/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.data.i2cp;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Date;
import java.util.Map;
import java.util.Properties;
import net.i2p.I2PAppContext;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.SigType;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DataStructureImpl;
import net.i2p.data.Destination;
import net.i2p.data.Signature;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteArrayStream;
import net.i2p.util.Clock;
import net.i2p.util.Log;
import net.i2p.util.OrderedProperties;

public class SessionConfig
extends DataStructureImpl {
    private Destination _destination;
    private Signature _signature;
    private Date _creationDate;
    private Properties _options;
    public static final String PROP_OFFLINE_EXPIRATION = "i2cp.leaseSetOfflineExpiration";
    public static final String PROP_TRANSIENT_KEY = "i2cp.leaseSetTransientPublicKey";
    public static final String PROP_OFFLINE_SIGNATURE = "i2cp.leaseSetOfflineSignature";
    private static final long OFFSET_VALIDITY = 180000L;

    public SessionConfig() {
        this(null);
    }

    public SessionConfig(Destination dest) {
        this._destination = dest;
        this._creationDate = new Date(Clock.getInstance().now());
    }

    public Destination getDestination() {
        return this._destination;
    }

    public Date getCreationDate() {
        return this._creationDate;
    }

    public void setCreationDate(Date date) {
        this._creationDate = date;
    }

    public Properties getOptions() {
        return this._options;
    }

    public void setOptions(Properties options) {
        this._options = options;
    }

    public Signature getSignature() {
        return this._signature;
    }

    public void setSignature(Signature sig) {
        this._signature = sig;
    }

    public void setOfflineSignature(long expires, SigningPublicKey transientSPK, Signature offlineSig) {
        if (this._options == null) {
            throw new IllegalStateException();
        }
        this._options.setProperty(PROP_OFFLINE_EXPIRATION, Long.toString(expires / 1000L));
        this._options.setProperty(PROP_TRANSIENT_KEY, transientSPK.getType().getCode() + ":" + transientSPK.toBase64());
        this._options.setProperty(PROP_OFFLINE_SIGNATURE, offlineSig.toBase64());
    }

    public long getOfflineExpiration() {
        if (this._options == null) {
            return 0L;
        }
        String s = this._options.getProperty(PROP_OFFLINE_EXPIRATION);
        if (s == null) {
            return 0L;
        }
        try {
            return Long.parseLong(s) * 1000L;
        }
        catch (NumberFormatException nfe) {
            return 0L;
        }
    }

    public SigningPublicKey getTransientSigningPublicKey() {
        SigType type;
        if (this._options == null || this._destination == null) {
            return null;
        }
        String s = this._options.getProperty(PROP_TRANSIENT_KEY);
        if (s == null) {
            return null;
        }
        int colon = s.indexOf(58);
        if (colon > 0) {
            String stype = s.substring(0, colon);
            type = SigType.parseSigType(stype);
            if (type == null) {
                return null;
            }
            s = s.substring(colon + 1);
        } else {
            type = SigType.DSA_SHA1;
        }
        SigningPublicKey rv = new SigningPublicKey(type);
        try {
            rv.fromBase64(s);
            return rv;
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public Signature getOfflineSignature() {
        if (this._options == null || this._destination == null) {
            return null;
        }
        String s = this._options.getProperty(PROP_OFFLINE_SIGNATURE);
        if (s == null) {
            return null;
        }
        Signature rv = new Signature(this._destination.getSigningPublicKey().getType());
        try {
            rv.fromBase64(s);
            return rv;
        }
        catch (DataFormatException dfe) {
            return null;
        }
    }

    public void signSessionConfig(SigningPrivateKey signingKey) throws DataFormatException {
        byte[] data = this.getBytes();
        if (data == null) {
            throw new DataFormatException("Unable to retrieve bytes for signing");
        }
        if (signingKey == null) {
            throw new DataFormatException("No Signing Key");
        }
        this._signature = DSAEngine.getInstance().sign(data, signingKey);
        if (this._signature == null) {
            throw new DataFormatException("Signature failed with " + (Object)((Object)signingKey.getType()) + " key");
        }
    }

    public boolean verifySignature() {
        Log log;
        boolean ok;
        if (this.getSignature() == null || this.getDestination() == null || this.getCreationDate() == null || this.tooOld()) {
            return false;
        }
        byte[] data = this.getBytes();
        if (data == null) {
            return false;
        }
        SigningPublicKey spk = this.getTransientSigningPublicKey();
        if (spk != null) {
            long expires = this.getOfflineExpiration();
            if (expires < this._creationDate.getTime()) {
                return false;
            }
            Signature sig = this.getOfflineSignature();
            if (sig == null) {
                return false;
            }
            ByteArrayStream baos = new ByteArrayStream(6 + spk.length());
            try {
                DataHelper.writeLong(baos, 4, expires / 1000L);
                DataHelper.writeLong(baos, 2, spk.getType().getCode());
                spk.writeBytes(baos);
            }
            catch (IOException ioe) {
                return false;
            }
            catch (DataFormatException dfe) {
                return false;
            }
            boolean ok2 = baos.verifySignature(sig, this._destination.getSigningPublicKey());
            if (!ok2) {
                return false;
            }
        } else {
            spk = this.getDestination().getSigningPublicKey();
        }
        if (!(ok = DSAEngine.getInstance().verifySignature(this.getSignature(), data, spk)) && (log = I2PAppContext.getGlobalContext().logManager().getLog(SessionConfig.class)).shouldWarn()) {
            log.warn("DSA signature failed!");
        }
        return ok;
    }

    public boolean tooOld() {
        long now = Clock.getInstance().now();
        long earliestValid = now - 180000L;
        long latestValid = now + 180000L;
        return this._creationDate == null || this._creationDate.getTime() < earliestValid || this._creationDate.getTime() > latestValid;
    }

    private byte[] getBytes() {
        if (this._destination == null || this._options == null || this._creationDate == null) {
            return null;
        }
        ByteArrayOutputStream out = new ByteArrayOutputStream(1024);
        try {
            this._destination.writeBytes(out);
            DataHelper.writeProperties(out, this._options, true);
            DataHelper.writeDate(out, this._creationDate);
        }
        catch (IOException ioe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SessionConfig.class);
            log.error("IOError signing", ioe);
            return null;
        }
        catch (DataFormatException dfe) {
            Log log = I2PAppContext.getGlobalContext().logManager().getLog(SessionConfig.class);
            log.error("Error writing out the bytes for signing/verification", dfe);
            return null;
        }
        return out.toByteArray();
    }

    @Override
    public void readBytes(InputStream rawConfig) throws DataFormatException, IOException {
        this._destination = Destination.create(rawConfig);
        this._options = DataHelper.readProperties(rawConfig);
        this._creationDate = DataHelper.readDate(rawConfig);
        SigningPublicKey spk = this.getTransientSigningPublicKey();
        if (spk == null) {
            spk = this._destination.getSigningPublicKey();
        }
        this._signature = new Signature(spk.getType());
        this._signature.readBytes(rawConfig);
    }

    @Override
    public void writeBytes(OutputStream out) throws DataFormatException, IOException {
        if (this._destination == null || this._options == null || this._signature == null || this._creationDate == null) {
            throw new DataFormatException("Not enough data to create the session config");
        }
        this._destination.writeBytes(out);
        DataHelper.writeProperties(out, this._options, true);
        DataHelper.writeDate(out, this._creationDate);
        this._signature.writeBytes(out);
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof SessionConfig) {
            SessionConfig cfg = (SessionConfig)object;
            return DataHelper.eq(this.getSignature(), cfg.getSignature()) && DataHelper.eq(this.getDestination(), cfg.getDestination()) && DataHelper.eq(this.getCreationDate(), cfg.getCreationDate()) && DataHelper.eq(this.getOptions(), cfg.getOptions());
        }
        return false;
    }

    public int hashCode() {
        return this._signature != null ? this._signature.hashCode() : 0;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder("SessionConfig: ");
        buf.append("\n* Destination: ").append(this.getDestination()).append("\n* Signature: ").append(this.getSignature()).append("\n* Creation Date: ").append(this.getCreationDate()).append("\n* Options (").append(this._options.size()).append(")");
        OrderedProperties sorted = new OrderedProperties();
        sorted.putAll((Map<?, ?>)this._options);
        for (Map.Entry<Object, Object> e : ((Properties)sorted).entrySet()) {
            String key = (String)e.getKey();
            String val = (String)e.getValue();
            buf.append("\n\t\t[").append(key).append("] = [").append(val).append("]");
        }
        return buf.toString();
    }
}

