/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.util;

import gnu.getopt.Getopt;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import net.i2p.I2PAppContext;
import net.i2p.util.EepGet;
import net.i2p.util.SocketTimeout;

public class EepHead
extends EepGet {
    private static final OutputStream _dummyStream = new ByteArrayOutputStream(0);

    public EepHead(I2PAppContext ctx, String proxyHost, int proxyPort, int numRetries, String url) {
        super(ctx, true, proxyHost, proxyPort, numRetries, -1L, -1L, null, _dummyStream, url, true, null, null);
    }

    public static void main(String[] args) {
        String proxyHost = "127.0.0.1";
        int proxyPort = 4444;
        int numRetries = 1;
        int inactivityTimeout = 10000;
        String username = null;
        String password = null;
        boolean error = false;
        Getopt g = new Getopt("eephead", args, "p:cn:t:u:x:");
        try {
            int c;
            block12: while ((c = g.getopt()) != -1) {
                switch (c) {
                    case 112: {
                        String s = g.getOptarg();
                        int colon = s.indexOf(58);
                        if (colon >= 0) {
                            proxyHost = s.substring(0, colon);
                            String port = s.substring(colon + 1);
                            proxyPort = Integer.parseInt(port);
                            continue block12;
                        }
                        proxyHost = s;
                        continue block12;
                    }
                    case 99: {
                        proxyHost = "";
                        proxyPort = 0;
                        continue block12;
                    }
                    case 110: {
                        numRetries = Integer.parseInt(g.getOptarg());
                        continue block12;
                    }
                    case 116: {
                        inactivityTimeout = 1000 * Integer.parseInt(g.getOptarg());
                        continue block12;
                    }
                    case 117: {
                        username = g.getOptarg();
                        continue block12;
                    }
                    case 120: {
                        password = g.getOptarg();
                        continue block12;
                    }
                }
                error = true;
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            error = true;
        }
        if (error || args.length - g.getOptind() != 1) {
            System.out.println(EepHead.usage());
            System.exit(1);
        }
        String url = args[g.getOptind()];
        EepHead get = new EepHead(I2PAppContext.getGlobalContext(), proxyHost, proxyPort, numRetries, url);
        if (username != null) {
            if (password == null) {
                try {
                    BufferedReader r = new BufferedReader(new InputStreamReader(System.in));
                    do {
                        System.err.print("Proxy password: ");
                        password = r.readLine();
                        if (password != null) continue;
                        throw new IOException();
                    } while ((password = password.trim()).length() <= 0);
                }
                catch (IOException ioe) {
                    System.exit(1);
                }
            }
            get.addAuthorization(username, password);
        }
        if (get.fetch(10000L, -1L, inactivityTimeout)) {
            System.out.println(" \u2022 URL: " + url);
            String x = get.getServer();
            String cc = get.getCacheControl();
            String ar = get.getAcceptRanges();
            String lm = get.getLastModified();
            String et = get.getEtag();
            String cl = String.valueOf(get.getContentLength());
            String xf = get.getXframeOptions();
            String cto = get.getXContentTypeOptions();
            String st = get.getStatus().toString();
            if (x != null) {
                System.out.println(" \u2022 Server: " + x);
            } else if (cc != null && (cc.equals("max-age=3600,public") || cc.equals("no-cache, private, max-age=2628000"))) {
                System.out.println(" \u2022 Server: Jetty (?)");
            } else if (cc == null && cl != null && cl.equals("217") && lm != null && ar != null && ar.equals("bytes") && et == null) {
                System.out.println(" \u2022 Server: Jetty (ZZZOT)");
            } else if (cc == null && xf != null && xf.equals("DENY") && cto != null && cto.equals("nosniff") && st != null && st.equals("200")) {
                System.out.println(" \u2022 Server: Jetty (?)");
            } else if (ar != null && ar.equals("bytes") && lm != null && et != null) {
                System.out.println(" \u2022 Server: nginx (?)");
            } else {
                System.out.println(" \u2022 Server: unknown");
            }
            x = get.getXPoweredBy();
            if (x != null) {
                System.out.println(" \u2022 X-Powered-By: " + x);
            }
            if (st != null) {
                System.out.println(" \u2022 Status: " + st);
            }
            if ((x = get.getContentType()) != null) {
                System.out.println(" \u2022 Content-Type: " + x);
            }
            System.out.println(" \u2022 Content-Length: " + cl);
            x = get.getTransferEncoding();
            if (x != null) {
                System.out.println(" \u2022 Transfer-Encoding: " + x);
            }
            if ((x = get.getContentEncoding()) != null) {
                System.out.println(" \u2022 Content-Encoding: " + x);
            }
            if ((x = get.getContentLanguage()) != null && !x.equals("")) {
                System.out.println(" \u2022 Content-Language: " + x);
            }
            if (lm != null) {
                System.out.println(" \u2022 Last-Modified: " + lm);
            }
            if (et != null) {
                System.out.println(" \u2022 Etag: " + et);
            }
            if (cc != null) {
                System.out.println(" \u2022 Cache-Control: " + cc);
            }
            if (ar != null) {
                System.out.println(" \u2022 Accept-Ranges: " + ar);
            }
            if ((x = get.getVary()) != null) {
                System.out.println(" \u2022 Vary: " + x);
            }
            if ((x = get.getExpiryDate()) != null) {
                System.out.println(" \u2022 Expires: " + x);
            }
            if ((x = get.getCookie()) != null) {
                System.out.println(" \u2022 Set-Cookie: " + x);
            }
            if ((x = get.getReferrerPolicy()) != null) {
                System.out.println(" \u2022 Referrer-Policy: " + x);
            }
            if (cto != null) {
                System.out.println(" \u2022 X-Content-Type-Options: " + cto);
            }
            if (xf != null) {
                System.out.println(" \u2022 X-FrameOptions: " + xf);
            }
            if ((x = get.getCSP()) != null) {
                System.out.println(" \u2022 Content-Security-Policy: " + x);
            }
            if ((x = get.getXSSProtection()) != null) {
                System.out.println(" \u2022 X-XSS-Protection: " + x);
            }
        } else {
            System.out.println(" \u2716 No response from: " + url);
            System.exit(1);
        }
    }

    private static String usage() {
        return "Usage:\n  eephead [opts] <url>   request server headers for url\n\nOptions:\n  -c               do not use proxy\n  -n <value>       number of retries (default 1)\n  -p <host:port>   use alternative proxy (default is 127.0.0.1:4444)\n  -t <value>       timeout in seconds (default 10)\n  -u <value>       proxy username\n  -x <value>       proxy password\n";
    }

    @Override
    protected void doFetch(SocketTimeout timeout) throws IOException {
        this._aborted = false;
        this.readHeaders();
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP headers");
        }
        if (timeout != null) {
            timeout.resetTimer();
            if (this._fetchInactivityTimeout > 0) {
                timeout.setInactivityTimeout(this._fetchInactivityTimeout);
            } else {
                timeout.setInactivityTimeout(120000L);
            }
        }
        if (this._redirectLocation != null) {
            try {
                if (this._redirectLocation.startsWith("http://")) {
                    this._actualURL = this._redirectLocation;
                } else {
                    URI url = new URI(this._actualURL);
                    String host = url.getHost();
                    if (host == null) {
                        throw new MalformedURLException("Redirected to invalid URL");
                    }
                    int port = url.getPort();
                    if (port < 0) {
                        port = 80;
                    }
                    this._actualURL = this._redirectLocation.startsWith("/") ? "http://" + host + ":" + port + this._redirectLocation : "http://" + host + ":" + port + "/" + this._redirectLocation;
                }
            }
            catch (URISyntaxException use) {
                MalformedURLException ioe = new MalformedURLException("Redirected to invalid URL");
                ioe.initCause(use);
                throw ioe;
            }
            EepGet.AuthState as = this._authState;
            if (this._responseCode == 407) {
                if (!this._shouldProxy) {
                    throw new IOException("Proxy auth response from non-proxy");
                }
                if (as == null) {
                    throw new IOException("Proxy requires authentication");
                }
                if (as.authSent) {
                    throw new IOException("Proxy authentication failed");
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Adding auth");
                }
            } else {
                ++this._redirects;
                if (this._redirects > 5) {
                    throw new IOException("Too many redirects: to " + this._redirectLocation);
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Redirecting to " + this._redirectLocation);
                }
                if (as != null) {
                    as.authSent = false;
                }
            }
            this._bytesRemaining = -1L;
            this._redirectLocation = null;
            this._etag = null;
            this._lastModified = null;
            this._contentType = null;
            this._encodingChunked = false;
            this.sendRequest(timeout);
            this.doFetch(timeout);
            return;
        }
        if (timeout != null) {
            timeout.cancel();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Headers read completely");
        }
        if (this._out != null) {
            this._out.close();
        }
        this._out = null;
        if (this._aborted) {
            throw new IOException("Timed out reading the HTTP data");
        }
        if (this._transferFailed) {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).attemptFailed(this._url, 0L, 0L, this._currentAttempt, this._numRetries, new Exception("Attempt failed"));
            }
        } else {
            for (int i = 0; i < this._listeners.size(); ++i) {
                ((EepGet.StatusListener)this._listeners.get(i)).transferComplete(0L, 0L, 0L, this._url, "dummy", false);
            }
        }
    }

    @Override
    protected boolean shouldReadBody() {
        return false;
    }

    @Override
    protected String getRequest() throws IOException {
        String urlToSend;
        URI url;
        StringBuilder buf = new StringBuilder(512);
        try {
            url = new URI(this._actualURL);
        }
        catch (URISyntaxException use) {
            MalformedURLException ioe = new MalformedURLException("Invalid URL");
            ioe.initCause(use);
            throw ioe;
        }
        String host = url.getHost();
        if (host == null) {
            throw new MalformedURLException("Invalid URL");
        }
        int port = url.getPort();
        String path = url.getRawPath();
        String query = url.getRawQuery();
        if (this._log.shouldDebug()) {
            this._log.debug("Requesting headers for:" + this._actualURL);
        }
        if (this._shouldProxy) {
            urlToSend = this._actualURL;
            if (!(path != null && path.length() > 0 || query != null && query.length() > 0)) {
                urlToSend = urlToSend + "/";
            }
        } else {
            urlToSend = path;
            if (urlToSend == null || urlToSend.length() <= 0) {
                urlToSend = "/";
            }
            if (query != null) {
                urlToSend = urlToSend + '?' + query;
            }
        }
        buf.append("HEAD ").append(urlToSend).append(" HTTP/1.1\r\n");
        buf.append("Host: ").append(host);
        if (port >= 0) {
            buf.append(':').append(port);
        }
        buf.append("\r\n");
        buf.append("Accept-Encoding: \r\n");
        buf.append("User-Agent: Wget/1.11.4\r\n");
        if (this._authState != null && this._shouldProxy && this._authState.authMode != EepGet.AUTH_MODE.NONE) {
            buf.append("Proxy-Authorization: ");
            buf.append(this._authState.getAuthHeader("HEAD", urlToSend));
            buf.append("\r\n");
        }
        buf.append("Connection: close\r\n\r\n");
        if (this._log.shouldDebug()) {
            this._log.debug("Request: [" + buf.toString() + "]");
        }
        return buf.toString();
    }

    public long getContentLength() {
        return this._bytesRemaining;
    }
}

