/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.MessageOutputStream;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.data.DataHelper;
import net.i2p.util.Log;

class ConnectionDataReceiver
implements MessageOutputStream.DataReceiver {
    private final I2PAppContext _context;
    private final Log _log;
    private final Connection _connection;
    private static final MessageOutputStream.WriteStatus _dummyStatus = new DummyStatus();

    public ConnectionDataReceiver(I2PAppContext ctx, Connection con) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(ConnectionDataReceiver.class);
        this._connection = con;
    }

    @Override
    public boolean writeInProcess() {
        return this._connection.getUnackedPacketsSent() >= this._connection.getOptions().getWindowSize();
    }

    @Override
    public MessageOutputStream.WriteStatus writeData(byte[] buf, int off, int size) {
        Connection con = this._connection;
        boolean doSend = true;
        if (size <= 0 && con.getLastSendId() >= 0L) {
            doSend = con.getOutputStream().getClosed() ? con.getCloseSentOn() <= 0L : false;
        }
        if (con.getUnackedPacketsReceived() > 0) {
            doSend = true;
        }
        if (this._log.shouldInfo() && !doSend) {
            this._log.info("writeData called: size=" + size + " doSend=" + doSend + " unackedReceived: " + con.getUnackedPacketsReceived() + " con: " + con);
        }
        if (doSend) {
            PacketLocal packet = this.send(buf, off, size);
            if (packet.getSequenceNum() > 0L || packet.isFlagSet(1)) {
                return packet;
            }
            return _dummyStatus;
        }
        return _dummyStatus;
    }

    public PacketLocal send(byte[] buf, int off, int size) {
        return this.send(buf, off, size, false);
    }

    public PacketLocal send(byte[] buf, int off, int size, boolean forceIncrement) {
        PacketLocal packet = this.buildPacket(buf, off, size, forceIncrement);
        this._connection.sendPacket(packet);
        return packet;
    }

    private boolean isAckOnly(int size) {
        boolean ackOnly = size <= 0 && this._connection.getLastSendId() >= 0L && (!this._connection.getOutputStream().getClosed() || this._connection.getCloseSentOn() > 0L);
        return ackOnly;
    }

    private PacketLocal buildPacket(byte[] buf, int off, int size, boolean forceIncrement) {
        if (size > 32768) {
            throw new IllegalArgumentException("size is too large (" + size + ")");
        }
        boolean ackOnly = this.isAckOnly(size);
        boolean isFirst = this._connection.getAckedPackets() <= 0L && this._connection.getUnackedPacketsSent() <= 0;
        PacketLocal packet = new PacketLocal(this._context, this._connection.getRemotePeer(), this._connection);
        ByteArray data = new ByteArray(new byte[size]);
        if (size > 0) {
            System.arraycopy(buf, off, data.getData(), 0, size);
        }
        data.setValid(size);
        data.setOffset(0);
        packet.setPayload(data);
        if (ackOnly && !forceIncrement && !isFirst) {
            packet.setSequenceNum(0L);
        } else {
            packet.setSequenceNum(this._connection.getNextOutboundPacketNum());
        }
        packet.setSendStreamId(this._connection.getSendStreamId());
        packet.setReceiveStreamId(this._connection.getReceiveStreamId());
        packet.setResendDelay(this._connection.getOptions().getResendDelay() / 1000);
        if (isFirst) {
            packet.setFlag(1);
            packet.setOptionalFrom();
            packet.setOptionalMaxSize(this._connection.getOptions().getMaxMessageSize());
            if (!this._connection.isInbound()) {
                byte[] h = this._connection.getRemotePeer().calculateHash().getData();
                long[] fakeNacks = new long[8];
                for (int i = 0; i < 8; ++i) {
                    fakeNacks[i] = DataHelper.fromLong((byte[])h, (int)(i << 2), (int)4);
                }
                packet.setNacks(fakeNacks);
            }
        }
        packet.setLocalPort(this._connection.getLocalPort());
        packet.setRemotePort(this._connection.getPort());
        if (this._connection.getSendStreamId() == 0L) {
            packet.setFlag(1024);
        }
        if (this._connection.getOutputStream().getClosed() && (size > 0 || this._connection.getUnackedPacketsSent() <= 0 || packet.getSequenceNum() > 0L)) {
            packet.setFlag(2);
            this._connection.notifyCloseSent();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("New Outbound packet (ACKs not yet filled in): " + packet + " on " + this._connection);
        }
        return packet;
    }

    void destroy() {
    }

    private static final class DummyStatus
    implements MessageOutputStream.WriteStatus {
        private DummyStatus() {
        }

        @Override
        public final void waitForAccept(int maxWaitMs) {
        }

        @Override
        public final void waitForCompletion(int maxWaitMs) {
        }

        @Override
        public final boolean writeAccepted() {
            return true;
        }

        @Override
        public final boolean writeFailed() {
            return false;
        }

        @Override
        public final boolean writeSuccessful() {
            return true;
        }
    }
}

