/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import net.i2p.I2PAppContext;
import net.i2p.data.ByteArray;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;

class MessageOutputStream
extends OutputStream {
    private final I2PAppContext _context;
    private final Log _log;
    private byte[] _buf;
    private int _valid;
    private final Object _dataLock;
    private final DataReceiver _dataReceiver;
    private final AtomicReference<IOException> _streamError = new AtomicReference();
    private final AtomicBoolean _closed = new AtomicBoolean();
    private long _written;
    private int _writeTimeout;
    private final ByteCache _dataCache;
    private final int _originalBufferSize;
    private int _currentBufferSize;
    private final Flusher _flusher;
    private volatile long _lastBuffered;
    private final int _passiveFlushDelay;
    private volatile int _nextBufferSize;
    private static final int DEFAULT_PASSIVE_FLUSH_DELAY = SystemVersion.isSlow() ? 160 : 80;
    private static final String PROP_PASSIVE_FLUSH_DELAY = "router.passiveFlushDelay";

    public MessageOutputStream(I2PAppContext ctx, SimpleTimer2 timer, DataReceiver receiver, int bufSize, int initBufSize) {
        this(ctx, timer, receiver, bufSize, initBufSize, DEFAULT_PASSIVE_FLUSH_DELAY);
    }

    public MessageOutputStream(I2PAppContext ctx, SimpleTimer2 timer, DataReceiver receiver, int bufSize, int initBufSize, int passiveFlushDelay) {
        if (bufSize < 1730) {
            bufSize = 1730;
        } else if (bufSize > 1730 && bufSize < 1812) {
            bufSize = 1812;
        }
        this._dataCache = ByteCache.getInstance((int)128, (int)bufSize);
        this._originalBufferSize = bufSize;
        this._currentBufferSize = initBufSize;
        this._context = ctx;
        this._log = ctx.logManager().getLog(MessageOutputStream.class);
        this._buf = ((ByteArray)this._dataCache.acquire()).getData();
        this._dataReceiver = receiver;
        this._dataLock = new Object();
        this._writeTimeout = -1;
        this._passiveFlushDelay = passiveFlushDelay;
        this._flusher = new Flusher(timer);
    }

    public void setWriteTimeout(int ms) {
        if (this._log.shouldDebug()) {
            this._log.debug("Changing write timeout from " + this._writeTimeout + " to " + ms);
        }
        this._writeTimeout = ms;
    }

    public int getWriteTimeout() {
        return this._writeTimeout;
    }

    public void setBufferSize(int size) {
        if (size <= 0 || size > this._originalBufferSize) {
            return;
        }
        this._nextBufferSize = size;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.write(b, 0, b.length);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        long elapsed;
        long begin;
        if (this._closed.get()) {
            throw new IOException("Output stream closed");
        }
        if (this._log.shouldDebug()) {
            this._log.debug("write(b[], " + off + ", " + len + ") ");
        }
        int cur = off;
        int remaining = len;
        long l = begin = this._log.shouldDebug() ? this._context.clock().now() : 0L;
        while (remaining > 0) {
            WriteStatus ws = null;
            if (this._closed.get()) {
                throw new IOException("Output stream closed");
            }
            Object object = this._dataLock;
            synchronized (object) {
                int maxBuffer;
                int n = maxBuffer = this._valid == 0 ? this.locked_updateBufferSize() : this._currentBufferSize;
                if (this._buf == null) {
                    throw new IOException("Output stream closed");
                }
                if (this._valid + remaining < maxBuffer) {
                    System.arraycopy(b, cur, this._buf, this._valid, remaining);
                    this._valid += remaining;
                    cur += remaining;
                    this._written += (long)remaining;
                    remaining = 0;
                    this._lastBuffered = this._context.clock().now();
                    if (this._passiveFlushDelay > 0) {
                        this._flusher.enqueue();
                    }
                } else {
                    int toWrite = maxBuffer - this._valid;
                    System.arraycopy(b, cur, this._buf, this._valid, toWrite);
                    remaining -= toWrite;
                    cur += toWrite;
                    this._valid = maxBuffer;
                    if (this._log.shouldDebug()) {
                        this._log.debug("write() direct valid = " + this._valid);
                    }
                    ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
                    this._written += (long)this._valid;
                    this._valid = 0;
                    this.throwAnyError();
                }
            }
            if (ws != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Waiting " + this._writeTimeout + "ms for accept of " + ws);
                }
                try {
                    ws.waitForAccept(this._writeTimeout);
                }
                catch (InterruptedException ie) {
                    InterruptedIOException ioe2 = new InterruptedIOException("Interrupted write");
                    ioe2.initCause(ie);
                    throw ioe2;
                }
                if (!ws.writeAccepted()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Write not accepted of " + ws);
                    }
                    if (this._writeTimeout > 0) {
                        throw new InterruptedIOException("Write not accepted within timeout" + (!ws.toString().equals("") ? ": " + ws : ""));
                    }
                    throw new IOException("Write not accepted into the queue" + (!ws.toString().equals("") ? ": " + ws : ""));
                }
                if (!this._log.shouldInfo()) continue;
                this._log.info("After waitForAccept of " + ws);
                continue;
            }
            if (!this._log.shouldDebug()) continue;
            this._log.debug("Queued " + len + " bytes without sending to the receiver");
        }
        if (this._log.shouldDebug() && (elapsed = this._context.clock().now() - begin) > 10000L) {
            this._log.debug("Took " + elapsed + "ms to write to the stream?", (Throwable)new Exception("foo"));
        }
        this.throwAnyError();
    }

    @Override
    public void write(int b) throws IOException {
        this.write(new byte[]{(byte)b}, 0, 1);
        this.throwAnyError();
    }

    private final int locked_updateBufferSize() {
        int size = this._nextBufferSize;
        if (size > 0) {
            this._currentBufferSize = size;
            this._nextBufferSize = 0;
        }
        return this._currentBufferSize;
    }

    @Override
    public void flush() throws IOException {
        this.flush(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void flush(boolean wait_for_accept_only) throws IOException {
        long elapsed;
        long begin = this._log.shouldDebug() ? this._context.clock().now() : 0L;
        WriteStatus ws = null;
        if (this._log.shouldDebug() && this._valid > 0) {
            this._log.debug("flush() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf == null) {
                this._dataLock.notifyAll();
                throw new IOException("Output stream closed");
            }
            if (!wait_for_accept_only) {
                ws = this._dataReceiver.writeData(this._buf, 0, this._valid);
                this._written += (long)this._valid;
                this._valid = 0;
                this._dataLock.notifyAll();
            }
        }
        if (wait_for_accept_only) {
            this.flushAvailable(this._dataReceiver, true);
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("before waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        try {
            if (this._closed.get() && (this._writeTimeout > 300000 || this._writeTimeout <= 0)) {
                ws.waitForCompletion(300000);
            } else if (this._writeTimeout <= 0 || this._writeTimeout > 300000) {
                ws.waitForCompletion(300000);
            } else {
                ws.waitForCompletion(this._writeTimeout);
            }
        }
        catch (InterruptedException ie) {
            InterruptedIOException ioe2 = new InterruptedIOException("Interrupted flush");
            ioe2.initCause(ie);
            throw ioe2;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("After waiting " + this._writeTimeout + "ms for completion of " + ws);
        }
        if (ws.writeFailed() && this._writeTimeout > 0) {
            throw new InterruptedIOException("Timed out during write");
        }
        if (ws.writeFailed()) {
            throw new IOException("Write failed");
        }
        if (this._log.shouldDebug() && (elapsed = this._context.clock().now() - begin) > 10000L) {
            this._log.debug("Took " + elapsed + "ms to flush the stream?\n" + ws, (Throwable)new Exception("bar"));
        }
        this.throwAnyError();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        if (!this._closed.compareAndSet(false, true)) {
            Object object = this._dataLock;
            synchronized (object) {
                this._dataLock.notifyAll();
            }
            this._log.logCloseLoop(new Object[]{"MOS"});
            return;
        }
        this._flusher.cancel();
        this.flush(false);
        if (this._log.shouldDebug()) {
            this._log.debug("Output stream closed after writing " + this._written);
        }
        ByteArray ba = null;
        Object object = this._dataLock;
        synchronized (object) {
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
            }
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public void closeInternal() {
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"close internal"});
            return;
        }
        this._flusher.cancel();
        this._streamError.compareAndSet(null, new IOException("Output stream closed"));
        this.clearData(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearData(boolean shouldFlush) {
        ByteArray ba = null;
        if (this._log.shouldDebug() && this._valid > 0) {
            this._log.debug("clearData() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            if (this._valid > 0 && shouldFlush) {
                this._dataReceiver.writeData(this._buf, 0, this._valid);
            }
            this._written += (long)this._valid;
            this._valid = 0;
            if (this._buf != null) {
                ba = new ByteArray(this._buf);
                this._buf = null;
                this._valid = 0;
            }
            this._dataLock.notifyAll();
        }
        if (ba != null) {
            this._dataCache.release(ba);
        }
    }

    public boolean getClosed() {
        return this._closed.get();
    }

    private void throwAnyError() throws IOException {
        IOException ioe = this._streamError.getAndSet(null);
        if (ioe != null) {
            IOException ioe2 = new IOException("Output stream error");
            ioe2.initCause(ioe);
            throw ioe2;
        }
    }

    void streamErrorOccurred(IOException ioe) {
        this._streamError.compareAndSet(null, ioe);
        this.clearData(false);
    }

    void flushAvailable(DataReceiver target) throws IOException {
        this.flushAvailable(target, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void flushAvailable(DataReceiver target, boolean blocking) throws IOException {
        long afterAccept;
        WriteStatus ws = null;
        long before = System.currentTimeMillis();
        if (this._log.shouldDebug() && this._valid > 0) {
            this._log.debug("flushAvailable() valid = " + this._valid);
        }
        Object object = this._dataLock;
        synchronized (object) {
            ws = target.writeData(this._buf, 0, this._valid);
            this._written += (long)this._valid;
            this._valid = 0;
            this._dataLock.notifyAll();
        }
        long afterBuild = System.currentTimeMillis();
        if (afterBuild - before > 1000L && this._log.shouldDebug()) {
            this._log.debug("Took " + (afterBuild - before) + "ms to build a packet?  " + ws);
        }
        if (blocking && ws != null) {
            try {
                ws.waitForAccept(this._writeTimeout);
            }
            catch (InterruptedException ie) {
                InterruptedIOException ioe2 = new InterruptedIOException("Interrupted flush");
                ioe2.initCause(ie);
                throw ioe2;
            }
            if (ws.writeFailed()) {
                throw new IOException("Flush available failed");
            }
            if (!ws.writeAccepted()) {
                throw new InterruptedIOException("Flush available timed out (" + this._writeTimeout + "ms)");
            }
        }
        if ((afterAccept = System.currentTimeMillis()) - afterBuild > 1000L && this._log.shouldDebug()) {
            this._log.debug("Took " + (afterAccept - afterBuild) + "ms to accept a packet? " + ws);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void destroy() {
        if (!this._closed.compareAndSet(false, true)) {
            this._log.logCloseLoop(new Object[]{"destroy()"});
            return;
        }
        this._flusher.cancel();
        Object object = this._dataLock;
        synchronized (object) {
            this._dataLock.notifyAll();
        }
    }

    public static interface WriteStatus {
        public void waitForCompletion(int var1) throws IOException, InterruptedException;

        public void waitForAccept(int var1) throws IOException, InterruptedException;

        public boolean writeAccepted();

        public boolean writeFailed();

        public boolean writeSuccessful();
    }

    public static interface DataReceiver {
        public WriteStatus writeData(byte[] var1, int var2, int var3);

        public boolean writeInProcess();
    }

    private class Flusher
    extends SimpleTimer2.TimedEvent {
        private boolean _enqueued;

        public Flusher(SimpleTimer2 timer) {
            super(timer);
        }

        public void enqueue() {
            int pfd = MessageOutputStream.this._context.getProperty(MessageOutputStream.PROP_PASSIVE_FLUSH_DELAY, DEFAULT_PASSIVE_FLUSH_DELAY);
            if (!this._enqueued) {
                this.forceReschedule(pfd);
                if (MessageOutputStream.this._log.shouldDebug()) {
                    MessageOutputStream.this._log.debug("Rescheduling the flusher to run in " + pfd + "ms");
                }
                this._enqueued = true;
            } else if (MessageOutputStream.this._log.shouldDebug()) {
                MessageOutputStream.this._log.debug("NOT rescheduling the flusher");
            }
        }

        public void timeReached() {
            if (MessageOutputStream.this._closed.get()) {
                return;
            }
            this._enqueued = false;
            long timeLeft = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay - MessageOutputStream.this._context.clock().now();
            if (MessageOutputStream.this._log.shouldDebug()) {
                MessageOutputStream.this._log.debug("Flusher time reached with " + timeLeft + "ms remaining");
            }
            if (timeLeft > 0L) {
                this.enqueue();
            } else if (MessageOutputStream.this._dataReceiver.writeInProcess()) {
                this.enqueue();
            } else {
                this.doFlush();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFlush() {
            boolean sent = false;
            WriteStatus ws = null;
            Object object = MessageOutputStream.this._dataLock;
            synchronized (object) {
                long flushTime = MessageOutputStream.this._lastBuffered + (long)MessageOutputStream.this._passiveFlushDelay;
                if (MessageOutputStream.this._valid > 0 && flushTime <= MessageOutputStream.this._context.clock().now()) {
                    if (MessageOutputStream.this._log.shouldDebug()) {
                        MessageOutputStream.this._log.debug("doFlush() valid = " + MessageOutputStream.this._valid);
                    }
                    if (MessageOutputStream.this._buf != null) {
                        ws = MessageOutputStream.this._dataReceiver.writeData(MessageOutputStream.this._buf, 0, MessageOutputStream.this._valid);
                        MessageOutputStream.this._written = MessageOutputStream.this._written + (long)MessageOutputStream.this._valid;
                        MessageOutputStream.this._valid = 0;
                        MessageOutputStream.this._dataLock.notifyAll();
                        sent = true;
                    }
                } else if (MessageOutputStream.this._log.shouldInfo() && MessageOutputStream.this._valid > 0) {
                    MessageOutputStream.this._log.info("doFlush() rejected... valid = " + MessageOutputStream.this._valid);
                }
            }
            if (sent && MessageOutputStream.this._log.shouldDebug()) {
                MessageOutputStream.this._log.debug("Passive flush of " + ws);
            }
        }
    }
}

