/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import net.i2p.I2PAppContext;
import net.i2p.I2PException;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.ConnectionManager;
import net.i2p.client.streaming.impl.I2PSocketManagerFull;
import net.i2p.client.streaming.impl.Packet;
import net.i2p.client.streaming.impl.PacketLocal;
import net.i2p.data.ByteArray;
import net.i2p.data.Destination;
import net.i2p.data.SigningPublicKey;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class PacketHandler {
    private final ConnectionManager _manager;
    private final I2PAppContext _context;
    private final Log _log;
    private final ByteCache _cache = ByteCache.getInstance((int)32, (int)4096);
    private static final SimpleDateFormat _fmt = new SimpleDateFormat("HH:mm:ss.SSS");

    public PacketHandler(I2PAppContext ctx, ConnectionManager mgr) {
        this._manager = mgr;
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
    }

    void receivePacket(Packet packet) {
        this.receivePacketDirect(packet, true);
    }

    void receivePacketDirect(Packet packet, boolean queueIfNoConn) {
        Connection con;
        long sendId = packet.getSendStreamId();
        Connection connection = con = sendId > 0L ? this._manager.getConnectionByInboundId(sendId) : null;
        if (con != null) {
            if (this._log.shouldDebug()) {
                this.displayPacket(packet, "RECV", "WSIZE " + con.getOptions().getWindowSize() + "; RTO " + con.getOptions().getRTO());
            }
            this.receiveKnownCon(con, packet);
        } else {
            if (this._log.shouldDebug()) {
                this.displayPacket(packet, "UNKN", null);
            }
            this.receiveUnknownCon(packet, sendId, queueIfNoConn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void displayPacket(Packet packet, String prefix, String suffix) {
        StringBuilder buf = new StringBuilder(256);
        SimpleDateFormat simpleDateFormat = _fmt;
        synchronized (simpleDateFormat) {
            buf.append(_fmt.format(new Date()));
        }
        buf.append(": ").append(prefix).append(" ");
        buf.append(packet.toString());
        if (suffix != null) {
            buf.append(" ").append(suffix);
        }
        String str = buf.toString();
        this._log.debug(str);
    }

    private void receiveKnownCon(Connection con, Packet packet) {
        if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
            packet.logTCPDump(con);
        }
        if (packet.isFlagSet(512)) {
            if (packet.getSendStreamId() > 0L) {
                if (con.getOptions().getAnswerPings()) {
                    this.receivePing(con, packet);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Dropping ECHO packet on existing connection -> " + packet);
                }
            } else if (packet.getReceiveStreamId() > 0L) {
                this.receivePong(packet);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Received ECHO packet " + packet + " with no StreamIDs");
            }
            packet.releasePayload();
            return;
        }
        if (PacketHandler.isValidMatch(con.getSendStreamId(), packet.getReceiveStreamId())) {
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received FORGED packet for " + con, (Throwable)ie);
                }
            }
        } else if (packet.isFlagSet(4)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Received reset: " + packet);
            }
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received FORGED reset for " + con, (Throwable)ie);
                }
            }
        } else if (con.getSendStreamId() <= 0L || con.getSendStreamId() == packet.getReceiveStreamId() || packet.getSequenceNum() <= 1L) {
            long oldId = con.getSendStreamId();
            if (packet.isFlagSet(1)) {
                if (oldId <= 0L) {
                    con.setSendStreamId(packet.getReceiveStreamId());
                    SigningPublicKey spk = packet.getTransientSPK();
                    if (spk != null) {
                        con.setRemoteTransientSPK(spk);
                    }
                } else if (oldId != packet.getReceiveStreamId()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received SYN packet with wrong IDs: [" + con + "]\n* Packet: " + packet);
                    }
                    this.sendReset(packet);
                    packet.releasePayload();
                    return;
                }
            }
            try {
                con.getPacketHandler().receivePacket(packet, con);
            }
            catch (I2PException ie) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Sig verify fail for " + con + "/" + oldId + ": " + packet, (Throwable)ie);
                }
                if (packet.isFlagSet(1)) {
                    this.sendResetUnverified(packet);
                }
            }
        } else if (packet.isFlagSet(1)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received SYN packet " + packet + " with wrong IDs -> Sending RESET...");
            }
            this.sendReset(packet);
            packet.releasePayload();
        } else {
            if (!con.getResetSent() && this._log.shouldWarn()) {
                StringBuilder buf = new StringBuilder(512);
                buf.append("Received packet on the wrong stream: ");
                buf.append(packet);
                buf.append("\nthis connection:\n");
                buf.append(con);
                buf.append("\nall connections:");
                for (Connection cur : this._manager.listConnections()) {
                    buf.append('\n').append(cur);
                }
                this._log.warn(buf.toString(), (Throwable)new Exception("Wrong stream"));
            }
            packet.releasePayload();
        }
    }

    private void sendReset(Packet packet) {
        Destination from = packet.getOptionalFrom();
        if (from == null) {
            return;
        }
        ByteArray ba = (ByteArray)this._cache.acquire();
        boolean ok = packet.verifySignature(this._context, ba.getData());
        this._cache.release(ba);
        if (!ok) {
            if (this._log.shouldWarn()) {
                this._log.warn("Can't send reset after receiving spoofed packet " + packet);
            }
            return;
        }
        this.sendResetUnverified(packet);
    }

    private void sendResetUnverified(Packet packet) {
        PacketLocal reply = new PacketLocal(this._context, packet.getOptionalFrom(), packet.getSession());
        reply.setFlag(4);
        reply.setFlag(8);
        reply.setSendStreamId(packet.getReceiveStreamId());
        reply.setReceiveStreamId(packet.getSendStreamId());
        reply.setLocalPort(packet.getLocalPort());
        reply.setRemotePort(packet.getRemotePort());
        this._manager.getPacketQueue().enqueue(reply);
    }

    private void receiveUnknownCon(Packet packet, long sendId, boolean queueIfNoConn) {
        if (packet.isFlagSet(512)) {
            if (packet.getSendStreamId() > 0L) {
                if (this._manager.answerPings()) {
                    this.receivePing(null, packet);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Dropping ECHO packet on UNKNOWN connection -> " + packet);
                }
            } else if (packet.getReceiveStreamId() > 0L) {
                this.receivePong(packet);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Received ECHO packet " + packet + " without StreamIDs");
            }
            packet.releasePayload();
        } else {
            if (this._log.shouldInfo() && !packet.isFlagSet(1)) {
                this._log.info("Received packet on UNKNOWN stream (not ECHO / SYN) -> " + packet);
            }
            if (sendId <= 0L) {
                Connection con = this._manager.getConnectionByOutboundId(packet.getReceiveStreamId());
                if (con != null) {
                    if (con.getHighestAckedThrough() <= 5L && packet.getSequenceNum() <= 5L) {
                        if (this._log.shouldInfo()) {
                            this._log.info("Received additional packet without SendStreamID after the SYN -> " + packet + "\n* " + con);
                        }
                    } else if (this._log.shouldWarn()) {
                        this._log.warn("hrmph, received while ACK of SYN was in flight\n* " + con + ": " + packet + " ACKed: " + con.getAckedPackets());
                    }
                    this.receiveKnownCon(con, packet);
                    return;
                }
            } else {
                if (this._log.shouldWarn()) {
                    boolean recent = this._manager.wasRecentlyClosed(packet.getSendStreamId());
                    this._log.warn("Dropping packet " + packet + " with SendStreamID but no connection" + (recent ? " -> Recently disconnected" : ""));
                }
                packet.releasePayload();
                return;
            }
            if (packet.isFlagSet(1)) {
                this._manager.getConnectionHandler().receiveNewSyn(packet);
            } else if (queueIfNoConn) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Packet " + packet + " belongs to no other connections, putting on the SYN queue...");
                }
                if (this._log.shouldDebug()) {
                    StringBuilder buf = new StringBuilder(128);
                    for (Connection con : this._manager.listConnections()) {
                        buf.append(con.toString()).append(" ");
                    }
                    this._log.debug("Connections: " + buf.toString() + " SendID: " + (sendId > 0L ? Packet.toId(sendId) : " unknown"));
                }
                this._manager.getConnectionHandler().receiveNewSyn(packet);
            } else {
                if (I2PSocketManagerFull.pcapWriter != null && this._context.getBooleanProperty("i2p.streaming.pcap")) {
                    packet.logTCPDump(null);
                }
                this.sendReset(packet);
                packet.releasePayload();
            }
        }
    }

    private void receivePing(Connection con, Packet packet) {
        SigningPublicKey spk = con != null ? con.getRemoteSPK() : null;
        ByteArray ba = (ByteArray)this._cache.acquire();
        boolean ok = packet.verifySignature(this._context, spk, ba.getData());
        this._cache.release(ba);
        if (!ok) {
            if (this._log.shouldWarn()) {
                this._log.warn("BAD ping, sig verify failed -> Dropping " + packet);
            }
        } else {
            this._manager.receivePing(con, packet);
        }
    }

    private void receivePong(Packet packet) {
        this._manager.receivePong(packet.getReceiveStreamId(), packet.getPayload());
    }

    private static final boolean isValidMatch(long conStreamId, long packetStreamId) {
        return conStreamId == packetStreamId && conStreamId != 0L;
    }
}

