/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.regex.Pattern;
import net.i2p.I2PAppContext;
import net.i2p.addressbook.HostTxtIterator;
import net.i2p.addressbook.HostTxtParser;
import net.i2p.addressbook.Log;
import net.i2p.addressbook.Subscription;
import net.i2p.client.naming.HostTxtEntry;
import net.i2p.util.EepGet;
import net.i2p.util.SecureFile;

class AddressBook
implements Iterable<Map.Entry<String, HostTxtEntry>> {
    private final String location;
    private final Map<String, HostTxtEntry> addresses;
    private final File subFile;
    private boolean modified;
    private static final boolean DEBUG = false;
    private static final int MIN_DEST_LENGTH = 516;
    private static final int MAX_DEST_LENGTH = 616;
    private static final Pattern HOST_PATTERN = Pattern.compile("^[0-9a-zA-Z\\.-]{5,67}$");
    private static final Pattern B32_PATTERN = Pattern.compile("^[2-7a-zA-Z]{51}[aAqQ]$");
    private static final Pattern B64_PATTERN = Pattern.compile("^[0-9a-zA-Z~-]{516,616}={0,2}$");
    static final long MAX_SUB_SIZE = 0x500000L;

    public AddressBook(Map<String, HostTxtEntry> addresses) {
        this.addresses = addresses;
        this.subFile = null;
        this.location = null;
    }

    public AddressBook(Subscription subscription, String proxyHost, int proxyPort) {
        Map a = null;
        File subf = null;
        File tmp = null;
        try {
            EepGet get;
            tmp = SecureFile.createTempFile("addressbook", null, I2PAppContext.getGlobalContext().getTempDir());
            String loc = subscription.getLocation();
            String etag = subscription.getEtag();
            if (loc.startsWith("http://i2p-projekt.i2p/") && etag != null && etag.endsWith("-gzip\"")) {
                etag = etag.substring(0, etag.length() - 6) + '\"';
            }
            if ((get = new EepGet(I2PAppContext.getGlobalContext(), true, proxyHost, proxyPort, 10, -1L, 0x500000L, tmp.getAbsolutePath(), null, loc, true, etag, subscription.getLastModified(), null)).fetch()) {
                subscription.setEtag(get.getEtag());
                subscription.setLastModified(get.getLastModified());
                subscription.setLastFetched(I2PAppContext.getGlobalContext().clock().now());
                subf = tmp;
                System.out.println("[" + loc + "] Last modified: " + get.getLastModified());
            } else {
                a = Collections.emptyMap();
                tmp.delete();
            }
        }
        catch (IOException ioe) {
            if (tmp != null) {
                tmp.delete();
            }
            a = Collections.emptyMap();
        }
        this.addresses = a;
        this.subFile = subf;
        this.location = subscription.getLocation();
    }

    public AddressBook(File file) {
        Map<String, HostTxtEntry> a;
        this.location = file.toString();
        try {
            a = HostTxtParser.parse(file);
        }
        catch (IOException exp) {
            a = new HashMap<String, HostTxtEntry>();
        }
        this.addresses = a;
        this.subFile = null;
    }

    public AddressBook(String testsubfile) {
        this.location = testsubfile;
        this.addresses = null;
        this.subFile = new File(testsubfile);
    }

    @Override
    public Iterator<Map.Entry<String, HostTxtEntry>> iterator() {
        if (this.subFile != null) {
            try {
                return new HostTxtIterator(this.subFile);
            }
            catch (IOException ioe) {
                return new HostTxtIterator();
            }
        }
        return this.addresses.entrySet().iterator();
    }

    public void delete() {
        if (this.subFile != null) {
            this.subFile.delete();
        } else if (this.addresses != null) {
            try {
                this.addresses.clear();
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                // empty catch block
            }
        }
    }

    public String getLocation() {
        return this.location;
    }

    public String toString() {
        if (this.location != null) {
            return "Book from " + this.location;
        }
        return "Map containing " + this.addresses.size() + " entries";
    }

    public static boolean isValidKey(String host) {
        return !(!host.endsWith(".i2p") || host.length() <= 4 || host.length() > 67 || host.startsWith(".") || host.startsWith("-") || host.indexOf(".-") >= 0 || host.indexOf("-.") >= 0 || host.indexOf("..") >= 0 || host.indexOf("--") >= 0 && !host.startsWith("xn--") && host.indexOf(".xn--") <= 0 || !HOST_PATTERN.matcher(host).matches() || host.length() == 56 && B32_PATTERN.matcher(host.substring(0, 52)).matches() || host.equals("b32.i2p") || host.endsWith(".b32.i2p") || host.equals("proxy.i2p") || host.equals("router.i2p") || host.equals("console.i2p") || host.endsWith(".proxy.i2p") || host.endsWith(".router.i2p") || host.endsWith(".console.i2p"));
    }

    private static boolean isValidDest(String dest) {
        return (dest.length() == 516 && dest.endsWith("AA") || dest.length() > 516 && dest.length() <= 616) && dest.length() % 4 != 1 && B64_PATTERN.matcher(dest).matches();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void merge(AddressBook other, boolean overwrite, Log log) {
        if (this.addresses == null) {
            throw new IllegalStateException();
        }
        Iterator<Map.Entry<String, HostTxtEntry>> iter = other.iterator();
        try {
            this.merge2(other, iter, overwrite, log);
        }
        finally {
            if (iter instanceof HostTxtIterator) {
                ((HostTxtIterator)iter).close();
            }
        }
    }

    private void merge2(AddressBook other, Iterator<Map.Entry<String, HostTxtEntry>> iter, boolean overwrite, Log log) {
        while (iter.hasNext()) {
            Map.Entry<String, HostTxtEntry> entry = iter.next();
            String otherKey = entry.getKey();
            HostTxtEntry otherValue = entry.getValue();
            if (!AddressBook.isValidKey(otherKey) || !AddressBook.isValidDest(otherValue.getDest()) || this.addresses.containsKey(otherKey) && !overwrite || this.addresses.containsKey(otherKey) && this.addresses.get(otherKey).equals(otherValue)) continue;
            this.addresses.put(otherKey, otherValue);
            this.modified = true;
            if (log == null) continue;
            log.append("New domain " + otherKey + " [" + other.location + "]");
        }
    }

    public void write(File file) {
        if (this.addresses == null) {
            throw new IllegalStateException();
        }
        if (this.modified) {
            try {
                HostTxtParser.write(this.addresses, file);
            }
            catch (IOException exp) {
                System.err.println("Error writing addressbook " + file.getAbsolutePath() + " : " + exp.toString());
            }
        }
    }

    public void write() {
        if (this.location == null || this.location.startsWith("http://")) {
            throw new IllegalStateException();
        }
        this.write(new File(this.location));
    }
}

