/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.addressbook;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import net.i2p.I2PAppContext;
import net.i2p.addressbook.AddressBook;
import net.i2p.addressbook.ConfigParser;
import net.i2p.addressbook.HostTxtIterator;
import net.i2p.addressbook.Log;
import net.i2p.addressbook.SubscriptionIterator;
import net.i2p.addressbook.SubscriptionList;
import net.i2p.client.naming.HostTxtEntry;
import net.i2p.client.naming.NamingService;
import net.i2p.client.naming.SingleFileNamingService;
import net.i2p.data.DataFormatException;
import net.i2p.data.Destination;
import net.i2p.util.OrderedProperties;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SystemVersion;

class Daemon {
    public static final String VERSION = "2.0.4";
    private volatile boolean _running;
    private static final boolean DEBUG = false;
    private static final String DEFAULT_SUB = "http://stats.i2p/cgi-bin/newhosts.txt\nhttp://skank.i2p/hosts.txt\nhttp://notbob.i2p/hosts.txt";
    static final String OLD_DEFAULT_SUB = "http://www.i2p2.i2p/hosts.txt";
    private static final String RCVD_PROP_PREFIX = "=";
    private static final boolean MUST_VALIDATE = false;

    Daemon() {
    }

    public static void update(AddressBook master, AddressBook router, File published, SubscriptionList subscriptions, Log log) {
        for (AddressBook book : subscriptions) {
            router.merge(book, false, log);
        }
        router.write();
        if (published != null) {
            if (master != null) {
                router.merge(master, true, null);
            }
            router.write(published);
        }
        subscriptions.write();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void update(NamingService router, File published, SubscriptionList subscriptions, Log log) {
        Set<String> knownNames;
        boolean isTextFile;
        String nsClass = router.getClass().getSimpleName();
        boolean bl = isTextFile = nsClass.equals("HostsTxtNamingService") || nsClass.equals("SingleFileNamingService");
        if (isTextFile) {
            Properties opts = new Properties();
            opts.setProperty("file", "hosts.txt");
            knownNames = router.getNames(opts);
        } else {
            knownNames = null;
        }
        SingleFileNamingService publishedNS = published != null ? new SingleFileNamingService(I2PAppContext.getGlobalContext(), published.getAbsolutePath()) : null;
        SubscriptionIterator iter = subscriptions.iterator();
        while (iter.hasNext()) {
            long start = System.currentTimeMillis();
            AddressBook addressbook = (AddressBook)iter.next();
            Iterator<Map.Entry<String, HostTxtEntry>> iter2 = addressbook.iterator();
            try {
                Daemon.update(router, knownNames, publishedNS, addressbook, iter2, log);
            }
            finally {
                if (iter2 instanceof HostTxtIterator) {
                    ((HostTxtIterator)iter2).close();
                }
                addressbook.delete();
            }
        }
        subscriptions.write();
    }

    private static void update(NamingService router, Set<String> knownNames, NamingService publishedNS, AddressBook addressbook, Iterator<Map.Entry<String, HostTxtEntry>> iter, Log log) {
        long start = 0L;
        int old = 0;
        int nnew = 0;
        int invalid = 0;
        boolean conflict = false;
        int total = 0;
        int deleted = 0;
        while (iter.hasNext()) {
            boolean isKnown;
            Destination oldDest;
            Map.Entry<String, HostTxtEntry> entry = iter.next();
            ++total;
            String key = entry.getKey();
            if (knownNames != null) {
                oldDest = null;
                isKnown = key != null ? knownNames.contains(key) : false;
            } else {
                oldDest = key != null ? router.lookup(key) : null;
                isKnown = oldDest != null;
            }
            try {
                block86: {
                    String action;
                    OrderedProperties hprops;
                    block87: {
                        boolean allowExistingKeyInPublished;
                        OrderedProperties props;
                        Destination dest;
                        block88: {
                            block102: {
                                block103: {
                                    List<Destination> pod;
                                    HostTxtEntry he;
                                    block104: {
                                        boolean success;
                                        String poldname;
                                        block98: {
                                            block99: {
                                                List<Destination> pod2;
                                                String polddest;
                                                block101: {
                                                    block100: {
                                                        block94: {
                                                            block95: {
                                                                List<Destination> pod22;
                                                                block97: {
                                                                    Destination pod3;
                                                                    block96: {
                                                                        block92: {
                                                                            block93: {
                                                                                block89: {
                                                                                    block90: {
                                                                                        List<Destination> pod23;
                                                                                        block91: {
                                                                                            he = entry.getValue();
                                                                                            hprops = he.getProps();
                                                                                            boolean mustValidate = hprops != null;
                                                                                            String string = action = hprops != null ? hprops.getProperty("action") : null;
                                                                                            if (key == null && !he.hasValidRemoveSig()) {
                                                                                                if (log != null) {
                                                                                                    log.append("Bad signature of action " + action + " for key " + hprops.getProperty("name") + ". [" + addressbook.getLocation() + "]");
                                                                                                }
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            if (key != null && mustValidate && !he.hasValidSig()) {
                                                                                                if (log != null) {
                                                                                                    log.append("Bad signature of action " + action + " for key " + key + ". [" + addressbook.getLocation() + "]");
                                                                                                }
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            if (action == null && isKnown) break block86;
                                                                                            if (key == null || !AddressBook.isValidKey(key)) break block87;
                                                                                            dest = new Destination(he.getDest());
                                                                                            props = new OrderedProperties();
                                                                                            props.setProperty("s", addressbook.getLocation());
                                                                                            allowExistingKeyInPublished = false;
                                                                                            if (mustValidate) {
                                                                                                props.setProperty("v", "true");
                                                                                            }
                                                                                            if (hprops != null) {
                                                                                                for (Map.Entry<Object, Object> e : ((Properties)hprops).entrySet()) {
                                                                                                    props.setProperty(RCVD_PROP_PREFIX + e.getKey(), (String)e.getValue());
                                                                                                }
                                                                                            }
                                                                                            if (action == null) break block88;
                                                                                            if (!action.equals("adddest")) break block89;
                                                                                            polddest = hprops.getProperty("olddest");
                                                                                            if (polddest == null) break block90;
                                                                                            pod = new Destination(polddest);
                                                                                            pod23 = router.lookupAll(key);
                                                                                            if (pod23 != null) break block91;
                                                                                            if (!he.hasValidInnerSig()) {
                                                                                                Daemon.logInner(log, action, key, addressbook);
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            break block88;
                                                                                        }
                                                                                        if (pod23.contains(dest)) {
                                                                                            ++old;
                                                                                            continue;
                                                                                        }
                                                                                        if (pod23.contains(pod)) {
                                                                                            if (!he.hasValidInnerSig()) {
                                                                                                Daemon.logInner(log, action, key, addressbook);
                                                                                                ++invalid;
                                                                                                continue;
                                                                                            }
                                                                                            boolean success2 = router.addDestination(key, dest, props);
                                                                                            if (log != null) {
                                                                                                if (success2) {
                                                                                                    log.append("Additional address for " + key + " [" + addressbook.getLocation() + "]");
                                                                                                } else {
                                                                                                    log.append("Failed to add additional address for " + key + " [" + addressbook.getLocation() + "]");
                                                                                                }
                                                                                            }
                                                                                            if (publishedNS != null) {
                                                                                                success2 = publishedNS.addDestination(key, dest, props);
                                                                                                if (log != null && !success2) {
                                                                                                    log.append("Failed to add " + key + " to published addressbook [" + publishedNS.getName() + "]");
                                                                                                }
                                                                                            }
                                                                                            ++nnew;
                                                                                            continue;
                                                                                        }
                                                                                        Daemon.logMismatch(log, action, key, pod23, he.getDest(), addressbook);
                                                                                        ++invalid;
                                                                                        continue;
                                                                                    }
                                                                                    Daemon.logMissing(log, action, key, addressbook);
                                                                                    ++invalid;
                                                                                    continue;
                                                                                }
                                                                                if (!action.equals("addname")) break block92;
                                                                                if (isKnown) {
                                                                                    ++old;
                                                                                    continue;
                                                                                }
                                                                                poldname = hprops.getProperty("oldname");
                                                                                if (poldname == null) break block93;
                                                                                pod = router.lookupAll(poldname);
                                                                                if (pod != null && !pod.contains(dest)) {
                                                                                    Daemon.logMismatch(log, action, key, pod, he.getDest(), addressbook);
                                                                                    ++invalid;
                                                                                    continue;
                                                                                }
                                                                                break block88;
                                                                            }
                                                                            Daemon.logMissing(log, action, key, addressbook);
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        if (!action.equals("addsubdomain")) break block94;
                                                                        if (isKnown) {
                                                                            ++old;
                                                                            continue;
                                                                        }
                                                                        polddest = hprops.getProperty("olddest");
                                                                        String poldname2 = hprops.getProperty("oldname");
                                                                        if (polddest == null || poldname2 == null) break block95;
                                                                        if (!AddressBook.isValidKey(poldname2) || key.indexOf('.' + poldname2) <= 0) {
                                                                            if (log != null) {
                                                                                log.append("Action: " + action + " failed because old name " + poldname2 + " is invalid. [" + addressbook.getLocation() + "]");
                                                                            }
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        pod3 = new Destination(polddest);
                                                                        pod22 = router.lookupAll(poldname2);
                                                                        if (pod22 != null) break block96;
                                                                        if (!he.hasValidInnerSig()) {
                                                                            Daemon.logInner(log, action, key, addressbook);
                                                                            ++invalid;
                                                                            continue;
                                                                        }
                                                                        break block88;
                                                                    }
                                                                    if (!pod22.contains(pod3)) break block97;
                                                                    if (!he.hasValidInnerSig()) {
                                                                        Daemon.logInner(log, action, key, addressbook);
                                                                        ++invalid;
                                                                        continue;
                                                                    }
                                                                    break block88;
                                                                }
                                                                Daemon.logMismatch(log, action, key, pod22, polddest, addressbook);
                                                                ++invalid;
                                                                continue;
                                                            }
                                                            Daemon.logMissing(log, action, key, addressbook);
                                                            ++invalid;
                                                            continue;
                                                        }
                                                        if (!action.equals("changedest")) break block98;
                                                        polddest = hprops.getProperty("olddest");
                                                        if (polddest == null) break block99;
                                                        pod = new Destination(polddest);
                                                        pod2 = router.lookupAll(key);
                                                        if (pod2 != null) break block100;
                                                        if (!he.hasValidInnerSig()) {
                                                            Daemon.logInner(log, action, key, addressbook);
                                                            ++invalid;
                                                            continue;
                                                        }
                                                        break block88;
                                                    }
                                                    if (pod2.contains(dest)) {
                                                        ++old;
                                                        continue;
                                                    }
                                                    if (!pod2.contains(pod)) break block101;
                                                    if (!he.hasValidInnerSig()) {
                                                        Daemon.logInner(log, action, key, addressbook);
                                                        ++invalid;
                                                        continue;
                                                    }
                                                    if (log != null) {
                                                        if (pod2.size() == 1) {
                                                            log.append("Changing destination for " + key + ". [" + addressbook.getLocation() + "]");
                                                        } else {
                                                            log.append("Replacing " + pod2.size() + " destinations for " + key + " [" + addressbook.getLocation() + "]");
                                                        }
                                                    }
                                                    allowExistingKeyInPublished = true;
                                                    props.setProperty("m", Long.toString(I2PAppContext.getGlobalContext().clock().now()));
                                                    break block88;
                                                }
                                                Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                                ++invalid;
                                                continue;
                                            }
                                            Daemon.logMissing(log, action, key, addressbook);
                                            ++invalid;
                                            continue;
                                        }
                                        if (!action.equals("changename")) break block102;
                                        if (isKnown) {
                                            ++old;
                                            continue;
                                        }
                                        poldname = hprops.getProperty("oldname");
                                        if (poldname == null) break block103;
                                        pod = router.lookupAll(poldname);
                                        if (pod == null) break block88;
                                        if (!pod.contains(dest)) break block104;
                                        if (knownNames != null) {
                                            knownNames.remove(poldname);
                                        }
                                        if (success = router.remove(poldname, dest)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + poldname + " to be replaced with " + key + " [" + addressbook.getLocation() + "]");
                                            } else {
                                                log.append("Remove failed for: " + poldname + " to be replaced with " + key + " [" + addressbook.getLocation() + "]");
                                            }
                                        }
                                        if (publishedNS == null) break block88;
                                        success = publishedNS.remove(poldname, dest);
                                        if (log == null || success) break block88;
                                        log.append("Remove from published addressbook " + publishedNS.getName() + " failed for " + poldname);
                                        break block88;
                                    }
                                    Daemon.logMismatch(log, action, key, pod, he.getDest(), addressbook);
                                    continue;
                                }
                                Daemon.logMissing(log, action, key, addressbook);
                                ++invalid;
                                continue;
                            }
                            if (action.equals("remove") || action.equals("removeall")) {
                                if (log != null) {
                                    log.append("Action: " + action + " with name=dest invalid [" + addressbook.getLocation() + "]");
                                }
                                ++invalid;
                                continue;
                            }
                            if (action.equals("update")) {
                                if (isKnown) {
                                    allowExistingKeyInPublished = true;
                                    props.setProperty("m", Long.toString(I2PAppContext.getGlobalContext().clock().now()));
                                }
                            } else {
                                if (log != null) {
                                    log.append("Action: " + action + " unrecognized [" + addressbook.getLocation() + "]");
                                }
                                ++invalid;
                                continue;
                            }
                        }
                        boolean success = router.put(key, dest, props);
                        if (log != null) {
                            if (success) {
                                log.append("New domain " + key + " [" + addressbook.getLocation() + "]");
                            } else {
                                log.append("Save to naming service " + router + " failed for new key " + key);
                            }
                        }
                        if (publishedNS != null) {
                            success = allowExistingKeyInPublished ? publishedNS.put(key, dest, props) : publishedNS.putIfAbsent(key, dest, props);
                            if (log != null && !success) {
                                log.append("Failed to save " + key + " to published addressbook [" + publishedNS.getName() + "]");
                            }
                        }
                        if (knownNames != null) {
                            knownNames.add(key);
                        }
                        ++nnew;
                        continue;
                    }
                    if (key == null) {
                        if (action != null) {
                            String polddest;
                            if (action.equals("remove")) {
                                polddest = hprops.getProperty("dest");
                                String poldname = hprops.getProperty("name");
                                if (polddest != null && poldname != null) {
                                    Destination pod = new Destination(polddest);
                                    List<Destination> pod2 = router.lookupAll(poldname);
                                    if (pod2 != null && pod2.contains(pod)) {
                                        boolean success;
                                        if (knownNames != null && pod2.size() == 1) {
                                            knownNames.remove(poldname);
                                        }
                                        if (success = router.remove(poldname, pod)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + poldname + " as requested [" + addressbook.getLocation() + "]");
                                            } else {
                                                log.append("Remove failed for: " + poldname + " as requested [" + addressbook.getLocation() + "]");
                                            }
                                        }
                                        if (publishedNS == null) continue;
                                        success = publishedNS.remove(poldname, pod);
                                        if (log == null || success) continue;
                                        log.append("Failed to remove " + poldname + " from published addressbook [" + publishedNS.getName() + "]");
                                        continue;
                                    }
                                    if (pod2 != null) {
                                        Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                        ++invalid;
                                        continue;
                                    }
                                    ++old;
                                    continue;
                                }
                                Daemon.logMissing(log, action, "delete", addressbook);
                                ++invalid;
                                continue;
                            }
                            if (action.equals("removeall")) {
                                polddest = hprops.getProperty("dest");
                                if (polddest != null) {
                                    List<String> revs;
                                    Destination pod = new Destination(polddest);
                                    String poldname = hprops.getProperty("name");
                                    if (poldname != null) {
                                        List<Destination> pod2 = router.lookupAll(poldname);
                                        if (pod2 != null && pod2.contains(pod)) {
                                            boolean success;
                                            if (knownNames != null) {
                                                knownNames.remove(poldname);
                                            }
                                            if (success = router.remove(poldname, pod)) {
                                                ++deleted;
                                            }
                                            if (log != null) {
                                                if (success) {
                                                    log.append("Removed: " + poldname + " as requested [" + addressbook.getLocation() + "]");
                                                } else {
                                                    log.append("Remove failed for: " + poldname + " as requested [" + addressbook.getLocation() + "]");
                                                }
                                            }
                                            if (publishedNS != null) {
                                                success = publishedNS.remove(poldname, pod);
                                                if (log != null && !success) {
                                                    log.append("Failed to remove " + poldname + " from published addressbook [" + publishedNS.getName() + "]");
                                                }
                                            }
                                        } else if (pod2 != null) {
                                            Daemon.logMismatch(log, action, key, pod2, polddest, addressbook);
                                            ++invalid;
                                        } else {
                                            ++old;
                                        }
                                    }
                                    if ((revs = router.reverseLookupAll(pod)) == null) continue;
                                    for (String rev : revs) {
                                        boolean success;
                                        if (knownNames != null) {
                                            knownNames.remove(rev);
                                        }
                                        if (success = router.remove(rev, pod)) {
                                            ++deleted;
                                        }
                                        if (log != null) {
                                            if (success) {
                                                log.append("Removed: " + rev + " as requested [" + addressbook.getLocation() + "]");
                                            } else {
                                                log.append("Remove failed for: " + rev + " as requested [" + addressbook.getLocation() + "]");
                                            }
                                        }
                                        if (publishedNS == null) continue;
                                        success = publishedNS.remove(rev, pod);
                                        if (log == null || success) continue;
                                        log.append("Failed to remove " + rev + " from published addressbook [" + publishedNS.getName() + "]");
                                    }
                                    continue;
                                }
                                Daemon.logMissing(log, action, "delete", addressbook);
                                ++invalid;
                                continue;
                            }
                            if (log != null) {
                                log.append("Action: " + action + " without name=dest unrecognized [" + addressbook.getLocation() + "]");
                            }
                            ++invalid;
                            continue;
                        }
                        if (log != null) {
                            log.append("No action in command line [" + addressbook.getLocation() + "]");
                        }
                        ++invalid;
                        continue;
                    }
                    if (log == null) continue;
                    log.append("Bad hostname " + key + " [" + addressbook.getLocation() + "]");
                    ++invalid;
                    continue;
                }
                ++old;
            }
            catch (DataFormatException dfe) {
                if (log != null) {
                    log.append("Invalid b64 for " + key + " [" + addressbook.getLocation() + "]");
                }
                ++invalid;
            }
        }
    }

    private static void logInner(Log log, String action, String name, AddressBook addressbook) {
        if (log != null) {
            log.append("Action: " + action + " failed because inner signature for key " + name + " failed [" + addressbook.getLocation() + "]");
        }
    }

    private static void logMissing(Log log, String action, String name, AddressBook addressbook) {
        if (log != null) {
            log.append("Action: " + action + " for " + name + " failed, missing required parameters [" + addressbook.getLocation() + "]");
        }
    }

    private static void logMismatch(Log log, String action, String name, List<Destination> dests, String olddest, AddressBook addressbook) {
        if (log != null) {
            StringBuilder buf = new StringBuilder(16);
            int sz = dests.size();
            for (int i = 0; i < sz; ++i) {
                buf.append(dests.get(i).toBase64().substring(0, 6));
                if (i == sz - 1) continue;
                buf.append(", ");
            }
            log.append("Action: " + action + " failed because destinations for " + name + " (" + buf + ')' + " do not include (" + olddest.substring(0, 6) + ')' + " [" + addressbook.getLocation() + "]");
        }
    }

    public static void update(Map<String, String> settings, String home) {
        Log log;
        long delay;
        File published = null;
        boolean should_publish = Boolean.parseBoolean(settings.get("should_publish"));
        if (should_publish) {
            published = new File(home, settings.get("published_addressbook"));
        }
        File subscriptionFile = new File(home, settings.get("subscriptions"));
        File logFile = new File(home, settings.get("log"));
        File etagsFile = new File(home, settings.get("etags"));
        File lastModifiedFile = new File(home, settings.get("last_modified"));
        File lastFetchedFile = new File(home, settings.get("last_fetched"));
        try {
            delay = Long.parseLong(settings.get("update_delay"));
        }
        catch (NumberFormatException nfe) {
            delay = 12L;
        }
        ArrayList<String> defaultSubs = new ArrayList<String>(4);
        defaultSubs.add(DEFAULT_SUB);
        SubscriptionList subscriptions = new SubscriptionList(subscriptionFile, etagsFile, lastModifiedFile, lastFetchedFile, delay *= 3600000L, defaultSubs, settings.get("proxy_host"), Integer.parseInt(settings.get("proxy_port")));
        Log log2 = log = SystemVersion.isAndroid() ? null : new Log(logFile);
        if (Boolean.parseBoolean(settings.get("update_direct"))) {
            AddressBook master;
            File routerFile = new File(home, settings.get("router_addressbook"));
            if (should_publish) {
                File masterFile = new File(home, settings.get("master_addressbook"));
                master = new AddressBook(masterFile);
            } else {
                master = null;
            }
            AddressBook router = new AddressBook(routerFile);
            Daemon.update(master, router, published, subscriptions, log);
        } else {
            Daemon.update(Daemon.getNamingService(settings.get("naming_service")), published, subscriptions, log);
        }
    }

    private static NamingService searchNamingService(NamingService ns, String srch) {
        String name = ns.getName();
        if (name.equals(srch) || name.endsWith('/' + srch) || name.endsWith('\\' + srch)) {
            return ns;
        }
        List<NamingService> list = ns.getNamingServices();
        if (list != null) {
            for (NamingService nss : list) {
                NamingService rv = Daemon.searchNamingService(nss, srch);
                if (rv == null) continue;
                return rv;
            }
        }
        return null;
    }

    private static NamingService getNamingService(String srch) {
        NamingService root = I2PAppContext.getGlobalContext().namingService();
        NamingService rv = Daemon.searchNamingService(root, srch);
        return rv != null ? rv : root;
    }

    public static void main(String[] args) {
        Daemon daemon = new Daemon();
        if (args.length > 0 && args[0].equals("test")) {
            Daemon.test(args);
        } else {
            daemon.run(args);
        }
    }

    public static void test(String[] args) {
        Properties ctxProps = new Properties();
        String PROP_FORCE = "i2p.naming.blockfile.writeInAppContext";
        ctxProps.setProperty(PROP_FORCE, "true");
        I2PAppContext ctx = new I2PAppContext(ctxProps);
        NamingService ns = Daemon.getNamingService("hosts.txt");
        File published = new File("test-published.txt");
        Log log = new Log(new File("test-log.txt"));
        SubscriptionList subscriptions = new SubscriptionList("test-sub.txt");
        Daemon.update(ns, published, subscriptions, log);
        ctx.logManager().flush();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run(String[] args) {
        boolean created;
        SecureDirectory homeFile;
        this._running = true;
        String settingsLocation = "config.txt";
        if (args != null && args.length > 0) {
            homeFile = new SecureDirectory(args[0]);
            if (!homeFile.isAbsolute()) {
                homeFile = new SecureDirectory(I2PAppContext.getGlobalContext().getRouterDir(), args[0]);
            }
        } else {
            homeFile = new SecureDirectory(System.getProperty("user.dir"));
        }
        HashMap<String, String> defaultSettings = new HashMap<String, String>();
        defaultSettings.put("proxy_host", "127.0.0.1");
        defaultSettings.put("proxy_port", "4444");
        defaultSettings.put("master_addressbook", "../userhosts.txt");
        defaultSettings.put("router_addressbook", "../hosts.txt");
        defaultSettings.put("published_addressbook", "../eepsite/docroot/hosts.txt");
        defaultSettings.put("should_publish", "false");
        defaultSettings.put("log", "log.txt");
        defaultSettings.put("subscriptions", "subscriptions.txt");
        defaultSettings.put("etags", "etags");
        defaultSettings.put("last_modified", "last_modified");
        defaultSettings.put("last_fetched", "last_fetched");
        defaultSettings.put("update_delay", "3");
        defaultSettings.put("update_direct", "false");
        defaultSettings.put("naming_service", "hosts.txt");
        if (!homeFile.exists() && !(created = ((File)homeFile).mkdirs())) {
            System.out.println("ERROR: Addressbook directory " + homeFile.getAbsolutePath() + " could not be created");
        }
        File settingsFile = new File(homeFile, settingsLocation);
        Map<String, String> settings = ConfigParser.parse(settingsFile, defaultSettings);
        try {
            Thread.sleep(300000L + I2PAppContext.getGlobalContext().random().nextLong(300000L));
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        while (this._running) {
            long delay = Long.parseLong(settings.get("update_delay"));
            if (delay < 1L) {
                delay = 1L;
            }
            Daemon.update(settings, homeFile.getAbsolutePath());
            try {
                Daemon daemon = this;
                synchronized (daemon) {
                    this.wait(delay * 60L * 60L * 1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (!this._running) break;
            settings = ConfigParser.parse(settingsFile, defaultSettings);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void wakeup() {
        Daemon daemon = this;
        synchronized (daemon) {
            this.notifyAll();
        }
    }

    public void stop() {
        this._running = false;
        this.wakeup();
    }
}

