/*
 * Decompiled with CFR 0.152.
 */
package io.pack200;

import io.pack200.Pack200;
import io.pack200.Utils;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.ResourceBundle;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;

class Driver {
    private static final ResourceBundle RESOURCE = ResourceBundle.getBundle("io.pack200.DriverResource");
    private static final String PACK200_OPTION_MAP = "--repack                 $ \n  -r +>- @--repack              $ \n--no-gzip                $ \n  -g +>- @--no-gzip             $ \n--strip-debug            $ \n  -G +>- @--strip-debug         $ \n--no-keep-file-order     $ \n  -O +>- @--no-keep-file-order  $ \n--segment-limit=      *> = \n  -S +>  @--segment-limit=      = \n--effort=             *> = \n  -E +>  @--effort=             = \n--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--modification-time=  *> = \n  -m +>  @--modification-time=  = \n--pass-file=        *> &\u0000 \n  -P +>  @--pass-file=        &\u0000 \n--unknown-attribute=  *> = \n  -U +>  @--unknown-attribute=  = \n--class-attribute=  *> &\u0000 \n  -C +>  @--class-attribute=  &\u0000 \n--field-attribute=  *> &\u0000 \n  -F +>  @--field-attribute=  &\u0000 \n--method-attribute= *> &\u0000 \n  -M +>  @--method-attribute= &\u0000 \n--code-attribute=   *> &\u0000 \n  -D +>  @--code-attribute=   &\u0000 \n--config-file=      *>   . \n  -f +>  @--config-file=        . \n--no-strip-debug  !--strip-debug         \n--gzip            !--no-gzip             \n--keep-file-order !--no-keep-file-order  \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n--           . \n-   +?    >- . \n";
    private static final String UNPACK200_OPTION_MAP = "--deflate-hint=       *> = \n  -H +>  @--deflate-hint=       = \n--verbose                $ \n  -v +>- @--verbose             $ \n--quiet        !--verbose  \n  -q +>- !--verbose               \n--remove-pack-file       $ \n  -r +>- @--remove-pack-file    $ \n--log-file=           *> = \n  -l +>  @--log-file=           = \n--config-file=        *> . \n  -f +>  @--config-file=        . \n--           . \n-   +?    >- . \n--version                . \n  -V +>  @--version             . \n--help               . \n  -? +> @--help . \n  -h +> @--help . \n";
    private static final String[] PACK200_PROPERTY_TO_OPTION = new String[]{"pack.segment.limit", "--segment-limit=", "pack.keep.file.order", "--no-keep-file-order", "pack.effort", "--effort=", "pack.deflate.hint", "--deflate-hint=", "pack.modification.time", "--modification-time=", "pack.pass.file.", "--pass-file=", "pack.unknown.attribute", "--unknown-attribute=", "pack.class.attribute.", "--class-attribute=", "pack.field.attribute.", "--field-attribute=", "pack.method.attribute.", "--method-attribute=", "pack.code.attribute.", "--code-attribute=", "io.pack200.verbose", "--verbose", "io.pack200.strip.debug", "--strip-debug"};
    private static final String[] UNPACK200_PROPERTY_TO_OPTION = new String[]{"unpack.deflate.hint", "--deflate-hint=", "io.pack200.verbose", "--verbose", "io.pack200.unpack.remove.packfile", "--remove-pack-file"};

    Driver() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] ava) throws IOException {
        String[] propTable;
        String optionMap;
        String arg0;
        ArrayList<String> av = new ArrayList<String>(Arrays.asList(ava));
        boolean doPack = true;
        boolean doUnpack = false;
        boolean doRepack = false;
        boolean doZip = true;
        String logFile = null;
        String verboseProp = "io.pack200.verbose";
        switch (arg0 = av.isEmpty() ? "" : (String)av.get(0)) {
            case "--pack": {
                av.remove(0);
                break;
            }
            case "--unpack": {
                av.remove(0);
                doPack = false;
                doUnpack = true;
            }
        }
        HashMap<String, String> engProps = new HashMap<String, String>();
        engProps.put(verboseProp, System.getProperty(verboseProp));
        if (doPack) {
            optionMap = PACK200_OPTION_MAP;
            propTable = PACK200_PROPERTY_TO_OPTION;
        } else {
            optionMap = UNPACK200_OPTION_MAP;
            propTable = UNPACK200_PROPERTY_TO_OPTION;
        }
        HashMap<String, String> avProps = new HashMap<String, String>();
        try {
            String state;
            block41: while (true) {
                state = Driver.parseCommandOptions(av, optionMap, avProps);
                Iterator opti = avProps.keySet().iterator();
                while (opti.hasNext()) {
                    String opt = (String)opti.next();
                    String prop = null;
                    for (int i = 0; i < propTable.length; i += 2) {
                        if (!opt.equals(propTable[1 + i])) continue;
                        prop = propTable[0 + i];
                        break;
                    }
                    if (prop == null) continue;
                    String val = (String)avProps.get(opt);
                    opti.remove();
                    if (!prop.endsWith(".")) {
                        if (!opt.equals("--verbose") && !opt.endsWith("=")) {
                            boolean flag;
                            boolean bl = flag = val != null;
                            if (opt.startsWith("--no-")) {
                                flag = !flag;
                            }
                            val = flag ? "true" : "false";
                        }
                        engProps.put(prop, val);
                        continue;
                    }
                    if (prop.contains(".attribute.")) {
                        for (String val1 : val.split("\u0000")) {
                            String[] val2 = val1.split("=", 2);
                            engProps.put(prop + val2[0], val2[1]);
                        }
                        continue;
                    }
                    int idx = 1;
                    for (String val1 : val.split("\u0000")) {
                        String prop1;
                        while (engProps.containsKey(prop1 = prop + "cli." + idx++)) {
                        }
                        engProps.put(prop1, val1);
                    }
                }
                if (!"--config-file=".equals(state)) break;
                String propFile = (String)av.remove(0);
                Properties fileProps = new Properties();
                try (Iterator<Map.Entry<Object, Object>> propIn = new FileInputStream(propFile);){
                    fileProps.load((InputStream)((Object)propIn));
                }
                if (engProps.get(verboseProp) != null) {
                    fileProps.list(System.out);
                }
                propIn = fileProps.entrySet().iterator();
                while (true) {
                    if (!propIn.hasNext()) continue block41;
                    Map.Entry<Object, Object> me = propIn.next();
                    engProps.put((String)me.getKey(), (String)me.getValue());
                }
                break;
            }
            if ("--version".equals(state)) {
                System.out.println(MessageFormat.format(RESOURCE.getString("VERSION"), Driver.class.getName(), "1.31, 07/05/05"));
                return;
            }
            if ("--help".equals(state)) {
                Driver.printUsage(doPack, true, System.out);
                System.exit(0);
                return;
            }
        }
        catch (IllegalArgumentException ee) {
            System.err.println(MessageFormat.format(RESOURCE.getString("BAD_ARGUMENT"), ee));
            Driver.printUsage(doPack, false, System.err);
            System.exit(2);
            return;
        }
        block48: for (String opt : avProps.keySet()) {
            String val = (String)avProps.get(opt);
            switch (opt) {
                case "--repack": {
                    doRepack = true;
                    continue block48;
                }
                case "--no-gzip": {
                    doZip = val == null;
                    continue block48;
                }
                case "--log-file=": {
                    logFile = val;
                    continue block48;
                }
            }
            throw new InternalError(MessageFormat.format(RESOURCE.getString("BAD_OPTION"), opt, avProps.get(opt)));
        }
        if (logFile != null && !logFile.isEmpty()) {
            if (logFile.equals("-")) {
                System.setErr(System.out);
            } else {
                FileOutputStream log = new FileOutputStream(logFile);
                System.setErr(new PrintStream(log));
            }
        }
        boolean verbose = engProps.get(verboseProp) != null;
        String packfile = "";
        if (!av.isEmpty()) {
            packfile = (String)av.remove(0);
        }
        String jarfile = "";
        if (!av.isEmpty()) {
            jarfile = (String)av.remove(0);
        }
        String newfile = "";
        String bakfile = "";
        String tmpfile = "";
        if (doRepack) {
            if (packfile.toLowerCase().endsWith(".pack") || packfile.toLowerCase().endsWith(".pac") || packfile.toLowerCase().endsWith(".gz")) {
                System.err.println(MessageFormat.format(RESOURCE.getString("BAD_REPACK_OUTPUT"), packfile));
                Driver.printUsage(doPack, false, System.err);
                System.exit(2);
            }
            newfile = packfile;
            if (jarfile.isEmpty()) {
                jarfile = newfile;
            }
            packfile = tmpfile = Driver.createTempFile(newfile, ".pack").getPath();
            doZip = false;
        }
        if (!(av.isEmpty() && (jarfile.toLowerCase().endsWith(".jar") || jarfile.toLowerCase().endsWith(".zip") || jarfile.equals("-") && !doPack))) {
            Driver.printUsage(doPack, false, System.err);
            System.exit(2);
            return;
        }
        if (doRepack) {
            doUnpack = true;
            doPack = true;
        } else if (doPack) {
            doUnpack = false;
        }
        Pack200.Packer jpack = Pack200.newPacker();
        Pack200.Unpacker junpack = Pack200.newUnpacker();
        jpack.properties().putAll(engProps);
        junpack.properties().putAll(engProps);
        if (doRepack && newfile.equals(jarfile)) {
            String zipc = Driver.getZipComment(jarfile);
            if (verbose && !zipc.isEmpty()) {
                System.out.println(MessageFormat.format(RESOURCE.getString("DETECTED_ZIP_COMMENT"), zipc));
            }
            if (zipc.indexOf("PACK200") >= 0) {
                System.out.println(MessageFormat.format(RESOURCE.getString("SKIP_FOR_REPACKED"), jarfile));
                doPack = false;
                doUnpack = false;
                doRepack = false;
            }
        }
        try {
            if (doPack) {
                OutputStream out;
                JarFile in = new JarFile(new File(jarfile));
                if (packfile.equals("-")) {
                    out = System.out;
                    System.setOut(System.err);
                } else if (doZip) {
                    if (!packfile.endsWith(".gz")) {
                        System.err.println(MessageFormat.format(RESOURCE.getString("WRITE_PACK_FILE"), packfile));
                        Driver.printUsage(doPack, false, System.err);
                        System.exit(2);
                    }
                    out = new FileOutputStream(packfile);
                    out = new BufferedOutputStream(out);
                    out = new GZIPOutputStream(out);
                } else {
                    if (!packfile.toLowerCase().endsWith(".pack") && !packfile.toLowerCase().endsWith(".pac")) {
                        System.err.println(MessageFormat.format(RESOURCE.getString("WRITE_PACKGZ_FILE"), packfile));
                        Driver.printUsage(doPack, false, System.err);
                        System.exit(2);
                    }
                    out = new FileOutputStream(packfile);
                    out = new BufferedOutputStream(out);
                }
                jpack.pack(in, out);
                ((OutputStream)out).close();
            }
            if (doRepack && newfile.equals(jarfile)) {
                File bakf = Driver.createTempFile(jarfile, ".bak");
                bakf.delete();
                boolean okBackup = new File(jarfile).renameTo(bakf);
                if (!okBackup) {
                    throw new Error(MessageFormat.format(RESOURCE.getString("SKIP_FOR_MOVE_FAILED"), bakfile));
                }
                bakfile = bakf.getPath();
            }
            if (doUnpack) {
                InputStream in = packfile.equals("-") ? System.in : new FileInputStream(new File(packfile));
                BufferedInputStream inBuf = new BufferedInputStream(in);
                in = inBuf;
                if (Utils.isGZIPMagic(Utils.readMagic(inBuf))) {
                    in = new GZIPInputStream(in);
                }
                String outfile = newfile.isEmpty() ? jarfile : newfile;
                OutputStream fileOut = outfile.equals("-") ? System.out : new FileOutputStream(outfile);
                fileOut = new BufferedOutputStream(fileOut);
                try (JarOutputStream out = new JarOutputStream(fileOut);){
                    junpack.unpack(in, out);
                }
            }
            if (!bakfile.isEmpty()) {
                new File(bakfile).delete();
                bakfile = "";
            }
        }
        finally {
            if (!bakfile.isEmpty()) {
                File jarFile = new File(jarfile);
                jarFile.delete();
                new File(bakfile).renameTo(jarFile);
            }
            if (!tmpfile.isEmpty()) {
                new File(tmpfile).delete();
            }
        }
    }

    private static File createTempFile(String basefile, String suffix) throws IOException {
        File base = new File(basefile);
        String prefix = base.getName();
        if (prefix.length() < 3) {
            prefix = prefix + "tmp";
        }
        File where = base.getParentFile() == null && suffix.equals(".bak") ? new File(".").getAbsoluteFile() : base.getParentFile();
        Path tmpfile = where == null ? Files.createTempFile(prefix, suffix, new FileAttribute[0]) : Files.createTempFile(where.toPath(), prefix, suffix, new FileAttribute[0]);
        return tmpfile.toFile();
    }

    private static void printUsage(boolean doPack, boolean full, PrintStream out) {
        String prog = doPack ? "pack200" : "unpack200";
        String[] packUsage = (String[])RESOURCE.getObject("PACK_HELP");
        String[] unpackUsage = (String[])RESOURCE.getObject("UNPACK_HELP");
        String[] usage = doPack ? packUsage : unpackUsage;
        for (int i = 0; i < usage.length; ++i) {
            out.println(usage[i]);
            if (full) continue;
            out.println(MessageFormat.format(RESOURCE.getString("MORE_INFO"), prog));
            break;
        }
    }

    private static String getZipComment(String jarfile) throws IOException {
        byte[] tail = new byte[1000];
        long filelen = new File(jarfile).length();
        if (filelen <= 0L) {
            return "";
        }
        long skiplen = Math.max(0L, filelen - (long)tail.length);
        try (FileInputStream in = new FileInputStream(new File(jarfile));){
            ((InputStream)in).skip(skiplen);
            ((InputStream)in).read(tail);
            for (int i = tail.length - 4; i >= 0; --i) {
                if (tail[i + 0] != 80 || tail[i + 1] != 75 || tail[i + 2] != 5 || tail[i + 3] != 6) continue;
                if ((i += 22) < tail.length) {
                    String string = new String(tail, i, tail.length - i, "UTF8");
                    return string;
                }
                String string = "";
                return string;
            }
            String string = "";
            return string;
        }
    }

    private static String parseCommandOptions(List<String> args, String options, Map<String, String> properties) {
        ListIterator<String> pbp;
        ListIterator<String> argp;
        String resultString;
        block32: {
            String arg;
            resultString = null;
            TreeMap<String, String[]> optmap = new TreeMap<String, String[]>();
            for (String optline : options.split("\n")) {
                String[] prevWords;
                String[] words = optline.split("\\p{Space}+");
                if (words.length == 0) continue;
                String opt = words[0];
                words[0] = "";
                if (opt.isEmpty() && words.length >= 1) {
                    opt = words[1];
                    words[1] = "";
                }
                if (opt.length() == 0 || (prevWords = optmap.put(opt, words)) == null) continue;
                throw new RuntimeException(MessageFormat.format(RESOURCE.getString("DUPLICATE_OPTION"), optline.trim()));
            }
            argp = args.listIterator();
            pbp = new ArrayList().listIterator();
            block14: while (true) {
                if (pbp.hasPrevious()) {
                    arg = (String)pbp.previous();
                    pbp.remove();
                } else {
                    if (!argp.hasNext()) break block32;
                    arg = argp.next();
                }
                int optlen = arg.length();
                while (true) {
                    String[] specs;
                    String opt;
                    if (!optmap.containsKey(opt = arg.substring(0, optlen))) {
                        if (optlen == 0) break block14;
                        SortedMap pfxmap = optmap.headMap(opt);
                        int len = pfxmap.isEmpty() ? 0 : pfxmap.lastKey().length();
                        optlen = Math.min(len, optlen - 1);
                        opt = arg.substring(0, optlen);
                        continue;
                    }
                    opt = opt.intern();
                    assert (arg.startsWith(opt));
                    assert (opt.length() == optlen);
                    String val = arg.substring(optlen);
                    boolean didAction = false;
                    boolean isError = false;
                    int pbpMark = pbp.nextIndex();
                    block16: for (String spec : specs = (String[])optmap.get(opt)) {
                        boolean ok;
                        if (spec.length() == 0) continue;
                        if (spec.startsWith("#")) break;
                        int sidx = 0;
                        char specop = spec.charAt(sidx++);
                        switch (specop) {
                            case '+': {
                                ok = !val.isEmpty();
                                specop = spec.charAt(sidx++);
                                break;
                            }
                            case '*': {
                                ok = true;
                                specop = spec.charAt(sidx++);
                                break;
                            }
                            default: {
                                boolean bl = ok = val.length() == 0;
                            }
                        }
                        if (!ok) continue;
                        String specarg = spec.substring(sidx);
                        switch (specop) {
                            case '.': {
                                resultString = specarg.isEmpty() ? opt : specarg.intern();
                                break block32;
                            }
                            case '?': {
                                resultString = specarg.isEmpty() ? arg : specarg.intern();
                                isError = true;
                                break block16;
                            }
                            case '@': {
                                opt = specarg.intern();
                                continue block16;
                            }
                            case '>': {
                                pbp.add(specarg + val);
                                val = "";
                                continue block16;
                            }
                            case '!': {
                                String negopt = specarg.isEmpty() ? opt : specarg.intern();
                                properties.remove(negopt);
                                properties.put(negopt, null);
                                didAction = true;
                                continue block16;
                            }
                            case '$': {
                                String old;
                                String boolval = !specarg.isEmpty() ? specarg : ((old = properties.get(opt)) == null || old.length() == 0 ? "1" : "" + (1 + Integer.parseInt(old)));
                                properties.put(opt, boolval);
                                didAction = true;
                                continue block16;
                            }
                            case '&': 
                            case '=': {
                                String old;
                                String strval;
                                boolean append;
                                boolean bl = append = specop == '&';
                                if (pbp.hasPrevious()) {
                                    strval = (String)pbp.previous();
                                    pbp.remove();
                                } else if (argp.hasNext()) {
                                    strval = argp.next();
                                } else {
                                    resultString = arg + " ?";
                                    isError = true;
                                    break block16;
                                }
                                if (append && (old = properties.get(opt)) != null) {
                                    String delim = specarg;
                                    if (delim.length() == 0) {
                                        delim = " ";
                                    }
                                    strval = old + specarg + strval;
                                }
                                properties.put(opt, strval);
                                didAction = true;
                                continue block16;
                            }
                            default: {
                                throw new RuntimeException(MessageFormat.format(RESOURCE.getString("BAD_SPEC"), opt, spec));
                            }
                        }
                    }
                    if (didAction && !isError) continue block14;
                    while (pbp.nextIndex() > pbpMark) {
                        pbp.previous();
                        pbp.remove();
                    }
                    if (isError) {
                        throw new IllegalArgumentException(resultString);
                    }
                    if (optlen == 0) break block14;
                    --optlen;
                }
                break;
            }
            pbp.add(arg);
        }
        args.subList(0, argp.nextIndex()).clear();
        while (pbp.hasPrevious()) {
            args.add(0, (String)pbp.previous());
        }
        return resultString;
    }
}

