/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.RouterThrottleImpl;
import net.i2p.util.Log;

@Deprecated
class RouterDoSThrottle
extends RouterThrottleImpl {
    private volatile long _currentLookupPeriod;
    private final AtomicInteger _currentLookupCount = new AtomicInteger();
    private static final long LOOKUP_THROTTLE_PERIOD = 20000L;
    private static final long LOOKUP_THROTTLE_MAX = 50L;
    private final Log _log;

    public RouterDoSThrottle(RouterContext context) {
        super(context);
        context.statManager().createRateStat("router.throttleNetDbDoS", "NetDb lookup messages received during detected DoS", "Router [Throttle]", new long[]{60000L, 600000L, 3600000L, 86400000L});
        this._log = context.logManager().getLog(RouterDoSThrottle.class);
    }

    @Override
    public boolean acceptNetDbLookupRequest(Hash key) {
        boolean shouldAccept = super.acceptNetDbLookupRequest(key);
        if (!shouldAccept) {
            return false;
        }
        long now = this._context.clock().now();
        if (this._currentLookupPeriod + 20000L > now) {
            int cnt = this._currentLookupCount.incrementAndGet();
            if ((long)cnt >= 50L) {
                int rand;
                this._context.statManager().addRateData("router.throttleNetDbDoS", cnt);
                if ((long)cnt >= 100L) {
                    this._context.banlist().banlistRouter(key, " <b>\u279c</b> Excessive NetDb lookups", null, null, now + 300000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning [" + key.toBase64().substring(0, 6) + "] for 5m for excessive NetDB lookups (Limit (over 20s period): " + 50L + " -> Requests: " + cnt + ")");
                    }
                }
                return (long)(rand = this._context.random().nextInt(cnt)) <= 50L;
            }
            return true;
        }
        this._currentLookupPeriod = now;
        this._currentLookupCount.set(1);
        return true;
    }
}

