/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router;

import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.RouterThrottle;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class RouterThrottleImpl
implements RouterThrottle {
    protected final RouterContext _context;
    private final Log _log;
    private volatile String _tunnelStatus;
    private final long _rejectStartupTime;
    private static final long JOB_LAG_LIMIT_NETWORK = 2000L;
    private static final long JOB_LAG_LIMIT_NETDB = 2000L;
    private static final long JOB_LAG_LIMIT_TUNNEL;
    public static final String PROP_MAX_TUNNELS = "router.maxParticipatingTunnels";
    public static final int DEFAULT_MAX_TUNNELS;
    private static final String PROP_MAX_PROCESSINGTIME = "router.defaultProcessingTimeThrottle";
    private static final long DEFAULT_REJECT_STARTUP_TIME = 180000L;
    private static final long MIN_REJECT_STARTUP_TIME = 90000L;
    private static final String PROP_REJECT_STARTUP_TIME = "router.rejectStartupTime";
    private static final int DEFAULT_MIN_THROTTLE_TUNNELS;
    private static final String PROP_MIN_THROTTLE_TUNNELS = "router.minThrottleTunnels";
    private static final int DEFAULT_MAX_PROCESSINGTIME;
    public static final int TUNNEL_ACCEPT = 0;
    private static final int PREPROCESSED_SIZE = 1024;
    private static final long[] RATES;
    public static final int DEFAULT_MESSAGES_PER_TUNNEL_ESTIMATE = 40;
    private static final int MIN_AVAILABLE_BPS = 4096;
    private static final String LIMIT_STR;

    public RouterThrottleImpl(RouterContext context) {
        this._context = context;
        this._log = context.logManager().getLog(RouterThrottleImpl.class);
        this.setTunnelStatus();
        this._rejectStartupTime = Math.max(90000L, this._context.getProperty(PROP_REJECT_STARTUP_TIME, 180000L));
        this._context.simpleTimer2().addEvent(new ResetStatus(), 5000L + this._rejectStartupTime);
        this._context.statManager().createRateStat("router.throttleNetworkCause", "JobQueue lag when an I2NP event was throttled", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelBandwidthExceeded", "Bandwidth allocated when we refuse to build tunnel (bandwidth exceeded)", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelBytesAllowed", "Bytes permitted to be sent when we get a tunnel request", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelBytesUsed", "Used B/s at request (period = max KB/s)", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelCause", "JobQueue lag when a tunnel request was throttled", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelMaxExceeded", "Transit tunnels when max limit reached", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("router.throttleTunnelProbTooFast", "Transit tunnels beyond previous 1h average when we throttle", "Router [Throttle]", RATES);
        this._context.statManager().createRateStat("tunnel.bytesAllocatedAtAccept", "Allocated bytes for transit tunnels when we accepted a request", "Tunnels [Participating]", RATES);
    }

    @Override
    public boolean acceptNetworkMessage() {
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > 2000L && this._context.router().getUptime() > 60000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Throttling Network Reader -> Job lag is " + lag + "ms");
            }
            this._context.statManager().addRateData("router.throttleNetworkCause", lag);
            return false;
        }
        return true;
    }

    @Override
    @Deprecated
    public boolean acceptNetDbLookupRequest(Hash key) {
        long lag = this._context.jobQueue().getMaxLag();
        if (lag > 2000L) {
            if (this._log.shouldDebug()) {
                this._log.debug("Refusing NetDb Lookup request -> Job lag is " + lag + "ms");
            }
            this._context.statManager().addRateData("router.throttleNetDbCause", lag);
            return false;
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public int acceptTunnelRequest() {
        double bytesAllocated;
        int numTunnels;
        Rate r;
        RateStat rs;
        RateAverages ra;
        block32: {
            double avg;
            block33: {
                Rate avgTunnels;
                boolean highload;
                int maxTunnels;
                block31: {
                    if (this._context.router().gracefulShutdownInProgress()) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Refusing all Tunnel Requests -> Graceful shutdown in progress...");
                        }
                        this.setShutdownStatus();
                        return 30;
                    }
                    if (this._context.router().getUptime() < this._rejectStartupTime && !this._context.router().isHidden()) {
                        this.setTunnelStatus("[starting]" + RouterThrottleImpl._x("Starting up") + "&hellip;");
                    } else if (this._context.router().isHidden()) {
                        this.setTunnelStatus("[hidden]" + RouterThrottleImpl._x("Declining all tunnel requests:<br>" + RouterThrottleImpl._x("Hidden Mode")));
                        return 30;
                    }
                    ra = RateAverages.getTemp();
                    maxTunnels = this._context.getProperty(PROP_MAX_TUNNELS, DEFAULT_MAX_TUNNELS);
                    rs = this._context.statManager().getRate("transport.sendProcessingTime");
                    r = null;
                    if (rs != null) {
                        r = rs.getRate(60000L);
                    }
                    if (r != null) {
                        r.computeAverages(ra, false);
                        int maxProcessingTime = this._context.getProperty(PROP_MAX_PROCESSINGTIME, DEFAULT_MAX_PROCESSINGTIME);
                        if ((ra.getAverage() > (double)maxProcessingTime * 0.9 || ra.getCurrent() > (double)maxProcessingTime || ra.getLast() > (double)maxProcessingTime) && maxTunnels > 0) {
                            if (this._log.shouldInfo()) {
                                this._log.warn("Refusing Tunnel Request -> Message processing congestion\n* Current: " + (int)ra.getCurrent() + "ms\n* Last: " + (int)ra.getLast() + "ms\n* Average: " + (int)ra.getAverage() + "ms\n* Max time to process: " + maxProcessingTime + "ms");
                            } else if (this._log.shouldWarn()) {
                                this._log.warn("Refusing Tunnel Request -> Message processing congestion");
                            }
                            this.setTunnelStatus("[rejecting/overload]" + RouterThrottleImpl._x("Declining Tunnel Requests:<br>" + RouterThrottleImpl._x("High message delay")));
                            return 30;
                        }
                    }
                    if ((numTunnels = this._context.tunnelManager().getParticipatingCount()) >= maxTunnels) {
                        if (maxTunnels > 0) {
                            if (this._log.shouldWarn()) {
                                this._log.warn("Refusing Tunnel Request -> Already participating in " + numTunnels + " (Max: " + maxTunnels + ")");
                            }
                            this._context.statManager().addRateData("router.throttleTunnelMaxExceeded", numTunnels);
                            this.setTunnelStatus("[rejecting/max]" + RouterThrottleImpl._x("Declining requests: " + RouterThrottleImpl._x("Limit reached")));
                            return 30;
                        }
                        if (this._log.shouldWarn()) {
                            this._log.warn("Refusing Tunnel Request -> Disabled by configuration");
                        }
                        this._context.statManager().addRateData("router.throttleTunnelMaxExceeded", numTunnels);
                        this.setTunnelStatus("[disabled]" + RouterThrottleImpl._x("Declining Tunnel Requests:<br>" + RouterThrottleImpl._x("Participation disabled")));
                        return 30;
                    }
                    long lag = this._context.jobQueue().getMaxLag();
                    boolean bl = highload = lag > 1000L && SystemVersion.getCPULoadAvg() > 95;
                    if (!highload) break block31;
                    this.setTunnelStatus("[rejecting/overload]" + RouterThrottleImpl._x("Rejecting all tunnel requests:<br>" + RouterThrottleImpl._x("High system load")));
                    break block32;
                }
                if (numTunnels <= this.getMinThrottleTunnels() || DEFAULT_MAX_TUNNELS < maxTunnels || (avgTunnels = this._context.statManager().getRate("tunnel.participatingTunnels").getRate(600000L)) == null) break block32;
                avg = avgTunnels.getAvgOrLifetimeAvg();
                double tunnelGrowthFactor = SystemVersion.isSlow() || highload ? this.getTunnelGrowthFactor() : this.getTunnelGrowthFactor() * 3.0 / 2.0;
                int min = this.getMinThrottleTunnels();
                if (avg < (double)min) {
                    avg = min;
                }
                if (!(avg > 0.0) || !(avg * tunnelGrowthFactor < (double)numTunnels)) break block33;
                double probAccept = avg * tunnelGrowthFactor / (double)numTunnels;
                probAccept *= probAccept;
                int v = this._context.random().nextInt(100);
                if ((double)v < probAccept * 100.0) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Probabalistically accepting Tunnel Request (p=" + probAccept + " v=" + v + " avg=" + avg + " current=" + numTunnels + ")");
                    }
                    break block32;
                } else {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Probabalistically refusing Tunnel Request (avg=" + avg + " current=" + numTunnels + ")");
                    }
                    this._context.statManager().addRateData("router.throttleTunnelProbTooFast", (long)((double)numTunnels - avg));
                    if (probAccept <= 0.5) {
                        this.setTunnelStatus("[rejecting/overload]" + RouterThrottleImpl._x("Rejecting most tunnel requests:<br>" + RouterThrottleImpl._x("High number of requests")));
                        return 10;
                    }
                    if (probAccept <= 0.9) {
                        this.setTunnelStatus("[accepting]" + RouterThrottleImpl._x("Accepting most tunnel requests"));
                        return 10;
                    }
                    if (numTunnels > 0) {
                        this.setTunnelStatus("[accepting]" + RouterThrottleImpl._x("Accepting tunnel requests"));
                        return 10;
                    }
                    this.setTunnelStatus("[ready]" + RouterThrottleImpl._x("Accepting tunnel requests"));
                    return 10;
                }
            }
            if (this._log.shouldInfo()) {
                this._log.info("Accepting Tunnel Request -> Tunnel count average is " + avg + " and we only have " + numTunnels + ")");
            }
        }
        double tunnelTestTimeGrowthFactor = this.getTunnelTestTimeGrowthFactor();
        Rate tunnelTestTime1m = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(60000L);
        Rate tunnelTestTime10m = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(600000L);
        if (tunnelTestTime1m != null && tunnelTestTime10m != null && tunnelTestTime1m.getLastEventCount() > 0L) {
            double avg1m = tunnelTestTime1m.getAverageValue();
            double avg10m = tunnelTestTime10m.getAvgOrLifetimeAvg();
            if (avg10m < 5000.0) {
                avg10m = 5000.0;
            }
            if (avg10m > 0.0 && avg1m > avg10m * tunnelTestTimeGrowthFactor) {
                double probAccept = avg10m * tunnelTestTimeGrowthFactor / avg1m;
                probAccept *= probAccept;
                int v = this._context.random().nextInt(100);
                if ((double)v < probAccept * 100.0 && this._log.shouldInfo()) {
                    this._log.info("Probabalistically accepting Tunnel Request (p=" + probAccept + " v=" + v + " test time avg 1m=" + avg1m + " 10m=" + avg10m + ")");
                }
            }
        }
        rs = this._context.statManager().getRate("tunnel.participatingMessageCountAvgPerTunnel");
        r = null;
        double messagesPerTunnel = 0.0;
        if (rs != null && (r = rs.getRate(60000L)) != null) {
            messagesPerTunnel = r.computeAverages(ra, true).getAverage();
        }
        if (messagesPerTunnel < 40.0) {
            messagesPerTunnel = 40.0;
        }
        if (!this.allowTunnel(bytesAllocated = messagesPerTunnel * (double)numTunnels * 1024.0, numTunnels)) {
            this._context.statManager().addRateData("router.throttleTunnelBandwidthExceeded", (long)bytesAllocated);
            return 30;
        }
        this._context.statManager().addRateData("tunnel.bytesAllocatedAtAccept", (long)bytesAllocated, 600000L);
        return 0;
    }

    private boolean allowTunnel(double bytesAllocated, int numTunnels) {
        boolean reject;
        double probReject;
        int maxKBpsIn = this._context.bandwidthLimiter().getInboundKBytesPerSecond();
        int maxKBpsOut = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        int maxKBps = Math.min(maxKBpsIn, maxKBpsOut);
        int usedIn = Math.min(this._context.router().get1sRateIn(), this._context.router().get15sRateIn());
        int usedOut = Math.min(this._context.router().get1sRate(true), this._context.router().get15sRate(true));
        int used = Math.max(usedIn, usedOut);
        int availBps = Math.min(maxKBpsIn * 1024 * 9 / 10 - usedIn, maxKBpsOut * 1024 * 9 / 10 - usedOut);
        if (availBps < 4096) {
            if (this._log.shouldWarn()) {
                this._log.warn("Rejecting participating tunnel requests \n* Available bandwidth (" + availBps + "B/s) is less than minimum required (" + 4096 + "B/s)");
            }
            this.setTunnelStatus("[rejecting/max]" + LIMIT_STR);
            return false;
        }
        double share = this._context.router().getSharePercentage();
        used = Math.min(used, (int)(bytesAllocated / 600.0));
        availBps = Math.min(availBps, (int)((double)(maxKBps * 1024) * share - (double)used));
        this._context.statManager().addRateData("router.throttleTunnelBytesUsed", used, maxKBps);
        this._context.statManager().addRateData("router.throttleTunnelBytesAllowed", availBps, (long)bytesAllocated);
        int used1mIn = this._context.router().get1mRateIn();
        int used1mOut = this._context.router().get1mRate(true);
        long overage = Math.max(used1mIn - maxKBpsIn * 1024, used1mOut - maxKBpsOut * 1024);
        if (overage > 0L && (float)overage / ((float)maxKBps * 1024.0f) > this._context.random().nextFloat()) {
            this._log.warn("Rejecting participating Tunnel Request \n* 1 minute rate (" + overage + " over) indicates overload.");
            this.setTunnelStatus("[rejecting/overload]" + LIMIT_STR);
            return false;
        }
        if (availBps <= 0) {
            probReject = 1.0;
            reject = true;
            this._log.warn("Rejecting participating tunnel -> Insufficient bandwidth available\n* Available: " + availBps + "; Maximum allocated: " + maxKBps + "; In use: " + used + "\n* Active tunnels: " + numTunnels + "; Estimated bandwidth required = " + bytesAllocated);
        } else {
            float maxBps = (float)maxKBps * 1024.0f * 0.9f - 4096.0f;
            float pctFull = (maxBps - (float)availBps) / maxBps;
            if (pctFull < 0.83f) {
                probReject = 0.0;
                reject = false;
                if (this._log.shouldDebug()) {
                    this._log.debug("Accept avail / maxK / used " + availBps + " / " + maxKBps + " / " + used + "\n* pReject = 0 numTunnels = " + numTunnels + " est = " + bytesAllocated);
                }
            } else {
                probReject = Math.pow(pctFull, 16.0);
                double rand = this._context.random().nextFloat();
                boolean bl = reject = rand <= probReject;
                if (reject) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Reject avail / maxK / used " + availBps + " / " + maxKBps + " / " + used + "\n* pReject = " + probReject + " pFull = " + pctFull + " numTunnels = " + numTunnels + " rand = " + rand + " est = " + bytesAllocated);
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Accept avail / maxK / used " + availBps + " / " + maxKBps + " / " + used + "\n* pReject = " + probReject + " pFull = " + pctFull + " numTunnels = " + numTunnels + " rand = " + rand + " est = " + bytesAllocated);
                }
            }
        }
        if (probReject >= 0.9) {
            this.setTunnelStatus("[rejecting]" + LIMIT_STR);
        } else if (probReject >= 0.5) {
            this.setTunnelStatus("[rejecting/bandwidth]" + RouterThrottleImpl._x("Declining requests: Bandwidth limit"));
        } else if (probReject >= 0.1) {
            this.setTunnelStatus("[accepting]" + RouterThrottleImpl._x("Accepting most tunnel requests"));
        } else {
            this.setTunnelStatus("[accepting]" + RouterThrottleImpl._x("Accepting tunnel requests"));
        }
        return !reject;
    }

    private int getMinThrottleTunnels() {
        return this._context.getProperty(PROP_MIN_THROTTLE_TUNNELS, DEFAULT_MIN_THROTTLE_TUNNELS);
    }

    private double getTunnelGrowthFactor() {
        try {
            String p = this._context.getProperty("router.tunnelGrowthFactor");
            if (p == null) {
                return 1.5;
            }
            return Double.parseDouble(p);
        }
        catch (NumberFormatException nfe) {
            return 1.5;
        }
    }

    private double getTunnelTestTimeGrowthFactor() {
        try {
            String p = this._context.getProperty("router.tunnelTestTimeGrowthFactor");
            if (p == null) {
                return 1.5;
            }
            return Double.parseDouble(p);
        }
        catch (NumberFormatException nfe) {
            return 1.5;
        }
    }

    @Override
    public long getMessageDelay() {
        RateStat rs = this._context.statManager().getRate("transport.sendProcessingTime");
        if (rs == null) {
            return 0L;
        }
        Rate delayRate = rs.getRate(60000L);
        return (long)delayRate.getAverageValue();
    }

    @Override
    public long getTunnelLag() {
        Rate lagRate = this._context.statManager().getRate("tunnel.testSuccessTime").getRate(600000L);
        return (long)lagRate.getAverageValue();
    }

    @Override
    public String getTunnelStatus() {
        return this._tunnelStatus;
    }

    @Override
    public String getLocalizedTunnelStatus() {
        return Translate.getString(this._tunnelStatus, this._context, "net.i2p.router.util.messages");
    }

    private void setTunnelStatus() {
        this.setTunnelStatus("[starting]" + RouterThrottleImpl._x("Starting up") + "&hellip;");
    }

    public static boolean isShuttingDown(RouterContext _context) {
        int code = _context.router().scheduledGracefulExitCode();
        return 2 == code || 3 == code;
    }

    @Override
    public void setShutdownStatus() {
        if (RouterThrottleImpl.isShuttingDown(this._context)) {
            this.setTunnelStatus("[shutdown]" + RouterThrottleImpl._x("Declining requests") + ": " + RouterThrottleImpl._x("Shutting down") + "&hellip;");
        } else {
            this.setTunnelStatus("[shutdown]" + RouterThrottleImpl._x("Declining requests") + ": " + RouterThrottleImpl._x("Restarting") + "&hellip;");
        }
    }

    @Override
    public void cancelShutdownStatus() {
        int maxTunnels = this._context.getProperty(PROP_MAX_TUNNELS, DEFAULT_MAX_TUNNELS);
        RouterInfo ri = this._context.router().getRouterInfo();
        if (maxTunnels > 0 && !this._context.router().isHidden() && ri != null && !ri.getBandwidthTier().equals("K")) {
            this.setTunnelStatus("[accepting]" + RouterThrottleImpl._x("Accepting tunnel requests"));
        } else {
            this.setTunnelStatus("[rejecting/disabled]" + RouterThrottleImpl._x("Declining Tunnel Requests"));
        }
    }

    @Override
    public void setTunnelStatus(String msg) {
        this._tunnelStatus = msg;
    }

    private static final String _x(String s) {
        return s;
    }

    static {
        long l = JOB_LAG_LIMIT_TUNNEL = SystemVersion.isSlow() ? 1500L : 1000L;
        DEFAULT_MAX_TUNNELS = SystemVersion.isSlow() ? 2000 : (SystemVersion.getMaxMemory() < 0x20000000L ? 5000 : (SystemVersion.getCores() >= 8 ? 12000 : 8000));
        DEFAULT_MIN_THROTTLE_TUNNELS = SystemVersion.isSlow() ? 1500 : 3000;
        DEFAULT_MAX_PROCESSINGTIME = SystemVersion.isSlow() ? 3000 : 2000;
        RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
        LIMIT_STR = RouterThrottleImpl._x("Declining requests: Bandwidth limit");
    }

    private class ResetStatus
    implements SimpleTimer.TimedEvent {
        private ResetStatus() {
        }

        @Override
        public void timeReached() {
            if (RouterThrottleImpl.this._tunnelStatus.contains(RouterThrottleImpl._x("Starting up"))) {
                RouterThrottleImpl.this.cancelShutdownStatus();
            }
        }
    }
}

