/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.crypto;

import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.crypto.TagSetHandle;
import net.i2p.data.DataHelper;
import net.i2p.data.PublicKey;
import net.i2p.data.SessionKey;
import net.i2p.data.SessionTag;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;

public class TransientSessionKeyManager
extends SessionKeyManager {
    private final Log _log;
    private final Map<PublicKey, OutboundSession> _outboundSessions;
    private final Map<SessionTag, TagSet> _inboundTagSets;
    protected final I2PAppContext _context;
    private volatile boolean _alive;
    private final AtomicInteger _rcvTagSetID = new AtomicInteger();
    private final AtomicInteger _sentTagSetID = new AtomicInteger();
    private final int _tagsToSend;
    private final int _lowThreshold;
    private static final long SESSION_TAG_DURATION_MS = 720000L;
    private static final long SESSION_LIFETIME_MAX_MS = 840000L;
    private static final long SESSION_TAG_EXPIRATION_WINDOW = 90000L;
    public static final int MAX_INBOUND_SESSION_TAGS = 800000;
    public static final int DEFAULT_TAGS = 40;
    public static final int LOW_THRESHOLD = 30;
    private static final boolean USE_UNACKED_TAGS = false;

    public TransientSessionKeyManager(I2PAppContext context) {
        this(context, 40, 30);
    }

    public TransientSessionKeyManager(I2PAppContext context, int tagsToSend, int lowThreshold) {
        super(context);
        if (tagsToSend <= 0 || tagsToSend > 128 || lowThreshold <= 0 || lowThreshold > 128) {
            throw new IllegalArgumentException();
        }
        this._tagsToSend = tagsToSend;
        this._lowThreshold = lowThreshold;
        this._log = context.logManager().getLog(TransientSessionKeyManager.class);
        this._context = context;
        this._outboundSessions = new HashMap<PublicKey, OutboundSession>(64);
        this._inboundTagSets = new HashMap<SessionTag, TagSet>(128);
        context.statManager().createRateStat("crypto.sessionTagsExpired", "Number of expired tags/sessions", "Encryption", new long[]{60000L, 600000L, 3600000L, 10800000L});
        context.statManager().createRateStat("crypto.sessionTagsRemaining", "Number of remaining tags/sessions after a cleanup", "Encryption", new long[]{60000L, 600000L, 3600000L, 10800000L});
        this._alive = true;
        this._context.simpleTimer2().addEvent(new CleanupEvent(), 60000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void shutdown() {
        this._alive = false;
        Map<Object, Object> map = this._inboundTagSets;
        synchronized (map) {
            this._inboundTagSets.clear();
        }
        map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<TagSet> getInboundTagSets() {
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            return new HashSet<TagSet>(this._inboundTagSets.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<OutboundSession> getOutboundSessions() {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return new HashSet<OutboundSession>(this._outboundSessions.values());
        }
    }

    @Override
    public SessionKey getCurrentKey(PublicKey target) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return null;
        }
        long now = this._context.clock().now();
        if (sess.getLastUsedDate() < now - 840000L) {
            if (this._log.shouldInfo()) {
                this._log.info("Expiring old session key established on " + new Date(sess.getEstablishedDate()) + " but not used for " + (now - sess.getLastUsedDate()) + "ms with target " + TransientSessionKeyManager.toString(target));
            }
            return null;
        }
        return sess.getCurrentKey();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKey getCurrentOrNewKey(PublicKey target) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            OutboundSession sess = this._outboundSessions.get(target);
            if (sess != null) {
                long now = this._context.clock().now();
                if (sess.getLastUsedDate() < now - 840000L) {
                    sess = null;
                }
            }
            if (sess == null) {
                SessionKey key = this._context.keyGenerator().generateSessionKey();
                this.createAndReturnSession(target, key);
                return key;
            }
            return sess.getCurrentKey();
        }
    }

    @Override
    public void createSession(PublicKey target, SessionKey key) {
        this.createAndReturnSession(target, key);
    }

    private OutboundSession createAndReturnSession(PublicKey target, SessionKey key) {
        EncType type = target.getType();
        if (type != EncType.ELGAMAL_2048) {
            throw new IllegalArgumentException("Bad public key type " + (Object)((Object)type));
        }
        if (this._log.shouldInfo()) {
            this._log.info("New Outbound session: Session key [" + key.toBase64().substring(0, 6) + "] Target: [" + TransientSessionKeyManager.toString(target).substring(0, 6) + "]");
        }
        OutboundSession sess = new OutboundSession(this._context, this._log, target, key);
        this.addSession(sess);
        return sess;
    }

    @Override
    public SessionTag consumeNextAvailableTag(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No session for " + TransientSessionKeyManager.toString(target));
            }
            return null;
        }
        if (sess.getCurrentKey().equals(key)) {
            SessionTag nxt = sess.consumeNext();
            return nxt;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Key does not match existing key, no tag");
        }
        return null;
    }

    @Override
    public int getTagsToSend() {
        return this._tagsToSend;
    }

    @Override
    public int getLowThreshold() {
        return this._lowThreshold;
    }

    @Override
    public boolean shouldSendTags(PublicKey target, SessionKey key, int lowThreshold) {
        return this.getAvailableTags(target, key) < lowThreshold || this.getAvailableTimeLeft(target, key) < 90000L;
    }

    @Override
    public int getAvailableTags(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0;
        }
        if (sess.getCurrentKey().equals(key)) {
            return sess.availableTags();
        }
        return 0;
    }

    @Override
    public long getAvailableTimeLeft(PublicKey target, SessionKey key) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            return 0L;
        }
        if (sess.getCurrentKey().equals(key)) {
            long end = sess.getLastExpirationDate();
            if (end <= 0L) {
                return 0L;
            }
            return end - this._context.clock().now();
        }
        return 0L;
    }

    @Override
    public TagSetHandle tagsDelivered(PublicKey target, SessionKey key, Set<SessionTag> sessionTags) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No session for delivered TagSet to target: " + TransientSessionKeyManager.toString(target));
            }
            sess = this.createAndReturnSession(target, key);
        } else {
            sess.setCurrentKey(key);
        }
        TagSet set = new TagSet(sessionTags, key, this._context.clock().now(), this._sentTagSetID.incrementAndGet());
        sess.addTags(set);
        if (this._log.shouldDebug()) {
            this._log.debug("Tags delivered: " + set + "\n* Target: " + TransientSessionKeyManager.toString(target));
        }
        return set;
    }

    @Override
    @Deprecated
    public void failTags(PublicKey target) {
        this.removeSession(target);
    }

    @Override
    public void failTags(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No session for failed TagSet: " + ts);
            }
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Wrong session key (wanted " + sess.getCurrentKey() + ") for failed TagSet: " + ts);
            }
            return;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Failed " + ts);
        }
        sess.failTags((TagSet)ts);
    }

    @Override
    public void tagsAcked(PublicKey target, SessionKey key, TagSetHandle ts) {
        OutboundSession sess = this.getSession(target);
        if (sess == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No session for ACKed TagSet: " + ts);
            }
            return;
        }
        if (!key.equals(sess.getCurrentKey())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Wrong session key (wanted " + sess.getCurrentKey() + ") for ACKed TagSet: " + ts);
            }
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("ACKed: " + ts);
        }
        sess.ackTags((TagSet)ts);
    }

    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags) {
        this.tagsReceived(key, sessionTags, 840000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tagsReceived(SessionKey key, Set<SessionTag> sessionTags, long expire) {
        TagSet tagSet = new TagSet(sessionTags, key, this._context.clock().now() + expire, this._rcvTagSetID.incrementAndGet());
        if (this._log.shouldDebug()) {
            this._log.debug("Received " + tagSet);
        }
        TagSet old = null;
        SessionTag dupTag = null;
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            for (SessionTag tag : sessionTags) {
                old = this._inboundTagSets.put(tag, tagSet);
                if (old == null) continue;
                if (!old.getAssociatedKey().equals(tagSet.getAssociatedKey())) {
                    this._inboundTagSets.remove(tag);
                    dupTag = tag;
                    break;
                }
                old = null;
            }
        }
        if (old != null) {
            map = this._inboundTagSets;
            synchronized (map) {
                for (SessionTag tag : old.getTags()) {
                    this._inboundTagSets.remove(tag);
                }
                for (SessionTag tag : sessionTags) {
                    this._inboundTagSets.remove(tag);
                }
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Multiple tags matching! TagSet: " + tagSet + " and old TagSet: " + old + " Tag: " + dupTag + "/" + dupTag);
                this._log.warn("Earlier tag set creation: " + old + ": key=" + old.getAssociatedKey());
                this._log.warn("Current tag set creation: " + tagSet + ": key=" + tagSet.getAssociatedKey());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearExcess(int overage) {
        long now = this._context.clock().now();
        int old = 0;
        int large = 0;
        int absurd = 0;
        int recent = 0;
        int tags = 0;
        int toRemove = overage * 2;
        this._log.logAlways(30, "TOO MANY SESSION TAGS! Starting cleanup, overage = " + overage);
        ArrayList<TagSet> removed = new ArrayList<TagSet>(toRemove);
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            for (TagSet set : this._inboundTagSets.values()) {
                int size = set.getTags().size();
                if (size > 1000) {
                    ++absurd;
                }
                if (size > 100) {
                    ++large;
                }
                if (set.getDate() - now < 180000L) {
                    ++old;
                    removed.add(set);
                    continue;
                }
                if (set.getDate() - now > 480000L) {
                    ++recent;
                    continue;
                }
                if (removed.size() >= toRemove) continue;
                removed.add(set);
            }
            for (int i = 0; i < removed.size(); ++i) {
                TagSet cur = (TagSet)removed.get(i);
                for (SessionTag tag : cur.getTags()) {
                    this._inboundTagSets.remove(tag);
                    ++tags;
                }
            }
        }
        this._log.logAlways(30, "TOO MANY SESSION TAGS! Removed " + removed.size() + " tag sets arbitrarily, with " + tags + " tags,where there are " + old + " long lasting sessions, " + recent + " ones created in the last few minutes, and " + large + " sessions with more than 100 tags (and " + absurd + " with more than 1000!), leaving a total of " + this._inboundTagSets.size() + " tags behind");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SessionKey consumeTag(SessionTag tag) {
        TagSet tagSet;
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            tagSet = this._inboundTagSets.remove(tag);
            if (tagSet == null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Cannot process unknown Inbound Tag [" + tag.toString().substring(0, 6) + "]");
                }
                return null;
            }
            tagSet.consume(tag);
        }
        SessionKey key = tagSet.getAssociatedKey();
        if (this._log.shouldDebug()) {
            this._log.debug("Inbound Tag [" + tag.toString().substring(0, 6) + "] processed from " + tagSet);
        }
        return key;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OutboundSession getSession(PublicKey target) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            return this._outboundSessions.get(target);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSession(OutboundSession sess) {
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            this._outboundSessions.put(sess.getTarget(), sess);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSession(PublicKey target) {
        if (target == null) {
            return;
        }
        OutboundSession session = null;
        Map<PublicKey, OutboundSession> map = this._outboundSessions;
        synchronized (map) {
            session = this._outboundSessions.remove(target);
        }
        if (session != null && this._log.shouldWarn()) {
            this._log.warn("Removing session tags with " + session.availableTags() + " available for " + (session.getLastExpirationDate() - this._context.clock().now()) + "ms more", new Exception("Removed by"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int aggressiveExpire() {
        int removed = 0;
        int remaining = 0;
        long now = this._context.clock().now();
        Map<SessionTag, TagSet> map = this._inboundTagSets;
        synchronized (map) {
            Iterator<TagSet> iter = this._inboundTagSets.values().iterator();
            while (iter.hasNext()) {
                TagSet ts = iter.next();
                if (ts.getDate() > now) continue;
                iter.remove();
                ++removed;
            }
            remaining = this._inboundTagSets.size();
            if (remaining > 500) {
                Map<SessionKey, Set<TagSet>> inboundSets = this.getInboundTagSetsBySessionKey();
                for (Map.Entry entry : inboundSets.entrySet()) {
                    SessionKey skey = (SessionKey)entry.getKey();
                    Set sets = (Set)entry.getValue();
                    int count = sets.size();
                    if (count < 10) continue;
                    if (this._log.shouldInfo()) {
                        this._log.info("Session key " + skey.toBase64() + " has " + count + " tag sets");
                    }
                    long age = Math.min(300000, Math.max(60000, 540000 - (count - 10) * 8 * 60 * 1000 / 40));
                    for (TagSet ts : sets) {
                        Set<SessionTag> tags = ts.getTags();
                        int curSize = tags.size();
                        int origSize = ts.getOriginalSize();
                        long expires = ts.getDate();
                        if (curSize != origSize || curSize <= 8 || expires >= now + 840000L - age) continue;
                        if (this._log.shouldInfo()) {
                            this._log.info("Removed unused TagSet " + ts);
                        }
                        for (SessionTag tag : tags) {
                            this._inboundTagSets.remove(tag);
                        }
                        removed += curSize;
                    }
                }
                remaining = this._inboundTagSets.size();
            }
        }
        this._context.statManager().addRateData("crypto.sessionTagsRemaining", remaining, 0L);
        if (removed > 0 && this._log.shouldInfo()) {
            this._log.info("Expired " + removed + " Inbound tags");
        }
        int oremoved = 0;
        Map<PublicKey, OutboundSession> map2 = this._outboundSessions;
        synchronized (map2) {
            Iterator<OutboundSession> iter = this._outboundSessions.values().iterator();
            while (iter.hasNext()) {
                OutboundSession outboundSession = iter.next();
                oremoved += outboundSession.expireTags();
                if (outboundSession.getLastUsedDate() >= now - 420000L || outboundSession.availableTags() > 0) continue;
                iter.remove();
                ++oremoved;
            }
        }
        if (oremoved > 0 && this._log.shouldInfo()) {
            this._log.info("Expired " + oremoved + " Outbound tags");
        }
        return removed + oremoved;
    }

    private Map<SessionKey, Set<TagSet>> getInboundTagSetsBySessionKey() {
        Set<TagSet> inbound = this.getInboundTagSets();
        HashMap<SessionKey, Set<TagSet>> inboundSets = new HashMap<SessionKey, Set<TagSet>>(inbound.size());
        for (TagSet ts : inbound) {
            HashSet<TagSet> sets = (HashSet<TagSet>)inboundSets.get(ts.getAssociatedKey());
            if (sets == null) {
                sets = new HashSet<TagSet>(4);
                inboundSets.put(ts.getAssociatedKey(), sets);
            }
            sets.add(ts);
        }
        return inboundSets;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        int size;
        StringBuilder buf = new StringBuilder(1024);
        buf.append("<h3 class=debug_inboundsessions>ElGamal Inbound Sessions</h3>\n<table>\n");
        Map<SessionKey, Set<TagSet>> inboundSets = this.getInboundTagSetsBySessionKey();
        int total = 0;
        int totalSets = 0;
        long now = this._context.clock().now();
        TreeSet<TagSet> sets = new TreeSet<TagSet>(new TagSetComparator());
        for (Map.Entry<SessionKey, Set<TagSet>> e : inboundSets.entrySet()) {
            SessionKey skey = e.getKey();
            sets.clear();
            sets.addAll((Collection<TagSet>)e.getValue());
            totalSets += sets.size();
            buf.append("\n<tr class=skm_key>\n<td><b>Session key:</b> ").append(skey.toBase64()).append("</td><td><b>Sets:</b> ").append(sets.size()).append("</td>\n</tr>\n<tr class=expiry>\n<td colspan=2>\n<ul>");
            for (TagSet ts : sets) {
                size = ts.getTags().size();
                total += size;
                buf.append("\n<li><b>ID: ").append(ts.getID());
                long expires = ts.getDate() - now;
                if (expires > 0L) {
                    buf.append(" expires:</b> ").append(DataHelper.formatDuration2(expires)).append(" with ");
                } else {
                    buf.append(" expired:</b> ").append(DataHelper.formatDuration2(0L - expires)).append(" ago with ");
                }
                buf.append(size).append('/').append(ts.getOriginalSize()).append(" tags remaining</li>");
            }
            buf.append("\n</ul>\n</td>\n</tr>\n");
            out.append(buf);
            buf.setLength(0);
        }
        buf.append("<tr>\n<th colspan=2>Total inbound tags: ").append(total).append(" (").append(DataHelper.formatSize2(32 * total)).append("B); sets: ").append(totalSets).append("; sessions: ").append(inboundSets.size()).append("</th>\n</tr>\n</table>\n<h3 class=debug_outboundsessions>ElGamal Outbound sessions</h3>\n<table>");
        total = 0;
        totalSets = 0;
        Set<OutboundSession> outbound = this.getOutboundSessions();
        for (OutboundSession sess : outbound) {
            sets.clear();
            sets.addAll(sess.getTagSets());
            totalSets += sets.size();
            buf.append("\n<tr class=debug_outboundtarget>\n<td>\n<div class=debug_targetinfo>\n<b>Session key:</b> <span class=debug_sesskey>").append(sess.getCurrentKey().toBase64()).append("</span><br>\n<b>Target public key:</b> <span class=debug_pubkey>").append(TransientSessionKeyManager.toString(sess.getTarget())).append("</span><br>\n<b>Established:</b> ").append(DataHelper.formatDuration2(now - sess.getEstablishedDate())).append(" ago&nbsp;&nbsp;&nbsp;<b>Ack Received?</b> ").append(sess.getAckReceived()).append("&nbsp;&nbsp;&nbsp;<b>Last Used:</b> ").append(DataHelper.formatDuration2(now - sess.getLastUsedDate())).append(" ago\n</div>\n</td><td><b>Sets:</b> ").append(sess.getTagSets().size()).append("</td></tr>\n<tr class=sentTags>\n<td colspan=2>\n<ul>");
            for (TagSet ts : sets) {
                size = ts.getTags().size();
                total += size;
                buf.append("\n<li><b>ID: ").append(ts.getID()).append(" Sent:</b> ").append(DataHelper.formatDuration2(now - ts.getDate())).append(" ago with ");
                buf.append(size).append('/').append(ts.getOriginalSize()).append(" tags remaining; ACKed? ").append(ts.getAcked()).append("</li>");
            }
            buf.append("\n</ul>\n</td>\n</tr>\n");
            out.append(buf);
            buf.setLength(0);
        }
        buf.append("<tr>\n<th colspan=2>Total Outbound tags: ").append(total).append(" (").append(DataHelper.formatSize2(32 * total)).append("B); sets: ").append(totalSets).append("; sessions: ").append(outbound.size()).append("</th>\n</tr>\n</table>\n");
        out.append(buf);
    }

    private static String toString(PublicKey target) {
        if (target == null) {
            return "null";
        }
        return target.toBase64();
    }

    private static class TagSet
    implements TagSetHandle {
        private final Set<SessionTag> _sessionTags;
        private final SessionKey _key;
        private final long _date;
        private final int _id;
        private final int _origSize;
        private boolean _acked;

        public TagSet(Set<SessionTag> tags, SessionKey key, long date, int id) {
            if (key == null) {
                throw new IllegalArgumentException("Missing key");
            }
            if (tags == null) {
                throw new IllegalArgumentException("Missing tags");
            }
            this._sessionTags = tags;
            this._key = key;
            this._date = date;
            this._id = id;
            this._origSize = tags.size();
        }

        public long getDate() {
            return this._date;
        }

        public int getOriginalSize() {
            return this._origSize;
        }

        public Set<SessionTag> getTags() {
            return this._sessionTags;
        }

        public SessionKey getAssociatedKey() {
            return this._key;
        }

        public void consume(SessionTag tag) {
            this._sessionTags.remove(tag);
        }

        public SessionTag consumeNext() {
            Iterator<SessionTag> iter = this._sessionTags.iterator();
            if (!iter.hasNext()) {
                return null;
            }
            SessionTag first = iter.next();
            iter.remove();
            return first;
        }

        public void setAcked() {
            this._acked = true;
        }

        public boolean getAcked() {
            return this._acked;
        }

        public int getID() {
            return this._id;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(256);
            buf.append("TagSet [").append(this._id).append("]");
            buf.append(" Size: ").append(this._sessionTags.size()).append('/').append(this._origSize);
            buf.append(" ACKed? ").append(this._acked);
            buf.append("\n* Created: ").append(new Date(this._date));
            buf.append("\n* Session key: ").append(this._key);
            return buf.toString();
        }
    }

    private static class OutboundSession {
        private final I2PAppContext _context;
        private final Log _log;
        private final PublicKey _target;
        private SessionKey _currentKey;
        private final long _established;
        private long _lastUsed;
        private final Set<TagSet> _unackedTagSets;
        private final List<TagSet> _tagSets;
        private volatile boolean _acked;
        private int _consecutiveFailures;
        private static final int MAX_FAILS = 2;

        public OutboundSession(I2PAppContext ctx, Log log, PublicKey target, SessionKey key) {
            this._context = ctx;
            this._log = log;
            this._target = target;
            this._currentKey = key;
            this._lastUsed = this._established = ctx.clock().now();
            this._unackedTagSets = new HashSet<TagSet>(4);
            this._tagSets = new ArrayList<TagSet>(6);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<TagSet> getTagSets() {
            ArrayList<TagSet> rv;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                rv = new ArrayList<TagSet>(this._unackedTagSets);
                rv.addAll(this._tagSets);
            }
            return rv;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void ackTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                if (this._unackedTagSets.remove(set)) {
                    this._tagSets.add(set);
                } else if (!this._tagSets.contains(set)) {
                    this._tagSets.add(set);
                    if (this._log.shouldWarn()) {
                        this._log.warn("ACK of unknown (previously failed?) TagSet\n* " + set);
                    }
                } else if (set.getAcked() && this._log.shouldWarn()) {
                    this._log.warn("Duplicate ACK of TagSet\n* " + set);
                }
                this._acked = true;
                this._consecutiveFailures = 0;
            }
            set.setAcked();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void failTags(TagSet set) {
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                this._unackedTagSets.remove(set);
                if (this._tagSets.remove(set) && ++this._consecutiveFailures >= 2) {
                    this._acked = false;
                    int acked = 0;
                    int unacked = 0;
                    Iterator<TagSet> iter = this._tagSets.iterator();
                    while (iter.hasNext()) {
                        TagSet ts = iter.next();
                        if (!ts.getAcked()) {
                            iter.remove();
                            this._unackedTagSets.add(ts);
                            ++unacked;
                            continue;
                        }
                        ++acked;
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn(this._consecutiveFailures + " consecutive failed TagSet deliveries to [" + this._currentKey.toBase64().substring(0, 6) + "]\n* Reverting to full ElG and un-ACKing " + unacked + " UnACKed tag sets, with " + acked + " remaining ACKed TagSets");
                    }
                }
            }
        }

        public PublicKey getTarget() {
            return this._target;
        }

        public SessionKey getCurrentKey() {
            return this._currentKey;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setCurrentKey(SessionKey key) {
            this._lastUsed = this._context.clock().now();
            if (this._currentKey != null && !this._currentKey.equals(key)) {
                List<TagSet> list = this._tagSets;
                synchronized (list) {
                    if (this._log.shouldWarn()) {
                        int dropped = 0;
                        for (TagSet set : this._tagSets) {
                            dropped += set.getTags().size();
                        }
                        this._log.warn("Rekeyed from " + this._currentKey + " to " + key + ": dropping " + dropped + " session tags", new Exception());
                    }
                    this._acked = false;
                    this._tagSets.clear();
                }
            }
            this._currentKey = key;
        }

        public long getEstablishedDate() {
            return this._established;
        }

        public long getLastUsedDate() {
            return this._lastUsed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int expireTags() {
            long now = this._context.clock().now();
            int removed = 0;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                TagSet set;
                Iterator<TagSet> iter = this._tagSets.iterator();
                while (iter.hasNext()) {
                    set = iter.next();
                    if (set.getDate() + 720000L > now) continue;
                    iter.remove();
                    ++removed;
                }
                if ((now & 0xFL) == 0L) {
                    iter = this._unackedTagSets.iterator();
                    while (iter.hasNext()) {
                        set = iter.next();
                        if (set.getDate() + 720000L > now) continue;
                        iter.remove();
                        ++removed;
                    }
                }
            }
            return removed;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public SessionTag consumeNext() {
            long now;
            this._lastUsed = now = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                while (!this._tagSets.isEmpty()) {
                    TagSet set = this._tagSets.get(0);
                    if (set.getDate() + 720000L > now) {
                        SessionTag tag = set.consumeNext();
                        if (tag != null) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("Outbound Tag [" + tag.toString().substring(0, 6) + "] processed  from " + set);
                            }
                            return tag;
                        }
                        if (this._log.shouldInfo()) {
                            this._log.info("Removing empty " + set);
                        }
                    } else if (this._log.shouldInfo()) {
                        this._log.info("Session Tag expired " + set);
                    }
                    this._tagSets.remove(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int availableTags() {
            int tags = 0;
            long now = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (int i = 0; i < this._tagSets.size(); ++i) {
                    TagSet set = this._tagSets.get(i);
                    if (set.getDate() + 720000L <= now) continue;
                    int sz = set.getTags().size();
                    if (!set.getAcked()) {
                        sz = (sz + 2) / 3;
                    }
                    tags += sz;
                }
            }
            return tags;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public long getLastExpirationDate() {
            long last = 0L;
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                for (TagSet set : this._tagSets) {
                    if (set.getDate() <= last || set.getTags().isEmpty()) continue;
                    last = set.getDate();
                }
            }
            if (last > 0L) {
                return last + 720000L;
            }
            return -1L;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addTags(TagSet set) {
            this._lastUsed = this._context.clock().now();
            List<TagSet> list = this._tagSets;
            synchronized (list) {
                this._unackedTagSets.add(set);
            }
        }

        public boolean getAckReceived() {
            return this._acked;
        }
    }

    private static class TagSetComparator
    implements Comparator<TagSet>,
    Serializable {
        private TagSetComparator() {
        }

        @Override
        public int compare(TagSet l, TagSet r) {
            int rv = (int)(l.getDate() - r.getDate());
            if (rv != 0) {
                return rv;
            }
            return l.hashCode() - r.hashCode();
        }
    }

    private class CleanupEvent
    implements SimpleTimer.TimedEvent {
        private CleanupEvent() {
        }

        @Override
        public void timeReached() {
            if (!TransientSessionKeyManager.this._alive) {
                return;
            }
            long beforeExpire = TransientSessionKeyManager.this._context.clock().now();
            int expired = TransientSessionKeyManager.this.aggressiveExpire();
            int overage = TransientSessionKeyManager.this._inboundTagSets.size() - 800000;
            if (overage > 0) {
                TransientSessionKeyManager.this.clearExcess(overage);
            }
            long expireTime = TransientSessionKeyManager.this._context.clock().now() - beforeExpire;
            TransientSessionKeyManager.this._context.statManager().addRateData("crypto.sessionTagsExpired", expired, expireTime);
            TransientSessionKeyManager.this._context.simpleTimer2().addEvent(this, 60000L);
        }
    }
}

