/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.HashSet;
import net.i2p.data.Hash;
import net.i2p.router.Job;
import net.i2p.router.MessageSelector;
import net.i2p.router.OutNetMessage;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DirectLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupSelector;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;

abstract class FloodOnlySearchJob
extends FloodSearchJob {
    private boolean _shouldProcessDSRM;
    private final HashSet<Hash> _unheardFrom;
    private OutNetMessage _out;
    protected final MessageSelector _replySelector;
    protected final ReplyJob _onReply;
    protected final Job _onTimeout;
    private static final int MIN_FOR_NO_DSRM = 4;
    private static final long SINGLE_SEARCH_MSG_TIME = 10000L;

    public FloodOnlySearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        this._timeoutMs = Math.min(timeoutMs, 10000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._unheardFrom = new HashSet(CONCURRENT_SEARCHES);
        this._replySelector = new FloodOnlyLookupSelector(ctx, this);
        this._onReply = new FloodOnlyLookupMatchJob(ctx, this);
        this._onTimeout = new FloodOnlyLookupTimeoutJob(ctx, this);
    }

    protected FloodOnlySearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, false);
        this._timeoutMs = timeoutMs;
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._unheardFrom = new HashSet(1);
        this._replySelector = new FloodOnlyLookupSelector(ctx, this);
        this._onReply = new DirectLookupMatchJob(ctx, this);
        this._onTimeout = new FloodOnlyLookupTimeoutJob(ctx, this);
    }

    public boolean shouldProcessDSRM() {
        return this._shouldProcessDSRM;
    }

    @Override
    public void runJob() {
        throw new UnsupportedOperationException("use override");
    }

    @Override
    public String getName() {
        return "Start NetDb Search for Floodfill";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    int decrementRemaining(Hash peer) {
        HashSet<Hash> hashSet = this._unheardFrom;
        synchronized (hashSet) {
            this._unheardFrom.remove(peer);
            return this.decrementRemaining();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void failed() {
        FloodOnlySearchJob floodOnlySearchJob = this;
        synchronized (floodOnlySearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this.getContext().messageRegistry().unregisterPending(this._out);
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldInfo()) {
            int timeRemaining = (int)(this._expiration - this.getContext().clock().now());
            this._log.info("Floodfill search for " + this._key + " failed with " + timeRemaining + " remaining after " + time);
        }
        HashSet<Hash> hashSet = this._unheardFrom;
        synchronized (hashSet) {
            for (Hash h : this._unheardFrom) {
                this.getContext().profileManager().dbLookupFailed(h);
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.failedTime", time);
        for (Job j : this._onFailed) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFailed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void success() {
        FloodOnlySearchJob floodOnlySearchJob = this;
        synchronized (floodOnlySearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
            super.success();
        }
        if (this._log.shouldInfo()) {
            this._log.info("Floodfill search for " + this._key + " successful");
        }
        long time = System.currentTimeMillis() - this._created;
        HashSet<Hash> hashSet = this._unheardFrom;
        synchronized (hashSet) {
            if (this._unheardFrom.size() == 1) {
                Hash peer = this._unheardFrom.iterator().next();
                this.getContext().profileManager().dbLookupSuccessful(peer, time);
            }
        }
        this._facade.complete(this._key);
        this.getContext().statManager().addRateData("netDb.successTime", time);
        for (Job j : this._onFind) {
            this.getContext().jobQueue().addJob(j);
        }
    }
}

