/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.HandleFloodfillDatabaseLookupMessageJob;
import net.i2p.util.Log;
import net.i2p.util.RandomSource;

public class FloodfillDatabaseLookupMessageHandler
implements HandlerJobBuilder {
    private RouterContext _context;
    private FloodfillNetworkDatabaseFacade _facade;
    private Log _log;
    private final long _msgIDBloomXor = RandomSource.getInstance().nextLong(0xFFFFFFFFL);

    public FloodfillDatabaseLookupMessageHandler(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        this._context = context;
        this._facade = facade;
        this._log = context.logManager().getLog(FloodfillDatabaseLookupMessageHandler.class);
        this._context.statManager().createRateStat("netDb.lookupsReceived", "NetDb lookups we have received", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsDropped", "NetDb lookups we dropped (throttled)", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsHandled", "NetDb lookups we have handled", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatched", "Successful NetDb lookups", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLeaseSet", "Successful NetDb LeaseSet lookups", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedReceivedPublished", "Successful NetDb lookups (published to us)", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLocalClosest", "NetDb lookups received for local data (closest peer)", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedLocalNotClosest", "NetDb lookups received for local data (not closest peer)", "NetworkDatabase", new long[]{60000L, 3600000L});
        this._context.statManager().createRateStat("netDb.lookupsMatchedRemoteNotClosest", "NetDb lookups received for remote data (not closest peer)", "NetworkDatabase", new long[]{60000L, 3600000L});
    }

    @Override
    public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
        String searchType;
        this._context.statManager().addRateData("netDb.lookupsReceived", 1L);
        DatabaseLookupMessage dlm = (DatabaseLookupMessage)receivedMessage;
        boolean ourRI = dlm.getSearchKey() != null && dlm.getSearchKey().equals(this._context.routerHash());
        Hash us = this._context.routerHash();
        boolean ffMode = this._context.netDb().floodfillEnabled() || this._context.getBooleanProperty("router.floodfillParticipant");
        DatabaseLookupMessage.Type type = dlm.getSearchType();
        String string = searchType = type != null ? type.toString().replace("EXPL", "Exploratory").replace("RI", "RouterInfo") : "";
        if (!this._facade.shouldThrottleLookup(dlm.getFrom(), dlm.getReplyTunnel()) && !this._facade.shouldBanLookup(dlm.getFrom(), dlm.getReplyTunnel()) && (ffMode || ourRI || type != DatabaseLookupMessage.Type.EXPL) || this._context.routerHash().equals(dlm.getSearchKey()) || dlm.getFrom() == us) {
            if (this._log.shouldInfo()) {
                this._log.info("Replying to " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] via [TunnelId " + dlm.getReplyTunnel() + "]");
            }
            HandleFloodfillDatabaseLookupMessageJob j = new HandleFloodfillDatabaseLookupMessageJob(this._context, dlm, from, fromHash, this._msgIDBloomXor);
            return j;
        }
        if (!(ffMode || type != DatabaseLookupMessage.Type.EXPL && type != DatabaseLookupMessage.Type.ANY)) {
            if (this._log.shouldInfo()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> We are not a floodfill [TunnelId " + dlm.getReplyTunnel() + "]");
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> We are not a floodfill");
            }
            this._context.statManager().addRateData("netDb.nonFFLookupsDropped", 1L);
            return null;
        }
        if (!ffMode && !this._facade.shouldBanLookup(dlm.getFrom(), dlm.getReplyTunnel())) {
            if (this._log.shouldInfo()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> We are not a floodfill [TunnelId " + dlm.getReplyTunnel() + "]");
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> We are not a floodfill");
            }
            this._context.statManager().addRateData("netDb.lookupsDropped", 1L);
            return null;
        }
        if (this._facade.shouldBanLookup(dlm.getFrom(), dlm.getReplyTunnel())) {
            if (this._log.shouldInfo()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] and banning for 3m -> Max 90 requests in 30s exceeded [TunnelId " + dlm.getReplyTunnel() + "]");
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] and banning for 3m -> Max 90 requests in 30s exceeded");
            }
            if (dlm.getFrom() != null) {
                this._context.banlist().banlistRouter(dlm.getFrom(), " <b>\u279c</b> Excessive lookup requests", null, null, this._context.clock().now() + 180000L);
                this._context.commSystem().mayDisconnect(dlm.getFrom());
            }
            this._context.statManager().addRateData("netDb.lookupsDropped", 1L);
            return null;
        }
        if (this._log.shouldInfo()) {
            this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> Max 60 requests in 90s exceeded [TunnelId " + dlm.getReplyTunnel() + "]");
        } else if (this._log.shouldWarn()) {
            this._log.warn("Dropping " + searchType.replace("LS", "LeaseSet") + " Lookup from [" + dlm.getFrom().toBase64().substring(0, 6) + "] for [" + dlm.getSearchKey().toBase64().substring(0, 6) + "] -> Max 60 requests in 90s exceeded");
        }
        this._context.statManager().addRateData("netDb.lookupsDropped", 1L);
        return null;
    }
}

