/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.List;
import net.i2p.crypto.SigType;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillRouterInfoFloodJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.TransportUtil;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class FloodfillMonitorJob
extends JobImpl {
    private final Log _log;
    private final FloodfillNetworkDatabaseFacade _facade;
    private long _lastChanged;
    private boolean _deferredFlood;
    private static final int REQUEUE_DELAY = 900000;
    private static final long MIN_UPTIME = 0x6DDD00L;
    private static final long MIN_CHANGE_DELAY = 10800000L;
    private static final int MIN_FF = 2000;
    private static final int MAX_FF = 999999;
    static final String PROP_FLOODFILL_PARTICIPANT = "router.floodfillParticipant";
    private Boolean autoff = true;

    public FloodfillMonitorJob(RouterContext context, FloodfillNetworkDatabaseFacade facade) {
        super(context);
        this._facade = facade;
        this._log = context.logManager().getLog(FloodfillMonitorJob.class);
    }

    @Override
    public String getName() {
        return "Monitor Floodfill Pool";
    }

    @Override
    public synchronized void runJob() {
        if (!this.getContext().commSystem().isRunning()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Attempted to initialize Floodfill Monitor before comm system started, requeuing...");
            }
            this.requeue(100L);
            return;
        }
        boolean wasFF = this._facade.floodfillEnabled();
        boolean ff = this.shouldBeFloodfill();
        if (wasFF) {
            this.autoff = false;
        }
        this._facade.setFloodfillEnabledFromMonitor(ff);
        if (ff != wasFF) {
            if (ff) {
                if (!this.getContext().getBooleanProperty(PROP_FLOODFILL_PARTICIPANT) || this.getContext().router().getUptime() >= 180000L) {
                    this.getContext().router().eventLog().addEvent("becameFloodfill");
                }
            } else {
                this.getContext().router().eventLog().addEvent("disabledFloodfill");
            }
            this.getContext().router().rebuildRouterInfo(true);
            FloodfillRouterInfoFloodJob routerInfoFlood = new FloodfillRouterInfoFloodJob(this.getContext(), this._facade);
            if (this.getContext().router().getUptime() < 300000L) {
                if (!this._deferredFlood) {
                    this._deferredFlood = true;
                    routerInfoFlood.getTiming().setStartAfter(this.getContext().clock().now() + 300000L);
                    this.getContext().jobQueue().addJob(routerInfoFlood);
                    if (this._log.shouldDebug()) {
                        this._log.logAlways(10, "Deferred our FloodfillRouterInfoFloodJob run because of low uptime.");
                    }
                }
            } else {
                routerInfoFlood.runJob();
                if (this._log.shouldDebug()) {
                    this._log.logAlways(10, "Running FloodfillRouterInfoFloodJob...");
                }
            }
        }
        if (this.autoff.booleanValue() && this._log.shouldInfo()) {
            this._log.info("Should we be a Floodfill? " + ff);
        }
        int delay = 450000 + this.getContext().random().nextInt(900000);
        delay = !ff ? (delay *= 4) : (delay *= 10);
        this.requeue(delay);
    }

    private boolean shouldBeFloodfill() {
        Rate rate;
        Rate rate2;
        RateStat queueStat;
        Rate rate3;
        if (!SigType.ECDSA_SHA256_P256.isAvailable()) {
            boolean wasFF = this._facade.floodfillEnabled();
            if (wasFF) {
                this.autoff = false;
            }
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("ECDSA SHA256 P256 unavailable on this router - not automatically enrolling as floodfill");
            }
            return false;
        }
        if (this.getContext().router().isHidden()) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Hidden mode enabled - not automatically enrolling as floodfill");
            }
            return false;
        }
        String enabled = this.getContext().getProperty(PROP_FLOODFILL_PARTICIPANT, "auto");
        if ("true".equals(enabled)) {
            return true;
        }
        if ("false".equals(enabled)) {
            return false;
        }
        if (this.getContext().router().gracefulShutdownInProgress()) {
            return false;
        }
        if (SystemVersion.isSlow()) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Slow processor (Arm/Android) detected on this host - not automatically enrolling as floodfill");
            }
            return false;
        }
        if (this.getContext().getBooleanProperty("i2np.laptopMode")) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Laptop mode is enabled on this router - not automatically enrolling as floodfill");
            }
            return false;
        }
        if (TransportUtil.getIPv6Config(this.getContext(), "SSU") == TransportUtil.IPv6Config.IPV6_ONLY) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("IPV4 is not active on this router - not automatically enrolling as floodfill");
            }
            return false;
        }
        Boolean ntcpEnabled = TransportManager.isNTCPEnabled(this.getContext());
        Boolean udpEnabled = this.getContext().getBooleanPropertyDefaultTrue("i2np.udp.enable");
        if (!ntcpEnabled.booleanValue()) {
            return false;
        }
        if (!udpEnabled.booleanValue()) {
            return false;
        }
        if ((!ntcpEnabled.booleanValue() || !udpEnabled.booleanValue()) && this.autoff.booleanValue() && this._log.shouldInfo()) {
            this._log.info("Either NTCP or SSU transports are disabled - not automatically enrolling as floodfill");
        }
        if (this.getContext().commSystem().isInStrictCountry()) {
            return false;
        }
        String country = this.getContext().commSystem().getOurCountry();
        if ("a1".equals(country) || "a2".equals(country)) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Cannot determine location of router - not automatically enrolling as a floodfill");
            }
            return false;
        }
        if (this.getContext().router().getUptime() < 0x6DDD00L) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Not enough uptime (min 2h required) to automatically enroll as a floodfill");
            }
            return false;
        }
        RouterInfo ri = this.getContext().router().getRouterInfo();
        if (ri == null) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("No RouterInfo for this router found - not automatically enrolling as a floodfill");
            }
            return false;
        }
        RouterIdentity ident = ri.getIdentity();
        if (ident.getSigningPublicKey().getType() == SigType.DSA_SHA1) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Our router is using a DSA SHA1 signature - not automatically enrolling as a floodfill");
            }
            return false;
        }
        char bw = ri.getBandwidthTier().charAt(0);
        if (bw != 'N' && bw != 'O' && bw != 'P' && bw != 'X') {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("Not enough upstream bandwidth allocated to automatically enroll as a floodfill");
            }
            return false;
        }
        List<Hash> floodfillPeers = this._facade.getFloodfillPeers();
        long now = this.getContext().clock().now();
        if (floodfillPeers == null || floodfillPeers.isEmpty()) {
            if (this.autoff.booleanValue() && this._log.shouldInfo()) {
                this._log.info("No floodfills in our NetDb so we're enrolling as a floodfill");
            }
            this._lastChanged = now;
            return true;
        }
        boolean wasFF = this._facade.floodfillEnabled();
        if (this._lastChanged + 10800000L > now) {
            return wasFF;
        }
        int ffcount = floodfillPeers.size();
        int failcount = 0;
        long before = now - 3600000L;
        for (Hash peer : floodfillPeers) {
            PeerProfile profile = this.getContext().profileOrganizer().getProfile(peer);
            if (profile != null && profile.getLastHeardFrom() >= before && !this.getContext().banlist().isBanlisted(peer) && !this.getContext().commSystem().wasUnreachable(peer)) continue;
            ++failcount;
        }
        if (wasFF) {
            ++ffcount;
        }
        int good = ffcount - failcount;
        boolean happy = this.getContext().router().getRouterInfo().getCapabilities().indexOf(82) >= 0;
        RateStat lagStat = this.getContext().statManager().getRate("jobQueue.jobLag");
        if (lagStat != null && (rate3 = lagStat.getRate(3600000L)) != null) {
            boolean bl = happy = happy && rate3.getAvgOrLifetimeAvg() < 25.0;
        }
        if ((queueStat = this.getContext().statManager().getRate("router.tunnelBacklog")) != null && (rate2 = queueStat.getRate(3600000L)) != null) {
            happy = happy && rate2.getAvgOrLifetimeAvg() < 5.0;
        }
        happy = happy && this._facade.getKnownRouters() >= 2000;
        happy = happy && this.getContext().commSystem().countActivePeers() >= 50;
        happy = happy && this.getContext().tunnelManager().getParticipatingCount() >= 250;
        boolean bl = happy = happy && Math.abs(this.getContext().clock().getOffset()) < 10000L;
        if (happy) {
            RouterAddress ra = this.getContext().router().getRouterInfo().getTargetAddress("SSU");
            if (ra == null) {
                happy = false;
            } else if (ra.getOption("itag0") != null) {
                happy = false;
            }
        }
        double elG = 0.0;
        RateStat stat = this.getContext().statManager().getRate("crypto.elGamal.decrypt");
        if (stat != null && (rate = stat.getRate(3600000L)) != null) {
            elG = rate.getAvgOrLifetimeAvg();
            boolean bl2 = happy = happy && elG <= 40.0;
        }
        if (this._log.shouldDebug()) {
            RouterContext rc = this.getContext();
            String log = String.format("Floodfill criteria breakdown: happy=%b, capabilities=%s, maxLag=%d, known=%d, active=%d, participating=%d, offset=%d, ssuAddr=%s ElG=%f", happy, rc.router().getRouterInfo().getCapabilities(), rc.jobQueue().getMaxLag(), this._facade.getKnownRouters(), rc.commSystem().countActivePeers(), rc.tunnelManager().getParticipatingCount(), Math.abs(rc.clock().getOffset()), rc.router().getRouterInfo().getTargetAddress("SSU").toString(), elG);
            this._log.debug(log);
        }
        if (good < 2000 && happy) {
            if (!wasFF) {
                this._lastChanged = now;
                this._log.logAlways(20, "We only have " + good + " good floodfill peers and we want at least " + 2000 + ", enrolling as a floodfill...");
            }
            return true;
        }
        if (good > 999999 || good > 2000 && !happy) {
            if (wasFF && happy) {
                this._lastChanged = now;
                this._log.logAlways(20, "We already have " + good + " good floodfill peers and we need only " + 2000 + " to " + 999999 + ", disabling floodfill role...");
            } else if (wasFF && !happy) {
                this._log.logAlways(20, "We are no longer reachable, disabling floodfill role...");
            }
            return false;
        }
        if (this._log.shouldInfo()) {
            this._log.info("We have " + good + " good floodfill peers, not changing our floodfill status -> Enabled? " + wasFF + "; reachable? " + happy);
        }
        return wasFF;
    }
}

