/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.SegmentedNetworkDatabaseFacade;
import net.i2p.util.Log;

public class FloodfillNetworkDatabaseSegmentor
extends SegmentedNetworkDatabaseFacade {
    private final Log _log;
    private final RouterContext _context;
    public static final Hash MAIN_DBID = null;
    private final FloodfillNetworkDatabaseFacade _mainDbid;

    public FloodfillNetworkDatabaseSegmentor(RouterContext context) {
        this._log = context.logManager().getLog(this.getClass());
        this._context = context;
        this._mainDbid = new FloodfillNetworkDatabaseFacade(this._context, MAIN_DBID);
    }

    private NetworkDatabaseFacade getSubNetDB(Hash id) {
        return this._context.clientManager().getClientFloodfillNetworkDatabaseFacade(id);
    }

    @Override
    public synchronized void shutdown() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Shutdown called from FNDS, shutting down main and multihome db");
        }
        this._mainDbid.shutdown();
    }

    @Override
    public synchronized void startup() {
        if (this._log.shouldLog(10)) {
            this._log.debug("Startup called from FNDS, starting up main and multihome db");
        }
        this._mainDbid.startup();
    }

    @Override
    public NetworkDatabaseFacade mainNetDB() {
        return this._mainDbid;
    }

    @Override
    public NetworkDatabaseFacade clientNetDB(Hash id) {
        NetworkDatabaseFacade fndf;
        if (this._log.shouldDebug()) {
            this._log.debug("Looked up ClientNetDB: " + id);
        }
        if (id != null && (fndf = this.getSubNetDB(id)) != null) {
            return fndf;
        }
        return this.mainNetDB();
    }
}

