/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.SelectionCollector;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;

class FloodfillPeerSelector
extends PeerSelector {
    private static final int NO_FAIL_STORE_OK = 300000;
    private static final int NO_FAIL_STORE_GOOD = 600000;
    private static final int NO_FAIL_LOOKUP_OK = 70000;
    private static final int NO_FAIL_LOOKUP_GOOD = 210000;
    private static final int MAX_GOOD_RESP_TIME = 2000;
    private static final long HEARD_AGE = 2700000L;
    private static final long INSTALL_AGE = 6300000L;
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";

    public FloodfillPeerSelector(RouterContext ctx) {
        super(ctx);
    }

    @Override
    List<Hash> selectMostReliablePeers(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, true);
    }

    @Override
    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        return this.selectNearestExplicitThin(key, maxNumRouters, peersToIgnore, kbuckets, false);
    }

    List<Hash> selectNearestExplicitThin(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets, boolean preferConnected) {
        if (peersToIgnore == null) {
            peersToIgnore = Collections.singleton(this._context.routerHash());
        } else {
            peersToIgnore.add(this._context.routerHash());
        }
        FloodfillSelectionCollector matches = new FloodfillSelectionCollector(key, peersToIgnore, maxNumRouters);
        if (kbuckets == null) {
            return new ArrayList<Hash>();
        }
        kbuckets.getAll(matches);
        List<Hash> rv = matches.get(maxNumRouters, preferConnected);
        StringBuilder buf = new StringBuilder();
        buf.append("Searching for " + maxNumRouters + " peers close to [" + key.toBase64().substring(0, 6) + "]");
        buf.append("\n* All Hashes: " + matches.size());
        buf.append("\n* Ignoring: ");
        for (Hash h : peersToIgnore) {
            buf.append("[").append(h.toBase64().substring(0, 6)).append("]").append(" ");
        }
        buf.append("\n* Matched: ");
        for (Hash h : rv) {
            buf.append("[").append(h.toBase64().substring(0, 6)).append("]").append(" ");
        }
        if (this._log.shouldDebug()) {
            this._log.debug(buf.toString());
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(ignore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipants(Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        Set<Hash> set = this._context.peerManager().getPeersByCapability('f');
        ArrayList<Hash> rv = new ArrayList<Hash>(set.size());
        for (Hash h : set) {
            if (toIgnore != null && toIgnore.contains(h) || this._context.banlist().isBanlisted(h) || this._context.banlist().isBanlistedForever(h) || this._context.profileOrganizer().peerSendsBadReplies(h)) continue;
            rv.add(h);
        }
        return rv;
    }

    List<Hash> selectFloodfillParticipants(Hash key, int maxNumRouters, KBucketSet<Hash> kbuckets) {
        Set<Hash> ignore = Collections.singleton(this._context.routerHash());
        return this.selectFloodfillParticipants(key, maxNumRouters, ignore, kbuckets);
    }

    List<Hash> selectFloodfillParticipants(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        if (toIgnore == null) {
            toIgnore = Collections.singleton(this._context.routerHash());
        } else if (!toIgnore.contains(this._context.routerHash())) {
            toIgnore = new HashSet<Hash>(toIgnore);
            toIgnore.add(this._context.routerHash());
        }
        return this.selectFloodfillParticipantsIncludingUs(key, howMany, toIgnore, kbuckets);
    }

    private List<Hash> selectFloodfillParticipantsIncludingUs(Hash key, int howMany, Set<Hash> toIgnore, KBucketSet<Hash> kbuckets) {
        int i;
        Iterator entry;
        Rate r;
        RateStat rs;
        List<Hash> sorted = this.selectFloodfillParticipants(toIgnore, kbuckets);
        Collections.sort(sorted, new XORComparator<Hash>(key));
        int found = 0;
        long now = this._context.clock().now();
        long installed = this._context.getProperty("router.firstInstalled", 0L);
        long uptime = this._context.router().getUptime();
        boolean enforceHeard = installed > 0L && now - installed > 6300000L;
        boolean shouldDisconnect = this._context.getProperty(PROP_SHOULD_DISCONNECT, false);
        double maxFailRate = 0.95;
        if (this._context.router().getUptime() > 0x6DDD00L && (rs = this._context.statManager().getRate("peer.failedLookupRate")) != null && (r = rs.getRate(3600000L)) != null) {
            double currentFailRate = r.getAverageValue();
            maxFailRate = Math.min(0.95, Math.max(0.2, 1.25 * currentFailRate));
        }
        int limit = Math.max(5, howMany + 2);
        limit = Math.min(limit, sorted.size());
        MaskedIPSet maskedIPs = new MaskedIPSet(limit * 3);
        ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
        ArrayList okff = new ArrayList(limit);
        ArrayList badff = new ArrayList(limit);
        for (int i2 = 0; found < howMany && i2 < limit && (entry = sorted.get(i2)) != null && uptime >= 45000L; ++i2) {
            Rate tunnelTestTime;
            RouterInfo routerInfo = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation((Hash)((Object)entry));
            MaskedIPSet entryIPs = new MaskedIPSet(this._context, (Hash)((Object)entry), routerInfo, 2);
            boolean sameIP = false;
            boolean noSSU = true;
            boolean noCountry = true;
            boolean isUnreachable = true;
            String country = "unknown";
            String caps = null;
            if (routerInfo == null) continue;
            caps = DataHelper.stripHTML(routerInfo.getCapabilities());
            isUnreachable = caps != null && !caps.contains("R");
            for (String ip : entryIPs) {
                if (maskedIPs.add(ip)) continue;
                sameIP = true;
            }
            if (isUnreachable) {
                badff.add(entry);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Router is unreachable");
                continue;
            }
            if (sameIP) {
                badff.add(entry);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Same /16, family, or port");
                continue;
            }
            if (routerInfo != null && now - routerInfo.getPublished() > 10800000L) {
                badff.add(entry);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: RouterInfo published over 3 hours ago");
                continue;
            }
            if (routerInfo != null && this._context.commSystem().isInStrictCountry(routerInfo)) {
                badff.add(entry);
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Router located in strict country");
                continue;
            }
            if (routerInfo.getBandwidthTier().equals("L") || routerInfo.getBandwidthTier().equals("M")) {
                badff.add(entry);
                if (this._log.shouldDebug()) {
                    this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Router is slow (L or M tier)");
                }
                if (!routerInfo.getBandwidthTier().equals("L")) continue;
                this._context.banlist().banlistRouter((Hash)((Object)entry), " <b>\u279c</b> L tier Floodfill", null, null, now + 14400000L);
                this._context.commSystem().forceDisconnect((Hash)((Object)entry));
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Banning for 4h and disconnecting from Floodfill [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> L tier");
                continue;
            }
            PeerProfile prof = this._context.profileOrganizer().getProfile((Hash)((Object)entry));
            double maxGoodRespTime = 2000.0;
            RateStat ttst = this._context.statManager().getRate("tunnel.testSuccessTime");
            if (ttst != null && (tunnelTestTime = ttst.getRate(600000L)) != null && tunnelTestTime.getAverageValue() > 500.0) {
                maxGoodRespTime = 2.0 * tunnelTestTime.getAverageValue();
            }
            if (prof != null) {
                if (enforceHeard && prof.getFirstHeardAbout() > now - 2700000L) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Router is too new (less than 45m old)");
                    }
                    badff.add(entry);
                    continue;
                }
                if (prof.getDBHistory() != null) {
                    if (prof.getDbResponseTime().getRate(3600000L).getAvgOrLifetimeAvg() < maxGoodRespTime && prof.getDBHistory().getLastStoreFailed() < now - 600000L && prof.getDBHistory().getLastLookupFailed() < now - 210000L && prof.getDBHistory().getFailedLookupRate().getRate(3600000L).getAverageValue() < maxFailRate) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Good");
                        }
                        rv.add((Hash)((Object)entry));
                        ++found;
                        continue;
                    }
                    if (prof.getDBHistory().getLastStoreFailed() <= prof.getDBHistory().getLastStoreSuccessful() || prof.getDBHistory().getLastLookupFailed() <= prof.getDBHistory().getLastLookupSuccessful() || prof.getDBHistory().getLastStoreFailed() < now - 300000L && prof.getDBHistory().getLastLookupFailed() < now - 70000L) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> OK");
                        }
                        okff.add(entry);
                        continue;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Poor profile history for this router");
                    }
                    badff.add(entry);
                    continue;
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: Profile contains no history");
                }
                badff.add(entry);
                continue;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Floodfill sort: [" + ((Hash)((Object)entry)).toBase64().substring(0, 6) + "] -> Bad: We have no profile for this router");
            }
            badff.add(entry);
        }
        StringBuilder buf = new StringBuilder();
        buf.append("Floodfill sort results:");
        if (!rv.isEmpty()) {
            buf.append("\n* Good: ");
            for (Hash hash : rv) {
                buf.append("[").append(hash.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
        }
        if (!okff.isEmpty()) {
            buf.append("\n* OK: ");
            for (Hash hash : okff) {
                buf.append("[").append(hash.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
        }
        if (!badff.isEmpty()) {
            buf.append("\n* Bad: ");
            for (Hash hash : badff) {
                buf.append("[").append(hash.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
        }
        for (i = 0; found < howMany && i < okff.size(); ++found, ++i) {
            rv.add((Hash)okff.get(i));
        }
        for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
            rv.add((Hash)badff.get(i));
        }
        return rv;
    }

    @Override
    List<Hash> selectNearest(Hash key, int maxNumRouters, Set<Hash> peersToIgnore, KBucketSet<Hash> kbuckets) {
        Hash rkey = this._context.routingKeyGenerator().getRoutingKey(key);
        if (peersToIgnore != null && peersToIgnore.contains(Hash.FAKE_HASH)) {
            peersToIgnore.addAll(this.selectFloodfillParticipants(peersToIgnore, kbuckets));
            FloodfillSelectionCollector matches = new FloodfillSelectionCollector(rkey, peersToIgnore, maxNumRouters);
            kbuckets.getAll(matches);
            return matches.get(maxNumRouters);
        }
        return this.selectFloodfillParticipantsIncludingUs(rkey, maxNumRouters, peersToIgnore, kbuckets);
    }

    private class FloodfillSelectionCollector
    implements SelectionCollector<Hash> {
        private final TreeSet<Hash> _sorted;
        private final List<Hash> _floodfillMatches;
        private final Hash _key;
        private final Set<Hash> _toIgnore;
        private int _matches;
        private final int _wanted;
        private static final int EXTRA_MATCHES = 200;

        public FloodfillSelectionCollector(Hash key, Set<Hash> toIgnore, int wanted) {
            this._key = key;
            this._sorted = new TreeSet<Hash>(new XORComparator<Hash>(key));
            this._floodfillMatches = new ArrayList<Hash>(8);
            this._toIgnore = toIgnore;
            this._wanted = wanted;
        }

        @Override
        public void add(Hash entry) {
            if (this._toIgnore != null && this._toIgnore.contains(entry)) {
                return;
            }
            if (FloodfillPeerSelector.this._context.banlist().isBanlisted(entry)) {
                return;
            }
            RouterInfo info = (RouterInfo)FloodfillPeerSelector.this._context.netDb().lookupLocallyWithoutValidation(entry);
            if (info != null && FloodfillNetworkDatabaseFacade.isFloodfill(info)) {
                this._floodfillMatches.add(entry);
            } else if (!SearchJob.onlyQueryFloodfillPeers(FloodfillPeerSelector.this._context) && this._wanted + 200 > this._matches && this._key != null) {
                this._sorted.add(entry);
            } else {
                return;
            }
            ++this._matches;
        }

        public List<Hash> get(int howMany) {
            return this.get(howMany, false);
        }

        public List<Hash> get(int howMany, boolean preferConnected) {
            int i;
            Hash entry;
            ArrayList<Hash> rv = new ArrayList<Hash>(howMany);
            ArrayList<Hash> badff = new ArrayList<Hash>(howMany);
            ArrayList<Hash> unconnectedff = new ArrayList<Hash>(howMany);
            int found = 0;
            long now = FloodfillPeerSelector.this._context.clock().now();
            RandomIterator<Hash> iter = new RandomIterator<Hash>(this._floodfillMatches);
            while (found < howMany && iter.hasNext()) {
                entry = (Hash)iter.next();
                RouterInfo info = (RouterInfo)FloodfillPeerSelector.this._context.netDb().lookupLocallyWithoutValidation(entry);
                if (info != null && now - info.getPublished() > 10800000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldDebug()) continue;
                    FloodfillPeerSelector.this._log.debug("Floodfill sort: Skipping [" + entry.toBase64().substring(0, 6) + "] -> RouterInfo published over 3h ago");
                    continue;
                }
                PeerProfile prof = FloodfillPeerSelector.this._context.profileOrganizer().getProfile(entry);
                if (prof != null && now - prof.getLastSendFailed() < 300000L) {
                    badff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldDebug()) continue;
                    FloodfillPeerSelector.this._log.debug("Floodfill sort: Skipping [" + entry.toBase64().substring(0, 6) + "] -> Poor send success rate for the last 5m");
                    continue;
                }
                if (preferConnected && !FloodfillPeerSelector.this._context.commSystem().isEstablished(entry)) {
                    unconnectedff.add(entry);
                    if (!FloodfillPeerSelector.this._log.shouldDebug()) continue;
                    FloodfillPeerSelector.this._log.debug("Floodfill sort: Skipping [" + entry.toBase64().substring(0, 6) + "] -> Not connected");
                    continue;
                }
                rv.add(entry);
                ++found;
            }
            for (i = 0; found < howMany && i < unconnectedff.size(); ++found, ++i) {
                rv.add((Hash)unconnectedff.get(i));
            }
            for (i = 0; found < howMany && i < badff.size(); ++found, ++i) {
                rv.add((Hash)badff.get(i));
            }
            for (i = rv.size(); i < howMany && !this._sorted.isEmpty(); ++i) {
                entry = this._sorted.first();
                rv.add(entry);
                this._sorted.remove(entry);
            }
            return rv;
        }

        public int size() {
            return this._matches;
        }
    }
}

