/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.crypto.EncType;
import net.i2p.data.Certificate;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.MessageSelector;
import net.i2p.router.ProfileManager;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.SingleLookupJob;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.util.Log;

class FloodfillVerifyStoreJob
extends JobImpl {
    private final Log _log;
    private final Hash _key;
    private final Hash _client;
    private volatile Hash _target;
    private final Hash _sentTo;
    private final FloodfillNetworkDatabaseFacade _facade;
    private long _expiration;
    private long _sendTime;
    private int _attempted;
    private final long _published;
    private final int _type;
    private final boolean _isRouterInfo;
    private final boolean _isLS2;
    private MessageWrapper.WrappedMessage _wrappedMessage;
    private final Set<Hash> _ignore;
    private final MaskedIPSet _ipSet;
    private static final int START_DELAY = 30000;
    private static final int VERIFY_TIMEOUT = 90000;
    private static final int MAX_PEERS_TO_TRY = 8;
    private static final int IP_CLOSE_BYTES = 3;
    private static final long[] RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FloodfillVerifyStoreJob(RouterContext ctx, Hash key, Hash client, long published, int type, Hash sentTo, Set<Hash> toSkip, FloodfillNetworkDatabaseFacade facade) {
        super(ctx);
        facade.verifyStarted(key);
        this._key = key;
        this._client = client;
        this._published = published;
        this._isRouterInfo = type == 0;
        this._isLS2 = !this._isRouterInfo && type != 1;
        this._type = type;
        this._log = ctx.logManager().getLog(this.getClass());
        this._sentTo = sentTo;
        this._facade = facade;
        this._ignore = new HashSet<Hash>(8);
        if (toSkip != null) {
            Set<Hash> set = toSkip;
            synchronized (set) {
                this._ignore.addAll(toSkip);
            }
        }
        if (sentTo != null) {
            this._ipSet = new MaskedIPSet(ctx, sentTo, 3);
            this._ignore.add(this._sentTo);
        } else {
            this._ipSet = new MaskedIPSet(16);
        }
        this.getTiming().setStartAfter(ctx.clock().now() + 30000L);
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyOK", "Time for successful Floodfill verify (ms)", "NetworkDatabase", RATES);
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyFail", "Time for failed Floodfill verify (ms)", "NetworkDatabase", RATES);
        this.getContext().statManager().createRateStat("netDb.floodfillVerifyTimeout", "Floodfill verify timeout (ms)", "NetworkDatabase", RATES);
    }

    @Override
    public String getName() {
        return "Verify NetDb Store";
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void runJob() {
        GarlicMessage sent;
        boolean isInboundExploratory;
        TunnelInfo replyTunnelInfo;
        this._target = this.pickTarget();
        if (this._target == null) {
            this._facade.verifyFinished(this._key);
            return;
        }
        RouterContext ctx = this.getContext();
        if (this._isRouterInfo || ctx.keyRing().get(this._key) != null || this._type == 7) {
            replyTunnelInfo = ctx.tunnelManager().selectInboundExploratoryTunnel(this._target);
            isInboundExploratory = true;
        } else {
            replyTunnelInfo = ctx.tunnelManager().selectInboundTunnel(this._client, this._target);
            isInboundExploratory = false;
        }
        if (replyTunnelInfo == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No Inbound tunnels to get a reply from");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        DatabaseLookupMessage lookup = this.buildLookup(replyTunnelInfo);
        TunnelInfo outTunnel = this._isRouterInfo || ctx.keyRing().get(this._key) != null || this._type == 7 ? ctx.tunnelManager().selectOutboundExploratoryTunnel(this._target) : ctx.tunnelManager().selectOutboundTunnel(this._client, this._target);
        if (outTunnel == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No Outbound tunnels to verify a store");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(this._target);
        if (peer == null) {
            if (this._log.shouldLog(30)) {
                this._log.warn("LOCAL lookup of RouterInfo for target " + this._target + " failed [DbId: " + this._facade + "]");
            }
            this._facade.verifyFinished(this._key);
            return;
        }
        EncType type = peer.getIdentity().getPublicKey().getType();
        boolean supportsElGamal = true;
        boolean supportsRatchet = false;
        if (DatabaseLookupMessage.supportsEncryptedReplies(peer)) {
            MessageWrapper.OneTimeSession sess;
            block30: {
                if (isInboundExploratory) {
                    EncType ourType = ctx.keyManager().getPublicKey().getType();
                    supportsElGamal = ourType == EncType.ELGAMAL_2048 && type == EncType.ELGAMAL_2048;
                    boolean bl = supportsRatchet = ourType == EncType.ECIES_X25519 && type == EncType.ECIES_X25519;
                    if (supportsElGamal || supportsRatchet) {
                        sess = MessageWrapper.generateSession(ctx, ctx.sessionKeyManager(), 90000L, !supportsRatchet);
                        break block30;
                    } else {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Skipping NetDbStore verify for incompatible Router " + peer);
                        }
                        this._facade.verifyFinished(this._key);
                        return;
                    }
                }
                LeaseSetKeys lsk = ctx.keyManager().getKeys(this._client);
                supportsRatchet = lsk != null && lsk.isSupported(EncType.ECIES_X25519) && DatabaseLookupMessage.supportsRatchetReplies(peer);
                boolean bl = supportsElGamal = lsk != null && lsk.isSupported(EncType.ELGAMAL_2048) && type == EncType.ELGAMAL_2048;
                if (supportsElGamal || supportsRatchet) {
                    sess = MessageWrapper.generateSession(ctx, this._client, 90000L, !supportsRatchet);
                    if (sess == null) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("No SessionKeyManager for connection to [" + this._target.toBase64().substring(0, 6) + "]");
                        }
                        this._facade.verifyFinished(this._key);
                        return;
                    }
                } else {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Skipping NetDbStore verify to [" + this._target.toBase64().substring(0, 6) + "] for ECIES or ElG-only client [" + this._client.toBase32().substring(0, 8) + "]");
                    }
                    this._facade.verifyFinished(this._key);
                    return;
                }
            }
            if (sess.tag != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Requesting AES reply from [" + this._target.toBase64().substring(0, 6) + "]\n* Session key: " + sess.key + "\n* Tag: " + sess.tag);
                }
                lookup.setReplySession(sess.key, sess.tag);
            } else {
                if (this._log.shouldDebug()) {
                    this._log.debug("Requesting AEAD reply from [" + this._target.toBase64().substring(0, 6) + "]\n* Session key: " + sess.key + "\n* Tag: " + sess.rtag);
                }
                lookup.setReplySession(sess.key, sess.rtag);
            }
        }
        if (supportsElGamal) {
            Hash fromKey = this._isRouterInfo ? null : this._client;
            this._wrappedMessage = MessageWrapper.wrap(ctx, (I2NPMessage)lookup, fromKey, peer);
            if (this._wrappedMessage == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Garlic encryption failure");
                }
                this._facade.verifyFinished(this._key);
                return;
            }
            sent = this._wrappedMessage.getMessage();
        } else {
            sent = MessageWrapper.wrap(ctx, (I2NPMessage)lookup, peer);
            if (sent == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Garlic encryption failure");
                }
                this._facade.verifyFinished(this._key);
                return;
            }
        }
        if (this._log.shouldInfo()) {
            LeaseSet ls = this._facade.lookupLeaseSetLocally(this._key);
            String tunnelName = ls != null ? this._facade.getTunnelName(ls.getDestination()) : "";
            String name = !tunnelName.equals("") ? " of '" + tunnelName + "'" : " of key";
            this._log.info("Verifying Floodfill store" + name + " [" + this._key.toBase32().substring(0, 8) + "] sent to [" + this._sentTo.toBase64().substring(0, 6) + "] -> Querying: [" + this._target.toBase64().substring(0, 6) + "]");
        }
        this._sendTime = ctx.clock().now();
        this._expiration = this._sendTime + 90000L;
        ctx.messageRegistry().registerPending(new VerifyReplySelector(), new VerifyReplyJob(this.getContext()), new VerifyTimeoutJob(this.getContext()));
        ctx.tunnelDispatcher().dispatchOutbound(sent, outTunnel.getSendTunnelId(0), this._target);
        ++this._attempted;
    }

    private Hash pickTarget() {
        List<Hash> peers;
        Certificate cert;
        Destination dest;
        Hash rkey = this.getContext().routingKeyGenerator().getRoutingKey(this._key);
        FloodfillPeerSelector sel = (FloodfillPeerSelector)this._facade.getPeerSelector();
        Certificate keyCert = null;
        if (!this._isRouterInfo && (dest = this._facade.lookupDestinationLocally(this._key)) != null && (cert = dest.getCertificate()).getCertificateType() == 5) {
            keyCert = cert;
        }
        if (keyCert != null) {
            while (!(peers = sel.selectFloodfillParticipants(rkey, 1, this._ignore, this._facade.getKBuckets())).isEmpty()) {
                Hash peer = peers.get(0);
                RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
                if (ri != null && StoreJob.shouldStoreTo(ri) && (this._type != 5 || StoreJob.shouldStoreEncLS2To(ri))) {
                    MaskedIPSet peerIPs = new MaskedIPSet(this.getContext(), ri, 3);
                    if (!this._ipSet.containsAny(peerIPs)) {
                        this._ipSet.addAll(peerIPs);
                        return peer;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Skipping Floodfill Verify for Router [" + peer.toBase64().substring(0, 6) + "] -> Too close to the store");
                    }
                } else if (this._log.shouldDebug()) {
                    this._log.debug("Skipping Floodfill Verify for Router [" + peer.toBase64().substring(0, 6) + "] -> Router is too old");
                }
                this._ignore.add(peer);
            }
        } else {
            peers = sel.selectFloodfillParticipants(rkey, 256, this._ignore, this._facade.getKBuckets());
            if (!peers.isEmpty()) {
                Collections.shuffle(peers);
                return peers.get(0);
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("No other peers to verify Floodfill with, using the one we sent to");
        }
        return this._sentTo;
    }

    private DatabaseLookupMessage buildLookup(TunnelInfo replyTunnelInfo) {
        DatabaseLookupMessage m = new DatabaseLookupMessage(this.getContext(), true);
        m.setMessageExpiration(this.getContext().clock().now() + 90000L);
        m.setReplyTunnel(replyTunnelInfo.getReceiveTunnelId(0));
        m.setFrom(replyTunnelInfo.getPeer(0));
        m.setSearchKey(this._key);
        m.setSearchType(this._isRouterInfo ? DatabaseLookupMessage.Type.RI : DatabaseLookupMessage.Type.LS);
        return m;
    }

    private void resend() {
        DatabaseEntry ds = this._facade.lookupLocally(this._key);
        if (ds != null) {
            long newDate;
            String name;
            LeaseSet ls = this._facade.lookupLeaseSetLocally(this._key);
            String tunnelName = ls != null ? this._facade.getTunnelName(ls.getDestination()) : "";
            String string = name = !tunnelName.equals("") ? " for '" + tunnelName + "'" : " for key";
            if (this._isLS2 && ds.getType() != 0 && ds.getType() != 1) {
                LeaseSet2 ls2 = (LeaseSet2)ds;
                newDate = ls2.getPublished();
            } else {
                newDate = ds.getDate();
            }
            if (newDate > this._published) {
                if (this._log.shouldInfo()) {
                    this._log.info("Floodfill Verify failed" + name + " [" + this._key.toBase32().substring(0, 8) + "] but new NetDbStore already succeeded");
                }
                return;
            }
            HashSet<Hash> toSkip = new HashSet<Hash>(8);
            if (this._sentTo != null) {
                toSkip.add(this._sentTo);
            }
            toSkip.add(this._target);
            if (this._ignore.size() < 50) {
                toSkip.addAll(this._ignore);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Floodfill Verify failed" + name + " [" + this._key.toBase32().substring(0, 8) + "] -> Starting new NetDbStore...");
            }
            this._facade.sendStore(this._key, ds, null, null, 90000L, toSkip);
        }
    }

    private class VerifyTimeoutJob
    extends JobImpl {
        public VerifyTimeoutJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Timeout Floodfill Verification";
        }

        @Override
        public void runJob() {
            if (FloodfillVerifyStoreJob.this._wrappedMessage != null) {
                FloodfillVerifyStoreJob.this._wrappedMessage.fail();
            }
            this.getContext().profileManager().dbLookupFailed(FloodfillVerifyStoreJob.this._target);
            this.getContext().statManager().addRateData("netDb.floodfillVerifyTimeout", this.getContext().clock().now() - FloodfillVerifyStoreJob.this._sendTime);
            if (FloodfillVerifyStoreJob.this._log.shouldWarn()) {
                LeaseSet ls = FloodfillVerifyStoreJob.this._facade.lookupLeaseSetLocally(FloodfillVerifyStoreJob.this._key);
                String tunnelName = ls != null ? FloodfillVerifyStoreJob.this._facade.getTunnelName(ls.getDestination()) : "";
                String name = !tunnelName.equals("") ? " for '" + tunnelName + "'" : " for key";
                FloodfillVerifyStoreJob.this._log.warn("Floodfill Verify timed out" + name + " [" + FloodfillVerifyStoreJob.this._key.toBase32().substring(0, 8) + "] -> Ignoring [" + FloodfillVerifyStoreJob.this._target.toBase64().substring(0, 6) + "] and selecting a new peer...");
            }
            if (FloodfillVerifyStoreJob.this._attempted < 8) {
                FloodfillVerifyStoreJob.this._ignore.add(FloodfillVerifyStoreJob.this._target);
                FloodfillVerifyStoreJob.this.runJob();
            } else {
                FloodfillVerifyStoreJob.this._facade.verifyFinished(FloodfillVerifyStoreJob.this._key);
                FloodfillVerifyStoreJob.this.resend();
            }
        }
    }

    private class VerifyReplyJob
    extends JobImpl
    implements ReplyJob {
        private I2NPMessage _message;

        public VerifyReplyJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Handle Floodfill Verification Reply";
        }

        @Override
        public void runJob() {
            String name;
            RouterContext ctx = this.getContext();
            long delay = ctx.clock().now() - FloodfillVerifyStoreJob.this._sendTime;
            if (FloodfillVerifyStoreJob.this._wrappedMessage != null) {
                FloodfillVerifyStoreJob.this._wrappedMessage.acked();
            }
            FloodfillVerifyStoreJob.this._facade.verifyFinished(FloodfillVerifyStoreJob.this._key);
            ProfileManager pm = ctx.profileManager();
            int type = this._message.getType();
            LeaseSet ls = FloodfillVerifyStoreJob.this._facade.lookupLeaseSetLocally(FloodfillVerifyStoreJob.this._key);
            String tunnelName = ls != null ? FloodfillVerifyStoreJob.this._facade.getTunnelName(ls.getDestination()) : "";
            String string = name = !tunnelName.equals("") ? " for '" + tunnelName + "'" : " for key";
            if (type == 1) {
                boolean success;
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)this._message;
                DatabaseEntry entry = dsm.getEntry();
                if (!entry.verifySignature()) {
                    if (FloodfillVerifyStoreJob.this._log.shouldWarn()) {
                        FloodfillVerifyStoreJob.this._log.warn("Banning Router [" + FloodfillVerifyStoreJob.this._target.toBase64().substring(0, 6) + "] for duration of session -> Sent us BAD data (spoofed?)");
                    }
                    pm.dbLookupFailed(FloodfillVerifyStoreJob.this._target);
                    ctx.banlist().banlistRouterForever(FloodfillVerifyStoreJob.this._target, "Sent bad NetDb data");
                    ctx.statManager().addRateData("netDb.floodfillVerifyFail", delay);
                    FloodfillVerifyStoreJob.this.resend();
                    return;
                }
                if (FloodfillVerifyStoreJob.this._isLS2 && entry.getType() != 0 && entry.getType() != 1) {
                    LeaseSet2 ls2 = (LeaseSet2)entry;
                    success = ls2.getPublished() >= FloodfillVerifyStoreJob.this._published;
                } else {
                    boolean bl = success = entry.getDate() >= FloodfillVerifyStoreJob.this._published;
                }
                if (success) {
                    pm.dbLookupSuccessful(FloodfillVerifyStoreJob.this._target, delay);
                    if (FloodfillVerifyStoreJob.this._sentTo != null) {
                        pm.dbStoreSuccessful(FloodfillVerifyStoreJob.this._sentTo);
                    }
                    ctx.statManager().addRateData("netDb.floodfillVerifyOK", delay);
                    if (FloodfillVerifyStoreJob.this._log.shouldInfo()) {
                        FloodfillVerifyStoreJob.this._log.info("Floodfill Verify succeeded" + name + " [" + FloodfillVerifyStoreJob.this._key.toBase32().substring(0, 8) + "]");
                    }
                    if (FloodfillVerifyStoreJob.this._isRouterInfo) {
                        FloodfillVerifyStoreJob.this._facade.routerInfoPublishSuccessful();
                    }
                    return;
                }
                if (FloodfillVerifyStoreJob.this._log.shouldWarn()) {
                    FloodfillVerifyStoreJob.this._log.warn("Floodfill Verify failed" + name + " [" + FloodfillVerifyStoreJob.this._key.toBase32().substring(0, 8) + "] -> Key was stale" + (FloodfillVerifyStoreJob.this._log.shouldDebug() ? "\n* " + dsm.getEntry() : ""));
                }
            } else if (type == 3) {
                DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)this._message;
                pm.dbLookupReply(FloodfillVerifyStoreJob.this._target, 0, dsrm.getNumReplies(), 0, 0, delay);
                if (FloodfillVerifyStoreJob.this._log.shouldWarn()) {
                    FloodfillVerifyStoreJob.this._log.warn("Floodfill Verify failed" + name + " [" + FloodfillVerifyStoreJob.this._key.toBase32().substring(0, 8) + "] -> Queried peer [" + FloodfillVerifyStoreJob.this._target.toBase64().substring(0, 6) + "] didn't have the key");
                }
                if (FloodfillVerifyStoreJob.this._isRouterInfo) {
                    if (FloodfillVerifyStoreJob.this._facade.isClientDb() && FloodfillVerifyStoreJob.this._log.shouldLog(30)) {
                        FloodfillVerifyStoreJob.this._log.warn("Warning! Client is starting a SingleLookupJob (DIRECT?) for RouterInfo [DbId: " + FloodfillVerifyStoreJob.this._facade + "]");
                    }
                    ctx.jobQueue().addJob(new SingleLookupJob(ctx, dsrm));
                }
            }
            if (FloodfillVerifyStoreJob.this._sentTo != null) {
                pm.dbStoreFailed(FloodfillVerifyStoreJob.this._sentTo);
            }
            if (!FloodfillVerifyStoreJob.this._target.equals(FloodfillVerifyStoreJob.this._sentTo)) {
                pm.dbLookupFailed(FloodfillVerifyStoreJob.this._target);
            }
            ctx.statManager().addRateData("netDb.floodfillVerifyFail", delay);
            FloodfillVerifyStoreJob.this.resend();
        }

        @Override
        public void setMessage(I2NPMessage message) {
            this._message = message;
        }
    }

    private class VerifyReplySelector
    implements MessageSelector {
        private VerifyReplySelector() {
        }

        @Override
        public boolean continueMatching() {
            return false;
        }

        @Override
        public long getExpiration() {
            return FloodfillVerifyStoreJob.this._expiration;
        }

        @Override
        public boolean isMatch(I2NPMessage message) {
            int type = message.getType();
            if (type == 1) {
                DatabaseStoreMessage dsm = (DatabaseStoreMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals(dsm.getKey());
            }
            if (type == 3) {
                DatabaseSearchReplyMessage dsrm = (DatabaseSearchReplyMessage)message;
                return FloodfillVerifyStoreJob.this._key.equals(dsrm.getSearchKey());
            }
            return false;
        }
    }
}

