/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.crypto.EncType;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.FastI2NPMessageImpl;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.Job;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupMatchJob;
import net.i2p.router.networkdb.kademlia.FloodOnlyLookupTimeoutJob;
import net.i2p.router.networkdb.kademlia.FloodSearchJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.IterativeLookupSelector;
import net.i2p.router.networkdb.kademlia.IterativeTimeoutJob;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.networkdb.kademlia.StoreJob;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.util.MaskedIPSet;
import net.i2p.router.util.RandomIterator;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.NativeBigInteger;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class IterativeSearchJob
extends FloodSearchJob {
    private final SortedSet<Hash> _toTry;
    private final Set<Hash> _unheardFrom;
    private final Set<Hash> _failedPeers;
    private final Map<Hash, Long> _sentTime;
    private final Hash _rkey;
    private OutNetMessage _out;
    private final Hash _fromLocalDest;
    private static Hash _alwaysQueryHash;
    private final int _totalSearchLimit;
    private final MaskedIPSet _ipSet;
    private final Set<Hash> _skippedPeers;
    private static final int MAX_NON_FF = 5;
    private static final int TOTAL_SEARCH_LIMIT = 14;
    private static final int TOTAL_SEARCH_LIMIT_WHEN_FF = 10;
    private static final int EXTRA_PEERS = 2;
    private static final int IP_CLOSE_BYTES = 3;
    private static final int MAX_SEARCH_TIME = 15000;
    private final long _singleSearchTime;
    private static final long SINGLE_SEARCH_TIME = 4000L;
    private static final long MIN_SINGLE_SEARCH_TIME = 600L;
    private static final long SINGLE_SEARCH_MSG_TIME = 15000L;
    private int _maxConcurrent;
    private static final int MAX_CONCURRENT;
    public static final String PROP_ENCRYPT_RI = "router.encryptRouterLookups";
    public static final boolean DEFAULT_ENCRYPT_RI;

    public IterativeSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease) {
        this(ctx, facade, key, onFind, onFailed, timeoutMs, isLease, null);
    }

    public IterativeSearchJob(RouterContext ctx, FloodfillNetworkDatabaseFacade facade, Hash key, Job onFind, Job onFailed, int timeoutMs, boolean isLease, Hash fromLocalDest) {
        super(ctx, facade, key, onFind, onFailed, timeoutMs, isLease);
        int known = ctx.netDb().getKnownRouters();
        int totalSearchLimit = facade.floodfillEnabled() && ctx.router().getUptime() > 1800000L ? 10 : 14;
        boolean isHidden = ctx.router().isHidden();
        boolean isSlow = SystemVersion.isSlow();
        long lag = ctx.jobQueue().getMaxLag();
        this._timeoutMs = Math.min(timeoutMs * 3, 15000);
        this._expiration = (long)this._timeoutMs + ctx.clock().now();
        this._rkey = ctx.routingKeyGenerator().getRoutingKey(key);
        this._toTry = new TreeSet<Hash>(new XORComparator<Hash>(this._rkey));
        this._totalSearchLimit = ctx.getProperty("netdb.searchLimit", totalSearchLimit);
        this._ipSet = new MaskedIPSet(2 * (this._totalSearchLimit + 2));
        this._singleSearchTime = ctx.getProperty("netdb.singleSearchTime", 4000L);
        this._unheardFrom = new HashSet<Hash>(CONCURRENT_SEARCHES);
        this._failedPeers = new HashSet<Hash>(this._totalSearchLimit);
        this._skippedPeers = new HashSet<Hash>(4);
        this._sentTime = new ConcurrentHashMap<Hash, Long>(this._totalSearchLimit);
        this._fromLocalDest = fromLocalDest;
        this._timeoutMs = Math.min(timeoutMs, 15000);
        int n = this._maxConcurrent = ctx.router().getUptime() > 1800000L || known > 1000 ? ctx.getProperty("netdb.maxConcurrent", MAX_CONCURRENT) : ctx.getProperty("netdb.maxConcurrent", MAX_CONCURRENT + 1);
        if (fromLocalDest != null && !isLease && this._log.shouldLog(30)) {
            this._log.warn("IterativeSearch for RouterInfo [" + key.toBase64().substring(0, 6) + "] down client tunnel " + fromLocalDest, new Exception());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void runJob() {
        boolean empty;
        byte[] b;
        KBucketSet<Hash> ks;
        if (this._facade.isNegativeCached(this._key)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Not searching for negative cached key for Router [" + this._key.toBase64().substring(0, 6) + "]");
            }
            this.cancelJob();
            return;
        }
        if (this.getContext().banlist().isBanlisted(this._key)) {
            if (this._log.shouldDebug()) {
                this._log.debug("Not searching for banlisted Router [" + this._key.toBase64().substring(0, 6) + "]");
            }
            this.cancelJob();
            return;
        }
        String MIN_VERSION = "0.9.61";
        boolean isHidden = this.getContext().router().isHidden();
        RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(this._key);
        RouterInfo isUs = this.getContext().netDb().lookupRouterInfoLocally(this.getContext().routerHash());
        long uptime = this.getContext().router().getUptime();
        if (ri != null && ri != isUs) {
            boolean uninteresting;
            String v = ri.getVersion();
            String caps = ri.getCapabilities();
            boolean bl = uninteresting = caps != null && (caps.indexOf(85) >= 0 || caps.indexOf(75) >= 0 || caps.indexOf(76) >= 0 || v.equals("") || VersionComparator.comp(v, MIN_VERSION) < 0) && !isHidden && this.getContext().netDb().getKnownRouters() > 1000;
            if (uninteresting) {
                if (this._log.shouldInfo()) {
                    this._log.info("Skipping search for uninteresting Router [" + this._key.toBase64().substring(0, 6) + "]");
                }
                this.cancelJob();
                return;
            }
        }
        List<Object> floodfillPeers = (ks = this._facade.getKBuckets()) != null ? ((FloodfillPeerSelector)this._facade.getPeerSelector()).selectFloodfillParticipants(this._rkey, this._totalSearchLimit + 2, ks) : new ArrayList(this._totalSearchLimit);
        String alwaysQuery = this.getContext().getProperty("netDb.alwaysQuery");
        if (alwaysQuery != null && _alwaysQueryHash == null && (b = Base64.decode(alwaysQuery)) != null && b.length == 32) {
            _alwaysQueryHash = Hash.create(b);
        }
        if (floodfillPeers.isEmpty()) {
            ArrayList<Hash> all;
            if (this._log.shouldLog(30) && uptime > 120000L) {
                this._log.warn("Cannot query remote floodfills -> None known (this should resolve shortly)");
            }
            if ((all = new ArrayList<Hash>(this._facade.getAllRouters())).isEmpty()) {
                if (this._log.shouldLog(40) && uptime > 180000L) {
                    this._log.error("No peers in NetDb - reseed required");
                }
                this.failed();
                return;
            }
            RandomIterator<Hash> iter = new RandomIterator<Hash>(all);
            for (int i = 0; iter.hasNext() && i < 5; ++i) {
                floodfillPeers.add(iter.next());
            }
        }
        Hash us = this.getContext().routerHash();
        IterativeSearchJob i = this;
        synchronized (i) {
            this._toTry.addAll(floodfillPeers);
            this._toTry.remove(us);
            this._toTry.remove(this._key);
            empty = this._toTry.isEmpty();
        }
        if (empty) {
            if (this._log.shouldLog(30)) {
                this._log.warn("IterativeSearch for " + (this._isLease ? "LeaseSet " : "Router") + " [" + this._key.toBase64().substring(0, 6) + "] failed -> No Floodfills in NetDb");
            }
            this.failed();
            return;
        }
        IterativeLookupSelector replySelector = new IterativeLookupSelector(this.getContext(), this);
        FloodOnlyLookupMatchJob onReply = new FloodOnlyLookupMatchJob(this.getContext(), this);
        FloodOnlyLookupTimeoutJob onTimeout = new FloodOnlyLookupTimeoutJob(this.getContext(), this);
        this._out = this.getContext().messageRegistry().registerPending(replySelector, onReply, onTimeout);
        if (this._log.shouldInfo()) {
            this._log.info("New IterativeSearch for " + (this._isLease ? "LeaseSet" : "Router") + " [" + this._key.toBase64().substring(0, 6) + "]\n* Querying: " + DataHelper.toString(this._toTry).substring(0, 6) + "]; Routing key: [" + this._rkey.toBase64().substring(0, 6) + "]; Timeout: " + DataHelper.formatDuration(this._timeoutMs) + " (DbId: " + this._facade + ")");
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void retry() {
        long now = this.getContext().clock().now();
        if (this._expiration < now) {
            this.cancelJob();
            return;
        }
        if (this._expiration - 600L < now) {
            this.cancelJob();
            return;
        }
        if (this._expiration - 1500L < now) {
            this._expiration = 1500L;
        }
        while (true) {
            int done;
            int pend;
            Hash peer = null;
            IterativeSearchJob iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                if (this._dead) {
                    return;
                }
                pend = this._unheardFrom.size();
                if (pend >= this._maxConcurrent) {
                    return;
                }
                done = this._failedPeers.size();
            }
            if (done >= this._totalSearchLimit) {
                this.cancelJob();
                return;
            }
            if (done + pend >= this._totalSearchLimit) {
                return;
            }
            iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                if (_alwaysQueryHash != null && !this._unheardFrom.contains(_alwaysQueryHash) && !this._failedPeers.contains(_alwaysQueryHash)) {
                    peer = _alwaysQueryHash;
                } else {
                    if (this._toTry.isEmpty()) {
                        return;
                    }
                    Iterator iter = this._toTry.iterator();
                    while (iter.hasNext()) {
                        Hash h = (Hash)iter.next();
                        iter.remove();
                        MaskedIPSet peerIPs = new MaskedIPSet(this.getContext(), h, 3);
                        if (!this._ipSet.containsAny(peerIPs)) {
                            this._ipSet.addAll(peerIPs);
                            peer = h;
                            break;
                        }
                        if (this._log.shouldInfo()) {
                            this._log.info("Skipping query: Router [" + h.toBase64().substring(0, 6) + "] is too close to others");
                        }
                        this._skippedPeers.add(h);
                    }
                    if (peer == null) {
                        return;
                    }
                }
                this._unheardFrom.add(peer);
            }
            this.sendQuery(peer, done + pend);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void sendQuery(Hash peer, int previouslyTried) {
        long avg;
        Rate r;
        RateStat dbrt;
        boolean isDirect;
        boolean isClientReplyTunnel;
        TunnelInfo replyTunnel;
        TunnelInfo outTunnel;
        RouterContext ctx = this.getContext();
        TunnelManagerFacade tm = ctx.tunnelManager();
        RouterInfo ri = ctx.netDb().lookupRouterInfoLocally(peer);
        if (ri != null && ctx.commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED && !StoreJob.shouldStoreTo(ri)) {
            this.failed(peer, false);
            if (this._log.shouldDebug()) {
                this._log.debug("Not sending query to old Router [" + ri.toBase64().substring(0, 6) + "]");
            }
            return;
        }
        boolean supportsRatchet = false;
        boolean supportsElGamal = true;
        if (this._fromLocalDest != null) {
            LeaseSetKeys lsk;
            outTunnel = previouslyTried <= 0 ? tm.selectOutboundTunnel(this._fromLocalDest, peer) : tm.selectOutboundTunnel(this._fromLocalDest);
            if (outTunnel == null) {
                outTunnel = previouslyTried <= 0 ? tm.selectOutboundExploratoryTunnel(peer) : tm.selectOutboundTunnel();
            }
            supportsRatchet = (lsk = ctx.keyManager().getKeys(this._fromLocalDest)) != null && lsk.isSupported(EncType.ECIES_X25519) && DatabaseLookupMessage.supportsRatchetReplies(ri);
            boolean bl = supportsElGamal = !supportsRatchet && lsk != null && lsk.isSupported(EncType.ELGAMAL_2048);
            if (supportsElGamal || supportsRatchet) {
                replyTunnel = previouslyTried <= 0 ? tm.selectInboundTunnel(this._fromLocalDest, peer) : tm.selectInboundTunnel(this._fromLocalDest);
                boolean bl2 = isClientReplyTunnel = replyTunnel != null;
                if (!isClientReplyTunnel) {
                    replyTunnel = previouslyTried <= 0 ? tm.selectInboundExploratoryTunnel(peer) : tm.selectInboundTunnel();
                }
            } else {
                isClientReplyTunnel = false;
                replyTunnel = previouslyTried <= 0 ? tm.selectInboundExploratoryTunnel(peer) : tm.selectInboundTunnel();
            }
            isDirect = false;
        } else if (!this._isLease && ri != null && ctx.commSystem().isEstablished(peer)) {
            outTunnel = null;
            replyTunnel = null;
            isClientReplyTunnel = false;
            isDirect = true;
            if (this._facade.isClientDb() && this._log.shouldLog(30)) {
                this._log.warn("Warning! Direct search selected in a client NetDb context! (DbId: " + this._facade + ")");
            }
            ctx.statManager().addRateData("netDb.RILookupDirect", 1L);
        } else {
            if (previouslyTried <= 0) {
                outTunnel = tm.selectOutboundExploratoryTunnel(peer);
                replyTunnel = tm.selectInboundExploratoryTunnel(peer);
            } else {
                outTunnel = tm.selectOutboundTunnel();
                replyTunnel = tm.selectInboundTunnel();
            }
            isClientReplyTunnel = false;
            isDirect = false;
            ctx.statManager().addRateData("netDb.RILookupDirect", 0L);
        }
        if (!(isDirect || replyTunnel != null && outTunnel != null)) {
            this.failed();
            return;
        }
        if (outTunnel != null && outTunnel.getLength() <= 1) {
            if (peer != null && peer.equals(this._key)) {
                this.failed(peer, false);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Not sending zero-hop self-lookup of [" + peer.toBase64().substring(0, 6) + "]");
                }
                return;
            }
            if (peer != null && this._facade.lookupLocallyWithoutValidation(peer) == null) {
                this.failed(peer, false);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Not sending zero-hop lookup of [" + peer.toBase64().substring(0, 6) + "] to UNKNOWN");
                }
                return;
            }
        }
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(ctx, true);
        if (isDirect) {
            dlm.setFrom(ctx.routerHash());
        } else {
            dlm.setFrom(replyTunnel.getPeer(0));
            dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
        }
        long now = ctx.clock().now();
        dlm.setMessageExpiration(now + 15000L);
        dlm.setSearchKey(this._key);
        dlm.setSearchType(this._isLease ? DatabaseLookupMessage.Type.LS : DatabaseLookupMessage.Type.RI);
        if (this._log.shouldDebug()) {
            int tries;
            IterativeSearchJob iterativeSearchJob = this;
            synchronized (iterativeSearchJob) {
                tries = this._unheardFrom.size() + this._failedPeers.size();
            }
            if (this._key != null && peer != null) {
                this._log.debug("IterativeSearch for " + (this._isLease ? "LeaseSet " : "Router ") + " [" + this._key.toBase64().substring(0, 6) + "] (attempt " + tries + ")\n* Querying: [" + peer.toBase64().substring(0, 6) + "]; Direct? " + isDirect + "; Reply via client tunnel? " + isClientReplyTunnel);
            }
        }
        if (peer != null) {
            this._sentTime.put(peer, now);
        }
        EncType type = ri != null ? ri.getIdentity().getPublicKey().getType() : null;
        boolean encryptElG = ctx.getProperty(PROP_ENCRYPT_RI, DEFAULT_ENCRYPT_RI);
        FastI2NPMessageImpl outMsg = null;
        if (!isDirect && (this._isLease || encryptElG && type == EncType.ELGAMAL_2048 && ctx.jobQueue().getMaxLag() < 300L || type == EncType.ECIES_X25519) && ri != null) {
            MessageWrapper.OneTimeSession sess;
            if (type != EncType.ELGAMAL_2048 && type != EncType.ECIES_X25519) {
                this.failed(peer, false);
                if (this._log.shouldLog(30)) {
                    this._log.warn("Can't do encrypted lookup to [" + peer.toBase64().substring(0, 6) + "] with EncType " + (Object)((Object)type));
                }
                return;
            }
            if (isClientReplyTunnel) {
                sess = MessageWrapper.generateSession(ctx, this._fromLocalDest, 15000L, !supportsRatchet);
            } else {
                EncType ourType = ctx.keyManager().getPublicKey().getType();
                boolean ratchet1 = ourType.equals((Object)EncType.ECIES_X25519);
                boolean ratchet2 = DatabaseLookupMessage.supportsRatchetReplies(ri);
                if (ratchet1 && !ratchet2) {
                    this.failed(peer, false);
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Can't do encrypted lookup to [" + peer.toBase64().substring(0, 6) + "] -> Router does not support AEAD replies");
                    }
                    return;
                }
                supportsRatchet = ratchet1 && ratchet2;
                sess = MessageWrapper.generateSession(ctx, ctx.sessionKeyManager(), 15000L, !supportsRatchet);
            }
            if (sess != null) {
                if (sess.tag != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Requesting AES reply from [" + peer.toBase64().substring(0, 6) + "]\n* Session key: [" + sess.key.toBase64().substring(0, 6) + "] Tag: [" + sess.tag.toString() + "]");
                    }
                    dlm.setReplySession(sess.key, sess.tag);
                } else {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Requesting AEAD reply from [" + peer.toBase64().substring(0, 6) + "]\n* Session key: [" + sess.key.toBase64().substring(0, 6) + "] Tag: [" + sess.rtag.toString() + "]");
                    }
                    dlm.setReplySession(sess.key, sess.rtag);
                }
            } else if (this._log.shouldLog(30)) {
                this._log.warn("Failed encrypt to " + ri);
            }
            outMsg = MessageWrapper.wrap(ctx, (I2NPMessage)dlm, ri);
            if (this._dead) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Aborting send - finished while wrapping message to [" + peer.toBase64().substring(0, 6) + "]");
                }
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Encrypted DbLookupMsg for [" + this._key.toBase64().substring(0, 6) + "] sent to [" + peer.toBase64().substring(0, 6) + "]");
            }
        }
        if (outMsg == null) {
            outMsg = dlm;
        }
        if (isDirect) {
            if (this._facade.isClientDb() && this._log.shouldLog(30)) {
                this._log.warn("Warning! Sending direct search message in a client NetDb context! (DbId: " + this._facade + ")" + outMsg);
            }
            OutNetMessage m = new OutNetMessage(ctx, outMsg, outMsg.getMessageExpiration(), 1000, ri);
            ctx.commSystem().processMessage(m);
        } else {
            ctx.tunnelDispatcher().dispatchOutbound(outMsg, outTunnel.getSendTunnelId(0), peer);
        }
        IterativeTimeoutJob j = new IterativeTimeoutJob(ctx, peer, this);
        PeerProfile prof = this.getContext().profileOrganizer().getProfileNonblocking(peer);
        long exp = this._singleSearchTime;
        if (prof != null && prof.getIsExpandedDB() && (dbrt = prof.getDbResponseTime()) != null && (r = dbrt.getRate(3600000L)) != null && (avg = (long)r.getAvgOrLifetimeAvg()) > 0L) {
            exp = Math.min(exp, Math.max(600L, (long)(isDirect ? 2 : 3) * avg));
        }
        long expire = Math.min(this._expiration, now + exp);
        j.getTiming().setStartAfter(expire);
        this.getContext().jobQueue().addJob(j);
    }

    @Override
    public String getName() {
        return "Start Iterative Search";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void failed(Hash peer, boolean timedOut) {
        boolean isNewFail;
        if (this._dead || this.getContext().banlist().isBanlisted(peer)) {
            return;
        }
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            this._unheardFrom.remove(peer);
            isNewFail = this._failedPeers.add(peer);
        }
        if (isNewFail) {
            boolean isKnown;
            boolean bl = isKnown = this._facade.lookupLocallyWithoutValidation(peer) != null;
            if (timedOut) {
                this.getContext().profileManager().dbLookupFailed(peer);
                if (this._log.shouldInfo()) {
                    if (peer != null) {
                        this._log.info("IterativeSearch for " + (isKnown ? "known " : "") + "Router [" + peer.toBase64().substring(0, 6) + "] timed out");
                    } else {
                        this._log.info("IterativeSearch for Router [unknown] timed out");
                    }
                }
            } else if (this._log.shouldInfo()) {
                if (peer != null) {
                    this._log.info("IterativeSearch for " + (isKnown ? "known " : "") + "Router [" + peer.toBase64().substring(0, 6) + "] failed");
                } else {
                    this._log.info("IterativeSearch for Router [unknown] failed");
                }
            }
        }
        this.retry();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void newPeerToTry(Hash peer) {
        if (peer.equals(this.getContext().routerHash()) || peer.equals(this._key) || this.getContext().banlist().isBanlisted(peer)) {
            if (this.getContext().banlist().isBanlisted(peer) && this._log.shouldInfo()) {
                this._log.info("Not querying banlisted peer [" + peer.toBase64().substring(0, 6) + "] received from DbSearchReplyMsg");
            }
            return;
        }
        RouterInfo ri = this.getContext().netDb().lookupRouterInfoLocally(peer);
        if (ri != null && !FloodfillNetworkDatabaseFacade.isFloodfill(ri)) {
            if (this._log.shouldInfo()) {
                this._log.info("Not querying non-Floodfill peer [" + peer.toBase64().substring(0, 6) + "] received from DbSearchReplyMsg");
            }
            return;
        }
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._failedPeers.contains(peer) || this._unheardFrom.contains(peer) || this._skippedPeers.contains(peer)) {
                return;
            }
            if (!this._toTry.add(peer)) {
                return;
            }
        }
        if (this._log.shouldInfo()) {
            this._log.info("Received new Router [" + peer.toBase64().substring(0, 6) + "] from DbSearchReplyMsg " + (ri != null ? " -> Already known" : ""));
        }
        this.retry();
    }

    public Hash getFromHash() {
        return this._fromLocalDest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasQueried(Hash peer) {
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            return this._unheardFrom.contains(peer) || this._failedPeers.contains(peer);
        }
    }

    long timeSent(Hash peer) {
        Long rv = this._sentTime.get(peer);
        return rv == null ? -1L : rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void cancelJob() {
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this._facade.complete(this._key);
    }

    @Override
    public void dropped() {
        this.failed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void failed() {
        ArrayList<Hash> unheard;
        int tries;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
        }
        this._facade.complete(this._key);
        if (this.getContext().commSystem().getStatus() != CommSystemFacade.Status.DISCONNECTED) {
            this._facade.lookupFailed(this._key);
        }
        this.getContext().messageRegistry().unregisterPending(this._out);
        IterativeSearchJob iterativeSearchJob2 = this;
        synchronized (iterativeSearchJob2) {
            tries = this._unheardFrom.size() + this._failedPeers.size();
            unheard = new ArrayList<Hash>(this._unheardFrom);
        }
        for (Hash h : unheard) {
            this.getContext().profileManager().dbLookupFailed(h);
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldInfo()) {
            long timeRemaining = this._expiration - this.getContext().clock().now();
            this._log.info("IterativeSearch for " + (this._isLease ? "LeaseSet " : "Router") + " [" + this._key.toBase64().substring(0, 6) + "] failed\n* Peers queried: " + tries + "; Time taken: " + time + "ms (" + timeRemaining + "ms remaining)");
        }
        if (tries > 0) {
            this.getContext().statManager().addRateData("netDb.failedTime", time);
            this.getContext().statManager().addRateData("netDb.failedRetries", tries - 1);
        }
        for (Job j : this._onFailed) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFailed.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void success() {
        Long timeSent;
        int tries;
        Hash peer = null;
        IterativeSearchJob iterativeSearchJob = this;
        synchronized (iterativeSearchJob) {
            if (this._dead) {
                return;
            }
            this._dead = true;
            this._success = true;
            tries = this._unheardFrom.size() + this._failedPeers.size();
            if (this._unheardFrom.size() == 1) {
                peer = this._unheardFrom.iterator().next();
                this._unheardFrom.clear();
            }
        }
        this._facade.complete(this._key);
        if (peer != null && (timeSent = this._sentTime.get(peer)) != null) {
            this.getContext().profileManager().dbLookupSuccessful(peer, this.getContext().clock().now() - timeSent);
        }
        long time = System.currentTimeMillis() - this._created;
        if (this._log.shouldInfo()) {
            this._log.info("IterativeSearch for " + (this._isLease ? "LeaseSet " : "Router") + " [" + this._key.toBase64().substring(0, 6) + "] succeeded\n* Peers queried: " + tries + "; Time taken: " + time + "ms");
        }
        this.getContext().statManager().addRateData("netDb.successTime", time);
        this.getContext().statManager().addRateData("netDb.successRetries", tries - 1);
        for (Job j : this._onFind) {
            this.getContext().jobQueue().addJob(j);
        }
        this._onFind.clear();
    }

    static {
        MAX_CONCURRENT = SystemVersion.isSlow() ? 2 : 4;
        DEFAULT_ENCRYPT_RI = NativeBigInteger.isNative();
    }
}

