/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.i2p.crypto.SigAlgo;
import net.i2p.crypto.SigType;
import net.i2p.data.BlindData;
import net.i2p.data.Certificate;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Destination;
import net.i2p.data.EncryptedLeaseSet;
import net.i2p.data.Hash;
import net.i2p.data.KeyCertificate;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.kademlia.KBucketSet;
import net.i2p.kademlia.RejectTrimmer;
import net.i2p.router.Job;
import net.i2p.router.NetworkDatabaseFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.networkdb.kademlia.BlindCache;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.networkdb.kademlia.ExpireLeasesJob;
import net.i2p.router.networkdb.kademlia.ExpireRoutersJob;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.FloodfillNetworkDatabaseSegmentor;
import net.i2p.router.networkdb.kademlia.FloodfillPeerSelector;
import net.i2p.router.networkdb.kademlia.NegativeLookupCache;
import net.i2p.router.networkdb.kademlia.PeerSelector;
import net.i2p.router.networkdb.kademlia.PersistentDataStore;
import net.i2p.router.networkdb.kademlia.RepublishLeaseSetJob;
import net.i2p.router.networkdb.kademlia.SearchJob;
import net.i2p.router.networkdb.kademlia.StartExplorersJob;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.router.networkdb.kademlia.UnsupportedCryptoException;
import net.i2p.router.networkdb.reseed.ReseedChecker;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public abstract class KademliaNetworkDatabaseFacade
extends NetworkDatabaseFacade {
    protected final Log _log;
    private KBucketSet<Hash> _kb;
    private DataStore _ds;
    private String _dbDir;
    private final Set<Hash> _exploreKeys;
    private boolean _initialized;
    private long _started;
    private StartExplorersJob _exploreJob;
    private long _lastExploreNew;
    protected final PeerSelector _peerSelector;
    protected final RouterContext _context;
    private final ReseedChecker _reseedChecker;
    private volatile long _lastRIPublishTime;
    private NegativeLookupCache _negativeCache;
    protected final int _networkID;
    private final BlindCache _blindCache;
    private final Hash _dbid;
    private final Job _elj;
    private final Job _erj;
    static final String PROP_MIN_ROUTER_VERSION = "router.minVersionAllowed";
    public static final String PROP_BLOCK_MY_COUNTRY = "i2np.blockMyCountry";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";
    private static final String PROP_BLOCK_COUNTRIES = "router.blockCountries";
    private static final String DEFAULT_BLOCK_COUNTRIES = "";
    public static final String PROP_BLOCK_XG = "i2np.blockXG";
    private final Map<Hash, RepublishLeaseSetJob> _publishingLeaseSets;
    private final Map<Hash, SearchJob> _activeRequests;
    public static long DONT_FAIL_PERIOD = 900000L;
    private static final boolean QUIET = false;
    public static final String PROP_DB_DIR = "router.networkDatabase.dbDir";
    public static final String DEFAULT_DB_DIR = "netDb";
    static final int MIN_RESEED = 100;
    protected static final int MIN_REMAINING_ROUTERS = 100;
    private static final long ROUTER_INFO_EXPIRATION = 86400000L;
    private static final long ROUTER_INFO_EXPIRATION_MIN = 28800000L;
    private static final long ROUTER_INFO_EXPIRATION_SHORT = 900000L;
    private static final long ROUTER_INFO_EXPIRATION_FLOODFILL = 14400000L;
    private static final long ROUTER_INFO_EXPIRATION_INTRODUCED = 3240000L;
    static final String PROP_ROUTER_INFO_EXPIRATION_ADJUSTED = "router.expireRouterInfo";
    static final String PROP_VALIDATE_ROUTERS_AFTER = "router.validateRoutersAfter";
    private static final long EXPLORE_JOB_DELAY = 300000L;
    private static final long MAX_LEASE_FUTURE = 900000L;
    private static final long MAX_META_LEASE_FUTURE = 65535000L;
    protected static final long PUBLISH_JOB_DELAY = 180000L;
    static final int MAX_EXPLORE_QUEUE = SystemVersion.isSlow() ? 128 : 256;
    static final String PROP_EXPLORE_QUEUE = "router.exploreQueue";
    private static final int BUCKET_SIZE = 24;
    static final String PROP_BUCKET_SIZE = "router.exploreBucketSize";
    private static final int KAD_B = 4;
    static final String PROP_KAD_B = "router.exploreKadB";
    private static final long[] RATES = new long[]{60000L, 3600000L, 86400000L};
    private static final long PUBLISH_DELAY = 1000L;
    private static final int MIN_ROUTERS = 2000;
    private static final int MIN_PER_PEER_TIMEOUT = 2500;
    private static final int MAX_PER_PEER_TIMEOUT = 5000;
    private static final int TIMEOUT_MULTIPLIER = 3;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void searchComplete(Hash key) {
        if (this._log.shouldDebug()) {
            this._log.debug("Search for key [" + key.toBase64().substring(0, 6) + "] finished");
        }
        Map<Hash, SearchJob> map = this._activeRequests;
        synchronized (map) {
            this._activeRequests.remove(key);
        }
    }

    public KademliaNetworkDatabaseFacade(RouterContext context, Hash dbid) {
        this._context = context;
        this._dbid = dbid;
        this._log = this._context.logManager().getLog(this.getClass());
        this._networkID = context.router().getNetworkID();
        this._publishingLeaseSets = new HashMap<Hash, RepublishLeaseSetJob>(8);
        this._activeRequests = new HashMap<Hash, SearchJob>(8);
        if (this.isClientDb()) {
            this._reseedChecker = null;
            this._blindCache = null;
            this._exploreKeys = null;
            this._erj = null;
            this._peerSelector = ((KademliaNetworkDatabaseFacade)context.netDb()).getPeerSelector();
        } else {
            this._reseedChecker = new ReseedChecker(context);
            this._blindCache = new BlindCache(context);
            this._exploreKeys = new ConcurrentHashSet<Hash>(64);
            this._erj = new ExpireRoutersJob(this._context, this);
            this._peerSelector = this.createPeerSelector();
        }
        this._elj = new ExpireLeasesJob(this._context, this);
        if (this._log.shouldLog(10)) {
            this._log.debug("Created KademliaNetworkDatabaseFacade for DbId: " + this._dbid);
        }
        context.statManager().createRateStat("netDb.exploreKeySet", "NetDb keys queued for exploration", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.lookupDeferred", "Deferred NetDb lookups", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.negativeCache", "Aborted NetDb lookups (already cached)", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.ackTime", "Time peer takes to ACK a DbStore", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.DLMAllZeros", "Message lookups in NetDb with zero key ", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.DSMAllZeros", "Messages stored in NetDb with zero key", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.replyTimeout", "Timeout expiry after a NetDb send (peer fails to reply in time)", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.republishLeaseSetCount", "How often we republish a LeaseSet", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.republishLeaseSetFail", "How often we fail to republish a LeaseSet", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.storeFailedPeers", "Peers each NetDb must be sent to before failing completely", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.storeLeaseSetSent", "Sent LeaseSet store messages", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.storePeers", "Peers each NetDb must be sent to before success", "NetworkDatabase", RATES);
        context.statManager().createRateStat("netDb.storeRouterInfoSent", "Sent RouterInfo store messages", "NetworkDatabase", RATES);
    }

    @Override
    public boolean isInitialized() {
        return this._initialized && this._ds != null && this._ds.isInitialized();
    }

    protected PeerSelector createPeerSelector() {
        if (this.isClientDb()) {
            throw new IllegalStateException();
        }
        return new FloodfillPeerSelector(this._context);
    }

    public PeerSelector getPeerSelector() {
        return this._peerSelector;
    }

    @Override
    public ReseedChecker reseedChecker() {
        if (this.isClientDb()) {
            return null;
        }
        return this._reseedChecker;
    }

    protected BlindCache blindCache() {
        if (!this.isClientDb()) {
            return this._blindCache;
        }
        return ((FloodfillNetworkDatabaseFacade)this._context.netDb()).blindCache();
    }

    KBucketSet<Hash> getKBuckets() {
        return this._kb;
    }

    DataStore getDataStore() {
        return this._ds;
    }

    long getLastExploreNewDate() {
        return this._lastExploreNew;
    }

    void setLastExploreNewDate(long when) {
        this._lastExploreNew = when;
    }

    public Set<Hash> getExploreKeys() {
        if (!this._initialized || this.isClientDb()) {
            return Collections.emptySet();
        }
        return Collections.unmodifiableSet(this._exploreKeys);
    }

    public void removeFromExploreKeys(Collection<Hash> toRemove) {
        if (!this._initialized || this.isClientDb()) {
            return;
        }
        this._exploreKeys.removeAll(toRemove);
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    public void queueForExploration(Collection<Hash> keys) {
        boolean upLongEnough;
        String exploreQueue = this._context.getProperty(PROP_EXPLORE_QUEUE);
        boolean bl = upLongEnough = this._context.router().getUptime() > 900000L;
        if (!upLongEnough) {
            long down = this._context.router().getEstimatedDowntime();
            boolean bl2 = upLongEnough = down > 0L && down < 36000000L;
        }
        if (!this._initialized || this.isClientDb()) {
            if (this._log.shouldInfo() && !this._initialized) {
                this._log.info("Datastore not initialized, cannot queue keys for exploration");
            }
            return;
        }
        Iterator<Hash> iter = keys.iterator();
        while (iter.hasNext() && this._exploreKeys.size() < MAX_EXPLORE_QUEUE) {
            this._exploreKeys.add(iter.next());
        }
        this._context.statManager().addRateData("netDb.exploreKeySet", this._exploreKeys.size());
    }

    @Override
    public synchronized void shutdown() {
        if (this._log.shouldWarn()) {
            this._log.warn("NetDb shutdown: " + this);
        }
        this._initialized = false;
        if (!this._context.commSystem().isDummy() && !this.isClientDb() && this._context.router().getUptime() > 15060000L) {
            ExpireRoutersJob erj = new ExpireRoutersJob(this._context, this);
            erj.runJob();
        }
        this._context.jobQueue().removeJob(this._elj);
        if (this._erj != null) {
            this._context.jobQueue().removeJob(this._erj);
        }
        if (this._kb != null && !this.isClientDb()) {
            this._kb.clear();
        }
        if (this._ds != null) {
            this._ds.stop();
        }
        if (this._exploreKeys != null) {
            this._exploreKeys.clear();
        }
        if (this._negativeCache != null) {
            this._negativeCache.stop();
        }
        if (!this.isClientDb()) {
            this.blindCache().shutdown();
        }
    }

    @Override
    @Deprecated
    public synchronized void restart() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void rescan() {
        if (this.isInitialized()) {
            this._ds.rescan();
        }
    }

    String getDbDir() {
        return this._dbDir;
    }

    public boolean isClientDb() {
        return this._dbid != FloodfillNetworkDatabaseSegmentor.MAIN_DBID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startup() {
        RouterInfo ri = this._context.router().getRouterInfo();
        String dbDir = this._context.getProperty(PROP_DB_DIR, DEFAULT_DB_DIR);
        boolean initMessage = false;
        if (this.isClientDb()) {
            this._kb = ((FloodfillNetworkDatabaseFacade)this._context.netDb()).getKBuckets();
        } else {
            KademliaNetworkDatabaseFacade kademliaNetworkDatabaseFacade = this;
            synchronized (kademliaNetworkDatabaseFacade) {
                this._kb = new KBucketSet<Hash>(this._context, ri.getIdentity().getHash(), 24, 4, new RejectTrimmer());
            }
        }
        if (this._log.shouldInfo() && this._context.router().getUptime() < 60000L && !initMessage) {
            this._log.info("Initializing the Kademlia Network Database...\nBucketSize: 24; B Value: 4");
            initMessage = true;
        }
        try {
            this._ds = !this.isClientDb() ? new PersistentDataStore(this._context, dbDir, this) : new TransientDataStore(this._context);
        }
        catch (IOException ioe) {
            throw new RuntimeException("Unable to initialize NetDb storage", ioe);
        }
        this._dbDir = dbDir;
        this._negativeCache = new NegativeLookupCache(this._context);
        if (!this.isClientDb()) {
            this.blindCache().startup();
        }
        this.createHandlers();
        this._initialized = true;
        this._started = System.currentTimeMillis();
        long now = this._context.clock().now();
        this._elj.getTiming().setStartAfter(now + 540000L);
        this._context.jobQueue().addJob(this._elj);
        if (!this.isClientDb() && !this._context.commSystem().isDummy()) {
            boolean isFF = this._context.getBooleanProperty("router.floodfillParticipant");
            long down = this._context.router().getEstimatedDowntime();
            long delay = down == 0L || !isFF && down > 0x6DDD00L || isFF && down > 0x6DDD000L ? 16800000L : 2400000L;
            this._erj.getTiming().setStartAfter(now + delay);
            this._context.jobQueue().addJob(this._erj);
        }
        if (!this.isClientDb()) {
            if (this._exploreJob == null) {
                this._exploreJob = new StartExplorersJob(this._context, this);
            }
            this._exploreJob.getTiming().setStartAfter(now + 300000L);
            this._context.jobQueue().addJob(this._exploreJob);
        }
    }

    protected void createHandlers() {
    }

    @Override
    public Set<Hash> findNearestRouters(Hash key, int maxNumRouters, Set<Hash> peersToIgnore) {
        if (this.isClientDb()) {
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return Collections.emptySet();
        }
        return new HashSet<Hash>(this._peerSelector.selectNearest(key, maxNumRouters, peersToIgnore, this._kb));
    }

    @Override
    public Set<Hash> getAllRouters() {
        if (this.isClientDb()) {
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return Collections.emptySet();
        }
        Collection<DatabaseEntry> entries = this._ds.getEntries();
        return entries.stream().filter(e -> e.isRouterInfo()).map(e -> e.getHash()).collect(Collectors.toSet());
    }

    @Override
    public int getKnownRouters() {
        if (this.isClientDb() || this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (ds.getType() != 0) continue;
            ++rv;
        }
        return rv;
    }

    @Override
    public int getKnownLeaseSets() {
        if (this._ds == null) {
            return 0;
        }
        int rv = 0;
        for (DatabaseEntry ds : this._ds.getEntries()) {
            if (!ds.isLeaseSet() || !((LeaseSet)ds).getReceivedAsPublished()) continue;
            ++rv;
        }
        return rv;
    }

    protected int getKBucketSetSize() {
        if (this._kb == null) {
            return 0;
        }
        return this._kb.size();
    }

    @Override
    public BlindData getBlindData(SigningPublicKey spk) {
        return this.blindCache().getData(spk);
    }

    @Override
    public void setBlindData(BlindData bd) {
        if (this._log.shouldWarn()) {
            this._log.warn("Adding to blind cache: " + bd);
        }
        this.blindCache().addToCache(bd);
    }

    @Override
    public List<BlindData> getBlindData() {
        return this.blindCache().getData();
    }

    @Override
    public boolean removeBlindData(SigningPublicKey spk) {
        return this.blindCache().removeBlindData(spk);
    }

    @Override
    public void routingKeyChanged() {
        this.blindCache().rollover();
        if (this._log.shouldInfo()) {
            this._log.info("UTC rollover -> Blind cache updated");
        }
    }

    @Override
    public DatabaseEntry lookupLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry rv = this._ds.get(key);
        if (rv == null) {
            return null;
        }
        int type = rv.getType();
        if (DatabaseEntry.isLeaseSet(type)) {
            LeaseSet ls = (LeaseSet)rv;
            if (ls.isCurrent(60000L)) {
                return rv;
            }
            key = this.blindCache().getHash(key);
            this.fail(key);
        } else if (type == 0) {
            try {
                if (this.validate((RouterInfo)rv) == null) {
                    return rv;
                }
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            this.fail(key);
        }
        return null;
    }

    @Override
    public DatabaseEntry lookupLocallyWithoutValidation(Hash key) {
        if (!this._initialized) {
            return null;
        }
        return this._ds.get(key);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        this.lookupLeaseSet(key, onFindJob, onFailedLookupJob, timeoutMs, null);
    }

    @Override
    public void lookupLeaseSet(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        LeaseSet ls = this.lookupLeaseSetLocally(key);
        if (ls != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldInfo()) {
                this._log.info("LeaseSet [" + key.toBase32().substring(0, 8) + "] is negatively cached -> Queueing search...");
            }
            if (onFailedLookupJob != null) {
                this._context.jobQueue().addJob(onFailedLookupJob);
            }
        } else {
            key = this.blindCache().getHash(key);
            this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public void lookupLeaseSetRemotely(Hash key, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        key = this.blindCache().getHash(key);
        if (this.isNegativeCached(key)) {
            return;
        }
        this.search(key, null, null, 30000L, true, fromLocalDest);
    }

    @Override
    public void lookupLeaseSetRemotely(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        key = this.blindCache().getHash(key);
        if (this.isNegativeCached(key)) {
            return;
        }
        this.search(key, onFindJob, onFailedLookupJob, timeoutMs, true, fromLocalDest);
    }

    @Override
    public LeaseSet lookupLeaseSetLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.isLeaseSet()) {
                LeaseSet ls = (LeaseSet)ds;
                if (ls.isCurrent(60000L)) {
                    return ls;
                }
                key = this.blindCache().getHash(key);
                this.fail(key);
                if (this._exploreKeys != null) {
                    this._exploreKeys.add(key);
                }
                return null;
            }
            return null;
        }
        return null;
    }

    @Override
    public void lookupDestination(Hash key, Job onFinishedJob, long timeoutMs, Hash fromLocalDest) {
        if (!this._initialized) {
            return;
        }
        Destination d = this.lookupDestinationLocally(key);
        if (d != null) {
            this._context.jobQueue().addJob(onFinishedJob);
        } else if (this.isNegativeCached(key)) {
            if (this._log.shouldInfo()) {
                this._log.info("Destination [" + key.toBase32().substring(0, 8) + "] is negatively cached -> Aborting lookup");
            }
            this._context.jobQueue().addJob(onFinishedJob);
        } else {
            key = this.blindCache().getHash(key);
            this.search(key, onFinishedJob, onFinishedJob, timeoutMs, true, fromLocalDest);
        }
    }

    @Override
    public Destination lookupDestinationLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.isLeaseSet()) {
                LeaseSet ls = (LeaseSet)ds;
                return ls.getDestination();
            }
        } else {
            return this._negativeCache.getBadDest(key);
        }
        return null;
    }

    @Override
    public void lookupRouterInfo(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs) {
        if (!this._initialized) {
            return;
        }
        RouterInfo ri = this.lookupRouterInfoLocally(key);
        if (ri != null) {
            if (onFindJob != null) {
                this._context.jobQueue().addJob(onFindJob);
            }
            boolean isHidden = this._context.router().isHidden() || this._context.getBooleanProperty("router.hiddenMode");
            String v = ri.getVersion();
            String MIN_VERSION = "0.9.60";
            String CURRENT_VERSION = "0.9.63";
            long uptime = this._context.router().getUptime();
            boolean isOld = VersionComparator.comp(v, MIN_VERSION) < 0;
            boolean isOlderThanCurrent = VersionComparator.comp(v, CURRENT_VERSION) < 0;
            Hash us = this._context.routerHash();
            boolean isUs = us.equals(ri.getIdentity().getHash());
            String caps = ri.getCapabilities().toUpperCase();
            boolean uninteresting = !(ri.getCapabilities().indexOf(85) < 0 && ri.getCapabilities().indexOf(82) >= 0 && ri.getCapabilities().indexOf(75) < 0 && ri.getCapabilities().indexOf(76) < 0 && ri.getCapabilities().indexOf(77) < 0 || !isOld || uptime <= 900000L && this._context.netDb().getKnownRouters() <= 2000 || isUs);
            boolean isLTier = ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0;
            boolean isXTier = ri.getCapabilities().indexOf(88) >= 0;
            boolean isUnreachable = ri.getCapabilities().indexOf(85) >= 0 || ri.getCapabilities().indexOf(82) < 0;
            boolean isNotRorU = ri.getCapabilities().indexOf(85) < 0 && ri.getCapabilities().indexOf(82) < 0;
            boolean isFF = false;
            boolean isG = ri.getCapabilities().indexOf(71) >= 0;
            boolean noCountry = true;
            String country = "unknown";
            if (caps != null && !caps.isEmpty() && caps.contains("F")) {
                isFF = true;
            }
            if ((country = this._context.commSystem().getCountry(key)) != null && country != "unknown") {
                noCountry = false;
            }
            String myCountry = this._context.getProperty(PROP_IP_COUNTRY);
            boolean blockMyCountry = this._context.getBooleanProperty(PROP_BLOCK_MY_COUNTRY);
            Set<String> blockedCountries = this.getBlockedCountries();
            boolean blockXG = this._context.getBooleanProperty(PROP_BLOCK_XG);
            boolean isStrict = this._context.commSystem().isInStrictCountry();
            boolean shouldRemove = false;
            if (this._context.commSystem().isInStrictCountry(key)) {
                if (!this._context.banlist().isBanlisted(key)) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> " + (isHidden ? "Hidden mode active and router is in same country" : (blockMyCountry ? "i2np.hideMyCountry=true" : "Our router is in a strict country")));
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning " + (caps != null && !caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + key.toBase64().substring(0, 6) + "] for duration of session -> Router is in our country");
                    }
                    if (blockMyCountry) {
                        this._context.banlist().banlistRouterForever(key, " <b>\u279c</b> In our country (banned via config)");
                    } else {
                        this._context.banlist().banlistRouterForever(key, " <b>\u279c</b> In our country (we are in a strict country)");
                    }
                }
            } else if (blockedCountries.contains(country) && !this._context.banlist().isBanlisted(key)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning and disconnecting from [" + key.toBase64().substring(0, 6) + "] -> Blocked country: " + country);
                }
                this._context.banlist().banlistRouter(key, " <b>\u279c</b> Blocked country: " + country, null, null, this._context.clock().now() + 28800000L);
                this._context.simpleTimer2().addEvent(new Disconnector(key), 3000L);
                shouldRemove = true;
            } else if (!isUs && isG && isNotRorU && isXTier && blockXG && !this._context.banlist().isBanlisted(key)) {
                if (!this._context.banlist().isBanlisted(key)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> X tier and G Cap, neither R nor U");
                    }
                    if (this._log.shouldWarn() && !this._context.banlist().isBanlisted(key)) {
                        this._log.warn("Banning " + (caps != null && !caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + key.toBase64().substring(0, 6) + "] for 4h -> XG and older than 0.9.61 (using proxy?)");
                    }
                    this._context.banlist().banlistRouter(key, " <b>\u279c</b> XG Router, neither R nor U (proxied?)", null, null, this._context.clock().now() + 14400000L);
                    shouldRemove = false;
                }
            } else if (!isUs && isLTier && isUnreachable && isOld) {
                if (!this._context.banlist().isBanlisted(key)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> LU and older than 0.9.61");
                    }
                    if (this._log.shouldWarn() && !this._context.banlist().isBanlisted(key)) {
                        String capsMessage = caps == null || caps.isEmpty() ? DEFAULT_BLOCK_COUNTRIES : caps;
                        this._log.warn("Banning " + capsMessage + ' ' + (isFF ? "Floodfill" : "Router") + " [" + key.toBase64().substring(0, 6) + "] for 4h -> LU and older than 0.9.61");
                    }
                    this._context.banlist().banlistRouter(key, " <b>\u279c</b> LU and older than 0.9.61", null, null, this._context.clock().now() + 14400000L);
                    shouldRemove = true;
                }
            } else if (key != null && this._context.banlist().isBanlistedForever(key)) {
                if (this._log.shouldInfo()) {
                    this._log.info("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> Permanently blocklisted");
                }
                shouldRemove = true;
            } else if (key != null && this._context.banlist().isBanlistedHostile(key)) {
                if (this._log.shouldInfo()) {
                    this._log.info("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> Blocklisted (tagged as hostile)");
                }
                shouldRemove = true;
            } else if (key != null && this.isNegativeCached(key)) {
                if (this._log.shouldInfo()) {
                    this._log.info("Dropping RouterInfo [" + key.toBase64().substring(0, 6) + "] -> Negatively cached");
                }
                if (onFailedLookupJob != null) {
                    this._context.jobQueue().addJob(onFailedLookupJob);
                }
            } else {
                this.search(key, onFindJob, onFailedLookupJob, timeoutMs, false);
            }
            if (shouldRemove) {
                this._ds.remove(key);
                this._kb.remove(key);
            }
        }
    }

    @Override
    public RouterInfo lookupRouterInfoLocally(Hash key) {
        if (!this._initialized) {
            return null;
        }
        if (this.isClientDb()) {
            return null;
        }
        DatabaseEntry ds = this._ds.get(key);
        if (ds != null) {
            if (ds.getType() == 0) {
                boolean valid = true;
                try {
                    valid = null == this.validate((RouterInfo)ds);
                }
                catch (IllegalArgumentException iae) {
                    valid = false;
                }
                if (!valid) {
                    this.fail(key);
                    return null;
                }
                return (RouterInfo)ds;
            }
            return null;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void publish(LeaseSet localLeaseSet) throws IllegalArgumentException {
        RepublishLeaseSetJob j;
        int code;
        if (!this._initialized) {
            if (this._log.shouldWarn()) {
                this._log.warn("Attempted to publish LOCAL LeaseSet before router fully initialized: " + localLeaseSet);
            }
            return;
        }
        Hash h = localLeaseSet.getHash();
        try {
            this.store(h, localLeaseSet, true);
        }
        catch (IllegalArgumentException iae) {
            this._log.error("Locally published LeaseSet is not valid", iae);
            throw iae;
        }
        if (!this._context.clientManager().shouldPublishLeaseSet(h)) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress() && ((code = this._context.router().scheduledGracefulExitCode()) == 2 || code == 3)) {
            return;
        }
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            j = this._publishingLeaseSets.get(h);
            if (j == null) {
                j = new RepublishLeaseSetJob(this._context, this, h);
                this._publishingLeaseSets.put(h, j);
            }
        }
        long nextTime = Math.max(j.lastPublished() + 90000L, this._context.clock().now() + 1000L);
        this._context.jobQueue().removeJob(j);
        j.getTiming().setStartAfter(nextTime);
        if (this._log.shouldInfo()) {
            this._log.info("Queueing LOCAL LeaseSet [" + h.toBase32().substring(0, 8) + "] for publication...\n* Publication time: " + new Date(nextTime));
        }
        this._context.jobQueue().addJob(j);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void stopPublishing(Hash target) {
        Map<Hash, RepublishLeaseSetJob> map = this._publishingLeaseSets;
        synchronized (map) {
            this._publishingLeaseSets.remove(target);
        }
    }

    @Override
    public void publish(RouterInfo localRouterInfo) throws IllegalArgumentException {
        if (this.isClientDb()) {
            throw new IllegalArgumentException("RouterInfo publication to client db attempted");
        }
        if (!this._initialized) {
            return;
        }
        if (this._context.router().gracefulShutdownInProgress()) {
            return;
        }
        if (this._context.router().isHidden()) {
            return;
        }
        Hash h = localRouterInfo.getIdentity().getHash();
        this.store(h, localRouterInfo);
    }

    void routerInfoPublishSuccessful() {
        this._lastRIPublishTime = this._context.clock().now();
    }

    @Override
    public long getLastRouterInfoPublishTime() {
        return this._lastRIPublishTime;
    }

    public String validate(Hash key, LeaseSet leaseSet) throws UnsupportedCryptoException {
        long latest;
        long earliest;
        LeaseSet2 ls2;
        if (!key.equals(leaseSet.getHash())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid NetDbStore attempt! Key does not match LeaseSet destination!\n* Key: [" + key.toBase32().substring(0, 8) + "]\n* LeaseSet: [" + leaseSet.getHash().toBase32().substring(0, 8) + "]");
            }
            return "Key does not match LeaseSet destination - " + key.toBase32();
        }
        if (!leaseSet.verifySignature()) {
            this.processStoreFailure(key, leaseSet);
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid LeaseSet signature! [" + leaseSet.getHash().toBase32().substring(0, 8) + "]");
            }
            return "Invalid LeaseSet signature on " + key;
        }
        int type = leaseSet.getType();
        if (type == 5) {
            ls2 = (LeaseSet2)leaseSet;
            earliest = ls2.getPublished();
            latest = ls2.getExpires();
        } else if (type == 7) {
            ls2 = (LeaseSet2)leaseSet;
            earliest = Math.min(ls2.getEarliestLeaseDate(), ls2.getPublished());
            latest = Math.min(ls2.getLatestLeaseDate(), ls2.getExpires());
        } else {
            earliest = leaseSet.getEarliestLeaseDate();
            latest = leaseSet.getLatestLeaseDate();
        }
        long now = this._context.clock().now();
        if (earliest <= now - 600000L || latest <= now - 60000L) {
            String id;
            long age = now - earliest;
            Destination dest = leaseSet.getDestination();
            String string = id = dest != null ? dest.toBase32() : leaseSet.getHash().toBase32();
            if (this._log.shouldWarn()) {
                this._log.warn("Old LeaseSet [" + id.substring(0, 6) + "] -> rejecting store...\n* First expired: " + new Date(earliest) + "\n* Last expired: " + new Date(latest) + "\n* " + leaseSet);
            }
            if (leaseSet.getLeaseCount() == 0) {
                for (int i = 0; i < 3; ++i) {
                    this.lookupFailed(key);
                }
            }
            return "LeaseSet for [" + id.substring(0, 6) + "] expired " + DataHelper.formatDuration(age) + " ago";
        }
        if (latest > now + 960000L && (leaseSet.getType() != 7 || latest > now + 65595000L)) {
            String id;
            long age = latest - now;
            Destination dest = leaseSet.getDestination();
            String string = id = dest != null ? dest.toBase32() : leaseSet.getHash().toBase32();
            if (this._log.shouldWarn()) {
                this._log.warn("LeaseSet expires too far in the future: [" + id.substring(0, 6) + "]\n* Expires: " + DataHelper.formatDuration(age) + " from now");
            }
            return "Future LeaseSet for [" + id.substring(0, 6) + "] expiring in " + DataHelper.formatDuration(age);
        }
        return null;
    }

    @Override
    public LeaseSet store(Hash key, LeaseSet leaseSet) throws IllegalArgumentException {
        return this.store(key, leaseSet, false);
    }

    public LeaseSet store(Hash key, LeaseSet leaseSet, boolean force) throws IllegalArgumentException {
        LeaseSet2 ls2;
        String err;
        Destination dest;
        LeaseSet rv;
        if (!this._initialized) {
            return null;
        }
        try {
            rv = (LeaseSet)this._ds.get(key);
            if (rv != null && !force && !KademliaNetworkDatabaseFacade.isNewer(leaseSet, rv)) {
                Hash to;
                if (this._log.shouldDebug()) {
                    this._log.debug("Not storing LeaseSet [" + key.toBase32().substring(0, 8) + "] -> Local copy is newer");
                }
                if ((to = leaseSet.getReceivedBy()) != null) {
                    rv.setReceivedBy(to);
                } else if (leaseSet.getReceivedAsReply()) {
                    rv.setReceivedAsReply();
                }
                if (leaseSet.getReceivedAsPublished()) {
                    rv.setReceivedAsPublished();
                }
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace RouterInfo with " + leaseSet);
        }
        if (rv != null && !force) {
            Destination d1 = leaseSet.getDestination();
            Destination d2 = rv.getDestination();
            if (d1 != null && d2 != null && !d1.equals(d2)) {
                throw new IllegalArgumentException("LeaseSet Hash collision");
            }
        }
        EncryptedLeaseSet encls = null;
        int type = leaseSet.getType();
        if (type == 5) {
            encls = (EncryptedLeaseSet)leaseSet;
            BlindData bd = this.blindCache().getReverseData(leaseSet.getSigningKey());
            if (bd != null) {
                String secret;
                if (this._log.shouldWarn()) {
                    this._log.warn("Found blind data for encrypted LeaseSet: " + bd);
                }
                if ((secret = bd.getSecret()) != null) {
                    encls.setSecret(secret);
                }
                if ((dest = bd.getDestination()) != null) {
                    encls.setDestination(dest);
                } else {
                    encls.setSigningKey(bd.getUnblindedPubKey());
                }
                if (bd.getAuthType() != 0) {
                    encls.setClientPrivateKey(bd.getAuthPrivKey());
                }
            } else if (encls.getDecryptedLeaseSet() == null && this._log.shouldWarn()) {
                this._log.warn("No blind data found for encrypted LeaseSet: " + leaseSet);
            }
        }
        if ((err = this.validate(key, leaseSet)) != null) {
            throw new IllegalArgumentException("Invalid NetDbStore attempt -> " + err);
        }
        if (force) {
            this._ds.forcePut(key, leaseSet);
        } else {
            this._ds.put(key, leaseSet);
        }
        if (encls != null) {
            LeaseSet2 decls = encls.getDecryptedLeaseSet();
            if (decls != null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Successfully decrypted encrypted LeaseSet: " + decls);
                }
                dest = decls.getDestination();
                this.store(dest.getHash(), decls);
                this.blindCache().setBlinded(dest);
            }
        } else if ((type == 3 || type == 7) && (ls2 = (LeaseSet2)leaseSet).isBlindedWhenPublished() && (dest = leaseSet.getDestination()) != null) {
            this.blindCache().setBlinded(dest, null, null);
        }
        return rv;
    }

    public static boolean isNewer(LeaseSet a, LeaseSet b) {
        if (a.getType() != 1 && b.getType() != 1) {
            return ((LeaseSet2)a).getPublished() > ((LeaseSet2)b).getPublished();
        }
        return a.getEarliestLeaseDate() > b.getEarliestLeaseDate();
    }

    private String validate(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        if (!key.equals(routerInfo.getIdentity().getHash())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid NetDbStore attempt! Key [" + key.toBase64().substring(0, 6) + "] does not match identity for RouterInfo [" + routerInfo.getIdentity().getHash().toBase64().substring(0, 6) + "]");
            }
            return "Key does not match routerInfo.identity";
        }
        if (!routerInfo.isValid()) {
            this.processStoreFailure(key, routerInfo);
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid RouterInfo signature detected for [" + routerInfo.getIdentity().getHash().toBase64().substring(0, 6) + "]");
            }
            return "Invalid RouterInfo signature";
        }
        int id = routerInfo.getNetworkId();
        if (id != this._networkID) {
            if (id == -1) {
                this._context.banlist().banlistRouter(key, " <b>\u279c</b> No Network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(key, " <b>\u279c</b> Not in our Network: " + id);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("BAD Network detected for [" + routerInfo.getIdentity().getHash().toBase64().substring(0, 6) + "]");
            }
            return "Not in our network";
        }
        FamilyKeyCrypto fkc = this._context.router().getFamilyKeyCrypto();
        if (fkc != null) {
            FamilyKeyCrypto.Result r = fkc.verify(routerInfo);
            switch (r) {
                case BAD_KEY: 
                case INVALID_SIG: {
                    Hash h = routerInfo.getHash();
                    if (h.equals(this._context.routerHash())) break;
                    return "BAD Family " + (Object)((Object)r) + ' ' + h;
                }
                case NO_SIG: {
                    break;
                }
            }
        }
        return this.validate(routerInfo);
    }

    String validate(RouterInfo routerInfo) throws IllegalArgumentException {
        boolean isOlderThanCurrent;
        boolean dontFail;
        if (!this.isInitialized() || this._context.commSystem().isDummy()) {
            return null;
        }
        long now = this._context.clock().now();
        String validateUptime = this._context.getProperty(PROP_VALIDATE_ROUTERS_AFTER);
        Hash us = this._context.routerHash();
        boolean isUs = us.equals(routerInfo.getIdentity().getHash());
        long uptime = this._context.router().getUptime();
        boolean upLongEnough = uptime > 1200000L;
        boolean bl = dontFail = this._context.router().getUptime() < DONT_FAIL_PERIOD;
        if (validateUptime != null) {
            upLongEnough = this._context.router().getUptime() > (long)(Integer.parseInt(validateUptime) * 60 * 1000);
        }
        int existing = this._kb.size();
        String expireRI = this._context.getProperty(PROP_ROUTER_INFO_EXPIRATION_ADJUSTED);
        String routerId = DEFAULT_BLOCK_COUNTRIES;
        String v = routerInfo.getVersion();
        String minRouterVersion = "0.9.20";
        String MIN_VERSION = "0.9.62";
        String CURRENT_VERSION = "0.9.63";
        String minVersionAllowed = this._context.getProperty(PROP_MIN_ROUTER_VERSION);
        boolean isSlow = routerInfo != null && (routerInfo.getCapabilities().indexOf(75) >= 0 || routerInfo.getCapabilities().indexOf(76) >= 0 || routerInfo.getCapabilities().indexOf(77) >= 0) && !isUs;
        boolean isUnreachable = routerInfo != null && routerInfo.getCapabilities().indexOf(82) < 0;
        boolean isLTier = routerInfo != null && routerInfo.getCapabilities().indexOf(75) >= 0 || routerInfo.getCapabilities().indexOf(76) >= 0;
        boolean isBanned = routerInfo != null && this._context.banlist().isBanlisted(routerInfo.getIdentity().getHash());
        boolean isFF = false;
        String caps = DEFAULT_BLOCK_COUNTRIES;
        boolean noCountry = true;
        String country = "unknown";
        Hash h = null;
        boolean isOld = routerInfo != null && !isUs && VersionComparator.comp(v, MIN_VERSION) < 0;
        boolean bl2 = isOlderThanCurrent = routerInfo != null && !isUs && VersionComparator.comp(v, CURRENT_VERSION) < 0;
        if (routerInfo != null) {
            routerId = routerInfo.getIdentity().getHash().toBase64().substring(0, 6);
            caps = routerInfo.getCapabilities().toUpperCase();
            h = routerInfo.getIdentity().getHash();
            if (caps != null && caps.contains("F")) {
                isFF = true;
            }
            if ((country = this._context.commSystem().getCountry(h)) != null && country != "unknown") {
                noCountry = false;
            }
            for (RouterAddress ra : routerInfo.getTargetAddresses("NTCP2")) {
                String i = ra.getOption("i");
                if (i == null || i.length() == 24) continue;
                this._context.banlist().banlistRouter(routerInfo.getIdentity().calculateHash(), " <b>\u279c</b> Invalid NTCP address", null, null, now + 86400000L);
                if (this._log.shouldWarn() && !isBanned) {
                    this._log.warn("Banning " + (!caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + routerId + "] for 24h -> Invalid NTCP address");
                }
                return "Invalid NTCP address";
            }
            long adjustedExpiration = expireRI != null ? (long)(Integer.parseInt(expireRI) * 60 * 60 * 1000) : (this.floodfillEnabled() ? 14400000L : (existing > 4000 ? 28800000L : (existing > 3000 ? 43200000L : (existing > 2000 ? 57600000L : 86400000L))));
            boolean blockMyCountry = this._context.getBooleanProperty(PROP_BLOCK_MY_COUNTRY);
            boolean blockXG = this._context.getBooleanProperty(PROP_BLOCK_XG);
            boolean isHidden = this._context.router().isHidden();
            boolean isStrict = this._context.commSystem().isInStrictCountry();
            boolean isXTier = routerInfo.getCapabilities().indexOf(88) >= 0;
            boolean isNotRorU = routerInfo.getCapabilities().indexOf(85) < 0 && routerInfo.getCapabilities().indexOf(82) < 0;
            boolean isG = routerInfo.getCapabilities().indexOf(71) >= 0;
            Set<String> blockedCountries = this.getBlockedCountries();
            if (isStrict || isHidden || blockMyCountry) {
                String myCountry = this._context.getProperty(PROP_IP_COUNTRY);
                if (myCountry != null && myCountry == country && !this._context.banlist().isBanlisted(h)) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Dropping RouterInfo [" + h.toBase64().substring(0, 6) + "] -> " + (isHidden ? "Hidden mode active and router is in same country" : (isStrict ? "We are in a strict country and so is this router" : "i2np.hideMyCountry=true")));
                    }
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning " + (!caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + h.toBase64().substring(0, 6) + "] for duration of session -> Router is in our country");
                    }
                    if (blockMyCountry) {
                        this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> In our country (banned via config)");
                    } else if (isHidden) {
                        this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> In our country (we are in Hidden mode)");
                    } else if (isStrict) {
                        this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> In our country (we are in a strict country)");
                    }
                }
            } else if (blockedCountries.contains(country) && !this._context.banlist().isBanlisted(h)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning and disconnecting from [" + h.toBase64().substring(0, 6) + "] -> Blocked country: " + country);
                }
                this._context.banlist().banlistRouter(h, " <b>\u279c</b> Blocked country: " + country, null, null, this._context.clock().now() + 28800000L);
                this._context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            } else if (!isUs && isG && isNotRorU && isXTier && blockXG) {
                if (!this._context.banlist().isBanlisted(h)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + h.toBase64().substring(0, 6) + "] -> X tier and G Cap, neither R nor U");
                    }
                    if (this._log.shouldWarn() && !this._context.banlist().isBanlisted(h)) {
                        this._log.warn("Banning " + (!caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + h.toBase64().substring(0, 6) + "] for 4h -> XG and older than 0.9.61 (using proxy?)");
                    }
                    this._context.banlist().banlistRouter(h, " <b>\u279c</b> XG Router, neither R nor U (proxied?)", null, null, this._context.clock().now() + 14400000L);
                }
            } else if (upLongEnough && !isUs && !routerInfo.isCurrent(adjustedExpiration)) {
                long age = now - routerInfo.getPublished();
                if (existing >= 100) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + routerInfo.getIdentity().getHash().toBase64().substring(0, 6) + "] -> Published " + DataHelper.formatDuration(age) + " ago");
                    }
                    return "Published " + DataHelper.formatDuration(age) + " ago";
                }
                if (this._log.shouldWarn()) {
                    this._log.warn("Even though RouterInfo [" + routerInfo.getIdentity().getHash().toBase64().substring(0, 6) + "] is STALE, we have only " + existing + " peers left - not dropping...");
                }
            }
            if (routerInfo.getPublished() > now + 120000L && !isUs) {
                long age = routerInfo.getPublished() - now;
                if (this._log.shouldWarn() && !isBanned) {
                    this._log.warn("Banning [" + routerId + "] for 4h -> RouterInfo from the future!\n* Published: " + new Date(routerInfo.getPublished()));
                }
                this._context.banlist().banlistRouter(h, " <b>\u279c</b> RouterInfo from the future (" + new Date(routerInfo.getPublished()) + ")", null, null, 14400000L);
                return caps + " Router [" + routerId + "] -> Published " + DataHelper.formatDuration(age) + " in the future";
            }
            if (isLTier && isUnreachable && isOld) {
                if (!isBanned && this._log.shouldWarn() && !this._context.banlist().isBanlisted(h)) {
                    this._log.warn("Banning " + (!caps.isEmpty() ? caps : DEFAULT_BLOCK_COUNTRIES) + ' ' + (isFF ? "Floodfill" : "Router") + " [" + routerId + "] for 4h -> LU and older than 0.9.61");
                }
                this._context.banlist().banlistRouter(h, " <b>\u279c</b> LU and older than 0.9.61", null, null, this._context.clock().now() + 14400000L);
            } else if (minVersionAllowed != null) {
                if (VersionComparator.comp(v, minVersionAllowed) < 0) {
                    this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> Router too old (" + v + ")");
                    return caps + " Router [" + routerId + "] -> Too old (" + v + ") - banned until restart";
                }
            } else if (VersionComparator.comp(v, minRouterVersion) < 0) {
                this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> Router too old (" + v + ")");
                return caps + " Router [" + routerId + "] -> Too old (" + v + ") - banned until restart";
            }
            if (uptime > 600000L && existing > 500 && isSlow && routerInfo.getPublished() < now - 3600000L) {
                if (this._log.shouldInfo()) {
                    this._log.info("Dropping RouterInfo [" + routerId + "] -> K, L or M tier and published over 1h ago");
                }
                return caps + " Router [" + routerId + "] -> Slow and published over 1h ago";
            }
            if (isSlow && routerInfo.getPublished() < now - 0x6DDD00L) {
                if (this._log.shouldInfo()) {
                    this._log.info("Dropping RouterInfo [" + routerId + "] -> K, L or M tier and published over 2h ago");
                }
                return caps + " Router [" + routerId + "] -> Slow and published over 2h ago";
            }
            if (!(dontFail || routerInfo.isCurrent(3240000L) || isUs)) {
                if (routerInfo.getAddresses().isEmpty()) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + routerId + "] -> No addresses and published over 54m ago");
                    }
                    return caps + " Router [" + routerId + "] -> No addresses and published over 54m ago";
                }
                if (!isUs && routerInfo.getCapabilities().indexOf(85) >= 0 || routerInfo.getAddresses().isEmpty()) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + routerId + "] -> Unreachable and published over 54m ago");
                    }
                    return caps + " Router [" + routerId + "] -> Unreachable and published over 54m ago";
                }
                for (RouterAddress ra : routerInfo.getAddresses()) {
                    if (ra.getOption("itag0") == null) continue;
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping RouterInfo [" + routerId + "] -> SSU Introducers and published over 54m ago");
                    }
                    return caps + " Router [" + routerId + "] -> SSU Introducers and published over 54m ago";
                }
            }
            if (expireRI != null && !isUs) {
                if (upLongEnough && routerInfo.getPublished() < now - Long.parseLong(expireRI) * 60L * 60L * 1000L) {
                    long age = now - routerInfo.getPublished();
                    return caps + " Router [" + routerId + "] -> Published " + DataHelper.formatDuration(age) + " ago";
                }
            } else if (upLongEnough && routerInfo.getPublished() < now - 86400000L && !isUs) {
                long age = this._context.clock().now() - routerInfo.getPublished();
                return caps + " Router [" + routerId + "] -> Published " + DataHelper.formatDuration(age) + " ago";
            }
            if (!routerInfo.isCurrent(900000L)) {
                for (RouterAddress ra : routerInfo.getAddresses()) {
                    if (routerInfo.getTargetAddresses("NTCP", "NTCP2").isEmpty() && ra.getOption("ihost0") == null && !isUs) {
                        return caps + " Router [" + routerId + "] -> SSU only without Introducers and published over 15m ago";
                    }
                    if (!isUnreachable || isUs) continue;
                    return caps + " Router [" + routerId + "] -> Unreachable on any transport and published over 15m ago";
                }
            }
        }
        return null;
    }

    @Override
    public RouterInfo store(Hash key, RouterInfo routerInfo) throws IllegalArgumentException {
        return this.store(key, routerInfo, true);
    }

    RouterInfo store(Hash key, RouterInfo routerInfo, boolean persist) throws IllegalArgumentException {
        RouterInfo rv;
        if (!this._initialized) {
            return null;
        }
        if (this.isClientDb()) {
            throw new IllegalArgumentException("RI store to client DB");
        }
        try {
            rv = (RouterInfo)this._ds.get(key, persist);
            if (rv != null && rv.getPublished() >= routerInfo.getPublished()) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Not storing RouterInfo [" + key.toBase64().substring(0, 6) + "] -> Local copy is newer");
                }
                return rv;
            }
        }
        catch (ClassCastException cce) {
            throw new IllegalArgumentException("Attempt to replace LeaseSet with " + routerInfo);
        }
        if (rv != null && !routerInfo.getIdentity().equals(rv.getIdentity())) {
            throw new IllegalArgumentException("RouterInfo Hash collision");
        }
        String err = this.validate(key, routerInfo);
        if (err != null) {
            throw new IllegalArgumentException("Invalid NetDbStore attempt - " + err);
        }
        this._context.peerManager().setCapabilities(key, routerInfo.getCapabilities());
        this._ds.put(key, routerInfo, persist);
        if (rv == null) {
            this._kb.add(key);
        }
        return rv;
    }

    private void processStoreFailure(Hash h, DatabaseEntry entry) throws UnsupportedCryptoException {
        if (entry.getHash().equals(h)) {
            RouterInfo ri;
            RouterIdentity id;
            Certificate c;
            int etype = entry.getType();
            if (DatabaseEntry.isLeaseSet(etype)) {
                Certificate c2;
                LeaseSet ls = (LeaseSet)entry;
                Destination d = ls.getDestination();
                if (d != null && (c2 = d.getCertificate()).getCertificateType() == 5) {
                    try {
                        KeyCertificate kc = c2.toKeyCertificate();
                        SigType type = kc.getSigType();
                        if (type == null || !type.isAvailable() || type.getBaseAlgorithm() == SigAlgo.RSA) {
                            String stype;
                            this.failPermanently(d);
                            String string = stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                            if (this._log.shouldWarn()) {
                                this._log.warn("Unsupported Signature type " + stype + " for destination " + h);
                            }
                            throw new UnsupportedCryptoException("Sig type " + stype);
                        }
                    }
                    catch (DataFormatException kc) {}
                }
            } else if (etype == 0 && (c = (id = (ri = (RouterInfo)entry).getIdentity()).getCertificate()).getCertificateType() == 5) {
                try {
                    KeyCertificate kc = c.toKeyCertificate();
                    SigType type = kc.getSigType();
                    if (type == null || !type.isAvailable()) {
                        String stype = type != null ? type.toString() : Integer.toString(kc.getSigTypeCode());
                        this._context.banlist().banlistRouterForever(h, " <b>\u279c</b> Unsupported Signature type " + stype);
                        if (this._log.shouldWarn()) {
                            this._log.warn("Unsupported Signature type " + stype + " for [" + h.toBase64().substring(0, 6) + "] - banned until restart");
                        }
                        throw new UnsupportedCryptoException("Sig type " + stype);
                    }
                }
                catch (DataFormatException dataFormatException) {
                    // empty catch block
                }
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("RouterInfo verification failure (Unknown cause)\n" + entry);
        }
    }

    @Override
    public void fail(Hash dbEntry) {
        if (!this._initialized) {
            return;
        }
        DatabaseEntry o = this._ds.get(dbEntry);
        if (o == null) {
            if (this._kb != null) {
                this._kb.remove(dbEntry);
            }
            this._context.peerManager().removeCapabilities(dbEntry);
            return;
        }
        if (o.getType() == 0) {
            this.lookupBeforeDropping(dbEntry, (RouterInfo)o);
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.info("Dropping LeaseSet [" + dbEntry.toBase32().substring(0, 8) + "] -> Lookup / tunnel failure");
        }
        if (!this.isClientDb()) {
            this._ds.remove(dbEntry, false);
        } else {
            this._ds.remove(dbEntry);
        }
    }

    protected void lookupBeforeDropping(Hash peer, RouterInfo info) {
        this.dropAfterLookupFailed(peer);
    }

    boolean dropAfterLookupFailed(Hash peer) {
        if (this.isClientDb()) {
            return false;
        }
        boolean loggedFailure = false;
        int count = 0;
        if (count == 0) {
            this._context.peerManager().removeCapabilities(peer);
            this._negativeCache.cache(peer);
            this._kb.remove(peer);
            this._ds.remove(peer);
            if (this._log.shouldInfo() && !loggedFailure) {
                this._log.info("Dropping RouterInfo [" + peer.toBase64().substring(0, 6) + "] -> Lookup failure");
                loggedFailure = true;
            }
            ++count;
        }
        return loggedFailure;
    }

    @Override
    public void unpublish(LeaseSet localLeaseSet) {
        if (!this._initialized) {
            return;
        }
        Hash h = localLeaseSet.getHash();
        DatabaseEntry data = this._ds.remove(h);
        if (data == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unpublishing UNKNOWN LOCAL LeaseSet [" + h.toBase32().substring(0, 8) + "]");
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Unpublishing LOCAL LeaseSet [" + h.toBase32().substring(0, 8) + "]");
        }
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease) {
        throw new UnsupportedOperationException();
    }

    SearchJob search(Hash key, Job onFindJob, Job onFailedLookupJob, long timeoutMs, boolean isLease, Hash fromLocalDest) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Set<LeaseSet> getLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (!o.isLeaseSet()) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<LeaseSet> getClientLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (!o.isLeaseSet()) continue;
            Hash key = o.getHash();
            boolean isLocal = !o.getReceivedAsPublished() && !o.getReceivedAsReply();
            if (!isLocal) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<LeaseSet> getPublishedLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            boolean isLocal;
            if (!o.isLeaseSet()) continue;
            Hash key = o.getHash();
            boolean bl = isLocal = !o.getReceivedAsPublished() && !o.getReceivedAsReply();
            boolean published = this._context.clientManager().shouldPublishLeaseSet(key);
            if (!published || !isLocal) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<LeaseSet> getUnpublishedLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            boolean isLocal;
            if (!o.isLeaseSet()) continue;
            Hash key = o.getHash();
            boolean published = this._context.clientManager().shouldPublishLeaseSet(key);
            boolean bl = isLocal = !o.getReceivedAsPublished() && !o.getReceivedAsReply();
            if (published || !isLocal) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<LeaseSet> getFloodfillLeases() {
        if (!this._initialized) {
            return null;
        }
        HashSet<LeaseSet> leases = new HashSet<LeaseSet>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (!o.isLeaseSet() || this.isClientDb()) continue;
            leases.add((LeaseSet)o);
        }
        return leases;
    }

    @Override
    public Set<RouterInfo> getRouters() {
        if (this.isClientDb()) {
            return Collections.emptySet();
        }
        if (!this._initialized) {
            return null;
        }
        HashSet<RouterInfo> routers = new HashSet<RouterInfo>();
        for (DatabaseEntry o : this.getDataStore().getEntries()) {
            if (!o.isRouterInfo()) continue;
            routers.add((RouterInfo)o);
        }
        return routers;
    }

    public int getPeerTimeout(Hash peer) {
        double responseTime;
        if (peer == null) {
            throw new IllegalArgumentException("Peer cannot be null");
        }
        PeerProfile prof = this._context.profileOrganizer().getProfile(peer);
        if (prof == null) {
            return 15000;
        }
        double d = responseTime = prof.getDbResponseTime() != null && prof.getDbResponseTime().getRate(3600000L) != null ? prof.getDbResponseTime().getRate(3600000L).getAvgOrLifetimeAvg() : 0.0;
        if (responseTime <= 0.0) {
            responseTime = 5000.0;
        } else if (responseTime > 5000.0) {
            responseTime = 5000.0;
        } else if (responseTime < 2500.0) {
            responseTime = 2500.0;
        }
        return 3 * (int)responseTime;
    }

    abstract void sendStore(Hash var1, DatabaseEntry var2, Job var3, Job var4, long var5, Set<Hash> var7);

    void lookupFailed(Hash key) {
        this._negativeCache.lookupFailed(key);
    }

    boolean isNegativeCached(Hash key) {
        boolean rv = this._negativeCache.isCached(key);
        if (rv) {
            this._context.statManager().addRateData("netDb.negativeCache", 1L);
        }
        return rv;
    }

    void failPermanently(Destination dest) {
        this._negativeCache.failPermanently(dest);
    }

    @Override
    public boolean isNegativeCachedForever(Hash key) {
        return this._negativeCache.getBadDest(key) != null;
    }

    @Override
    public void renderStatusHTML(Writer out) throws IOException {
        if (this._kb == null) {
            return;
        }
        out.write(this._kb.toString().replace("\n", "<br>\n"));
    }

    public String toString() {
        if (!this.isClientDb()) {
            return "MainNetDb";
        }
        return "ClientNetDb [" + this._dbid.toBase32().substring(0, 8) + "]";
    }

    private Set<String> getBlockedCountries() {
        String blockCountries = this._context.getProperty(PROP_BLOCK_COUNTRIES, DEFAULT_BLOCK_COUNTRIES);
        if (blockCountries.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(blockCountries.toLowerCase().split(",")));
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            KademliaNetworkDatabaseFacade.this._context.commSystem().forceDisconnect(this.h);
        }
    }
}

