/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileFilter;
import java.io.FileInputStream;
import java.io.Flushable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataFormatException;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.router.networkdb.kademlia.TransientDataStore;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileSuffixFilter;
import net.i2p.util.FileUtil;
import net.i2p.util.I2PThread;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public class PersistentDataStore
extends TransientDataStore {
    private final File _dbDir;
    private final KademliaNetworkDatabaseFacade _facade;
    private final Writer _writer;
    private final ReadJob _readJob;
    private volatile boolean _initialized;
    private final boolean _flat;
    private final int _networkID;
    private static final int READ_DELAY = 120000;
    private static final String PROP_FLAT = "router.networkDatabase.flat";
    static final String DIR_PREFIX = "r";
    private static final String B64 = "ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789-~";
    private static final int MAX_ROUTERS_INIT = 5000;
    private static final String PROP_ENABLE_REVERSE_LOOKUPS = "routerconsole.enableReverseLookups";
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";
    private static final int WRITE_LIMIT = 10000;
    private static final long WRITE_DELAY = 300000L;
    private static final String ROUTERINFO_PREFIX = "routerInfo-";
    private static final String ROUTERINFO_SUFFIX = ".dat";
    public static final FileFilter RI_FILTER = new FileSuffixFilter("routerInfo-", ".dat");

    @Override
    public boolean enableReverseLookups() {
        return this._context.getBooleanProperty(PROP_ENABLE_REVERSE_LOOKUPS);
    }

    public PersistentDataStore(RouterContext ctx, String dbDir, KademliaNetworkDatabaseFacade facade) throws IOException {
        super(ctx);
        this._networkID = ctx.router().getNetworkID();
        this._flat = ctx.getBooleanProperty(PROP_FLAT);
        this._dbDir = this.getDbDir(dbDir);
        this._facade = facade;
        this._readJob = new ReadJob();
        this._context.jobQueue().addJob(this._readJob);
        ctx.statManager().createRateStat("netDb.writeClobber", "How often we clobber a pending NetDb write", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writePending", "Number of pending NetDb writes", "NetworkDatabase", new long[]{60000L});
        ctx.statManager().createRateStat("netDb.writeOut", "Total number of NetDb writes", "NetworkDatabase", new long[]{1200000L});
        ctx.statManager().createRateStat("netDb.writeTime", "Total time used for NetDb writes ", "NetworkDatabase", new long[]{1200000L});
        this._writer = new Writer();
        I2PThread writer = new I2PThread(this._writer, "DBWriter");
        writer.start();
    }

    @Override
    public boolean isInitialized() {
        return this._initialized || this._readJob.isNetDbReady();
    }

    @Override
    public void stop() {
        super.stop();
        this._writer.flush();
    }

    @Override
    public void rescan() {
        if (this._initialized) {
            this._readJob.wakeup();
        }
    }

    @Override
    public DatabaseEntry get(Hash key) {
        return this.get(key, true);
    }

    @Override
    public DatabaseEntry get(Hash key, boolean persist) {
        DatabaseEntry rv = super.get(key);
        return rv;
    }

    @Override
    public DatabaseEntry remove(Hash key) {
        return this.remove(key, true);
    }

    @Override
    public DatabaseEntry remove(Hash key, boolean persist) {
        if (persist) {
            this._writer.remove(key);
        }
        return super.remove(key);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data) {
        return this.put(key, data, true);
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data, boolean persist) {
        if (data == null || key == null) {
            return false;
        }
        boolean rv = super.put(key, data);
        if (rv && persist && data.getType() == 0) {
            this._writer.queue(key, data);
        }
        return rv;
    }

    @Override
    public boolean forcePut(Hash key, DatabaseEntry data) {
        boolean rv = super.forcePut(key, data);
        if (rv && data.getType() == 0) {
            this._writer.queue(key, data);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void write(Hash key, DatabaseEntry data) {
        boolean shouldDelete;
        File dbFile;
        block51: {
            if (data == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Attempted to write NULL data for key: " + key);
                }
                return;
            }
            RouterInfo ri = (RouterInfo)data;
            boolean isHidden = this._context.router().isHidden();
            boolean isUs = key.equals(this._context.routerHash());
            OutputStream fos = null;
            dbFile = null;
            String filename = null;
            String MIN_VERSION = "0.9.62";
            String CURRENT_VERSION = "0.9.66";
            String v = MIN_VERSION;
            String bw = "K";
            String ip = null;
            String ourIP = null;
            ourIP = Addresses.toString(CommSystemFacadeImpl.getValidIP(this._context.router().getRouterInfo()));
            long uptime = this._context.router().getUptime();
            boolean unreachable = false;
            boolean reachable = false;
            boolean isFF = false;
            boolean hasIP = false;
            boolean noSSU = true;
            boolean isBadFF = isFF && noSSU;
            boolean isOld = VersionComparator.comp(v, MIN_VERSION) < 0;
            boolean isOlderThanCurrent = VersionComparator.comp(v, CURRENT_VERSION) < 0;
            boolean shouldDisconnect = this._context.getProperty(PROP_SHOULD_DISCONNECT, false);
            v = ri.getVersion();
            String caps = ri.getCapabilities();
            unreachable = caps.indexOf(85) >= 0 || caps.indexOf(82) < 0;
            reachable = caps.indexOf(82) >= 0;
            String country = "unknown";
            boolean noCountry = true;
            if (caps.contains("f")) {
                isFF = true;
            }
            if (ip != null) {
                hasIP = true;
            }
            bw = ri.getBandwidthTier();
            for (RouterAddress ra : ri.getAddresses()) {
                if (!ra.getTransportStyle().contains("SSU")) continue;
                noSSU = false;
                break;
            }
            boolean isSlow = ri != null && caps != null && caps != "unknown" && bw.equals("K") || bw.equals("L") || bw.equals("M");
            boolean isLTier = bw.equals("L");
            boolean isBanned = ri != null && (this._context.banlist().isBanlistedForever(key) || this._context.banlist().isBanlisted(key) || this._context.banlist().isBanlistedHostile(key));
            String version = ri != null ? ri.getVersion() : "0.8.0";
            boolean isInvalidVersion = VersionComparator.comp(version, "2.5.0") >= 0;
            shouldDelete = false;
            boolean shouldStore = !isBanned && !isLTier && !isSlow && !isInvalidVersion && !isOld && hasIP && !unreachable && !noSSU;
            try {
                if (data.getType() != 0) {
                    throw new IOException("We don't know how to write objects of type " + data.getClass().getName());
                }
                filename = this.getRouterInfoName(key);
                dbFile = new File(this._dbDir, filename);
                long dataPublishDate = PersistentDataStore.getPublishDate(data);
                if (this.enableReverseLookups() && uptime > 30000L && hasIP) {
                    String string;
                    ip = ri != null ? Addresses.toString(CommSystemFacadeImpl.getValidIP(ri)) : null;
                    String string2 = string = ip != null ? this._context.commSystem().getCanonicalHostName(ip) : null;
                }
                if (dbFile.lastModified() < dataPublishDate && (shouldStore || isUs)) {
                    fos = new SecureFileOutputStream(dbFile);
                    fos = new BufferedOutputStream(fos);
                    try {
                        data.writeBytes(fos);
                        fos.close();
                        dbFile.setLastModified(dataPublishDate);
                        if (this._log.shouldDebug()) {
                            this._log.debug("Writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk");
                        }
                        break block51;
                    }
                    catch (DataFormatException dfe) {
                        this._log.error("Error writing out malformed object as [" + key.toBase64().substring(0, 6) + "]: " + data, dfe);
                        shouldDelete = true;
                    }
                    break block51;
                }
                if (ri != null && !isUs && !isBanned) {
                    if (!isUs && hasIP && ip.equals(ourIP)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Banning and disconnecting from [" + key.toBase64().substring(0, 6) + "] for 72h -> Router is spoofing our IP address!");
                        }
                        this._context.banlist().banlistRouter(key, " <b>\u279c</b> Spoofed IP address (ours)", null, null, this._context.clock().now() + 259200000L);
                        this._context.simpleTimer2().addEvent(new Disconnector(key), 3000L);
                        shouldDelete = true;
                    } else if (isInvalidVersion) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> Invalid version in RouterInfo (" + version + ")");
                        }
                        if (this._log.shouldWarn() && !isBanned) {
                            this._log.warn("Banning for 24h and disconnecting from Router [" + key.toBase64().substring(0, 6) + "] -> Invalid version " + version + " / " + bw + (unreachable ? "U" : ""));
                            this._context.banlist().banlistRouter(key, " <b>\u279c</b> Invalid Router version (" + version + " / " + bw + (unreachable ? "U" : (reachable ? "R" : "")) + ")", null, null, this._context.clock().now() + 86400000L);
                        }
                        this._context.simpleTimer2().addEvent(new Disconnector(key), 3000L);
                        shouldDelete = true;
                    } else if (isLTier && unreachable && isOld) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> LU and older than " + MIN_VERSION);
                        }
                        if (this._log.shouldWarn() && !isBanned) {
                            this._log.warn("Banning [" + key.toBase64().substring(0, 6) + "] for 8h -> LU and older than " + MIN_VERSION);
                            this._context.banlist().banlistRouter(key, " <b>\u279c</b> LU and older than " + MIN_VERSION, null, null, this._context.clock().now() + 28800000L);
                        }
                        this._context.simpleTimer2().addEvent(new Disconnector(key), 660000L);
                        shouldDelete = true;
                    } else if (unreachable) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> Unreachable");
                        }
                        shouldDelete = true;
                    } else if (isSlow) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> K, L, M or N tier");
                        }
                        shouldDelete = true;
                    } else if (isOld) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> Older than " + MIN_VERSION);
                        }
                        shouldDelete = true;
                    } else if (noSSU) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> No SSU transport");
                        }
                        shouldDelete = true;
                    } else if (this._log.shouldDebug()) {
                        this._log.debug("Not writing RouterInfo [" + key.toBase64().substring(0, 6) + "] to disk -> Local copy is newer");
                    }
                }
            }
            catch (IOException ioe) {
                if (this._log.shouldDebug()) {
                    this._log.error("Error writing to disk", ioe);
                } else {
                    this._log.error("Error writing to disk (" + ioe.getMessage() + ")");
                }
            }
            finally {
                if (fos != null) {
                    try {
                        fos.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (shouldDelete && dbFile != null) {
            dbFile.delete();
        }
    }

    private static long getPublishDate(DatabaseEntry data) {
        return data.getDate();
    }

    private File getDbDir(String dbDir) throws IOException {
        boolean created;
        SecureDirectory f = new SecureDirectory(this._context.getRouterDir(), dbDir);
        if (!f.exists() && !(created = ((File)f).mkdirs())) {
            throw new IOException("Unable to create the NetDb directory [" + f.getAbsolutePath() + "]");
        }
        if (!f.isDirectory()) {
            throw new IOException("NetDb directory [" + f.getAbsolutePath() + "] is not a directory!");
        }
        if (!f.canRead()) {
            throw new IOException("NetDb directory [" + f.getAbsolutePath() + "] is not readable!");
        }
        if (!f.canWrite()) {
            throw new IOException("NetDb directory [" + f.getAbsolutePath() + "] is not writable!");
        }
        if (this._flat) {
            PersistentDataStore.unmigrate(f);
        } else {
            for (int j = 0; j < B64.length(); ++j) {
                SecureDirectory subdir = new SecureDirectory(f, DIR_PREFIX + B64.charAt(j));
                if (subdir.exists()) continue;
                ((File)subdir).mkdir();
            }
            File[] routerInfoFiles = f.listFiles(RI_FILTER);
            if (routerInfoFiles != null) {
                PersistentDataStore.migrate(f, routerInfoFiles);
            }
        }
        return f;
    }

    private static void unmigrate(File dbdir) {
        for (int j = 0; j < B64.length(); ++j) {
            File subdir = new File(dbdir, DIR_PREFIX + B64.charAt(j));
            File[] files = subdir.listFiles(RI_FILTER);
            if (files == null) continue;
            for (int i = 0; i < files.length; ++i) {
                File from = files[i];
                File to = new File(dbdir, from.getName());
                FileUtil.rename(from, to);
            }
        }
    }

    private static void migrate(File dbdir, File[] files) {
        for (int i = 0; i < files.length; ++i) {
            File from = files[i];
            if (!from.isFile()) continue;
            File dir = new File(dbdir, DIR_PREFIX + from.getName().charAt(ROUTERINFO_PREFIX.length()));
            File to = new File(dir, from.getName());
            FileUtil.rename(from, to);
        }
    }

    private String getRouterInfoName(Hash hash) {
        String b64 = hash.toBase64();
        if (this._flat) {
            return ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX;
        }
        return DIR_PREFIX + b64.charAt(0) + File.separatorChar + ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX;
    }

    public static File getRouterInfoFile(RouterContext ctx, Hash hash) {
        String b64 = hash.toBase64();
        File dir = new File(ctx.getRouterDir(), ctx.getProperty("router.networkDatabase.dbDir", "netDb"));
        if (ctx.getBooleanProperty(PROP_FLAT)) {
            return new File(dir, ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX);
        }
        return new File(dir, DIR_PREFIX + b64.charAt(0) + File.separatorChar + ROUTERINFO_PREFIX + b64 + ROUTERINFO_SUFFIX);
    }

    static Hash getRouterInfoHash(String filename) {
        return PersistentDataStore.getHash(filename, ROUTERINFO_PREFIX, ROUTERINFO_SUFFIX);
    }

    private static Hash getHash(String filename, String prefix, String suffix) {
        try {
            String key = filename.substring(prefix.length());
            key = key.substring(0, key.length() - suffix.length());
            byte[] b = Base64.decode(key);
            if (b == null) {
                return null;
            }
            Hash h = Hash.create(b);
            return h;
        }
        catch (RuntimeException e) {
            return null;
        }
    }

    private void removeFile(Hash key, File dir) throws IOException {
        String riName = this.getRouterInfoName(key);
        File f = new File(dir, riName);
        if (f.exists()) {
            boolean removed = f.delete();
            if (!removed && f.exists()) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Unable to delete " + f.getAbsolutePath() + " -> Previously deleted?");
                }
            } else if (this._log.shouldDebug()) {
                this._log.debug("Deleted " + f.getAbsolutePath());
            }
            return;
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            PersistentDataStore.this._context.commSystem().forceDisconnect(this.h);
        }
    }

    private class ReadRouterJob
    extends JobImpl {
        private final File _routerFile;
        private final Hash _key;
        private long _knownDate;

        public ReadRouterJob(File routerFile, Hash key) {
            super(PersistentDataStore.this._context);
            this._routerFile = routerFile;
            this._key = key;
        }

        @Override
        public String getName() {
            return "Read RouterInfo";
        }

        private boolean shouldRead() {
            DatabaseEntry data = PersistentDataStore.this.get(this._key, false);
            if (data == null) {
                return true;
            }
            if (data.getType() == 0) {
                this._knownDate = ((RouterInfo)data).getPublished();
                long fileDate = this._routerFile.lastModified();
                return fileDate > this._knownDate + 3600000L;
            }
            PersistentDataStore.this._log.error("Prevented LeaseSet overwrite by RouterInfo [" + this._key.toBase64().substring(0, 6) + "] from " + this._routerFile);
            return false;
        }

        @Override
        public void runJob() {
            this.read();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean read() {
            boolean corrupt;
            block50: {
                if (this._routerFile.length() > 4096L) {
                    if (PersistentDataStore.this._log.shouldWarn()) {
                        PersistentDataStore.this._log.warn("RouterInfo file [" + this._routerFile + "] exceeds maximum permitted size of 4KB -> " + this._routerFile.length() + "bytes");
                    }
                    this._routerFile.delete();
                    return false;
                }
                if (!this.shouldRead()) {
                    return false;
                }
                if (PersistentDataStore.this._log.shouldDebug()) {
                    PersistentDataStore.this._log.debug("Reading " + this._routerFile);
                }
                InputStream fis = null;
                corrupt = false;
                try {
                    fis = new FileInputStream(this._routerFile);
                    fis = new BufferedInputStream(fis);
                    RouterInfo ri = new RouterInfo();
                    ri.readBytes(fis, true);
                    Hash h = ri.getIdentity().calculateHash();
                    String v = ri.getVersion();
                    String MIN_VERSION = "0.9.62";
                    String ip = null;
                    String truncHash = "";
                    Hash us = PersistentDataStore.this._context.routerHash();
                    boolean isUs = ri != null && us.equals(ri.getIdentity().getHash());
                    boolean isOldVersion = ri != null && VersionComparator.comp(v, MIN_VERSION) < 0;
                    boolean isSlow = ri != null && (ri.getCapabilities().indexOf(85) >= 0 || ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0 || ri.getCapabilities().indexOf(77) >= 0) && !isUs;
                    boolean isFF = false;
                    boolean hasIP = false;
                    boolean noSSU = true;
                    String caps = "unknown";
                    if (ri != null) {
                        truncHash = h.toBase64().substring(0, 6);
                        caps = ri.getCapabilities();
                        ip = Addresses.toString(CommSystemFacadeImpl.getValidIP(ri));
                        if (caps.contains("f")) {
                            isFF = true;
                        }
                        if (ip != null) {
                            hasIP = true;
                        }
                        for (RouterAddress ra : ri.getAddresses()) {
                            if (!ra.getTransportStyle().contains("SSU")) continue;
                            noSSU = false;
                            break;
                        }
                    }
                    boolean isBadFF = isFF && noSSU;
                    long now = PersistentDataStore.this._context.clock().now();
                    if (ri.getNetworkId() != PersistentDataStore.this._networkID) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldError()) {
                            PersistentDataStore.this._log.error("Router [" + truncHash + "] is from a different network");
                        }
                        this._routerFile.delete();
                        break block50;
                    }
                    if (!h.equals(this._key)) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldWarn()) {
                            PersistentDataStore.this._log.warn("RouterInfo [" + truncHash + "] does not match [" + this._key.toBase64().substring(0, 6) + "] from " + this._routerFile);
                        }
                        PersistentDataStore.this._log.warn("Banning: [" + truncHash + "] for 1h -> Corrupt RouterInfo");
                        PersistentDataStore.this._context.banlist().banlistRouter(this._key, " <b>\u279c</b> Corrupt RouterInfo", null, null, now + 3600000L);
                        this._routerFile.delete();
                        break block50;
                    }
                    if (ri.getPublished() <= this._knownDate) {
                        if (PersistentDataStore.this._log.shouldInfo()) {
                            PersistentDataStore.this._log.info("Skipping since NetDb copy is newer than " + this._routerFile);
                        }
                        break block50;
                    }
                    if (isSlow || isOldVersion) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldInfo()) {
                            if (ri.getCapabilities().indexOf(85) >= 0 || ri.getAddresses().isEmpty()) {
                                PersistentDataStore.this._log.info("Not writing RouterInfo [" + truncHash + "] to disk -> Unreachable");
                            } else if (isSlow) {
                                PersistentDataStore.this._log.info("Not writing RouterInfo [" + truncHash + "] to disk -> K, L or M tier");
                            } else if (isOldVersion) {
                                PersistentDataStore.this._log.info("Not writing RouterInfo [" + truncHash + "] to disk -> Older than " + MIN_VERSION);
                            }
                        }
                        break block50;
                    }
                    if (this.getContext().blocklist().isBlocklisted(ri)) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldWarn()) {
                            PersistentDataStore.this._log.warn("Not writing RouterInfo [" + truncHash + "] to disk -> Blocklisted");
                        }
                        break block50;
                    }
                    try {
                        PersistentDataStore.this._facade.store(ri.getIdentity().getHash(), ri, false);
                        this.getContext().profileManager().heardAbout(ri.getIdentity().getHash(), ri.getPublished());
                    }
                    catch (IllegalArgumentException iae) {
                        corrupt = true;
                        if (PersistentDataStore.this._log.shouldInfo()) {
                            PersistentDataStore.this._log.info("Rejected locally loaded RouterInfo [" + truncHash + "]\n* " + iae.getMessage());
                        }
                    }
                }
                catch (DataFormatException dfe) {
                    corrupt = true;
                    if (PersistentDataStore.this._log.shouldInfo()) {
                        PersistentDataStore.this._log.info("Deleted " + this._routerFile.getName() + " -> File is corrupt \n* " + dfe.getMessage());
                    }
                }
                catch (IOException ioe) {
                    corrupt = true;
                    if (PersistentDataStore.this._log.shouldInfo()) {
                        PersistentDataStore.this._log.info("Deleted " + this._routerFile.getName() + " -> Unable to read Router reference \n* " + ioe.getMessage());
                    }
                }
                catch (RuntimeException e) {
                    corrupt = true;
                    if (PersistentDataStore.this._log.shouldInfo()) {
                        PersistentDataStore.this._log.info("Deleted " + this._routerFile.getName() + " -> Unable to read Router reference \n* " + e.getMessage());
                    }
                }
                finally {
                    if (fis != null) {
                        try {
                            fis.close();
                        }
                        catch (IOException dfe) {}
                    }
                }
            }
            if (corrupt) {
                this._routerFile.delete();
            }
            return !corrupt;
        }
    }

    private class ReadJob
    extends JobImpl {
        private volatile long _lastModified;
        private volatile long _lastReseed;
        private volatile boolean _setNetDbReady;
        private static final int MIN_ROUTERS = 100;
        private static final long MIN_RESEED_INTERVAL = 5400000L;

        public ReadJob() {
            super(PersistentDataStore.this._context);
        }

        @Override
        public String getName() {
            return "Read NetDb";
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void runJob() {
            boolean shouldScan;
            if (this.getContext().router().gracefulShutdownInProgress()) {
                this.requeue(120000L);
                return;
            }
            long now = System.currentTimeMillis();
            long lastMod = PersistentDataStore.this._dbDir.lastModified();
            boolean bl = shouldScan = lastMod > this._lastModified || PersistentDataStore.this.size() < 110;
            if (!shouldScan && !PersistentDataStore.this._flat) {
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    if (subdir.lastModified() <= this._lastModified) continue;
                    shouldScan = true;
                    break;
                }
            }
            if (shouldScan) {
                if (PersistentDataStore.this._log.shouldDebug()) {
                    PersistentDataStore.this._log.debug("Scanning for new RouterInfo files in: " + PersistentDataStore.this._dbDir);
                }
                File file = PersistentDataStore.this._dbDir;
                synchronized (file) {
                    this.readFiles();
                }
                this._lastModified = now;
            }
            this.requeue(120000L);
        }

        public void wakeup() {
            this.requeue(0L);
        }

        public boolean isNetDbReady() {
            return this._setNetDbReady;
        }

        private void readFiles() {
            int count;
            int routerCount = 0;
            File[] routerInfoFiles = PersistentDataStore.this._dbDir.listFiles(RI_FILTER);
            if (PersistentDataStore.this._flat) {
                if (routerInfoFiles != null) {
                    routerCount = routerInfoFiles.length;
                    for (int i = 0; i < routerInfoFiles.length && PersistentDataStore.this._context.router().isAlive(); ++i) {
                        Hash key = PersistentDataStore.getRouterInfoHash(routerInfoFiles[i].getName());
                        if (key == null) continue;
                        new ReadRouterJob(routerInfoFiles[i], key).runJob();
                    }
                }
            } else {
                if (routerInfoFiles != null) {
                    PersistentDataStore.migrate(PersistentDataStore.this._dbDir, routerInfoFiles);
                }
                ArrayList<File> toRead = new ArrayList<File>(2048);
                for (int j = 0; j < PersistentDataStore.B64.length(); ++j) {
                    File subdir = new File(PersistentDataStore.this._dbDir, PersistentDataStore.DIR_PREFIX + PersistentDataStore.B64.charAt(j));
                    File[] files = subdir.listFiles(RI_FILTER);
                    if (files == null) continue;
                    long lastMod = subdir.lastModified();
                    if (routerCount >= 100 && lastMod <= this._lastModified) continue;
                    routerCount += files.length;
                    if (lastMod <= this._lastModified) continue;
                    for (int i = 0; i < files.length; ++i) {
                        toRead.add(files[i]);
                    }
                }
                Collections.shuffle(toRead, PersistentDataStore.this._context.random());
                int i = 0;
                for (File file : toRead) {
                    ReadRouterJob rrj;
                    if (i >= 5000 && !PersistentDataStore.this._initialized) {
                        file.delete();
                        continue;
                    }
                    Hash key = PersistentDataStore.getRouterInfoHash(file.getName());
                    if (key == null || !(rrj = new ReadRouterJob(file, key)).read()) continue;
                    if (i++ == 150 && SystemVersion.isSlow() && !PersistentDataStore.this._initialized) {
                        this._setNetDbReady = true;
                        PersistentDataStore.this._context.router().setNetDbReady();
                        continue;
                    }
                    if (i != 500 || this._setNetDbReady) continue;
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            }
            if (!PersistentDataStore.this._initialized) {
                PersistentDataStore.this._initialized = true;
                if (PersistentDataStore.this._facade.reseedChecker().checkReseed(routerCount)) {
                    this._lastReseed = PersistentDataStore.this._context.clock().now();
                } else if (!this._setNetDbReady) {
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            } else if (this._lastReseed < PersistentDataStore.this._context.clock().now() - 5400000L) {
                count = Math.min(routerCount, PersistentDataStore.this.size());
                if (count < 100) {
                    if (PersistentDataStore.this._facade.reseedChecker().checkReseed(count)) {
                        this._lastReseed = PersistentDataStore.this._context.clock().now();
                    }
                } else if (!this._setNetDbReady) {
                    this._setNetDbReady = true;
                    PersistentDataStore.this._context.router().setNetDbReady();
                }
            } else if (!this._setNetDbReady && (count = Math.min(routerCount, PersistentDataStore.this.size())) >= 100) {
                this._setNetDbReady = true;
                PersistentDataStore.this._context.router().setNetDbReady();
            }
        }
    }

    private class Writer
    implements Runnable,
    Flushable {
        private final Map<Hash, DatabaseEntry> _keys = new ConcurrentHashMap<Hash, DatabaseEntry>(64);
        private final Set<Hash> _keysToRemove = new ConcurrentHashSet<Hash>();
        private final Object _waitLock = new Object();
        private volatile boolean _quit;

        public void queue(Hash key, DatabaseEntry data) {
            boolean exists;
            int pending = this._keys.size();
            this._keysToRemove.remove(key);
            boolean bl = exists = null != this._keys.put(key, data);
            if (exists) {
                PersistentDataStore.this._context.statManager().addRateData("netDb.writeClobber", pending);
            }
            PersistentDataStore.this._context.statManager().addRateData("netDb.writePending", pending);
        }

        public void remove(Hash key) {
            this._keys.remove(key);
            this._keysToRemove.add(key);
        }

        private void removeQueued() {
            if (this._keysToRemove.isEmpty()) {
                return;
            }
            Iterator<Hash> iter = this._keysToRemove.iterator();
            while (iter.hasNext()) {
                Hash key = iter.next();
                iter.remove();
                try {
                    PersistentDataStore.this.removeFile(key, PersistentDataStore.this._dbDir);
                }
                catch (IOException ioe) {
                    if (!PersistentDataStore.this._log.shouldWarn()) continue;
                    PersistentDataStore.this._log.warn("Error removing key " + key, ioe);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            this._quit = false;
            Hash key = null;
            DatabaseEntry data = null;
            int count = 0;
            int lastCount = 0;
            long startTime = 0L;
            while (true) {
                Iterator<Map.Entry<Hash, DatabaseEntry>> iter = this._keys.entrySet().iterator();
                try {
                    Map.Entry<Hash, DatabaseEntry> entry = iter.next();
                    key = entry.getKey();
                    data = entry.getValue();
                    iter.remove();
                    ++count;
                }
                catch (NoSuchElementException nsee) {
                    lastCount = count;
                    count = 0;
                }
                catch (IllegalStateException ise) {
                    lastCount = count;
                    count = 0;
                }
                if (key != null) {
                    if (data != null) {
                        File ise = PersistentDataStore.this._dbDir;
                        synchronized (ise) {
                            PersistentDataStore.this.write(key, data);
                        }
                        data = null;
                    }
                    key = null;
                }
                if (count >= 10000) {
                    count = 0;
                }
                if (count != 0) continue;
                this.removeQueued();
                if (lastCount > 0) {
                    long time = PersistentDataStore.this._context.clock().now() - startTime;
                    if (PersistentDataStore.this._log.shouldDebug()) {
                        PersistentDataStore.this._log.debug(lastCount + " RouterInfo files saved to disk in " + time + "ms");
                    }
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeOut", lastCount);
                    PersistentDataStore.this._context.statManager().addRateData("netDb.writeTime", time);
                }
                if (this._quit) break;
                Object object = this._waitLock;
                synchronized (object) {
                    try {
                        this._waitLock.wait(300000L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
                startTime = PersistentDataStore.this._context.clock().now();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void flush() {
            Object object = this._waitLock;
            synchronized (object) {
                this._quit = true;
                this._waitLock.notifyAll();
            }
        }
    }
}

