/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Destination;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.networkdb.kademlia.KademliaNetworkDatabaseFacade;
import net.i2p.util.Log;

class RepublishLeaseSetJob
extends JobImpl {
    private final Log _log;
    public static final long REPUBLISH_LEASESET_TIMEOUT = 90000L;
    private static final int RETRY_DELAY = 5000;
    private final Hash _dest;
    private final KademliaNetworkDatabaseFacade _facade;
    private long _lastPublished;
    private final AtomicInteger failCount = new AtomicInteger(0);
    private String tunnelName = "";

    public RepublishLeaseSetJob(RouterContext ctx, KademliaNetworkDatabaseFacade facade, Hash destHash) {
        super(ctx);
        this._log = ctx.logManager().getLog(RepublishLeaseSetJob.class);
        this._facade = facade;
        this._dest = destHash;
    }

    @Override
    public String getName() {
        return "Republish Local LeaseSet";
    }

    @Override
    public void runJob() {
        long uptime = this.getContext().router().getUptime();
        if (!this.getContext().clientManager().shouldPublishLeaseSet(this._dest) || uptime < 300000L) {
            return;
        }
        try {
            if (this.getContext().clientManager().isLocal(this._dest)) {
                LeaseSet ls = this._facade.lookupLeaseSetLocally(this._dest);
                if (ls != null) {
                    String name;
                    this.tunnelName = this.getTunnelName(ls.getDestination());
                    String string = name = !this.tunnelName.equals("") ? " for '" + this.tunnelName + "'" : " for key";
                    if (!ls.isCurrent(60000L)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Not publishing expired LOCAL LeaseSet" + name + " [" + this._dest.toBase32().substring(0, 8) + "]", new Exception("Publish expired LOCAL lease?"));
                        }
                    } else {
                        if (this._log.shouldInfo()) {
                            this._log.info("Attempting to publish new LeaseSet" + name + " [" + this._dest.toBase32().substring(0, 8) + "]...");
                        }
                        this.getContext().statManager().addRateData("netDb.republishLeaseSetCount", 1L);
                        this._facade.sendStore(this._dest, ls, null, new OnRepublishFailure(ls), 90000L, null);
                        this._lastPublished = this.getContext().clock().now();
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Client [" + this._dest.toBase32().substring(0, 8) + "] is LOCAL, but no valid LeaseSet found -> Being rebuilt?");
                }
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Client [" + this._dest.toBase32().substring(0, 8) + "] is no longer LOCAL -> Not republishing LeaseSet");
            }
            this._facade.stopPublishing(this._dest);
        }
        catch (RuntimeException re) {
            if (this._log.shouldError()) {
                this._log.error("Uncaught error republishing the LeaseSet", re);
            }
            this._facade.stopPublishing(this._dest);
            throw re;
        }
    }

    void requeueRepublish() {
        String count;
        this.failCount.incrementAndGet();
        String string = count = this.failCount.get() > 1 ? " (Attempt: " + this.failCount.get() + ")" : "";
        if (this._log.shouldWarn()) {
            this._log.warn("Failed to publish LeaseSet for [" + this._dest.toBase32().substring(0, 8) + "] -> Retrying..." + count);
        }
        this.getContext().statManager().addRateData("netDb.republishLeaseSetFail", 1L);
        this.getContext().jobQueue().removeJob(this);
        this.requeue(5000L);
    }

    public long lastPublished() {
        return this._lastPublished;
    }

    public String getTunnelName(Destination d) {
        String name;
        TunnelPoolSettings in = this.getContext().tunnelManager().getInboundSettings(d.calculateHash());
        String string = name = in != null ? in.getDestinationNickname() : null;
        if (name == null) {
            TunnelPoolSettings out = this.getContext().tunnelManager().getOutboundSettings(d.calculateHash());
            String string2 = name = out != null ? out.getDestinationNickname() : null;
        }
        if (name == null) {
            return "";
        }
        return name;
    }

    private class OnRepublishFailure
    extends JobImpl {
        private final LeaseSet _ls;

        public OnRepublishFailure(LeaseSet ls) {
            super(RepublishLeaseSetJob.this.getContext());
            this._ls = ls;
        }

        @Override
        public String getName() {
            return "Timeout LeaseSet Publication";
        }

        @Override
        public void runJob() {
            LeaseSet ls = RepublishLeaseSetJob.this._facade.lookupLeaseSetLocally(this._ls.getHash());
            if (ls != null) {
                RepublishLeaseSetJob.this.tunnelName = RepublishLeaseSetJob.this.getTunnelName(this._ls.getDestination());
            }
            if (ls != null && !KademliaNetworkDatabaseFacade.isNewer(ls, this._ls)) {
                RepublishLeaseSetJob.this.requeueRepublish();
            } else if (RepublishLeaseSetJob.this._log.shouldInfo()) {
                String name = !RepublishLeaseSetJob.this.tunnelName.equals("") ? " for '" + RepublishLeaseSetJob.this.tunnelName + "'" : "";
                RepublishLeaseSetJob.this._log.info("Not requeueing failed publication of LeaseSet" + name + " [" + this._ls.getDestination().toBase32().substring(0, 8) + "] -> Newer LeaseSet exists");
            }
        }
    }
}

