/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseSearchReplyMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.MessageSelector;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.SearchState;
import net.i2p.util.Log;

class SearchMessageSelector
implements MessageSelector {
    private final Log _log;
    private final RouterContext _context;
    private static final AtomicInteger __searchSelectorId = new AtomicInteger();
    private final Hash _peer;
    private volatile boolean _found;
    private final int _id;
    private final long _exp;
    private final SearchState _state;

    public SearchMessageSelector(RouterContext context, RouterInfo peer, long expiration, SearchState state) {
        this._context = context;
        this._log = context.logManager().getLog(SearchMessageSelector.class);
        this._peer = peer.getIdentity().getHash();
        this._exp = expiration;
        this._state = state;
        this._id = __searchSelectorId.incrementAndGet();
        if (this._log.shouldDebug()) {
            this._log.debug("[ID " + this._id + "] Created: " + this.toString());
        }
    }

    public String toString() {
        return "Search selector \n* Looking for reply from [" + this._peer.toBase64().substring(0, 6) + "] for key [" + this._state.getTarget().toBase32().substring(0, 8) + "]";
    }

    @Override
    public boolean continueMatching() {
        boolean expired;
        boolean bl = expired = this._context.clock().now() > this._exp;
        if (expired) {
            return false;
        }
        if (this._state.getPending().size() > 1) {
            return true;
        }
        if (this._found) {
            if (this._log.shouldDebug()) {
                this._log.debug("[ID " + this._id + "] Don't continue matching! Looking for reply from [" + this._peer.toBase64().substring(0, 6) + "] for key [" + this._state.getTarget().toBase32().substring(0, 8) + "]");
            }
            return false;
        }
        return true;
    }

    @Override
    public long getExpiration() {
        return this._exp;
    }

    @Override
    public boolean isMatch(I2NPMessage message) {
        DatabaseSearchReplyMessage msg;
        int type = message.getType();
        if (type == 1) {
            DatabaseStoreMessage msg2 = (DatabaseStoreMessage)message;
            if (msg2.getKey().equals(this._state.getTarget())) {
                if (this._log.shouldDebug()) {
                    this._log.debug("[ID " + this._id + "] Received DbStore of the key we're looking for. May not have been from peer we're checking against though, but DBStore doesn't include that info");
                }
                this._found = true;
                return true;
            }
        } else if (type == 3 && this._peer.equals((msg = (DatabaseSearchReplyMessage)message).getFromHash()) && msg.getSearchKey().equals(this._state.getTarget())) {
            if (this._log.shouldDebug()) {
                this._log.debug("[ID " + this._id + "] Received DbSearchReply from queried peer for a key we're looking for");
            }
            this._found = true;
            return true;
        }
        return false;
    }
}

