/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import net.i2p.data.Hash;
import net.i2p.kademlia.XORComparator;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;

class SearchState {
    private final RouterContext _context;
    private final Set<Hash> _pendingPeers;
    private final Map<Hash, Long> _pendingPeerTimes;
    private final Set<Hash> _attemptedPeers;
    private final Set<Hash> _failedPeers;
    private final Set<Hash> _successfulPeers;
    private final Set<Hash> _repliedPeers;
    private final Hash _searchKey;
    private volatile long _completed;
    private volatile long _started;
    private volatile boolean _aborted;
    private final Log _log;

    public SearchState(RouterContext context, Hash key) {
        this._log = context.logManager().getLog(SearchState.class);
        this._context = context;
        this._searchKey = key;
        this._pendingPeers = new HashSet<Hash>(16);
        this._attemptedPeers = new HashSet<Hash>(16);
        this._failedPeers = new HashSet<Hash>(16);
        this._successfulPeers = new HashSet<Hash>(16);
        this._pendingPeerTimes = new HashMap<Hash, Long>(16);
        this._repliedPeers = new HashSet<Hash>(16);
        this._completed = -1L;
        this._started = this._context.clock().now();
    }

    public Hash getTarget() {
        return this._searchKey;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getPending() {
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._pendingPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getAttempted() {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._attemptedPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getClosestAttempted(int max) {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            return this.locked_getClosest(this._attemptedPeers, max, this._searchKey);
        }
    }

    private Set<Hash> locked_getClosest(Set<Hash> peers, int max, Hash target) {
        if (this._attemptedPeers.size() <= max) {
            return new HashSet<Hash>(this._attemptedPeers);
        }
        TreeSet<Hash> closest = new TreeSet<Hash>(new XORComparator<Hash>(target));
        closest.addAll(this._attemptedPeers);
        HashSet<Hash> rv = new HashSet<Hash>(max);
        Iterator<Hash> iter = closest.iterator();
        for (int i = 0; iter.hasNext() && i < max; ++i) {
            rv.add(iter.next());
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasAttempted(Hash peer) {
        Set<Hash> set = this._attemptedPeers;
        synchronized (set) {
            return this._attemptedPeers.contains(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getSuccessful() {
        Set<Hash> set = this._successfulPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._successfulPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getFailed() {
        Set<Hash> set = this._failedPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._failedPeers);
        }
    }

    public boolean completed() {
        return this._completed != -1L;
    }

    public void complete() {
        this._completed = this._context.clock().now();
    }

    public boolean isAborted() {
        return this._aborted;
    }

    public void abort() {
        this._aborted = true;
    }

    public long getWhenStarted() {
        return this._started;
    }

    public long getWhenCompleted() {
        return this._completed;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Collection<Hash> pending) {
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.addAll(pending);
            for (Hash peer : pending) {
                this._pendingPeerTimes.put(peer, this._context.clock().now());
            }
        }
        set = this._attemptedPeers;
        synchronized (set) {
            this._attemptedPeers.addAll(pending);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addPending(Hash peer) {
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.add(peer);
            this._pendingPeerTimes.put(peer, this._context.clock().now());
        }
        set = this._attemptedPeers;
        synchronized (set) {
            this._attemptedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removePending(Hash peer) {
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.remove(peer);
            this._pendingPeerTimes.remove(peer);
        }
        set = this._attemptedPeers;
        synchronized (set) {
            this._attemptedPeers.remove(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long dataFound(Hash peer) {
        long rv = -1L;
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                rv = this._context.clock().now() - when;
            }
        }
        set = this._successfulPeers;
        synchronized (set) {
            this._successfulPeers.add(peer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long replyFound(Hash peer) {
        Set<Hash> set = this._repliedPeers;
        synchronized (set) {
            this._repliedPeers.add(peer);
        }
        set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.remove(peer);
            Long when = this._pendingPeerTimes.remove(peer);
            if (when != null) {
                return this._context.clock().now() - when;
            }
            return -1L;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Hash> getRepliedPeers() {
        Set<Hash> set = this._repliedPeers;
        synchronized (set) {
            return new HashSet<Hash>(this._repliedPeers);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replyTimeout(Hash peer) {
        Set<Hash> set = this._pendingPeers;
        synchronized (set) {
            this._pendingPeers.remove(peer);
            this._pendingPeerTimes.remove(peer);
        }
        set = this._failedPeers;
        synchronized (set) {
            this._failedPeers.add(peer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        Boolean debug = this._log.shouldDebug();
        StringBuilder buf = new StringBuilder(256);
        buf.append(" Search for [").append(this._searchKey.toBase64().substring(0, 6)).append("]");
        if (this._successfulPeers.size() <= 0) {
            buf.append(" in progress...");
        } else {
            buf.append(" completed");
        }
        if (this._aborted) {
            buf.append(" aborted");
        }
        if (debug.booleanValue()) {
            Set<Hash> set;
            if (this._attemptedPeers.size() > 0) {
                buf.append("\n* Queried: ");
                set = this._attemptedPeers;
                synchronized (set) {
                    buf.append(this._attemptedPeers.size()).append(' ');
                    for (Hash peer : this._attemptedPeers) {
                        buf.append("[").append(peer.toBase64().substring(0, 6)).append("] ");
                    }
                }
            }
            if (this._pendingPeers.size() > 0) {
                buf.append("\n* Pending: ");
                set = this._pendingPeers;
                synchronized (set) {
                    buf.append(this._pendingPeers.size()).append(' ');
                    for (Hash peer : this._pendingPeers) {
                        buf.append("[").append(peer.toBase64().substring(0, 6)).append("] ");
                    }
                }
            }
            if (this._failedPeers.size() > 0) {
                buf.append("\n* Failed: ");
                set = this._failedPeers;
                synchronized (set) {
                    buf.append(this._failedPeers.size()).append(' ');
                    for (Hash peer : this._failedPeers) {
                        buf.append("[").append(peer.toBase64().substring(0, 6)).append("] ");
                    }
                }
            }
            if (this._successfulPeers.size() > 0) {
                buf.append("\n* Successful: ");
                set = this._successfulPeers;
                synchronized (set) {
                    buf.append(this._successfulPeers.size()).append(' ');
                    for (Hash peer : this._successfulPeers) {
                        buf.append("[").append(peer.toBase64().substring(0, 6)).append("] ");
                    }
                }
            }
        }
        return buf.toString();
    }
}

