/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import net.i2p.data.Hash;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.networkdb.kademlia.FloodOnlySearchJob;

class SingleSearchJob
extends FloodOnlySearchJob {
    private final Hash _to;
    private OutNetMessage _onm;
    private static final int TIMEOUT = 8000;

    public SingleSearchJob(RouterContext ctx, Hash key, Hash to) {
        super(ctx, null, key, null, null, 8000, false);
        this._to = to;
    }

    @Override
    public String getName() {
        return "Start DbStoreReplyMsg Search for NetDb key";
    }

    @Override
    public boolean shouldProcessDSRM() {
        return false;
    }

    @Override
    public void runJob() {
        this._onm = this.getContext().messageRegistry().registerPending(this._replySelector, this._onReply, this._onTimeout);
        DatabaseLookupMessage dlm = new DatabaseLookupMessage(this.getContext(), true);
        TunnelInfo replyTunnel = this.getContext().tunnelManager().selectInboundExploratoryTunnel(this._to);
        TunnelInfo outTunnel = this.getContext().tunnelManager().selectOutboundExploratoryTunnel(this._to);
        if (replyTunnel == null || outTunnel == null) {
            this.failed();
            return;
        }
        dlm.setFrom(replyTunnel.getPeer(0));
        dlm.setMessageExpiration(this.getContext().clock().now() + 5000L);
        dlm.setReplyTunnel(replyTunnel.getReceiveTunnelId(0));
        dlm.setSearchKey(this._key);
        dlm.setSearchType(DatabaseLookupMessage.Type.RI);
        if (this._log.shouldInfo()) {
            this._log.info("SingleSearch for [" + this._key.toBase64().substring(0, 6) + "] sent to [" + this._to.toBase64().substring(0, 6) + "]");
        }
        this.getContext().tunnelDispatcher().dispatchOutbound(dlm, outTunnel.getSendTunnelId(0), this._to);
        this._lookupsRemaining.set(1);
    }

    @Override
    void failed() {
        this.getContext().messageRegistry().unregisterPending(this._onm);
        this.getContext().profileManager().dbLookupFailed(this._to);
    }

    @Override
    void success() {
        this.getContext().profileManager().dbLookupSuccessful(this._to, System.currentTimeMillis() - this._created);
    }
}

