/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.networkdb.kademlia;

import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DatabaseEntry;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.LeaseSet2;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.DataStore;
import net.i2p.router.transport.CommSystemFacadeImpl;
import net.i2p.util.Addresses;
import net.i2p.util.Log;

class TransientDataStore
implements DataStore {
    protected final Log _log;
    private final ConcurrentHashMap<Hash, DatabaseEntry> _data;
    protected final RouterContext _context;
    private static final String PROP_ENABLE_REVERSE_LOOKUPS = "routerconsole.enableReverseLookups";

    public TransientDataStore(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._data = new ConcurrentHashMap(1024);
    }

    @Override
    public boolean isInitialized() {
        return true;
    }

    public boolean enableReverseLookups() {
        return this._context.getBooleanProperty(PROP_ENABLE_REVERSE_LOOKUPS);
    }

    @Override
    public void stop() {
        this._data.clear();
    }

    @Override
    public void rescan() {
    }

    @Override
    public int size() {
        return this._data.size();
    }

    @Override
    public Set<Hash> getKeys() {
        return Collections.unmodifiableSet(this._data.keySet());
    }

    @Override
    public Collection<DatabaseEntry> getEntries() {
        return Collections.unmodifiableCollection(this._data.values());
    }

    @Override
    public Set<Map.Entry<Hash, DatabaseEntry>> getMapEntries() {
        return Collections.unmodifiableSet(this._data.entrySet());
    }

    @Override
    public DatabaseEntry get(Hash key, boolean persist) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseEntry get(Hash key) {
        if (key != null) {
            return this._data.get(key);
        }
        return null;
    }

    @Override
    public boolean isKnown(Hash key) {
        return this._data.containsKey(key);
    }

    @Override
    public int countLeaseSets() {
        int count = 0;
        for (DatabaseEntry d : this._data.values()) {
            if (!d.isLeaseSet()) continue;
            ++count;
        }
        return count;
    }

    @Override
    public boolean put(Hash key, DatabaseEntry data, boolean persist) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean put(Hash key, DatabaseEntry data) {
        String receivedAs;
        boolean isRI;
        if (data == null) {
            return false;
        }
        int type = data.getType();
        boolean bl = isRI = type == 0;
        if (this._log.shouldDebug()) {
            this._log.debug((isRI ? "Sending RouterInfo" : "Saving LeaseSet") + " [" + (isRI ? key.toBase64().substring(0, 6) : key.toBase32().substring(0, 8)) + "] to persistent datastore" + (isRI ? " for processing" : "") + "...");
        }
        DatabaseEntry old = this._data.putIfAbsent(key, data);
        boolean rv = false;
        if (isRI) {
            RouterInfo ri = (RouterInfo)data;
            String v = ri.getVersion();
            String caps = ri.getCapabilities();
            if (old != null) {
                RouterInfo ori = (RouterInfo)old;
                if (ri.getPublished() <= ori.getPublished()) return rv;
                if (this._log.shouldInfo()) {
                    this._log.info("Received updated RouterInfo [" + key.toBase64().substring(0, 6) + "] -> " + v + " / " + caps + "\n* Old: " + new Date(ori.getPublished()) + "\n* New: " + new Date(ri.getPublished()));
                }
                this._data.put(key, data);
                return true;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Received new RouterInfo [" + key.toBase64().substring(0, 6) + "] -> " + v + " / " + caps + "\n* Published: " + new Date(ri.getPublished()));
            }
            rv = true;
            long uptime = this._context.router().getUptime();
            if (!this.enableReverseLookups()) return rv;
            if (uptime <= 30000L) return rv;
            String ip = Addresses.toString(CommSystemFacadeImpl.getValidIP(ri));
            ip = ri != null ? Addresses.toString(CommSystemFacadeImpl.getValidIP(ri)) : null;
            String string = ip != null ? this._context.commSystem().getCanonicalHostName(ip) : null;
            return rv;
        }
        if (!DatabaseEntry.isLeaseSet(type)) return rv;
        LeaseSet ls = (LeaseSet)data;
        String string = ls.getReceivedAsPublished() ? " -> Published via peer" : (receivedAs = ls.getReceivedAsReply() ? " -> In response to query" : "");
        if (old != null) {
            long newDate;
            long oldDate;
            LeaseSet ols = (LeaseSet)old;
            if (type != 1 && ols.getType() != 1) {
                if (!(ls instanceof LeaseSet2)) throw new IllegalArgumentException("Expected LeaseSet2 but got a different type");
                if (!(ols instanceof LeaseSet2)) throw new IllegalArgumentException("Expected LeaseSet2 but got a different type");
                LeaseSet2 ls2 = (LeaseSet2)ls;
                LeaseSet2 ols2 = (LeaseSet2)ols;
                oldDate = ols2.getPublished();
                newDate = ls2.getPublished();
            } else {
                oldDate = ols.getEarliestLeaseDate();
                newDate = ls.getEarliestLeaseDate();
            }
            if (newDate < oldDate) {
                if (!this._log.shouldDebug()) return rv;
                this._log.debug("Almost clobbered a LeaseSet! [" + key.toBase32().substring(0, 8) + "]\n* Old: " + new Date(ols.getEarliestLeaseDate()) + "\n* New: " + new Date(ls.getEarliestLeaseDate()));
                return rv;
            }
            if (newDate == oldDate) {
                if (!this._log.shouldDebug()) return rv;
                this._log.debug("Received duplicate LeaseSet [" + key.toBase32().substring(0, 8) + "] -> Not updating");
                return rv;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Received updated LeaseSet [" + key.toBase32().substring(0, 8) + "]" + receivedAs + "\n* Old: " + new Date(ols.getEarliestLeaseDate()) + "\n* New: " + new Date(newDate));
            }
            this._data.put(key, data);
            return true;
        }
        if (!this._log.shouldInfo()) return true;
        this._log.info("Received new LeaseSet [" + key.toBase32().substring(0, 8) + "]" + receivedAs + "\n* Expires: " + new Date(ls.getEarliestLeaseDate()));
        return true;
    }

    @Override
    public boolean forcePut(Hash key, DatabaseEntry data) {
        this._data.put(key, data);
        return true;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Transient DataStore: ").append(this._data.size()).append("\n* Keys: ");
        for (Map.Entry<Hash, DatabaseEntry> e : this._data.entrySet()) {
            Hash key = e.getKey();
            DatabaseEntry dp = e.getValue();
            buf.append("\n* Key: ").append(key.toString()).append("\n* Content: ").append(dp.toString());
        }
        buf.append("\n");
        return buf.toString();
    }

    @Override
    public DatabaseEntry remove(Hash key, boolean persist) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DatabaseEntry remove(Hash key) {
        return this._data.remove(key);
    }
}

