/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Properties;
import net.i2p.router.RouterContext;
import net.i2p.router.peermanager.ProfilePersistenceHelper;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;

public class DBHistory {
    private final Log _log;
    private final RouterContext _context;
    private long _successfulLookups;
    private long _failedLookups;
    private final RateStat _failedLookupRate;
    private final RateStat _invalidReplyRate;
    private long _lastLookupSuccessful;
    private long _lastLookupFailed;
    private long _lastStoreSuccessful;
    private long _lastStoreFailed;
    private long _unpromptedDbStoreNew;
    private long _unpromptedDbStoreOld;
    private final String _statGroup;
    private static final String NL = System.getProperty("line.separator");
    private static final String HR = "# ----------------------------------------------------------------------------------------";

    public DBHistory(RouterContext context, String statGroup) {
        this._context = context;
        this._log = context.logManager().getLog(DBHistory.class);
        this._statGroup = statGroup;
        this._failedLookupRate = new RateStat("dbHistory.failedLookupRate", "How often peer responds to a lookup", statGroup, new long[]{600000L, 3600000L, 86400000L});
        this._invalidReplyRate = new RateStat("dbHistory.invalidReplyRate", "How often peer sends us a bad RouterInfo?", statGroup, new long[]{600000L, 3600000L, 86400000L});
    }

    public long getSuccessfulLookups() {
        return this._successfulLookups;
    }

    public long getFailedLookups() {
        return this._failedLookups;
    }

    public long getLastLookupSuccessful() {
        return this._lastLookupSuccessful;
    }

    public long getLastLookupFailed() {
        return this._lastLookupFailed;
    }

    public long getLastStoreSuccessful() {
        return this._lastStoreSuccessful;
    }

    public long getLastStoreFailed() {
        return this._lastStoreFailed;
    }

    public long getUnpromptedDbStoreNew() {
        return this._unpromptedDbStoreNew;
    }

    public long getUnpromptedDbStoreOld() {
        return this._unpromptedDbStoreOld;
    }

    public RateStat getFailedLookupRate() {
        return this._failedLookupRate;
    }

    public RateStat getInvalidReplyRate() {
        return this._invalidReplyRate;
    }

    public void lookupSuccessful() {
        ++this._successfulLookups;
        this._failedLookupRate.addData(0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L);
        this._lastLookupSuccessful = this._context.clock().now();
    }

    public void lookupFailed() {
        ++this._failedLookups;
        this._failedLookupRate.addData(1L);
        this._context.statManager().addRateData("peer.failedLookupRate", 1L);
        this._lastLookupFailed = this._context.clock().now();
    }

    public void storeSuccessful() {
        this._failedLookupRate.addData(0L);
        this._context.statManager().addRateData("peer.failedLookupRate", 0L);
        this._lastStoreSuccessful = this._context.clock().now();
    }

    public void storeFailed() {
        this._failedLookupRate.addData(1L);
        this._lastStoreFailed = this._context.clock().now();
    }

    public void lookupReply(int newPeers, int oldPeers, int invalid, int duplicate) {
        if (invalid > 0) {
            this._invalidReplyRate.addData(invalid);
        }
    }

    public void unpromptedStoreReceived(boolean wasNew) {
        if (wasNew) {
            ++this._unpromptedDbStoreNew;
        } else {
            ++this._unpromptedDbStoreOld;
        }
    }

    public void setSuccessfulLookups(long num) {
        this._successfulLookups = num;
    }

    public void setFailedLookups(long num) {
        this._failedLookups = num;
    }

    public void setUnpromptedDbStoreNew(long num) {
        this._unpromptedDbStoreNew = num;
    }

    public void setUnpromptedDbStoreOld(long num) {
        this._unpromptedDbStoreOld = num;
    }

    public void coalesceStats() {
        if (this._log.shouldDebug()) {
            this._log.debug("Coalescing Profile Manager stats");
        }
        this._failedLookupRate.coalesceStats();
        this._invalidReplyRate.coalesceStats();
    }

    public void store(OutputStream out) throws IOException {
        this.store(out, true);
    }

    public void store(OutputStream out, boolean addComments) throws IOException {
        StringBuilder buf = new StringBuilder(512);
        if (addComments) {
            buf.append(NL);
            buf.append(HR).append(NL);
            buf.append("# NetDb History").append(NL);
            buf.append(HR).append(NL);
        }
        DBHistory.add(buf, addComments, "lastLookupFailed", this._lastLookupFailed, "Time of last failed lookup from peer (ms since the epoch)");
        DBHistory.add(buf, addComments, "lastLookupSuccessful", this._lastLookupSuccessful, "Time of last successful lookup from peer (ms since the epoch)");
        DBHistory.add(buf, addComments, "lastStoreFailed", this._lastStoreFailed, "Time of last failed store to peer (ms since the epoch)");
        DBHistory.add(buf, addComments, "lastStoreSuccessful", this._lastStoreSuccessful, "Time of last successful store to peer (ms since the epoch)");
        DBHistory.add(buf, addComments, "unpromptedDbStoreNew", this._unpromptedDbStoreNew, "Number of times peer sent us something unrequested and not seen before");
        DBHistory.add(buf, addComments, "unpromptedDbStoreOld", this._unpromptedDbStoreOld, "Number of times peer sent us something unrequested but seen before");
        DBHistory.add(buf, addComments, "failedLookups", this._failedLookups, "Number of times peer never responded to a lookup request");
        DBHistory.add(buf, addComments, "successfulLookups", this._successfulLookups, "Number of times peer sent a valid response to a lookup request");
        out.write(buf.toString().getBytes("UTF-8"));
        this._failedLookupRate.store(out, "dbHistory.failedLookupRate", addComments);
        this._invalidReplyRate.store(out, "dbHistory.invalidReplyRate", addComments);
    }

    private static void add(StringBuilder buf, boolean addComments, String name, long val, String description) {
        if (addComments) {
            buf.append("# ").append(description).append(": ").append(val).append(NL);
        }
    }

    public void load(Properties props) {
        this._failedLookups = DBHistory.getLong(props, "dbHistory.failedLookups");
        this._unpromptedDbStoreNew = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreNew");
        this._unpromptedDbStoreOld = DBHistory.getLong(props, "dbHistory.unpromptedDbStoreOld");
        this._lastLookupSuccessful = DBHistory.getLong(props, "dbHistory.lastLookupSuccessful");
        this._lastLookupFailed = DBHistory.getLong(props, "dbHistory.lastLookupFailed");
        this._lastStoreSuccessful = DBHistory.getLong(props, "dbHistory.lastStoreSuccessful");
        this._lastStoreFailed = DBHistory.getLong(props, "dbHistory.lastStoreFailed");
        this._successfulLookups = DBHistory.getLong(props, "dbHistory.successfulLookups");
        try {
            this._failedLookupRate.load(props, "dbHistory.failedLookupRate", true);
            this._log.debug("Loading dbHistory.failedLookupRate");
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("Db History Failed Lookup rate is corrupt (" + iae.getMessage() + ") -> resetting...");
        }
        try {
            this._invalidReplyRate.load(props, "dbHistory.invalidReplyRate", true);
        }
        catch (IllegalArgumentException iae) {
            this._log.warn("Db History Invalid Reply rate is corrupt -> " + iae.getMessage());
        }
    }

    private static final long getLong(Properties props, String key) {
        return ProfilePersistenceHelper.getLong(props, key);
    }
}

