/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.peermanager;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.DeliveryStatusMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.MessageSelector;
import net.i2p.router.ReplyJob;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.peermanager.PeerManager;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.peermanager.PeerSelectionCriteria;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class PeerTestJob
extends JobImpl {
    private final Log _log;
    private PeerManager _manager;
    private boolean _keepTesting;
    private final int DEFAULT_PEER_TEST_DELAY = SystemVersion.isSlow() ? 8000 : 5000;
    public static final String PROP_PEER_TEST_DELAY = "router.peerTestDelay";
    private static final int DEFAULT_PEER_TEST_CONCURRENCY = SystemVersion.isSlow() ? 1 : (SystemVersion.getCores() <= 2 ? 2 : (SystemVersion.getCores() >= 8 ? 4 : 3));
    public static final String PROP_PEER_TEST_CONCURRENCY = "router.peerTestConcurrency";
    private static final int DEFAULT_PEER_TEST_TIMEOUT = 750;
    public static final String PROP_PEER_TEST_TIMEOUT = "router.peerTestTimeout";

    public PeerTestJob(RouterContext context) {
        super(context);
        this._log = context.logManager().getLog(PeerTestJob.class);
        this._keepTesting = false;
        this.getContext().statManager().createRequiredRateStat("peer.testOK", "Time a successful test takes (ms)", "Peers", new long[]{60000L, 600000L, 3600000L});
        this.getContext().statManager().createRequiredRateStat("peer.testTooSlow", "Excess time taken by too slow test (ms)", "Peers", new long[]{60000L, 600000L, 3600000L});
        this.getContext().statManager().createRateStat("peer.testTimeout", "Frequency of test timeouts (no reply)", "Peers", new long[]{60000L, 600000L});
    }

    public int getAvgPeerTestTime() {
        if (this.getContext() == null) {
            return 0;
        }
        RateStat rs = this.getContext().statManager().getRate("peer.testOK");
        Rate r = rs.getRate(60000L);
        int avgTestTime = (int)r.getLifetimeAverageValue();
        return avgTestTime;
    }

    public int getTotalAvgPeerTestTime() {
        if (this.getContext() == null) {
            return 0;
        }
        RateStat ok = this.getContext().statManager().getRate("peer.testOK");
        Rate rok = ok.getRate(3600000L);
        RateStat tooslow = this.getContext().statManager().getRate("peer.testTooSlow");
        Rate rtooslow = ok.getRate(3600000L);
        int totalAvgTestTime = (int)rok.getLifetimeAverageValue() + (int)rtooslow.getLifetimeAverageValue();
        return totalAvgTestTime;
    }

    private long getPeerTestDelay() {
        long uptime = this.getContext().router().getUptime();
        int testDelay = this.getContext().getProperty(PROP_PEER_TEST_DELAY, this.DEFAULT_PEER_TEST_DELAY);
        if (uptime > 10800000L || SystemVersion.getCPULoadAvg() > 80) {
            return testDelay + 1000;
        }
        if (uptime >= 180000L) {
            return testDelay;
        }
        return (long)testDelay + (180000L - uptime);
    }

    private int getTestTimeout() {
        int testTimeout = this.getContext().getProperty(PROP_PEER_TEST_TIMEOUT, 750);
        if (testTimeout < this.getAvgPeerTestTime()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Peer test timeout set below successful test average, setting to: " + this.getAvgPeerTestTime() + "ms");
            }
            return this.getAvgPeerTestTime();
        }
        return testTimeout;
    }

    private int getTestConcurrency() {
        int cores = SystemVersion.getCores();
        long memory = SystemVersion.getMaxMemory();
        int testConcurrent = this.getContext().getProperty(PROP_PEER_TEST_CONCURRENCY, DEFAULT_PEER_TEST_CONCURRENCY);
        if (SystemVersion.getCPULoadAvg() > 80) {
            testConcurrent = 1;
        }
        return testConcurrent;
    }

    public synchronized void startTesting(PeerManager manager) {
        this._manager = manager;
        this._keepTesting = true;
        this.getTiming().setStartAfter(this.getContext().clock().now() + this.getPeerTestDelay());
        this.getContext().jobQueue().addJob(this);
        long uptime = this.getContext().router().getUptime();
        if (uptime < 18000L) {
            if (this._log.shouldInfo()) {
                this._log.info("Peer testing will commence in 3 minutes...");
            }
        } else if (this._log.shouldInfo()) {
            this._log.info("Initialising peer tests -> Timeout: " + this.getTestTimeout() + "ms per peer");
        }
    }

    public synchronized void stopTesting() {
        this._keepTesting = false;
        if (this._log.shouldInfo()) {
            this._log.info("Ending peer tests...");
        }
    }

    @Override
    public String getName() {
        return "Test Peers";
    }

    @Override
    public void runJob() {
        long lag = this.getContext().jobQueue().getMaxLag();
        if (!this._keepTesting) {
            return;
        }
        Set<RouterInfo> peers = this.selectPeersToTest();
        for (RouterInfo peer : peers) {
            this.testPeer(peer);
        }
        if (lag > 300L || SystemVersion.getCPULoadAvg() > 80) {
            this.requeue(this.getPeerTestDelay() * 2L);
            if (this._log.shouldWarn()) {
                if (lag > 300L) {
                    this._log.info("High Job lag (" + lag + "ms) -> Increasing delay before next run to " + this.getPeerTestDelay() * 2L + "ms");
                } else {
                    this._log.info("High CPU load -> Increasing delay before next run to " + this.getPeerTestDelay() * 2L + "ms");
                }
            }
        } else {
            this.requeue(this.getPeerTestDelay());
        }
        if (this._log.shouldInfo()) {
            this._log.info("Next Peer Test run in " + this.getPeerTestDelay() + "ms");
        }
    }

    private Set<RouterInfo> selectPeersToTest() {
        PeerSelectionCriteria criteria = new PeerSelectionCriteria();
        criteria.setMinimumRequired(this.getTestConcurrency());
        criteria.setMaximumRequired(this.getTestConcurrency());
        criteria.setPurpose(4);
        List<Hash> peerHashes = this._manager.selectPeers(criteria);
        HashSet<RouterInfo> peers = new HashSet<RouterInfo>(peerHashes.size());
        for (Hash peer : peerHashes) {
            RouterInfo peerInfo = this.getContext().netDb().lookupRouterInfoLocally(peer);
            PeerProfile prof = this.getContext().profileOrganizer().getProfile(peer);
            String cap = null;
            String bw = "";
            String version = "";
            boolean reachable = false;
            if (peerInfo != null) {
                bw = peerInfo.getBandwidthTier();
                cap = peerInfo.getCapabilities();
                version = peerInfo.getVersion();
                boolean bl = reachable = cap.indexOf(82) >= 0;
            }
            if (peerInfo != null && prof != null && cap != null && reachable && VersionComparator.comp(version, "0.9.57") >= 0 && (bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                peers.add(peerInfo);
                continue;
            }
            if (peerInfo != null && prof != null && cap != null && (!reachable || bw.equals("K") || bw.equals("L") || bw.equals("M") || bw.equals("N"))) {
                prof.setCapacityBonus(-30);
                if (!this._log.shouldInfo()) continue;
                this._log.info("Setting capacity bonus to -30 and skipping test for [" + peer.toBase64().substring(0, 6) + "] -> K, L, M, N or unreachable");
                continue;
            }
            if (peerInfo != null || !this._log.shouldInfo()) continue;
            this._log.info("Test of [" + peer.toBase64().substring(0, 6) + "] failed: No local RouterInfo");
        }
        if (this.getTestConcurrency() != 1 && this._log.shouldInfo()) {
            this._log.info("Running " + this.getTestConcurrency() + " concurrent peer tests");
        }
        return peers;
    }

    private void testPeer(RouterInfo peer) {
        TunnelInfo inTunnel = this.getInboundTunnelId();
        if (inTunnel == null) {
            this._log.warn("No tunnels to get peer test replies through!");
            return;
        }
        TunnelId inTunnelId = inTunnel.getReceiveTunnelId(0);
        RouterInfo inGateway = this.getContext().netDb().lookupRouterInfoLocally(inTunnel.getPeer(0));
        if (inGateway == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("We can't find the gateway to our inbound tunnel?! Impossible?");
            }
            return;
        }
        int timeoutMs = this.getTestTimeout();
        long expiration = this.getContext().clock().now() + (long)timeoutMs;
        long nonce = 1L + this.getContext().random().nextLong(0xFFFFFFFEL);
        DatabaseStoreMessage msg = this.buildMessage(peer, inTunnelId, inGateway.getIdentity().getHash(), nonce, expiration);
        TunnelInfo outTunnel = this.getOutboundTunnelId();
        if (outTunnel == null) {
            this._log.warn("No tunnels to send search out through! We have a problem, Houston!");
            return;
        }
        TunnelId outTunnelId = outTunnel.getSendTunnelId(0);
        if (this._log.shouldDebug()) {
            this._log.debug("Initiating peer test of [" + peer.getIdentity().getHash().toBase64().substring(0, 6) + "] \n* Outbound: " + outTunnel + "\n* Inbound: " + inTunnel);
        } else if (this._log.shouldInfo()) {
            this._log.info("Initiating peer test of [" + peer.getIdentity().getHash().toBase64().substring(0, 6) + "]");
        }
        ReplySelector sel = new ReplySelector(peer.getIdentity().getHash(), nonce, expiration);
        PeerReplyFoundJob reply = new PeerReplyFoundJob(this.getContext(), peer, inTunnel, outTunnel);
        PeerReplyTimeoutJob timeoutJob = new PeerReplyTimeoutJob(this.getContext(), peer, inTunnel, outTunnel, sel);
        this.getContext().messageRegistry().registerPending(sel, reply, timeoutJob);
        this.getContext().tunnelDispatcher().dispatchOutbound(msg, outTunnelId, null, peer.getIdentity().getHash());
    }

    private TunnelInfo getOutboundTunnelId() {
        return this.getContext().tunnelManager().selectOutboundTunnel();
    }

    private TunnelInfo getInboundTunnelId() {
        return this.getContext().tunnelManager().selectInboundTunnel();
    }

    private DatabaseStoreMessage buildMessage(RouterInfo peer, TunnelId replyTunnel, Hash replyGateway, long nonce, long expiration) {
        DatabaseStoreMessage msg = new DatabaseStoreMessage(this.getContext());
        msg.setEntry(peer);
        msg.setReplyGateway(replyGateway);
        msg.setReplyTunnel(replyTunnel);
        msg.setReplyToken(nonce);
        msg.setMessageExpiration(expiration);
        return msg;
    }

    private class PeerReplyTimeoutJob
    extends JobImpl {
        private final RouterInfo _peer;
        private final TunnelInfo _replyTunnel;
        private final TunnelInfo _sendTunnel;
        private final ReplySelector _selector;

        public PeerReplyTimeoutJob(RouterContext context, RouterInfo peer, TunnelInfo replyTunnel, TunnelInfo sendTunnel, ReplySelector sel) {
            super(context);
            this._peer = peer;
            this._replyTunnel = replyTunnel;
            this._sendTunnel = sendTunnel;
            this._selector = sel;
        }

        @Override
        public String getName() {
            return "Timeout Peer Test";
        }

        private boolean getShouldFailPeer() {
            return true;
        }

        @Override
        public void runJob() {
            if (this._selector.matchFound()) {
                return;
            }
            if (this.getShouldFailPeer()) {
                this.getContext().profileManager().dbLookupFailed(this._peer.getIdentity().getHash());
            }
            if (PeerTestJob.this._log.shouldDebug()) {
                PeerTestJob.this._log.debug("Test failed (timeout reached) for [" + this._peer.toBase64().substring(0, 6) + "]\n* " + this._sendTunnel + "\n* " + this._replyTunnel);
            } else if (PeerTestJob.this._log.shouldInfo()) {
                PeerTestJob.this._log.info("Test failed (timeout reached) for [" + this._peer.toBase64().substring(0, 6) + "]");
            }
            this.getContext().statManager().addRateData("peer.testTimeout", 1L);
            Hash h = this._peer.getIdentity().getHash();
            if (h != null) {
                PeerProfile prof = this.getContext().profileOrganizer().getProfile(h);
                RouterInfo peerInfo = this.getContext().netDb().lookupRouterInfoLocally(h);
                if (peerInfo != null) {
                    String cap = peerInfo.getCapabilities();
                    boolean reachable = cap.indexOf(82) >= 0;
                    String bw = peerInfo.getBandwidthTier();
                    if (prof != null && cap != null && (!reachable || bw.equals("L") || bw.equals("M") || bw.equals("N"))) {
                        try {
                            prof.setCapacityBonus(-30);
                            prof.setSpeedBonus(0);
                            if (PeerTestJob.this._log.shouldInfo()) {
                                PeerTestJob.this._log.info("Setting capacity bonus to -30 and speed bonus to 0 for [" + this._peer.toBase64().substring(0, 6) + "] -> Slow or unreachable");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {
                            // empty catch block
                        }
                        return;
                    }
                }
            }
        }
    }

    private class PeerReplyFoundJob
    extends JobImpl
    implements ReplyJob {
        private final RouterInfo _peer;
        private final long _testBegin;
        private final TunnelInfo _replyTunnel;
        private final TunnelInfo _sendTunnel;

        public PeerReplyFoundJob(RouterContext context, RouterInfo peer, TunnelInfo replyTunnel, TunnelInfo sendTunnel) {
            super(context);
            this._peer = peer;
            this._replyTunnel = replyTunnel;
            this._sendTunnel = sendTunnel;
            this._testBegin = context.clock().now();
        }

        @Override
        public String getName() {
            return "Verify Peer Test";
        }

        @Override
        public void runJob() {
            RouterInfo peerInfo;
            long responseTime = this.getContext().clock().now() - this._testBegin;
            if (PeerTestJob.this._log.shouldDebug()) {
                PeerTestJob.this._log.debug("[" + this._peer.getIdentity().getHash().toBase64().substring(0, 6) + "] Test succeeded in " + responseTime + "ms\n* " + this._sendTunnel + "\n* " + this._replyTunnel);
            } else if (PeerTestJob.this._log.shouldInfo()) {
                PeerTestJob.this._log.info("[" + this._peer.getIdentity().getHash().toBase64().substring(0, 6) + "] Test succeeded in " + responseTime + "ms");
            }
            this.getContext().profileManager().dbLookupSuccessful(this._peer.getIdentity().getHash(), responseTime);
            this._sendTunnel.testSuccessful((int)responseTime);
            this._replyTunnel.testSuccessful((int)responseTime);
            Hash h = this._peer.getIdentity().getHash();
            if (h != null && (peerInfo = this.getContext().netDb().lookupRouterInfoLocally(h)) != null) {
                String cap = peerInfo.getCapabilities();
                boolean reachable = cap.indexOf(82) >= 0;
                String bw = peerInfo.getBandwidthTier();
                PeerProfile prof = this.getContext().profileOrganizer().getProfile(h);
                if (prof != null && cap != null && reachable && (bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                    prof.setSpeedBonus(9999999);
                    if (PeerTestJob.this._log.shouldInfo()) {
                        PeerTestJob.this._log.info("[" + this._peer.getIdentity().getHash().toBase64().substring(0, 6) + "] Setting speed bonus to 9999999 for fast tier router");
                    }
                }
                if (!(prof == null || prof.getCapacityBonus() != -30 || cap == null || !reachable || bw.equals("L") && bw.equals("M"))) {
                    try {
                        prof.setCapacityBonus(0);
                        if (PeerTestJob.this._log.shouldInfo()) {
                            PeerTestJob.this._log.info("Resetting capacity bonus to 0 for [" + this._peer.toBase64().substring(0, 6) + "]");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return;
                }
                if (prof != null && cap != null && (!reachable || bw.equals("L") || bw.equals("M"))) {
                    try {
                        prof.setCapacityBonus(-30);
                        if (PeerTestJob.this._log.shouldInfo()) {
                            PeerTestJob.this._log.info("Setting capacity bonus to -30 for [" + this._peer.toBase64().substring(0, 6) + "] -> L or M tier or unreachable");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return;
                }
                if (prof != null && cap == null) {
                    try {
                        prof.setCapacityBonus(-30);
                        if (PeerTestJob.this._log.shouldInfo()) {
                            PeerTestJob.this._log.info("Setting capacity bonus to -30 for [" + this._peer.toBase64().substring(0, 6) + "] -> No capabilities published in RouterInfo");
                        }
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                    return;
                }
            }
        }

        @Override
        public void setMessage(I2NPMessage message) {
        }
    }

    private class ReplySelector
    implements MessageSelector {
        private final long _expiration;
        private final long _nonce;
        private final Hash _peer;
        private boolean _matchFound;

        public ReplySelector(Hash peer, long nonce, long expiration) {
            this._nonce = nonce;
            this._expiration = expiration;
            this._peer = peer;
            this._matchFound = false;
        }

        @Override
        public boolean continueMatching() {
            return false;
        }

        @Override
        public long getExpiration() {
            return this._expiration;
        }

        @Override
        public boolean isMatch(I2NPMessage message) {
            DeliveryStatusMessage msg;
            if (message.getType() == 10 && this._nonce == (msg = (DeliveryStatusMessage)message).getMessageId()) {
                long timeLeft = this._expiration - PeerTestJob.this.getContext().clock().now();
                PeerProfile prof = PeerTestJob.this.getContext().profileOrganizer().getProfile(this._peer);
                RouterInfo peerInfo = PeerTestJob.this.getContext().netDb().lookupRouterInfoLocally(this._peer);
                if (peerInfo != null && prof != null) {
                    int speedBonus = prof.getSpeedBonus();
                    String cap = peerInfo.getCapabilities();
                    boolean reachable = cap.indexOf(82) >= 0;
                    String bw = peerInfo.getBandwidthTier();
                    int timeout = PeerTestJob.this.getTestTimeout();
                    float testAvg = prof.getPeerTestTimeAverage();
                    if (prof != null && cap != null && (bw.equals("L") || bw.equals("M") || bw.equals("N") || !reachable)) {
                        try {
                            prof.setCapacityBonus(-30);
                            if (PeerTestJob.this._log.shouldInfo()) {
                                PeerTestJob.this._log.info("Setting capacity bonus to -30 for [" + this._peer.toBase64().substring(0, 6) + "] -> L, M, N or unreachable");
                            }
                        }
                        catch (NumberFormatException numberFormatException) {}
                    } else if (timeLeft < 0L) {
                        if (PeerTestJob.this._log.shouldInfo()) {
                            PeerTestJob.this._log.info("[" + this._peer.toBase64().substring(0, 6) + "] Test reply took too long: " + (0L - timeLeft) + "ms too slow");
                        }
                        PeerTestJob.this.getContext().statManager().addRateData("peer.testTooSlow", 0L - timeLeft);
                        if (this._peer != null && cap != null && (bw.equals("N") || bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                            try {
                                prof.setCapacityBonus(-30);
                                if (speedBonus >= 9999999) {
                                    prof.setSpeedBonus(speedBonus - 9999999);
                                }
                                if (PeerTestJob.this._log.shouldInfo()) {
                                    PeerTestJob.this._log.info("Setting capacity bonus to -30 for [" + this._peer.toBase64().substring(0, 6) + "]");
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        }
                    } else {
                        PeerTestJob.this.getContext().statManager().addRateData("peer.testOK", (long)PeerTestJob.this.getTestTimeout() - timeLeft);
                        if (testAvg > (float)(timeout * 2) && (bw.equals("N") || bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                            try {
                                prof.setCapacityBonus(-30);
                                if (speedBonus >= 9999999) {
                                    prof.setSpeedBonus(speedBonus - 9999999);
                                }
                                if (PeerTestJob.this._log.shouldInfo()) {
                                    PeerTestJob.this._log.info("Setting capacity bonus to -30 for [" + this._peer.toBase64().substring(0, 6) + "] -> Average response is over twice timeout value");
                                }
                            }
                            catch (NumberFormatException numberFormatException) {}
                        } else if ((prof.getCapacityBonus() == -30 || prof.getSpeedBonus() < 9999999) && cap != null && reachable && testAvg < (float)(timeout * 2) && (bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                            try {
                                if (prof.getCapacityBonus() == -30) {
                                    prof.setCapacityBonus(0);
                                    if (PeerTestJob.this._log.shouldInfo()) {
                                        PeerTestJob.this._log.info("Resetting capacity bonus to 0 for [" + this._peer.toBase64().substring(0, 6) + "]");
                                    }
                                }
                                if (prof.getSpeedBonus() < 9999999 && cap != null && reachable && (bw.equals("N") || bw.equals("O") || bw.equals("P") || bw.equals("X"))) {
                                    prof.setSpeedBonus(speedBonus + 9999999);
                                    if (PeerTestJob.this._log.shouldInfo()) {
                                        PeerTestJob.this._log.info("Setting speed bonus to 9999999 for [" + this._peer.toBase64().substring(0, 6) + "]");
                                    }
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                // empty catch block
                            }
                            this._matchFound = true;
                            return true;
                        }
                    }
                }
            }
            return false;
        }

        public boolean matchFound() {
            return this._matchFound;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Test peer [").append(this._peer.toBase64().substring(0, 6));
            buf.append("] with nonce: ").append(this._nonce);
            return buf.toString();
        }
    }
}

