/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.startup;

import java.io.File;
import java.io.IOException;
import java.util.List;
import net.i2p.router.RouterContext;
import net.i2p.router.startup.ClientAppConfig;
import net.i2p.router.startup.LoadClientAppsJob;
import net.i2p.router.startup.WorkingDir;
import net.i2p.util.FileUtil;
import net.i2p.util.VersionComparator;

abstract class MigrateJetty {
    private static boolean _wasChecked;
    private static boolean _hasLatestJetty;
    private static final String OLD_CLASS = "org.mortbay.jetty.Server";
    private static final String OLD_CLASS_6 = "org.mortbay.start.Main";
    private static final String NEW_CLASS = "net.i2p.jetty.JettyStart";
    private static final String TEST_CLASS = "org.eclipse.jetty.server.Server";
    private static final String BACKUP_SUFFIX = ".jetty6";
    private static final String BACKUP_SUFFIX_8 = ".jetty8";
    private static final String BACKUP_SUFFIX_9 = ".jetty9-id";
    private static final String JETTY_TEMPLATE_DIR = "eepsite-jetty9";
    private static final String JETTY_TEMPLATE_PKGDIR = "eepsite";
    private static final String BASE_CONTEXT = "contexts/base-context.xml";
    private static final String CGI_CONTEXT = "contexts/cgi-context.xml";
    private static final String PROP_JETTY9_MIGRATED = "router.startup.jetty9.migrated";
    private static final String PROP_JETTY9_MIGRATED_2 = "router.startup.jetty-ids.migrated";

    MigrateJetty() {
    }

    public static void migrate(RouterContext ctx, List<ClientAppConfig> apps) {
        if (ctx.getBooleanProperty(PROP_JETTY9_MIGRATED_2)) {
            return;
        }
        String installed = ctx.getProperty("router.firstVersion");
        if (installed != null && VersionComparator.comp(installed, "2.9.0") >= 0) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED_2, "true");
            return;
        }
        boolean migrated1 = ctx.getBooleanProperty(PROP_JETTY9_MIGRATED);
        if (!migrated1 && installed != null && VersionComparator.comp(installed, "0.9.30") >= 0) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED, "true");
            migrated1 = true;
        }
        boolean migration2success = false;
        for (int i = 0; i < apps.size(); ++i) {
            String[] args;
            String backupSuffix;
            String client;
            ClientAppConfig app = apps.get(i);
            if (migrated1) {
                if (!app.className.equals(NEW_CLASS)) continue;
                client = "client application " + i + " [" + app.clientName + "] to fix DTDs and duplicate ids";
                backupSuffix = BACKUP_SUFFIX_9;
            } else if (app.className.equals(NEW_CLASS)) {
                client = "client application " + i + " [" + app.clientName + "] from Jetty 7/8 to Jetty 9";
                backupSuffix = BACKUP_SUFFIX_8;
            } else {
                if (!app.className.equals(OLD_CLASS) && !app.className.equals(OLD_CLASS_6)) continue;
                client = "client application " + i + " [" + app.clientName + "] from Jetty 5/6 " + app.className + " to Jetty 9 " + NEW_CLASS;
                backupSuffix = BACKUP_SUFFIX;
            }
            if (!MigrateJetty.hasLatestJetty()) {
                System.err.println("WARNING: Jetty 7 unavailable, cannot migrate " + client);
                continue;
            }
            if (app.args == null || (args = LoadClientAppsJob.parseArgs(app.args)).length == 0) continue;
            if (!migrated1) {
                System.err.println("WARNING: Unable to migrate " + client + ", delete client or uninstall and reinstall I2P+");
                app.disabled = true;
                continue;
            }
            System.err.println("Migrating " + client);
            for (String xml : args) {
                if (!xml.endsWith(".xml")) continue;
                File xmlFile = new File(xml);
                if (!xmlFile.isAbsolute()) {
                    xmlFile = new File(ctx.getAppDir(), xml);
                }
                if (!xmlFile.exists()) {
                    System.err.println("WARNING: XML file " + xmlFile + " not found, cannot migrate " + client);
                    continue;
                }
                boolean ok = MigrateJetty.backupFile(xmlFile, backupSuffix);
                if (!ok) {
                    System.err.println("WARNING: Failed to backup up XML file " + xmlFile + ", cannot migrate " + client);
                    continue;
                }
                File tmpFile = new File(xmlFile + ".tmp");
                try {
                    WorkingDir.migrateFileXML(xmlFile, tmpFile, "<Ref id=", "<Ref refid=", "/jetty/configure.dtd", "/jetty/configure_9_3.dtd");
                    ok = FileUtil.rename(tmpFile, xmlFile);
                    if (!ok) {
                        throw new IOException();
                    }
                }
                catch (IOException ioe) {
                    System.err.println("WARNING: Failed to migrate XML file " + xmlFile + ", cannot migrate " + client);
                    continue;
                }
                migration2success = true;
            }
            System.err.println("Migrated " + client);
        }
        if (migration2success) {
            ctx.router().saveConfig(PROP_JETTY9_MIGRATED_2, "true");
        }
    }

    private static boolean hasLatestJetty() {
        if (!_wasChecked) {
            try {
                LoadClientAppsJob.testClient(TEST_CLASS, null);
                _hasLatestJetty = true;
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
            _wasChecked = true;
        }
        return _hasLatestJetty;
    }

    private static boolean backupFile(File from) {
        return MigrateJetty.backupFile(from, BACKUP_SUFFIX);
    }

    private static boolean backupFile(File from, String suffix) {
        boolean rv;
        if (!from.exists()) {
            return true;
        }
        File to = new File(from.getAbsolutePath() + suffix);
        if (to.exists()) {
            to = new File(to.getAbsolutePath() + "." + System.currentTimeMillis());
        }
        if (rv = WorkingDir.copyFile(from, to)) {
            System.err.println("Backed up file " + from + " to " + to);
        } else {
            System.err.println("WARNING: Failed to back up file " + from + " to " + to);
        }
        return rv;
    }

    private static boolean backupAndMigrateFile(File templateDir, File toDir, String filename, String fromString, String toString) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        boolean rv2 = WorkingDir.migrateJettyXml(templateDir, toDir, filename, fromString, toString);
        return rv && rv2;
    }

    private static boolean backupAndCopyFile(File templateDir, File toDir, String filename) {
        File to = new File(toDir, filename);
        boolean rv = MigrateJetty.backupFile(to);
        File from = new File(templateDir, filename);
        boolean rv2 = WorkingDir.copyFile(from, to);
        return rv && rv2;
    }
}

