/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.sybil;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppState;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.LeaseSet;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.data.router.RouterKeyGenerator;
import net.i2p.router.Banlist;
import net.i2p.router.Blocklist;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.app.RouterApp;
import net.i2p.router.crypto.FamilyKeyCrypto;
import net.i2p.router.peermanager.DBHistory;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.sybil.Pair;
import net.i2p.router.sybil.PersistSybil;
import net.i2p.router.sybil.Points;
import net.i2p.router.sybil.Util;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.util.HashDistance;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Addresses;
import net.i2p.util.I2PAppThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounterUnsafe;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class Analysis
extends JobImpl
implements RouterApp,
Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final ClientAppManager _cmgr;
    private final PersistSybil _persister;
    private volatile ClientAppState _state = ClientAppState.UNINITIALIZED;
    private final DecimalFormat fmt = new DecimalFormat("#0.00");
    private boolean _wasRun;
    private final List<String> _familyExemptPoints24 = new ArrayList<String>(2);
    public static final String APP_NAME = "Sybil Scan";
    public static final String PROP_FREQUENCY = "router.sybilFrequency";
    public static final String PROP_THRESHOLD = "router.sybilThreshold";
    public static final String PROP_BLOCK = "router.sybilEnableBlocking";
    public static final String PROP_NONFF = "router.sybilAnalyzeAll";
    public static final String PROP_BLOCKTIME = "router.sybilBlockPeriod";
    public static final String PROP_REMOVETIME = "router.sybilDeleteOld";
    private static final long MIN_FREQUENCY = 3600000L;
    private static final long MIN_UPTIME = 4500000L;
    public static final long DEFAULT_FREQUENCY = 14400000L;
    public static final int PAIRMAX = 20;
    public static final int MAX = 10;
    private static final double POINTS32 = 5.0;
    private static final double POINTS24 = 4.0;
    private static final double POINTS16 = 0.25;
    private static final double POINTS_US32 = 25.0;
    private static final double POINTS_US24 = 20.0;
    private static final double POINTS_US16 = 10.0;
    private static final double POINTS_V6_US64 = 12.5;
    private static final double POINTS_V6_US48 = 5.0;
    private static final double POINTS64 = 2.0;
    private static final double POINTS48 = 0.5;
    private static final double POINTS_FAMILY = -20.0;
    private static final double POINTS_FAMILY_VERIFIED = -200.0;
    private static final double POINTS_NONFF = -5.0;
    private static final double POINTS_BAD_FAMILY = 75.0;
    private static final double POINTS_BAD_OUR_FAMILY = 100.0;
    private static final double POINTS_OUR_FAMILY = -100.0;
    private static final double POINTS_BAD_VERSION = 30.0;
    private static final double POINTS_UNREACHABLE = 10.0;
    private static final double POINTS_NEW = 4.0;
    private static final double POINTS_BANLIST = 5.0;
    public static final double MIN_CLOSE = 242.0;
    private static final double PAIR_DISTANCE_FACTOR = 2.0;
    private static final double OUR_KEY_FACTOR = 4.0;
    private static final double VERSION_FACTOR = 2.0;
    public static final boolean DEFAULT_BLOCK = true;
    public static final double DEFAULT_BLOCK_THRESHOLD = 35.0;
    public static final long DEFAULT_BLOCK_TIME = 86400000L;
    public static final long DEFAULT_REMOVE_TIME = 86400000L;
    public static final long SHORT_REMOVE_TIME = 43200000L;
    public static final float MIN_BLOCK_POINTS = 12.01f;
    private static final byte[] IPV6_LOCALHOST = new byte[16];
    private static final byte[] IPV6_NAT64;
    private static final BigInteger BI_MAX;
    private static final long DAY = 86400000L;
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";

    private Analysis(RouterContext ctx, ClientAppManager mgr, String[] args) {
        super(ctx);
        this._context = ctx;
        this._log = ctx.logManager().getLog(Analysis.class);
        this._cmgr = mgr;
        this._persister = new PersistSybil(ctx);
        this._familyExemptPoints24.add("SUNYSB");
        this._familyExemptPoints24.add("stormycloud");
    }

    public static synchronized Analysis getInstance(RouterContext ctx) {
        ClientAppManager cmgr = ctx.clientAppManager();
        if (cmgr == null) {
            return null;
        }
        Analysis rv = (Analysis)cmgr.getRegisteredApp(APP_NAME);
        if (rv == null) {
            rv = new Analysis(ctx, cmgr, null);
            rv.startup();
        }
        return rv;
    }

    public PersistSybil getPersister() {
        return this._persister;
    }

    @Override
    public void runJob() {
        I2PAppThread t = new I2PAppThread(this, this.getDisplayName());
        t.setPriority(1);
        ((Thread)t).start();
        this.schedule();
    }

    @Override
    public void run() {
        long now = this._context.clock().now();
        this._log.info("Running Sybil analysis...");
        Map<Hash, Points> points = this.backgroundAnalysis(this._context.getBooleanProperty(PROP_NONFF));
        if (!points.isEmpty()) {
            try {
                this._log.info("Storing Sybil analysis...");
                this._persister.store(now, points);
                this._persister.removeOld();
                this._log.info("Store complete");
            }
            catch (IOException ioe) {
                this._log.error("Failed to store Sybil analysis", ioe);
            }
        }
    }

    @Override
    public synchronized void startup() {
        this.changeState(ClientAppState.STARTING);
        this.changeState(ClientAppState.RUNNING);
        this._cmgr.register(this);
        this._persister.removeOld();
        InitJob init = new InitJob();
        long start = this._context.clock().now() + 5000L;
        init.getTiming().setStartAfter(start);
        this._context.jobQueue().addJob(init);
        this.schedule();
    }

    @Override
    public synchronized void shutdown(String[] args) {
        if (this._state == ClientAppState.STOPPED) {
            return;
        }
        this.changeState(ClientAppState.STOPPING);
        this.changeState(ClientAppState.STOPPED);
    }

    @Override
    public ClientAppState getState() {
        return this._state;
    }

    @Override
    public String getName() {
        return APP_NAME;
    }

    @Override
    public String getDisplayName() {
        return "Sybil Analyzer";
    }

    private synchronized void changeState(ClientAppState state) {
        this._state = state;
        if (this._cmgr != null) {
            this._cmgr.notify(this, state, null, null);
        }
    }

    public synchronized void schedule() {
        long freq = this._context.getProperty(PROP_FREQUENCY, 14400000L);
        if (freq > 0L) {
            List<Long> previous = this._persister.load();
            long now = this._context.clock().now() + 15000L;
            if (freq < 3600000L) {
                freq = 3600000L;
            }
            long when = this._wasRun ? now + freq : (!previous.isEmpty() ? Math.max(previous.get(0) + freq, now) : now);
            long up = this._context.router().getUptime();
            when = Math.max(when, now + 4500000L - up);
            this.getTiming().setStartAfter(when);
            this._context.jobQueue().addJob(this);
        } else {
            this._context.jobQueue().removeJob(this);
        }
    }

    private void addPoints(Map<Hash, Points> points, Hash h, double d, String reason) {
        Points dd = points.get(h);
        if (dd != null) {
            dd.addPoints(d, reason);
        } else {
            points.put(h, new Points(d, reason));
        }
    }

    public List<RouterInfo> getFloodfills(Hash us) {
        Set<Hash> ffs = this._context.peerManager().getPeersByCapability('f');
        ArrayList<RouterInfo> ris = new ArrayList<RouterInfo>(ffs.size());
        for (Hash ff : ffs) {
            RouterInfo ri;
            if (ff.equals(us) || (ri = this._context.netDb().lookupRouterInfoLocally(ff)) == null) continue;
            ris.add(ri);
        }
        return ris;
    }

    public List<RouterInfo> getAllRouters(Hash us) {
        Set<RouterInfo> set = this._context.netDb().getRouters();
        ArrayList<RouterInfo> ris = new ArrayList<RouterInfo>(set.size());
        for (RouterInfo ri : set) {
            if (ri.getIdentity().getHash().equals(us)) continue;
            ris.add(ri);
        }
        return ris;
    }

    public double getAvgMinDist(List<RouterInfo> ris) {
        double tot = 0.0;
        int count = 200;
        byte[] b = new byte[32];
        for (int i = 0; i < count; ++i) {
            this._context.random().nextBytes(b);
            Hash h = new Hash(b);
            double d = Analysis.closestDistance(h, ris);
            tot += d;
        }
        double avgMinDist = tot / (double)count;
        return avgMinDist;
    }

    public synchronized Map<Hash, Points> backgroundAnalysis(boolean includeAll) {
        this._wasRun = true;
        HashMap<Hash, Points> points = new HashMap<Hash, Points>(64);
        Hash us = this._context.routerHash();
        if (us == null) {
            return points;
        }
        List<RouterInfo> ris = includeAll ? this.getAllRouters(us) : this.getFloodfills(us);
        if (ris.isEmpty()) {
            return points;
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Analyzing " + ris.size() + " routers " + (includeAll ? "(including non-floodfills)" : "(floodfills only)"));
        }
        this.calculateIPGroupsFamily(ris, points);
        DummyList dummy = new DummyList();
        this.calculateIPGroupsUs(ris, points, dummy, dummy, dummy, dummy, dummy);
        long sz = ris.size();
        if (sz * sz < SystemVersion.getMaxMemory() / 10L) {
            ArrayList<Pair> pairs = new ArrayList<Pair>(20);
            this.calculatePairDistance(ris, points, pairs);
        }
        Hash ourRKey = this._context.router().getRouterInfo().getRoutingKey();
        this.calculateRouterInfo(ourRKey, "our rkey", ris, points);
        RouterKeyGenerator rkgen = this._context.routerKeyGenerator();
        Hash nkey = rkgen.getNextRoutingKey(us);
        this.calculateRouterInfo(nkey, "our rkey (tomorrow)", ris, points);
        this.calculateRouterInfo(us, "our router", ris, points);
        Map<Hash, TunnelPool> clientInboundPools = this._context.tunnelManager().getInboundClientPools();
        ArrayList<Hash> destinations = new ArrayList<Hash>(clientInboundPools.keySet());
        for (Hash client : destinations) {
            LeaseSet ls;
            boolean isLocal = this._context.clientManager().isLocal(client);
            if (!isLocal || !this._context.clientManager().shouldPublishLeaseSet(client) || (ls = this._context.netDb().lookupLeaseSetLocally(client)) == null) continue;
            Hash rkey = ls.getRoutingKey();
            TunnelPool in = clientInboundPools.get(client);
            String name = in != null ? DataHelper.escapeHTML(in.getSettings().getDestinationNickname()) : client.toBase64().substring(0, 4);
            this.calculateRouterInfo(rkey, name, ris, points);
            nkey = rkgen.getNextRoutingKey(ls.getHash());
            this.calculateRouterInfo(nkey, name + " (tomorrow)", ris, points);
        }
        this.addProfilePoints(ris, points);
        this.addVersionPoints(ris, points);
        if (this._context.getProperty(PROP_BLOCK, true)) {
            this.doBlocking(points);
        }
        return points;
    }

    private void doBlocking(Map<Hash, Points> points) {
        double threshold = 35.0;
        long now = this._context.clock().now();
        long blockUntil = this._context.getProperty(PROP_BLOCKTIME, 86400000L) + now;
        try {
            threshold = Double.parseDouble(this._context.getProperty(PROP_THRESHOLD, Double.toString(35.0)));
            if (threshold < (double)12.01f) {
                threshold = 12.01f;
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        String day = DataHelper.formatTime(now);
        HashSet<String> blocks = new HashSet<String>();
        for (Map.Entry<Hash, Points> e : points.entrySet()) {
            double p = e.getValue().getPoints();
            if (!(p >= threshold)) continue;
            Hash h = e.getKey();
            blocks.add(h.toBase64());
            RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(h);
            if (ri != null) {
                for (RouterAddress ra : ri.getAddresses()) {
                    String host;
                    byte[] ip = ra.getIP();
                    if (ip != null) {
                        this._context.blocklist().add(ip, "Sybil " + h.toBase64());
                    }
                    if ((host = ra.getHost()) == null) continue;
                    blocks.add(host);
                }
            }
            String reason = " <b>\u279c</b> " + day + ": Sybil Scan (" + this.fmt.format(p).replace(".00", "") + " points)";
            if (this._log.shouldWarn()) {
                if (ri != null) {
                    this._log.warn("Banning " + reason.replace("<b>\u279c</b>", "->") + "\n* Blocked IP Address(es): " + ri);
                } else {
                    this._log.warn("Banning " + h.toBase64() + ' ' + reason.replace("<b>\u279c</b>", "->"));
                }
            }
            this._context.banlist().banlistRouter(h, reason, null, null, blockUntil);
        }
        if (!blocks.isEmpty()) {
            this._persister.storeBlocklist(blocks, blockUntil);
        }
    }

    public double calculatePairDistance(List<RouterInfo> ris, Map<Hash, Points> points, List<Pair> pairs) {
        int sz = ris.size();
        double total = 0.0;
        for (int i = 0; i < sz; ++i) {
            RouterInfo info1 = ris.get(i);
            if (!info1.getCapabilities().contains("f")) continue;
            for (int j = i + 1; j < sz; ++j) {
                RouterInfo info2 = ris.get(j);
                if (!info2.getCapabilities().contains("f")) continue;
                BigInteger dist = HashDistance.getDistance(info1.getHash(), info2.getHash());
                if (pairs.isEmpty()) {
                    pairs.add(new Pair(info1, info2, dist));
                } else if (pairs.size() < 20) {
                    pairs.add(new Pair(info1, info2, dist));
                    Collections.sort(pairs);
                } else if (dist.compareTo(pairs.get((int)19).dist) < 0) {
                    pairs.set(19, new Pair(info1, info2, dist));
                    Collections.sort(pairs);
                }
                total += Analysis.biLog2(dist);
            }
        }
        double avg = total / ((double)(sz * sz) / 2.0);
        String other = this._context.getBooleanProperty(PROP_NONFF) ? "router" : "floodfill";
        for (Pair p : pairs) {
            double distance = Analysis.biLog2(p.dist);
            double point = 242.0 - distance;
            if (point < 0.0) break;
            String b2 = p.r2.getHash().toBase64();
            this.addPoints(points, p.r1.getHash(), point *= 2.0, "Very close (" + this.fmt.format(distance) + ") to other " + other + " <a href=\"netdb?r=" + b2 + "\">" + b2.substring(0, 6) + "</a>");
            String b1 = p.r1.getHash().toBase64();
            this.addPoints(points, p.r2.getHash(), point, "Very close (" + this.fmt.format(distance) + ") to other " + other + " <a href=\"netdb?r=" + b1 + "\">" + b1.substring(0, 6) + "</a>");
        }
        return avg;
    }

    private static double closestDistance(Hash h, List<RouterInfo> ris) {
        BigInteger min = BI_MAX;
        for (RouterInfo info : ris) {
            BigInteger dist = HashDistance.getDistance(h, info.getHash());
            if (dist.compareTo(min) >= 0) continue;
            min = dist;
        }
        return Analysis.biLog2(min);
    }

    private static byte[] getIP(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null || rv.length != 4) continue;
            return rv;
        }
        return null;
    }

    private static byte[] getIPv6(RouterInfo ri) {
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null || rv.length != 16 || DataHelper.eq(rv, IPV6_LOCALHOST) || DataHelper.eq(rv, 0, IPV6_NAT64, 0, 12)) continue;
            return rv;
        }
        return null;
    }

    public void calculateIPGroupsUs(List<RouterInfo> ris, Map<Hash, Points> points, List<RouterInfo> ri32, List<RouterInfo> ri24, List<RouterInfo> ri16, List<RouterInfo> ri64, List<RouterInfo> ri48) {
        String reason48;
        String reason64;
        String reason16;
        String reason24;
        String reason32;
        String last;
        byte[] ourIPv6;
        String last2;
        RouterInfo us = this._context.router().getRouterInfo();
        byte[] ourIP = Analysis.getIP(us);
        if (ourIP == null && (last2 = this._context.getProperty("i2np.lastIP")) != null) {
            ourIP = Addresses.getIPOnly(last2);
        }
        if ((ourIPv6 = Analysis.getIPv6(us)) == null && (last = this._context.getProperty("i2np.lastIPv6")) != null) {
            ourIPv6 = Addresses.getIPOnly(last);
        }
        if (ourIP == null && ourIPv6 == null) {
            return;
        }
        if (ourIP != null) {
            reason32 = "Same IP as <a href=\"/netdb?ip=" + Addresses.toString(ourIP) + "&amp;sybil\">us</a>";
            reason24 = "Same IPv4 /24 as <a href=\"/netdb?ip=" + (ourIP[0] & 0xFF) + '.' + (ourIP[1] & 0xFF) + '.' + (ourIP[2] & 0xFF) + ".0/24&amp;sybil\">us</a>";
            reason16 = "Same IPv4 /16 as <a href=\"/netdb?ip=" + (ourIP[0] & 0xFF) + '.' + (ourIP[1] & 0xFF) + ".0.0/16&amp;sybil\">us</a>";
        } else {
            reason32 = null;
            reason24 = null;
            reason16 = null;
        }
        if (ourIPv6 != null) {
            reason64 = "Same IPv6 /64 as <a href=\"/netdb?ip=" + Integer.toString(ourIPv6[0] << 8 & 0xFF00 | ourIPv6[1] & 0xFF, 16) + ':' + Integer.toString(ourIPv6[2] << 8 & 0xFF00 | ourIPv6[3] & 0xFF, 16) + ':' + Integer.toString(ourIPv6[4] << 8 & 0xFF00 | ourIPv6[5] & 0xFF, 16) + ':' + Integer.toString(ourIPv6[6] << 8 & 0xFF00 | ourIPv6[7] & 0xFF, 16) + "::&amp;sybil\">us</a>";
            reason48 = "Same IPv6 /48 as <a href=\"/netdb?ip=" + Integer.toString(ourIPv6[0] << 8 & 0xFF00 | ourIPv6[1] & 0xFF, 16) + ':' + Integer.toString(ourIPv6[2] << 8 & 0xFF00 | ourIPv6[3] & 0xFF, 16) + ':' + Integer.toString(ourIPv6[4] << 8 & 0xFF00 | ourIPv6[5] & 0xFF, 16) + "::&amp;sybil\">us</a>";
        } else {
            reason64 = null;
            reason48 = null;
        }
        for (RouterInfo info : ris) {
            byte[] ip;
            if (ourIP != null) {
                ip = Analysis.getIP(info);
                if (ip == null) continue;
                if (ip[0] == ourIP[0] && ip[1] == ourIP[1]) {
                    if (ip[2] == ourIP[2]) {
                        if (ip[3] == ourIP[3]) {
                            this.addPoints(points, info.getHash(), 25.0, reason32);
                            ri32.add(info);
                        } else {
                            this.addPoints(points, info.getHash(), 20.0, reason24);
                            ri24.add(info);
                        }
                    } else {
                        this.addPoints(points, info.getHash(), 10.0, reason16);
                        ri16.add(info);
                    }
                }
            }
            if (ourIPv6 == null || (ip = Analysis.getIPv6(info)) == null || !DataHelper.eq(ip, 0, ourIPv6, 0, 6)) continue;
            if (ip[6] == ourIPv6[6] && ip[7] == ourIPv6[7]) {
                this.addPoints(points, info.getHash(), 12.5, reason64);
                ri64.add(info);
                continue;
            }
            this.addPoints(points, info.getHash(), 5.0, reason48);
            ri48.add(info);
        }
    }

    public Map<Integer, List<RouterInfo>> calculateIPGroups32(List<RouterInfo> ris, Map<Hash, Points> points) {
        ObjectCounterUnsafe<Integer> oc = new ObjectCounterUnsafe<Integer>();
        for (RouterInfo info : ris) {
            byte[] byArray = Analysis.getIP(info);
            if (byArray == null) continue;
            Integer x = (int)DataHelper.fromLong(byArray, 0, 4);
            oc.increment(x);
        }
        HashMap<Integer, List<RouterInfo>> rv = new HashMap<Integer, List<RouterInfo>>();
        for (Integer n : oc.objects()) {
            int count = oc.count(n);
            if (count < 2) continue;
            rv.put(n, new ArrayList(count));
        }
        for (Map.Entry entry : rv.entrySet()) {
            Integer ii = (Integer)entry.getKey();
            int count = oc.count(ii);
            double point = 5.0 * (double)(count - 1);
            int i = ii;
            int i0 = i >> 24 & 0xFF;
            int i1 = i >> 16 & 0xFF;
            int i2 = i >> 8 & 0xFF;
            int i3 = i & 0xFF;
            String reason = "Same IP with <a href=\"/netdb?ip=" + i0 + '.' + i1 + '.' + i2 + '.' + i3 + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
            for (RouterInfo info : ris) {
                byte[] ip = Analysis.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2 || (ip[3] & 0xFF) != i3) continue;
                ((List)entry.getValue()).add(info);
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public Map<Integer, List<RouterInfo>> calculateIPGroups24(List<RouterInfo> ris, Map<Hash, Points> points) {
        ObjectCounterUnsafe<Integer> oc = new ObjectCounterUnsafe<Integer>();
        for (RouterInfo routerInfo : ris) {
            byte[] ip = Analysis.getIP(routerInfo);
            if (ip == null) continue;
            Integer x = (int)DataHelper.fromLong(ip, 0, 3);
            oc.increment(x);
        }
        HashMap<Integer, List<RouterInfo>> rv = new HashMap<Integer, List<RouterInfo>>();
        for (Integer ii : oc.objects()) {
            int count = oc.count(ii);
            if (count < 2) continue;
            rv.put(ii, new ArrayList(count));
        }
        FamilyKeyCrypto familyKeyCrypto = this._context.router().getFamilyKeyCrypto();
        for (Map.Entry e : rv.entrySet()) {
            Integer ii = (Integer)e.getKey();
            int count = oc.count(ii);
            double point = 4.0 * (double)(count - 1);
            int i = ii;
            int i0 = i >> 16;
            int i1 = i >> 8 & 0xFF;
            int i2 = i & 0xFF;
            String reason = "Same IPv4 /24 with <a href=\"/netdb?ip=" + i0 + '.' + i1 + '.' + i2 + ".0/24&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
            for (RouterInfo info : ris) {
                String f;
                byte[] ip = Analysis.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2 || familyKeyCrypto != null && (f = info.getOption("family")) != null && this._familyExemptPoints24.contains(f) && familyKeyCrypto.verify(info) == FamilyKeyCrypto.Result.STORED_KEY) continue;
                ((List)e.getValue()).add(info);
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public Map<Integer, List<RouterInfo>> calculateIPGroups16(List<RouterInfo> ris, Map<Hash, Points> points) {
        ObjectCounterUnsafe<Integer> oc = new ObjectCounterUnsafe<Integer>();
        for (RouterInfo info : ris) {
            byte[] byArray = Analysis.getIP(info);
            if (byArray == null) continue;
            Integer x = (int)DataHelper.fromLong(byArray, 0, 2);
            oc.increment(x);
        }
        HashMap<Integer, List<RouterInfo>> rv = new HashMap<Integer, List<RouterInfo>>();
        for (Integer n : oc.objects()) {
            int count = oc.count(n);
            if (count < 4) continue;
            rv.put(n, new ArrayList(count));
        }
        for (Map.Entry entry : rv.entrySet()) {
            Integer ii = (Integer)entry.getKey();
            int count = oc.count(ii);
            double point = 0.25 * (double)(count - 1);
            int i = ii;
            int i0 = i >> 8;
            int i1 = i & 0xFF;
            String reason = "Same IPv4 /16 with <a href=\"/netdb?ip=" + i0 + '.' + i1 + ".0.0/16&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
            for (RouterInfo info : ris) {
                byte[] ip = Analysis.getIP(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1) continue;
                ((List)entry.getValue()).add(info);
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public Map<Long, List<RouterInfo>> calculateIPGroups64(List<RouterInfo> ris, Map<Hash, Points> points) {
        ObjectCounterUnsafe<Long> oc = new ObjectCounterUnsafe<Long>();
        for (RouterInfo info : ris) {
            byte[] byArray = Analysis.getIPv6(info);
            if (byArray == null) continue;
            Long x = DataHelper.fromLong8(byArray, 0);
            oc.increment(x);
        }
        HashMap<Long, List<RouterInfo>> rv = new HashMap<Long, List<RouterInfo>>();
        for (Long l : oc.objects()) {
            int count = oc.count(l);
            if (count < 2) continue;
            rv.put(l, new ArrayList(count));
        }
        for (Map.Entry entry : rv.entrySet()) {
            Long ii = (Long)entry.getKey();
            int count = oc.count(ii);
            double point = 2.0 * (double)(count - 1);
            long i = ii;
            int i0 = (int)(i >> 56 & 0xFFL);
            int i1 = (int)(i >> 48 & 0xFFL);
            int i2 = (int)(i >> 40 & 0xFFL);
            int i3 = (int)(i >> 32 & 0xFFL);
            int i4 = (int)(i >> 24 & 0xFFL);
            int i5 = (int)(i >> 16 & 0xFFL);
            int i6 = (int)(i >> 8 & 0xFFL);
            int i7 = (int)(i & 0xFFL);
            String reason = "Same IPv6 /64 with <a href=\"/netdb?ip=" + Integer.toString(i0 << 8 | i1, 16) + ':' + Integer.toString(i2 << 8 | i3, 16) + ':' + Integer.toString(i4 << 8 | i5, 16) + ':' + Integer.toString(i6 << 8 | i7, 16) + "::&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
            for (RouterInfo info : ris) {
                byte[] ip = Analysis.getIPv6(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2 || (ip[3] & 0xFF) != i3 || (ip[4] & 0xFF) != i4 || (ip[5] & 0xFF) != i5 || (ip[6] & 0xFF) != i6 || (ip[7] & 0xFF) != i7) continue;
                ((List)entry.getValue()).add(info);
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public Map<Long, List<RouterInfo>> calculateIPGroups48(List<RouterInfo> ris, Map<Hash, Points> points) {
        ObjectCounterUnsafe<Long> oc = new ObjectCounterUnsafe<Long>();
        for (RouterInfo info : ris) {
            byte[] byArray = Analysis.getIPv6(info);
            if (byArray == null) continue;
            Long x = DataHelper.fromLong(byArray, 0, 6);
            oc.increment(x);
        }
        HashMap<Long, List<RouterInfo>> rv = new HashMap<Long, List<RouterInfo>>();
        for (Long l : oc.objects()) {
            int count = oc.count(l);
            if (count < 4) continue;
            rv.put(l, new ArrayList(count));
        }
        for (Map.Entry entry : rv.entrySet()) {
            Long ii = (Long)entry.getKey();
            int count = oc.count(ii);
            double point = 0.5 * (double)(count - 1);
            long i = ii;
            int i0 = (int)(i >> 40 & 0xFFL);
            int i1 = (int)(i >> 32 & 0xFFL);
            int i2 = (int)(i >> 24 & 0xFFL);
            int i3 = (int)(i >> 16 & 0xFFL);
            int i4 = (int)(i >> 8 & 0xFFL);
            int i5 = (int)(i & 0xFFL);
            String reason = "Same IPv6 /48 with <a href=\"/netdb?ip=" + Integer.toString(i0 << 8 | i1, 16) + ':' + Integer.toString(i2 << 8 | i3, 16) + ':' + Integer.toString(i4 << 8 | i5, 16) + "::&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
            for (RouterInfo info : ris) {
                byte[] ip = Analysis.getIPv6(info);
                if (ip == null || (ip[0] & 0xFF) != i0 || (ip[1] & 0xFF) != i1 || (ip[2] & 0xFF) != i2 || (ip[3] & 0xFF) != i3 || (ip[4] & 0xFF) != i4 || (ip[5] & 0xFF) != i5) continue;
                ((List)entry.getValue()).add(info);
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public Map<String, List<RouterInfo>> calculateIPGroupsFamily(List<RouterInfo> ris, Map<Hash, Points> points) {
        HashMap<String, List<RouterInfo>> rv = new HashMap<String, List<RouterInfo>>();
        for (RouterInfo info : ris) {
            String fam = info.getOption("family");
            if (fam == null) continue;
            ArrayList<RouterInfo> fris = (ArrayList<RouterInfo>)rv.get(fam);
            if (fris == null) {
                fris = new ArrayList<RouterInfo>(4);
                rv.put(fam, fris);
            }
            fris.add(info);
        }
        FamilyKeyCrypto fkc = this._context.router().getFamilyKeyCrypto();
        String ourFamily = fkc != null ? fkc.getOurFamilyName() : null;
        for (Map.Entry e : rv.entrySet()) {
            String s = (String)e.getKey();
            List list = (List)e.getValue();
            int count = list.size();
            String ss = DataHelper.escapeHTML(s);
            for (RouterInfo info : list) {
                String reason;
                double point;
                if (fkc != null) {
                    if (s.equals(ourFamily)) {
                        if (fkc.verifyOurFamily(info)) {
                            point = -100.0;
                            reason = "Our family \"" + ss + "\" with <a href=\"/netdb?fam=" + ss + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
                        } else {
                            point = 100.0;
                            reason = "Spoofed our family \"" + ss + "\" with <a href=\"/netdb?fam=" + ss + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
                        }
                    } else {
                        FamilyKeyCrypto.Result r = fkc.verify(info);
                        switch (r) {
                            case BAD_KEY: 
                            case BAD_SIG: 
                            case INVALID_SIG: 
                            case NO_SIG: {
                                point = 75.0;
                                reason = "Bad family config \"" + ss + '\"';
                                break;
                            }
                            case STORED_KEY: {
                                point = -200.0;
                                if (count > 1) {
                                    reason = "In verified family \"" + ss + "\" with <a href=\"/netdb?fam=" + ss + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
                                    break;
                                }
                                reason = "In verified family \"" + ss + '\"';
                                break;
                            }
                            default: {
                                point = -20.0;
                                if (count > 1) {
                                    reason = "In unverified family \"" + ss + "\" with <a href=\"/netdb?fam=" + ss + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
                                    break;
                                }
                                reason = "In unverified family \"" + ss + '\"';
                                break;
                            }
                        }
                    }
                } else if (count > 1) {
                    point = -20.0;
                    reason = "In unverified family \"" + ss + "\" with <a href=\"/netdb?fam=" + ss + "&amp;sybil\">" + (count - 1) + " other" + (count > 2 ? "s" : "") + "</a>";
                } else {
                    point = -20.0;
                    reason = "In unverified family \"" + ss + '\"';
                }
                this.addPoints(points, info.getHash(), point, reason);
            }
        }
        return rv;
    }

    public void addProfilePoints(List<RouterInfo> ris, Map<Hash, Points> points) {
        Map<Hash, Banlist.Entry> banEntries = this._context.banlist().getEntries();
        long now = this._context.clock().now();
        RateAverages ra = RateAverages.getTemp();
        for (RouterInfo info : ris) {
            double avg;
            Rate r;
            RateStat rs;
            DBHistory dbh;
            long age;
            PeerProfile prof;
            Hash h = info.getHash();
            if (this._context.banlist().isBanlisted(h)) {
                StringBuilder buf = new StringBuilder("Banlist");
                Banlist.Entry entry = banEntries.get(h);
                if (entry != null && entry.cause != null) {
                    if (entry.causeCode != null) {
                        buf.append(this._t(entry.cause, entry.causeCode));
                    } else {
                        buf.append(this._t(entry.cause));
                    }
                }
                this.addPoints(points, h, 5.0, buf.toString());
            }
            if (!info.getCapabilities().contains("f") || (prof = this._context.profileOrganizer().getProfileNonblocking(h)) == null) continue;
            long heard = prof.getFirstHeardAbout();
            if (heard > 0L && (age = Math.max(now - heard, 1L)) < 172800000L) {
                double point = Math.min(4.0, (double)(172800000L - age) / 4.32E7);
                this.addPoints(points, h, point, "First heard about: " + this._t("{0} ago", DataHelper.formatDuration2(age).replace("&nbsp;", " ")));
            }
            if ((dbh = prof.getDBHistory()) == null || (rs = dbh.getFailedLookupRate()) == null || (r = rs.getRate(86400000L)) == null) continue;
            r.computeAverages(ra, false);
            if (ra.getTotalEventCount() <= 0L || !((avg = 100.0 * ra.getAverage()) > 40.0)) continue;
            this.addPoints(points, h, (avg - 40.0) / 6.0, "Lookup fail rate: " + (int)avg + '%');
        }
    }

    public void addVersionPoints(List<RouterInfo> ris, Map<Hash, Points> points) {
        int minor;
        RouterInfo us = this._context.router().getRouterInfo();
        if (us == null) {
            return;
        }
        String ourVer = us.getVersion();
        if (!ourVer.startsWith("0.9.")) {
            return;
        }
        int dot = (ourVer = ourVer.substring(4)).indexOf(46);
        if (dot > 0) {
            ourVer = ourVer.substring(0, dot);
        }
        try {
            minor = Integer.parseInt(ourVer);
        }
        catch (NumberFormatException nfe) {
            return;
        }
        for (RouterInfo info : ris) {
            int hisMinor;
            String hisFullVer;
            Hash h = info.getHash();
            String caps = info.getCapabilities();
            if (!caps.contains("R")) {
                this.addPoints(points, h, 10.0, "Unreachable: " + DataHelper.escapeHTML(caps));
            }
            if (!caps.contains("f")) {
                this.addPoints(points, h, -5.0, "Non-floodfill");
            }
            if (!(hisFullVer = info.getVersion()).startsWith("0.9.")) {
                if (hisFullVer.startsWith("1.")) continue;
                this.addPoints(points, h, 30.0, "Strange version " + DataHelper.escapeHTML(hisFullVer));
                continue;
            }
            String hisVer = hisFullVer.substring(4);
            dot = hisVer.indexOf(46);
            if (dot > 0) {
                hisVer = hisVer.substring(0, dot);
            }
            try {
                hisMinor = Integer.parseInt(hisVer);
            }
            catch (NumberFormatException nfe) {
                continue;
            }
            int howOld = minor - hisMinor;
            if (howOld < 3) continue;
            this.addPoints(points, h, (double)howOld * 2.0, howOld + " versions behind (" + DataHelper.escapeHTML(hisFullVer) + ")");
        }
    }

    public void calculateRouterInfo(Hash us, String usName, List<RouterInfo> ris, Map<Hash, Points> points) {
        Collections.sort(ris, new RouterInfoRoutingKeyComparator(us));
        int count = Math.min(10, ris.size());
        for (int i = 0; i < count; ++i) {
            RouterInfo ri = ris.get(i);
            if (!ri.getCapabilities().contains("f")) continue;
            BigInteger bidist = HashDistance.getDistance(us, ri.getHash());
            double dist = Analysis.biLog2(bidist);
            double point = 242.0 - dist;
            if (point <= 0.0) break;
            this.addPoints(points, ri.getHash(), point *= 4.0, "Very close (" + this.fmt.format(dist) + ") to our key " + usName + ": " + us.toBase64());
        }
    }

    private static double biLog2(BigInteger a) {
        return Util.biLog2(a);
    }

    private String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private String _t(String s, Object o) {
        return Translate.getString(s, o, this._context, BUNDLE_NAME);
    }

    static {
        Analysis.IPV6_LOCALHOST[15] = 1;
        IPV6_NAT64 = new byte[16];
        Analysis.IPV6_NAT64[1] = 100;
        Analysis.IPV6_NAT64[2] = -1;
        Analysis.IPV6_NAT64[3] = -101;
        BI_MAX = new BigInteger("2").pow(256);
    }

    private static class DummyList
    extends ArrayList<RouterInfo> {
        public DummyList() {
            super(0);
        }

        @Override
        public boolean add(RouterInfo ri) {
            return true;
        }
    }

    private static class RouterInfoRoutingKeyComparator
    implements Comparator<RouterInfo>,
    Serializable {
        private final Hash _us;

        public RouterInfoRoutingKeyComparator(Hash us) {
            this._us = us;
        }

        @Override
        public int compare(RouterInfo l, RouterInfo r) {
            return HashDistance.getDistance(this._us, l.getHash()).compareTo(HashDistance.getDistance(this._us, r.getHash()));
        }
    }

    private class InitJob
    extends JobImpl {
        public InitJob() {
            super(Analysis.this._context);
        }

        @Override
        public String getName() {
            return "Load Sybil Blocklist";
        }

        @Override
        public void runJob() {
            Map<String, Long> map = Analysis.this._persister.readBlocklist();
            if (map == null || map.isEmpty()) {
                return;
            }
            Blocklist bl = Analysis.this._context.blocklist();
            Banlist ban = Analysis.this._context.banlist();
            File file = Analysis.this._persister.getBlocklistFile();
            String source = file.toString();
            String when = DataHelper.formatTime(file.lastModified());
            for (Map.Entry<String, Long> e : map.entrySet()) {
                String s = e.getKey();
                if (s.contains(".") || s.contains(":")) {
                    bl.add(s, source);
                    continue;
                }
                byte[] b = Base64.decode(s);
                if (b == null || b.length != 32) continue;
                Hash h = Hash.create(b);
                long until = e.getValue();
                String reason = " <b>\u279c</b> Sybil Analysis {0}";
                ban.banlistRouter(h, reason, when, null, until);
            }
        }
    }
}

