/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.I2PAppContext;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.GeoIP;
import net.i2p.router.transport.GetBidsJob;
import net.i2p.router.transport.StrictCountries;
import net.i2p.router.transport.Transport;
import net.i2p.router.transport.TransportImpl;
import net.i2p.router.transport.TransportManager;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.crypto.X25519KeyFactory;
import net.i2p.util.AddressType;
import net.i2p.util.Addresses;
import net.i2p.util.ArraySet;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;
import net.i2p.util.Translate;

public class CommSystemFacadeImpl
extends CommSystemFacade {
    private final Log _log;
    private final RouterContext _context;
    private final TransportManager _manager;
    private final GeoIP _geoIP;
    private final Map<String, Object> _exemptIncoming;
    private volatile boolean _netMonitorStatus;
    private boolean _wasStarted;
    private static final String PROP_DISABLED = "i2np.disable";
    public static final String PROP_BLOCK_MY_COUNTRY = "i2np.blockMyCountry";
    public static final String PROP_IP_COUNTRY = "i2np.lastCountry";
    private static final String BUNDLE_NAME = "net.i2p.router.web.messages";
    private static final String COUNTRY_BUNDLE_NAME = "net.i2p.router.countries.messages";
    private static final Object DUMMY = 0;
    private static final int START_DELAY = SystemVersion.isSlow() ? 60000 : 5000;
    private static final int LOOKUP_TIME = 75000;
    private static final String PROP_ENABLE_REVERSE_LOOKUPS = "routerconsole.enableReverseLookups";
    private static final Charset ENCODING = StandardCharsets.UTF_8;
    private static final String NEWLINE = "\n";
    private static final String RDNS_CACHE_FILE = I2PAppContext.getGlobalContext().getConfigDir() + File.separator + "rdnscache.txt";
    private static final long EXPIRE_TIME = 86400000L;
    private static final long EXPIRE_TIME_SHORT = 3600000L;
    private static final int MAX_RDNS_CACHE_SIZE = SystemVersion.getMaxMemory() < 0x20000000L ? 16384 : 32768;
    private static Object rdnslock = new Object();
    private static Map<String, CacheEntry> rdnsCache = new HashMap<String, CacheEntry>();
    private static final int MAX_COUNTRY_CACHE_SIZE = 20000;
    private static final Random random = new Random();
    private long lastLookupTime = 0L;
    private long lastUnknownPurge = 0L;
    private LinkedHashMap<Hash, String> countryCache = new LinkedHashMap<Hash, String>(20000, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<Hash, String> eldest) {
            return this.size() > 20000;
        }
    };
    private static final int TIME_START_DELAY = 300000;
    private static final int TIME_REPEAT_DELAY = 480000;

    public CommSystemFacadeImpl(RouterContext context) {
        this._context = context;
        this._log = this._context.logManager().getLog(CommSystemFacadeImpl.class);
        this._netMonitorStatus = true;
        this._geoIP = new GeoIP(this._context);
        this._manager = new TransportManager(this._context);
        this._exemptIncoming = new LHMCache<String, Object>(128);
    }

    @Override
    public synchronized void startup() {
        this._log.info("Starting up the Comm System...");
        this._manager.startListening();
        this.startTimestamper();
        this.startNetMonitor();
        this._wasStarted = true;
    }

    @Override
    public synchronized void shutdown() {
        this._manager.shutdown();
        this._geoIP.shutdown();
    }

    @Override
    public synchronized void restart() {
        if (!this._wasStarted) {
            this.startup();
        } else {
            this._wasStarted = false;
            this._manager.restart();
            this._wasStarted = true;
        }
    }

    @Override
    public synchronized boolean isRunning() {
        return this._wasStarted;
    }

    @Override
    public int countActivePeers() {
        return this._manager.countActivePeers();
    }

    @Override
    public int countActiveSendPeers() {
        return this._manager.countActiveSendPeers();
    }

    @Override
    public boolean haveInboundCapacity(int pct) {
        return this._manager.haveInboundCapacity(pct);
    }

    @Override
    public boolean haveOutboundCapacity(int pct) {
        return this._manager.haveOutboundCapacity(pct);
    }

    @Override
    public boolean haveHighOutboundCapacity() {
        return this._manager.haveHighOutboundCapacity();
    }

    @Override
    public long getFramedAveragePeerClockSkew(int percentToInclude) {
        List<Long> skews = this._manager.getClockSkews();
        if (skews == null || skews.isEmpty() || skews.size() < 5 && this._context.clock().getUpdatedSuccessfully()) {
            return this._context.clock().getOffset();
        }
        Collections.sort(skews);
        int frameSize = Math.max(skews.size() * percentToInclude / 100, 1);
        int first = skews.size() / 2 - frameSize / 2;
        int last = Math.min(skews.size() / 2 + frameSize / 2, skews.size() - 1);
        long sum = 0L;
        for (int i = first; i <= last; ++i) {
            long value = skews.get(i);
            sum += value;
        }
        return sum * 1000L / (long)frameSize;
    }

    @Override
    public void processMessage(OutNetMessage msg) {
        if (this.isDummy()) {
            GetBidsJob.fail(this._context, msg);
            return;
        }
        GetBidsJob.getBids(this._context, this._manager, msg);
    }

    @Override
    public boolean isBacklogged(Hash peer) {
        return this._manager.isBacklogged(peer);
    }

    @Override
    public boolean isEstablished(Hash peer) {
        return this._manager.isEstablished(peer);
    }

    @Override
    public List<Hash> getEstablished() {
        return this._manager.getEstablished();
    }

    @Override
    public boolean wasUnreachable(Hash peer) {
        return this._manager.wasUnreachable(peer);
    }

    @Override
    public byte[] getIP(Hash peer) {
        return this._manager.getIP(peer);
    }

    @Override
    public void mayDisconnect(Hash peer) {
        this._manager.mayDisconnect(peer);
    }

    @Override
    public void forceDisconnect(Hash peer) {
        this._manager.forceDisconnect(peer);
    }

    @Override
    public List<String> getMostRecentErrorMessages() {
        return this._manager.getMostRecentErrorMessages();
    }

    @Override
    public CommSystemFacade.Status getStatus() {
        if (!this._netMonitorStatus) {
            return CommSystemFacade.Status.DISCONNECTED;
        }
        CommSystemFacade.Status rv = this._manager.getReachabilityStatus();
        if (rv != CommSystemFacade.Status.HOSED && this._context.router().isHidden()) {
            return CommSystemFacade.Status.OK;
        }
        return rv;
    }

    @Override
    public String getLocalizedStatusString() {
        return Translate.getString(this.getStatus().toStatusString(), this._context, "net.i2p.router.util.messages");
    }

    @Override
    @Deprecated
    public void recheckReachability() {
        this._manager.recheckReachability();
    }

    @Override
    public void renderStatusHTML(Writer out, String urlBase, int sortFlags) throws IOException {
        this._manager.renderStatusHTML(out, urlBase, sortFlags);
    }

    @Override
    public SortedMap<String, Transport> getTransports() {
        return this._manager.getTransports();
    }

    @Override
    public List<RouterAddress> createAddresses() {
        ArrayList<RouterAddress> addresses = new ArrayList<RouterAddress>(this._manager.getAddresses());
        if (addresses.size() > 1) {
            Collections.sort(addresses, new AddrComparator());
        }
        return addresses;
    }

    @Override
    public void notifyReplaceAddress(RouterAddress udpAddr) {
        Transport udp;
        byte[] ip = null;
        int port = 0;
        if (udpAddr != null && udpAddr.getOption("itag0") == null) {
            ip = udpAddr.getIP();
            port = udpAddr.getPort();
        }
        if (port < 0 && (udp = this._manager.getTransport("SSU")) != null) {
            port = udp.getRequestedPort();
        }
        if (ip != null || port > 0) {
            this._manager.externalAddressReceived(Transport.AddressSource.SOURCE_SSU, ip, port);
        } else {
            this.notifyRemoveAddress(udpAddr);
        }
    }

    @Override
    public void notifyRemoveAddress(RouterAddress address) {
        this.notifyRemoveAddress(address != null && TransportUtil.isIPv6(address));
    }

    @Override
    public void notifyRemoveAddress(boolean ipv6) {
        this._manager.externalAddressRemoved(Transport.AddressSource.SOURCE_SSU, ipv6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void exemptIncoming(Hash peer) {
        if (this._manager.isEstablished(peer)) {
            return;
        }
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        if (ri == null) {
            return;
        }
        Collection<RouterAddress> addrs = ri.getAddresses();
        ArraySet<String> ips = new ArraySet<String>(addrs.size());
        for (RouterAddress addr : addrs) {
            String ip = addr.getHost();
            if (ip == null) continue;
            ips.add(Addresses.toCanonicalString(ip));
        }
        int sz = ips.size();
        if (sz > 0) {
            Map<String, Object> map = this._exemptIncoming;
            synchronized (map) {
                for (int i = 0; i < sz; ++i) {
                    this._exemptIncoming.put((String)ips.get(i), DUMMY);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isExemptIncoming(String ip) {
        Map<String, Object> map = this._exemptIncoming;
        synchronized (map) {
            return this._exemptIncoming.containsKey(ip);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeExemption(String ip) {
        Map<String, Object> map = this._exemptIncoming;
        synchronized (map) {
            this._exemptIncoming.remove(ip);
        }
    }

    @Override
    public void registerTransport(Transport t) {
        this._manager.registerAndStart(t);
    }

    @Override
    public void unregisterTransport(Transport t) {
        this._manager.stopAndUnregister(t);
    }

    @Override
    public X25519KeyFactory getXDHFactory() {
        return this._manager.getXDHFactory();
    }

    @Override
    public void initGeoIP() {
        this.startGeoIP();
    }

    public boolean enableReverseLookups() {
        return this._context.getBooleanProperty(PROP_ENABLE_REVERSE_LOOKUPS);
    }

    private void startGeoIP() {
        this._context.simpleTimer2().addEvent(new QueueAll(), START_DELAY);
        if (this.enableReverseLookups()) {
            CommSystemFacadeImpl.readRDNSCacheFromFile();
        }
    }

    @Override
    public void queueLookup(byte[] ip) {
        this._geoIP.add(ip);
    }

    private static Map<String, CacheEntry> getRDNSCache() {
        return rdnsCache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String rdnsCacheSize() {
        Object object = rdnslock;
        synchronized (object) {
            File cache = new File(RDNS_CACHE_FILE);
            long fileSize = cache.length() / 1024L;
            return String.valueOf(fileSize) + "KB";
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void readRDNSCacheFromFile() {
        Object object = rdnslock;
        synchronized (object) {
            File fCache = new File(RDNS_CACHE_FILE);
            try (BufferedReader reader = new BufferedReader(new FileReader(fCache));){
                String line;
                while ((line = reader.readLine()) != null) {
                    CacheEntry cacheEntry;
                    if (!line.matches("^([0-9a-fA-F]).*")) {
                        System.out.println("Line doesn't start with a digit or a-f (skipping line): " + line);
                        line = line.replaceFirst("^[^0-9a-fA-F]*", "");
                    }
                    if ((cacheEntry = CommSystemFacadeImpl.rdnsEntryFromString(line)) == null) continue;
                    rdnsCache.put(cacheEntry.getIpAddress(), cacheEntry);
                }
            }
            catch (IOException ex) {
                System.err.println("Error reading RDNS cache file. Creating new file...");
                CommSystemFacadeImpl.createRdnsCacheFile();
                ex.printStackTrace();
            }
            Timer timer = new Timer();
            long delay = 300030L;
            timer.schedule((TimerTask)new RDNSCacheFileWriter(new HashMap<String, CacheEntry>(rdnsCache)), delay, delay);
        }
    }

    private static String rdnsEntryToString(CacheEntry entry) {
        return entry.getIpAddress() + "," + entry.getHostname();
    }

    private static CacheEntry rdnsEntryFromString(String s) {
        String[] parts = s.split(",", 2);
        if (parts.length == 2) {
            String ipAddress = parts[0];
            String hostname = parts[1];
            return new CacheEntry(ipAddress, hostname);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void createRdnsCacheFile() {
        Object object = rdnslock;
        synchronized (object) {
            File cacheFile = new File(RDNS_CACHE_FILE);
            if (!cacheFile.exists()) {
                try {
                    cacheFile.createNewFile();
                }
                catch (IOException ex) {
                    System.err.println("Error creating cache file: " + ex.getMessage());
                }
            } else {
                CommSystemFacadeImpl.readRDNSCacheFromFile();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void writeRDNSCacheToFile() {
        Object object = rdnslock;
        synchronized (object) {
            try {
                File cacheFile = new File(RDNS_CACHE_FILE);
                if (!cacheFile.exists()) {
                    cacheFile.createNewFile();
                    System.err.println("Cache file created");
                }
                File tmpFile = new File(RDNS_CACHE_FILE + ".tmp");
                BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(tmpFile), ENCODING));
                Map<String, CacheEntry> cacheEntries = rdnsCache;
                for (Map.Entry<String, CacheEntry> entry : cacheEntries.entrySet()) {
                    String ipAddress = entry.getKey();
                    CacheEntry cacheEntry = entry.getValue();
                    String line = ipAddress + "," + cacheEntry.getHostname() + NEWLINE;
                    writer.write(line);
                    writer.flush();
                }
                writer.close();
                Files.copy(tmpFile.toPath(), cacheFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                tmpFile.delete();
            }
            catch (IOException ex) {
                System.err.println("Error updating reverse DNS cache file: " + ex.getMessage());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static synchronized void cleanupRDNSCache() {
        Object object = rdnslock;
        synchronized (object) {
            ArrayList keysToRemove = new ArrayList();
            Iterator<Map.Entry<String, CacheEntry>> it = rdnsCache.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, CacheEntry> entry = it.next();
                if (rdnsCache.size() <= MAX_RDNS_CACHE_SIZE) continue;
                it.remove();
            }
            rdnsCache.keySet().removeAll(keysToRemove);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String getCanonicalHostName(String ipAddress) {
        Object object = rdnslock;
        synchronized (object) {
            CommSystemFacadeImpl.cleanupRDNSCache();
            if (ipAddress == null || ipAddress.equals("null")) {
                return null;
            }
            CacheEntry cacheEntry = rdnsCache.get(ipAddress);
            if (cacheEntry != null) {
                return cacheEntry.getHostname();
            }
            try {
                String hostName = InetAddress.getByName(ipAddress).getCanonicalHostName();
                if (hostName.equals(ipAddress)) {
                    hostName = "unknown";
                }
                rdnsCache.put(ipAddress, new CacheEntry(ipAddress, hostName));
                return hostName;
            }
            catch (UnknownHostException exception) {
                rdnsCache.put(ipAddress, new CacheEntry(ipAddress, "unknown"));
                return ipAddress;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int countRdnsCacheEntries() {
        Object object = rdnslock;
        synchronized (object) {
            return rdnsCache.size();
        }
    }

    public static String getDomain(String hostname) {
        String[] domainArray = hostname.split("\\.");
        int length = domainArray.length;
        if (length > 3 && (hostname.endsWith(".uk") || hostname.endsWith(".au") || hostname.endsWith(".nz") || hostname.contains(".co.") || hostname.contains(".ne.") || hostname.contains(".com.") || hostname.contains(".net.") || hostname.contains(".org.") || hostname.contains(".gov."))) {
            return domainArray[length - 3] + "." + domainArray[length - 2] + "." + domainArray[length - 1];
        }
        if (length == 1) {
            return domainArray[0];
        }
        if (length > 2) {
            return domainArray[length - 2] + "." + domainArray[length - 1];
        }
        return "";
    }

    @Override
    public String getOurCountry() {
        return this._context.getProperty(PROP_IP_COUNTRY);
    }

    @Override
    public boolean isInStrictCountry() {
        String us = this.getOurCountry();
        return us != null && StrictCountries.contains(us) || this._context.getBooleanProperty("router.forceStrictCountry") || this._context.getBooleanProperty("router.blockMyCountry");
    }

    @Override
    public boolean isInStrictCountry(Hash peer) {
        String c = this.getCountry(peer);
        return c != null && StrictCountries.contains(c);
    }

    @Override
    public boolean isInStrictCountry(RouterInfo ri) {
        byte[] ip = CommSystemFacadeImpl.getIP(ri);
        Hash h = ri.getHash();
        if (ip == null) {
            ip = TransportImpl.getIP(h);
        }
        if (ip == null) {
            return false;
        }
        String c = this._geoIP.get(ip);
        return c != null && StrictCountries.contains(c);
    }

    @Override
    public String getCountry(Hash peer) {
        String myCountry;
        ConcurrentHashMap countryCache = new ConcurrentHashMap();
        String cachedCountry = (String)countryCache.get(peer);
        long now = System.currentTimeMillis();
        long uptime = this._context.router().getUptime();
        if (cachedCountry != null && !cachedCountry.equals("xx")) {
            return cachedCountry;
        }
        if (cachedCountry != null && cachedCountry.equals("xx") && now - this.lastUnknownPurge > 5000L) {
            countryCache.remove(peer);
            this.lastUnknownPurge = now;
        }
        RouterInfo ri = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation(peer);
        byte[] ip = TransportImpl.getIP(peer);
        if (ip == null && ri != null) {
            ip = CommSystemFacadeImpl.getIP(ri);
        }
        if (ip == null && ri != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Cannot identify country for Router [" + peer.toBase64().substring(0, 6) + "] -> IP address not found");
            }
            return "xx";
        }
        String country = this._geoIP.get(ip);
        if (ri != null && country == null || country == "xx") {
            if (this._log.shouldDebug()) {
                try {
                    InetAddress address = InetAddress.getByAddress(ip);
                    String hostAddress = address.getHostAddress();
                    this._log.debug("Country not found for IP address: " + hostAddress);
                }
                catch (UnknownHostException e) {
                    this._log.debug("Unknown host while attempting to resolve address: " + e.getMessage());
                }
            }
            return "xx";
        }
        if (country == null && ri == null) {
            return "xx";
        }
        if (countryCache.size() >= 20000) {
            Set keySet = Collections.synchronizedSet(new HashSet(countryCache.keySet()));
            Iterator iterator = keySet.iterator();
            while (iterator.hasNext()) {
                Hash eldestKey = (Hash)iterator.next();
                iterator.remove();
            }
        }
        this.lastLookupTime = now;
        boolean blockMyCountry = this._context.getBooleanProperty(PROP_BLOCK_MY_COUNTRY);
        boolean isStrict = this._context.commSystem().isInStrictCountry();
        boolean isHidden = this._context.router().isHidden();
        if ((isStrict || isHidden || blockMyCountry) && (myCountry = this._context.getProperty(PROP_IP_COUNTRY)) != null && myCountry == country) {
            GeoIP.banCountry(this._context, country);
        }
        return country;
    }

    private static byte[] getIP(RouterInfo ri) {
        if (ri == null) {
            return null;
        }
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv != null) {
                return rv;
            }
            rv = TransportImpl.getIP(ri.getHash());
            if (rv == null) continue;
            return rv;
        }
        return null;
    }

    public static byte[] getValidIP(RouterInfo ri) {
        if (ri == null) {
            return null;
        }
        for (RouterAddress ra : ri.getAddresses()) {
            byte[] rv = ra.getIP();
            if (rv == null || !TransportUtil.isPubliclyRoutable(rv, true)) continue;
            return rv;
        }
        return null;
    }

    @Override
    public String getCountryName(String c) {
        if (this._geoIP == null) {
            return c;
        }
        String n = this._geoIP.fullName(c);
        if (n == null) {
            return c;
        }
        return n;
    }

    @Override
    public Map<String, String> getCountries() {
        if (this._geoIP == null) {
            return Collections.emptyMap();
        }
        return this._geoIP.getCountries();
    }

    @Override
    public String renderPeerHTML(Hash peer, boolean extended) {
        StringBuilder buf = new StringBuilder(128);
        RouterInfo ri = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation(peer);
        String c = this.getCountry(peer);
        String h = peer.toBase64();
        if (ri != null) {
            String caps = ri.getCapabilities();
            String v = ri.getVersion();
            String ip = Addresses.toString(CommSystemFacadeImpl.getValidIP(ri));
            buf.append("<table class=rid><tr><td class=rif>");
            if (c != null) {
                String countryName = this.getCountryName(c);
                if (countryName.length() > 2) {
                    countryName = Translate.getString(countryName, this._context, COUNTRY_BUNDLE_NAME);
                }
                buf.append("<a href=\"/netdb?c=").append(c).append("\"><img width=20 height=15 alt=\"").append(c.toUpperCase(Locale.US)).append("\" title=\"").append(countryName);
                if (ip != null && !ip.equals("null")) {
                    if (this.enableReverseLookups() && !this.getCanonicalHostName(ip).equals("unknown")) {
                        buf.append(" &bullet; ").append(this.getCanonicalHostName(ip));
                    } else {
                        buf.append(" &bullet; ").append(ip);
                    }
                }
                buf.append("\" src=\"/flags.jsp?c=").append(c).append("\"></a>");
            } else {
                buf.append("<img width=20 height=15 alt=\"??\"").append(" src=\"/flags.jsp?c=a0\" title=\"").append(this._t("unknown"));
                if (ip != null) {
                    buf.append(" &bullet; ").append(ip);
                }
                buf.append("\">");
            }
            buf.append("</td><td class=rih>");
            buf.append("<a title=\"");
            if (caps.contains("f") && !extended) {
                buf.append(this._t("Floodfill"));
            }
            if (v != null && !extended) {
                buf.append(" &bullet; ");
            }
            buf.append(v).append("\" href=\"netdb?r=").append(h.substring(0, 10)).append("\">");
            buf.append(h.substring(0, 4));
            buf.append("</a>");
            if (extended) {
                buf.append("</td>").append(this.renderPeerCaps(peer, true));
            }
        } else {
            buf.append("<table class=rid><tr><td class=rif>").append(this.renderPeerFlag(peer)).append("</td><td class=rih>").append(h.substring(0, 4));
            if (extended) {
                buf.append("</td><td class=rbw>?</td>");
            }
        }
        buf.append("</tr></table>");
        return buf.toString();
    }

    @Override
    public String renderPeerCaps(Hash peer, boolean inline) {
        StringBuilder buf = new StringBuilder(128);
        RouterInfo ri = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation(peer);
        String c = this.getCountry(peer);
        String h = peer.toBase64();
        if (!inline) {
            buf.append("<table class=\"rid ric\"><tr>");
        }
        if (ri != null) {
            String caps = ri.getCapabilities();
            String v = ri.getVersion();
            String ip = Addresses.toString(CommSystemFacadeImpl.getValidIP(ri));
            String capacity = String.valueOf(this.getCapacity(peer));
            boolean hasD = caps.contains("D");
            boolean hasE = caps.contains("E");
            boolean hasG = caps.contains("G");
            boolean isFF = caps.contains("f");
            boolean isU = caps.contains("U");
            boolean isR = caps.contains("R");
            buf.append("<td class=\"rbw ").append(this.getCapacity(peer));
            if (isFF) {
                buf.append(" isff");
            }
            if (isU) {
                buf.append(" isU");
            }
            if (hasD) {
                buf.append(" isD");
            } else if (hasE) {
                buf.append(" isE");
            } else if (hasG) {
                buf.append(" isG");
            }
            buf.append("\"><a href=\"/netdb?caps=");
            buf.append(this.getCapacity(peer));
            if (isFF) {
                buf.append("f");
            }
            if (isU) {
                buf.append("U");
            } else if (isR) {
                buf.append("R");
            }
            if (hasD) {
                buf.append("D");
            } else if (hasE) {
                buf.append("E");
            } else if (hasG) {
                buf.append("G");
            }
            buf.append("\" title=\"").append(this._t("Show all routers with this capability in the NetDb")).append("\">").append(capacity.replace("D", "").replace("E", "").replace("G", "")).append("</a>");
        } else {
            buf.append("<td class=rbw>?");
        }
        buf.append("</td>");
        if (!inline) {
            buf.append("</tr></table>\n");
        }
        return buf.toString();
    }

    private char getCapacity(Hash peer) {
        RouterInfo info = (RouterInfo)this._context.netDb().lookupLocallyWithoutValidation(peer);
        if (info != null) {
            String caps = info.getCapabilities();
            for (int i = 0; i < "XPONMLK".length(); ++i) {
                char c = "XPONMLK".charAt(i);
                if (caps.indexOf(c) < 0) continue;
                return c;
            }
        }
        return '?';
    }

    @Override
    public String renderPeerFlag(Hash peer) {
        StringBuilder buf = new StringBuilder(128);
        RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
        String c = this.getCountry(peer);
        String countryName = this.getCountryName(c);
        String h = peer.toBase64();
        if (c != null) {
            if (countryName.length() > 2) {
                countryName = Translate.getString(countryName, this._context, COUNTRY_BUNDLE_NAME);
            }
        } else {
            c = "xx";
        }
        buf.append("<span class=cc hidden>").append(c.toUpperCase(Locale.US)).append("</span>");
        buf.append("<span class=peerFlag title=\"");
        if (ri != null) {
            byte[] transportIP;
            String ip = Addresses.toString(CommSystemFacadeImpl.getValidIP(ri));
            if ((ip == null || ip.equals("null") || ip.equals("")) && (transportIP = CommSystemFacadeImpl.getIP(ri)) != null) {
                ip = Addresses.toString(transportIP);
            }
            if (!c.equals("xx") && c != null && countryName.length() > 2) {
                buf.append(countryName);
                if (ip != null && !ip.equals("null") && !ip.equals("") && ip.length() > 6) {
                    buf.append(" &bullet; ");
                    if (this.enableReverseLookups() && !this.getCanonicalHostName(ip).equals("unknown")) {
                        buf.append(this.getCanonicalHostName(ip)).append(" (").append(ip).append(")");
                    } else {
                        buf.append(ip);
                    }
                }
            } else {
                buf.append(this._t("unknown"));
            }
            buf.append("\">");
            if (!c.equals("xx") && c != null) {
                buf.append("<a href=\"/netdb?c=").append(c).append("\"><img width=24 height=18 alt=\"").append(c.toUpperCase(Locale.US)).append("\" src=\"/flags.jsp?c=").append(c).append("\"></a>");
            } else {
                buf.append("<img class=unknownflag width=24 height=18 alt=\"??\"").append(" src=\"/flags.jsp?c=xx\">");
            }
        } else {
            buf.append(this._t("unknown")).append("\"><img class=unknownflag width=24 height=18 alt=\"??\"").append(" src=\"/flags.jsp?c=xx\">");
        }
        buf.append("</span>");
        return buf.toString();
    }

    @Override
    public boolean isDummy() {
        return this._context.getBooleanProperty(PROP_DISABLED);
    }

    private final String _t(String s) {
        return Translate.getString(s, this._context, BUNDLE_NAME);
    }

    private void startTimestamper() {
        this._context.simpleTimer2().addPeriodicEvent(new Timestamper(), 300000L, 480000L);
    }

    private void startNetMonitor() {
        new NetMonitor();
    }

    private class NetMonitor
    extends SimpleTimer2.TimedEvent {
        private static final long SHORT_DELAY = 15000L;
        private static final long LONG_DELAY = 90000L;

        public NetMonitor() {
            super(CommSystemFacadeImpl.this._context.simpleTimer2(), 0L);
        }

        @Override
        public void timeReached() {
            boolean good;
            Set<AddressType> addrs = Addresses.getConnectedAddressTypes();
            boolean bl = good = addrs.contains((Object)AddressType.IPV4) || addrs.contains((Object)AddressType.IPV6);
            if (CommSystemFacadeImpl.this._netMonitorStatus != good) {
                if (good) {
                    CommSystemFacadeImpl.this._log.logAlways(20, "Network reconnected");
                } else {
                    CommSystemFacadeImpl.this._log.error("Network disconnected");
                }
                CommSystemFacadeImpl.this._context.router().eventLog().addEvent("network", good ? "connected" : "disconnected");
                CommSystemFacadeImpl.this._netMonitorStatus = good;
                if (good) {
                    CommSystemFacadeImpl.this._manager.initializeAddress();
                    CommSystemFacadeImpl.this._manager.transportAddressChanged();
                }
            }
            this.reschedule(good ? 90000L : 15000L);
        }
    }

    private class Timestamper
    implements SimpleTimer.TimedEvent {
        private Timestamper() {
        }

        @Override
        public void timeReached() {
            long peerOffset = CommSystemFacadeImpl.this.getFramedAveragePeerClockSkew(10);
            if (peerOffset == 0L) {
                return;
            }
            long currentOffset = CommSystemFacadeImpl.this._context.clock().getOffset();
            long newOffset = currentOffset - peerOffset;
            CommSystemFacadeImpl.this._context.clock().setOffset(newOffset);
        }
    }

    private static class RDNSCacheFileWriter
    extends TimerTask {
        private final Map<String, CacheEntry> cacheToWrite;

        public RDNSCacheFileWriter(Map<String, CacheEntry> cacheToWrite) {
            this.cacheToWrite = cacheToWrite;
        }

        @Override
        public void run() {
            File cacheFile = new File(RDNS_CACHE_FILE);
            int cacheEntries = CommSystemFacadeImpl.countRdnsCacheEntries();
            try (FileOutputStream fos = new FileOutputStream(cacheFile);){
                for (Map.Entry<String, CacheEntry> entry : this.cacheToWrite.entrySet()) {
                    String line = entry.getKey() + "," + entry.getValue().getHostname() + CommSystemFacadeImpl.NEWLINE;
                    fos.write(line.getBytes());
                }
            }
            catch (IOException ex) {
                System.err.println("Error updating reverse DNS cache file: " + ex.getMessage());
            }
        }
    }

    public static class CacheEntry {
        private String ipAddress;
        private String hostname;

        public CacheEntry(String ipAddress, String hostname) {
            this.ipAddress = ipAddress;
            this.hostname = hostname != null ? hostname : "unknown";
        }

        public String getIpAddress() {
            return this.ipAddress;
        }

        public String getHostname() {
            return this.hostname;
        }

        public String getRdnsEntry() {
            return CommSystemFacadeImpl.rdnsEntryToString(this);
        }
    }

    private class LookupThread
    extends I2PThread {
        public LookupThread() {
            super("GeoIP Lookup");
            this.setDaemon(true);
        }

        @Override
        public void run() {
            long start = System.currentTimeMillis();
            CommSystemFacadeImpl.this._geoIP.blockingLookup();
            if (CommSystemFacadeImpl.this._log.shouldInfo()) {
                CommSystemFacadeImpl.this._log.info("GeoIP lookup for all routers in the NetDB took " + (System.currentTimeMillis() - start) + "ms");
            }
        }
    }

    private class Lookup
    implements SimpleTimer.TimedEvent {
        private Lookup() {
        }

        @Override
        public void timeReached() {
            new LookupThread().start();
        }
    }

    private class QueueAll
    implements SimpleTimer.TimedEvent {
        private QueueAll() {
        }

        @Override
        public void timeReached() {
            long uptime = CommSystemFacadeImpl.this._context.router().getUptime();
            for (Hash h : CommSystemFacadeImpl.this._context.netDb().getAllRouters()) {
                RouterInfo ri = (RouterInfo)CommSystemFacadeImpl.this._context.netDb().lookupLocallyWithoutValidation(h);
                if (ri == null) continue;
                byte[] ip = CommSystemFacadeImpl.getIP(ri);
                if (ip == null) {
                    ip = TransportImpl.getIP(h);
                }
                if (ip == null) continue;
                CommSystemFacadeImpl.this._geoIP.add(ip);
            }
            CommSystemFacadeImpl.this._context.simpleTimer2().addPeriodicEvent(new Lookup(), 5000L, 75000L);
        }
    }

    private static class AddrComparator
    implements Comparator<RouterAddress>,
    Serializable {
        private AddrComparator() {
        }

        @Override
        public int compare(RouterAddress l, RouterAddress r) {
            int rh;
            int rv = l.getCost() - r.getCost();
            if (rv != 0) {
                return rv;
            }
            int lh = l.hashCode();
            if (lh > (rh = l.hashCode())) {
                return 1;
            }
            if (lh < rh) {
                return -1;
            }
            return 0;
        }
    }
}

