/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.ntcp;

import java.io.IOException;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.CancelledKeyException;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.NoConnectionPendingException;
import java.nio.channels.NotYetConnectedException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.nio.channels.UnresolvedAddressException;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.i2p.I2PAppContext;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.ntcp.NTCPConnection;
import net.i2p.router.transport.ntcp.NTCPTransport;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Addresses;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SystemVersion;
import net.i2p.util.TryCache;

class EventPumper
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private volatile boolean _alive;
    private Selector _selector;
    private final Set<NTCPConnection> _wantsWrite = new ConcurrentHashSet<NTCPConnection>(64);
    private final Queue<NTCPConnection> _wantsRead = new ConcurrentLinkedQueue<NTCPConnection>();
    private final Queue<ServerSocketChannel> _wantsRegister = new ConcurrentLinkedQueue<ServerSocketChannel>();
    private final Queue<NTCPConnection> _wantsConRegister = new ConcurrentLinkedQueue<NTCPConnection>();
    private final NTCPTransport _transport;
    private final ObjectCounter<String> _blockedIPs;
    private long _expireIdleWriteTime;
    private static final boolean _useDirect = false;
    private final boolean _nodelay;
    private static final int BUF_SIZE = SystemVersion.isSlow() ? 8192 : 32768;
    private static final int FAILSAFE_ITERATION_FREQ = 30000;
    private static final int FAILSAFE_LOOP_COUNT = SystemVersion.isSlow() ? 512 : 1024;
    private static final long SELECTOR_LOOP_DELAY = SystemVersion.isSlow() ? 300L : 150L;
    private static final long BLOCKED_IP_FREQ = 0x6DDD00L;
    private static final long MIN_EXPIRE_IDLE_TIME = 120000L;
    private static final long MAX_EXPIRE_IDLE_TIME = 660000L;
    private static final long MAY_DISCON_TIMEOUT = 10000L;
    private static final long RI_STORE_INTERVAL = 1740000L;
    private static final String PROP_NODELAY = "i2np.ntcp.nodelay";
    private static final int MIN_MINB = SystemVersion.isSlow() ? 8 : 16;
    private static final int MAX_MINB = SystemVersion.isSlow() ? 24 : 128;
    public static final String PROP_MAX_MINB = "i2np.ntcp.eventPumperMaxBuffers";
    private static final int MIN_BUFS;
    private static final float DEFAULT_THROTTLE_FACTOR;
    private static final String PROP_THROTTLE_FACTOR = "router.throttleFactor";
    private static final TryCache<ByteBuffer> _bufferCache;
    private static final Set<CommSystemFacade.Status> STATUS_OK;
    private long _lastExpired;

    public EventPumper(RouterContext ctx, NTCPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._transport = transport;
        this._expireIdleWriteTime = 660000L;
        this._blockedIPs = new ObjectCounter();
        this._context.statManager().createRateStat("ntcp.pumperKeySetSize", "Number of NTCP Pumper KeySetSize events", "Transport [NTCP]", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.pumperLoopsPerSecond", "Number of NTCP Pumper loops/s", "Transport [NTCP]", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.zeroRead", "Number of NTCP zero length read events", "Transport [NTCP]", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.zeroReadDrop", "Number of NTCP zero length read events dropped", "Transport [NTCP]", new long[]{60000L, 600000L});
        this._context.statManager().createRateStat("ntcp.dropInboundNoMessage", "Number of NTCP Inbound empty message drop events", "Transport [NTCP]", new long[]{60000L, 600000L});
        this._context.statManager().createRequiredRateStat("ntcp.inboundConn", "Inbound NTCP Connection", "Transport [NTCP]", new long[]{60000L});
        this._nodelay = ctx.getBooleanPropertyDefaultTrue(PROP_NODELAY);
    }

    public synchronized void startPumping() {
        if (this._log.shouldInfo()) {
            this._log.info("Starting NTCP Pumper...");
        }
        try {
            this._selector = Selector.open();
            this._alive = true;
            I2PThread t = new I2PThread(this, "NTCP Pumper", true);
            t.setPriority(10);
            t.start();
        }
        catch (IOException ioe) {
            this._log.log(50, "Error opening the NTCP selector", ioe);
        }
        catch (InternalError jlie) {
            this._log.log(50, "Error opening the NTCP selector", jlie);
        }
    }

    public synchronized void stopPumping() {
        this._alive = false;
        if (this._selector != null && this._selector.isOpen()) {
            this._selector.wakeup();
        }
    }

    public boolean isAlive() {
        return this._alive || this._selector != null && this._selector.isOpen();
    }

    public void register(ServerSocketChannel chan) {
        if (this._log.shouldDebug()) {
            this._log.debug("Registering ServerSocketChannel...");
        }
        this._wantsRegister.offer(chan);
        this._selector.wakeup();
    }

    public void registerConnect(NTCPConnection con) {
        if (this._log.shouldDebug()) {
            this._log.debug("Registering " + con + "...");
        }
        this._context.statManager().addRateData("ntcp.registerConnect", 1L);
        this._wantsConRegister.offer(con);
        this._selector.wakeup();
    }

    private float getThrottleFactor() {
        return this._context.getProperty(PROP_THROTTLE_FACTOR, DEFAULT_THROTTLE_FACTOR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        long lastFailsafeIteration;
        int loopCount = 0;
        int failsafeLoopCount = FAILSAFE_LOOP_COUNT;
        long lastBlockedIPClear = lastFailsafeIteration = System.currentTimeMillis();
        while (this._alive && this._selector.isOpen()) {
            try {
                long now;
                block43: {
                    int pause;
                    ++loopCount;
                    try {
                        int count = this._selector.select(SELECTOR_LOOP_DELAY);
                        if (count > 0) {
                            Set<SelectionKey> selected = this._selector.selectedKeys();
                            this.processKeys(selected);
                            selected.clear();
                        }
                        this.runDelayedEvents();
                    }
                    catch (ClosedSelectorException cse) {
                        continue;
                    }
                    catch (IOException ioe) {
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Error selecting", ioe);
                        continue;
                    }
                    catch (CancelledKeyException cke) {
                        if (!this._log.shouldWarn()) continue;
                        this._log.warn("Error selecting", cke);
                        continue;
                    }
                    now = System.currentTimeMillis();
                    int known = this._context.netDb().getKnownRouters();
                    int loopFreq = 30000;
                    loopFreq = known > 2000 ? 60000 : (known < 1000 ? 7500 : 15000);
                    if (lastFailsafeIteration + (long)loopFreq < now) {
                        lastFailsafeIteration = now;
                        try {
                            Set<SelectionKey> all = this._selector.keys();
                            int lastKeySetSize = all.size();
                            this._context.statManager().addRateData("ntcp.pumperKeySetSize", lastKeySetSize);
                            this._context.statManager().addRateData("ntcp.pumperLoopsPerSecond", loopCount / (loopFreq / 1000));
                            loopCount = 0;
                            failsafeLoopCount = Math.max(FAILSAFE_LOOP_COUNT, 2 * lastKeySetSize);
                            int failsafeWrites = 0;
                            int failsafeCloses = 0;
                            int failsafeInvalid = 0;
                            boolean haveCap = this._transport.haveCapacity(33);
                            this._expireIdleWriteTime = haveCap ? Math.min(this._expireIdleWriteTime + 1000L, 660000L) : Math.max(this._expireIdleWriteTime - 3000L, 120000L);
                            for (SelectionKey key : all) {
                                try {
                                    long mod;
                                    long uptime;
                                    long expire;
                                    Object att = key.attachment();
                                    if (!(att instanceof NTCPConnection)) continue;
                                    NTCPConnection con = (NTCPConnection)att;
                                    if (!key.isValid() && !((SocketChannel)key.channel()).isConnectionPending() && con.getTimeSinceCreated(now) > 20000L) {
                                        if (this._log.shouldInfo()) {
                                            this._log.info("Removing invalid key for: " + con);
                                        }
                                        con.close();
                                        key.cancel();
                                        ++failsafeInvalid;
                                        continue;
                                    }
                                    Object object = con.getWriteLock();
                                    synchronized (object) {
                                        if (!con.isWriteBufEmpty() && (key.interestOps() & 4) == 0) {
                                            if (this._log.shouldInfo()) {
                                                this._log.info("Failsafe write for " + con);
                                            }
                                            EventPumper.setInterest(key, 4);
                                            ++failsafeWrites;
                                        }
                                    }
                                    if (!(haveCap && con.isInbound() || !con.getMayDisconnect() || con.getMessagesReceived() > 2 || con.getMessagesSent() > 1)) {
                                        expire = 10000L;
                                        if (this._log.shouldInfo()) {
                                            this._log.info("Possible early disconnect for: " + con);
                                        }
                                    } else {
                                        expire = this._expireIdleWriteTime;
                                    }
                                    if (con.getTimeSinceSend(now) > expire && con.getTimeSinceReceive(now) > expire) {
                                        con.sendTerminationAndClose();
                                        if (this._log.shouldInfo()) {
                                            this._log.info("Failsafe or expire close for: " + con);
                                        }
                                        ++failsafeCloses;
                                        continue;
                                    }
                                    long estab = con.getEstablishedOn();
                                    if (estab <= 0L || (uptime = now - estab) < 1740000L || (mod = uptime % 1740000L) >= 30000L) continue;
                                    con.sendOurRouterInfo(false);
                                }
                                catch (CancelledKeyException cancelledKeyException) {}
                            }
                            if (failsafeWrites > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeWrites", failsafeWrites);
                            }
                            if (failsafeCloses > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeCloses", failsafeCloses);
                            }
                            if (failsafeInvalid > 0) {
                                this._context.statManager().addRateData("ntcp.failsafeInvalid", failsafeInvalid);
                            }
                            break block43;
                        }
                        catch (ClosedSelectorException cse) {
                            continue;
                        }
                    }
                    int cpuLoadAvg = SystemVersion.getCPULoadAvg();
                    int n = pause = SystemVersion.isSlow() || cpuLoadAvg > 95 ? 30 : 10;
                    if (loopCount % failsafeLoopCount == failsafeLoopCount - 1) {
                        if (this._log.shouldInfo()) {
                            this._log.info("EventPumper throttle " + loopCount + " loops in " + (now - lastFailsafeIteration) + " ms");
                        }
                        this._context.statManager().addRateData("ntcp.failsafeThrottle", 1L);
                        try {
                            Thread.sleep(pause);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
                if (lastBlockedIPClear + 0x6DDD00L >= now) continue;
                this._blockedIPs.clear();
                lastBlockedIPClear = now;
            }
            catch (RuntimeException re) {
                this._log.error("Error in EventPumper", re);
            }
        }
        try {
            if (this._selector.isOpen()) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Closing down EventPumper with selection keys remaining");
                }
                Set<SelectionKey> keys = this._selector.keys();
                for (SelectionKey key : keys) {
                    try {
                        Object att = key.attachment();
                        if (att instanceof ServerSocketChannel) {
                            ServerSocketChannel chan = (ServerSocketChannel)att;
                            chan.close();
                            key.cancel();
                            continue;
                        }
                        if (!(att instanceof NTCPConnection)) continue;
                        NTCPConnection con = (NTCPConnection)att;
                        con.close();
                        key.cancel();
                    }
                    catch (IOException ke) {
                        this._log.error("Error closing key " + key + " on EventPumper shutdown", ke);
                    }
                }
                this._selector.close();
            } else if (this._log.shouldDebug()) {
                this._log.debug("Closing down EventPumper with no selection keys remaining...");
            }
        }
        catch (IOException e) {
            this._log.error("Error closing keys on EventPumper shutdown", e);
        }
        this._wantsConRegister.clear();
        this._wantsRead.clear();
        this._wantsRegister.clear();
        this._wantsWrite.clear();
    }

    private void processKeys(Set<SelectionKey> selected) {
        for (SelectionKey key : selected) {
            try {
                boolean write;
                int ops = key.readyOps();
                boolean accept = (ops & 0x10) != 0;
                boolean connect = (ops & 8) != 0;
                boolean read = (ops & 1) != 0;
                boolean bl = write = (ops & 4) != 0;
                if (accept) {
                    this._context.statManager().addRateData("ntcp.accept", 1L);
                    this.processAccept(key);
                }
                if (connect) {
                    EventPumper.clearInterest(key, 8);
                    this.processConnect(key);
                }
                if (read) {
                    this.processRead(key);
                }
                if (!write) continue;
                this.processWrite(key);
            }
            catch (CancelledKeyException cke) {
                if (!this._log.shouldDebug()) continue;
                this._log.debug("Key cancelled");
            }
        }
    }

    public void wantsWrite(NTCPConnection con) {
        if (this._wantsWrite.add(con)) {
            this._selector.wakeup();
        }
    }

    public void wantsRead(NTCPConnection con) {
        this._wantsRead.offer(con);
        this._selector.wakeup();
    }

    private ByteBuffer acquireBuf() {
        return _bufferCache.acquire();
    }

    public static void releaseBuf(ByteBuffer buf) {
        if (buf.capacity() < BUF_SIZE) {
            I2PAppContext.getGlobalContext().logManager().getLog(EventPumper.class).error("Bad size " + buf.capacity(), new Exception());
            return;
        }
        buf.clear();
        _bufferCache.release(buf);
    }

    private void processAccept(SelectionKey key) {
        ServerSocketChannel servChan = (ServerSocketChannel)key.attachment();
        try {
            SocketChannel chan = servChan.accept();
            if (chan == null) {
                return;
            }
            chan.configureBlocking(false);
            byte[] ip = chan.socket().getInetAddress().getAddress();
            String ba = Addresses.toString(ip).replace("/", "");
            if (this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Refusing Session Request from blocklisted IP address " + ba);
                }
                try {
                    chan.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                return;
            }
            if (!this._context.commSystem().isExemptIncoming(Addresses.toCanonicalString(ba))) {
                if (!this._transport.allowConnection()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Refusing Session Request from " + ba + " -> NTCP connection limit reached");
                    }
                    try {
                        chan.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                int count = this._blockedIPs.count(ba);
                if (count > 0) {
                    count = this._blockedIPs.increment(ba);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Blocking NTCP connection attempt from: " + ba + " (Count: " + count + ")");
                    }
                    this._context.statManager().addRateData("ntcp.dropInboundNoMessage", count);
                    if (count >= 30 && this._log.shouldWarn()) {
                        this._log.warn("WARNING! IP Address " + ba + " is making excessive inbound NTCP connection attempts (Count: " + count + ")");
                    }
                    try {
                        chan.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
                if (!this.shouldAllowInboundEstablishment()) {
                    try {
                        chan.close();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return;
                }
            }
            this._context.statManager().addRateData("ntcp.inboundConn", 1L);
            if (this.shouldSetKeepAlive(chan)) {
                chan.socket().setKeepAlive(true);
            }
            if (this._nodelay) {
                chan.socket().setTcpNoDelay(true);
            }
            SelectionKey ckey = chan.register(this._selector, 1);
            NTCPConnection con = new NTCPConnection(this._context, this._transport, chan, ckey);
            ckey.attach(con);
            this._transport.establishing(con);
        }
        catch (IOException ioe) {
            if (ioe.toString().contains("reset by peer")) {
                this._log.warn("Error accepting NTCP connection: " + ioe.getMessage());
            }
            this._log.error("Error accepting NTCP connection", ioe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldAllowInboundEstablishment() {
        int total;
        int current;
        long periodStart;
        int last;
        RateStat rs = this._context.statManager().getRate("ntcp.inboundConn");
        if (rs == null) {
            return true;
        }
        Rate r = rs.getRate(60000L);
        if (r == null) {
            return true;
        }
        RateAverages ra = RateAverages.getTemp();
        Rate rate = r;
        synchronized (rate) {
            last = (int)r.getLastEventCount();
            periodStart = r.getLastCoalesceDate();
            r.computeAverages(ra, true);
        }
        if (last < 15) {
            last = 15;
        }
        if ((current = (total = (int)ra.getTotalEventCount()) - last) <= 0) {
            return true;
        }
        int lastPeriod = 60000;
        double avg = ra.getAverage();
        int currentTime = (int)(this._context.clock().now() - periodStart);
        if (currentTime <= 5000) {
            return true;
        }
        float lastRate = (float)last / (float)lastPeriod;
        float currentRate = (float)((double)current / (double)currentTime);
        float factor = this._transport.haveCapacity(95) ? this.getThrottleFactor() : 0.95f;
        float minThresh = factor * lastRate;
        int maxConnections = this._transport.getMaxConnections();
        int currentConnections = this._transport.countPeers();
        if (currentRate > minThresh * 5.0f / 3.0f && currentConnections > maxConnections * 2 / 3) {
            int percent;
            int probAccept = Math.max(1, (int)(512.0f * currentRate / minThresh) - 512);
            int n = percent = probAccept > 128 ? 100 : probAccept / 128 * 100;
            if (probAccept >= 128 || this._context.random().nextInt(128) < probAccept) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping incoming TCP connection (" + (percent >= 1 ? Integer.valueOf(percent) : "1") + "% chance) -> Previous/current connections per minute: " + last + " / " + (int)(currentRate * 60.0f * 1000.0f));
                }
                return false;
            }
        }
        return true;
    }

    private void processConnect(SelectionKey key) {
        block9: {
            NTCPConnection con = (NTCPConnection)key.attachment();
            SocketChannel chan = con.getChannel();
            try {
                boolean connected = chan.finishConnect();
                if (this._log.shouldDebug()) {
                    this._log.debug("Processing connect for " + con + ": connected? " + connected);
                }
                if (connected) {
                    if (this.shouldSetKeepAlive(chan)) {
                        chan.socket().setKeepAlive(true);
                    }
                    if (this._nodelay) {
                        chan.socket().setTcpNoDelay(true);
                    }
                    con.setKey(key);
                    con.outboundConnected();
                    this._context.statManager().addRateData("ntcp.connectSuccessful", 1L);
                } else {
                    con.closeOnTimeout("Connect failed (10s timeout exceeded) -> Marking unreachable", null);
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    this._context.statManager().addRateData("ntcp.connectFailedTimeout", 1L);
                }
            }
            catch (IOException ioe) {
                if (this._log.shouldInfo()) {
                    this._log.info("Failed outbound " + con + " (" + ioe.getMessage() + ")");
                }
                con.closeOnTimeout("Connect failed (10s timeout exceeded or connection refused) -> Marking unreachable", ioe);
                this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                this._context.statManager().addRateData("ntcp.connectFailedTimeoutIOE", 1L);
            }
            catch (NoConnectionPendingException ncpe) {
                if (!this._log.shouldWarn()) break block9;
                this._log.warn("Error connecting on " + con, ncpe);
            }
        }
    }

    private boolean shouldSetKeepAlive(SocketChannel chan) {
        if (chan.socket().getInetAddress() instanceof Inet6Address) {
            return false;
        }
        CommSystemFacade.Status status = this._context.commSystem().getStatus();
        return !STATUS_OK.contains((Object)status);
    }

    private void processRead(SelectionKey key) {
        block39: {
            NTCPConnection con = (NTCPConnection)key.attachment();
            SocketChannel chan = con.getChannel();
            ByteBuffer buf = null;
            try {
                boolean keepReading;
                do {
                    int readThisTime;
                    buf = this.acquireBuf();
                    int read = 0;
                    int readCount = 0;
                    while ((readThisTime = chan.read(buf)) > 0) {
                        read += readThisTime;
                        ++readCount;
                    }
                    if (readThisTime < 0 && read == 0) {
                        read = readThisTime;
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("Read " + read + " bytes total in " + readCount + " times from " + con);
                    }
                    if (read < 0) {
                        if (con.isInbound() && con.getMessagesReceived() <= 0) {
                            int count;
                            InetAddress addr = chan.socket().getInetAddress();
                            if (addr != null) {
                                byte[] ip = addr.getAddress();
                                String ba = Addresses.toString(ip).replace("/", "");
                                count = this._blockedIPs.increment(ba);
                                if (this._log.shouldWarn()) {
                                    this._log.warn("EOF on Inbound connection before receiving any data \n* Blocking IP address: " + ba + (count > 1 ? " (Count: " + count + ")" : ""));
                                }
                            } else {
                                count = 1;
                                if (this._log.shouldWarn()) {
                                    this._log.warn("EOF on Inbound connection before receiving any data: " + con);
                                }
                            }
                            this._context.statManager().addRateData("ntcp.dropInboundNoMessage", count);
                        } else if (this._log.shouldDebug()) {
                            this._log.debug("EOF on " + con);
                        }
                        con.close();
                        EventPumper.releaseBuf(buf);
                    } else if (read == 0) {
                        EventPumper.releaseBuf(buf);
                        int consec = con.gotZeroRead();
                        if (consec >= 5) {
                            this._context.statManager().addRateData("ntcp.zeroReadDrop", 1L);
                            if (this._log.shouldWarn()) {
                                this._log.warn("Fail safe zero read close " + con);
                            }
                            con.close();
                        } else {
                            this._context.statManager().addRateData("ntcp.zeroRead", consec);
                            if (this._log.shouldInfo()) {
                                this._log.info("Nothing to read for " + con + ", but remaining interested");
                            }
                        }
                    } else {
                        con.clearZeroRead();
                        keepReading = !buf.hasRemaining();
                        ((Buffer)buf).flip();
                        FIFOBandwidthLimiter.Request req = this._context.bandwidthLimiter().requestInbound(read, "NTCP read");
                        if (req.getPendingRequested() > 0) {
                            EventPumper.clearInterest(key, 1);
                            this._context.statManager().addRateData("ntcp.queuedRecv", read);
                            con.queuedRecv(buf, req);
                        } else {
                            con.recv(buf);
                            this._context.statManager().addRateData("ntcp.read", read);
                            if (readThisTime >= 0) continue;
                            con.close();
                        }
                    }
                    break;
                } while (keepReading);
            }
            catch (CancelledKeyException cke) {
                if (buf != null) {
                    EventPumper.releaseBuf(buf);
                }
                if (this._log.shouldWarn()) {
                    this._log.warn("Error reading on " + con + "\n* " + cke.getMessage());
                }
                con.close();
                this._context.statManager().addRateData("ntcp.readError", 1L);
            }
            catch (IOException ioe) {
                if (buf != null) {
                    EventPumper.releaseBuf(buf);
                }
                if (con.isInbound() && con.getMessagesReceived() <= 0) {
                    int count;
                    byte[] ip = con.getRemoteIP();
                    if (ip != null) {
                        String ba = Addresses.toString(ip).replace("/", "");
                        count = this._blockedIPs.increment(ba);
                        if (this._log.shouldWarn()) {
                            this._log.warn("Blocking IP address " + ba + (count > 1 ? " (Count: " + count + ")" : "") + "\n* IO Error: " + ioe.getMessage());
                        }
                    } else {
                        count = 1;
                        if (this._log.shouldWarn()) {
                            this._log.warn("IO Error on Inbound connection before receiving any data: " + con);
                        }
                    }
                    this._context.statManager().addRateData("ntcp.dropInboundNoMessage", count);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Error reading: " + con + " (" + ioe.getMessage() + ")");
                }
                if (con.isEstablished()) {
                    this._context.statManager().addRateData("ntcp.readError", 1L);
                } else {
                    this._context.statManager().addRateData("ntcp.connectFailedTimeoutIOE", 1L);
                    RouterIdentity rem = con.getRemotePeer();
                    if (rem != null && !con.isInbound()) {
                        this._transport.markUnreachable(rem.calculateHash());
                    }
                }
                con.close();
            }
            catch (NotYetConnectedException nyce) {
                if (buf != null) {
                    EventPumper.releaseBuf(buf);
                }
                EventPumper.clearInterest(key, 1);
                if (!this._log.shouldWarn()) break block39;
                this._log.warn("Error reading: " + con, nyce);
            }
        }
    }

    private void processWrite(SelectionKey key) {
        NTCPConnection con = (NTCPConnection)key.attachment();
        this.processWrite(con, key);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processWrite(NTCPConnection con, SelectionKey key) {
        boolean rv = false;
        SocketChannel chan = con.getChannel();
        try {
            Object object = con.getWriteLock();
            synchronized (object) {
                block17: {
                    ByteBuffer buf;
                    while ((buf = con.getNextWriteBuf()) != null) {
                        if (buf.remaining() <= 0) {
                            con.removeWriteBuf(buf);
                            continue;
                        }
                        int written = chan.write(buf);
                        if (written == 0) {
                            if (buf.remaining() <= 0 && con.isWriteBufEmpty()) {
                                rv = true;
                            }
                        } else if (buf.remaining() <= 0) {
                            con.removeWriteBuf(buf);
                            continue;
                        }
                        break block17;
                    }
                    if (key.isValid()) {
                        rv = true;
                    }
                }
                if (rv) {
                    EventPumper.clearInterest(key, 4);
                } else {
                    EventPumper.setInterest(key, 4);
                }
            }
        }
        catch (CancelledKeyException cke) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error writing on: " + con + "\n* Reason: Cancelled Key Exception");
            }
            this._context.statManager().addRateData("ntcp.writeError", 1L);
            con.close();
            rv = true;
        }
        catch (IOException ioe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Error writing on: " + con + "\n* Reason: IO Error");
            }
            this._context.statManager().addRateData("ntcp.writeError", 1L);
            con.close();
            rv = true;
        }
        return rv;
    }

    private void runDelayedEvents() {
        ServerSocketChannel chan;
        SelectionKey key;
        NTCPConnection con;
        while ((con = this._wantsRead.poll()) != null) {
            SelectionKey key2 = con.getKey();
            try {
                EventPumper.setInterest(key2, 1);
            }
            catch (CancelledKeyException cke) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Run Delayed Events: Cancelled Key Exception [1]");
            }
            catch (IllegalArgumentException iae) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("gnu?", iae);
            }
        }
        if (!this._wantsWrite.isEmpty()) {
            Iterator<NTCPConnection> iter = this._wantsWrite.iterator();
            while (iter.hasNext()) {
                con = iter.next();
                iter.remove();
                if (con.isClosed() || (key = con.getKey()) == null) continue;
                try {
                    EventPumper.setInterest(key, 4);
                }
                catch (CancelledKeyException cke) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("Run Delayed Events: Cancelled Key Exception [2]");
                }
                catch (IllegalArgumentException iae) {
                    if (!this._log.shouldWarn()) continue;
                    this._log.warn("gnu?", iae);
                }
            }
        }
        while ((chan = this._wantsRegister.poll()) != null) {
            try {
                key = chan.register(this._selector, 16);
                key.attach(chan);
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Error registering", cce);
            }
        }
        while ((con = this._wantsConRegister.poll()) != null) {
            SocketChannel schan = con.getChannel();
            try {
                SelectionKey key3 = schan.register(this._selector, 8);
                key3.attach(con);
                con.setKey(key3);
                RouterAddress naddr = con.getRemoteAddress();
                try {
                    int port = naddr.getPort();
                    byte[] ip = naddr.getIP();
                    if (port <= 0 || ip == null) {
                        throw new IOException("Invalid NTCP address: " + naddr);
                    }
                    InetSocketAddress saddr = new InetSocketAddress(InetAddress.getByAddress(ip), port);
                    boolean connected = schan.connect(saddr);
                    if (!connected) continue;
                    EventPumper.setInterest(key3, 1);
                    this.processConnect(key3);
                }
                catch (IOException ioe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Error connecting to: " + Addresses.toString(naddr.getIP(), naddr.getPort()) + "\n* Error: " + ioe.getMessage());
                    }
                    this._context.statManager().addRateData("ntcp.connectFailedIOE", 1L);
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    con.close(true);
                }
                catch (UnresolvedAddressException uae) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Unresolved address connecting", uae);
                    }
                    this._transport.markUnreachable(con.getRemotePeer().calculateHash());
                    con.close(true);
                }
                catch (CancelledKeyException cke) {
                    con.close(false);
                }
            }
            catch (ClosedChannelException cce) {
                if (!this._log.shouldWarn()) continue;
                this._log.warn("Error registering", cce);
            }
        }
        long now = System.currentTimeMillis();
        if (this._lastExpired + 1000L <= now) {
            this.expireTimedOut();
            this._lastExpired = now;
        }
    }

    public void blockIP(byte[] ip) {
        if (ip == null) {
            return;
        }
        String ba = Addresses.toString(ip);
        this._blockedIPs.increment(ba);
    }

    private void expireTimedOut() {
        this._transport.expireTimedOut();
    }

    public long getIdleTimeout() {
        return this._expireIdleWriteTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setInterest(SelectionKey key, int op) throws CancelledKeyException {
        SelectionKey selectionKey = key;
        synchronized (selectionKey) {
            int old = key.interestOps();
            if ((old & op) == 0) {
                key.interestOps(old | op);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void clearInterest(SelectionKey key, int op) throws CancelledKeyException {
        SelectionKey selectionKey = key;
        synchronized (selectionKey) {
            int old = key.interestOps();
            if ((old & op) != 0) {
                key.interestOps(old & ~op);
            }
        }
    }

    static {
        long maxMemory = SystemVersion.getMaxMemory();
        boolean isSlow = SystemVersion.isSlow();
        MIN_BUFS = (int)Math.max((long)MIN_MINB, Math.max((long)MAX_MINB, 1L + maxMemory / 0x400000L));
        DEFAULT_THROTTLE_FACTOR = SystemVersion.isSlow() ? 1.1f : 1.5f;
        _bufferCache = new TryCache<ByteBuffer>(new BufferFactory(), MIN_BUFS);
        STATUS_OK = EnumSet.of(CommSystemFacade.Status.OK, CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN, CommSystemFacade.Status.IPV4_OK_IPV6_FIREWALLED);
    }

    private static class BufferFactory
    implements TryCache.ObjectFactory<ByteBuffer> {
        private BufferFactory() {
        }

        @Override
        public ByteBuffer newInstance() {
            return ByteBuffer.allocate(BUF_SIZE);
        }
    }
}

