/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import java.io.BufferedInputStream;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.net.DatagramPacket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2np.DatabaseLookupMessage;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPAddress;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.stat.Rate;
import net.i2p.stat.RateAverages;
import net.i2p.stat.RateStat;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.I2PThread;
import net.i2p.util.LHMCache;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SecureFileOutputStream;
import net.i2p.util.SystemVersion;

class EstablishmentManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final int _networkID;
    private final PacketBuilder2 _builder2;
    private final Map<RemoteHostId, Token> _outboundTokens;
    private final Map<RemoteHostId, Token> _inboundTokens;
    private final ObjectCounter<RemoteHostId> _terminationCounter;
    private final ConcurrentHashMap<RemoteHostId, InboundEstablishState> _inboundStates;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundStates;
    private final ConcurrentHashMap<RemoteHostId, List<OutNetMessage>> _queuedOutbound;
    private final ConcurrentHashMap<Long, OutboundEstablishState> _liveIntroductions;
    private final ConcurrentHashMap<RemoteHostId, OutboundEstablishState> _outboundByClaimedAddress;
    private final ConcurrentHashMap<Hash, OutboundEstablishState> _outboundByHash;
    private final Map<RemoteHostId, Long> _inboundBans;
    private volatile boolean _alive;
    private final Object _activityLock;
    private int _activity;
    private final int DEFAULT_MAX_CONCURRENT_ESTABLISH;
    private static final int DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH = SystemVersion.isSlow() ? 32 : 96;
    private static final int DEFAULT_HIGH_MAX_CONCURRENT_ESTABLISH = SystemVersion.isSlow() ? 128 : 384;
    private static final String PROP_MAX_CONCURRENT_ESTABLISH = "i2np.udp.maxConcurrentEstablish";
    private static final float DEFAULT_THROTTLE_FACTOR = SystemVersion.isSlow() ? 1.5f : 3.0f;
    private static final String PROP_THROTTLE_FACTOR = "router.throttleFactor";
    private static final int MAX_QUEUED_OUTBOUND = SystemVersion.isSlow() ? 32 : 64;
    private static final int MAX_QUEUED_PER_PEER = SystemVersion.isSlow() ? 16 : 32;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final int MAX_OB_ESTABLISH_TIME = SystemVersion.isSlow() ? 25000 : 20000;
    public static final int MAX_IB_ESTABLISH_TIME = SystemVersion.isSlow() ? 12000 : 10000;
    public static final int OB_MESSAGE_TIMEOUT = SystemVersion.isSlow() ? 15000 : 12000;
    private static final int DATA_MESSAGE_TIMEOUT = SystemVersion.isSlow() ? 10000 : 8000;
    private static final int IB_BAN_TIME = 900000;
    private static final int MIN_TOKENS = SystemVersion.isSlow() ? 128 : 512;
    private static final int MAX_TOKENS = SystemVersion.isSlow() ? 1024 : 4096;
    public static final long IB_TOKEN_EXPIRATION = 3600000L;
    private static final long MAX_SKEW = 120000L;
    private static final String TOKEN_FILE = "ssu2tokens.txt";
    private static final int MAX_TERMINATIONS = 2;
    public static final long MAX_TAG_VALUE = 0xFFFFFFFFL;

    public EstablishmentManager(RouterContext ctx, UDPTransport transport) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(EstablishmentManager.class);
        this._networkID = ctx.router().getNetworkID();
        this._transport = transport;
        this._builder2 = transport.getBuilder2();
        this._inboundStates = new ConcurrentHashMap();
        this._outboundStates = new ConcurrentHashMap();
        this._queuedOutbound = new ConcurrentHashMap();
        this._liveIntroductions = new ConcurrentHashMap();
        this._outboundByClaimedAddress = new ConcurrentHashMap();
        this._outboundByHash = new ConcurrentHashMap();
        this._inboundBans = new LHMCache<RemoteHostId, Long>(32);
        int tokenCacheSize = Math.max(MIN_TOKENS, Math.min(MAX_TOKENS, 3 * this._transport.getMaxConnections() / 4));
        this._inboundTokens = new InboundTokens(tokenCacheSize);
        this._outboundTokens = new LHMCache<RemoteHostId, Token>(tokenCacheSize);
        this._terminationCounter = new ObjectCounter();
        this._activityLock = new Object();
        this.DEFAULT_MAX_CONCURRENT_ESTABLISH = Math.max(DEFAULT_LOW_MAX_CONCURRENT_ESTABLISH, Math.min(DEFAULT_HIGH_MAX_CONCURRENT_ESTABLISH, ctx.bandwidthLimiter().getOutboundKBytesPerSecond() / 2));
        this._context.statManager().createRateStat("udp.inboundEstablishTime", "Time to establish new inbound session (ms)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.outboundEstablishTime", "Time to establish new outbound session (ms)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.sendIntroRelayTimeout", "Relay request timeouts before response (target or intro peer offline)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishDropped", "Dropped an inbound establish message", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishRejected", "Pending outbound connections when we refuse to add any more", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishOverflow", "Messages queued up on a pending connection when it was too much", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.establishBadIP", "Received IP or port was bad", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestionOccurred", "Size of CWIN when congestion occurred (duration = sendBps)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.congestedRTO", "RTO after congestion (duration = RTT dev)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuIncrease", "Number of resends to peer when MTU was increased", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.mtuDecrease", "Number of resends to peer when MTU was decreased", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentActive", "Messages in transit to peer when we reject it", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.allowConcurrentActive", "Messages in transit to peer when we accept it", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRateStat("udp.rejectConcurrentSequence", "Consecutive concurrency rejections when we stop rejecting", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.inboundTokenLifetime", "SSU2 Token lifetime (ms)", "Transport [UDP]", UDPTransport.RATES);
        this._context.statManager().createRequiredRateStat("udp.inboundConn", "Inbound UDP Connection", "Transport [UDP]", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this.loadTokens();
        this._alive = true;
        I2PThread t = new I2PThread(new Establisher(), "UDPEstablisher", true);
        t.setPriority(10);
        t.start();
    }

    public synchronized void shutdown() {
        this._alive = false;
        this.saveTokens();
        this.notifyActivity();
    }

    InboundEstablishState getInboundState(RemoteHostId from) {
        InboundEstablishState state = this._inboundStates.get(from);
        return state;
    }

    OutboundEstablishState getOutboundState(RemoteHostId from) {
        OutboundEstablishState state = this._outboundStates.get(from);
        if (state == null && (state = this._outboundByClaimedAddress.get(from)) != null && this._log.shouldInfo()) {
            this._log.info("[SSU2] Found by claimed address: " + state);
        }
        return state;
    }

    private int getMaxConcurrentEstablish() {
        return this._context.getProperty(PROP_MAX_CONCURRENT_ESTABLISH, this.DEFAULT_MAX_CONCURRENT_ESTABLISH);
    }

    private float getThrottleFactor() {
        return this._context.getProperty(PROP_THROTTLE_FACTOR, DEFAULT_THROTTLE_FACTOR);
    }

    public void establish(OutNetMessage msg) {
        this.establish(msg, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void establish(OutNetMessage msg, boolean queueIfMaxExceeded) {
        String truncHash;
        RouterInfo toRouterInfo = msg.getTarget();
        RouterAddress ra = this._transport.getTargetAddress(toRouterInfo);
        if (ra == null) {
            this._transport.failed(msg, "Peer has no address, cannot establish connection");
            return;
        }
        RouterIdentity toIdentity = toRouterInfo.getIdentity();
        Hash toHash = toIdentity.calculateHash();
        int id = toRouterInfo.getNetworkId();
        boolean isBanned = toHash != null && this._context.banlist().isBanlisted(toHash);
        long now = this._context.clock().now();
        String string = truncHash = toHash != null ? toHash.toBase64().substring(0, 6) : "";
        if (id != this._networkID) {
            if (id == -1) {
                this._context.banlist().banlistRouter(toHash, " <b>\u279c</b> No network specified", null, null, this._context.clock().now() + 2592000000L);
            } else {
                this._context.banlist().banlistRouterForever(toHash, " <b>\u279c</b> Not in our network: " + id);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Not in our network: " + toRouterInfo, new Exception());
            }
            this._transport.markUnreachable(toHash);
            this._transport.failed(msg, "Peer is on the wrong network, cannot establish connection");
            return;
        }
        UDPAddress addr = new UDPAddress(ra);
        RemoteHostId maybeTo = null;
        InetAddress remAddr = addr.getHostAddress();
        int port = addr.getPort();
        if (remAddr != null && port > 0 && port <= 65535) {
            maybeTo = new RemoteHostId(remAddr.getAddress(), port);
            String ipAddress = Addresses.toString(remAddr.getAddress());
            if (!this._transport.isValid(maybeTo.getIP()) || Arrays.equals(maybeTo.getIP(), this._transport.getExternalIP()) && !this._transport.allowLocal()) {
                this._transport.failed(msg, "Peer's IP address isn't valid");
                this._transport.markUnreachable(toHash);
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                if (toHash != null) {
                    if (!isBanned) {
                        this._context.banlist().banlistRouter(toHash, " <b>\u279c</b> Invalid SSU address", null, null, now + 480000L);
                        if (this._log.shouldWarn()) {
                            this._log.warn("[SSU2] Banning [" + truncHash + "] for 8h -> Invalid SSU address");
                        }
                    }
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Invalid or spoofed SSU address detected for: " + ipAddress + ":" + port);
                }
                return;
            }
            InboundEstablishState inState = this._inboundStates.get(maybeTo);
            if (inState != null) {
                InboundEstablishState inboundEstablishState = inState;
                synchronized (inboundEstablishState) {
                    switch (inState.getState()) {
                        case IB_STATE_UNKNOWN: 
                        case IB_STATE_REQUEST_RECEIVED: 
                        case IB_STATE_CREATED_SENT: 
                        case IB_STATE_CONFIRMED_PARTIALLY: 
                        case IB_STATE_CONFIRMED_COMPLETELY: 
                        case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                        case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: 
                        case IB_STATE_RETRY_SENT: {
                            inState.addMessage(msg);
                            if (!this._log.shouldDebug()) break;
                            this._log.debug("[SSU2] Outbound message queued to InboundEstablishState");
                            break;
                        }
                        case IB_STATE_COMPLETE: {
                            this._transport.sendIfEstablished(msg);
                            break;
                        }
                        case IB_STATE_FAILED: {
                            this._transport.failed(msg, "Outbound message failed during InboundEstablish");
                        }
                    }
                }
                return;
            }
        }
        boolean isIndirect = addr.getIntroducerCount() > 0 || maybeTo == null;
        byte[] maybeIP = maybeTo != null ? maybeTo.getIP() : null;
        int maybePort = maybeTo != null ? maybeTo.getPort() : 0;
        String ipAddress = maybeTo != null ? Addresses.toString(maybeIP) : "";
        RemoteHostId to = isIndirect ? new RemoteHostId(toHash) : maybeTo;
        OutboundEstablishState state = null;
        int deferred = 0;
        boolean rejected = false;
        int queueCount = 0;
        state = this._outboundStates.get(to);
        if (state == null && (state = this._outboundByHash.get(toHash)) != null && this._log.shouldInfo()) {
            this._log.info("[SSU2] Found by hash: " + state);
        }
        if (state == null) {
            if (queueIfMaxExceeded && this._outboundStates.size() >= this.getMaxConcurrentEstablish()) {
                if (this._queuedOutbound.size() >= MAX_QUEUED_OUTBOUND && !this._queuedOutbound.containsKey(to)) {
                    rejected = true;
                } else {
                    ArrayList<OutNetMessage> newQueued = new ArrayList<OutNetMessage>(MAX_QUEUED_PER_PEER);
                    ArrayList<OutNetMessage> queued = this._queuedOutbound.putIfAbsent(to, newQueued);
                    if (queued == null) {
                        queued = newQueued;
                        if (this._log.shouldWarn()) {
                            this._log.warn("[SSU2] Queueing OutboundEstablish to " + to + ", increase " + PROP_MAX_CONCURRENT_ESTABLISH);
                        }
                    }
                    ArrayList<OutNetMessage> arrayList = queued;
                    synchronized (arrayList) {
                        queueCount = queued.size();
                        if (queueCount < MAX_QUEUED_PER_PEER) {
                            queued.add(msg);
                            ++queueCount;
                        } else {
                            rejected = true;
                        }
                        deferred = this._queuedOutbound.size();
                    }
                }
            } else {
                boolean isNew;
                SessionKey sessionKey;
                String siv;
                byte[] keyBytes;
                int version = this._transport.getSSUVersion(ra);
                if (isIndirect && version == 2 && ra.getTransportStyle().equals("SSU")) {
                    boolean v2intros = false;
                    int count = addr.getIntroducerCount();
                    for (int i = 0; i < count; ++i) {
                        Hash h = addr.getIntroducerHash(i);
                        long exp = addr.getIntroducerExpiration(i);
                        if (h != null && (exp > now || exp == 0L)) {
                            v2intros = true;
                            break;
                        }
                        if (v2intros) continue;
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, "No v2 Introducers");
                        return;
                    }
                }
                if (version == 2) {
                    int mtu = addr.getMTU();
                    boolean isIPv6 = TransportUtil.isIPv6(ra);
                    int ourMTU = this._transport.getMTU(isIPv6);
                    if (mtu > 0 && mtu < 1280 || ourMTU > 0 && ourMTU < 1280) {
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, "MTU too small");
                        if (toHash != null) {
                            if (!isBanned) {
                                this._context.banlist().banlistRouter(toHash, " <b>\u279c</b> Invalid MTU", null, null, now + 480000L);
                                if (this._log.shouldWarn()) {
                                    this._log.warn("[SSU2] Banning [" + truncHash + "] for 8h -> Invalid MTU");
                                }
                            }
                        } else if (ipAddress != "" && this._log.shouldWarn()) {
                            this._log.warn("[SSU2] Router has invalid MTU (too small): " + ipAddress + ":" + maybePort);
                        }
                        return;
                    }
                }
                if ((keyBytes = version == 1 ? null : ((siv = ra.getOption("i")) != null ? Base64.decode(siv) : null)) == null) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has no key, cannot establish connection -> Marking unreachable");
                    if (toHash != null) {
                        if (!isBanned) {
                            this._context.banlist().banlistRouter(toHash, " <b>\u279c</b> No Introduction key", null, null, now + 240000L);
                            if (this._log.shouldWarn()) {
                                this._log.warn("[SSU2] Banning [" + truncHash + "] for 4h -> No Introduction key");
                            }
                        }
                    } else if (ipAddress != "" && this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Received no Introduction key from: " + ipAddress + ":" + maybePort);
                    }
                    return;
                }
                try {
                    sessionKey = new SessionKey(keyBytes);
                }
                catch (IllegalArgumentException iae) {
                    this._transport.markUnreachable(toHash);
                    this._transport.failed(msg, "Peer has BAD key, cannot establish connection -> Marking unreachable");
                    if (toHash != null) {
                        if (!isBanned) {
                            this._context.banlist().banlistRouter(toHash, " <b>\u279c</b> Bad Introduction key", null, null, now + 480000L);
                            if (this._log.shouldWarn()) {
                                this._log.warn("[SSU2] Banning [" + truncHash + "] for 8h -> Bad Introduction key");
                            }
                        }
                    } else if (ipAddress != "" && this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Received Bad Introduction key from: " + ipAddress + ":" + maybePort);
                    }
                    return;
                }
                if (version == 2) {
                    boolean requestIntroduction = !isIndirect && this._transport.introducersMaybeRequired(TransportUtil.isIPv6(ra));
                    try {
                        state = new OutboundEstablishState2(this._context, this._transport, maybeTo, to, toIdentity, requestIntroduction, sessionKey, ra, addr);
                    }
                    catch (IllegalArgumentException iae) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("[SSU2] OES2 error: " + toRouterInfo, iae);
                        }
                        this._transport.markUnreachable(toHash);
                        this._transport.failed(msg, iae.getMessage());
                        return;
                    }
                } else {
                    this._transport.failed(msg, "OB to bad addr? " + ra);
                    return;
                }
                OutboundEstablishState oldState = this._outboundStates.putIfAbsent(to, state);
                boolean bl = isNew = oldState == null;
                if (isNew) {
                    if (isIndirect && maybeTo != null) {
                        this._outboundByClaimedAddress.put(maybeTo, state);
                    }
                    if (this._log.shouldDebug()) {
                        this._log.debug("[SSU2] Adding new Outbound connection to: " + state);
                    }
                } else {
                    state = oldState;
                }
            }
        }
        if (state != null) {
            state.addMessage(msg);
            List<OutNetMessage> queued = this._queuedOutbound.remove(to);
            if (queued != null) {
                List<OutNetMessage> list = queued;
                synchronized (list) {
                    for (OutNetMessage m : queued) {
                        state.addMessage(m);
                    }
                }
            }
        }
        if (rejected) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Too many pending connections, rejecting OutboundEstablish to " + to);
            }
            this._transport.failed(msg, "Too many pending outbound connections");
            this._context.statManager().addRateData("udp.establishRejected", deferred);
            return;
        }
        if (queueCount >= MAX_QUEUED_PER_PEER) {
            this._transport.failed(msg, "Too many pending messages for the given peer");
            this._context.statManager().addRateData("udp.establishOverflow", queueCount, deferred);
            return;
        }
        if (deferred > 0) {
            msg.timestamp("Too many deferred establishers");
        } else if (state != null) {
            msg.timestamp("Establish state already waiting");
        }
        this.notifyActivity();
    }

    private int getMaxInboundEstablishers() {
        return this.getMaxConcurrentEstablish() / 2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean shouldAllowInboundEstablishment() {
        int total;
        int current;
        long periodStart;
        int last;
        if (this._inboundStates.size() >= this.getMaxInboundEstablishers()) {
            return false;
        }
        RateStat rs = this._context.statManager().getRate("udp.inboundConn");
        if (rs == null) {
            return true;
        }
        Rate r = rs.getRate(60000L);
        if (r == null) {
            return true;
        }
        RateAverages ra = RateAverages.getTemp();
        Rate rate = r;
        synchronized (rate) {
            last = (int)r.getLastEventCount();
            periodStart = r.getLastCoalesceDate();
            r.computeAverages(ra, true);
        }
        if (last < 15) {
            last = 15;
        }
        if ((current = (total = (int)ra.getTotalEventCount()) - last) <= 0) {
            return true;
        }
        int lastPeriod = 60000;
        double avg = ra.getAverage();
        int currentTime = (int)(this._context.clock().now() - periodStart);
        if (currentTime <= 5000) {
            return true;
        }
        float lastRate = (float)last / (float)lastPeriod;
        float currentRate = (float)((double)current / (double)currentTime);
        float factor = this._transport.haveCapacity(95) ? this.getThrottleFactor() : 0.95f;
        float minThresh = factor * lastRate;
        int maxConnections = this._transport.getMaxConnections();
        int currentConnections = this._transport.countPeers();
        if (currentRate > minThresh * 5.0f / 3.0f && currentConnections > maxConnections * 2 / 3) {
            int percent;
            int probAccept = Math.max(1, (int)(512.0f * currentRate / minThresh) - 512);
            int n = percent = probAccept > 128 ? 100 : probAccept / 128 * 100;
            if (probAccept >= 128 || this._context.random().nextInt(128) < probAccept) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Dropping incoming connection (" + (percent >= 1 ? Integer.valueOf(percent) : "1") + "% chance) -> Previous/current connections per minute: " + last + " / " + (int)(currentRate * 60.0f * 1000.0f));
                }
                return false;
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveSessionOrTokenRequest(RemoteHostId from, InboundEstablishState2 state, UDPPacket packet) {
        String truncHash;
        long now = this._context.clock().now();
        byte[] fromIP = from.getIP();
        int fromPort = from.getPort();
        String ipAddress = Addresses.toString(fromIP);
        RemoteHostId host = new RemoteHostId(fromIP, fromPort);
        Hash fromHash = host.getPeerHash();
        boolean hasIP = fromIP != null;
        boolean isBlocklisted = hasIP && this._context.blocklist().isBlocklisted(fromIP);
        boolean isBanned = fromHash != null && this._context.banlist().isBanlisted(fromHash);
        String string = truncHash = fromHash != null ? fromHash.toBase64().substring(0, 6) : "";
        if (!TransportUtil.isValidPort(from.getPort()) || !this._transport.isValid(fromIP)) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received Session Request from invalid address/port: " + from);
            }
            if (fromHash != null) {
                if (!isBanned) {
                    this._context.banlist().banlistRouter(fromHash, " <b>\u279c</b> Invalid address/port in Session Request", null, null, now + 480000L);
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Banning [" + truncHash + "] for 8h -> Invalid address/port in Session Request (" + from + ")");
                    }
                } else if (isBanned && this._log.shouldInfo()) {
                    this._log.info("[SSU2] Not banning [" + truncHash + "] -> Already in blocklist (" + from + ")");
                }
            }
            return;
        }
        boolean isNew = false;
        if (state == null) {
            if (isBlocklisted) {
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Received Session Request from blocklisted IP address " + from);
                } else if (isBanned && this._log.shouldInfo()) {
                    this._log.info("[SSU2] Received Session Request from banned Router [" + truncHash + "}");
                }
                this._context.statManager().addRateData("udp.establishBadIP", 1L);
                if (!this._context.commSystem().isInStrictCountry()) {
                    this.sendTerminationPacket(from, packet, 17);
                }
                return;
            }
            if (!this._context.commSystem().isExemptIncoming(Addresses.toString(fromIP))) {
                if (!this.shouldAllowInboundEstablishment()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Dropping InboundEstablish from " + Addresses.toString(fromIP));
                    }
                    this._context.statManager().addRateData("udp.establishDropped", 1L);
                    this.sendTerminationPacket(from, packet, 19);
                    return;
                }
                Map<RemoteHostId, Long> map = this._inboundBans;
                synchronized (map) {
                    Long exp = this._inboundBans.get(from);
                    if (exp != null) {
                        if (exp >= this._context.clock().now()) {
                            if (this._log.shouldInfo()) {
                                this._log.info("[SSU2] Received Session Request from temporarily banned peer " + from);
                            }
                            this._context.statManager().addRateData("udp.establishBadIP", 1L);
                            this.sendTerminationPacket(from, packet, 11);
                            return;
                        }
                        this._inboundBans.remove(from);
                    }
                }
                if (!this._transport.allowConnection()) {
                    this.sendTerminationPacket(from, packet, 19);
                    return;
                }
            }
            try {
                state = new InboundEstablishState2(this._context, this._transport, packet);
            }
            catch (GeneralSecurityException gse) {
                boolean gseNotNull;
                boolean bl = gseNotNull = gse.getMessage() != null && gse.getMessage() != "null";
                if (this._log.shouldDebug()) {
                    this._log.warn("[SSU2] Received CORRUPT Session or Token Request from " + from, gse);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Received CORRUPT Session or Token Request from " + from + (gseNotNull ? "\n* General Security Exception: " + gse.getMessage() : ""));
                }
                this._context.statManager().addRateData("udp.establishDropped", 1L);
                return;
            }
            this._context.statManager().addRateData("udp.inboundConn", 1L);
            InboundEstablishState oldState = this._inboundStates.putIfAbsent(from, state);
            boolean bl = isNew = oldState == null;
            if (!isNew && oldState.getVersion() == 2) {
                state = (InboundEstablishState2)oldState;
            }
        } else {
            try {
                state.receiveSessionOrTokenRequestAfterRetry(packet);
            }
            catch (GeneralSecurityException gse) {
                boolean gseNotNull;
                boolean bl = gseNotNull = gse.getMessage() != null && gse.getMessage() != "null";
                if (this._log.shouldDebug()) {
                    this._log.warn("[SSU2] Received CORRUPT Session or Token Request after Retry \n* Router: " + state, gse);
                } else if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Received CORRUPT Session or Token Request after Retry \n* Router: " + state + (gseNotNull ? "\n* General Security Exception: " + gse.getMessage() : ""));
                }
                this._inboundStates.remove(state.getRemoteHostId());
                return;
            }
        }
        if (this._log.shouldDebug()) {
            if (isNew) {
                this._log.debug("[SSU2] Received NEW Session/Token Request " + state);
            } else {
                this._log.debug("[SSU2] Received DUPLICATE Session/Token Request \n* Router: " + state);
            }
        }
        this.notifyActivity();
    }

    private void sendTerminationPacket(RemoteHostId to, UDPPacket fromPacket, int terminationCode) {
        boolean shouldExit = false;
        int count = this._terminationCounter.increment(to);
        if (count > 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Rate limit of 2 in 3m exceeded (Count: " + count + ") \n* No more termination packets to: " + to);
            }
            if (count > 4) {
                try {
                    String toIP = InetAddress.getByAddress(to.getIP()).getHostAddress();
                    String targetIP = toIP.toString().replace("/", "");
                    byte[] ip = Addresses.getIP(targetIP);
                    if (ip != null && !this._context.blocklist().isBlocklisted(ip)) {
                        this._context.blocklist().add(ip, "Ignores termination packets");
                        if (this._log.shouldWarn()) {
                            this._log.warn("[SSU2] Banning " + targetIP + " for duration of session -> Repeatedly ignoring termination packets");
                        }
                    }
                }
                catch (UnknownHostException toIP) {
                    // empty catch block
                }
            }
            shouldExit = true;
        }
        if (shouldExit) {
            return;
        }
        if (this._transport.isTooClose(to.getIP())) {
            return;
        }
        DatagramPacket pkt = fromPacket.getPacket();
        int len = pkt.getLength();
        if (len < 56) {
            return;
        }
        int off = pkt.getOffset();
        byte[] data = pkt.getData();
        int type = data[off + 12] & 0xFF;
        if (type == 0 && len < SSU2Util.MIN_SESSION_REQUEST_LEN) {
            return;
        }
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        if (rcvConnID == 0L || sendConnID == 0L || rcvConnID == sendConnID) {
            return;
        }
        if (this._log.shouldInfo()) {
            this._log.warn("[SSU2] Sending termination packet (" + EstablishmentManager.parseReason(terminationCode) + ") on type " + type + " to: " + to);
        }
        UDPPacket packet = this._builder2.buildRetryPacket(to, pkt.getSocketAddress(), sendConnID, rcvConnID, terminationCode);
        this._transport.send(packet);
    }

    void receiveSessionConfirmed(InboundEstablishState2 state, UDPPacket packet) {
        boolean shouldExit = false;
        try {
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && this._context.blocklist().isBlocklisted(ip)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Ignoring SessionConfirmed from " + targetIP + " -> IP address is blocklisted");
                    }
                    shouldExit = true;
                }
            }
            catch (UnknownHostException fromIP) {
                // empty catch block
            }
            shouldExit = true;
            if (true) {
                return;
            }
            state.receiveSessionConfirmed(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.warn("[SSU2] Received CORRUPT SessionConfirmed \n* Router: " + state, gse);
            } else if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received CORRUPT SessionConfirmed \n* Router: " + state + "\n* " + gse.getMessage());
            }
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && !this._context.blocklist().isBlocklisted(ip)) {
                    this._context.blocklist().add(ip, "Corrupt SessionConfirmed");
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Banning " + targetIP + " for duration of session -> Corrupt SessionConfirmed");
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this._inboundStates.remove(state.getRemoteHostId());
            return;
        }
        InboundEstablishState.InboundState istate = state.getState();
        if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
            this.handleCompletelyEstablished(state);
        }
        this.notifyActivity();
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received SessionConfirmed \n* Router: " + state);
        }
    }

    void receiveSessionCreated(OutboundEstablishState2 state, UDPPacket packet) {
        boolean shouldExit = false;
        try {
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && this._context.blocklist().isBlocklisted(ip)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Ignoring SessionCreated from " + targetIP + " -> IP address is blocklisted");
                    }
                    shouldExit = true;
                }
            }
            catch (UnknownHostException fromIP) {
                // empty catch block
            }
            if (shouldExit) {
                return;
            }
            state.receiveSessionCreated(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.warn("[SSU2] Received CORRUPT SessionCreated \n* Router: " + state, gse);
            } else if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received CORRUPT SessionCreated \n* Router: " + state + "\n* " + gse.getMessage());
            }
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && !this._context.blocklist().isBlocklisted(ip)) {
                    this._context.blocklist().add(ip, "Corrupt SessionCreated");
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Banning " + targetIP + " for duration of session -> Corrupt SessionCreated");
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            this._outboundStates.remove(state.getRemoteHostId());
            return;
        }
        this.notifyActivity();
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received SessionCreated \n* Router: " + state);
        }
    }

    void receiveRetry(OutboundEstablishState2 state, UDPPacket packet) {
        boolean shouldExit = false;
        try {
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && this._context.blocklist().isBlocklisted(ip)) {
                    if (this._log.shouldInfo()) {
                        this._log.info("[SSU2] Ignoring RETRY from " + targetIP + " -> IP address is in blocklist");
                    }
                    shouldExit = true;
                }
            }
            catch (UnknownHostException fromIP) {
                // empty catch block
            }
            state.receiveRetry(packet);
        }
        catch (GeneralSecurityException gse) {
            if (this._log.shouldDebug()) {
                this._log.warn("[SSU2] Received CORRUPT Retry \n* Router: " + state, gse);
            } else if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Received CORRUPT Retry \n* Router: " + state + "\n* " + gse.getMessage());
            }
            try {
                String fromIP = InetAddress.getByAddress(state.getRemoteHostId().getIP()).getHostAddress();
                String targetIP = fromIP.toString().replace("/", "");
                byte[] ip = Addresses.getIP(targetIP);
                if (ip != null && !this._context.blocklist().isBlocklisted(ip)) {
                    this._context.blocklist().add(ip, "Corrupt Retry");
                    if (this._log.shouldWarn()) {
                        this._log.warn("[SSU2] Banning " + targetIP + " for duration of session -> Corrupt Retry");
                    }
                }
            }
            catch (UnknownHostException unknownHostException) {
                // empty catch block
            }
            if (shouldExit) {
                return;
            }
            this._outboundStates.remove(state.getRemoteHostId());
            return;
        }
        this.notifyActivity();
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Received Retry with token " + state.getToken() + " \n* Router: " + state);
        }
    }

    void receiveSessionDestroy(RemoteHostId from, PeerState state) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received SessionDestroy on established connection from " + from);
        }
        this._transport.dropPeer(state, false, "Received destroy message");
    }

    void receiveSessionDestroy(RemoteHostId from, OutboundEstablishState state) {
        if (this._log.shouldDebug()) {
            this._log.debug("Received Outbound SessionDestroy from " + from);
        }
        this._outboundStates.remove(from);
        Hash peer = state.getRemoteIdentity().calculateHash();
        this._transport.dropPeer(peer, false, "Received destroy message during Outbound establish");
    }

    void receiveSessionDestroy(RemoteHostId from) {
        if (this._log.shouldWarn()) {
            this._log.warn("Received unauthenticated SessionDestroy from " + from);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    PeerState receiveData(OutboundEstablishState state) {
        state.dataReceived();
        this._outboundStates.remove(state.getRemoteHostId());
        List<OutNetMessage> queued = this._queuedOutbound.remove(state.getRemoteHostId());
        if (queued != null) {
            List<OutNetMessage> list = queued;
            synchronized (list) {
                for (OutNetMessage m : queued) {
                    state.addMessage(m);
                }
            }
        }
        if (this._outboundStates.size() < this.getMaxConcurrentEstablish() && !this._queuedOutbound.isEmpty()) {
            this.locked_admitQueued();
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Outbound SSU connection successfully established \n* " + state);
        }
        PeerState peer = this.handleCompletelyEstablished(state);
        this.notifyActivity();
        return peer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int locked_admitQueued() {
        if (this._queuedOutbound.isEmpty()) {
            return 0;
        }
        int admitted = 0;
        int max = this.getMaxConcurrentEstablish();
        Iterator<Map.Entry<RemoteHostId, List<OutNetMessage>>> iter = this._queuedOutbound.entrySet().iterator();
        while (iter.hasNext() && this._outboundStates.size() < max) {
            Map.Entry<RemoteHostId, List<OutNetMessage>> entry = iter.next();
            try {
                iter.remove();
            }
            catch (IllegalStateException ise) {
                continue;
            }
            List<OutNetMessage> allQueued = entry.getValue();
            ArrayList<OutNetMessage> queued = new ArrayList<OutNetMessage>();
            long now = this._context.clock().now();
            List<OutNetMessage> list = allQueued;
            synchronized (list) {
                for (OutNetMessage msg : allQueued) {
                    if (now - 60000L > msg.getExpiration()) {
                        this._transport.failed(msg, "Timed out in EstablishmentManager Outbound queue");
                        continue;
                    }
                    queued.add(msg);
                }
            }
            if (queued.isEmpty()) continue;
            for (OutNetMessage m : queued) {
                m.timestamp("No longer deferred - establishing...");
                this.establish(m, false);
            }
            ++admitted;
        }
        return admitted;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void notifyActivity() {
        Object object = this._activityLock;
        synchronized (object) {
            ++this._activity;
            this._activityLock.notifyAll();
        }
    }

    private void handleCompletelyEstablished(InboundEstablishState state) {
        OutNetMessage msg;
        if (state.isComplete()) {
            return;
        }
        RouterIdentity remote = state.getConfirmedIdentity();
        InboundEstablishState2 state2 = (InboundEstablishState2)state;
        PeerState2 peer = state2.getPeerState();
        if (this._log.shouldDebug()) {
            this._log.debug("Inbound SSU handle successfully established to [" + peer.getRemotePeer().toBase64().substring(0, 6) + "] \n* " + state);
        }
        this._transport.addRemotePeerState(peer);
        boolean isIPv6 = state.getSentIP().length == 16;
        this._transport.inboundConnectionReceived(isIPv6);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.inboundEstablishTime", state.getLifetime());
        this.sendInboundComplete(peer);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (this._context.clock().now() - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            this._transport.send(msg);
        }
        state.complete();
    }

    private void sendInboundComplete(PeerState peer) {
        Hash hash;
        if (this._log.shouldDebug()) {
            this._log.debug("Completing initial handshake with " + peer);
        }
        if ((hash = peer.getRemotePeer()) != null && !this._context.banlist().isBanlisted(hash) && !this._transport.isUnreachable(hash)) {
            DatabaseStoreMessage dbsm = this.getOurInfo();
            this._transport.send(dbsm, peer);
        }
    }

    private PeerState handleCompletelyEstablished(OutboundEstablishState state) {
        OutNetMessage msg;
        RouterIdentity rem;
        if (state.complete() && (rem = state.getRemoteIdentity()) != null) {
            return this._transport.getPeerState(rem.getHash());
        }
        long now = this._context.clock().now();
        RouterIdentity remote = state.getRemoteIdentity();
        RemoteHostId claimed = state.getClaimedAddress();
        if (claimed != null) {
            this._outboundByClaimedAddress.remove(claimed, state);
        }
        this._outboundByHash.remove(remote.calculateHash(), state);
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        PeerState2 peer = state2.getPeerState();
        peer.setTheyRelayToUsAs(state.getReceivedRelayTag());
        if (this._log.shouldDebug()) {
            this._log.debug("Outbound SSU handle successfully established to [" + peer.getRemotePeer().toBase64().substring(0, 6) + "] \n* " + state);
        }
        this._transport.addRemotePeerState(peer);
        this._transport.setIP(remote.calculateHash(), state.getSentIP());
        this._context.statManager().addRateData("udp.outboundEstablishTime", state.getLifetime(now));
        I2NPMessage dbsm = null;
        ArrayList<OutNetMessage> msgs = new ArrayList<OutNetMessage>(8);
        while ((msg = state.getNextQueuedMessage()) != null) {
            if (now - 60000L > msg.getExpiration()) {
                msg.timestamp("took too long but established...");
                this._transport.failed(msg, "Took too long to establish, but it was established");
                continue;
            }
            msg.timestamp("session fully established and sent");
            msgs.add(msg);
        }
        this._transport.send(dbsm, msgs, peer);
        return peer;
    }

    public DatabaseStoreMessage getOurInfo() {
        DatabaseStoreMessage m = new DatabaseStoreMessage(this._context);
        m.setEntry(this._context.router().getRouterInfo());
        m.setMessageExpiration(this._context.clock().now() + (long)DATA_MESSAGE_TIMEOUT);
        return m;
    }

    private void sendCreated(InboundEstablishState state) {
        UDPPacket pkt;
        InboundEstablishState2 state2 = (InboundEstablishState2)state;
        InboundEstablishState.InboundState istate = state2.getState();
        switch (istate) {
            case IB_STATE_CREATED_SENT: {
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] ResendSessionCreated packet sent to: " + state);
                }
                pkt = state2.getRetransmitSessionCreatedPacket();
                break;
            }
            case IB_STATE_REQUEST_RECEIVED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Sending SessionCreated to: " + state);
                }
                pkt = this._builder2.buildSessionCreatedPacket(state2);
                break;
            }
            case IB_STATE_TOKEN_REQUEST_RECEIVED: 
            case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: 
            case IB_STATE_RETRY_SENT: {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Sending Retry to: " + state);
                }
                pkt = this._builder2.buildRetryPacket(state2, 0);
                break;
            }
            default: {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Unhandled state " + (Object)((Object)istate) + " on " + state);
                }
                return;
            }
        }
        if (pkt == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Router " + state + " appears to have sent us an invalid IP address");
            }
            this._inboundStates.remove(state.getRemoteHostId());
            state.fail();
            return;
        }
        this._transport.send(pkt);
    }

    private void sendRequest(OutboundEstablishState state) {
        UDPPacket packet;
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        OutboundEstablishState.OutboundState ostate = state2.getState();
        switch (ostate) {
            case OB_STATE_REQUEST_SENT: 
            case OB_STATE_REQUEST_SENT_NEW_TOKEN: {
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Resending Session Request packet to: " + state);
                }
                packet = state2.getRetransmitSessionRequestPacket();
                break;
            }
            case OB_STATE_NEEDS_TOKEN: 
            case OB_STATE_TOKEN_REQUEST_SENT: {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Sending Token Request to: " + state);
                }
                packet = this._builder2.buildTokenRequestPacket(state2);
                break;
            }
            case OB_STATE_UNKNOWN: 
            case OB_STATE_RETRY_RECEIVED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Sending Session Request to: " + state);
                }
                packet = this._builder2.buildSessionRequestPacket(state2);
                break;
            }
            case OB_STATE_INTRODUCED: {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Sending Session Request after introduction to: " + state);
                }
                packet = this._builder2.buildSessionRequestPacket(state2);
                break;
            }
            default: {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Unhandled state " + (Object)((Object)ostate) + " on " + state);
                }
                return;
            }
        }
        if (packet != null) {
            this._transport.send(packet);
        } else if (this._log.shouldWarn()) {
            this._log.warn("[SSU2] Unable to build a Session Request packet for: " + state);
        }
    }

    private void handlePendingIntro(OutboundEstablishState state) {
        Hash h;
        int i;
        OutboundEstablishState2.IntroState istate;
        long nonce = state.getIntroNonce();
        if (nonce < 0L) {
            OutboundEstablishState old;
            while ((old = this._liveIntroductions.putIfAbsent(nonce = this._context.random().nextLong(0xFFFFFFFFL), state)) != null) {
            }
            state.setIntroNonce(nonce);
        }
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        UDPAddress addr = state.getRemoteAddress();
        int count = addr.getIntroducerCount();
        for (int i2 = 0; i2 < count; ++i2) {
            long tag;
            boolean ok;
            Hash h2 = addr.getIntroducerHash(i2);
            if (h2 == null) continue;
            PeerState bob = null;
            istate = state2.getIntroState(h2);
            switch (istate) {
                case INTRO_STATE_INIT: 
                case INTRO_STATE_CONNECTING: {
                    bob = this._transport.getPeerState(h2);
                    if (bob == null) break;
                    if (bob.getVersion() == 2) {
                        istate = OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTED;
                        state2.setIntroState(h2, istate);
                        break;
                    }
                    istate = OutboundEstablishState2.IntroState.INTRO_STATE_REJECTED;
                    state2.setIntroState(h2, istate);
                    break;
                }
                case INTRO_STATE_CONNECTED: {
                    bob = this._transport.getPeerState(h2);
                    if (bob != null) break;
                    istate = OutboundEstablishState2.IntroState.INTRO_STATE_DISCONNECTED;
                    state2.setIntroState(h2, istate);
                }
            }
            if (bob == null || istate != OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTED) continue;
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Found connected Introducer " + bob + " for " + state);
            }
            if (ok = this.sendRelayRequest(tag = addr.getIntroducerTag(i2), (PeerState2)bob, state)) {
                state2.introSent(h2);
            } else {
                state2.setIntroState(h2, OutboundEstablishState2.IntroState.INTRO_STATE_DISCONNECTED);
            }
            return;
        }
        boolean sent = false;
        for (i = 0; i < count; ++i) {
            OutboundEstablishState2.IntroState istate2;
            h = addr.getIntroducerHash(i);
            if (h == null) continue;
            RouterInfo bob = null;
            OutboundEstablishState2.IntroState oldState = istate2 = state2.getIntroState(h);
            switch (istate2) {
                case INTRO_STATE_INIT: 
                case INTRO_STATE_LOOKUP_SENT: 
                case INTRO_STATE_HAS_RI: {
                    bob = this._context.netDb().lookupRouterInfoLocally(h);
                    if (bob == null) break;
                    istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI;
                }
            }
            if (bob != null && istate2 == OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI) {
                List<RouterAddress> addrs = this._transport.getTargetAddresses(bob);
                for (RouterAddress ra : addrs) {
                    byte[] ip = ra.getIP();
                    int port = ra.getPort();
                    if (ip == null || port <= 0) continue;
                    RemoteHostId rhid = new RemoteHostId(ip, port);
                    OutboundEstablishState oes = this._outboundStates.get(rhid);
                    if (oes != null) {
                        if (!this._log.shouldDebug()) break;
                        this._log.debug("[SSU2] Awaiting pending connection to Introducer " + oes + " for " + state);
                        break;
                    }
                    int version = this._transport.getSSUVersion(ra);
                    if (version != 2) continue;
                    if (this._log.shouldDebug()) {
                        this._log.debug("[SSU2] Connecting to Introducer " + bob + " for " + state);
                    }
                    DatabaseLookupMessage dlm = new DatabaseLookupMessage(this._context);
                    dlm.setSearchKey(h);
                    dlm.setSearchType(DatabaseLookupMessage.Type.RI);
                    long now = this._context.clock().now();
                    dlm.setMessageExpiration(now + 10000L);
                    dlm.setFrom(this._context.routerHash());
                    OutNetMessage m = new OutNetMessage(this._context, dlm, now + 10000L, 1000, bob);
                    this.establish(m);
                    istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_CONNECTING;
                    break;
                }
            }
            if (istate2 == OutboundEstablishState2.IntroState.INTRO_STATE_HAS_RI) {
                istate2 = OutboundEstablishState2.IntroState.INTRO_STATE_REJECTED;
            }
            if (oldState == istate2) continue;
            state2.setIntroState(h, istate2);
        }
        if (sent) {
            state.introSent();
            return;
        }
        for (i = 0; i < count; ++i) {
            h = addr.getIntroducerHash(i);
            if (h == null || (istate = state2.getIntroState(h)) != OutboundEstablishState2.IntroState.INTRO_STATE_INIT) continue;
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Looking up Introducer " + h + " for " + state);
            }
            istate = OutboundEstablishState2.IntroState.INTRO_STATE_LOOKUP_SENT;
            state2.setIntroState(h, istate);
            this._context.netDb().lookupRouterInfo(h, null, null, 10000L);
            sent = true;
        }
        if (sent) {
            state.introSent();
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] No valid Introducers for " + state);
            }
            this.processExpired(state);
        }
    }

    private boolean sendRelayRequest(long tag, PeerState2 bob, OutboundEstablishState charlie) {
        UDPPacket packet;
        RouterAddress ourra;
        UDPAddress cra = charlie.getRemoteAddress();
        if (cra.isIPv6()) {
            ourra = this._transport.getCurrentExternalAddress(true);
            if (ourra == null) {
                ourra = this._transport.getCurrentExternalAddress(false);
            }
        } else {
            ourra = this._transport.getCurrentExternalAddress(false);
        }
        if (ourra == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] No IP address to send in relay request");
            }
            return false;
        }
        byte[] ourIP = ourra.getIP();
        if (ourIP == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] No IP address to send in relay request");
            }
            return false;
        }
        int ourPort = this._transport.getRequestedPort();
        byte[] data = SSU2Util.createRelayRequestData(this._context, bob.getRemotePeer(), charlie.getRemoteIdentity().getHash(), charlie.getIntroNonce(), tag, ourIP, ourPort, this._context.keyManager().getSigningPrivateKey());
        if (data == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Signature failure (no data)");
            }
            return false;
        }
        try {
            packet = this._builder2.buildRelayRequest(data, bob);
        }
        catch (IOException ioe) {
            return false;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Sending RelayRequest to " + bob + " for " + charlie);
        }
        this._transport.send(packet);
        bob.setLastSendTime(this._context.clock().now());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveRelayResponse(PeerState2 bob, long nonce, int code, byte[] data) {
        OutboundEstablishState2.IntroState istate;
        Hash signer;
        long token;
        Long lnonce = nonce;
        OutboundEstablishState charlie = code > 0 && code < 64 ? this._liveIntroductions.get(lnonce) : this._liveIntroductions.remove(lnonce);
        if (charlie == null) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Duplicate or unknown RelayResponse: " + nonce);
            }
            return;
        }
        if (charlie.getVersion() != 2) {
            return;
        }
        OutboundEstablishState2 charlie2 = (OutboundEstablishState2)charlie;
        if (code == 0) {
            token = DataHelper.fromLong8(data, data.length - 8);
            data = Arrays.copyOfRange(data, 0, data.length - 8);
        } else {
            token = 0L;
        }
        Hash bobHash = bob.getRemotePeer();
        Hash charlieHash = charlie.getRemoteIdentity().getHash();
        RouterInfo bobRI = this._context.netDb().lookupRouterInfoLocally(bobHash);
        RouterInfo charlieRI = this._context.netDb().lookupRouterInfoLocally(charlieHash);
        if (code > 0 && code < 64) {
            signer = bobHash;
            istate = OutboundEstablishState2.IntroState.INTRO_STATE_BOB_REJECT;
        } else {
            signer = charlieHash;
            istate = code == 0 ? OutboundEstablishState2.IntroState.INTRO_STATE_SUCCESS : OutboundEstablishState2.IntroState.INTRO_STATE_CHARLIE_REJECT;
        }
        RouterInfo signerRI = this._context.netDb().lookupRouterInfoLocally(signer);
        if (signerRI != null) {
            SigningPublicKey spk = signerRI.getIdentity().getSigningPublicKey();
            if (!SSU2Util.validateSig(this._context, SSU2Util.RELAY_RESPONSE_PROLOGUE, bobHash, null, data, spk)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Signature failed RelayResponse (" + EstablishmentManager.parseReason(code) + ") as Alice from:\n" + signerRI);
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                charlie.fail();
                return;
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] RouterInfo not found for Signer: " + signer);
            }
            return;
        }
        if (code == 0) {
            int iplen = data[9] & 0xFF;
            if (iplen != 6 && iplen != 18) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] BAD IP address length " + iplen + " from " + charlie);
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                charlie.fail();
                return;
            }
            int port = (int)DataHelper.fromLong(data, 10, 2);
            byte[] ip = new byte[iplen - 2];
            System.arraycopy(data, 12, ip, 0, iplen - 2);
            if (!TransportUtil.isValidPort(port) || !this._transport.isValid(ip) || this._transport.isTooClose(ip) || DataHelper.eq(ip, bob.getRemoteIP()) || this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("[SSU2] BAD RelayResponse from " + charlie + " for " + Addresses.toString(ip, port));
                }
                istate = OutboundEstablishState2.IntroState.INTRO_STATE_FAILED;
                charlie2.setIntroState(bobHash, istate);
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(charlieHash, " <b>\u279c</b> Bad Introduction data", null, null, this._context.clock().now() + 21600000L);
                charlie.fail();
                return;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("Received RelayResponse from " + charlie + " - they are on " + Addresses.toString(ip, port));
            }
            if (charlieRI == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Charlie's RouterInfo not found " + charlie);
                }
                charlie2.setIntroState(bobHash, istate);
                return;
            }
            OutboundEstablishState outboundEstablishState = charlie;
            synchronized (outboundEstablishState) {
                RemoteHostId oldId = charlie.getRemoteHostId();
                if (oldId.getIP() == null) {
                    ((OutboundEstablishState2)charlie).introduced(ip, port, token);
                    RemoteHostId newId = charlie.getRemoteHostId();
                    this.addOutboundToken(newId, token, this._context.clock().now() + 10000L);
                    this._outboundByHash.put(charlieHash, charlie);
                    RemoteHostId claimed = charlie.getClaimedAddress();
                    if (!oldId.equals(newId)) {
                        this._outboundStates.remove(oldId);
                        this._outboundStates.put(newId, charlie);
                        if (this._log.shouldLog(20)) {
                            this._log.info("[SSU2] RelayResponse replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                        }
                    }
                    if (claimed != null) {
                        this._outboundByClaimedAddress.remove(oldId, charlie);
                    }
                }
            }
            charlie2.setIntroState(bobHash, istate);
            this.notifyActivity();
        } else if (code >= 64) {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Received RelayResponse rejection (" + EstablishmentManager.parseReason(code) + ") from Charlie " + charlie);
            }
            charlie2.setIntroState(bobHash, istate);
            if (code == 69) {
                this._context.banlist().banlistRouter(charlieHash, " <b>\u279c</b> They banned us", null, null, this._context.clock().now() + 21600000L);
            }
            charlie.fail();
            this._liveIntroductions.remove(lnonce);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Received RelayResponse rejection (" + EstablishmentManager.parseReason(code) + ") from Bob " + bob);
            }
            charlie2.setIntroState(bobHash, istate);
            this.notifyActivity();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void receiveHolePunch(RemoteHostId id, UDPPacket packet) {
        long nonce;
        DatagramPacket pkt = packet.getPacket();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        int type = data[off + 12] & 0xFF;
        if (type != 11) {
            return;
        }
        byte[] introKey = this._transport.getSSU2StaticIntroKey();
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(introKey, 0);
        long n = DataHelper.fromLong(data, off + 8, 4);
        chacha.setNonce(n);
        HPCallback cb = new HPCallback(id);
        long now = this._context.clock().now();
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            int payloadLen = len - 48;
            SSU2Payload.processPayload(this._context, cb, data, off + 32, payloadLen, false, null);
            if (cb._respCode != 0) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] BAD HolePunch response: " + cb._respCode);
                }
                return;
            }
            long skew = cb._timeReceived - now;
            if (skew > 120000L || skew < -120000L) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Too skewed (" + skew + "ms) in HolePunch from " + id);
                }
                return;
            }
            nonce = DataHelper.fromLong(cb._respData, 0, 4);
            if (nonce != (rcvConnID & 0xFFFFFFFFL) || nonce != (rcvConnID >> 32 & 0xFFFFFFFFL)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] BAD nonce in HolePunch from " + id);
                }
                return;
            }
            long time = DataHelper.fromLong(cb._respData, 4, 4) * 1000L;
            skew = time - now;
            if (skew > 120000L || skew < -120000L) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Too skewed (" + skew + "ms) in HolePunch from " + id);
                }
                return;
            }
            int ver = cb._respData[8] & 0xFF;
            if (ver != 2) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] BAD HolePunch version (" + ver + ") from " + id);
                }
                return;
            }
        }
        catch (Exception e) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] BAD HolePunch packet:\n" + HexDump.dump(data, off, len), e);
            }
            return;
        }
        finally {
            chacha.destroy();
        }
        OutboundEstablishState state = this._outboundStates.get(id);
        if (state != null) {
            if (this._log.shouldInfo()) {
                this._log.info("[SSU2] HolePunch after RelayResponse from " + state);
            }
        } else {
            state = this._liveIntroductions.remove(nonce);
            if (state != null) {
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] HolePunch before RelayResponse from " + state);
                }
            } else {
                if (this._log.shouldLog(20)) {
                    this._log.info("[SSU2] No state found for SSU2 HolePunch from " + id);
                }
                return;
            }
        }
        if (state.getVersion() != 2) {
            return;
        }
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        Hash charlieHash = state.getRemoteIdentity().getHash();
        RouterInfo charlieRI = this._context.netDb().lookupRouterInfoLocally(charlieHash);
        if (charlieRI != null) {
            SigningPublicKey spk = charlieRI.getIdentity().getSigningPublicKey();
            UDPAddress addr = state.getRemoteAddress();
            int count = addr.getIntroducerCount();
            data = Arrays.copyOfRange(cb._respData, 0, cb._respData.length - 8);
            boolean ok = false;
            block15: for (int i = 0; i < count; ++i) {
                Hash h = addr.getIntroducerHash(i);
                if (h == null) continue;
                OutboundEstablishState2.IntroState istate = state2.getIntroState(h);
                switch (istate) {
                    case INTRO_STATE_INIT: 
                    case INTRO_STATE_EXPIRED: 
                    case INTRO_STATE_REJECTED: 
                    case INTRO_STATE_CONNECT_FAILED: 
                    case INTRO_STATE_BOB_REJECT: 
                    case INTRO_STATE_CHARLIE_REJECT: 
                    case INTRO_STATE_FAILED: 
                    case INTRO_STATE_INVALID: 
                    case INTRO_STATE_DISCONNECTED: {
                        continue block15;
                    }
                    default: {
                        if (!SSU2Util.validateSig(this._context, SSU2Util.RELAY_RESPONSE_PROLOGUE, h, null, data, spk)) continue block15;
                        if (this._log.shouldInfo()) {
                            this._log.info("[SSU2] GOOD signature with HolePunch, credit " + h.toBase64() + " on " + state);
                        }
                        state2.setIntroState(h, OutboundEstablishState2.IntroState.INTRO_STATE_SUCCESS);
                        ok = true;
                        break block15;
                    }
                }
            }
            if (!ok) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] Signature failed HolePunch on " + state);
                }
                return;
            }
            int iplen = data[9] & 0xFF;
            if (iplen != 6 && iplen != 18) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] BAD IP address length " + iplen + " from " + state);
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), " <b>\u279c</b> Bad Introduction data", null, null, this._context.clock().now() + 21600000L);
                state.fail();
                return;
            }
            int port = (int)DataHelper.fromLong(data, 10, 2);
            byte[] ip = new byte[iplen - 2];
            System.arraycopy(data, 12, ip, 0, iplen - 2);
            if (!TransportUtil.isValidPort(port) || !this._transport.isValid(ip) || this._transport.isTooClose(ip) || !DataHelper.eq(ip, id.getIP()) || this._context.blocklist().isBlocklisted(ip)) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("[SSU2] BAD HolePunch from " + state + " for " + Addresses.toString(ip, port) + " via " + id);
                }
                this._context.statManager().addRateData("udp.relayBadIP", 1L);
                this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), " <b>\u279c</b> Bad Introduction data", null, null, this._context.clock().now() + 21600000L);
                state.fail();
                return;
            }
            int fromPort = id.getPort();
            if (port != fromPort) {
                if (this._log.shouldWarn()) {
                    this._log.warn("[SSU2] HolePunch source mismatch (wrong port) from " + id + " -> Published port: " + port);
                }
                if (!TransportUtil.isValidPort(fromPort)) {
                    this._context.statManager().addRateData("udp.relayBadIP", 1L);
                    this._context.banlist().banlistRouter(state.getRemoteIdentity().getHash(), " <b>\u279c</b> Bad Introduction data", null, null, this._context.clock().now() + 21600000L);
                    state.fail();
                    return;
                }
                port = fromPort;
            } else if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Received HolePunch from " + state + " - they are on " + Addresses.toString(ip, port));
            }
            OutboundEstablishState outboundEstablishState = state;
            synchronized (outboundEstablishState) {
                RemoteHostId oldId = state.getRemoteHostId();
                if (oldId.getIP() == null) {
                    long token = DataHelper.fromLong8(cb._respData, cb._respData.length - 8);
                    state2.introduced(ip, port, token);
                    RemoteHostId newId = state.getRemoteHostId();
                    this.addOutboundToken(newId, token, now + 10000L);
                    this._outboundByHash.put(charlieHash, state);
                    RemoteHostId claimed = state.getClaimedAddress();
                    if (!oldId.equals(newId)) {
                        this._outboundStates.remove(oldId);
                        this._outboundStates.put(newId, state);
                        if (this._log.shouldLog(20)) {
                            this._log.info("[SSU2] HolePunch replaced " + oldId + " with " + newId + ", claimed address was " + claimed);
                        }
                    }
                    if (claimed != null) {
                        this._outboundByClaimedAddress.remove(oldId, state);
                    }
                }
            }
            boolean sendNow = state.receiveHolePunch();
            if (sendNow) {
                if (this._log.shouldInfo()) {
                    this._log.info("[SSU2] Send Session Request after HolePunch from " + state);
                }
                this.notifyActivity();
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] Charlie's RouterInfo not found " + state);
            }
            return;
        }
    }

    boolean isValid(byte[] ip, int port) {
        return TransportUtil.isValidPort(port) && ip != null && this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip);
    }

    private void sendConfirmation(OutboundEstablishState state) {
        boolean valid = state.validateSessionCreated();
        if (!valid) {
            if (this._log.shouldWarn()) {
                this._log.warn("[SSU2] SessionCreated failed validation -> " + state);
            }
            return;
        }
        byte[] ip = state.getReceivedIP();
        int port = state.getReceivedPort();
        if (!this._transport.isValid(ip) || port < 1024) {
            state.fail();
            return;
        }
        this._transport.externalAddressReceived(state.getRemoteIdentity().calculateHash(), ip, port);
        OutboundEstablishState2 state2 = (OutboundEstablishState2)state;
        OutboundEstablishState.OutboundState ostate = state2.getState();
        if (ostate == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            return;
        }
        UDPPacket[] packets = this._builder2.buildSessionConfirmedPackets(state2, this._context.router().getRouterInfo());
        if (packets == null) {
            state.fail();
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Sending SessionConfirmed to: " + state);
        }
        for (int i = 0; i < packets.length; ++i) {
            this._transport.send(packets[i]);
        }
        this.handleCompletelyEstablished(state2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleInbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        InboundEstablishState inboundState = null;
        boolean expired = false;
        Iterator<InboundEstablishState> iter = this._inboundStates.values().iterator();
        while (iter.hasNext()) {
            InboundEstablishState cur = iter.next();
            InboundEstablishState.InboundState istate = cur.getState();
            if (istate == InboundEstablishState.InboundState.IB_STATE_CONFIRMED_COMPLETELY) {
                iter.remove();
                inboundState = cur;
                break;
            }
            if (cur.getLifetime(now) > (long)MAX_IB_ESTABLISH_TIME || istate == InboundEstablishState.InboundState.IB_STATE_RETRY_SENT && cur.getLifetime(now) >= 5L * InboundEstablishState.RETRANSMIT_DELAY) {
                iter.remove();
                inboundState = cur;
                expired = true;
                break;
            }
            if (istate == InboundEstablishState.InboundState.IB_STATE_FAILED || istate == InboundEstablishState.InboundState.IB_STATE_COMPLETE) {
                iter.remove();
                continue;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                inboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (inboundState != null) {
            InboundEstablishState inboundEstablishState = inboundState;
            synchronized (inboundEstablishState) {
                InboundEstablishState.InboundState istate = inboundState.getState();
                switch (istate) {
                    case IB_STATE_REQUEST_RECEIVED: 
                    case IB_STATE_TOKEN_REQUEST_RECEIVED: 
                    case IB_STATE_REQUEST_BAD_TOKEN_RECEIVED: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_PARTIALLY: {
                        if (!expired) break;
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_CREATED_SENT: 
                    case IB_STATE_RETRY_SENT: {
                        if (expired) {
                            this.processExpired(inboundState);
                            break;
                        }
                        if (inboundState.getNextSendTime() > now) break;
                        this.sendCreated(inboundState);
                        break;
                    }
                    case IB_STATE_CONFIRMED_COMPLETELY: {
                        RouterIdentity remote = inboundState.getConfirmedIdentity();
                        if (remote != null) {
                            if (this._context.banlist().isBanlistedForever(remote.calculateHash()) || this._context.banlist().isBanlistedHostile(remote.calculateHash())) {
                                if (this._log.shouldWarn()) {
                                    this._log.warn("Dropping Inbound connection from " + (this._context.banlist().isBanlistedForever(remote.calculateHash()) ? "permanently" : "") + " banlisted peer: " + remote.calculateHash());
                                }
                                this._context.blocklist().add(inboundState.getSentIP());
                                inboundState.fail();
                                this.processExpired(inboundState);
                                break;
                            }
                            this.handleCompletelyEstablished(inboundState);
                            break;
                        }
                        if (this._log.shouldWarn()) {
                            this._log.warn("Confirmed with invalid? " + inboundState);
                        }
                        inboundState.fail();
                        this.processExpired(inboundState);
                        break;
                    }
                    case IB_STATE_COMPLETE: 
                    case IB_STATE_FAILED: {
                        break;
                    }
                    case IB_STATE_UNKNOWN: {
                        if (!this._log.shouldError()) break;
                        this._log.error("hrm, state is unknown for " + inboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + inboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long handleOutbound() {
        long now = this._context.clock().now();
        long nextSendTime = Long.MAX_VALUE;
        OutboundEstablishState outboundState = null;
        Iterator<OutboundEstablishState> iter = this._outboundStates.values().iterator();
        while (iter.hasNext()) {
            OutboundEstablishState cur = iter.next();
            OutboundEstablishState.OutboundState state = cur.getState();
            if (state == OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY || state == OutboundEstablishState.OutboundState.OB_STATE_VALIDATION_FAILED) {
                iter.remove();
                outboundState = cur;
                break;
            }
            if (cur.getLifetime(now) >= (long)MAX_OB_ESTABLISH_TIME) {
                iter.remove();
                outboundState = cur;
                break;
            }
            long next = cur.getNextSendTime();
            if (next <= now) {
                outboundState = cur;
                break;
            }
            if (next >= nextSendTime) continue;
            nextSendTime = next;
        }
        if (outboundState != null) {
            OutboundEstablishState outboundEstablishState = outboundState;
            synchronized (outboundEstablishState) {
                boolean expired = outboundState.getLifetime(now) >= (long)MAX_OB_ESTABLISH_TIME;
                switch (outboundState.getState()) {
                    case OB_STATE_NEEDS_TOKEN: 
                    case OB_STATE_UNKNOWN: 
                    case OB_STATE_INTRODUCED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_REQUEST_SENT: 
                    case OB_STATE_REQUEST_SENT_NEW_TOKEN: 
                    case OB_STATE_TOKEN_REQUEST_SENT: 
                    case OB_STATE_RETRY_RECEIVED: {
                        long rtime = outboundState.getRequestSentTime();
                        if (expired || rtime > 0L && rtime + (long)OB_MESSAGE_TIMEOUT <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendRequest(outboundState);
                        break;
                    }
                    case OB_STATE_CREATED_RECEIVED: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_PARTIALLY: {
                        long ctime = outboundState.getConfirmedSentTime();
                        if (expired || ctime > 0L && ctime + (long)OB_MESSAGE_TIMEOUT <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.sendConfirmation(outboundState);
                        break;
                    }
                    case OB_STATE_CONFIRMED_COMPLETELY: {
                        if (expired) {
                            this.processExpired(outboundState);
                            break;
                        }
                        this.handleCompletelyEstablished(outboundState);
                        break;
                    }
                    case OB_STATE_PENDING_INTRO: {
                        long itime = outboundState.getIntroSentTime();
                        if (expired || itime > 0L && itime + (long)OB_MESSAGE_TIMEOUT <= now) {
                            this.processExpired(outboundState);
                            break;
                        }
                        if (outboundState.getNextSendTime() > now) break;
                        this.handlePendingIntro(outboundState);
                        break;
                    }
                    case OB_STATE_VALIDATION_FAILED: {
                        this.processExpired(outboundState);
                        break;
                    }
                    default: {
                        if (!this._log.shouldWarn()) break;
                        this._log.warn("Unhandled state on " + outboundState);
                    }
                }
            }
            nextSendTime = now;
        }
        return nextSendTime;
    }

    private void processExpired(OutboundEstablishState outboundState) {
        RemoteHostId claimed;
        boolean removed;
        long nonce = outboundState.getIntroNonce();
        if (nonce >= 0L && (removed = this._liveIntroductions.remove(nonce, outboundState))) {
            if (this._log.shouldDebug()) {
                this._log.debug("RelayRequest for " + outboundState + " timed out");
            }
            this._context.statManager().addRateData("udp.sendIntroRelayTimeout", 1L);
        }
        if ((claimed = outboundState.getClaimedAddress()) != null) {
            this._outboundByClaimedAddress.remove(claimed, outboundState);
        }
        this._outboundByHash.remove(outboundState.getRemoteIdentity().calculateHash(), outboundState);
        this._outboundStates.remove(outboundState.getRemoteHostId(), outboundState);
        if (outboundState.getState() != OutboundEstablishState.OutboundState.OB_STATE_CONFIRMED_COMPLETELY) {
            OutNetMessage msg;
            if (this._log.shouldDebug()) {
                this._log.debug("Session with " + outboundState + " has expired; Lifetime: " + outboundState.getLifetime() + "ms ");
            }
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.failed(msg, "Expired during failed establishment attempt");
            }
            String err = "Took too long to establish Outbound connection, state is " + (Object)((Object)outboundState.getState());
            Hash peer = outboundState.getRemoteIdentity().calculateHash();
            this._transport.markUnreachable(peer);
            this._transport.dropPeer(peer, false, err);
            outboundState.fail();
        } else {
            OutNetMessage msg;
            while ((msg = outboundState.getNextQueuedMessage()) != null) {
                this._transport.send(msg);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processExpired(InboundEstablishState inboundState) {
        OutNetMessage msg;
        RemoteHostId id = inboundState.getRemoteHostId();
        byte[] fromIP = id.getIP();
        if (this._log.shouldInfo() && fromIP != null && !this._context.blocklist().isBlocklisted(fromIP)) {
            this._log.warn("Expired: " + inboundState);
        }
        this._inboundStates.remove(id);
        Long exp = this._context.clock().now() + 900000L;
        Map<RemoteHostId, Long> map = this._inboundBans;
        synchronized (map) {
            this._inboundBans.put(id, exp);
        }
        while ((msg = inboundState.getNextQueuedMessage()) != null) {
            this._transport.failed(msg, "Expired during failed establish");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addOutboundToken(RemoteHostId peer, long token, long expires) {
        byte[] ip;
        long now = this._context.clock().now();
        if (expires < now) {
            return;
        }
        if (expires > now + 120000L && (ip = peer.getIP()) != null && ip.length == 4 && this._transport.isSymNatted()) {
            return;
        }
        Token tok = new Token(token, expires, now);
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.put(peer, tok);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getOutboundToken(RemoteHostId peer) {
        Token tok;
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            tok = this._outboundTokens.remove(peer);
        }
        if (tok == null) {
            return 0L;
        }
        if (tok.getExpiration() < this._context.clock().now()) {
            return 0L;
        }
        return tok.getToken();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ipChanged(boolean isIPv6) {
        Map.Entry<RemoteHostId, Token> e;
        Iterator<Map.Entry<RemoteHostId, Token>> iter;
        if (this._log.shouldWarn()) {
            this._log.warn("[SSU2] IP address changed (" + (isIPv6 ? "IPv6" : "IPv4") + ")");
        }
        int len = isIPv6 ? 16 : 4;
        long now = this._context.clock().now();
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            iter = this._outboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && (long)e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
        map = this._inboundTokens;
        synchronized (map) {
            iter = this._inboundTokens.entrySet().iterator();
            while (iter.hasNext()) {
                e = iter.next();
                if (e.getKey().getIP().length != len && (long)e.getValue().expires >= now) continue;
                iter.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void portChanged() {
        Map<RemoteHostId, Token> map = this._outboundTokens;
        synchronized (map) {
            this._outboundTokens.clear();
        }
        map = this._inboundTokens;
        synchronized (map) {
            this._inboundTokens.clear();
        }
    }

    public Token getInboundToken(RemoteHostId peer) {
        return this.getInboundToken(peer, 3600000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Token getInboundToken(RemoteHostId peer, long expiration) {
        long lifetime;
        Rate r;
        long token;
        while ((token = this._context.random().nextLong()) == 0L) {
        }
        long now = this._context.clock().now();
        RateStat rs = this._context.statManager().getRate("udp.inboundTokenLifetime");
        if (rs != null && (r = rs.getRate(600000L)) != null && (lifetime = (long)(r.getAverageValue() * 0.9)) > 0L) {
            if (lifetime < 120000L) {
                lifetime = 120000L;
            }
            if (lifetime < expiration) {
                expiration = lifetime;
            }
        }
        long expires = now + expiration;
        Token tok = new Token(token, expires, now);
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            Token old = this._inboundTokens.put(peer, tok);
            if (old != null && old.getExpiration() > expires - 120000L) {
                if (this._log.shouldDebug()) {
                    this._log.debug("[SSU2] Resending Inbound " + old + " for " + peer);
                }
                this._inboundTokens.put(peer, old);
                return old;
            }
        }
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Added Inbound " + tok + " for " + peer);
        }
        return tok;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isInboundTokenValid(RemoteHostId peer, long token) {
        boolean rv;
        Token tok;
        if (token == 0L) {
            return false;
        }
        Map<RemoteHostId, Token> map = this._inboundTokens;
        synchronized (map) {
            tok = this._inboundTokens.get(peer);
            if (tok == null) {
                return false;
            }
            if (tok.getToken() != token) {
                return false;
            }
            this._inboundTokens.remove(peer);
        }
        boolean bl = rv = tok.getExpiration() >= this._context.clock().now();
        if (rv && this._log.shouldDebug()) {
            this._log.debug("[SSU2] Using Inbound " + tok + " for " + peer);
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void loadTokens() {
        File f = new File(this._context.getConfigDir(), TOKEN_FILE);
        String ourV4Port = Integer.toString(this._transport.getExternalPort(false));
        String ourV6Port = Integer.toString(this._transport.getExternalPort(true));
        RouterAddress addr = this._transport.getCurrentExternalAddress(false);
        String ourV4Addr = addr != null ? addr.getHost() : null;
        addr = this._transport.getCurrentExternalAddress(true);
        String ourV6Addr = addr != null ? addr.getHost() : null;
        if (this._log.shouldDebug()) {
            this._log.debug("[SSU2] Loading tokens for " + ourV4Addr + ' ' + ourV4Port + ' ' + ourV6Addr + ' ' + ourV6Port);
        }
        InputStream in = null;
        try {
            in = new BufferedInputStream(new FileInputStream(f));
            boolean v4Match = false;
            boolean v6Match = false;
            long now = this._context.clock().now();
            int count = 0;
            Map<RemoteHostId, Token> map = this._inboundTokens;
            synchronized (map) {
                Map<RemoteHostId, Token> map2 = this._outboundTokens;
                synchronized (map2) {
                    String line;
                    while ((line = DataHelper.readLine(in)) != null) {
                        boolean isV6;
                        String[] s;
                        if (line.startsWith("#") || (s = DataHelper.split(line, " ", 5)).length < 3) continue;
                        if (s[0].equals("4")) {
                            v4Match = s[1].equals(ourV4Addr) && s[2].trim().equals(ourV4Port);
                            continue;
                        }
                        if (s[0].equals("6")) {
                            v6Match = s[1].equals(ourV6Addr) && s[2].trim().equals(ourV6Port);
                            continue;
                        }
                        if (!s[0].equals("I") && !s[0].equals("O") || s.length != 5 || (isV6 = s[1].contains(":")) && !v6Match || !isV6 && !v4Match) continue;
                        try {
                            byte[] ip;
                            long exp = Long.parseLong(s[4].trim());
                            if (exp <= now || (ip = Addresses.getIPOnly(s[1])) == null) continue;
                            int port = Integer.parseInt(s[2]);
                            long tok = Long.parseLong(s[3]);
                            RemoteHostId id = new RemoteHostId(ip, port);
                            Token token = new Token(tok, exp, now);
                            if (s[0].equals("I")) {
                                this._inboundTokens.put(id, token);
                            } else {
                                this._outboundTokens.put(id, token);
                            }
                            ++count;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                }
            }
            if (!this._log.shouldDebug()) return;
            this._log.debug("[SSU2] Loaded " + count + " tokens");
            return;
        }
        catch (IOException ioe) {
            if (!this._log.shouldWarn()) return;
            this._log.warn("[SSU2] Failed to load tokens", ioe);
            return;
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException iOException) {}
                f.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTokens() {
        File f = new File(this._context.getConfigDir(), TOKEN_FILE);
        try (PrintWriter out = null;){
            RemoteHostId id;
            long exp;
            Token token;
            ArrayList<Map.Entry<RemoteHostId, Token>> tmp;
            String us;
            out = new PrintWriter(new BufferedWriter(new OutputStreamWriter((OutputStream)new SecureFileOutputStream(f), "UTF-8")));
            out.println("# SSU2 tokens, format: IPv4/IPv6/In/Out Address Port Token Expiration");
            RouterAddress addr = this._transport.getCurrentExternalAddress(false);
            if (addr != null && (us = addr.getHost()) != null) {
                out.println("4 " + us + ' ' + this._transport.getExternalPort(false));
            }
            if ((addr = this._transport.getCurrentExternalAddress(true)) != null && (us = addr.getHost()) != null) {
                out.println("6 " + us + ' ' + this._transport.getExternalPort(true));
            }
            long now = this._context.clock().now();
            int count = 0;
            TokenComparator comp = new TokenComparator();
            Object object = this._inboundTokens;
            synchronized (object) {
                tmp = new ArrayList<Map.Entry<RemoteHostId, Token>>(this._inboundTokens.entrySet());
            }
            Collections.sort(tmp, comp);
            for (Map.Entry entry : tmp) {
                token = (Token)entry.getValue();
                exp = token.getExpiration();
                if (exp <= now) continue;
                id = (RemoteHostId)entry.getKey();
                out.println("I " + Addresses.toString(id.getIP()) + ' ' + id.getPort() + ' ' + token.getToken() + ' ' + exp);
                ++count;
            }
            tmp.clear();
            object = this._outboundTokens;
            synchronized (object) {
                tmp.addAll(this._outboundTokens.entrySet());
            }
            Collections.sort(tmp, comp);
            for (Map.Entry entry : tmp) {
                token = (Token)entry.getValue();
                exp = token.getExpiration();
                if (exp <= now) continue;
                id = (RemoteHostId)entry.getKey();
                out.println("O " + Addresses.toString(id.getIP()) + ' ' + id.getPort() + ' ' + token.getToken() + ' ' + exp);
                ++count;
            }
            if (out.checkError()) {
                throw new IOException("Failed write SSUS2 tokens to: " + f);
            }
            if (this._log.shouldDebug()) {
                this._log.debug("[SSU2] Stored " + count + " tokens to " + f);
            }
        }
    }

    public static String parseReason(int reasonCode) {
        switch (reasonCode) {
            case 0: {
                return "Unspecified";
            }
            case 1: {
                return "Termination";
            }
            case 2: {
                return "Timeout";
            }
            case 3: {
                return "Shutdown";
            }
            case 4: {
                return "AEAD error";
            }
            case 5: {
                return "Options error";
            }
            case 6: {
                return "Signature type error";
            }
            case 7: {
                return "Excessive clock skew";
            }
            case 8: {
                return "Padding error";
            }
            case 9: {
                return "Framing error";
            }
            case 10: {
                return "Payload error";
            }
            case 11: {
                return "Message #1 error";
            }
            case 12: {
                return "Message #2 error";
            }
            case 13: {
                return "Message #3 error";
            }
            case 14: {
                return "Frame Timeout";
            }
            case 15: {
                return "Signature error";
            }
            case 16: {
                return "S Mismatch";
            }
            case 17: {
                return "Router is banned";
            }
            case 18: {
                return "Token error";
            }
            case 19: {
                return "Limit reached";
            }
            case 20: {
                return "Incompatible Version";
            }
            case 21: {
                return "BAD NetId";
            }
            case 22: {
                return "Replaced connection";
            }
        }
        return "Unknown error";
    }

    private class Establisher
    implements Runnable {
        private long _lastFailsafe;
        private static final long FAILSAFE_INTERVAL = 180000L;
        private long _lastPrinted;
        private static final long PRINT_INTERVAL = 5000L;

        private Establisher() {
        }

        @Override
        public void run() {
            while (EstablishmentManager.this._alive) {
                try {
                    this.doPass();
                }
                catch (RuntimeException re) {
                    if (re.toString().contains("unsupported address type")) {
                        if (EstablishmentManager.this._log.shouldWarn()) {
                            EstablishmentManager.this._log.warn("Error in the establisher: Unsupported address type (localhost?)");
                        }
                    } else {
                        EstablishmentManager.this._log.error("Error in the establisher", re);
                    }
                    try {
                        Thread.sleep(500L);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            EstablishmentManager.this._inboundStates.clear();
            EstablishmentManager.this._outboundStates.clear();
            EstablishmentManager.this._queuedOutbound.clear();
            EstablishmentManager.this._outboundByClaimedAddress.clear();
            EstablishmentManager.this._outboundByHash.clear();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doPass() {
            long nextSendTime;
            long delay;
            long now = EstablishmentManager.this._context.clock().now();
            if (EstablishmentManager.this._log.shouldDebug() && this._lastPrinted + 5000L < now) {
                this._lastPrinted = now;
                int iactive = EstablishmentManager.this._inboundStates.size();
                int oactive = EstablishmentManager.this._outboundStates.size();
                if (iactive > 0 || oactive > 0) {
                    int queued = EstablishmentManager.this._queuedOutbound.size();
                    int live = EstablishmentManager.this._liveIntroductions.size();
                    int claimed = EstablishmentManager.this._outboundByClaimedAddress.size();
                    int hash = EstablishmentManager.this._outboundByHash.size();
                    EstablishmentManager.this._log.debug("Inbound states [" + iactive + "] * Outbound states [" + oactive + "] -> Queued: " + queued + "; Intros: " + live + "; Claimed: " + claimed + "; Hash: " + hash);
                }
            }
            EstablishmentManager.this._activity = 0;
            if (this._lastFailsafe + 180000L < now) {
                this._lastFailsafe = now;
                this.doFailsafe(now);
            }
            if ((delay = (nextSendTime = Math.min(EstablishmentManager.this.handleInbound(), EstablishmentManager.this.handleOutbound())) - now) > 0L) {
                if (delay > 1000L) {
                    delay = 1000L;
                }
                try {
                    Object object = EstablishmentManager.this._activityLock;
                    synchronized (object) {
                        if (EstablishmentManager.this._activity > 0) {
                            return;
                        }
                        EstablishmentManager.this._activityLock.wait(delay);
                    }
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void doFailsafe(long now) {
            OutboundEstablishState state;
            Iterator iter = EstablishmentManager.this._liveIntroductions.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= (long)(3 * MAX_OB_ESTABLISH_TIME)) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldWarn()) continue;
                EstablishmentManager.this._log.warn("Failsafe removal of LiveIntroduction: " + state);
            }
            iter = EstablishmentManager.this._outboundByClaimedAddress.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= (long)(3 * MAX_OB_ESTABLISH_TIME)) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldWarn()) continue;
                EstablishmentManager.this._log.warn("Failsafe removal of OutboundByClaimedAddress: " + state);
            }
            iter = EstablishmentManager.this._outboundByHash.values().iterator();
            while (iter.hasNext()) {
                state = (OutboundEstablishState)iter.next();
                if (state.getLifetime(now) <= (long)(3 * MAX_OB_ESTABLISH_TIME)) continue;
                iter.remove();
                if (!EstablishmentManager.this._log.shouldWarn()) continue;
                EstablishmentManager.this._log.warn("Failsafe removal of OutboundByHash: " + state);
            }
            if (EstablishmentManager.this._inboundTokens != null) {
                Token tok;
                Iterator iter2;
                int count = 0;
                Map map = EstablishmentManager.this._inboundTokens;
                synchronized (map) {
                    iter2 = EstablishmentManager.this._inboundTokens.values().iterator();
                    while (iter2.hasNext()) {
                        tok = (Token)iter2.next();
                        if (tok.getExpiration() >= now) continue;
                        iter2.remove();
                        ++count;
                    }
                }
                if (count > 0 && EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("Expired " + count + " inbound tokens");
                }
                count = 0;
                map = EstablishmentManager.this._outboundTokens;
                synchronized (map) {
                    iter2 = EstablishmentManager.this._outboundTokens.values().iterator();
                    while (iter2.hasNext()) {
                        tok = (Token)iter2.next();
                        if (tok.getExpiration() >= now) continue;
                        iter2.remove();
                        ++count;
                    }
                }
                if (count > 0 && EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("Expired " + count + " outbound tokens");
                }
                EstablishmentManager.this._terminationCounter.clear();
                EstablishmentManager.this._transport.getIntroManager().cleanup();
            }
        }
    }

    private static class HPCallback
    implements SSU2Payload.PayloadCallback {
        private final RemoteHostId _from;
        public long _timeReceived;
        public byte[] _aliceIP;
        public int _alicePort;
        public int _respCode = 999;
        public byte[] _respData;

        public HPCallback(RemoteHostId from) {
            this._from = from;
        }

        @Override
        public void gotDateTime(long time) {
            this._timeReceived = time;
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
        }

        @Override
        public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotAddress(byte[] ip, int port) {
            this._aliceIP = ip;
            this._alicePort = port;
        }

        @Override
        public void gotRelayTagRequest() {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotRelayTag(long tag) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotRelayRequest(byte[] data) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotRelayResponse(int status, byte[] data) {
            this._respCode = status;
            this._respData = data;
        }

        @Override
        public void gotRelayIntro(Hash aliceHash, byte[] data) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotToken(long token, long expires) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotI2NP(I2NPMessage msg) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotACK(long ackThru, int acks, byte[] ranges) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotTermination(int reason, long count) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotPathChallenge(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in HolePunch");
        }

        @Override
        public void gotPathResponse(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in HolePunch");
        }
    }

    private class InboundTokens
    extends LHMCache<RemoteHostId, Token> {
        public InboundTokens(int max) {
            super(max);
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<RemoteHostId, Token> eldest) {
            boolean rv = super.removeEldestEntry(eldest);
            if (rv) {
                long lifetime = EstablishmentManager.this._context.clock().now() - eldest.getValue().getWhenAdded();
                EstablishmentManager.this._context.statManager().addRateData("udp.inboundTokenLifetime", lifetime);
                if (EstablishmentManager.this._log.shouldDebug()) {
                    EstablishmentManager.this._log.debug("[SSU2] Removed oldest Inbound " + eldest.getValue() + " for " + eldest.getKey());
                }
            }
            return rv;
        }
    }

    private static class TokenComparator
    implements Comparator<Map.Entry<RemoteHostId, Token>> {
        private TokenComparator() {
        }

        @Override
        public int compare(Map.Entry<RemoteHostId, Token> l, Map.Entry<RemoteHostId, Token> r) {
            long re;
            long le = l.getValue().expires;
            if (le < (re = (long)r.getValue().expires)) {
                return -1;
            }
            if (le > re) {
                return 1;
            }
            return 0;
        }
    }

    public static class Token {
        private final long token;
        private final int expires;
        private final int added;

        public Token(long tok, long exp, long now) {
            this.token = tok;
            this.expires = (int)(exp >> 10);
            this.added = (int)(now >> 10);
        }

        public long getToken() {
            return this.token;
        }

        public long getExpiration() {
            return ((long)this.expires & 0xFFFFFFFFL) << 10;
        }

        public long getWhenAdded() {
            return ((long)this.added & 0xFFFFFFFFL) << 10;
        }

        public String toString() {
            return "Token [" + this.token + "]\n* Added: " + DataHelper.formatTime(this.getWhenAdded()) + "\n* Expires: " + DataHelper.formatTime(this.getExpiration());
        }
    }
}

