/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import net.i2p.data.ByteArray;
import net.i2p.data.DataFormatException;
import net.i2p.data.Hash;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.ACKBitfield;
import net.i2p.router.util.CDQEntry;
import net.i2p.util.ByteCache;
import net.i2p.util.Log;

class InboundMessageState
implements CDQEntry {
    private final RouterContext _context;
    private final Log _log;
    private final long _messageId;
    private final Hash _from;
    private final ByteArray[] _fragments;
    private int _lastFragment;
    private final long _receiveBegin;
    private long _enqueueTime;
    private int _completeSize;
    private boolean _released;
    private static final long MAX_RECEIVE_TIME = 10000L;
    public static final int MAX_FRAGMENTS = 64;
    public static final int MAX_PARTIAL_BITFIELD_BYTES = 10;
    private static final int MAX_FRAGMENT_SIZE = 1572;
    private static final ByteCache _fragmentCache = ByteCache.getInstance(64, 1572);

    public InboundMessageState(RouterContext ctx, long messageId, Hash from) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageState.class);
        this._messageId = messageId;
        this._from = from;
        this._fragments = new ByteArray[64];
        this._lastFragment = -1;
        this._completeSize = -1;
        this._receiveBegin = ctx.clock().now();
    }

    public InboundMessageState(RouterContext ctx, long messageId, Hash from, byte[] data, int off, int len, int fragmentNum, boolean isLast) throws DataFormatException {
        this._context = ctx;
        this._log = ctx.logManager().getLog(InboundMessageState.class);
        this._messageId = messageId;
        this._from = from;
        if (isLast) {
            if (fragmentNum > 64) {
                throw new DataFormatException("corrupt - too many fragments: " + fragmentNum);
            }
            this._fragments = new ByteArray[fragmentNum + 1];
        } else {
            this._fragments = new ByteArray[64];
        }
        this._lastFragment = -1;
        this._completeSize = -1;
        this._receiveBegin = ctx.clock().now();
        if (!this.receiveFragment(data, off, len, fragmentNum, isLast)) {
            throw new DataFormatException("corrupt");
        }
    }

    public boolean receiveFragment(byte[] data, int off, int len, int fragmentNum, boolean isLast) throws DataFormatException {
        if (fragmentNum >= this._fragments.length) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid fragment " + fragmentNum + '/' + this._fragments.length);
            }
            return false;
        }
        if (this._fragments[fragmentNum] == null) {
            ByteArray message = (ByteArray)_fragmentCache.acquire();
            System.arraycopy(data, off, message.getData(), 0, len);
            message.setValid(len);
            this._fragments[fragmentNum] = message;
            if (isLast) {
                if (this._lastFragment >= 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Multiple last fragments for message " + this._messageId + " from " + this._from);
                    }
                    return false;
                }
                this._lastFragment = fragmentNum;
            } else if (this._lastFragment >= 0 && fragmentNum >= this._lastFragment) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Non-last fragment " + fragmentNum + " when last is " + this._lastFragment + " for message " + this._messageId + " from " + this._from);
                }
                return false;
            }
            if (this._log.shouldDebug()) {
                this._log.debug("New fragment " + fragmentNum + " for message " + this._messageId + ", size=" + len + ", isLast=" + isLast);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Received fragment " + fragmentNum + " for message " + this._messageId + " again, old size=" + this._fragments[fragmentNum].getValid() + " and new size=" + len);
        }
        return true;
    }

    public boolean hasFragment(int fragmentNum) {
        if (fragmentNum >= this._fragments.length) {
            return false;
        }
        return this._fragments[fragmentNum] != null;
    }

    public boolean isComplete() {
        int last = this._lastFragment;
        if (last < 0) {
            return false;
        }
        for (int i = 0; i <= last; ++i) {
            if (this._fragments[i] != null) continue;
            return false;
        }
        return true;
    }

    public boolean isExpired() {
        return this._context.clock().now() > this._receiveBegin + 10000L;
    }

    public long getLifetime() {
        return this._context.clock().now() - this._receiveBegin;
    }

    @Override
    public void setEnqueueTime(long now) {
        this._enqueueTime = now;
    }

    @Override
    public long getEnqueueTime() {
        return this._enqueueTime;
    }

    @Override
    public void drop() {
        this.releaseResources();
    }

    public Hash getFrom() {
        return this._from;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public int getCompleteSize() {
        if (this._completeSize < 0) {
            if (this._lastFragment < 0) {
                throw new IllegalStateException("Last fragment not set");
            }
            if (this._released) {
                throw new IllegalStateException("SSU IMS 2 Use after free");
            }
            int size = 0;
            for (int i = 0; i <= this._lastFragment; ++i) {
                ByteArray frag = this._fragments[i];
                if (frag == null) {
                    throw new IllegalStateException("null fragment " + i + '/' + this._lastFragment);
                }
                size += frag.getValid();
            }
            this._completeSize = size;
        }
        return this._completeSize;
    }

    public ACKBitfield createACKBitfield() {
        int last = this._lastFragment;
        int sz = last >= 0 ? last + 1 : this._fragments.length;
        return new PartialBitfield(this._messageId, this._fragments, sz);
    }

    public void releaseResources() {
        this._released = true;
        for (int i = 0; i < this._fragments.length; ++i) {
            if (this._fragments[i] == null) continue;
            _fragmentCache.release(this._fragments[i]);
            this._fragments[i] = null;
        }
    }

    public ByteArray[] getFragments() {
        if (this._released) {
            IllegalStateException e = new IllegalStateException("Use after free: " + this._messageId);
            this._log.error("SSU IMS", e);
            throw e;
        }
        return this._fragments;
    }

    public int getFragmentCount() {
        return this._lastFragment + 1;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(256);
        buf.append("\n* Inbound Message: ").append(this._messageId);
        buf.append(" from [").append(this._from.toString().substring(0, 6)).append("]");
        if (this.isComplete()) {
            buf.append(" completely received with ");
            buf.append(this._completeSize).append(" bytes in ");
            buf.append(this._lastFragment + 1).append(" fragments");
        } else {
            for (int i = 0; i <= this._lastFragment; ++i) {
                buf.append(" fragment ").append(i);
                ByteArray ba = this._fragments[i];
                if (ba != null) {
                    buf.append(": known at size ").append(ba.getValid());
                    continue;
                }
                buf.append(": unknown");
            }
        }
        buf.append(" (Lifetime: ").append(this.getLifetime()).append("ms)");
        return buf.toString();
    }

    private static final class PartialBitfield
    implements ACKBitfield {
        private final long _bitfieldMessageId;
        private final int _fragmentCount;
        private final int _ackCount;
        private final int _highestReceived;
        private final long _fragmentAcks;

        public PartialBitfield(long messageId, Object[] data, int size) {
            if (size > 64) {
                throw new IllegalArgumentException();
            }
            this._bitfieldMessageId = messageId;
            int ackCount = 0;
            int highestReceived = -1;
            long acks = 0L;
            for (int i = 0; i < size; ++i) {
                if (data[i] == null) continue;
                acks |= PartialBitfield.mask(i);
                ++ackCount;
                highestReceived = i;
            }
            this._fragmentAcks = acks;
            this._fragmentCount = size;
            this._ackCount = ackCount;
            this._highestReceived = highestReceived;
        }

        private static long mask(int fragment) {
            return 1L << fragment;
        }

        @Override
        public int fragmentCount() {
            return this._fragmentCount;
        }

        @Override
        public int ackCount() {
            return this._ackCount;
        }

        @Override
        public int highestReceived() {
            return this._highestReceived;
        }

        @Override
        public long getMessageId() {
            return this._bitfieldMessageId;
        }

        @Override
        public boolean received(int fragmentNum) {
            if (fragmentNum < 0 || fragmentNum > this._highestReceived) {
                return false;
            }
            return (this._fragmentAcks & PartialBitfield.mask(fragmentNum)) != 0L;
        }

        @Override
        public boolean receivedComplete() {
            return this._ackCount == this._fragmentCount;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(64);
            buf.append("Outbound Partial ACK of [");
            buf.append(this._bitfieldMessageId);
            buf.append("] Highest: ").append(this._highestReceived);
            buf.append(" with ").append(this._ackCount).append(" ACKs for fragments [");
            for (int i = 0; i <= this._highestReceived; ++i) {
                if (!this.received(i)) continue;
                buf.append(i).append(' ');
            }
            buf.append(" / ").append(this._highestReceived + 1).append("]");
            return buf.toString();
        }
    }
}

