/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.concurrent.BlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.udp.EstablishmentManager;
import net.i2p.router.transport.udp.InboundEstablishState;
import net.i2p.router.transport.udp.InboundEstablishState2;
import net.i2p.router.transport.udp.InboundMessageFragments;
import net.i2p.router.transport.udp.IntroductionManager;
import net.i2p.router.transport.udp.OutboundEstablishState;
import net.i2p.router.transport.udp.OutboundEstablishState2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerStateDestroyed;
import net.i2p.router.transport.udp.PeerTestManager;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Header;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class PacketHandler {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final EstablishmentManager _establisher;
    private final PeerTestManager _testManager;
    private volatile boolean _keepReading;
    private final Handler[] _handlers;
    private final BlockingQueue<UDPPacket> _inboundQueue;
    private final int _networkID;
    private static final int TYPE_POISON = -99999;
    private static final int MIN_QUEUE_SIZE = SystemVersion.isSlow() ? 32 : 64;
    private static final int MAX_QUEUE_SIZE = SystemVersion.isSlow() ? 192 : 384;
    private static final int MIN_NUM_HANDLERS = 1;
    private static final int MAX_NUM_HANDLERS = SystemVersion.isSlow() ? 2 : 4;

    PacketHandler(RouterContext ctx, UDPTransport transport, EstablishmentManager establisher, InboundMessageFragments inbound, PeerTestManager testManager, IntroductionManager introManager) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(PacketHandler.class);
        this._transport = transport;
        this._establisher = establisher;
        this._testManager = testManager;
        this._networkID = ctx.router().getNetworkID();
        long maxMemory = SystemVersion.getMaxMemory();
        int cores = SystemVersion.getCores();
        boolean isSlow = SystemVersion.isSlow();
        int qsize = (int)Math.max((long)MIN_QUEUE_SIZE, Math.min((long)MAX_QUEUE_SIZE, maxMemory / 0x200000L));
        this._inboundQueue = new CoDelBlockingQueue<UDPPacket>(ctx, "UDP-Receiver", qsize);
        int num_handlers = maxMemory < 0x8000000L ? 1 : MAX_NUM_HANDLERS;
        this._handlers = new Handler[num_handlers];
        for (int i = 0; i < num_handlers; ++i) {
            this._handlers[i] = new Handler();
        }
        this._context.statManager().createRateStat("udp.destroyedInvalidSkew", "Session destroyed (bad skew)", "Transport [UDP]", UDPTransport.RATES);
    }

    public synchronized void startup() {
        this._keepReading = true;
        for (int i = 0; i < this._handlers.length; ++i) {
            I2PThread t = new I2PThread(this._handlers[i], "UDPPktHandler " + (i + 1) + '/' + this._handlers.length, true);
            t.setPriority(10);
            t.start();
        }
    }

    public synchronized void shutdown() {
        this._keepReading = false;
        this.stopQueue();
    }

    String getHandlerStatus() {
        StringBuilder rv = new StringBuilder();
        rv.append("Handlers: ").append(this._handlers.length);
        for (int i = 0; i < this._handlers.length; ++i) {
            Handler handler = this._handlers[i];
            rv.append(" handler ").append(i);
        }
        return rv.toString();
    }

    public void queueReceived(UDPPacket packet) throws InterruptedException {
        if (this._log.shouldDebug()) {
            this._log.debug("Adding packet to queue: " + packet);
        }
        this._inboundQueue.put(packet);
    }

    private void stopQueue() {
        int i;
        this._inboundQueue.clear();
        for (i = 0; i < this._handlers.length; ++i) {
            UDPPacket poison = UDPPacket.acquire(this._context, false);
            poison.setMessageType(-99999);
            this._inboundQueue.offer(poison);
        }
        for (i = 1; i <= 5 && !this._inboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 50);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._inboundQueue.clear();
    }

    public UDPPacket receiveNext() {
        UDPPacket rv = null;
        while (this._keepReading && rv == null) {
            try {
                rv = this._inboundQueue.take();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            if (rv == null || rv.getMessageType() != -99999) continue;
            return null;
        }
        return rv;
    }

    private boolean receiveSSU2Packet(RemoteHostId from, UDPPacket packet, InboundEstablishState2 state) {
        int type;
        SSU2Header.Header header;
        byte[] k1 = this._transport.getSSU2StaticIntroKey();
        boolean shouldBan = false;
        if (state == null) {
            byte[] k2 = k1;
            header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
            if (header == null || header.getType() != 0 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                if (header != null && this._log.shouldInfo()) {
                    this._log.info("Packet does not decrypt as Session Request, attempting to decrypt as Token Request / PeerTest / HolePunch \n* " + header + " from " + from);
                }
                if ((header = SSU2Header.trialDecryptLongHeader(packet, k1, k2)) == null || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                    if (header != null) {
                        long id = header.getDestConnID();
                        PeerState2 ps2 = this._transport.getPeerState(id);
                        if (ps2 != null) {
                            if (this._log.shouldInfo()) {
                                this._log.info("Migrated " + packet.getPacket().getLength() + " byte packet from " + from + ps2);
                            }
                            ps2.receivePacket(from, packet);
                            return true;
                        }
                        PeerStateDestroyed dead = this._transport.getRecentlyClosed(id);
                        if (dead != null) {
                            if (this._log.shouldDebug()) {
                                this._log.debug("Handling " + packet.getPacket().getLength() + " byte packet from " + from + " for recently closed ID " + id);
                            }
                            dead.receivePacket(from, packet);
                            return true;
                        }
                    }
                    return false;
                }
                type = header.getType();
                if (type == 2) {
                    return false;
                }
                if (type == 0 && packet.getPacket().getLength() == SSU2Util.MIN_HANDSHAKE_DATA_LEN - 1) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received short Session Request (87 bytes) from " + from);
                    }
                    shouldBan = true;
                    return true;
                }
            } else {
                type = 0;
            }
        } else {
            byte[] k2 = state.getRcvHeaderEncryptKey2();
            if (k2 == null) {
                k2 = k1;
                header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
                if (header == null || header.getType() != 0 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                    header = SSU2Header.trialDecryptLongHeader(packet, k1, k2);
                    if (header != null && header.getType() == 0 && header.getVersion() == 2 && header.getNetID() == this._networkID && packet.getPacket().getLength() == 87) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Received short Session Request (87 bytes) after Retry on " + state);
                        }
                        shouldBan = true;
                        return true;
                    }
                    if (header == null || header.getType() != 10 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Failed to decrypt Session or Token Request after Retry \n* " + header + " (" + packet.getPacket().getLength() + " bytes) on " + state);
                        }
                        shouldBan = true;
                        return false;
                    }
                }
                if (header.getSrcConnID() != state.getSendConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received BAD Source Connection ID \n* " + header + " (" + packet.getPacket().getLength() + " bytes) on " + state);
                    }
                    shouldBan = true;
                    return false;
                }
                if (header.getDestConnID() != state.getRcvConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received BAD Destination Connection ID \n* " + header + " (" + packet.getPacket().getLength() + " bytes) on " + state);
                    }
                    shouldBan = true;
                    return true;
                }
                type = header.getType();
            } else {
                header = SSU2Header.trialDecryptShortHeader(packet, k1, k2);
                if (header == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received SessionConfirmed packet was too short (" + packet.getPacket().getLength() + " bytes) on " + state);
                    }
                    shouldBan = true;
                    return false;
                }
                if (header.getDestConnID() != state.getRcvConnID()) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received BAD Destination Connection ID \n* " + header + " on " + state);
                    }
                    shouldBan = true;
                    return false;
                }
                if (header.getPacketNumber() != 0L || header.getType() != 2) {
                    if (this._log.shouldInfo()) {
                        this._log.info("Queueing possible data packet (" + packet.getPacket().getLength() + " bytes) on: " + state);
                    }
                    state.queuePossibleDataPacket(packet);
                    return true;
                }
                type = 2;
            }
        }
        SSU2Header.acceptTrialDecrypt(packet, header);
        switch (type) {
            case 0: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Received a SessionRequest on " + state);
                }
                this._establisher.receiveSessionOrTokenRequest(from, state, packet);
                break;
            }
            case 10: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Received a TokenRequest on " + state);
                }
                this._establisher.receiveSessionOrTokenRequest(from, state, packet);
                break;
            }
            case 2: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Received a SessionConfirmed on " + state);
                }
                this._establisher.receiveSessionConfirmed(state, packet);
                break;
            }
            case 7: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Received a PeerTest from " + from);
                }
                this._testManager.receiveTest(from, packet);
                break;
            }
            case 11: {
                if (this._log.shouldDebug()) {
                    this._log.debug("Received a HolePunch from " + from);
                }
                this._establisher.receiveHolePunch(from, packet);
                break;
            }
            default: {
                if (!this._log.shouldWarn()) break;
                this._log.warn("Received UNKNOWN SSU2 message \n* " + header + " from " + from);
            }
        }
        return true;
    }

    private boolean receiveSSU2Packet(UDPPacket packet, OutboundEstablishState2 state) {
        int type;
        SSU2Header.Header header;
        byte[] k1 = state.getRcvHeaderEncryptKey1();
        byte[] k2 = state.getRcvHeaderEncryptKey2();
        if (k2 != null) {
            header = SSU2Header.trialDecryptHandshakeHeader(packet, k1, k2);
            if (header != null && header.getDestConnID() != state.getRcvConnID()) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Received BAD Destination Connection ID \n* " + header);
                }
                return false;
            }
        } else {
            header = null;
        }
        if (header == null || header.getType() != 1 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
            if (this._log.shouldInfo()) {
                this._log.info("Packet does not decrypt as SessionCreated, attempting to decrypt as Retry" + (header != null ? "\n* " + header : ""));
            }
            if ((header = SSU2Header.trialDecryptLongHeader(packet, k1, k2 = state.getRcvRetryHeaderEncryptKey2())) == null || header.getType() != 9 || header.getVersion() != 2 || header.getNetID() != this._networkID) {
                if (this._log.shouldInfo()) {
                    this._log.info("Packet does not decrypt as SessionCreated or Retry \n* " + header + " on " + state);
                }
                return false;
            }
            type = 9;
        } else {
            type = 1;
        }
        if (header.getDestConnID() != state.getRcvConnID()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received BAD Destination Connection ID \n* " + header);
            }
            return false;
        }
        if (header.getSrcConnID() != state.getSendConnID()) {
            if (this._log.shouldWarn()) {
                this._log.warn("Received BAD Source Connection ID \n* " + header);
            }
            return false;
        }
        SSU2Header.acceptTrialDecrypt(packet, header);
        if (type == 1) {
            if (this._log.shouldDebug()) {
                this._log.debug("Received a SessionCreated on " + state);
            }
            this._establisher.receiveSessionCreated(state, packet);
        } else {
            if (this._log.shouldDebug()) {
                this._log.debug("Received a Retry on " + state);
            }
            this._establisher.receiveRetry(state, packet);
        }
        return true;
    }

    private class Handler
    implements Runnable {
        private Handler() {
        }

        @Override
        public void run() {
            UDPPacket packet;
            while (PacketHandler.this._keepReading && (packet = PacketHandler.this.receiveNext()) != null) {
                block4: {
                    packet.received();
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Received packet from " + packet);
                    }
                    try {
                        this.handlePacket(packet);
                    }
                    catch (RuntimeException e) {
                        if (!PacketHandler.this._log.shouldError()) break block4;
                        PacketHandler.this._log.error("Internal error handling a UDP packet from " + packet, e);
                    }
                }
                packet.release();
            }
        }

        private void handlePacket(UDPPacket packet) {
            RemoteHostId rem = packet.getRemoteHost();
            PeerState state = PacketHandler.this._transport.getPeerState(rem);
            if (state == null) {
                InboundEstablishState est = PacketHandler.this._establisher.getInboundState(rem);
                if (est != null) {
                    if (PacketHandler.this._log.shouldDebug()) {
                        PacketHandler.this._log.debug("Packet received IS for an Inbound establishment");
                    }
                    PacketHandler.this.receiveSSU2Packet(rem, packet, (InboundEstablishState2)est);
                } else {
                    OutboundEstablishState oest = PacketHandler.this._establisher.getOutboundState(rem);
                    if (oest != null) {
                        if (PacketHandler.this._log.shouldDebug()) {
                            PacketHandler.this._log.debug("Packet received IS for an Outbound establishment");
                        }
                        PacketHandler.this.receiveSSU2Packet(packet, (OutboundEstablishState2)oest);
                    } else {
                        if (PacketHandler.this._log.shouldDebug()) {
                            PacketHandler.this._log.debug("Packet received is not for an Inbound or Outbound establishment");
                        }
                        PacketHandler.this.receiveSSU2Packet(rem, packet, null);
                    }
                }
            } else {
                ((PeerState2)state).receivePacket(rem, packet);
            }
        }
    }
}

