/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import com.southernstorm.noise.protocol.ChaChaPolyCipherState;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.data.Base64;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.SigningPrivateKey;
import net.i2p.data.SigningPublicKey;
import net.i2p.data.i2np.DatabaseStoreMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.router.RouterAddress;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.transport.udp.IPThrottler;
import net.i2p.router.transport.udp.PacketBuilder2;
import net.i2p.router.transport.udp.PeerState;
import net.i2p.router.transport.udp.PeerState2;
import net.i2p.router.transport.udp.PeerTestState;
import net.i2p.router.transport.udp.RemoteHostId;
import net.i2p.router.transport.udp.SSU2Payload;
import net.i2p.router.transport.udp.SSU2Util;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.transport.udp.UDPTransport;
import net.i2p.util.Addresses;
import net.i2p.util.HexDump;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer2;

class PeerTestManager {
    private final RouterContext _context;
    private final Log _log;
    private final UDPTransport _transport;
    private final PacketBuilder2 _packetBuilder2;
    private final Map<Long, PeerTestState> _activeTests;
    private PeerTestState _currentTest;
    private boolean _currentTestComplete;
    private final Queue<Long> _recentTests;
    private final IPThrottler _throttle;
    private static final int MAX_RELAYED_PER_TEST_ALICE = 9;
    private static final int MAX_RELAYED_PER_TEST_BOB = 6;
    private static final int MAX_RELAYED_PER_TEST_CHARLIE = 6;
    private static final int MAX_CHARLIE_LIFETIME = 15000;
    private static final int MAX_BOB_LIFETIME = 10000;
    private static final int MAX_ACTIVE_TESTS = 20;
    private static final int MAX_RECENT_TESTS = 40;
    private static final int MAX_PER_IP = 12;
    private static final long THROTTLE_CLEAN_TIME = 600000L;
    private static final int RESEND_TIMEOUT = 4000;
    private static final int MAX_TEST_TIME = 20000;
    private static final long MAX_SKEW = 120000L;
    private static final long MAX_NONCE = 0xFFFFFFFFL;
    private static final InetAddress PENDING_IP;
    private static final int PENDING_PORT = 99999;
    private static final boolean ENABLE_SSU2_SYMNAT_TEST = true;
    private static final long CHARLIE_RECENT_PERIOD = 600000L;

    public PeerTestManager(RouterContext context, UDPTransport transport) {
        this._context = context;
        this._transport = transport;
        this._log = context.logManager().getLog(PeerTestManager.class);
        this._activeTests = new ConcurrentHashMap<Long, PeerTestState>();
        this._recentTests = new LinkedBlockingQueue<Long>();
        this._packetBuilder2 = transport.getBuilder2();
        this._throttle = new IPThrottler(12, 600000L);
        this._context.statManager().createRateStat("udp.testBadIP", "Received IP or port was bad", "Transport [UDP]", UDPTransport.RATES);
    }

    public synchronized boolean runTest(PeerState bob) {
        int testPort;
        byte[] testIP;
        if (this._currentTest != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("We are already running a test: " + this._currentTest + ", aborting test with Bob [" + bob + "]");
            }
            return false;
        }
        InetAddress bobIP = bob.getRemoteIPAddress();
        if (this._transport.isTooClose(bobIP.getAddress())) {
            if (this._log.shouldWarn()) {
                this._log.warn("Not running test with Bob too close to us [" + bobIP + "]");
            }
            return false;
        }
        PeerTestState test = new PeerTestState(PeerTestState.Role.ALICE, bob, bobIP instanceof Inet6Address, this._context.random().nextLong(0xFFFFFFFFL), this._context.clock().now());
        if (!(bob instanceof PeerState2)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bob is not an instance of PeerState2, cannot proceed with the test.");
            }
            return false;
        }
        PeerState2 b2 = (PeerState2)bob;
        boolean ipv6 = b2.isIPv6();
        byte[] ourIP = b2.getOurIP();
        int ourPort = b2.getOurPort();
        RouterAddress ra = this._transport.getCurrentExternalAddress(ipv6);
        if (!(ra == null || (testIP = ra.getIP()) == null || ourPort == (testPort = ra.getPort()) && DataHelper.eq(ourIP, testIP))) {
            if (this._log.shouldWarn()) {
                this._log.warn("Test IP mismatch: " + Addresses.toString(testIP, testPort) + ", ours with Bob: " + Addresses.toString(ourIP, ourPort) + " on " + test);
            }
            ourIP = testIP;
            ourPort = testPort;
        }
        try {
            InetAddress addr = InetAddress.getByAddress(ourIP);
            test.setAlice(addr, ourPort, this._context.routerHash());
        }
        catch (UnknownHostException uhe) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unable to get our IP", uhe);
            }
            return false;
        }
        this._currentTest = test;
        this._currentTestComplete = false;
        if (this._log.shouldDebug()) {
            this._log.debug("Start new test: " + test);
        }
        while (this._recentTests.size() > 40) {
            this._recentTests.poll();
        }
        this._recentTests.offer(test.getNonce());
        test.incrementPacketsRelayed();
        this.sendTestToBob();
        new ContinueTest(test.getNonce());
        return true;
    }

    private boolean expired() {
        PeerTestState state = this._currentTest;
        if (state != null) {
            return state.getBeginTime() + 20000L < this._context.clock().now();
        }
        return true;
    }

    private void sendTestToBob() {
        PeerTestState test = this._currentTest;
        if (!this.expired()) {
            UDPPacket packet;
            if (this._log.shouldDebug()) {
                this._log.debug("Sending test to Bob: " + test);
            }
            PeerState bob = test.getBob();
            PeerState2 bob2 = (PeerState2)bob;
            byte[] data = test.getTestData();
            if (data == null) {
                SigningPrivateKey spk = this._context.keyManager().getSigningPrivateKey();
                data = SSU2Util.createPeerTestData(this._context, bob2.getRemotePeer(), null, PeerTestState.Role.ALICE, test.getNonce(), test.getAliceIP().getAddress(), test.getAlicePort(), spk);
                if (data == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("sig fail");
                    }
                    this.testComplete();
                    return;
                }
                test.setTestData(data);
            }
            try {
                packet = this._packetBuilder2.buildPeerTestFromAlice(data, bob2);
            }
            catch (IOException ioe) {
                this.fail();
                return;
            }
            this._transport.send(packet);
            long now = this._context.clock().now();
            test.setLastSendTime(now);
            bob.setLastSendTime(now);
        } else {
            this._currentTest = null;
        }
    }

    private void sendTestToCharlie() {
        PeerTestState test = this._currentTest;
        if (test == null) {
            return;
        }
        if (!this.expired()) {
            if (this._log.shouldDebug()) {
                this._log.debug("Sending message #6 to Charlie: " + test);
            }
            long now = this._context.clock().now();
            test.setLastSendTime(now);
            test.setSendCharlieTime(now);
            long nonce = test.getNonce();
            long rcvId = nonce << 32 | nonce;
            long sendId = rcvId ^ 0xFFFFFFFFFFFFFFFFL;
            InetAddress addr = test.getAliceIP();
            int alicePort = test.getAlicePort();
            byte[] aliceIP = addr.getAddress();
            int iplen = aliceIP.length;
            byte[] data = new byte[12 + iplen];
            data[0] = 2;
            DataHelper.toLong(data, 1, 4, nonce);
            DataHelper.toLong(data, 5, 4, this._context.clock().now() / 1000L);
            data[9] = (byte)(iplen + 2);
            DataHelper.toLong(data, 10, 2, alicePort);
            System.arraycopy(aliceIP, 0, data, 12, iplen);
            UDPPacket packet = this._packetBuilder2.buildPeerTestFromAlice(test.getCharlieIP(), test.getCharliePort(), test.getCharlieIntroKey(), sendId, rcvId, data);
            this._transport.send(packet);
        } else {
            this._currentTest = null;
        }
    }

    private void fail() {
        PeerTestState test = this._currentTest;
        if (test == null) {
            return;
        }
        test.setAlicePortFromCharlie(0);
        test.setReceiveCharlieTime(0L);
        test.setReceiveBobTime(0L);
        this.testComplete();
    }

    private void testComplete() {
        CommSystemFacade.Status status;
        this._currentTestComplete = true;
        PeerTestState test = this._currentTest;
        boolean isIPv6 = test.isIPv6();
        int apfc = test.getAlicePortFromCharlie();
        if (apfc > 0) {
            InetAddress aIP = test.getAliceIP();
            InetAddress aIPfc = test.getAliceIPFromCharlie();
            if (test.getAlicePort() == apfc && aIP != null && aIP.equals(aIPfc)) {
                if (test.getReceiveCharlieTime() <= 0L) {
                    CommSystemFacade.Status status2 = status = isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN;
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test complete w/o msg 5, " + (Object)((Object)status) + " on " + test);
                    }
                } else {
                    status = isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK : CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN;
                }
            } else if (test.getAlicePort() == apfc) {
                status = this._transport.isSymNatted() ? CommSystemFacade.Status.UNKNOWN : (test.getReceiveCharlieTime() <= 0L ? (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN) : (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK : CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN));
            } else {
                CommSystemFacade.Status status3 = status = isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_SNAT_IPV6_UNKNOWN;
                if (this._log.shouldWarn()) {
                    this._log.warn("Test complete, SYMMETRIC NAT! " + (Object)((Object)status));
                }
            }
        } else if (test.getReceiveCharlieTime() > 0L) {
            status = this._transport.isSymNatted() ? CommSystemFacade.Status.UNKNOWN : (isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_OK : CommSystemFacade.Status.IPV4_OK_IPV6_UNKNOWN);
        } else if (test.getReceiveBobTime() > 0L) {
            if (isIPv6 && PENDING_IP.equals(test.getCharlieIP())) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Test complete, no response from firewalled Charlie, will retest");
                }
                status = CommSystemFacade.Status.UNKNOWN;
            } else {
                status = isIPv6 ? CommSystemFacade.Status.IPV4_UNKNOWN_IPV6_FIREWALLED : CommSystemFacade.Status.IPV4_FIREWALLED_IPV6_UNKNOWN;
            }
        } else {
            status = CommSystemFacade.Status.UNKNOWN;
        }
        if (this._log.shouldInfo()) {
            this._log.info("Test complete: " + test);
        }
        this.honorStatus(status, isIPv6);
        this._currentTest = null;
    }

    private void honorStatus(CommSystemFacade.Status status, boolean isIPv6) {
        if (this._log.shouldInfo()) {
            this._log.info("Test results IPv" + (isIPv6 ? (char)'6' : '4') + " status " + (Object)((Object)status));
        }
        this._transport.setReachabilityStatus(status, isIPv6);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void receiveTest(RemoteHostId from, UDPPacket packet) {
        DatagramPacket pkt = packet.getPacket();
        int off = pkt.getOffset();
        int len = pkt.getLength();
        byte[] data = pkt.getData();
        long rcvConnID = DataHelper.fromLong8(data, off);
        long sendConnID = DataHelper.fromLong8(data, off + 16);
        int type = data[off + 12] & 0xFF;
        if (type != 7) {
            return;
        }
        byte[] introKey = this._transport.getSSU2StaticIntroKey();
        ChaChaPolyCipherState chacha = new ChaChaPolyCipherState();
        chacha.initializeKey(introKey, 0);
        long n = DataHelper.fromLong(data, off + 8, 4);
        chacha.setNonce(n);
        try {
            chacha.decryptWithAd(data, off, 32, data, off + 32, data, off + 32, len - 32);
            int payloadLen = len - 48;
            PTCallback cb = new PTCallback(from);
            SSU2Payload.processPayload(this._context, cb, data, off + 32, payloadLen, false, null);
        }
        catch (Exception e) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad PeerTest packet:\n" + HexDump.dump(data, off, len), e);
            }
        }
        finally {
            chacha.destroy();
        }
    }

    public void receiveTest(RemoteHostId from, PeerState2 fromPeer, int msg, int status, Hash h, byte[] data) {
        if (!(status != 0 || msg != 2 && msg != 4 || this._context.banlist().isBanlisted(h))) {
            this.receiveTest(from, fromPeer, msg, h, data, 0);
        } else {
            this.receiveTest(from, fromPeer, msg, status, h, data, null, 0);
        }
    }

    private boolean receiveTest(RemoteHostId from, PeerState2 fromPeer, int msg, Hash h, byte[] data, int retryCount) {
        RouterInfo ri;
        if (retryCount < 5 && (ri = this._context.netDb().lookupRouterInfoLocally(h)) == null) {
            if (this._log.shouldInfo()) {
                this._log.info("Delay after " + retryCount + " retries, no RI for " + h.toBase64());
            }
            if (retryCount == 0) {
                new DelayTest(from, fromPeer, msg, h, data);
            }
            return false;
        }
        this.receiveTest(from, fromPeer, msg, 0, h, data, null, 0);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private void receiveTest(RemoteHostId from, PeerState2 fromPeer, int msg, int status, Hash h, byte[] data, byte[] addrBlockIP, int addrBlockPort) {
        if (data[0] != 2) {
            if (this._log.shouldWarn()) {
                this._log.warn("Bad version " + (data[0] & 255) + from + ' ' + fromPeer);
            }
            return;
        }
        nonce = DataHelper.fromLong(data, 1, 4);
        time = DataHelper.fromLong(data, 5, 4) * 1000L;
        iplen = data[9] & 255;
        if (iplen != 0 && iplen != 6 && iplen != 18) {
            if (this._log.shouldLog(30)) {
                this._log.warn("Bad IP address length " + iplen);
            }
            return;
        }
        v0 = isIPv6 = iplen == 18;
        if (iplen != 0) {
            testPort = (int)DataHelper.fromLong(data, 10, 2);
            testIP = new byte[iplen - 2];
            System.arraycopy(data, 12, testIP, 0, iplen - 2);
        } else {
            testPort = 0;
            testIP = null;
            if (status == 0) {
                status = 999;
            }
        }
        lNonce = nonce;
        state = msg == 4 || msg == 5 || msg == 7 ? this._currentTest : this._activeTests.get(lNonce);
        if (this._log.shouldDebug()) {
            this._log.debug("Received PeerTest message from [" + fromPeer + "] \n* Time: " + DataHelper.formatTime(time) + "; Message: " + msg + "; Status: " + status + "; Hash: " + (h != null ? h.toBase64() : "null") + "; Nonce: " + nonce + "; IP/Port: " + Addresses.toString(testIP, testPort) + "; State " + state);
        }
        fromIP = from.getIP();
        fromPort = from.getPort();
        if (fromPeer == null && (!TransportUtil.isValidPort(fromPort) || !this._transport.isValid(fromIP) || this._transport.isTooClose(fromIP) || this._context.blocklist().isBlocklisted(fromIP))) {
            if (this._log.shouldWarn()) {
                this._log.warn("Invalid PeerTest address: " + Addresses.toString(fromIP, fromPort));
            }
            this._context.statManager().addRateData("udp.testBadIP", 1L);
            return;
        }
        now = this._context.clock().now();
        if (msg >= 1 && msg <= 4) {
            if (fromPeer == null) {
                if (this._log.shouldWarn()) {
                    this._log.warn("BAD message " + msg + " out-of-session from " + from);
                }
                return;
            }
            fromPeer.setLastReceiveTime(now);
        } else if (fromPeer != null) {
            if (this._log.shouldWarn()) {
                this._log.warn("BAD message " + msg + " in-session from " + fromPeer);
            }
            return;
        }
        if (msg < 3) {
            if (state != null) {
                retx = state.getTestData();
                if (retx != null) {
                    if (msg == 1 && state.getSendAliceTime() > 0L) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Resending message 4 to Alice on " + state);
                        }
                        alice = state.getAlice();
                        try {
                            packet = this._packetBuilder2.buildPeerTestToAlice(state.getStatus(), state.getCharlieHash(), data, alice);
                            this._transport.send(packet);
                            alice.setLastSendTime(now);
                            state.setSendAliceTime(now);
                            state.setReceiveAliceTime(now);
                        }
                        catch (IOException ioe) {
                            this._activeTests.remove(lNonce);
                        }
                        return;
                    }
                    if (msg == 2) {
                        if (this._log.shouldDebug()) {
                            this._log.debug("Retx msg 3 to bob on " + state);
                        }
                        bob = (PeerState2)state.getBob();
                        try {
                            packet = this._packetBuilder2.buildPeerTestToBob(state.getStatus(), data, bob);
                            this._transport.send(packet);
                            bob.setLastSendTime(now);
                            state.setReceiveBobTime(now);
                        }
                        catch (IOException ioe) {
                            this._activeTests.remove(lNonce);
                        }
                        return;
                    }
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Duplicate message " + msg + fromPeer + " on " + state);
                }
                if (msg == 1) {
                    state.setReceiveAliceTime(now);
                } else {
                    state.setReceiveBobTime(now);
                }
                return;
            }
            if (this._activeTests.size() >= 20) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Too many active tests, droppping from " + Addresses.toString(fromIP, fromPort));
                }
                try {
                    packet = msg == 1 ? this._packetBuilder2.buildPeerTestToAlice(3, Hash.FAKE_HASH, data, fromPeer) : this._packetBuilder2.buildPeerTestToBob(66, data, fromPeer);
                    this._transport.send(packet);
                }
                catch (IOException var24_25) {
                    // empty catch block
                }
                return;
            }
        } else if (state == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("No state found for message " + msg + fromPeer);
            }
            return;
        }
        if ((skew = time - now) > 120000L || skew < -120000L) {
            if (this._log.shouldWarn()) {
                this._log.warn("Too skewed for message " + msg + fromPeer);
            }
            return;
        }
        switch (msg) {
            case 1: {
                if (status != 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Message #1 status " + status);
                    }
                    return;
                }
                if (testIP == null || isIPv6 != fromPeer.isIPv6() || !TransportUtil.isValidPort(testPort) || !this._transport.isValid(testIP) || this._transport.isTooClose(testIP) || !DataHelper.eq(fromPeer.getRemoteIP(), 0, testIP, 0, isIPv6 != false ? 8 : 4)) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Invalid PeerTest address: " + Addresses.toString(testIP, testPort));
                    }
                    this.sendRejectToAlice(5, data, fromPeer);
                    fromPeer.setLastSendTime(now);
                    return;
                }
                if (this._throttle.shouldThrottle(fromIP)) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("PeerTest throttle from " + Addresses.toString(fromIP, fromPort));
                    }
                    this.sendRejectToAlice(3, data, fromPeer);
                    fromPeer.setLastSendTime(now);
                    return;
                }
                alice = fromPeer.getRemotePeer();
                aliceRI = this._context.netDb().lookupRouterInfoLocally(alice);
                if (aliceRI == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("No RouterInfo for Alice");
                    }
                    this.sendRejectToAlice(1, data, fromPeer);
                    fromPeer.setLastSendTime(now);
                    return;
                }
                spk = aliceRI.getIdentity().getSigningPublicKey();
                if (!SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, this._context.routerHash(), null, data, spk)) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Signature failed in message #1\n" + aliceRI);
                    }
                    this.sendRejectToAlice(4, data, fromPeer);
                    fromPeer.setLastSendTime(now);
                    return;
                }
                charlie = this._transport.pickTestPeer(PeerTestState.Role.CHARLIE, 2, isIPv6, from);
                if (charlie == null) {
                    if (this._log.shouldLog(30)) {
                        this._log.warn("Unable to pick a Charlie (no peer), IPv6? " + isIPv6);
                    }
                    this.sendRejectToAlice(2, data, fromPeer);
                    fromPeer.setLastSendTime(now);
                    return;
                }
                aliceIP = fromPeer.getRemoteIPAddress();
                alicePort = fromPeer.getRemotePort();
                state = new PeerTestState(PeerTestState.Role.BOB, null, isIPv6, nonce, now);
                state.setAlice(fromPeer);
                state.setAlice(aliceIP, alicePort, alice);
                state.setCharlie(charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getRemotePeer());
                state.setReceiveAliceTime(now);
                state.setLastSendTime(now);
                state.setTestData(data);
                this._activeTests.put(lNonce, state);
                new RemoveTest(lNonce, 10000L);
                if (this._log.shouldDebug()) {
                    this._log.debug("Sending Alice's RouterInfo and message #2 to Charlie on " + state);
                }
                try {
                    this.sendRIandPT(aliceRI, -1, alice, data, (PeerState2)charlie, now);
                }
                catch (IOException ioe) {
                    this.sendRejectToAlice(1, data, fromPeer);
                    this._activeTests.remove(lNonce);
                }
                break;
            }
            case 2: {
                if (status != 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Message #2 status " + status);
                    }
                    return;
                }
                try {
                    aliceIP = InetAddress.getByAddress(testIP);
                }
                catch (UnknownHostException uhe) {
                    return;
                }
                aliceRI = null;
                aliceIntroKey = null;
                aps = this._transport.getPeerState(h);
                if (!this._transport.canTestAsCharlie(isIPv6)) {
                    rcode = 65;
                } else if (aps != null && aps.isIPv6() == isIPv6) {
                    rcode = 68;
                } else if (this._transport.getEstablisher().getInboundState(from) != null || this._transport.getEstablisher().getOutboundState(from) != null) {
                    rcode = 68;
                } else if (this._context.banlist().isBanlisted(h) || this._context.blocklist().isBlocklisted(testIP)) {
                    rcode = 69;
                } else if (!TransportUtil.isValidPort(testPort) || !this._transport.isValid(testIP) || this._transport.isTooClose(testIP)) {
                    rcode = 65;
                } else if (this._throttle.shouldThrottle(fromIP) || this._throttle.shouldThrottle(testIP)) {
                    rcode = 66;
                } else {
                    aliceRI = this._context.netDb().lookupRouterInfoLocally(h);
                    if (aliceRI != null) {
                        spk /* !! */  = aliceRI.getIdentity().getSigningPublicKey();
                        if (SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, fromPeer.getRemotePeer(), null, data, (SigningPublicKey)spk /* !! */ )) {
                            aliceIntroKey = PeerTestManager.getIntroKey(this.getAddress(aliceRI, isIPv6));
                            rcode = aliceIntroKey != null ? 0 : 65;
                        } else {
                            if (this._log.shouldWarn()) {
                                this._log.warn("Signature failed on message #2\n" + aliceRI);
                            }
                            rcode = 67;
                        }
                    } else {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Alice's RouterInfo [" + h.toBase64().substring(0, 6) + "] not found for peer test " + fromPeer);
                        }
                        rcode = 70;
                    }
                }
                if (rcode == 0) {
                    state = new PeerTestState(PeerTestState.Role.CHARLIE, fromPeer, isIPv6, nonce, now);
                    state.setAlice(aliceIP, testPort, h);
                    state.setAliceIntroKey(aliceIntroKey);
                    state.setReceiveBobTime(now);
                    state.setLastSendTime(now);
                    this._activeTests.put(lNonce, state);
                    new CharlieTimer(lNonce);
                }
                spk /* !! */  = this._context.keyManager().getSigningPrivateKey();
                data = SSU2Util.createPeerTestData(this._context, fromPeer.getRemotePeer(), h, PeerTestState.Role.CHARLIE, nonce, testIP, testPort, spk /* !! */ );
                if (data == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Signature failure");
                    }
                    if (rcode == 0) {
                        this._activeTests.remove(lNonce);
                    }
                    return;
                }
                try {
                    packet = this._packetBuilder2.buildPeerTestToBob(rcode, data, fromPeer);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Sending message #3 response " + rcode + " nonce " + lNonce + " to " + fromPeer);
                    }
                    this._transport.send(packet);
                    fromPeer.setLastSendTime(now);
                }
                catch (IOException ioe) {
                    if (rcode == 0) {
                        this._activeTests.remove(lNonce);
                    }
                    return;
                }
                if (rcode != 0) break;
                if (this._log.shouldDebug()) {
                    this._log.debug("Sending message #5 to " + Addresses.toString(testIP, testPort) + " on " + state);
                }
                sendId = nonce << 32 | nonce;
                rcvId = sendId ^ -1L;
                packet = this._packetBuilder2.buildPeerTestToAlice(aliceIP, testPort, aliceIntroKey, true, sendId, rcvId, data);
                this._transport.send(packet);
                state.incrementPacketsRelayed();
                state.setStatus(rcode);
                state.setTestData(data);
                break;
            }
            case 3: {
                state.setReceiveCharlieTime(now);
                if (status != 0 && now - state.getBeginTime() < 5000L && (prev = state.getPreviousCharlies()).size() < 7 && (charlie = this._transport.pickTestPeer(PeerTestState.Role.CHARLIE, 2, isIPv6, from)) != null && charlie != fromPeer && !prev.contains(charlie.getRemotePeer())) {
                    alice = state.getAlice().getRemotePeer();
                    aliceRI = this._context.netDb().lookupRouterInfoLocally(alice);
                    if (aliceRI != null) {
                        try {
                            state.setCharlie(charlie.getRemoteIPAddress(), charlie.getRemotePort(), charlie.getRemotePeer());
                            state.setLastSendTime(now);
                            this.sendRIandPT(aliceRI, -1, alice, state.getTestData(), (PeerState2)charlie, now);
                            if (!this._log.shouldInfo()) break;
                            this._log.info("Charlie response " + status + " picked a new one " + charlie + " on " + state);
                            break;
                        }
                        catch (IOException aps) {
                            // empty catch block
                        }
                    }
                }
                if (status != 0 && this._log.shouldWarn()) {
                    this._log.warn("Charlie response " + status + " no more to choose from on " + state);
                }
                state.setLastSendTime(now);
                alice = state.getAlice();
                charlie = fromPeer.getRemotePeer();
                v1 = charlieRI = status == 0 ? this._context.netDb().lookupRouterInfoLocally((Hash)charlie) : null;
                if (charlieRI != null) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Sending Charlie's RouterInfo to Alice on " + state);
                    }
                    spk = charlieRI.getIdentity().getSigningPublicKey();
                    if (!SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, this._context.routerHash(), alice.getRemotePeer(), data, spk) && this._log.shouldWarn()) {
                        this._log.warn("Signature failed on message #3\n" + charlieRI);
                    }
                } else if (status == 0 && this._log.shouldWarn()) {
                    this._log.warn("No RouterInfo for Charlie");
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Sending message #4 status " + status + " to Alice on " + state);
                }
                try {
                    this.sendRIandPT(charlieRI, status, (Hash)charlie, data, alice, now);
                    state.setStatus(status);
                    state.setSendAliceTime(now);
                    state.setTestData(data);
                }
                catch (IOException ioe) {
                    this._activeTests.remove(lNonce);
                }
                break;
            }
            case 4: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                test.setReceiveBobTime(now);
                test.setLastSendTime(now);
                fail = false;
                charlieRI = null;
                charlieIntroKey = null;
                charlieIP = null;
                charliePort = 0;
                cps = this._transport.getPeerState(h);
                if (status == 0) ** GOTO lbl315
                if (this._log.shouldInfo()) {
                    this._log.info("Message #4 status " + status + ' ' + test);
                }
                ** GOTO lbl372
lbl315:
                // 1 sources

                if (cps == null || cps.isIPv6() != isIPv6) ** GOTO lbl319
                if (this._log.shouldInfo()) {
                    this._log.info("Charlie is connected " + test);
                }
                ** GOTO lbl372
lbl319:
                // 1 sources

                if (this._transport.getEstablisher().getInboundState(from) == null && this._transport.getEstablisher().getOutboundState(from) == null) ** GOTO lbl323
                if (this._log.shouldInfo()) {
                    this._log.info("Charlie is connecting " + test);
                }
                ** GOTO lbl372
lbl323:
                // 1 sources

                if (!this._context.banlist().isBanlisted(h)) ** GOTO lbl327
                if (this._log.shouldInfo()) {
                    this._log.info("Test fail ban " + h);
                }
                ** GOTO lbl372
lbl327:
                // 1 sources

                charlieRI = this._context.netDb().lookupRouterInfoLocally(h);
                if (charlieRI == null) ** GOTO lbl370
                spk = charlieRI.getIdentity().getSigningPublicKey();
                if (!SSU2Util.validateSig(this._context, SSU2Util.PEER_TEST_PROLOGUE, fromPeer.getRemotePeer(), this._context.routerHash(), data, spk)) ** GOTO lbl367
                ra = this.getAddress(charlieRI, isIPv6);
                if (ra == null) ** GOTO lbl364
                charlieIntroKey = PeerTestManager.getIntroKey(ra);
                if (charlieIntroKey == null && this._log.shouldWarn()) {
                    this._log.warn("Charlie's IntroKey not found: " + test + '\n' + charlieRI);
                }
                if ((ip = ra.getIP()) == null) ** GOTO lbl354
                if (this._transport.isValid(ip) && !this._transport.isTooClose(ip) && !this._context.blocklist().isBlocklisted(ip)) ** GOTO lbl341
                if (this._log.shouldInfo()) {
                    this._log.info("Test fail ban/ip " + Addresses.toString(ip));
                }
                ** GOTO lbl372
lbl341:
                // 1 sources

                try {
                    charlieIP = InetAddress.getByAddress(ip);
                    charliePort = ra.getPort();
                    if (!TransportUtil.isValidPort(charliePort)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("BAD port (" + charliePort + ") detected for Charlie: " + test + '\n' + ra);
                        }
                        charliePort = 0;
                    }
                    ** GOTO lbl372
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie's IP address not found: " + test + '\n' + ra, uhe);
                    }
                    ** GOTO lbl372
                }
lbl354:
                // 1 sources

                caps = ra.getOption("caps");
                if (caps != null && caps.indexOf(66) >= 0) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie's IP address not found: " + test + '\n' + ra);
                    }
                    charlieIP = PeerTestManager.PENDING_IP;
                    charliePort = 99999;
                } else if (this._log.shouldWarn()) {
                    this._log.warn("Bob picked Charlie without B cap: " + test + '\n' + ra);
                }
                ** GOTO lbl372
lbl364:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie's address not found" + test + '\n' + charlieRI);
                }
                ** GOTO lbl372
lbl367:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Signature failed on message #4 " + test + '\n' + charlieRI);
                }
                ** GOTO lbl372
lbl370:
                // 1 sources

                if (this._log.shouldWarn()) {
                    this._log.warn("Charlie's RouterInfo not found" + test + ' ' + h);
                }
lbl372:
                // 15 sources

                if (charlieIntroKey == null || charlieIP == null || charliePort <= 0) {
                    this.fail();
                    return;
                }
                oldIP = test.getCharlieIP();
                if (oldIP == null) {
                    test.setCharlie(charlieIP, charliePort, h);
                } else if (charlieIP != PeerTestManager.PENDING_IP) {
                    oldPort = test.getCharliePort();
                    if (!charlieIP.equals(oldIP)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Charlie IP mismatch, msg 4: " + Addresses.toString(charlieIP.getAddress(), charliePort) + ", msg 5: " + Addresses.toString(oldIP.getAddress(), oldPort) + " on " + test);
                        }
                        if (!this._transport.isSymNatted()) {
                            test.setAliceIPFromCharlie(test.getAliceIP());
                            test.setAlicePortFromCharlie(test.getAlicePort());
                        }
                        this.testComplete();
                        return;
                    }
                    if (charliePort != oldPort) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Charlie port mismatch, msg 4: " + Addresses.toString(charlieIP.getAddress(), charliePort) + ", msg 5: " + Addresses.toString(oldIP.getAddress(), oldPort) + " on " + test);
                        }
                        if (TransportUtil.isValidPort(charliePort)) {
                            test.setCharlie(charlieIP, charliePort, h);
                        } else {
                            if (!this._transport.isSymNatted()) {
                                test.setAliceIPFromCharlie(test.getAliceIP());
                                test.setAlicePortFromCharlie(test.getAlicePort());
                            }
                            this.testComplete();
                            return;
                        }
                    }
                }
                test.setCharlieIntroKey(charlieIntroKey);
                if (test.getReceiveCharlieTime() > 0L) {
                    oldPort = this;
                    synchronized (oldPort) {
                        this.sendTestToCharlie();
                        break;
                    }
                }
                if (!this._log.shouldDebug()) break;
                this._log.debug("Received message #4 before message #5 on " + test);
                break;
            }
            case 5: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                if (test.getSendCharlieTime() > 0L) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Ignoring message #5 after sending message #6, from Charlie " + from + " on " + test);
                    }
                    return;
                }
                prev = test.getReceiveCharlieTime();
                test.setReceiveCharlieTime(now);
                if (prev > 0L) {
                    if (this._log.shouldDebug()) {
                        this._log.debug("Dup msg 5 from Charlie " + from + " on " + test);
                    }
                    return;
                }
                charlieIP = test.getCharlieIP();
                if (charlieIP == null) {
                    try {
                        test.setCharlie(InetAddress.getByAddress(fromIP), fromPort, null);
                    }
                    catch (UnknownHostException charlieIP) {}
                } else if (charlieIP == PeerTestManager.PENDING_IP) {
                    try {
                        test.setCharlie(InetAddress.getByAddress(fromIP), fromPort, test.getCharlieHash());
                    }
                    catch (UnknownHostException charlieIP) {}
                } else {
                    oldIP = charlieIP.getAddress();
                    oldPort = test.getCharliePort();
                    if (!DataHelper.eq(fromIP, oldIP)) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Charlie IP mismatch, msg 4: " + Addresses.toString(oldIP, oldPort) + ", msg 5: " + Addresses.toString(fromIP, fromPort) + " on " + test);
                        }
                        if (!this._transport.isSymNatted()) {
                            test.setAliceIPFromCharlie(test.getAliceIP());
                            test.setAlicePortFromCharlie(test.getAlicePort());
                            this._transport.markUnreachable(test.getCharlieHash());
                        }
                        this.testComplete();
                        return;
                    }
                    if (fromPort != oldPort) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Charlie port mismatch, msg 4: " + Addresses.toString(oldIP, oldPort) + ", msg 5: " + Addresses.toString(fromIP, fromPort) + " on " + test);
                        }
                        test.setCharlie(charlieIP, fromPort, h);
                    }
                }
                try {
                    addr = InetAddress.getByAddress(testIP);
                    test.setAliceIPFromCharlie(addr);
                }
                catch (UnknownHostException uhe) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie @ " + from + " said we were an invalid IP address: " + uhe.getMessage(), uhe);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                }
                if (test.getCharlieIntroKey() != null) {
                    uhe = this;
                    synchronized (uhe) {
                        this.sendTestToCharlie();
                        break;
                    }
                }
                if (!this._log.shouldDebug()) break;
                this._log.debug("Received message #5 before message #4 on " + test);
                break;
            }
            case 6: {
                state.setReceiveAliceTime(now);
                state.setLastSendTime(now);
                sendId = nonce << 32 | nonce;
                rcvId = sendId ^ -1L;
                addr = state.getAliceIP();
                alicePort = state.getAlicePort();
                aliceIP = addr.getAddress();
                iplen = aliceIP.length;
                data = new byte[12 + iplen];
                data[0] = 2;
                DataHelper.toLong(data, 1, 4, nonce);
                DataHelper.toLong(data, 5, 4, now / 1000L);
                data[9] = (byte)(iplen + 2);
                DataHelper.toLong(data, 10, 2, alicePort);
                System.arraycopy(aliceIP, 0, data, 12, iplen);
                if (!DataHelper.eq(aliceIP, fromIP)) {
                    try {
                        addr = InetAddress.getByAddress(fromIP);
                    }
                    catch (UnknownHostException uhe) {
                        return;
                    }
                }
                if (this._log.shouldDebug()) {
                    this._log.debug("Sending messsage #7 to Alice at " + Addresses.toString(fromIP, fromPort) + " on " + state);
                }
                packet = this._packetBuilder2.buildPeerTestToAlice(addr, fromPort, state.getAliceIntroKey(), false, sendId, rcvId, data);
                this._transport.send(packet);
                state.incrementPacketsRelayed();
                if (addrBlockIP == null) break;
                if (this._transport.isValid(addrBlockIP) && TransportUtil.isValidPort(addrBlockPort)) {
                    ra = this._transport.getCurrentExternalAddress(isIPv6);
                    if (ra == null || addrBlockPort == ra.getPort() && DataHelper.eq(addrBlockIP, ra.getIP()) || !this._log.shouldWarn()) break;
                    this._log.warn("Alice said we had a different IP/port: " + Addresses.toString(addrBlockIP, addrBlockPort) + " on " + state);
                    break;
                }
                if (!this._log.shouldWarn()) break;
                this._log.warn("Alice said we had an invalid IP/port: " + Addresses.toString(addrBlockIP, addrBlockPort) + " on " + state);
                break;
            }
            case 7: {
                test = this._currentTest;
                if (test == null || test.getNonce() != nonce) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Test nonce mismatch? " + nonce);
                    }
                    return;
                }
                if (test.getReceiveBobTime() <= 0L) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Received message #7 WITHOUT message #4??? on " + test);
                    }
                    this.testComplete();
                    return;
                }
                if (test.getReceiveCharlieTime() <= 0L) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Got msg 7 w/o msg 5 from Charlie " + from + " on " + test);
                    }
                    if ((charlieIP = test.getCharlieIP()) != null) {
                        oldIP = charlieIP.getAddress();
                        oldPort = test.getCharliePort();
                        if (fromPort != oldPort || !DataHelper.eq(fromIP, oldIP)) {
                            if (this._log.shouldWarn()) {
                                this._log.warn("Charlie IP/port mismatch, msg 4: " + Addresses.toString(oldIP, oldPort) + ", msg 7: " + Addresses.toString(fromIP, fromPort) + " on " + test);
                            }
                            this.fail();
                            return;
                        }
                    }
                }
                bad = false;
                if (addrBlockIP != null) {
                    if (this._transport.isValid(addrBlockIP)) {
                        try {
                            addr = InetAddress.getByAddress(addrBlockIP);
                            test.setAliceIPFromCharlie(addr);
                        }
                        catch (UnknownHostException addr) {}
                    } else {
                        bad = true;
                    }
                } else {
                    test.setAliceIPFromCharlie(test.getAliceIP());
                }
                if (!bad && addrBlockPort != 0) {
                    if (addrBlockPort >= 1024) {
                        test.setAlicePortFromCharlie(addrBlockPort);
                    } else {
                        bad = true;
                    }
                } else if (!this._transport.isSymNatted()) {
                    test.setAlicePortFromCharlie(test.getAlicePort());
                }
                if (bad) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Charlie said we had an invalid IP/port: " + Addresses.toString(addrBlockIP, addrBlockPort) + " on " + test);
                    }
                    this._context.statManager().addRateData("udp.testBadIP", 1L);
                } else {
                    charlieHash = test.getCharlieHash();
                    portok = addrBlockPort == test.getAlicePort();
                    IPok = DataHelper.eq(addrBlockIP, test.getAliceIP().getAddress());
                    if (!portok || !IPok) {
                        if (this._log.shouldWarn()) {
                            this._log.warn("Charlie said we had a different IP/port: " + Addresses.toString(addrBlockIP, addrBlockPort) + " on " + test);
                        }
                        if (test.getReceiveCharlieTime() > 0L) {
                            if (IPok) {
                                if (charlieHash != null) {
                                    this._transport.markUnreachable(charlieHash);
                                }
                                test.setAlicePortFromCharlie(test.getAlicePort());
                                bad = true;
                            } else if (!portok) {
                                if (charlieHash != null) {
                                    this._transport.markUnreachable(charlieHash);
                                }
                                test.setAliceIPFromCharlie(test.getAliceIP());
                                test.setAlicePortFromCharlie(test.getAlicePort());
                                bad = true;
                            }
                        }
                    }
                    if (!bad && charlieHash != null) {
                        this._transport.externalAddressReceived(charlieHash, addrBlockIP, addrBlockPort);
                    }
                }
                this.testComplete();
                break;
            }
            default: {
                return;
            }
        }
    }

    private void sendRejectToAlice(int reason, byte[] data, PeerState2 alice) {
        try {
            UDPPacket packet = this._packetBuilder2.buildPeerTestToAlice(reason, Hash.FAKE_HASH, data, alice);
            this._transport.send(packet);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private RouterAddress getAddress(RouterInfo ri, boolean isIPv6) {
        List<RouterAddress> addrs = this._transport.getTargetAddresses(ri);
        return PeerTestManager.getAddress(addrs, isIPv6);
    }

    static RouterAddress getAddress(List<RouterAddress> addrs, boolean isIPv6) {
        RouterAddress ra = null;
        for (RouterAddress addr : addrs) {
            String caps;
            if (addrs.size() > 1 && addr.getTransportStyle().equals("SSU") && addr.getOption("s") == null) continue;
            String host = addr.getHost();
            if (host == null) {
                host = "";
            }
            if ((caps = addr.getOption("caps")) == null) {
                caps = "";
            }
            if (!isIPv6 ? !host.contains(".") && !caps.contains("4") : !host.contains(":") && !caps.contains("6")) continue;
            byte[] ip = addr.getIP();
            if (ip != null && !TransportUtil.isPubliclyRoutable(ip, true)) continue;
            ra = addr;
            break;
        }
        return ra;
    }

    static SessionKey getIntroKey(RouterAddress ra) {
        if (ra == null) {
            return null;
        }
        String siv = ra.getOption("i");
        if (siv == null) {
            return null;
        }
        byte[] ik = Base64.decode(siv);
        if (ik == null) {
            return null;
        }
        return new SessionKey(ik);
    }

    private void sendRIandPT(RouterInfo ri, int status, Hash hash, byte[] data, PeerState2 to, long now) throws IOException {
        boolean delay = false;
        SSU2Payload.RIBlock riblock = null;
        if (ri != null) {
            boolean gzip;
            int avail = to.getMTU() - ((to.isIPv6() ? 80 : 60) + 3 + 3 + 32 + data.length + 3 + 2);
            byte[] info = ri.toByteArray();
            byte[] gzipped = DataHelper.compress(info, 0, info.length, 9);
            if (this._log.shouldDebug()) {
                this._log.debug("RI: " + info.length + " bytes uncompressed, " + gzipped.length + " compressed, MTU " + to.getMTU() + ", available " + avail);
            }
            boolean bl = gzip = gzipped.length < info.length;
            if (gzip) {
                info = gzipped;
            }
            if (info.length <= avail) {
                riblock = new SSU2Payload.RIBlock(info, 0, info.length, false, gzip, 0, 1);
            } else {
                DatabaseStoreMessage dbsm = new DatabaseStoreMessage(this._context);
                dbsm.setEntry(ri);
                dbsm.setMessageExpiration(now + 10000L);
                this._transport.send(dbsm, (PeerState)to);
                delay = true;
            }
        }
        UDPPacket packet = status < 0 ? this._packetBuilder2.buildPeerTestToCharlie(hash, data, riblock, to) : this._packetBuilder2.buildPeerTestToAlice(status, hash, data, riblock, to);
        if (delay) {
            new DelaySend(packet, 100L);
        } else {
            this._transport.send(packet);
        }
        to.setLastSendTime(now);
    }

    static {
        InetAddress p = null;
        try {
            p = InetAddress.getByName("0.0.0.1");
        }
        catch (UnknownHostException unknownHostException) {
            // empty catch block
        }
        PENDING_IP = p;
    }

    private class PTCallback
    implements SSU2Payload.PayloadCallback {
        private final RemoteHostId _from;
        public long _timeReceived;
        public byte[] _aliceIP;
        public int _alicePort;

        public PTCallback(RemoteHostId from) {
            this._from = from;
        }

        @Override
        public void gotDateTime(long time) {
            this._timeReceived = time;
        }

        @Override
        public void gotOptions(byte[] options, boolean isHandshake) {
        }

        @Override
        public void gotRI(RouterInfo ri, boolean isHandshake, boolean flood) {
            block5: {
                if (ri.getPublished() < 0L) {
                    if (PeerTestManager.this._log.shouldWarn()) {
                        PeerTestManager.this._log.warn("Invalid publication date in RouterInfo [" + ri.getIdentity().calculateHash().toBase64().substring(0, 6) + "] -> Banning...");
                    }
                    return;
                }
                try {
                    Hash h = ri.getHash();
                    if (h.equals(PeerTestManager.this._context.routerHash())) {
                        return;
                    }
                    PeerTestManager.this._context.netDb().store(h, ri);
                }
                catch (IllegalArgumentException iae) {
                    if (!PeerTestManager.this._log.shouldInfo()) break block5;
                    PeerTestManager.this._log.info("RouterInfo store fail (" + iae.getMessage() + "): " + ri);
                }
            }
        }

        @Override
        public void gotRIFragment(byte[] data, boolean isHandshake, boolean flood, boolean isGzipped, int frag, int totalFrags) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotAddress(byte[] ip, int port) {
            this._aliceIP = ip;
            this._alicePort = port;
        }

        @Override
        public void gotRelayTagRequest() {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayTag(long tag) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayRequest(byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayResponse(int status, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotRelayIntro(Hash aliceHash, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotPeerTest(int msg, int status, Hash h, byte[] data) {
            PeerTestManager.this.receiveTest(this._from, null, msg, status, h, data, this._aliceIP, this._alicePort);
        }

        @Override
        public void gotToken(long token, long expires) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotI2NP(I2NPMessage msg) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotFragment(byte[] data, int off, int len, long messageId, int frag, boolean isLast) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotACK(long ackThru, int acks, byte[] ranges) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotTermination(int reason, long count) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotPathChallenge(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }

        @Override
        public void gotPathResponse(RemoteHostId from, byte[] data) {
            throw new IllegalStateException("Bad block in PT");
        }
    }

    private class DelaySend
    extends SimpleTimer2.TimedEvent {
        private final UDPPacket pkt;

        public DelaySend(UDPPacket packet, long delay) {
            super(PeerTestManager.this._context.simpleTimer2());
            this.pkt = packet;
            this.schedule(delay);
        }

        @Override
        public void timeReached() {
            PeerTestManager.this._transport.send(this.pkt);
        }
    }

    private class CharlieTimer
    extends SimpleTimer2.TimedEvent {
        private final Long _nonce;

        public CharlieTimer(Long nonce) {
            super(PeerTestManager.this._context.simpleTimer2());
            this._nonce = nonce;
            this.schedule(4000L);
        }

        @Override
        public void timeReached() {
            PeerTestState state = (PeerTestState)PeerTestManager.this._activeTests.get(this._nonce);
            if (state == null) {
                return;
            }
            long now = PeerTestManager.this._context.clock().now();
            long remaining = state.getBeginTime() + 15000L - now;
            if (remaining <= 0L) {
                if (PeerTestManager.this._log.shouldDebug()) {
                    PeerTestManager.this._log.debug("Expired as Charlie on " + state);
                }
                PeerTestManager.this._activeTests.remove(this._nonce);
                return;
            }
            if (state.getReceiveAliceTime() > 0L) {
                this.reschedule(remaining);
                return;
            }
            if (PeerTestManager.this._log.shouldDebug()) {
                PeerTestManager.this._log.debug("Resending message #5 to Alice on " + state);
            }
            long nonce = this._nonce;
            long sendId = nonce << 32 | nonce;
            long rcvId = sendId ^ 0xFFFFFFFFFFFFFFFFL;
            UDPPacket packet = PeerTestManager.this._packetBuilder2.buildPeerTestToAlice(state.getAliceIP(), state.getAlicePort(), state.getAliceIntroKey(), true, sendId, rcvId, state.getTestData());
            PeerTestManager.this._transport.send(packet);
            state.incrementPacketsRelayed();
            state.setLastSendTime(now);
            this.reschedule(Math.min(4000L, remaining));
        }
    }

    private class RemoveTest
    extends SimpleTimer2.TimedEvent {
        private final Long _nonce;

        public RemoveTest(Long nonce, long delay) {
            super(PeerTestManager.this._context.simpleTimer2());
            this._nonce = nonce;
            this.schedule(delay);
        }

        @Override
        public void timeReached() {
            PeerTestManager.this._activeTests.remove(this._nonce);
        }
    }

    private class DelayTest
    extends SimpleTimer2.TimedEvent {
        private final RemoteHostId from;
        private final PeerState2 fromPeer;
        private final int msg;
        private final Hash hash;
        private final byte[] data;
        private volatile int count;
        private static final long DELAY = 50L;

        public DelayTest(RemoteHostId f, PeerState2 fp, int m, Hash h, byte[] d) {
            super(PeerTestManager.this._context.simpleTimer2());
            this.from = f;
            this.fromPeer = fp;
            this.msg = m;
            this.hash = h;
            this.data = d;
            this.schedule(50L);
        }

        @Override
        public void timeReached() {
            boolean ok;
            if (!(ok = PeerTestManager.this.receiveTest(this.from, this.fromPeer, this.msg, this.hash, this.data, ++this.count))) {
                this.reschedule(50L << this.count);
            }
        }
    }

    private class ContinueTest
    extends SimpleTimer2.TimedEvent {
        private final long _nonce;

        public ContinueTest(long nonce) {
            super(PeerTestManager.this._context.simpleTimer2());
            this._nonce = nonce;
            this.schedule(4000L);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void timeReached() {
            PeerTestManager peerTestManager = PeerTestManager.this;
            synchronized (peerTestManager) {
                PeerTestState state = PeerTestManager.this._currentTest;
                if (state == null || state.getNonce() != this._nonce) {
                    return;
                }
                if (PeerTestManager.this.expired()) {
                    if (!PeerTestManager.this._currentTestComplete) {
                        PeerTestManager.this.testComplete();
                    }
                    return;
                }
                long now = PeerTestManager.this._context.clock().now();
                long timeSinceSend = now - state.getLastSendTime();
                if (timeSinceSend >= 4000L) {
                    int sent = state.incrementPacketsRelayed();
                    if (sent > 9) {
                        if (PeerTestManager.this._log.shouldWarn()) {
                            PeerTestManager.this._log.warn("Sent too many packets " + state);
                        }
                        if (!PeerTestManager.this._currentTestComplete) {
                            PeerTestManager.this.testComplete();
                        }
                        return;
                    }
                    long bobTime = state.getReceiveBobTime();
                    long charlieTime = state.getReceiveCharlieTime();
                    if (bobTime <= 0L && charlieTime <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else if (charlieTime <= 0L) {
                        if (now - bobTime > 5000L && state.getCharliePort() != 99999) {
                            if (PeerTestManager.this._log.shouldWarn()) {
                                PeerTestManager.this._log.warn("Continuing test w/o msg 5: " + state);
                            }
                            PeerTestManager.this.sendTestToCharlie();
                        }
                    } else if (bobTime <= 0L) {
                        PeerTestManager.this.sendTestToBob();
                    } else if (state.getCharliePort() != 99999) {
                        PeerTestManager.this.sendTestToCharlie();
                    }
                    if (bobTime > 0L && charlieTime <= 0L) {
                        if (state.getBeginTime() + 15000L < now) {
                            if (!PeerTestManager.this._currentTestComplete) {
                                PeerTestManager.this.testComplete();
                            }
                            return;
                        }
                        this.reschedule(sent * 1000);
                    } else {
                        this.reschedule(4000 + sent * 1000);
                    }
                } else {
                    this.reschedule(4000L - timeSinceSend);
                }
            }
        }
    }
}

