/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.util.Arrays;
import net.i2p.router.transport.udp.SSU2Payload;

class SSU2Bitfield {
    private final long[] bitfield;
    private final int size;
    private final int max_shift;
    private final int min_shift;
    private long offset;
    private int highestSet = -1;

    public SSU2Bitfield(int size, long offset) {
        if (size <= 0 || offset < 0L) {
            throw new IllegalArgumentException("size " + size + " offset " + offset);
        }
        this.size = size = size + 255 & 0x7FFFFF00;
        this.offset = offset;
        this.max_shift = Math.max(1024, size * 8);
        this.min_shift = Math.max(8, size / 4);
        this.bitfield = new long[size / 64];
    }

    public int size() {
        return this.size;
    }

    public long getOffset() {
        return this.offset;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean set(long bit) throws IndexOutOfBoundsException {
        boolean rv;
        if (bit < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(bit));
        }
        SSU2Bitfield sSU2Bitfield = this;
        synchronized (sSU2Bitfield) {
            long mask;
            int index;
            if ((bit -= this.offset) < 0L) {
                return true;
            }
            if (bit >= (long)this.size) {
                long shift = bit + 1L - (long)this.size;
                if (shift > (long)this.max_shift) {
                    throw new IndexOutOfBoundsException("Shift too big: " + shift);
                }
                if (shift < (long)this.min_shift) {
                    shift = this.min_shift;
                }
                if ((shift & 0x3FL) != 0L) {
                    shift = 64L + (shift & 0x7FFFFFC0L);
                }
                if (shift < (long)this.size) {
                    int bshift = (int)(shift / 64L);
                    System.arraycopy(this.bitfield, bshift, this.bitfield, 0, this.bitfield.length - bshift);
                    Arrays.fill(this.bitfield, this.bitfield.length - bshift, this.bitfield.length, 0L);
                    if (this.highestSet >= 0) {
                        this.highestSet = (int)((long)this.highestSet - shift);
                    }
                } else {
                    Arrays.fill(this.bitfield, 0L);
                    this.highestSet = -1;
                }
                this.offset += shift;
                bit -= shift;
            }
            boolean bl = rv = (this.bitfield[index = (int)(bit >> 6)] & (mask = 1L << ((int)bit & 0x3F))) != 0L;
            if (!rv) {
                int n = index;
                this.bitfield[n] = this.bitfield[n] | mask;
                if (bit > (long)this.highestSet) {
                    this.highestSet = (int)bit;
                }
            }
        }
        return rv;
    }

    public boolean get(long bit) {
        if (bit < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(bit));
        }
        if ((bit -= this.offset) < 0L || bit >= (long)this.size) {
            return false;
        }
        int index = (int)(bit >> 6);
        long mask = 1L << ((int)bit & 0x3F);
        return (this.bitfield[index] & mask) != 0L;
    }

    public synchronized long getHighestSet() {
        if (this.highestSet < 0) {
            return -1L;
        }
        return (long)this.highestSet + this.offset;
    }

    public synchronized SSU2Payload.AckBlock toAckBlock(int maxRanges) {
        long highest = this.getHighestSet();
        if (highest < 0L) {
            return null;
        }
        byte[] ranges = new byte[maxRanges * 2];
        int acnt = 0;
        int rangeCount = 0;
        for (long i = highest - 1L; i >= this.offset && acnt < 255 && this.get(i); ++acnt, --i) {
        }
        if ((long)acnt < highest - this.offset) {
            long cur = highest - (long)(acnt + 1);
            for (int r = 0; r < maxRanges; ++r) {
                int aacnt;
                int ncnt;
                for (ncnt = 0; cur >= this.offset && ncnt < 255 && !this.get(cur); ++ncnt, --cur) {
                }
                for (aacnt = 0; cur >= this.offset && aacnt < 255 && this.get(cur); ++aacnt, --cur) {
                }
                if (ncnt == 0 && aacnt == 0) break;
                ranges[rangeCount * 2] = (byte)ncnt;
                ranges[rangeCount * 2 + 1] = (byte)aacnt;
                ++rangeCount;
                if (cur < this.offset) break;
            }
        }
        return new SSU2Payload.AckBlock(highest, acnt, ranges, rangeCount);
    }

    public static SSU2Bitfield fromACKBlock(long thru, int acnt, byte[] ranges, int rangeCount) {
        int t = (int)thru;
        if (ranges == null || rangeCount == 0) {
            SSU2Bitfield rv = new SSU2Bitfield(acnt + 1, thru - (long)acnt);
            for (int i = t; i >= t - acnt; --i) {
                rv.set(i);
            }
            return rv;
        }
        int min = t - acnt;
        for (int i = 0; i < rangeCount * 2; ++i) {
            min -= ranges[i] & 0xFF;
        }
        if (ranges[rangeCount * 2 - 1] == 0) {
            min += ranges[rangeCount * 2 - 2] & 0xFF;
        }
        SSU2Bitfield rv = new SSU2Bitfield(1 + t - min, min);
        for (int i = t; i >= t - acnt; --i) {
            rv.set(i);
        }
        int j = t - (acnt + 1);
        for (int i = 0; i < rangeCount * 2; i += 2) {
            j -= ranges[i] & 0xFF;
            int toAck = ranges[i + 1] & 0xFF;
            for (int k = 0; k < toAck; ++k) {
                rv.set(j--);
            }
        }
        return rv;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void forEachAndNot(SSU2Bitfield bf2, Callback cb) {
        SSU2Bitfield sSU2Bitfield = bf2;
        synchronized (sSU2Bitfield) {
            long bit;
            long highest = this.getHighestSet();
            if (highest < bf2.offset) {
                return;
            }
            long start = Math.max(this.offset, bf2.offset);
            long bf2Highest = bf2.getHighestSet();
            for (bit = start; bit < bf2Highest && bit <= highest; ++bit) {
                if (!this.get(bit) || bf2.set(bit)) continue;
                cb.bitSet(bit);
            }
            for (bit = bf2Highest + 1L; bit <= highest; ++bit) {
                if (!this.get(bit)) continue;
                bf2.set(bit);
                cb.bitSet(bit);
            }
        }
    }

    public static String toString(long thru, int acnt, byte[] ranges, int rangeCount) {
        StringBuilder sb = new StringBuilder();
        sb.append("ACK ").append(thru);
        int cur = (int)thru;
        if (acnt > 0) {
            sb.append('-').append(thru - (long)acnt);
            cur -= acnt;
        }
        if (ranges != null) {
            --cur;
            for (int i = 0; i < rangeCount * 2; i += 2) {
                int acks;
                int nacks = ranges[i] & 0xFF;
                if (nacks > 0) {
                    sb.append(" NACK ").append(cur);
                    if (nacks > 1) {
                        sb.append('-').append(cur - (nacks - 1));
                    }
                    cur -= nacks;
                }
                if ((acks = ranges[i + 1] & 0xFF) <= 0) continue;
                sb.append(" ACK ").append(cur);
                if (acks > 1) {
                    sb.append('-').append(cur - (acks - 1));
                }
                cur -= acks;
            }
        }
        return sb.toString();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("SSU2Bitfield(");
        sb.append(this.size).append(")");
        sb.append(" offset: ").append(this.offset);
        sb.append(" highest set: ").append(this.getHighestSet());
        sb.append(" [");
        for (long i = this.offset; i <= this.getHighestSet(); ++i) {
            if (!this.get(i)) continue;
            sb.append(' ').append(i);
        }
        sb.append(" ]");
        return sb.toString();
    }

    public static interface Callback {
        public void bitSet(long var1);
    }
}

