/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.transport.udp;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.util.concurrent.BlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.transport.FIFOBandwidthLimiter;
import net.i2p.router.transport.udp.SocketListener;
import net.i2p.router.transport.udp.UDPPacket;
import net.i2p.router.util.CoDelPriorityBlockingQueue;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class UDPSender {
    private final RouterContext _context;
    private final Log _log;
    private final DatagramSocket _socket;
    private String _name;
    private final BlockingQueue<UDPPacket> _outboundQueue;
    private volatile boolean _keepRunning;
    private final Runner _runner;
    private final boolean _dummy;
    private final SocketListener _endpoint;
    private static final int TYPE_POISON = 99999;
    private static final int MIN_QUEUE_SIZE;
    private static final int MAX_QUEUE_SIZE;
    private static final int CODEL_TARGET = 40;
    private static final int CODEL_INTERVAL = 750;
    public static final String PROP_CODEL_TARGET = "router.codelTarget";
    public static final String PROP_CODEL_INTERVAL = "router.codelInterval";
    static final long[] RATES;

    public boolean fullStats() {
        return this._context.getBooleanProperty("stat.full");
    }

    public UDPSender(RouterContext ctx, DatagramSocket socket, String name, SocketListener lsnr) {
        this._context = ctx;
        this._dummy = false;
        this._log = ctx.logManager().getLog(UDPSender.class);
        long maxMemory = SystemVersion.getMaxMemory();
        int cores = SystemVersion.getCores();
        boolean isSlow = SystemVersion.isSlow();
        long messageDelay = this._context.throttle().getMessageDelay();
        int qsize = (int)Math.max((long)MIN_QUEUE_SIZE, Math.min((long)MAX_QUEUE_SIZE, maxMemory * 2L / 0x100000L));
        this._outboundQueue = new CoDelPriorityBlockingQueue<UDPPacket>(ctx, "UDP-Sender", qsize, ctx.getProperty(PROP_CODEL_TARGET, 40), ctx.getProperty(PROP_CODEL_INTERVAL, 750));
        this._socket = socket;
        this._runner = new Runner();
        this._name = name;
        this._endpoint = lsnr;
        this._context.statManager().createRateStat("udp.pushTime", "Time taken for a UDP packet get pushed out", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendQueueSize", "Number of packets queued on the UDP sender", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendQueueFailed", "Failed to add a new packet to the queue", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendQueueTrimmed", "Stale packets removed from queue", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendPacketSize", "Size of sent packets (bytes)", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendBWThrottleTime", "How long send is blocked by bandwidth throttle", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendACKTime", "How long an ACK packet is blocked for", "Transport [UDP]", RATES);
        this._context.statManager().createRateStat("udp.sendFailsafe", "Time bandwidth limiter is stuck", "Transport [UDP]", RATES);
        if (this.fullStats()) {
            this._context.statManager().createRequiredRateStat("udp.sendException", "Send fails (Windows exception?)", "Transport [UDP]", RATES);
        } else {
            this._context.statManager().createRequiredRateStat("udp.sendException", "Send fails (Windows exception?)", "Transport", RATES);
        }
    }

    public synchronized void startup() {
        if (this._log.shouldDebug()) {
            this._log.debug("Starting the runner: " + this._name);
        }
        this._keepRunning = true;
        I2PThread t = new I2PThread(this._runner, this._name, true);
        t.setPriority(10);
        t.start();
    }

    public synchronized void shutdown() {
        if (!this._keepRunning) {
            return;
        }
        this._keepRunning = false;
        this._outboundQueue.clear();
        UDPPacket poison = UDPPacket.acquire(this._context, false);
        poison.setMessageType(99999);
        this._outboundQueue.offer(poison);
        for (int i = 1; i <= 5 && !this._outboundQueue.isEmpty(); ++i) {
            try {
                Thread.sleep(i * 10);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this._outboundQueue.clear();
    }

    public void clear() {
        this._outboundQueue.clear();
    }

    @Deprecated
    public void add(UDPPacket packet, int blockTime) {
        this.add(packet);
    }

    public void add(UDPPacket packet) {
        if (packet == null || !this._keepRunning) {
            return;
        }
        int psz = packet.getPacket().getLength();
        if (psz > 1472) {
            this._log.error("Dropping large UDP packet " + psz + " bytes from " + packet, new Exception());
            return;
        }
        if (psz > 0 && psz < 40 && this._log.shouldWarn()) {
            this._log.warn("Small UDP packet " + psz + " bytes from " + packet, new Exception());
        }
        if (this._dummy) {
            packet.release();
            return;
        }
        packet.requestOutboundBandwidth();
        try {
            this._outboundQueue.put(packet);
        }
        catch (InterruptedException ie) {
            packet.release();
            return;
        }
        if (this._log.shouldDebug()) {
            this._log.debug("UDP packet queued -> Lifetime: " + packet.getLifetime() + "ms; Size: " + psz + " bytes");
        }
    }

    static {
        int n = SystemVersion.isSlow() ? 128 : (MIN_QUEUE_SIZE = SystemVersion.getCores() < 4 ? 192 : 256);
        MAX_QUEUE_SIZE = SystemVersion.isSlow() ? 512 : (SystemVersion.getCores() < 4 ? 768 : 1024);
        RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
    }

    private class Runner
    implements Runnable {
        private Runner() {
        }

        @Override
        public void run() {
            if (UDPSender.this._log.shouldDebug()) {
                UDPSender.this._log.debug("Running the UDP sender...");
            }
            while (UDPSender.this._keepRunning) {
                UDPPacket packet;
                block13: {
                    FIFOBandwidthLimiter.Request req;
                    packet = this.getNextPacket();
                    if (packet == null) continue;
                    if (UDPSender.this._log.shouldDebug()) {
                        UDPSender.this._log.debug("Attempting to send UDP packet to known peer at " + packet);
                    }
                    int size = packet.getPacket().getLength();
                    long acquireTime = UDPSender.this._context.clock().now();
                    if (size > 0 && (req = packet.getBandwidthRequest()) != null) {
                        int waitCount = 0;
                        while (req.getPendingRequested() > 0 && waitCount++ < 5) {
                            req.waitForNextAllocation();
                        }
                        if (waitCount >= 5) {
                            req.abort();
                            UDPSender.this._context.statManager().addRateData("udp.sendFailsafe", 1L);
                        }
                    }
                    long afterBW = UDPSender.this._context.clock().now();
                    try {
                        long throttleTime;
                        DatagramPacket dp = packet.getPacket();
                        UDPSender.this._socket.send(dp);
                        if (UDPSender.this._log.shouldDebug()) {
                            UDPSender.this._log.debug("Sent UDP packet to " + packet);
                        }
                        if ((throttleTime = afterBW - acquireTime) > 10L) {
                            UDPSender.this._context.statManager().addRateData("udp.sendBWThrottleTime", throttleTime, acquireTime - packet.getBegin());
                        }
                        if (packet.getMarkedType() == 1) {
                            UDPSender.this._context.statManager().addRateData("udp.sendACKTime", throttleTime);
                        }
                        UDPSender.this._context.statManager().addRateData("udp.pushTime", packet.getLifetime());
                        UDPSender.this._context.statManager().addRateData("udp.sendPacketSize", size);
                    }
                    catch (IOException ioe) {
                        String ipaddress = packet.getPacket().getAddress().toString().replace("/", "");
                        if (UDPSender.this._log.shouldWarn()) {
                            UDPSender.this._log.warn("Error sending to " + ipaddress + "\n* Error: " + ioe.getMessage());
                        }
                        UDPSender.this._context.statManager().addRateData("udp.sendException", 1L);
                        if (!UDPSender.this._socket.isClosed() || !UDPSender.this._keepRunning) break block13;
                        UDPSender.this._keepRunning = false;
                        UDPSender.this._endpoint.fail();
                    }
                }
                packet.release();
            }
            if (UDPSender.this._log.shouldWarn()) {
                UDPSender.this._log.warn("Stop sending on " + UDPSender.this._endpoint);
            }
            UDPSender.this._outboundQueue.clear();
        }

        private UDPPacket getNextPacket() {
            UDPPacket packet = null;
            int codelTarget = 40;
            if (UDPSender.this._context.getProperty(UDPSender.PROP_CODEL_TARGET) != null) {
                codelTarget = Integer.parseInt(UDPSender.this._context.getProperty(UDPSender.PROP_CODEL_TARGET));
            }
            while (UDPSender.this._keepRunning && (packet == null || packet.getLifetime() > (long)(codelTarget * 3))) {
                if (packet != null) {
                    UDPSender.this._context.statManager().addRateData("udp.sendQueueTrimmed", 1L);
                    packet.release();
                }
                try {
                    packet = (UDPPacket)UDPSender.this._outboundQueue.take();
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                if (packet == null || packet.getMessageType() != 99999) continue;
                return null;
            }
            return packet;
        }
    }
}

