/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageException;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.i2np.UnknownI2NPMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class OutboundMessageDistributor {
    private final RouterContext _context;
    private final int _priority;
    private final Log _log;
    private final Set<Hash> _toRouters;
    private int _newRouterCount;
    private long _newRouterTime;
    private static final long MAX_DISTRIBUTE_TIME = 15000L;
    private static final int coreCount = SystemVersion.getCores();
    private static final int MAX_ROUTERS_PER_PERIOD = SystemVersion.isSlow() ? 32 : 64;
    private static final long NEW_ROUTER_PERIOD = SystemVersion.isSlow() ? 30000L : 15000L;

    public OutboundMessageDistributor(RouterContext ctx, int priority) {
        this._context = ctx;
        this._priority = priority;
        this._log = ctx.logManager().getLog(OutboundMessageDistributor.class);
        if (priority <= 200) {
            this._toRouters = new HashSet<Hash>(4);
            this._toRouters.add(ctx.routerHash());
        } else {
            this._toRouters = null;
        }
    }

    public void distribute(I2NPMessage msg, Hash target) {
        this.distribute(msg, target, null);
    }

    public void distribute(I2NPMessage msg, Hash target, TunnelId tunnel) {
        if (this.shouldDrop(target)) {
            this._context.statManager().addRateData("tunnel.dropAtOBEP", 1L);
            if (this._log.shouldInfo()) {
                this._log.warn("Dropping I2NPMessage to [" + target.toBase64().substring(0, 6) + "] at Outbound Endpoint [TunnelID " + tunnel.getTunnelId() + "] -> New connection throttle" + msg);
            } else if (this._log.shouldWarn()) {
                this._log.warn("Dropping I2NPMessage (" + msg.getType() + ") to [" + target.toBase64().substring(0, 6) + "] at Outbound Endpoint [TunnelID " + tunnel.getTunnelId() + "] -> New connection throttle");
            }
            return;
        }
        RouterInfo info = this._context.netDb().lookupRouterInfoLocally(target);
        if (info == null) {
            if (this._toRouters != null && this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.OBEP, 2, 1024)) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping I2NPMessage (" + msg.getType() + ") to [" + target.toBase64().substring(0, 6) + "] at Outbound Endpoint -> Lookup bandwidth throttle");
                }
                return;
            }
            if (this._log.shouldInfo()) {
                this._log.info("Outbound distributor to [" + target.toBase64().substring(0, 6) + "]" + (tunnel != null ? "." + tunnel.getTunnelId() + "" : "") + " -> No local info, searching...");
            }
            this._context.netDb().lookupRouterInfo(target, new DistributeJob(this._context, msg, target, tunnel), null, 15000L);
            return;
        }
        this.distribute(msg, info, tunnel);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldDrop(Hash target) {
        if (this._toRouters == null) {
            return false;
        }
        OutboundMessageDistributor outboundMessageDistributor = this;
        synchronized (outboundMessageDistributor) {
            if (!this._toRouters.add(target) || this._context.commSystem().isEstablished(target) || ++this._newRouterCount <= Math.min(MAX_ROUTERS_PER_PERIOD, 64)) {
                return false;
            }
            long now = this._context.clock().now();
            if (this._newRouterTime < now - NEW_ROUTER_PERIOD) {
                this._newRouterCount = 1;
                this._newRouterTime = now;
                return false;
            }
            this._toRouters.remove(target);
        }
        return true;
    }

    private void distribute(I2NPMessage msg, RouterInfo target, TunnelId tunnel) {
        boolean toUs = this._context.routerHash().equals(target.getIdentity().calculateHash());
        if (toUs && msg instanceof UnknownI2NPMessage) {
            try {
                UnknownI2NPMessage umsg = (UnknownI2NPMessage)msg;
                msg = umsg.convert();
            }
            catch (I2NPMessageException ime) {
                if (this._log.shouldLog(30)) {
                    this._log.warn("Unable to convert to standard message class at zero-hop Inbound Gateway \n* " + ime.getMessage());
                }
                return;
            }
        }
        if (tunnel != null) {
            TunnelGatewayMessage t = new TunnelGatewayMessage(this._context);
            t.setMessage(msg);
            t.setTunnelId(tunnel);
            t.setMessageExpiration(msg.getMessageExpiration());
            msg = t;
        }
        if (toUs) {
            if (this._log.shouldDebug()) {
                this._log.debug("Queueing Inbound message to ourselves: " + msg);
            }
            this._context.inNetMessagePool().add(msg, null, null, 0L);
            return;
        }
        OutNetMessage out = new OutNetMessage(this._context, msg, this._context.clock().now() + 15000L, this._priority, target);
        if (this._log.shouldDebug()) {
            this._log.debug("Queueing Outbound message to: [" + target.getIdentity().calculateHash().toBase64().substring(0, 6) + "]");
        }
        this._context.outNetMessagePool().add(out);
    }

    private class DistributeJob
    extends JobImpl {
        private final I2NPMessage _message;
        private final Hash _target;
        private final TunnelId _tunnel;

        public DistributeJob(RouterContext ctx, I2NPMessage msg, Hash target, TunnelId id) {
            super(ctx);
            this._message = msg;
            this._target = target;
            this._tunnel = id;
        }

        @Override
        public String getName() {
            return "Distribute OBEP after Lookup";
        }

        @Override
        public void runJob() {
            int stat;
            RouterInfo info = this.getContext().netDb().lookupRouterInfoLocally(this._target);
            if (info != null) {
                if (OutboundMessageDistributor.this._log.shouldDebug()) {
                    OutboundMessageDistributor.this._log.debug("Lookup succeeded for Outbound distributor to [" + this._target.toBase64().substring(0, 6) + "]" + (this._tunnel != null ? " for [TunnelID " + this._tunnel.getTunnelId() + "]" : ""));
                }
                OutboundMessageDistributor.this.distribute(this._message, info, this._tunnel);
                stat = 1;
            } else {
                if (OutboundMessageDistributor.this._log.shouldWarn()) {
                    OutboundMessageDistributor.this._log.warn("Lookup failed for Outbound distributor to [" + this._target.toBase64().substring(0, 6) + "]" + (this._tunnel != null ? " for [TunnelID " + this._tunnel.getTunnelId() + "]" : ""));
                }
                stat = 0;
            }
            OutboundMessageDistributor.this._context.statManager().addRateData("tunnel.distributeLookupSuccess", stat);
        }
    }
}

