/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.List;
import java.util.concurrent.BlockingQueue;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.OutboundGatewayMessage;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.router.util.CoDelBlockingQueue;
import net.i2p.router.util.CoDelPriorityBlockingQueue;
import net.i2p.util.SystemVersion;

class PumpedTunnelGateway
extends TunnelGateway {
    private final BlockingQueue<PendingGatewayMessage> _prequeue;
    private final TunnelGatewayPumper _pumper;
    public final boolean _isInbound;
    private final Hash _nextHop;
    private static final int MAX_OB_MSGS_PER_PUMP = SystemVersion.isSlow() ? 256 : 1024;
    private static final int MAX_IB_MSGS_PER_PUMP = SystemVersion.isSlow() ? 128 : 512;
    private static final int INITIAL_OB_QUEUE = SystemVersion.isSlow() ? 128 : 512;
    private static final int MAX_IB_QUEUE = SystemVersion.isSlow() ? 1024 : 4096;
    public static final String PROP_MAX_OB_MSGS_PER_PUMP = "router.pumpMaxOutboundMsgs";
    public static final String PROP_MAX_IB_MSGS_PER_PUMP = "router.pumpMaxInboundMsgs";
    public static final String PROP_INITIAL_OB_QUEUE = "router.pumpInitialOutboundQueue";
    public static final String PROP_MAX_IB_QUEUE = "router.pumpMaxInboundQueue";

    public PumpedTunnelGateway(RouterContext context, TunnelGateway.QueuePreprocessor preprocessor, TunnelGateway.Sender sender, TunnelGateway.Receiver receiver, TunnelGatewayPumper pumper) {
        super(context, preprocessor, sender, receiver);
        if (this.getClass() == PumpedTunnelGateway.class) {
            this._prequeue = new CoDelPriorityBlockingQueue<PendingGatewayMessage>(context, "OBGW", context.getProperty(PROP_INITIAL_OB_QUEUE, INITIAL_OB_QUEUE));
            this._nextHop = receiver.getSendTo();
            this._isInbound = false;
        } else {
            this._prequeue = new CoDelBlockingQueue<PendingGatewayMessage>(context, "IBGW", context.getProperty(PROP_MAX_IB_QUEUE, MAX_IB_QUEUE));
            this._nextHop = receiver.getSendTo();
            this._isInbound = true;
        }
        this._pumper = pumper;
    }

    @Override
    public void add(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
        OutboundGatewayMessage cur = new OutboundGatewayMessage(msg, toRouter, toTunnel);
        if (this._log.shouldDebug()) {
            this._log.debug("Outbound PumpedTunnelGateway added [Type " + msg.getType() + "] at priority: " + cur.getPriority());
        }
        this.add(cur);
    }

    protected void add(PendingGatewayMessage cur) {
        ++this._messagesSent;
        if (this._prequeue.offer(cur)) {
            this._pumper.wantsPumping(this);
        } else {
            this._context.statManager().addRateData("tunnel.dropGatewayOverflow", 1L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean pump(List<PendingGatewayMessage> queueBuf) {
        boolean highLoad;
        boolean backlogged = this._context.commSystem().isBacklogged(this._nextHop);
        long lag = this._context.jobQueue().getMaxLag();
        boolean bl = highLoad = SystemVersion.getCPULoadAvg() > 95 && lag > 1000L;
        if (backlogged && this._log.shouldInfo()) {
            this._log.info("PumpedTunnelGateway backlogged, queued to " + this._nextHop + " : " + this._prequeue.size() + " Inbound? " + this._isInbound);
        }
        int max = backlogged ? (this._isInbound ? 1 : 2) : (this._isInbound ? this._context.getProperty(PROP_MAX_IB_MSGS_PER_PUMP, MAX_IB_MSGS_PER_PUMP) : this._context.getProperty(PROP_MAX_OB_MSGS_PER_PUMP, MAX_OB_MSGS_PER_PUMP));
        this._prequeue.drainTo(queueBuf, max);
        if (queueBuf.isEmpty()) {
            return false;
        }
        boolean rv = !this._prequeue.isEmpty();
        boolean debug = this._log.shouldDebug();
        long startAdd = debug ? this._context.clock().now() : 0L;
        long beforeLock = startAdd;
        long afterAdded = -1L;
        boolean delayedFlush = false;
        long delayAmount = -1L;
        int remaining = 0;
        long afterPreprocess = 0L;
        long afterExpire = 0L;
        List list = this._queue;
        synchronized (list) {
            this._queue.addAll(queueBuf);
            if (debug) {
                afterAdded = this._context.clock().now();
                this._log.debug("Added before direct flush preprocessing for " + this.toString() + ":\n* " + this._queue);
            }
            delayedFlush = this._preprocessor.preprocessQueue(this._queue, this._sender, this._receiver);
            if (debug) {
                afterPreprocess = this._context.clock().now();
            }
            if (delayedFlush) {
                delayAmount = this._preprocessor.getDelayAmount();
            }
            this._lastFlush = this._context.clock().now();
            for (int i = 0; i < this._queue.size(); ++i) {
                PendingGatewayMessage m = (PendingGatewayMessage)this._queue.get(i);
                if (m.getExpiration() + 60000L >= this._lastFlush) continue;
                if (debug) {
                    this._log.debug("Expire on the queue (size=" + this._queue.size() + "): " + m);
                }
                this._queue.remove(i);
                --i;
            }
            remaining = this._queue.size();
            if (remaining > 0 && debug) {
                afterExpire = this._context.clock().now();
                this._log.debug("Remaining after preprocessing: " + this._queue);
            }
            queueBuf.clear();
        }
        if (delayedFlush) {
            this._delayedFlush.reschedule(delayAmount);
        }
        if (debug) {
            long complete = this._context.clock().now();
            this._log.debug("Time to add " + queueBuf.size() + " messages to " + this.toString() + ":" + (complete - startAdd) + "\n* Delayed? " + delayedFlush + "; Remaining: " + remaining + "; Add: " + (afterAdded - beforeLock) + "; Preprocess: " + (afterPreprocess - afterAdded) + "; Expire: " + (afterExpire - afterPreprocess) + "; Queue flush: " + (complete - afterExpire));
        }
        if (rv && this._log.shouldInfo()) {
            this._log.info("PumpedTunnelGateway remaining to [" + this._nextHop.toBase64().substring(0, 6) + "] -> Pre-queue: " + this._prequeue.size() + "bytes; Inbound? " + this._isInbound + "; Backlogged? " + backlogged);
        }
        return rv;
    }
}

