/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.router.JobImpl;
import net.i2p.router.RouterContext;
import net.i2p.router.Service;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.tunnel.BatchedRouterPreprocessor;
import net.i2p.router.tunnel.BloomFilterIVValidator;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundGatewayReceiver;
import net.i2p.router.tunnel.InboundSender;
import net.i2p.router.tunnel.OutboundReceiver;
import net.i2p.router.tunnel.OutboundSender;
import net.i2p.router.tunnel.OutboundTunnelEndpoint;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.router.tunnel.ThrottledPumpedTunnelGateway;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelGateway;
import net.i2p.router.tunnel.TunnelGatewayPumper;
import net.i2p.router.tunnel.TunnelGatewayZeroHop;
import net.i2p.router.tunnel.TunnelParticipant;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.util.Log;

public class TunnelDispatcher
implements Service {
    private final RouterContext _context;
    private final Log _log;
    private final ConcurrentHashMap<TunnelId, TunnelGateway> _outboundGateways;
    private final ConcurrentHashMap<TunnelId, OutboundTunnelEndpoint> _outboundEndpoints;
    private final ConcurrentHashMap<TunnelId, TunnelParticipant> _participants;
    private final ConcurrentHashMap<TunnelId, TunnelGateway> _inboundGateways;
    private final ConcurrentHashMap<TunnelId, HopConfig> _participatingConfig;
    private long _lastParticipatingExpiration;
    private BloomFilterIVValidator _validator;
    private final LeaveTunnel _leaveJob;
    private final TunnelGatewayPumper _pumper;
    private final Object _joinParticipantLock = new Object();
    private final AtomicInteger _allocatedBW = new AtomicInteger();
    private static final long[] RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
    private static final long MAX_FUTURE_EXPIRATION = 300000L;

    public TunnelDispatcher(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelDispatcher.class);
        this._outboundGateways = new ConcurrentHashMap();
        this._outboundEndpoints = new ConcurrentHashMap();
        this._participants = new ConcurrentHashMap();
        this._inboundGateways = new ConcurrentHashMap();
        this._participatingConfig = new ConcurrentHashMap();
        this._pumper = new TunnelGatewayPumper(ctx);
        this._leaveJob = new LeaveTunnel(ctx);
        ctx.statManager().createRequiredRateStat("tunnel.participatingTunnels", "Tunnels routed for others", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dispatchOutboundPeer", "Outbound messages targeting a peer", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dispatchOutboundTunnel", "Outbound messages targeting a tunnel", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dispatchInbound", "Messages we sent through our Tunnel Gateway", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dispatchParticipant", "Messages we sent through a tunnel we are participating in", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dispatchEndpoint", "Messages received as Outbound Endpoint of a tunnel", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinOutboundGateway", "Tunnels joined as Outbound Gateway", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinOutboundGatewayZeroHop", "Zero hop tunnels joined as Outbound Gateway", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinInboundEndpoint", "Tunnels joined as Inbound Endpoint", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinInboundEndpointZeroHop", "Zero hop tunnels joined as Inbound Endpoint", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinParticipant", "Tunnels joined as participant", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinOutboundEndpoint", "Tunnels joined as Outbound Endpoint", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.joinInboundGateway", "Tunnels joined as Inbound Gateway", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.participating InBps", "In (B/s) for Participating tunnels ", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.participating OutBps", "Out (B/s) for Participating tunnels", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.participatingMessageDropped", "Dropped participating messages (share limit exceeded)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.participatingMessageCount", "Total 1KB participating messages", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.participatingMessageCountAvgPerTunnel", "Estimated participating messages per tunnel lifetime", "Tunnels [Participating]", new long[]{60000L, 1200000L});
        ctx.statManager().createRateStat("tunnel.ownedMessageCount", "Messages sent through a tunnel we created", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.failedCompletelyMessages", "Messages sent through a prematurely failed tunnel", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.failedPartially", "Messages sent through a partially failed tunnel", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.batchMultipleCount", "Messages batched into a tunnel message", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchDelay", "Messages pending when the batching waited", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchDelaySent", "Messages flushed when the batching delay completed", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchCount", "Number of groups of messages flushed together", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchDelayAmount", "Delay before flushing the batch", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchFlushRemaining", "Messages remaining after flush", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.writeDelay", "Message processing time after reaching gateway (ms)", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchSmallFragments", "Number of outgoing pad bytes in small fragments", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchFullFragments", "Outgoing tunnel messages using full data area", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.batchFragmentation", "Average number of fragments per message", "Tunnels [BatchedPreprocessor]", RATES);
        ctx.statManager().createRateStat("tunnel.distributeLookupSuccess", "Success rate for deferred lookup (outbound distribution)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.dropAtOBEP", "Tunnels droppped at Outbound Endpoint (throttled)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.outboundLookupSuccess", "Success rate for deferred lookup (outbound receive)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.inboundLookupSuccess", "Success rate for deferred lookup (inbound receive)", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.participantLookupSuccess", "Success rate for deferred lookup (tunnel participant)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.buildRequestDup", "How often we get duplicate build request messages", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.buildRequestBadReplyKey", "Build requests with bad reply keys", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.smallFragments", "Number of pad bytes in small fragments", "Tunnels [FragmentHandler]", RATES);
        ctx.statManager().createRateStat("tunnel.fullFragments", "Tunnel messages using full data area", "Tunnels [FragmentHandler]", RATES);
        ctx.statManager().createRateStat("tunnel.fragmentedComplete", "Fragments in a completely received message", "Tunnels [FragmentHandler]", RATES);
        ctx.statManager().createRateStat("tunnel.fragmentedDropped", "Total dropped fragments", "Tunnels [FragmentHandler]", RATES);
        ctx.statManager().createRateStat("tunnel.corruptMessage", "Total corrupt messages received", "Tunnels [FragmentHandler]", RATES);
        ctx.statManager().createRateStat("tunnel.dropDangerousClientTunnelMessage", "Dropped dangerous Inbound messages", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.dropDangerousExplTunnelMessage", "Dropped dangerous Exploratory messages", "Tunnels [Exploratory]", RATES);
        ctx.statManager().createRateStat("tunnel.handleLoadClove", "How often we load test cloves", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.dropGatewayOverflow", "Messages dropped at gateway (queue full)", "Tunnels", RATES);
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(HopConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    private TunnelGateway.QueuePreprocessor createPreprocessor(TunnelCreatorConfig cfg) {
        return new BatchedRouterPreprocessor(this._context, cfg);
    }

    public boolean joinOutbound(PooledTunnelCreatorConfig cfg) {
        TunnelGateway gw;
        if (this._log.shouldInfo()) {
            this._log.info("Outbound Gateway built successfully: " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
            OutboundSender sender = new OutboundSender(this._context, cfg);
            OutboundReceiver receiver = new OutboundReceiver(this._context, cfg);
            gw = new PumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper);
        } else {
            gw = new TunnelGatewayZeroHop(this._context, cfg);
        }
        TunnelId outId = cfg.getConfig(0).getSendTunnel();
        if (this._outboundGateways.putIfAbsent(outId, gw) != null) {
            return false;
        }
        if (cfg.getLength() > 1) {
            this._context.statManager().addRateData("tunnel.joinOutboundGateway", 1L);
            this._context.messageHistory().tunnelJoined("outbound", cfg);
        } else {
            this._context.statManager().addRateData("tunnel.joinOutboundGatewayZeroHop", 1L);
            this._context.messageHistory().tunnelJoined("outboundZeroHop", cfg);
        }
        return true;
    }

    public boolean joinInbound(TunnelCreatorConfig cfg) {
        if (this._log.shouldInfo()) {
            this._log.info("Inbound Endpoint built successfully " + cfg);
        }
        if (cfg.getLength() > 1) {
            TunnelParticipant participant = new TunnelParticipant(this._context, new InboundEndpointProcessor(this._context, cfg, this._validator));
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            if (this._participants.putIfAbsent(recvId, participant) != null) {
                return false;
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpoint", 1L);
            this._context.messageHistory().tunnelJoined("inboundEndpoint", cfg);
        } else {
            TunnelGatewayZeroHop gw = new TunnelGatewayZeroHop(this._context, cfg);
            TunnelId recvId = cfg.getConfig(0).getReceiveTunnel();
            if (this._inboundGateways.putIfAbsent(recvId, gw) != null) {
                return false;
            }
            this._context.statManager().addRateData("tunnel.joinInboundEndpointZeroHop", 1L);
            this._context.messageHistory().tunnelJoined("inboundEndpointZeroHop", cfg);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinParticipant(HopConfig cfg) {
        if (this._log.shouldInfo()) {
            this._log.info("Joining tunnel as participant " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        TunnelParticipant participant = new TunnelParticipant(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._participants.putIfAbsent(recvId, participant) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("participant", cfg);
        this._context.statManager().addRateData("tunnel.joinParticipant", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        this._allocatedBW.addAndGet(cfg.getAllocatedBW());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinOutboundEndpoint(HopConfig cfg) {
        if (this._log.shouldInfo()) {
            this._log.info("Joining tunnel as Outbound Endpoint " + cfg);
        }
        TunnelId recvId = cfg.getReceiveTunnel();
        OutboundTunnelEndpoint endpoint = new OutboundTunnelEndpoint(this._context, cfg, new HopProcessor(this._context, cfg, this._validator));
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._outboundEndpoints.putIfAbsent(recvId, endpoint) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("outboundEndpoint", cfg);
        this._context.statManager().addRateData("tunnel.joinOutboundEndpoint", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        this._allocatedBW.addAndGet(cfg.getAllocatedBW());
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean joinInboundGateway(HopConfig cfg) {
        if (this._log.shouldInfo()) {
            this._log.info("Joining tunnel as Inbound Gateway " + cfg);
        }
        TunnelGateway.QueuePreprocessor preproc = this.createPreprocessor(cfg);
        InboundSender sender = new InboundSender(this._context, cfg);
        InboundGatewayReceiver receiver = new InboundGatewayReceiver(this._context, cfg);
        ThrottledPumpedTunnelGateway gw = new ThrottledPumpedTunnelGateway(this._context, preproc, sender, receiver, this._pumper, cfg);
        TunnelId recvId = cfg.getReceiveTunnel();
        Object object = this._joinParticipantLock;
        synchronized (object) {
            if (this._participatingConfig.putIfAbsent(recvId, cfg) != null) {
                return false;
            }
            if (this._inboundGateways.putIfAbsent(recvId, gw) != null) {
                this._participatingConfig.remove(recvId);
                return false;
            }
        }
        this._context.messageHistory().tunnelJoined("inboundGateway", cfg);
        this._context.statManager().addRateData("tunnel.joinInboundGateway", 1L);
        if (cfg.getExpiration() > this._lastParticipatingExpiration) {
            this._lastParticipatingExpiration = cfg.getExpiration();
        }
        this._leaveJob.add(cfg);
        this._allocatedBW.addAndGet(cfg.getAllocatedBW());
        return true;
    }

    public int getAllocatedBW() {
        return this._allocatedBW.get();
    }

    public int getParticipatingCount() {
        return this._participatingConfig.size();
    }

    public TunnelId getNewOBGWID() {
        long id;
        TunnelId rv;
        while (this._outboundGateways.containsKey(rv = new TunnelId(id = 1L + this._context.random().nextLong(0xFFFFFFFFL)))) {
        }
        return rv;
    }

    public TunnelId getNewIBEPID() {
        long id;
        TunnelId rv;
        while (this._participants.containsKey(rv = new TunnelId(id = 1L + this._context.random().nextLong(0xFFFFFFFFL)))) {
        }
        return rv;
    }

    public TunnelId getNewIBZeroHopID() {
        long id;
        TunnelId rv;
        while (this._inboundGateways.containsKey(rv = new TunnelId(id = 1L + this._context.random().nextLong(0xFFFFFFFFL)))) {
        }
        return rv;
    }

    public long getLastParticipatingExpiration() {
        return this._lastParticipatingExpiration;
    }

    public void remove(TunnelCreatorConfig cfg) {
        if (cfg.isInbound()) {
            TunnelParticipant participant;
            TunnelId recvId = cfg.getConfig(cfg.getLength() - 1).getReceiveTunnel();
            if (this._log.shouldInfo()) {
                this._log.info("Removing our own Inbound tunnel...\n* " + cfg);
            }
            if ((participant = this._participants.remove(recvId)) == null) {
                this._inboundGateways.remove(recvId);
            } else {
                for (int i = 0; i < cfg.getLength() - 1; ++i) {
                    Hash peer = cfg.getPeer(i);
                    PeerProfile profile = this._context.profileOrganizer().getProfile(peer);
                    if (profile == null) continue;
                    int ok = participant.getCompleteCount();
                    int fail = participant.getFailedCount();
                    profile.getTunnelHistory().incrementProcessed(ok, fail);
                }
            }
        } else {
            TunnelId outId;
            TunnelGateway gw;
            if (this._log.shouldInfo()) {
                this._log.info("Removing our own Outbound tunnel...\n*  " + cfg);
            }
            if ((gw = this._outboundGateways.remove(outId = cfg.getConfig(0).getSendTunnel())) != null) {
                // empty if block
            }
        }
        long msgs = cfg.getProcessedMessagesCount();
        int failures = cfg.getTunnelFailures();
        boolean failed = cfg.getTunnelFailed();
        this._context.statManager().addRateData("tunnel.ownedMessageCount", msgs, failures);
        if (failed) {
            this._context.statManager().addRateData("tunnel.failedCompletelyMessages", msgs, failures);
        } else if (failures > 0) {
            this._context.statManager().addRateData("tunnel.failedPartiallyMessages", msgs, failures);
        }
    }

    public void remove(HopConfig cfg) {
        boolean removed;
        TunnelId recvId = cfg.getReceiveTunnel();
        boolean bl = removed = null != this._participatingConfig.remove(recvId);
        if (removed) {
            if (this._log.shouldInfo()) {
                this._log.info("Removing Participating tunnel config... " + cfg);
            }
        } else if (this._log.shouldDebug()) {
            this._log.debug("Participating in tunnel, but no longer listed in participatingConfig? " + cfg);
        }
        boolean bl2 = removed = null != this._participants.remove(recvId);
        if (removed) {
            return;
        }
        boolean bl3 = removed = null != this._inboundGateways.remove(recvId);
        if (removed) {
            return;
        }
        this._outboundEndpoints.remove(recvId);
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        TunnelParticipant participant = this._participants.get(msg.getTunnelIdObj());
        if (participant != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Dispatch to: " + participant + " [MsgID " + msg.getUniqueId() + "] from [" + recvFrom.toBase64().substring(0, 6) + "]");
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "participant");
            participant.dispatch(msg, recvFrom);
            this._context.statManager().addRateData("tunnel.dispatchParticipant", 1L);
        } else {
            OutboundTunnelEndpoint endpoint = this._outboundEndpoints.get(msg.getTunnelIdObj());
            if (endpoint != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Dispatch where we are the Outbound Endpoint:\n* " + endpoint + ": " + msg + " from [" + recvFrom.toBase64().substring(0, 6) + "]");
                }
                this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), msg.getTunnelId(), "outbound endpoint");
                endpoint.dispatch(msg, recvFrom);
                this._context.statManager().addRateData("tunnel.dispatchEndpoint", 1L);
            } else {
                int level;
                this._context.messageHistory().droppedTunnelDataMessageUnknown(msg.getUniqueId(), msg.getTunnelId());
                int n = level = this._context.router().getUptime() > 600000L ? 30 : 10;
                if (this._log.shouldLog(level)) {
                    this._log.log(level, "No matching participant/endpoint for [TunnelID " + msg.getTunnelId() + "]\n* Expires: " + DataHelper.formatDuration(msg.getMessageExpiration() - this._context.clock().now()) + "\n* Existing: " + this._participants.size() + " / " + this._outboundEndpoints.size());
                }
            }
        }
    }

    public void dispatch(TunnelGatewayMessage msg) {
        long before = this._context.clock().now();
        TunnelId id = msg.getTunnelId();
        TunnelGateway gw = this._inboundGateways.get(id);
        I2NPMessage submsg = msg.getMessage();
        if (submsg == null) {
            throw new IllegalArgumentException("TGM message is null");
        }
        if (gw != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Dispatch where we are the Inbound gateway:\n* " + gw + ": " + msg);
            }
            long minTime = before - 60000L;
            long maxTime = before + 300000L;
            long exp = msg.getMessageExpiration();
            long subexp = submsg.getMessageExpiration();
            if (exp < minTime || subexp < minTime || exp > maxTime || subexp > maxTime) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Not dispatching GatewayMessage for [TunnelID " + id.getTunnelId() + "]\n* Wrapper's expiration -> " + DataHelper.formatDuration(exp - before) + " and/or content expiration -> " + DataHelper.formatDuration(subexp - before) + "\n* Type: " + submsg.getType() + " [MsgID " + id + "/" + submsg.getUniqueId() + "]");
                }
                return;
            }
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), submsg.getUniqueId(), id.getTunnelId(), "inbound gateway");
            gw.add(msg);
            this._context.statManager().addRateData("tunnel.dispatchInbound", 1L);
        } else {
            int level;
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), id.getTunnelId());
            int n = level = this._context.router().getUptime() > 600000L ? 30 : 20;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "No matching tunnel for [TunnelID " + id.getTunnelId() + "]\n* Gateway message expires: " + DataHelper.formatDuration(msg.getMessageExpiration() - before) + "/" + DataHelper.formatDuration(submsg.getMessageExpiration() - before) + " [MsgID " + id + "/" + msg.getMessage().getUniqueId() + "] Type: " + submsg.getType() + "; Existing: " + this._inboundGateways.size());
            }
        }
    }

    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, Hash targetPeer) {
        this.dispatchOutbound(msg, outboundTunnel, null, targetPeer);
    }

    public void dispatchOutbound(I2NPMessage msg, TunnelId outboundTunnel, TunnelId targetTunnel, Hash targetPeer) {
        if (outboundTunnel == null) {
            throw new IllegalArgumentException("null outbound tunnel?");
        }
        long before = this._context.clock().now();
        TunnelGateway gw = this._outboundGateways.get(outboundTunnel);
        if (gw != null) {
            if (this._log.shouldDebug()) {
                this._log.debug("Dispatch Outbound through " + outboundTunnel.getTunnelId() + ": " + msg);
            }
            if (msg.getMessageExpiration() < before - 60000L) {
                if (this._log.shouldError()) {
                    this._log.error("Why are we sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, new Exception("cause"));
                }
                return;
            }
            if (msg.getMessageExpiration() < before) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Why are we sending a tunnel message that expired " + (before - msg.getMessageExpiration()) + "ms ago? " + msg, new Exception("cause"));
                }
            } else if (msg.getMessageExpiration() > before + 300000L) {
                if (this._log.shouldError()) {
                    this._log.error("Why are we sending a tunnel message that expires " + (msg.getMessageExpiration() - before) + "ms from now? " + msg, new Exception("cause"));
                }
                return;
            }
            long tid1 = outboundTunnel.getTunnelId();
            long tid2 = targetTunnel != null ? targetTunnel.getTunnelId() : -1L;
            this._context.messageHistory().tunnelDispatched(msg.getUniqueId(), tid1, tid2, targetPeer, "Outbound gateway");
            gw.add(msg, targetPeer, targetTunnel);
            if (targetTunnel == null) {
                this._context.statManager().addRateData("tunnel.dispatchOutboundPeer", 1L);
            } else {
                this._context.statManager().addRateData("tunnel.dispatchOutboundTunnel", 1L);
            }
        } else {
            this._context.messageHistory().droppedTunnelGatewayMessageUnknown(msg.getUniqueId(), outboundTunnel.getTunnelId());
            int level = 30;
            if (this._log.shouldLog(level)) {
                this._log.log(level, "No matching Outbound tunnel for id=" + outboundTunnel + ": existing = " + this._outboundGateways.size(), new Exception("src"));
            }
        }
    }

    public List<HopConfig> listParticipatingTunnels() {
        return new ArrayList<HopConfig>(this._participatingConfig.values());
    }

    public void updateParticipatingStats(int ms) {
        int partCount = this._context.tunnelManager().getParticipatingCount();
        long count = 0L;
        long bw = 0L;
        long tcount = 0L;
        long tooYoung = this._context.clock().now() - 60000L;
        long tooOld = tooYoung - 540000L;
        for (HopConfig cfg : this._participatingConfig.values()) {
            long c = cfg.getAndResetRecentMessagesCount();
            bw += c;
            long created = cfg.getCreation();
            if (created > tooYoung || created < tooOld) continue;
            ++tcount;
            count += c;
        }
        if (tcount > 0L) {
            count = count * (long)(600000 / ms) / tcount;
        }
        this._context.statManager().addRateData("tunnel.participatingMessageCountAvgPerTunnel", count, ms);
        this._context.statManager().addRateData("tunnel.participatingMessageCount", bw, ms);
        this._context.statManager().addRateData("tunnel.participating InBps", bw * 1024L / (long)(ms / 1000), ms);
        this._context.statManager().addRateData("tunnel.participatingTunnels", partCount);
    }

    public boolean shouldDropParticipatingMessage(Location loc, int type, int length) {
        boolean reject;
        if (length <= 0) {
            return false;
        }
        float factor = loc == Location.OBEP ? (type == 23 || type == 21 || type == 25 ? 0.6666667f : 1.5f) : (loc == Location.IBGW ? (type == 24 || type == 22 || type == 26 ? 0.2962963f : 0.6666667f) : 1.0f);
        boolean bl = reject = !this._context.bandwidthLimiter().sentParticipatingMessage(length, factor);
        if (reject) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Participating message [factor=" + factor + ' ' + (Object)((Object)loc) + ' ' + type + ' ' + length + "]");
            }
            this._context.statManager().addRateData("tunnel.participatingMessageDropped", 1L);
        }
        return reject;
    }

    @Override
    public synchronized void startup() {
        this._validator = new BloomFilterIVValidator(this._context, TunnelDispatcher.getShareBandwidth(this._context));
    }

    public static int getShareBandwidth(RouterContext ctx) {
        int irateKBps = ctx.bandwidthLimiter().getInboundKBytesPerSecond();
        int orateKBps = ctx.bandwidthLimiter().getOutboundKBytesPerSecond();
        double pct = ctx.router().getSharePercentage();
        return (int)(pct * (double)Math.min(irateKBps, orateKBps));
    }

    @Override
    public synchronized void shutdown() {
        if (this._validator != null) {
            this._validator.destroy();
        }
        this._validator = null;
        this._pumper.stopPumping();
        this._outboundGateways.clear();
        this._outboundEndpoints.clear();
        this._participants.clear();
        this._inboundGateways.clear();
        this._participatingConfig.clear();
        this._leaveJob.clear();
    }

    @Override
    public void restart() {
        this.shutdown();
        this.startup();
    }

    @Override
    @Deprecated
    public void renderStatusHTML(Writer out) throws IOException {
    }

    private class LeaveTunnel
    extends JobImpl {
        private final LinkedBlockingQueue<HopConfig> _configs;
        private static final int LEAVE_BATCH_TIME = 10000;

        public LeaveTunnel(RouterContext ctx) {
            super(ctx);
            this._configs = new LinkedBlockingQueue();
            this.getTiming().setStartAfter(ctx.clock().now() + 600000L);
            this.getContext().jobQueue().addJob(this);
        }

        public void add(HopConfig cfg) {
            this._configs.offer(cfg);
        }

        public void clear() {
            this._configs.clear();
        }

        @Override
        public String getName() {
            return "Expire Participating Tunnels";
        }

        @Override
        public void runJob() {
            HopConfig cur = null;
            long now = this.getContext().clock().now() + 10000L;
            long nextTime = now + 600000L;
            while ((cur = this._configs.peek()) != null) {
                long exp = cur.getExpiration() + 90000L + 10000L;
                if (exp < now) {
                    this._configs.poll();
                    if (TunnelDispatcher.this._log.shouldInfo()) {
                        TunnelDispatcher.this._log.info("Expiring Participating tunnel... " + cur);
                    }
                    TunnelDispatcher.this.remove(cur);
                    TunnelDispatcher.this._allocatedBW.addAndGet(0 - cur.getAllocatedBW());
                    continue;
                }
                if (exp >= nextTime) break;
                nextTime = exp;
                break;
            }
            this.getTiming().setStartAfter(nextTime);
            this.getContext().jobQueue().addJob(this);
        }
    }

    static enum Location {
        OBEP,
        PARTICIPANT,
        IBGW;

    }
}

