/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.LinkedBlockingQueue;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.PendingGatewayMessage;
import net.i2p.router.tunnel.PumpedTunnelGateway;
import net.i2p.util.I2PThread;
import net.i2p.util.Log;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;

class TunnelGatewayPumper
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final BlockingQueue<PumpedTunnelGateway> _wantsPumping;
    private final ConcurrentHashMap<PumpedTunnelGateway, Boolean> _backlogged;
    private final List<Thread> _threads;
    private volatile boolean _stop;
    private static final int MIN_PUMPERS = 1;
    private static final int MAX_PUMPERS = SystemVersion.isSlow() ? 2 : 4;
    private static final int QUEUE_BUFFER = SystemVersion.isSlow() ? 16 : 32;
    private final int _pumpers;
    private static final long REQUEUE_TIME = SystemVersion.isSlow() ? 50L : 30L;
    private static final int POISON_PTG = -99999;

    public TunnelGatewayPumper(RouterContext ctx) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelGatewayPumper.class);
        this._wantsPumping = new LinkedBlockingQueue<PumpedTunnelGateway>(QUEUE_BUFFER);
        this._backlogged = new ConcurrentHashMap(QUEUE_BUFFER);
        this._threads = new CopyOnWriteArrayList<Thread>();
        this._pumpers = ctx.getBooleanProperty("i2p.dummyTunnelManager") ? 1 : MAX_PUMPERS;
        for (int i = 0; i < this._pumpers; ++i) {
            I2PThread t = new I2PThread(this, "TunnGWPumper " + (i + 1) + '/' + this._pumpers, true);
            t.setPriority(10);
            this._threads.add(t);
            ((Thread)t).start();
        }
    }

    public void stopPumping() {
        long adjusted;
        this._stop = true;
        this._wantsPumping.clear();
        for (int i = 0; i < this._pumpers; ++i) {
            PoisonPTG poison = new PoisonPTG(this._context);
            this.wantsPumping(poison);
        }
        long l = adjusted = SystemVersion.getCPULoadAvg() > 95 ? REQUEUE_TIME * 3L / 2L : REQUEUE_TIME;
        if (this._log.shouldWarn() && adjusted != REQUEUE_TIME) {
            this._log.warn("Router JVM under sustained high CPU load, increasing pump interval from " + REQUEUE_TIME + " to " + adjusted + "ms");
        }
        for (Thread t : this._threads) {
            t.interrupt();
        }
        this._threads.clear();
        this._backlogged.clear();
    }

    public void wantsPumping(PumpedTunnelGateway gw) {
        if (!this._stop && !this._backlogged.containsKey(gw)) {
            this._wantsPumping.offer(gw);
        }
    }

    @Override
    public void run() {
        try {
            this.run2();
        }
        catch (Exception e) {
            this._log.error("Error in TunnelGatewayPumper run", e);
        }
        finally {
            this._threads.remove(Thread.currentThread());
        }
    }

    private void run2() {
        PumpedTunnelGateway gw = null;
        ArrayList<PendingGatewayMessage> queueBuf = new ArrayList<PendingGatewayMessage>(QUEUE_BUFFER);
        while (!this._stop) {
            try {
                gw = this._wantsPumping.take();
                if (gw.getMessagesSent() == -99999) break;
                boolean requeue = gw.pump(queueBuf);
                if (!requeue) continue;
                this.handleRequeue(gw);
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                break;
            }
            catch (Exception e) {
                this._log.error("Error processing gateway: " + gw, e);
            }
        }
    }

    private void handleRequeue(PumpedTunnelGateway gw) {
        if (this._backlogged.putIfAbsent(gw, true) == null) {
            this._context.simpleTimer2().addEvent(new Requeue(gw), REQUEUE_TIME);
        }
    }

    private static class PoisonPTG
    extends PumpedTunnelGateway {
        public PoisonPTG(RouterContext ctx) {
            super(ctx, null, null, null, null);
        }

        @Override
        public int getMessagesSent() {
            return -99999;
        }
    }

    private class Requeue
    implements SimpleTimer.TimedEvent {
        private final PumpedTunnelGateway _ptg;

        public Requeue(PumpedTunnelGateway ptg) {
            this._ptg = ptg;
        }

        @Override
        public void timeReached() {
            TunnelGatewayPumper.this._backlogged.remove(this._ptg);
            TunnelGatewayPumper.this._wantsPumping.offer(this._ptg);
        }
    }
}

