/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel;

import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.TunnelDataMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.tunnel.FragmentHandler;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.HopProcessor;
import net.i2p.router.tunnel.InboundEndpointProcessor;
import net.i2p.router.tunnel.InboundMessageDistributor;
import net.i2p.router.tunnel.TunnelCreatorConfig;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.util.Log;

class TunnelParticipant {
    private final RouterContext _context;
    private final Log _log;
    private final HopConfig _config;
    private final HopProcessor _processor;
    private final InboundEndpointProcessor _inboundEndpointProcessor;
    private final InboundMessageDistributor _inboundDistributor;
    private final FragmentHandler _handler;
    private RouterInfo _nextHopCache;
    private static final long MAX_LOOKUP_TIME = 15000L;
    private static final long LONG_MAX_LOOKUP_TIME = 25000L;
    private static final int PRIORITY = 200;

    public TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor) {
        this(ctx, config, processor, null);
    }

    public TunnelParticipant(RouterContext ctx, InboundEndpointProcessor inEndProc) {
        this(ctx, null, null, inEndProc);
    }

    private TunnelParticipant(RouterContext ctx, HopConfig config, HopProcessor processor, InboundEndpointProcessor inEndProc) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(TunnelParticipant.class);
        this._config = config;
        this._processor = processor;
        this._handler = config == null || config.getSendTo() == null ? new FragmentHandler(ctx, new DefragmentedHandler(), true) : null;
        this._inboundEndpointProcessor = inEndProc;
        this._inboundDistributor = inEndProc != null ? new InboundMessageDistributor(ctx, inEndProc.getDestination()) : null;
        if (this._config != null && this._config.getSendTo() != null) {
            this._nextHopCache = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
            if (this._nextHopCache == null) {
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new Found(this._context), null, 25000L);
            }
        }
    }

    public void dispatch(TunnelDataMessage msg, Hash recvFrom) {
        block16: {
            int lenm1;
            byte[] data;
            boolean ok;
            block14: {
                RouterInfo ri;
                block15: {
                    ok = false;
                    data = msg.getData();
                    if (this._processor != null) {
                        ok = this._processor.process(data, 0, data.length, recvFrom);
                    } else if (this._inboundEndpointProcessor != null) {
                        ok = this._inboundEndpointProcessor.retrievePreprocessedData(data, 0, data.length, recvFrom);
                    }
                    if (!ok) {
                        if (this._log.shouldInfo()) {
                            this._log.warn("Failed to dispatch " + msg + "\n* Processor: " + this._processor + "\n* Inbound Endpoint: " + this._inboundEndpointProcessor);
                        } else if (this._log.shouldWarn()) {
                            this._log.warn("Failed to dispatch " + msg + " via " + (this._processor != null ? this._processor : "NULL tunnel"));
                        }
                        if (this._config != null) {
                            this._config.incrementProcessedMessages();
                        }
                        return;
                    }
                    if (this._config == null || this._config.getSendTo() == null) break block14;
                    this._config.incrementProcessedMessages();
                    ri = this._nextHopCache;
                    if (ri == null) break block15;
                    this.send(this._config, msg, ri);
                    if (this._log.shouldDebug()) {
                        this._log.debug("Dispatched " + msg + " directly to nextHop [" + this._config.getSendTo().toBase64().substring(0, 6) + "]");
                    }
                    break block16;
                }
                ri = this._context.netDb().lookupRouterInfoLocally(this._config.getSendTo());
                this._context.netDb().lookupRouterInfo(this._config.getSendTo(), new SendJob(this._context, msg), new TimeoutJob(this._context, msg), 15000L);
                if (!this._log.shouldInfo()) break block16;
                this._log.info("Looking up nextHop [" + this._config.getSendTo().toBase64().substring(0, 6) + "] for " + msg);
                break block16;
            }
            TunnelCreatorConfig cfg = this._inboundEndpointProcessor.getConfig();
            cfg.incrementProcessedMessages();
            ok = this._handler.receiveTunnelMessage(data, 0, data.length);
            if (ok && this._log.shouldDebug()) {
                this._log.debug("Received fragment on " + this._config + ": " + msg);
            } else if (!ok && (lenm1 = cfg.getLength() - 1) > 0) {
                int pct = 100 / lenm1;
                for (int i = 0; i < lenm1; ++i) {
                    Hash h = cfg.getPeer(i);
                    if (this._log.shouldWarn()) {
                        this._log.warn(this.toString() + ": Blaming [" + h.toBase64().substring(0, 6) + "] -> " + pct + '%');
                    }
                    this._context.profileManager().tunnelFailed(h, pct);
                }
            }
        }
    }

    public int getCompleteCount() {
        if (this._handler != null) {
            return this._handler.getCompleteCount();
        }
        return 0;
    }

    public int getFailedCount() {
        if (this._handler != null) {
            return this._handler.getFailedCount();
        }
        return 0;
    }

    private void send(HopConfig config, TunnelDataMessage msg, RouterInfo ri) {
        if (this._context.tunnelDispatcher().shouldDropParticipatingMessage(TunnelDispatcher.Location.PARTICIPANT, 18, 1024)) {
            return;
        }
        long oldId = msg.getUniqueId();
        long newId = this._context.random().nextLong(0xFFFFFFFFL);
        this._context.messageHistory().wrap("TunnelDataMessage", oldId, "TunnelDataMessage", newId);
        msg.setUniqueId(newId);
        msg.setMessageExpiration(this._context.clock().now() + 10000L);
        msg.setTunnelId(config.getSendTunnel());
        OutNetMessage m = new OutNetMessage(this._context, msg, msg.getMessageExpiration(), 200, ri);
        if (this._log.shouldDebug()) {
            this._log.debug("Forward on from " + this._config + ": " + msg);
        }
        this._context.outNetMessagePool().add(m);
    }

    public String toString() {
        if (this._config != null) {
            StringBuilder buf = new StringBuilder(64);
            buf.append("participant at ").append(this._config.toString());
            return buf.toString();
        }
        return "Inbound Endpoint";
    }

    private class TimeoutJob
    extends JobImpl {
        private final TunnelDataMessage _msg;

        public TimeoutJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        @Override
        public String getName() {
            return "Participant next hop lookup timeout";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                return;
            }
            RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
            if (ri != null) {
                TunnelParticipant.this._nextHopCache = ri;
                if (TunnelParticipant.this._log.shouldWarn()) {
                    TunnelParticipant.this._log.warn("Lookup of nextHop [" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 6) + "] failed, but we found it!! Where do we go for " + TunnelParticipant.this._config + "? -> Message dropped: " + this._msg);
                }
            } else if (TunnelParticipant.this._log.shouldWarn()) {
                TunnelParticipant.this._log.warn("Lookup of nextHop [" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 6) + "] failed! Where do we go for " + TunnelParticipant.this._config + "? -> Message dropped: " + this._msg);
            }
            TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", 0L);
        }
    }

    private class SendJob
    extends JobImpl {
        private final TunnelDataMessage _msg;

        public SendJob(RouterContext ctx, TunnelDataMessage msg) {
            super(ctx);
            this._msg = msg;
        }

        @Override
        public String getName() {
            return "Participant send after lookup";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache != null) {
                TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, TunnelParticipant.this._nextHopCache);
            } else {
                int stat;
                RouterInfo ri = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
                if (ri != null) {
                    TunnelParticipant.this._nextHopCache = ri;
                    TunnelParticipant.this.send(TunnelParticipant.this._config, this._msg, ri);
                    stat = 1;
                } else {
                    if (TunnelParticipant.this._log.shouldWarn()) {
                        TunnelParticipant.this._log.warn("Lookup of nextHop [" + TunnelParticipant.this._config.getSendTo().toBase64().substring(0, 6) + "] failed! Where do we go for " + TunnelParticipant.this._config + "?  -> Message dropped: " + this._msg);
                    }
                    stat = 0;
                }
                TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", stat);
            }
        }
    }

    private class DefragmentedHandler
    implements FragmentHandler.DefragmentedReceiver {
        private DefragmentedHandler() {
        }

        @Override
        public void receiveComplete(I2NPMessage msg, Hash toRouter, TunnelId toTunnel) {
            if (TunnelParticipant.this._log.shouldDebug()) {
                TunnelParticipant.this._log.debug("Receive complete: on " + TunnelParticipant.this._config + ": " + msg);
            }
            TunnelParticipant.this._inboundDistributor.distribute(msg, toRouter, toTunnel);
        }
    }

    private class Found
    extends JobImpl {
        public Found(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public String getName() {
            return "Verify Next Hop Info Found";
        }

        @Override
        public void runJob() {
            if (TunnelParticipant.this._nextHopCache == null) {
                TunnelParticipant.this._nextHopCache = TunnelParticipant.this._context.netDb().lookupRouterInfoLocally(TunnelParticipant.this._config.getSendTo());
                TunnelParticipant.this._context.statManager().addRateData("tunnel.participantLookupSuccess", 1L);
            }
        }
    }
}

