/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.CommSystemFacade;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.tunnel.pool.BuildRequestor;
import net.i2p.router.tunnel.pool.ExpireJob;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.stat.StatManager;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;

class BuildExecutor
implements Runnable {
    private final ArrayList<Long> _recentBuildIds = new ArrayList(256);
    private final RouterContext _context;
    private final Log _log;
    private final TunnelPoolManager _manager;
    private final Object _currentlyBuilding;
    private final ConcurrentHashMap<Long, PooledTunnelCreatorConfig> _currentlyBuildingMap;
    private final ConcurrentHashMap<Long, PooledTunnelCreatorConfig> _recentlyBuildingMap;
    private volatile boolean _isRunning;
    private boolean _repoll;
    private static final int MAX_CONCURRENT_BUILDS = SystemVersion.isSlow() ? 10 : Math.max(SystemVersion.getCores() * 4, 16);
    private static final int TUNNEL_POOLS = SystemVersion.isSlow() ? 12 : 32;
    private static final long GRACE_PERIOD = 60000L;
    private static final long[] RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
    private static final int LOOP_TIME = 200;

    public boolean fullStats() {
        return this._context.getBooleanProperty("stat.full");
    }

    public BuildExecutor(RouterContext ctx, TunnelPoolManager mgr) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._manager = mgr;
        this._currentlyBuilding = new Object();
        this._currentlyBuildingMap = new ConcurrentHashMap(MAX_CONCURRENT_BUILDS);
        this._recentlyBuildingMap = new ConcurrentHashMap(4 * MAX_CONCURRENT_BUILDS);
        this._context.statManager().createRateStat("tunnel.buildFailFirstHop", "OB tunnel build failure frequency (can't contact 1st hop)", "Tunnels", RATES);
        this._context.statManager().createRateStat("tunnel.buildReplySlow", "Build reply late, but not too late", "Tunnels", RATES);
        this._context.statManager().createRateStat("tunnel.concurrentBuildsLagged", "Concurrent build count before rejecting (job lag)", "Tunnels", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildClientExpire", "No response to our build request", "Tunnels [Participating]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildClientReject", "Response time for rejection (ms)", "Tunnels [Participating]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildClientSuccess", "Response time for success (ms)", "Tunnels [Participating]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildConfigTime", "Time to build a tunnel config (ms)", "Tunnels", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratoryExpire", "No response to our build request", "Tunnels [Exploratory]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratoryReject", "Response time for rejection (ms)", "Tunnels [Exploratory]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildExploratorySuccess", "Response time for success (ms)", "Tunnels [Exploratory]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.buildRequestTime", "Time to build a tunnel request (ms)", "Tunnels [Participating]", RATES);
        this._context.statManager().createRequiredRateStat("tunnel.concurrentBuilds", "How many builds are going at once", "Tunnels", RATES);
        StatManager statMgr = this._context.statManager();
        String bwTiers = "XPONMLK";
        for (int i = 0; i < bwTiers.length(); ++i) {
            String bwTier = String.valueOf(bwTiers.charAt(i));
            statMgr.createRateStat("tunnel.tierAgree" + bwTier, "Agreed joins from bandwidth tier " + bwTier, "Tunnels [Participating]", RATES);
            statMgr.createRateStat("tunnel.tierReject" + bwTier, "Rejected joins from bandwidth tier " + bwTier, "Tunnels [Participating]", RATES);
            statMgr.createRateStat("tunnel.tierExpire" + bwTier, "Expired joins from bandwidth tier " + bwTier, "Tunnels [Participating]", RATES);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void restart() {
        ArrayList<Long> arrayList = this._recentBuildIds;
        synchronized (arrayList) {
            this._recentBuildIds.clear();
        }
        this._currentlyBuildingMap.clear();
        this._recentlyBuildingMap.clear();
    }

    public synchronized void shutdown() {
        this._isRunning = false;
        this.restart();
    }

    private int allowed() {
        boolean highload;
        PooledTunnelCreatorConfig cfg;
        CommSystemFacade csf = this._context.commSystem();
        if (csf.getStatus() == CommSystemFacade.Status.DISCONNECTED) {
            return 0;
        }
        if (csf.isDummy() && csf.countActivePeers() <= 0) {
            return 0;
        }
        int maxKBps = this._context.bandwidthLimiter().getOutboundKBytesPerSecond();
        int allowed = maxKBps / 4;
        RateStat rs = this._context.statManager().getRate("tunnel.buildRequestTime");
        boolean isSlow = SystemVersion.isSlow();
        if (rs != null) {
            int throttleFactor;
            Rate r = rs.getRate(60000L);
            double avg = r != null ? r.getAverageValue() : rs.getLifetimeAverageValue();
            int n = throttleFactor = isSlow ? 100 : 200;
            if (avg > 50.0) {
                int throttle = (int)((double)(throttleFactor * MAX_CONCURRENT_BUILDS) / avg);
                if (throttle < allowed) {
                    allowed = throttle;
                    if (!isSlow && avg < 100.0) {
                        allowed *= 2;
                    }
                    if (allowed > MAX_CONCURRENT_BUILDS && this._log.shouldInfo()) {
                        this._log.info("Throttling concurrent tunnel builds to " + allowed + " -> Average build time is " + (int)avg + "ms");
                    }
                }
            } else if (avg <= 0.0 && rs.getLifetimeAverageValue() > 0.0) {
                avg = rs.getLifetimeAverageValue();
            }
        }
        if (allowed < SystemVersion.getCores()) {
            allowed = SystemVersion.getCores();
        }
        if (SystemVersion.getMaxMemory() >= 0x40000000L && !SystemVersion.isSlow()) {
            allowed *= 2;
        }
        if (allowed > MAX_CONCURRENT_BUILDS) {
            allowed = MAX_CONCURRENT_BUILDS;
        }
        allowed = this._context.getProperty("router.tunnelConcurrentBuilds", allowed);
        long now = this._context.clock().now();
        long expireBefore = now + 600000L - (long)BuildRequestor.REQUEST_TIMEOUT - 60000L;
        Iterator<PooledTunnelCreatorConfig> iter = this._recentlyBuildingMap.values().iterator();
        while (iter.hasNext()) {
            PooledTunnelCreatorConfig cfg2 = iter.next();
            if (cfg2.getExpiration() > expireBefore) continue;
            iter.remove();
        }
        ArrayList<PooledTunnelCreatorConfig> expired = null;
        int concurrent = 0;
        expireBefore = now + 600000L - (long)BuildRequestor.REQUEST_TIMEOUT;
        Iterator<PooledTunnelCreatorConfig> iter2 = this._currentlyBuildingMap.values().iterator();
        while (iter2.hasNext()) {
            PooledTunnelCreatorConfig existingCfg;
            cfg = iter2.next();
            if (cfg.getExpiration() > expireBefore || (existingCfg = this._recentlyBuildingMap.putIfAbsent(cfg.getReplyMessageId(), cfg)) != null) continue;
            iter2.remove();
            if (expired == null) {
                expired = new ArrayList<PooledTunnelCreatorConfig>();
            }
            expired.add(cfg);
        }
        concurrent = this._currentlyBuildingMap.size();
        allowed -= concurrent;
        if (expired != null) {
            for (int i = 0; i < expired.size(); ++i) {
                cfg = (PooledTunnelCreatorConfig)expired.get(i);
                if (this._log.shouldInfo()) {
                    this._log.info("Timeout (" + BuildRequestor.REQUEST_TIMEOUT / 1000 + "s) waiting for tunnel build reply -> " + cfg);
                }
                for (int iPeer = 0; iPeer < cfg.getLength(); ++iPeer) {
                    Hash peer = cfg.getPeer(iPeer);
                    if (peer.equals(this._context.routerHash())) continue;
                    RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                    String bwTier = "Unknown";
                    if (ri != null) {
                        bwTier = ri.getBandwidthTier();
                    }
                    this._context.statManager().addRateData("tunnel.tierExpire" + bwTier, 1L);
                    this.didNotReply(cfg.getReplyMessageId(), peer);
                    this._context.profileManager().tunnelTimedOut(peer);
                }
                TunnelPool pool = cfg.getTunnelPool();
                if (pool != null) {
                    pool.buildComplete(cfg, Result.TIMEOUT);
                }
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratoryExpire", 1L);
                    continue;
                }
                this._context.statManager().addRateData("tunnel.buildClientExpire", 1L);
            }
        }
        this._context.statManager().addRateData("tunnel.concurrentBuilds", concurrent);
        long lag = this._context.jobQueue().getMaxLag();
        int cpuloadavg = SystemVersion.getCPULoadAvg();
        boolean bl = highload = lag > 1000L && cpuloadavg > 98;
        if (this._context.router().getUptime() > 300000L && highload) {
            if (this._log.shouldWarn() && highload) {
                this._log.warn("System is under load -> Slowing down new tunnel builds...");
            }
            this._context.statManager().addRateData("tunnel.concurrentBuildsLagged", concurrent, lag);
            return SystemVersion.isSlow() ? 1 : 3;
        }
        if (allowed < 3) {
            allowed += 3;
            allowed *= 4;
        }
        return allowed;
    }

    @Override
    public void run() {
        this._isRunning = true;
        try {
            this.run2();
        }
        catch (NoSuchMethodError nsme) {
            String s = "Fatal error:\nJava 8 compiler used with JRE version " + System.getProperty("java.version") + " and no bootclasspath specified.\nUpdate to Java 8 or contact packager.\nStop I2P+ now, it will not build tunnels!";
            this._log.log(50, s, nsme);
            System.out.println(s);
            throw nsme;
        }
        finally {
            this._isRunning = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void run2() {
        ArrayList<TunnelPool> wanted = new ArrayList<TunnelPool>(MAX_CONCURRENT_BUILDS);
        ArrayList<TunnelPool> pools = new ArrayList<TunnelPool>(TUNNEL_POOLS);
        while (this._isRunning && !this._manager.isShutdown()) {
            block33: {
                try {
                    this._repoll = false;
                    this._manager.listPools(pools);
                    for (int i = 0; i < pools.size(); ++i) {
                        TunnelPool pool = (TunnelPool)pools.get(i);
                        if (!pool.isAlive()) continue;
                        int howMany = pool.countHowManyToBuild();
                        for (int j = 0; j < howMany; ++j) {
                            wanted.add(pool);
                        }
                    }
                    int allowed = this.allowed();
                    allowed = this.buildZeroHopTunnels(wanted, allowed);
                    TunnelManagerFacade mgr = this._context.tunnelManager();
                    if (mgr == null || mgr.getFreeTunnelCount() <= 0 || mgr.getOutboundTunnelCount() <= 0) {
                        if (mgr != null) {
                            if (mgr.getFreeTunnelCount() <= 0) {
                                mgr.selectInboundTunnel();
                            }
                            if (mgr.getOutboundTunnelCount() <= 0) {
                                mgr.selectOutboundTunnel();
                            }
                        }
                        Object howMany = this._currentlyBuilding;
                        synchronized (howMany) {
                            if (!this._repoll) {
                                if (this._log.shouldDebug()) {
                                    this._log.debug("No tunnel to build with (Allowed / Requested: " + allowed + " / " + wanted.size() + ") -> Waiting for a moment...");
                                }
                                try {
                                    this._currentlyBuilding.wait(500 + this._context.random().nextInt(500));
                                }
                                catch (InterruptedException j) {
                                    // empty catch block
                                }
                            }
                            break block33;
                        }
                    }
                    if (allowed > 0 && !wanted.isEmpty()) {
                        if (wanted.size() > 1) {
                            Collections.shuffle(wanted, this._context.random());
                            boolean preferEmpty = this._context.random().nextInt(3) != 0;
                            DataHelper.sort(wanted, new TunnelPoolComparator(preferEmpty));
                        }
                        if (allowed > 3) {
                            allowed = SystemVersion.isSlow() ? 3 : 8;
                        }
                        for (int i = 0; i < allowed && !wanted.isEmpty(); ++i) {
                            TunnelPool pool = (TunnelPool)wanted.remove(0);
                            long bef = System.currentTimeMillis();
                            PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
                            if (cfg != null) {
                                if (cfg.getLength() <= 1 && !pool.needFallback()) {
                                    if (this._log.shouldDebug()) {
                                        this._log.debug("We don't need more fallbacks for " + pool);
                                    }
                                    --i;
                                    pool.buildComplete(cfg, Result.OTHER_FAILURE);
                                    continue;
                                }
                                long pTime = System.currentTimeMillis() - bef;
                                this._context.statManager().addRateData("tunnel.buildConfigTime", pTime);
                                if (this._log.shouldDebug()) {
                                    this._log.debug("Configuring new tunnel [" + i + "] for " + pool + " -> " + cfg);
                                }
                                this.buildTunnel(cfg);
                                continue;
                            }
                            --i;
                        }
                    }
                    long lag = this._context.jobQueue().getMaxLag();
                    int cpuloadavg = SystemVersion.getCPULoadAvg();
                    boolean highload = lag > 1000L && cpuloadavg > 98;
                    try {
                        Object object = this._currentlyBuilding;
                        synchronized (object) {
                            if (!this._repoll) {
                                int delay = SystemVersion.isSlow() || highload ? 200 : 100;
                                this._currentlyBuilding.wait(delay);
                            }
                        }
                    }
                    catch (InterruptedException interruptedException) {}
                }
                catch (RuntimeException e) {
                    this._log.log(50, "Catastrophic Tunnel Manager failure! -> " + e.getMessage());
                    try {
                        Thread.sleep(200L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                }
            }
            wanted.clear();
            pools.clear();
        }
        if (this._log.shouldInfo()) {
            this._log.info("Done building");
        }
    }

    private int buildZeroHopTunnels(List<TunnelPool> wanted, int allowed) {
        Iterator<TunnelPool> iter = wanted.iterator();
        while (iter.hasNext()) {
            TunnelPool pool = iter.next();
            if (pool.getSettings().getLength() != 0) continue;
            PooledTunnelCreatorConfig cfg = pool.configureNewTunnel();
            if (cfg != null) {
                if (this._log.shouldDebug()) {
                    this._log.debug("Configuring short tunnel for " + pool + " -> " + cfg);
                }
                this.buildTunnel(cfg);
                if (cfg.getLength() > 1) {
                    --allowed;
                }
                iter.remove();
                continue;
            }
            if (!this._log.shouldDebug()) continue;
            this._log.debug("Configured a NULL tunnel!");
        }
        return allowed;
    }

    public boolean isRunning() {
        return this._isRunning;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void buildTunnel(PooledTunnelCreatorConfig cfg) {
        long id;
        boolean ok;
        long beforeBuild = System.currentTimeMillis();
        if (cfg.getLength() > 1) {
            do {
                cfg.setReplyMessageId(this._context.random().nextLong(0xFFFFFFFFL));
            } while (this.addToBuilding(cfg));
        }
        if (!(ok = BuildRequestor.request(this._context, cfg, this))) {
            return;
        }
        if (cfg.getLength() > 1) {
            long buildTime = System.currentTimeMillis() - beforeBuild;
            this._context.statManager().addRateData("tunnel.buildRequestTime", buildTime);
        }
        if ((id = cfg.getReplyMessageId()) > 0L) {
            ArrayList<Long> arrayList = this._recentBuildIds;
            synchronized (arrayList) {
                if (this._recentBuildIds.size() > 98) {
                    for (int i = 0; i < 32; ++i) {
                        this._recentBuildIds.remove(0);
                    }
                }
                this._recentBuildIds.add(id);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void buildComplete(PooledTunnelCreatorConfig cfg, Result result) {
        long now;
        long buildTime;
        if (this._log.shouldInfo()) {
            this._log.info("Build complete (" + (Object)((Object)result) + ") for " + cfg);
        }
        cfg.getTunnelPool().buildComplete(cfg, result);
        if (cfg.getLength() > 1) {
            this.removeFromBuilding(cfg.getReplyMessageId());
        }
        if ((buildTime = (now = this._context.clock().now()) + 600000L - cfg.getExpiration()) > 250L) {
            Object object = this._currentlyBuilding;
            synchronized (object) {
                this._currentlyBuilding.notifyAll();
            }
        } else if (cfg.getLength() > 1 && this._log.shouldInfo() && buildTime < 50L) {
            this._log.info("Build completed fast (" + buildTime + "ms) -> " + cfg);
        }
        long expireBefore = now + 600000L - (long)BuildRequestor.REQUEST_TIMEOUT;
        if (cfg.getExpiration() <= expireBefore && this._log.shouldDebug()) {
            this._log.debug("Build completed for expired tunnel -> " + cfg);
        }
        if (result == Result.SUCCESS) {
            this._manager.buildComplete(cfg);
            ExpireJob expireJob = new ExpireJob(this._context, cfg);
            this._context.jobQueue().addJob(expireJob);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean wasRecentlyBuilding(long replyId) {
        ArrayList<Long> arrayList = this._recentBuildIds;
        synchronized (arrayList) {
            return this._recentBuildIds.contains(replyId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void repoll() {
        Object object = this._currentlyBuilding;
        synchronized (object) {
            this._repoll = true;
            this._currentlyBuilding.notifyAll();
        }
    }

    private void didNotReply(long tunnel, Hash peer) {
        if (this._log.shouldDebug()) {
            this._log.debug("No reply from [" + peer.toBase64().substring(0, 6) + "] to join [Tunnel " + tunnel + "]");
        }
    }

    private boolean addToBuilding(PooledTunnelCreatorConfig cfg) {
        return this._currentlyBuildingMap.putIfAbsent(cfg.getReplyMessageId(), cfg) != null;
    }

    PooledTunnelCreatorConfig removeFromBuilding(long id) {
        Long key = id;
        PooledTunnelCreatorConfig rv = this._currentlyBuildingMap.remove(key);
        if (rv != null) {
            return rv;
        }
        rv = this._recentlyBuildingMap.remove(key);
        if (rv != null) {
            long requestedOn = rv.getExpiration() - 600000L;
            long rtt = this._context.clock().now() - requestedOn;
            this._context.statManager().addRateData("tunnel.buildReplySlow", rtt);
            if (this._log.shouldInfo()) {
                this._log.info("Received late reply (RTT: " + rtt + "ms) for: " + rv);
            }
        }
        return rv;
    }

    private static class TunnelPoolComparator
    implements Comparator<TunnelPool>,
    Serializable {
        private final boolean _preferEmpty;

        public TunnelPoolComparator(boolean preferEmptyPools) {
            this._preferEmpty = preferEmptyPools;
        }

        @Override
        public int compare(TunnelPool tpl, TunnelPool tpr) {
            if (tpl.getSettings().isExploratory() && !tpr.getSettings().isExploratory()) {
                return -1;
            }
            if (tpr.getSettings().isExploratory() && !tpl.getSettings().isExploratory()) {
                return 1;
            }
            if (this._preferEmpty) {
                if (tpl.getTunnelCount() <= 0 && tpr.getTunnelCount() > 0) {
                    return -1;
                }
                if (tpr.getTunnelCount() <= 0 && tpl.getTunnelCount() > 0) {
                    return 1;
                }
            }
            return 0;
        }
    }

    static enum Result {
        SUCCESS,
        REJECT,
        TIMEOUT,
        BAD_RESPONSE,
        DUP_ID,
        OTHER_FAILURE;

    }
}

