/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.List;
import java.util.Properties;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicInteger;
import net.i2p.I2PAppContext;
import net.i2p.crypto.EncType;
import net.i2p.data.DataHelper;
import net.i2p.data.EmptyProperties;
import net.i2p.data.Hash;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.BuildRequestRecord;
import net.i2p.data.i2np.BuildResponseRecord;
import net.i2p.data.i2np.EncryptedBuildRecord;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.i2np.OutboundTunnelBuildReplyMessage;
import net.i2p.data.i2np.ShortTunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildReplyMessage;
import net.i2p.data.i2np.TunnelGatewayMessage;
import net.i2p.data.i2np.VariableTunnelBuildReplyMessage;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.HandlerJobBuilder;
import net.i2p.router.Job;
import net.i2p.router.JobImpl;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.TunnelDispatcher;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.BuildMessageProcessor;
import net.i2p.router.tunnel.pool.BuildReplyHandler;
import net.i2p.router.tunnel.pool.BuildRequestor;
import net.i2p.router.tunnel.pool.ParticipatingThrottler;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.RequestThrottler;
import net.i2p.router.tunnel.pool.TunnelPoolManager;
import net.i2p.router.util.CDQEntry;
import net.i2p.stat.Rate;
import net.i2p.stat.RateStat;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class BuildHandler
implements Runnable {
    private final RouterContext _context;
    private final Log _log;
    private final TunnelPoolManager _manager;
    private final BuildExecutor _exec;
    private final Job _buildMessageHandlerJob;
    private final Job _buildReplyMessageHandlerJob;
    private final BlockingQueue<BuildMessageState> _inboundBuildMessages;
    private final BuildMessageProcessor _processor;
    private final RequestThrottler _requestThrottler;
    private final ParticipatingThrottler _throttler;
    private final BuildReplyHandler _buildReplyHandler;
    private final AtomicInteger _currentLookups = new AtomicInteger();
    private volatile boolean _isRunning;
    private final Object _startupLock = new Object();
    private ExplState _explState = ExplState.NONE;
    private final String MIN_VERSION_HONOR_CAPS = "0.9.58";
    private static final boolean DEFAULT_SHOULD_THROTTLE = true;
    private static final String PROP_SHOULD_THROTTLE = "router.enableTransitThrottle";
    private static final int MIN_QUEUE = SystemVersion.isSlow() ? 32 : 64;
    private static final int MAX_QUEUE = SystemVersion.isSlow() ? 128 : 256;
    private static final String PROP_MAX_QUEUE = "router.buildHandlerMaxQueue";
    private static final int NEXT_HOP_LOOKUP_TIMEOUT = SystemVersion.isSlow() ? 8000 : 5000;
    private static final int PRIORITY = 300;
    private static final int MIN_LOOKUP_LIMIT = SystemVersion.isSlow() ? 8 : 16;
    private static final int MAX_LOOKUP_LIMIT = SystemVersion.isSlow() ? 64 : 128;
    private static final int PERCENT_LOOKUP_LIMIT = SystemVersion.isSlow() ? 5 : 10;
    private static final int NEXT_HOP_SEND_TIMEOUT = 20000;
    private static final long MAX_REQUEST_FUTURE = 300000L;
    private static final long MAX_REQUEST_AGE = 3900000L;
    private static final long MAX_REQUEST_AGE_ECIES = 480000L;
    private static final long JOB_LAG_LIMIT_TUNNEL = SystemVersion.isSlow() ? 1000L : 500L;
    private static final long[] RATES = new long[]{60000L, 600000L, 3600000L, 86400000L};
    private static final int DEFAULT_BW_PER_TUNNEL_ESTIMATE = 68;

    public BuildHandler(RouterContext ctx, TunnelPoolManager manager, BuildExecutor exec) {
        this._context = ctx;
        this._log = ctx.logManager().getLog(this.getClass());
        this._manager = manager;
        this._exec = exec;
        int sz = ctx.getProperty(PROP_MAX_QUEUE, MAX_QUEUE);
        this._inboundBuildMessages = new LinkedBlockingQueue<BuildMessageState>(sz);
        ctx.statManager().createRateStat("tunnel.buildLookupSuccess", "Confirmation of successful deferred lookup", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.buildReplyTooSlow", "Received a tunnel build reply after timeout", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.corruptBuildReply", "Corrupt tunnel build replies received", "Tunnels", RATES);
        ctx.statManager().createRateStat("tunnel.dropConnLimits", "Dropped not rejected tunnel build (connection limits)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.dropDecryptFail", "Dropped tunnel build (decryption failed)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.handleRemaining", "Waiting inbound requests after 1 pass", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.receiveRejectionBandwidth", "Received tunnel build rejection (bandwidth overload)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.receiveRejectionCritical", "Received tunnel build rejection (critical failure)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.receiveRejectionProbabalistic", "Received tunnel build rejection probabalistically", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.receiveRejectionTransient", "Received tunnel build rejection (transient overload)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.reject.30", "Rejected a tunnel (bandwidth overload)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.rejectConnLimits", "Rejected tunnel build (connection limits)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.rejectFuture", "Rejected tunnel build (time in future)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.rejectTimeout2", "Rejected tunnel build (can't contact next hop)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.rejectTimeout", "Rejected tunnel build (unknown next hop)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRateStat("tunnel.rejectTooOld", "Rejected tunnel build (too old)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.acceptLoad", "Delay processing accepted request (ms)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.decryptRequestTime", "Time to decrypt a build request (ms)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLoadBacklog", "Pending request count when dropped", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLoad", "Delay before dropping request (ms)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLoadDelay", "Delay before abandoning request (ms)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLoadProactiveAbort", "Allowed requests during load", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLoadProactive", "Delay estimate when dropped (ms)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropLookupThrottle", "Dropped tunnel build (hop lookup limit)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.dropReqThrottle", "Dropped tunnel build (request limit)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.ownDupID", "Our tunnel dup. ID", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.rejectDupID", "Rejected tunnel build (duplicate ID)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.rejectHopThrottle", "Rejected tunnel build (per-hop limit)", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.rejectHostile", "Rejected malicious tunnel build", "Tunnels [Participating]", RATES);
        ctx.statManager().createRequiredRateStat("tunnel.rejectOverloaded", "Delay processing rejected request (ms)", "Tunnels [Participating]", RATES);
        this._processor = new BuildMessageProcessor(ctx);
        boolean testMode = ctx.getBooleanProperty("i2np.allowLocal");
        boolean shouldThrottle = this._context.getBooleanPropertyDefaultTrue(PROP_SHOULD_THROTTLE);
        this._requestThrottler = testMode || !shouldThrottle ? null : new RequestThrottler(ctx);
        this._throttler = testMode || !shouldThrottle ? null : new ParticipatingThrottler(ctx);
        this._buildReplyHandler = new BuildReplyHandler(ctx);
        this._buildMessageHandlerJob = new TunnelBuildMessageHandlerJob(ctx);
        this._buildReplyMessageHandlerJob = new TunnelBuildReplyMessageHandlerJob(ctx);
        TunnelBuildMessageHandlerJobBuilder tbmhjb = new TunnelBuildMessageHandlerJobBuilder();
        TunnelBuildReplyMessageHandlerJobBuilder tbrmhjb = new TunnelBuildReplyMessageHandlerJobBuilder();
        ctx.inNetMessagePool().registerHandlerJobBuilder(21, tbmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(22, tbrmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(23, tbmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(24, tbrmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(25, tbmhjb);
        ctx.inNetMessagePool().registerHandlerJobBuilder(26, tbrmhjb);
    }

    void init() {
        boolean obz;
        if (this._context.commSystem().isDummy()) {
            this._explState = ExplState.BOTH;
            this._context.router().setExplTunnelsReady();
            return;
        }
        int ibl = this._manager.getInboundSettings().getLength();
        int ibv = this._manager.getInboundSettings().getLengthVariance();
        int obl = this._manager.getOutboundSettings().getLength();
        int obv = this._manager.getOutboundSettings().getLengthVariance();
        boolean ibz = ibl <= 0 || ibl + ibv <= 0;
        boolean bl = obz = obl <= 0 || obl + obv <= 0;
        if (ibz && obz) {
            this._explState = ExplState.BOTH;
            this._context.router().setExplTunnelsReady();
        } else if (ibz) {
            this._explState = ExplState.IB;
        } else if (obz) {
            this._explState = ExplState.OB;
        }
    }

    public void restart() {
        this._inboundBuildMessages.clear();
    }

    public synchronized void shutdown(int numThreads) {
        this._isRunning = false;
        this._inboundBuildMessages.clear();
        BuildMessageState poison = new BuildMessageState(this._context, null, null, null);
        for (int i = 0; i < numThreads; ++i) {
            this._inboundBuildMessages.offer(poison);
        }
    }

    @Override
    public void run() {
        this._isRunning = true;
        while (this._isRunning && !this._manager.isShutdown()) {
            try {
                this.handleInboundRequest();
            }
            catch (RuntimeException e) {
                this._log.log(50, "Catastrophic tunnel build failure! -> " + e.getMessage());
            }
        }
        if (this._log.shouldWarn()) {
            this._log.warn("Completed handling Inbound build requests");
        }
        this._isRunning = false;
    }

    private void handleInboundRequest() {
        boolean highLoad;
        BuildMessageState state = null;
        try {
            state = this._inboundBuildMessages.take();
        }
        catch (InterruptedException ie) {
            return;
        }
        if (state.msg == null) {
            this._isRunning = false;
            return;
        }
        long now = this._context.clock().now();
        long uptime = this._context.router().getUptime();
        long dropBefore = now - (long)(BuildRequestor.REQUEST_TIMEOUT / 4);
        String PROP_MAX_TUNNELS = this._context.getProperty("router.maxParticipatingTunnels");
        int DEFAULT_MAX_TUNNELS = SystemVersion.isSlow() ? 2000 : 8000;
        int maxTunnels = PROP_MAX_TUNNELS != null ? Integer.parseInt(PROP_MAX_TUNNELS) : DEFAULT_MAX_TUNNELS;
        long lag = this._context.jobQueue().getMaxLag();
        boolean isLagged = lag > JOB_LAG_LIMIT_TUNNEL && maxTunnels > 0 && uptime > 300000L;
        boolean bl = highLoad = SystemVersion.getCPULoadAvg() > 98 && isLagged;
        if (state.recvTime <= dropBefore) {
            if (this._log.shouldWarn()) {
                this._log.warn("Not processing stale tunnel build request [MsgID " + state.msg.getUniqueId() + "] -> Request received " + (now - state.recvTime) + "ms ago");
            }
            this._context.statManager().addRateData("tunnel.dropLoadDelay", now - state.recvTime);
            if (maxTunnels > 0) {
                this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: Too slow").replace("tunnel requests:", "requests:"));
            }
            return;
        }
        if (isLagged) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Tunnel Request -> Job lag (" + lag + "ms)");
                this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: High job lag").replace("requests: ", "requests:<br>"));
            }
            this._context.statManager().addRateData("router.throttleTunnelCause", lag);
            return;
        }
        if (highLoad && maxTunnels > 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Tunnel Request -> System under load");
                this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests:<br>High CPU load"));
            }
            this._context.statManager().addRateData("router.throttleTunnelCause", lag);
            return;
        }
        this.handleRequest(state, now);
    }

    private void handleReply(BuildReplyMessageState state) {
        long replyMessageId = state.msg.getUniqueId();
        PooledTunnelCreatorConfig cfg = this._exec.removeFromBuilding(replyMessageId);
        if (cfg == null) {
            if (this._log.shouldWarn()) {
                this._log.warn("Reply [MsgID " + replyMessageId + "] did not match any pending tunnels");
            }
            this._context.statManager().addRateData("tunnel.buildReplyTooSlow", 1L);
        } else {
            this.handleReply(state.msg, cfg, System.currentTimeMillis() - state.recvTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handleReply(TunnelBuildReplyMessage msg, PooledTunnelCreatorConfig cfg, long delay) {
        List<Integer> order;
        BuildReplyHandler.Result[] statuses;
        long requestedOn = cfg.getExpiration() - 600000L;
        long rtt = this._context.clock().now() - requestedOn;
        if (this._log.shouldInfo()) {
            this._log.info("Handled reply [MsgID " + msg.getUniqueId() + "] in " + rtt + "ms -> " + (delay > 0L ? "Waited " + delay + "ms for config \n* " : "") + cfg);
        }
        if ((statuses = this._buildReplyHandler.decrypt(msg, cfg, order = cfg.getReplyOrder())) != null) {
            boolean allAgree = true;
            for (int i = 0; i < cfg.getLength(); ++i) {
                Hash peer = cfg.getPeer(i);
                if (peer.equals(this._context.routerHash())) continue;
                int record = order.indexOf(i);
                if (record < 0) {
                    this._log.error("Bad Status Index " + i);
                    this._exec.buildComplete(cfg, BuildExecutor.Result.BAD_RESPONSE);
                    return;
                }
                int howBad = statuses[record].code;
                RouterInfo ri = this._context.netDb().lookupRouterInfoLocally(peer);
                String bwTier = "Unknown";
                if (ri != null && (bwTier = ri.getBandwidthTier()) == "Unknown") {
                    if (this._log.shouldWarn()) {
                        this._log.warn("Banning [" + peer.toBase64().substring(0, 6) + "] for 4h -> No Bandwidth Tier in RouterInfo");
                    }
                    String reason = " <b>\u279c</b> No Bandwidth Tier in RouterInfo";
                    this._context.commSystem().mayDisconnect(peer);
                    this._context.banlist().banlistRouter(peer, reason, null, null, 14400000L);
                }
                if (howBad == 0) {
                    String avail;
                    this._context.statManager().addRateData("tunnel.tierAgree" + bwTier, 1L);
                    this._context.profileManager().tunnelJoined(peer, rtt);
                    Properties props = statuses[record].props;
                    if (props != null && (avail = props.getProperty("b")) != null && this._log.shouldWarn()) {
                        this._log.warn(msg.getUniqueId() + ": peer replied available: " + avail + "KBps");
                    }
                } else {
                    this._context.statManager().addRateData("tunnel.tierReject" + bwTier, 1L);
                    allAgree = false;
                    switch (howBad) {
                        case 30: {
                            this._context.statManager().addRateData("tunnel.receiveRejectionBandwidth", 1L);
                            break;
                        }
                        case 20: {
                            this._context.statManager().addRateData("tunnel.receiveRejectionTransient", 1L);
                            break;
                        }
                        case 10: {
                            this._context.statManager().addRateData("tunnel.receiveRejectionProbabalistic", 1L);
                            break;
                        }
                        default: {
                            this._context.statManager().addRateData("tunnel.receiveRejectionCritical", 1L);
                        }
                    }
                    this._context.profileManager().tunnelRejected(peer, rtt, howBad);
                    this._context.messageHistory().tunnelParticipantRejected(peer, "peer rejected after " + rtt + " with " + howBad + ": " + cfg.toString());
                }
                if (!this._log.shouldInfo()) continue;
                this._log.info("Received reply from [" + peer.toBase64().substring(0, 6) + "] for [MsgID " + msg.getUniqueId() + "] -> Request " + (howBad == 0 ? "accepted" : "rejected (Status: " + howBad + ")"));
            }
            if (allAgree) {
                boolean success = cfg.isInbound() ? this._context.tunnelDispatcher().joinInbound(cfg) : this._context.tunnelDispatcher().joinOutbound(cfg);
                if (!success) {
                    this._context.statManager().addRateData("tunnel.ownDupID", 1L);
                    this._exec.buildComplete(cfg, BuildExecutor.Result.DUP_ID);
                    if (this._log.shouldWarn()) {
                        this._log.warn("Duplicate ID for our own tunnel " + cfg);
                    }
                    return;
                }
                this._exec.buildComplete(cfg, BuildExecutor.Result.SUCCESS);
                if (cfg.getTunnelPool().getSettings().isExploratory()) {
                    boolean isIn = cfg.isInbound();
                    Object object = this._startupLock;
                    synchronized (object) {
                        switch (this._explState) {
                            case NONE: {
                                if (isIn) {
                                    this._explState = ExplState.IB;
                                    break;
                                }
                                this._explState = ExplState.OB;
                                break;
                            }
                            case IB: {
                                if (isIn) break;
                                this._explState = ExplState.BOTH;
                                this._context.router().setExplTunnelsReady();
                                break;
                            }
                            case OB: {
                                if (!isIn) break;
                                this._explState = ExplState.BOTH;
                                this._context.router().setExplTunnelsReady();
                                break;
                            }
                        }
                    }
                }
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratorySuccess", rtt);
                } else {
                    this._context.statManager().addRateData("tunnel.buildClientSuccess", rtt);
                }
            } else {
                this._exec.buildComplete(cfg, BuildExecutor.Result.REJECT);
                if (cfg.getDestination() == null) {
                    this._context.statManager().addRateData("tunnel.buildExploratoryReject", rtt);
                } else {
                    this._context.statManager().addRateData("tunnel.buildClientReject", rtt);
                }
            }
        } else {
            if (this._log.shouldWarn()) {
                this._log.warn("Tunnel reply [MsgID " + msg.getUniqueId() + "] could not be decrypted for tunnel " + cfg);
            }
            this._context.statManager().addRateData("tunnel.corruptBuildReply", 1L);
            this._exec.buildComplete(cfg, BuildExecutor.Result.BAD_RESPONSE);
        }
    }

    private long handleRequest(BuildMessageState state, long now) {
        String caps;
        long timeSinceReceived = now - state.recvTime;
        Hash from = state.fromHash;
        if (from == null && state.from != null) {
            from = state.from.calculateHash();
        }
        if (from != null && this._context.banlist().isBanlisted(from)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Tunnel Request -> Previous peer [" + from.toBase64().substring(0, 6) + "] is banned");
            }
            this._context.commSystem().mayDisconnect(from);
            return -1L;
        }
        RouterInfo myRI = this._context.router().getRouterInfo();
        if (myRI != null && (caps = myRI.getCapabilities()) != null && caps.indexOf(71) >= 0) {
            String fromVersion;
            RouterInfo fromRI;
            this._context.statManager().addRateData("tunnel.dropTunnelFromCongestionCapability", 1L);
            if (this._log.shouldLog(30) && from != null) {
                this._log.warn("Dropped request from [" + from.toBase64().substring(0, 6) + "] -> Local congestion");
            }
            if ((fromRI = this._context.netDb().lookupRouterInfoLocally(from)) != null && (fromVersion = fromRI.getVersion()) != null && VersionComparator.comp(fromVersion, "0.9.58") >= 0) {
                this._context.statManager().addRateData("tunnel.dropTunnelFromCongestionCapability" + from, 1L);
                this._context.statManager().addRateData("tunnel.dropTunnelFromCongestionCapability" + fromVersion, 1L);
            }
            return -1L;
        }
        if (timeSinceReceived > (long)(BuildRequestor.REQUEST_TIMEOUT * 3)) {
            this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: Overloaded"));
            if (this._log.shouldWarn()) {
                this._log.warn("Not trying to handle/decrypt stale request " + state.msg.getUniqueId() + " -> Received " + timeSinceReceived + "ms ago");
            }
            this._context.statManager().addRateData("tunnel.dropLoadDelay", timeSinceReceived);
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
            }
            return -1L;
        }
        long beforeDecrypt = System.currentTimeMillis();
        BuildRequestRecord req = this._processor.decrypt(state.msg, this._context.routerHash(), this._context.keyManager().getPrivateKey());
        long decryptTime = System.currentTimeMillis() - beforeDecrypt;
        this._context.statManager().addRateData("tunnel.decryptRequestTime", decryptTime);
        if (decryptTime > 500L && this._log.shouldWarn()) {
            this._log.warn("Timeout decrypting request: " + decryptTime + " for message: " + state.msg.getUniqueId() + " received " + (timeSinceReceived + decryptTime) + "ms ago");
        }
        if (req == null) {
            this._context.statManager().addRateData("tunnel.dropDecryptFail", 1L);
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                if (this._log.shouldInfo()) {
                    this._log.info("Request [MsgID " + state.msg.getUniqueId() + "] could not be decrypted from [" + from.toBase64().substring(0, 6) + "]");
                }
            }
            return -1L;
        }
        Hash nextPeer = req.readNextIdentity();
        if (this._context.banlist().isBanlisted(nextPeer)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping Tunnel Request -> Next peer [" + nextPeer.toBase64().substring(0, 6) + "] is banned");
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
            }
            return -1L;
        }
        RouterInfo nextPeerInfo = this._context.netDb().lookupRouterInfoLocally(nextPeer);
        if (nextPeerInfo == null) {
            boolean highload;
            int numTunnels = this._context.tunnelManager().getParticipatingCount();
            int limit = Math.max(MIN_LOOKUP_LIMIT, Math.min(MAX_LOOKUP_LIMIT, numTunnels * PERCENT_LOOKUP_LIMIT / 100));
            long maxQueueLag = this._context.jobQueue().getMaxLag();
            boolean bl = highload = SystemVersion.getCPULoadAvg() > 95 && maxQueueLag > 500L;
            boolean lucky = numTunnels < 500 ? this._context.random().nextInt(5) > 1 : (numTunnels < 3000 ? this._context.random().nextInt(10) > 6 : this._context.random().nextInt(10) > 8);
            int current = this._context.random().nextInt(16) > 0 ? this._currentLookups.incrementAndGet() : 1;
            if (current <= limit && !highload && lucky) {
                if (current <= 0) {
                    this._currentLookups.set(1);
                }
                if (this._log.shouldInfo()) {
                    this._log.info("Looking up next hop [" + nextPeer.toBase64().substring(0, 6) + "]\n* From: " + from + " [MsgID: " + state.msg.getUniqueId() + "]\n* Lookups: " + current + " / " + limit + req);
                }
                this._context.netDb().lookupRouterInfo(nextPeer, new HandleReq(this._context, state, req, nextPeer), new TimeoutReq(this._context, state, req, nextPeer), NEXT_HOP_LOOKUP_TIMEOUT);
            } else {
                String status = "\n* From: " + from + " [MsgID: " + state.msg.getUniqueId() + "]" + req;
                if (highload) {
                    this._log.info("Dropping next hop lookup -> System is under load" + status);
                } else if (lucky) {
                    this._currentLookups.decrementAndGet();
                } else {
                    if (numTunnels > 2000) {
                        this._currentLookups.incrementAndGet();
                    }
                    if (this._log.shouldInfo()) {
                        this._log.info("Dropping next hop lookup -> " + (numTunnels < 800 ? "40" : (numTunnels < 3000 ? "70" : "90")) + "% chance of drop" + status);
                    }
                }
                this._context.statManager().addRateData("tunnel.dropLookupThrottle", 1L);
                if (from != null) {
                    this._context.commSystem().mayDisconnect(from);
                }
            }
            return -1L;
        }
        long beforeHandle = System.currentTimeMillis();
        this.handleReq(nextPeerInfo, state, req, nextPeer);
        long handleTime = System.currentTimeMillis() - beforeHandle;
        if (this._log.shouldDebug()) {
            this._log.debug("Request handled after " + handleTime + "ms / " + decryptTime + "ms / " + timeSinceReceived + "ms and next hop [" + nextPeer.toBase64().substring(0, 6) + "] is known\n* From: " + from + " [MsgID: " + state.msg.getUniqueId() + "]" + req);
        }
        return handleTime;
    }

    private void handleRequestAsInboundEndpoint(BuildEndMessageState state) {
        int records = state.msg.getRecordCount();
        TunnelBuildReplyMessage msg = state.msg.getType() == 25 ? new ShortTunnelBuildReplyMessage(this._context, records) : (records == 8 ? new TunnelBuildReplyMessage(this._context) : new VariableTunnelBuildReplyMessage(this._context, records));
        for (int i = 0; i < records; ++i) {
            msg.setRecord(i, state.msg.getRecord(i));
        }
        msg.setUniqueId(state.msg.getUniqueId());
        this.handleReply(msg, state.cfg, System.currentTimeMillis() - state.recvTime);
    }

    private void handleReq(RouterInfo nextPeerInfo, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
        EncryptedBuildRecord reply;
        Properties props;
        ParticipatingThrottler.Result result;
        int type;
        int response;
        long maxAge;
        long timeDiff;
        long roundedNow;
        boolean isEC;
        long ourId = req.readReceiveTunnelId();
        long nextId = req.readNextTunnelId();
        boolean isInGW = req.readIsInboundGateway();
        boolean isOutEnd = req.readIsOutboundEndpoint();
        int bantime = 600000;
        int period = bantime / 60 / 1000;
        Hash from = state.fromHash;
        if (from == null && state.from != null) {
            from = state.from.calculateHash();
        }
        if (isInGW && isOutEnd) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> IBGW+OBEP " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (IBGW+OBEP)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (Inbound Gateway & Outbound Endpoint)");
            }
            return;
        }
        if (ourId <= 0L || ourId > 0xFFFFFFFFL || nextId <= 0L || nextId > 0xFFFFFFFFL) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> BAD Tunnel ID " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (BAD Tunnel ID)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (BAD TunnelID)");
            }
            return;
        }
        if (!isOutEnd && this._context.routerHash().equals(nextPeer)) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> We are the next hop " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (double hop)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (We are 2 hops in a row!)");
            }
            return;
        }
        if (!isInGW && (from == null || this._context.routerHash().equals(from))) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> We are the previous hop " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (previous hop)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (We are the previous hop!)");
            }
            return;
        }
        if (!isOutEnd && !isInGW && nextPeer.equals(from)) {
            this._context.statManager().addRateData("tunnel.rejectHostile", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> Previous and next hop are the same " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (duplicate hops in chain)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (duplicate hops in chain)");
            }
            return;
        }
        long time = req.readRequestTime();
        long now = this._context.clock().now();
        boolean bl = isEC = this._context.keyManager().getPrivateKey().getType() == EncType.ECIES_X25519;
        if (isEC) {
            roundedNow = now / 60000L * 60000L;
            timeDiff = roundedNow - time;
            maxAge = 480000L;
        } else {
            roundedNow = now / 3600000L * 3600000L;
            timeDiff = roundedNow - time;
            maxAge = 3900000L;
        }
        if (timeDiff > maxAge) {
            this._context.statManager().addRateData("tunnel.rejectTooOld", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> Too old... replay attack? " + DataHelper.formatDuration(timeDiff) + " " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (possible replay attack)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (too old, replay attack?)");
            }
            return;
        }
        if (timeDiff < -300000L) {
            this._context.statManager().addRateData("tunnel.rejectFuture", 1L);
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping HOSTILE Tunnel Request -> Too far in future " + DataHelper.formatDuration(0L - timeDiff) + " " + req);
            }
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
                this._context.banlist().banlistRouter(from, " <b>\u279c</b> Hostile Tunnel Request (too far in future)", null, null, this._context.clock().now() + (long)bantime);
                this._log.warn("Banning [" + from.toBase64().substring(0, 6) + "] for " + period + "m -> Hostile Tunnel Request (too far in future)");
            }
            return;
        }
        if (this._context.router().isHidden()) {
            this._context.throttle().setTunnelStatus("[hidden]" + BuildHandler._x("Declining requests:" + BuildHandler._x("Hidden Mode")));
            response = 30;
        } else {
            response = this._context.throttle().acceptTunnelRequest();
        }
        if (response == 0 && (type = req.readLayerEncryptionType()) != 0) {
            if (this._log.shouldWarn()) {
                this._log.warn("Unsupported layer encryption type: " + type);
            }
            response = 30;
        }
        long recvDelay = now - state.recvTime;
        if (response == 0) {
            float pDrop = (float)recvDelay / (float)(BuildRequestor.REQUEST_TIMEOUT * 3);
            pDrop = (float)Math.pow(pDrop, 16.0);
            if (this._context.random().nextFloat() < pDrop) {
                this._context.statManager().addRateData("tunnel.rejectOverloaded", recvDelay);
                this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Declining Tunnel Requests:<br>" + BuildHandler._x("Request overload")));
                response = 20;
            } else {
                this._context.statManager().addRateData("tunnel.acceptLoad", recvDelay);
            }
        }
        RouterInfo ri = this._context.router().getRouterInfo();
        if (response == 0) {
            if (ri == null) {
                response = 30;
            } else {
                char bw = ri.getBandwidthTier().charAt(0);
                if (bw != 'N' && bw != 'O' && bw != 'P' && bw != 'X' && (isInGW && !this._context.commSystem().haveInboundCapacity(87) || isOutEnd && !this._context.commSystem().haveOutboundCapacity(87))) {
                    this._context.statManager().addRateData("tunnel.rejectConnLimits", 1L);
                    this._context.throttle().setTunnelStatus("[rejecting/max]" + BuildHandler._x("Declining Tunnel Requests:<br>" + BuildHandler._x("Connection limit reached")));
                    response = 30;
                }
            }
        }
        boolean shouldThrottle = this._context.getBooleanPropertyDefaultTrue(PROP_SHOULD_THROTTLE);
        if (response == 0 && !isInGW && this._throttler != null && from != null && shouldThrottle) {
            result = this._throttler.shouldThrottle(from);
            if (result == ParticipatingThrottler.Result.DROP) {
                if (this._log.shouldWarn() && from != null && req != null) {
                    this._log.warn("Dropping Tunnel Request (hop throttle), previous hop -> [" + from.toBase64().substring(0, 6) + "] " + req);
                }
                this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
                this._context.commSystem().mayDisconnect(from);
                this._context.profileManager().tunnelFailed(from, 400);
                return;
            }
            if (result == ParticipatingThrottler.Result.REJECT) {
                if (this._log.shouldWarn() && from != null && req != null) {
                    this._log.warn("Rejecting Tunnel Request (hop throttle), previous hop -> [" + from.toBase64().substring(0, 6) + "] " + req);
                }
                this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
                response = 30;
                this._context.profileManager().tunnelFailed(from, 200);
            }
        }
        if (response == 0 && !isOutEnd && this._throttler != null && shouldThrottle) {
            result = this._throttler.shouldThrottle(nextPeer);
            if (result == ParticipatingThrottler.Result.DROP) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping Tunnel Request (hop throttle), next hop -> [" + nextPeer.toBase64().substring(0, 6) + "] " + req);
                }
                this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
                if (from != null) {
                    this._context.commSystem().mayDisconnect(from);
                }
                this._context.profileManager().tunnelFailed(nextPeer, 400);
                return;
            }
            if (result == ParticipatingThrottler.Result.REJECT) {
                if (this._log.shouldWarn()) {
                    this._log.warn("Rejecting Tunnel Request (hop throttle), next hop -> [" + nextPeer.toBase64().substring(0, 6) + "] " + req);
                }
                this._context.statManager().addRateData("tunnel.rejectHopThrottle", 1L);
                response = 30;
                this._context.profileManager().tunnelFailed(nextPeer, 200);
            }
        }
        int avail = 0;
        if (response == 0 && (props = req.readOptions()) != null) {
            String sreq;
            int min = 0;
            int rqu = 0;
            String smin = props.getProperty("m");
            if (smin != null) {
                try {
                    min = 1000 * Integer.parseInt(smin);
                }
                catch (NumberFormatException nfe) {
                    response = 30;
                }
            }
            if ((sreq = props.getProperty("r")) != null) {
                try {
                    rqu = 1000 * Integer.parseInt(sreq);
                }
                catch (NumberFormatException nfe) {
                    response = 30;
                }
            }
            if ((min > 0 || rqu > 0) && response == 0) {
                int share = 1000 * TunnelDispatcher.getShareBandwidth(this._context);
                int max = share / 20;
                if (min > max) {
                    response = 30;
                } else {
                    Rate rate;
                    RateStat stat = this._context.statManager().getRate("tunnel.participatingBandwidth");
                    if (stat != null && (rate = stat.getRate(600000L)) != null) {
                        int used = (int)rate.getAvgOrLifetimeAvg();
                        avail = Math.min(max, (share - used) / 4);
                        if (min > avail) {
                            if (this._log.shouldWarn()) {
                                this._log.warn("REJECT Part tunnel: min: " + min + " req: " + rqu + " avail: " + avail);
                            }
                            response = 30;
                        } else {
                            if (this._log.shouldWarn()) {
                                this._log.warn("ACCEPT Part tunnel: min: " + min + " req: " + rqu + " avail: " + avail);
                            }
                            if (min > 0 && rqu > 4 * min) {
                                rqu = 4 * min;
                            }
                            if (rqu > 0 && rqu < avail) {
                                avail = rqu;
                            }
                        }
                    }
                }
            }
        }
        HopConfig cfg = null;
        if (response == 0) {
            cfg = new HopConfig();
            cfg.setCreation(now);
            cfg.setExpiration(now + 600000L);
            cfg.setIVKey(req.readIVKey());
            cfg.setLayerKey(req.readLayerKey());
            if (!isInGW) {
                if (from != null) {
                    cfg.setReceiveFrom(from);
                } else {
                    return;
                }
            }
            cfg.setReceiveTunnelId(ourId);
            if (!isOutEnd) {
                cfg.setSendTo(nextPeer);
                cfg.setSendTunnelId(nextId);
            }
            if (avail > 0) {
                cfg.setAllocatedBW(avail);
            } else {
                cfg.setAllocatedBW(68);
            }
            boolean success = isOutEnd ? this._context.tunnelDispatcher().joinOutboundEndpoint(cfg) : (isInGW ? this._context.tunnelDispatcher().joinInboundGateway(cfg) : this._context.tunnelDispatcher().joinParticipant(cfg));
            if (!success) {
                response = 30;
                this._context.statManager().addRateData("tunnel.rejectDupID", 1L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Duplicate TunnelID failure " + req);
                }
            }
        }
        if (response != 0) {
            this._context.statManager().addRateData("tunnel.reject." + response, 1L);
            this._context.messageHistory().tunnelRejected(from, new TunnelId(ourId), nextPeer, Integer.toString(response));
            if (from != null) {
                this._context.commSystem().mayDisconnect(from);
            }
            if (!(this._context.routerHash().equals(nextPeer) || this._context.commSystem().haveOutboundCapacity(90) || this._context.commSystem().isEstablished(nextPeer))) {
                this._context.statManager().addRateData("tunnel.dropConnLimits", 1L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Dropping Tunnel Request -> Congestion control enabled (close to our limit) " + req);
                }
                return;
            }
        } else if (isInGW && from != null) {
            this._context.commSystem().mayDisconnect(from);
        }
        if (this._log.shouldDebug()) {
            this._log.debug("Responding to [MsgID " + state.msg.getUniqueId() + "] after " + recvDelay + "ms with response [" + response + "] from " + (from != null ? "[" + from.toBase64().substring(0, 6) + "]" : "tunnel") + req);
        }
        int records = state.msg.getRecordCount();
        int ourSlot = -1;
        for (int j = 0; j < records; ++j) {
            if (state.msg.getRecord(j) != null) continue;
            ourSlot = j;
            break;
        }
        if (isEC) {
            Properties props2;
            if (avail > 0) {
                props2 = new Properties();
                props2.setProperty("b", Integer.toString(avail / 1000));
            } else {
                props2 = EmptyProperties.INSTANCE;
            }
            reply = state.msg.getType() == 25 ? BuildResponseRecord.createShort(this._context, response, req.getChaChaReplyKey(), req.getChaChaReplyAD(), props2, ourSlot) : BuildResponseRecord.create((I2PAppContext)this._context, response, req.getChaChaReplyKey(), req.getChaChaReplyAD(), props2);
        } else {
            reply = BuildResponseRecord.create((I2PAppContext)this._context, response, req.readReplyKey(), req.readReplyIV(), state.msg.getUniqueId());
        }
        state.msg.setRecord(ourSlot, reply);
        if (this._log.shouldDebug()) {
            this._log.debug("Read slot [" + ourSlot + "] containing reply [MsgID " + req.readReplyMessageId() + "] accepted? " + response + "; recvDelay " + recvDelay + "ms;" + req);
        }
        long expires = now + 20000L;
        if (!isOutEnd) {
            TunnelBuildMessage nextMessage = state.msg;
            nextMessage.setUniqueId(req.readReplyMessageId());
            nextMessage.setMessageExpiration(expires);
            OutNetMessage msg = new OutNetMessage(this._context, nextMessage, expires, 300, nextPeerInfo);
            if (response == 0) {
                msg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
            }
            this._context.outNetMessagePool().add(msg);
        } else {
            I2NPMessageImpl outMessage;
            TunnelBuildReplyMessage replyMsg;
            if (state.msg.getType() == 25) {
                OutboundTunnelBuildReplyMessage otbrm = new OutboundTunnelBuildReplyMessage(this._context, records);
                replyMsg = otbrm;
            } else {
                replyMsg = records == 8 ? new TunnelBuildReplyMessage(this._context) : new VariableTunnelBuildReplyMessage(this._context, records);
            }
            for (int i = 0; i < records; ++i) {
                replyMsg.setRecord(i, state.msg.getRecord(i));
            }
            replyMsg.setUniqueId(req.readReplyMessageId());
            replyMsg.setMessageExpiration(expires);
            boolean replyGwIsUs = this._context.routerHash().equals(nextPeer);
            if (!replyGwIsUs && state.msg.getType() == 25) {
                outMessage = MessageWrapper.wrap(this._context, (I2NPMessage)replyMsg, req.readGarlicKeys());
                if (outMessage == null) {
                    if (this._log.shouldWarn()) {
                        this._log.warn("OutboundTunnelBuildReplyMessage encryption failure");
                    }
                    return;
                }
            } else {
                outMessage = replyMsg;
            }
            TunnelGatewayMessage m = new TunnelGatewayMessage(this._context);
            m.setMessage(outMessage);
            m.setMessageExpiration(expires);
            m.setTunnelId(new TunnelId(nextId));
            if (replyGwIsUs) {
                this._context.tunnelDispatcher().dispatch(m);
                if (this._log.shouldDebug()) {
                    this._log.debug("We are the reply gateway for " + nextId + " when replying to ReplyMessage " + req);
                }
            } else {
                OutNetMessage outMsg = new OutNetMessage(this._context, m, expires, 300, nextPeerInfo);
                if (response == 0) {
                    outMsg.setOnFailedSendJob(new TunnelBuildNextHopFailJob(this._context, cfg));
                }
                this._context.outNetMessagePool().add(outMsg);
            }
        }
    }

    public int getInboundBuildQueueSize() {
        return this._inboundBuildMessages.size();
    }

    private static final String _x(String s) {
        return s;
    }

    private static class TunnelBuildNextHopFailJob
    extends JobImpl {
        private final HopConfig _cfg;

        private TunnelBuildNextHopFailJob(RouterContext ctx, HopConfig cfg) {
            super(ctx);
            this._cfg = cfg;
        }

        @Override
        public String getName() {
            return "Timeout Building Tunnel Hop";
        }

        @Override
        public void runJob() {
            this.getContext().statManager().addRateData("tunnel.rejectTimeout2", 1L);
            Log log = this.getContext().logManager().getLog(BuildHandler.class);
            if (log.shouldInfo()) {
                log.info("Timeout (" + NEXT_HOP_LOOKUP_TIMEOUT / 1000 + "s) contacting next hop" + this._cfg);
            }
        }
    }

    private static class TunnelBuildReplyMessageHandlerJob
    extends JobImpl {
        private TunnelBuildReplyMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public void runJob() {
        }

        @Override
        public String getName() {
            return "Receive Tunnel Build Reply Message";
        }
    }

    private static class TunnelBuildMessageHandlerJob
    extends JobImpl {
        private TunnelBuildMessageHandlerJob(RouterContext ctx) {
            super(ctx);
        }

        @Override
        public void runJob() {
        }

        @Override
        public String getName() {
            return "Receive Tunnel Build Message";
        }
    }

    private static class BuildEndMessageState {
        final TunnelBuildMessage msg;
        final PooledTunnelCreatorConfig cfg;
        final long recvTime;

        public BuildEndMessageState(PooledTunnelCreatorConfig c, I2NPMessage m) {
            this.cfg = c;
            this.msg = (TunnelBuildMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildReplyMessageState {
        final TunnelBuildReplyMessage msg;
        final long recvTime;

        public BuildReplyMessageState(I2NPMessage m) {
            this.msg = (TunnelBuildReplyMessage)m;
            this.recvTime = System.currentTimeMillis();
        }
    }

    private static class BuildMessageState
    implements CDQEntry {
        private final RouterContext _ctx;
        final TunnelBuildMessage msg;
        final RouterIdentity from;
        final Hash fromHash;
        final long recvTime;

        public BuildMessageState(RouterContext ctx, I2NPMessage m, RouterIdentity f, Hash h) {
            this._ctx = ctx;
            this.msg = (TunnelBuildMessage)m;
            this.from = f;
            this.fromHash = h;
            this.recvTime = ctx.clock().now();
        }

        @Override
        public void setEnqueueTime(long time) {
        }

        @Override
        public long getEnqueueTime() {
            return this.recvTime;
        }

        @Override
        public void drop() {
            this._ctx.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: Queue time"));
            this._ctx.statManager().addRateData("tunnel.dropLoadProactive", this._ctx.clock().now() - this.recvTime);
        }
    }

    private class TunnelBuildReplyMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildReplyMessageHandlerJobBuilder() {
        }

        @Override
        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            if (BuildHandler.this._log.shouldDebug()) {
                BuildHandler.this._log.debug("Received TunnelBuildReplyMessage " + receivedMessage.getUniqueId() + " from " + (fromHash != null ? fromHash : (from != null ? from.calculateHash() : "a tunnel")));
            }
            BuildHandler.this.handleReply(new BuildReplyMessageState(receivedMessage));
            return BuildHandler.this._buildReplyMessageHandlerJob;
        }
    }

    private class TunnelBuildMessageHandlerJobBuilder
    implements HandlerJobBuilder {
        private TunnelBuildMessageHandlerJobBuilder() {
        }

        @Override
        public Job createJob(I2NPMessage receivedMessage, RouterIdentity from, Hash fromHash) {
            long reqId = receivedMessage.getUniqueId();
            PooledTunnelCreatorConfig cfg = BuildHandler.this._exec.removeFromBuilding(reqId);
            boolean shouldThrottle = BuildHandler.this._context.getBooleanPropertyDefaultTrue(BuildHandler.PROP_SHOULD_THROTTLE);
            if (cfg != null) {
                if (!cfg.isInbound()) {
                    BuildHandler.this._log.error("Received TunnelBuildMessage, but it's not Inbound? " + cfg);
                }
                BuildEndMessageState state = new BuildEndMessageState(cfg, receivedMessage);
                BuildHandler.this.handleRequestAsInboundEndpoint(state);
            } else if (BuildHandler.this._exec.wasRecentlyBuilding(reqId)) {
                if (BuildHandler.this._log.shouldWarn()) {
                    BuildHandler.this._log.warn("Dropping reply [RequestID: " + reqId + "] -> Previously abandoned");
                }
                BuildHandler.this._context.statManager().addRateData("tunnel.buildReplyTooSlow", 1L);
            } else {
                long age;
                int sz = BuildHandler.this._inboundBuildMessages.size();
                BuildMessageState cur = (BuildMessageState)BuildHandler.this._inboundBuildMessages.peek();
                boolean accept = true;
                if (cur != null && (age = BuildHandler.this._context.clock().now() - cur.recvTime) >= (long)(BuildRequestor.REQUEST_TIMEOUT / 4)) {
                    BuildHandler.this._context.statManager().addRateData("tunnel.dropLoad", age, sz);
                    BuildHandler.this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: High load"));
                    accept = false;
                }
                if (accept && BuildHandler.this._requestThrottler != null && shouldThrottle) {
                    Hash fh = fromHash;
                    if (fh == null && from != null) {
                        fh = from.calculateHash();
                    }
                    if (fh != null && BuildHandler.this._requestThrottler.shouldThrottle(fh)) {
                        if (BuildHandler.this._log.shouldWarn()) {
                            BuildHandler.this._log.warn("Dropping Tunnel Request [ID: " + reqId + "] -> Previous hop [" + fh.toBase64().substring(0, 6) + "] is being throttled");
                        }
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropReqThrottle", 1L);
                        BuildHandler.this._context.profileManager().tunnelFailed(fh, 400);
                        accept = false;
                    }
                }
                if (accept) {
                    accept = BuildHandler.this._inboundBuildMessages.offer(new BuildMessageState(BuildHandler.this._context, receivedMessage, from, fromHash));
                    if (accept) {
                        BuildHandler.this._exec.repoll();
                    } else {
                        BuildHandler.this._context.throttle().setTunnelStatus("[rejecting/overload]" + BuildHandler._x("Dropping Tunnel Requests: High load"));
                        BuildHandler.this._context.statManager().addRateData("tunnel.dropLoadBacklog", sz);
                    }
                }
            }
            return BuildHandler.this._buildMessageHandlerJob;
        }
    }

    private class TimeoutReq
    extends JobImpl {
        private final BuildMessageState _state;
        private final BuildRequestRecord _req;
        private final Hash _nextPeer;

        TimeoutReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        @Override
        public String getName() {
            return "Timeout Locating Peer for Tunnel Join";
        }

        @Override
        public void runJob() {
            BuildHandler.this._currentLookups.decrementAndGet();
            this.getContext().statManager().addRateData("tunnel.rejectTimeout", 1L);
            this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 0L);
            Hash from = this._state.fromHash;
            if (BuildHandler.this._log.shouldInfo()) {
                if (from == null && this._state.from != null) {
                    from = this._state.from.calculateHash();
                }
                BuildHandler.this._log.info("Timeout (" + NEXT_HOP_LOOKUP_TIMEOUT / 1000 + "s) locating peer for next hop " + this._req + "\n* From: " + from + " [MsgID " + this._state.msg.getUniqueId() + "]");
            }
            if (this._nextPeer != null) {
                BuildHandler.this._context.commSystem().mayDisconnect(this._nextPeer);
            }
            BuildHandler.this._context.profileManager().tunnelFailed(this._nextPeer, 100);
            BuildHandler.this._context.profileManager().tunnelTimedOut(this._nextPeer);
            BuildHandler.this._context.messageHistory().tunnelRejected(this._state.fromHash, new TunnelId(this._req.readReceiveTunnelId()), this._nextPeer, "lookup fail");
        }
    }

    private class HandleReq
    extends JobImpl {
        private final BuildMessageState _state;
        private final BuildRequestRecord _req;
        private final Hash _nextPeer;

        HandleReq(RouterContext ctx, BuildMessageState state, BuildRequestRecord req, Hash nextPeer) {
            super(ctx);
            this._state = state;
            this._req = req;
            this._nextPeer = nextPeer;
        }

        @Override
        public String getName() {
            return "Defer Tunnel Join Processing";
        }

        @Override
        public void runJob() {
            RouterInfo ri;
            BuildHandler.this._currentLookups.decrementAndGet();
            if (BuildHandler.this._log.shouldDebug()) {
                BuildHandler.this._log.debug("Request " + this._state.msg.getUniqueId() + " handled with a successful deferred lookup: " + this._req);
            }
            if ((ri = this.getContext().netDb().lookupRouterInfoLocally(this._nextPeer)) != null) {
                BuildHandler.this.handleReq(ri, this._state, this._req, this._nextPeer);
                this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 1L);
            } else {
                if (BuildHandler.this._log.shouldInfo()) {
                    BuildHandler.this._log.info("Lookup deferred, but we couldn't find [" + this._nextPeer.toBase64().substring(0, 6) + "] ? " + this._req);
                }
                this.getContext().statManager().addRateData("tunnel.buildLookupSuccess", 0L);
            }
        }
    }

    private static enum ExplState {
        NONE,
        IB,
        OB,
        BOTH;

    }
}

