/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.EmptyProperties;
import net.i2p.data.Hash;
import net.i2p.data.PublicKey;
import net.i2p.data.TunnelId;
import net.i2p.data.i2np.GarlicMessage;
import net.i2p.data.i2np.I2NPMessage;
import net.i2p.data.i2np.I2NPMessageImpl;
import net.i2p.data.i2np.ShortTunnelBuildMessage;
import net.i2p.data.i2np.TunnelBuildMessage;
import net.i2p.data.i2np.VariableTunnelBuildMessage;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.JobImpl;
import net.i2p.router.LeaseSetKeys;
import net.i2p.router.OutNetMessage;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelInfo;
import net.i2p.router.TunnelManagerFacade;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.crypto.ratchet.MuxedSKM;
import net.i2p.router.crypto.ratchet.RatchetSKM;
import net.i2p.router.networkdb.kademlia.MessageWrapper;
import net.i2p.router.tunnel.HopConfig;
import net.i2p.router.tunnel.pool.BuildExecutor;
import net.i2p.router.tunnel.pool.BuildMessageGenerator;
import net.i2p.router.tunnel.pool.PooledTunnelCreatorConfig;
import net.i2p.router.tunnel.pool.TunnelPool;
import net.i2p.util.Log;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

abstract class BuildRequestor {
    private static final List<Integer> ORDER;
    private static final String MIN_NEWTBM_VERSION = "0.9.51";
    private static final boolean SEND_VARIABLE = true;
    private static final int SHORT_RECORDS = 4;
    private static final List<Integer> SHORT_ORDER;
    private static final int MEDIUM_RECORDS = 5;
    private static final List<Integer> MEDIUM_ORDER;
    private static final int PRIORITY = 500;
    static final int REQUEST_TIMEOUT;
    private static final int FIRST_HOP_TIMEOUT;
    private static final int BUILD_MSG_TIMEOUT = 40000;
    private static final int MAX_CONSECUTIVE_CLIENT_BUILD_FAILS = 8;
    static final String PROP_MIN_BW = "m";
    static final String PROP_REQ_BW = "r";
    static final String PROP_MAX_BW = "l";
    static final String PROP_AVAIL_BW = "b";

    BuildRequestor() {
    }

    private static boolean usePairedTunnels(RouterContext ctx) {
        return true;
    }

    private static void prepare(RouterContext ctx, PooledTunnelCreatorConfig cfg) {
        int len = cfg.getLength();
        boolean isIB = cfg.isInbound();
        for (int i = 0; i < len; ++i) {
            TunnelId id;
            HopConfig hop = cfg.getConfig(i);
            if (!isIB && i == 0) {
                if (len <= 1) {
                    id = ctx.tunnelDispatcher().getNewOBGWID();
                    hop.setSendTunnelId(id);
                }
            } else {
                id = isIB && len == 1 ? ctx.tunnelDispatcher().getNewIBZeroHopID() : (isIB && i == len - 1 ? ctx.tunnelDispatcher().getNewIBEPID() : new TunnelId(1L + ctx.random().nextLong(0xFFFFFFFFL)));
                hop.setReceiveTunnelId(id);
            }
            if (i <= 0) continue;
            cfg.getConfig(i - 1).setSendTunnelId(hop.getReceiveTunnelId());
        }
    }

    public static boolean request(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        BuildRequestor.prepare(ctx, cfg);
        if (cfg.getLength() <= 1) {
            BuildRequestor.buildZeroHop(ctx, cfg, exec);
            return true;
        }
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        TunnelPool pool = cfg.getTunnelPool();
        TunnelPoolSettings settings = pool.getSettings();
        TunnelInfo pairedTunnel = null;
        Hash farEnd = cfg.getFarEnd();
        TunnelManagerFacade mgr = ctx.tunnelManager();
        boolean isInbound = settings.isInbound();
        SessionKeyManager replySKM = null;
        if (settings.isExploratory() || !BuildRequestor.usePairedTunnels(ctx)) {
            if (isInbound) {
                pairedTunnel = mgr.selectOutboundExploratoryTunnel(farEnd);
            } else {
                pairedTunnel = mgr.selectInboundExploratoryTunnel(farEnd);
                if (pairedTunnel != null) {
                    replySKM = ctx.sessionKeyManager();
                }
            }
        } else {
            int fails = pool.getConsecutiveBuildTimeouts();
            if (fails < 8) {
                Hash from = settings.getDestination();
                pairedTunnel = isInbound ? mgr.selectOutboundTunnel(from, farEnd) : mgr.selectInboundTunnel(from, farEnd);
                if (pairedTunnel != null && (replySKM = ctx.clientManager().getClientSessionKeyManager(from)) == null && cfg.getGarlicReplyKeys() != null) {
                    pairedTunnel = null;
                }
            } else if (log.shouldWarn()) {
                log.warn(fails + " consecutive build timeouts for " + cfg + " -> Using Exploratory tunnel...");
            }
            if (pairedTunnel == null) {
                if (isInbound) {
                    pairedTunnel = mgr.selectOutboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getOutboundSettings().getLength() > 0 && mgr.getOutboundSettings().getLength() + mgr.getOutboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                } else {
                    pairedTunnel = mgr.selectInboundTunnel();
                    if (pairedTunnel != null && pairedTunnel.getLength() <= 1 && mgr.getInboundSettings().getLength() > 0 && mgr.getInboundSettings().getLength() + mgr.getInboundSettings().getLengthVariance() > 0) {
                        pairedTunnel = null;
                    }
                    if (pairedTunnel != null) {
                        replySKM = ctx.sessionKeyManager();
                    }
                }
                if (pairedTunnel != null && log.shouldInfo()) {
                    log.info("Can't find a paired tunnel -> Using Exploratory tunnel instead for: " + cfg);
                }
            }
        }
        if (pairedTunnel == null) {
            if (log.shouldWarn()) {
                log.warn("Tunnel build failed -> Can't find a paired tunnel for " + cfg);
            }
            exec.buildComplete(cfg, BuildExecutor.Result.OTHER_FAILURE);
            int ms = settings.isExploratory() ? 200 : 30;
            try {
                Thread.sleep(ms);
            }
            catch (InterruptedException from) {
                // empty catch block
            }
            return false;
        }
        I2NPMessageImpl msg = BuildRequestor.createTunnelBuildMessage(ctx, pool, cfg, pairedTunnel, exec);
        if (msg == null) {
            if (log.shouldWarn()) {
                log.warn("Tunnel build failed -> Can't create the TunnelBuildMessage " + cfg);
            }
            exec.buildComplete(cfg, BuildExecutor.Result.OTHER_FAILURE);
            return false;
        }
        if (pairedTunnel.getLength() > 1) {
            TunnelId gw = pairedTunnel.isInbound() ? pairedTunnel.getReceiveTunnelId(0) : pairedTunnel.getSendTunnelId(0);
            cfg.setPairedGW(gw);
        }
        if (cfg.isInbound()) {
            Hash ibgw = cfg.getPeer(0);
            if (msg.getType() == 25 && !ibgw.equals(pairedTunnel.getEndpoint())) {
                RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(ibgw);
                if (peer != null) {
                    GarlicMessage enc = MessageWrapper.wrap(ctx, (I2NPMessage)msg, peer);
                    if (enc != null) {
                        msg = enc;
                    } else if (log.shouldWarn()) {
                        log.warn("Failed to wrap Inbound TunnelBuildMessage to " + ibgw);
                    }
                } else if (log.shouldWarn()) {
                    log.warn("No RouterInfo, failed to wrap Inbound TunnelBuildMessage to " + ibgw);
                }
            }
            if (log.shouldInfo()) {
                log.info("Sending TunnelBuildRequest [MsgID " + msg.getUniqueId() + "] via " + pairedTunnel + "\n* To [" + ibgw.toBase64().substring(0, 6) + "] for " + cfg + "\n* Waiting for reply of [ReplyMsgId " + cfg.getReplyMessageId() + "]...");
            }
            ctx.tunnelDispatcher().dispatchOutbound(msg, pairedTunnel.getSendTunnelId(0), ibgw);
        } else {
            if (log.shouldInfo()) {
                log.info("Sending TunnelBuildRequest direct to [" + cfg.getPeer(1).toBase64().substring(0, 6) + "] for " + cfg + "\n* Waiting for reply of [ReplyMsgId" + cfg.getReplyMessageId() + "] via " + pairedTunnel + " with [MsgID " + msg.getUniqueId() + "]");
            }
            msg.setMessageExpiration(ctx.clock().now() + 40000L + ctx.random().nextLong(15000L) + (long)ctx.random().nextInt(5000));
            RouterInfo peer = ctx.netDb().lookupRouterInfoLocally(cfg.getPeer(1));
            if (peer == null) {
                if (log.shouldWarn()) {
                    log.warn("Failed to find next hop to send Outbound request to -> " + cfg);
                }
                exec.buildComplete(cfg, BuildExecutor.Result.OTHER_FAILURE);
                return false;
            }
            OutNetMessage outMsg = new OutNetMessage(ctx, msg, ctx.clock().now() + (long)FIRST_HOP_TIMEOUT, 500, peer);
            outMsg.setOnFailedSendJob(new TunnelBuildFirstHopFailJob(ctx, cfg, exec));
            MessageWrapper.OneTimeSession ots = cfg.getGarlicReplyKeys();
            if (ots != null && replySKM != null) {
                if (replySKM instanceof RatchetSKM) {
                    RatchetSKM rskm = (RatchetSKM)replySKM;
                    rskm.tagsReceived(ots.key, ots.rtag, 80000L);
                } else if (replySKM instanceof MuxedSKM) {
                    MuxedSKM mskm = (MuxedSKM)replySKM;
                    mskm.tagsReceived(ots.key, ots.rtag, 80000L);
                } else if (log.shouldWarn()) {
                    log.warn("Unsupported SessionKeyManager for Garlic reply to: " + cfg);
                }
                cfg.setGarlicReplyKeys(null);
            }
            try {
                ctx.outNetMessagePool().add(outMsg);
            }
            catch (RuntimeException re) {
                log.error("Failed sending TunnelBuildMessage", re);
                return false;
            }
        }
        return true;
    }

    private static boolean supportsShortTBM(RouterContext ctx, Hash h) {
        RouterInfo ri = ctx.netDb().lookupRouterInfoLocally(h);
        if (ri == null) {
            return false;
        }
        if (ri.getIdentity().getPublicKey().getType() != EncType.ECIES_X25519) {
            return false;
        }
        String v = ri.getVersion();
        return VersionComparator.comp(v, MIN_NEWTBM_VERSION) >= 0;
    }

    private static TunnelBuildMessage createTunnelBuildMessage(RouterContext ctx, TunnelPool pool, PooledTunnelCreatorConfig cfg, TunnelInfo pairedTunnel, BuildExecutor exec) {
        Properties props;
        TunnelBuildMessage msg;
        ArrayList<Integer> order;
        int len;
        Hash replyRouter;
        boolean useShortTBM;
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        long replyTunnel = 0L;
        boolean useVariable = cfg.getLength() <= 5;
        boolean bl = useShortTBM = ctx.keyManager().getPublicKey().getType() == EncType.ECIES_X25519;
        if (useShortTBM && !cfg.isInbound() && !pool.getSettings().isExploratory()) {
            LeaseSetKeys lsk = ctx.keyManager().getKeys(pool.getSettings().getDestination());
            if (lsk != null) {
                if (!lsk.isSupported(EncType.ECIES_X25519)) {
                    useShortTBM = false;
                }
            } else {
                useShortTBM = false;
            }
        }
        if (cfg.isInbound()) {
            replyRouter = ctx.routerHash();
            if (useShortTBM) {
                for (int i = 0; i < cfg.getLength() - 1; ++i) {
                    if (BuildRequestor.supportsShortTBM(ctx, cfg.getPeer(i))) continue;
                    useShortTBM = false;
                    break;
                }
            }
        } else {
            replyTunnel = pairedTunnel.getReceiveTunnelId(0).getTunnelId();
            replyRouter = pairedTunnel.getPeer(0);
            if (useShortTBM) {
                for (int i = 1; i < cfg.getLength(); ++i) {
                    if (BuildRequestor.supportsShortTBM(ctx, cfg.getPeer(i))) continue;
                    useShortTBM = false;
                    break;
                }
            }
        }
        if (useShortTBM) {
            if (cfg.getLength() <= 4) {
                len = 4;
                order = new ArrayList<Integer>(SHORT_ORDER);
            } else if (cfg.getLength() <= 5) {
                len = 5;
                order = new ArrayList<Integer>(MEDIUM_ORDER);
            } else {
                len = 8;
                order = new ArrayList<Integer>(ORDER);
            }
            msg = new ShortTunnelBuildMessage(ctx, len);
        } else if (useVariable) {
            if (cfg.getLength() <= 4) {
                msg = new VariableTunnelBuildMessage(ctx, 4);
                order = new ArrayList<Integer>(SHORT_ORDER);
            } else {
                msg = new VariableTunnelBuildMessage(ctx, 5);
                order = new ArrayList<Integer>(MEDIUM_ORDER);
            }
        } else {
            msg = new TunnelBuildMessage(ctx);
            order = new ArrayList<Integer>(ORDER);
        }
        if (!useShortTBM) {
            len = cfg.getLength();
            for (int i = 0; i < len; ++i) {
                HopConfig hop = cfg.getConfig(i);
                hop.setIVKey(ctx.keyGenerator().generateSessionKey());
                hop.setLayerKey(ctx.keyGenerator().generateSessionKey());
                byte[] iv = new byte[16];
                ctx.random().nextBytes(iv);
                cfg.setAESReplyKeys(i, ctx.keyGenerator().generateSessionKey(), iv);
            }
        }
        Collections.shuffle(order, ctx.random());
        cfg.setReplyOrder(order);
        if (log.shouldDebug()) {
            log.debug("Build order: " + order + " for " + cfg);
        }
        int bw = 0;
        int variance = 0;
        if (!useShortTBM || pool.getSettings().isExploratory()) {
            props = EmptyProperties.INSTANCE;
        } else {
            bw = pool.getAvgBWPerTunnel();
            if (bw > 7000) {
                props = new Properties();
                variance = 4 * bw / 10;
            } else {
                props = EmptyProperties.INSTANCE;
            }
        }
        for (int i = 0; i < msg.getRecordCount(); ++i) {
            int hop = (Integer)order.get(i);
            PublicKey key = null;
            if (!BuildMessageGenerator.isBlank(cfg, hop)) {
                Hash peer = cfg.getPeer(hop);
                RouterInfo peerInfo = ctx.netDb().lookupRouterInfoLocally(peer);
                if (peerInfo == null) {
                    if (log.shouldWarn()) {
                        log.warn("Peer selected for hop " + i + "/" + hop + " was not found locally: " + peer + " for " + cfg);
                    }
                    return null;
                }
                key = peerInfo.getIdentity().getPublicKey();
            }
            if (log.shouldDebug()) {
                if (key != null) {
                    log.debug("[ReplyMsgID " + cfg.getReplyMessageId() + "] Record " + i + "/" + hop + " has key " + key);
                } else {
                    log.debug("[ReplyMsgID " + cfg.getReplyMessageId() + "] Record " + i + "/" + hop + " is empty");
                }
            }
            if (key != null && variance > 0) {
                int min = bw - ctx.random().nextInt(variance);
                int req = bw + variance + ctx.random().nextInt(variance);
                if (log.shouldWarn()) {
                    log.warn("Pool: " + pool + " min: " + min + " avg: " + bw + " req: " + req);
                }
                props.setProperty(PROP_MIN_BW, Integer.toString(min / 1000));
                props.setProperty(PROP_REQ_BW, Integer.toString(req / 1000));
            }
            Properties p = key != null ? props : EmptyProperties.INSTANCE;
            BuildMessageGenerator.createRecord(i, hop, msg, cfg, replyRouter, replyTunnel, ctx, key, p);
        }
        BuildMessageGenerator.layeredEncrypt(ctx, msg, cfg, order);
        return msg;
    }

    private static void buildZeroHop(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
        Log log = ctx.logManager().getLog(BuildRequestor.class);
        if (log.shouldDebug()) {
            log.debug("Build zero hop tunnel " + cfg);
        }
        boolean ok = cfg.isInbound() ? ctx.tunnelDispatcher().joinInbound(cfg) : ctx.tunnelDispatcher().joinOutbound(cfg);
        exec.buildComplete(cfg, ok ? BuildExecutor.Result.SUCCESS : BuildExecutor.Result.DUP_ID);
    }

    static {
        int i;
        ORDER = new ArrayList<Integer>(8);
        SHORT_ORDER = new ArrayList<Integer>(4);
        MEDIUM_ORDER = new ArrayList<Integer>(5);
        for (i = 0; i < 8; ++i) {
            ORDER.add(i);
        }
        for (i = 0; i < 4; ++i) {
            SHORT_ORDER.add(i);
        }
        for (i = 0; i < 5; ++i) {
            MEDIUM_ORDER.add(i);
        }
        REQUEST_TIMEOUT = SystemVersion.isSlow() ? 15000 : 12000;
        FIRST_HOP_TIMEOUT = SystemVersion.isSlow() ? 12000 : 10000;
    }

    private static class TunnelBuildFirstHopFailJob
    extends JobImpl {
        private final PooledTunnelCreatorConfig _cfg;
        private final BuildExecutor _exec;

        private TunnelBuildFirstHopFailJob(RouterContext ctx, PooledTunnelCreatorConfig cfg, BuildExecutor exec) {
            super(ctx);
            this._cfg = cfg;
            this._exec = exec;
        }

        @Override
        public String getName() {
            return "Timeout OB Tunnel Build First Hop";
        }

        @Override
        public void runJob() {
            this._exec.buildComplete(this._cfg, BuildExecutor.Result.OTHER_FAILURE);
            this.getContext().profileManager().tunnelTimedOut(this._cfg.getPeer(1));
            this.getContext().statManager().addRateData("tunnel.buildFailFirstHop", 1L);
        }
    }
}

