/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class ParticipatingThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private final Log _log;
    private static final boolean isSlow = SystemVersion.isSlow();
    private static final boolean DEFAULT_BLOCK_OLD_ROUTERS = true;
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final boolean DEFAULT_SHOULD_THROTTLE = true;
    private static final String PROP_BLOCK_OLD_ROUTERS = "router.blockOldRouters";
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";
    private static final String PROP_SHOULD_THROTTLE = "router.enableTransitThrottle";
    private static final int LIFETIME_PORTION = 3;
    private static final int MIN_LIMIT = (isSlow ? 100 : 150) / 3;
    private static final int MAX_LIMIT = (isSlow ? 1200 : 1800) / 3;
    private static final int PERCENT_LIMIT = 5;
    private static final long CLEAN_TIME = 220000L;
    private static final String MIN_VERSION = "0.9.63";

    ParticipatingThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        this._log = ctx.logManager().getLog(ParticipatingThrottler.class);
        ctx.simpleTimer2().addPeriodicEvent(new Cleaner(), 220000L);
    }

    Result shouldThrottle(Hash h) {
        String version;
        RouterInfo ri = (RouterInfo)this.context.netDb().lookupLocallyWithoutValidation(h);
        Hash us = this.context.routerHash();
        String caps = ri != null ? ri.getCapabilities() : "";
        boolean isUs = ri != null && us.equals(ri.getIdentity().getHash());
        boolean isUnreachable = ri != null && !isUs && (caps.indexOf(85) >= 0 || caps.indexOf(82) < 0);
        boolean isG = ri != null && !isUs && caps.indexOf(71) >= 0;
        boolean isLowShare = ri != null && !isUs && (caps.indexOf(75) >= 0 || caps.indexOf(76) >= 0 || caps.indexOf(77) >= 0 || isG);
        boolean isFast = ri != null && !isUs && (caps.indexOf(79) >= 0 || caps.indexOf(80) >= 0 || caps.indexOf(88) >= 0);
        boolean isLU = isUnreachable && isLowShare;
        byte[] padding = ri != null ? ri.getIdentity().getPadding() : null;
        boolean isCompressible = padding != null && padding.length >= 64 && DataHelper.eq(padding, 0, padding, 32, 32);
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int limit = this.calculateLimit(numTunnels, isUnreachable, isLowShare, isFast);
        int count = this.counter.increment(h);
        int bantime = isLU || isLowShare || isUnreachable ? 3600000 : 14400000;
        boolean shouldThrottle = this.context.getProperty(PROP_SHOULD_THROTTLE, true);
        boolean shouldDisconnect = this.context.getProperty(PROP_SHOULD_DISCONNECT, false);
        boolean shouldBlockOldRouters = this.context.getProperty(PROP_BLOCK_OLD_ROUTERS, true);
        boolean isBanned = this.context.banlist().isBanlisted(h);
        String string = version = ri != null ? ri.getVersion() : "";
        if (version.equals("0") || version.equals("")) {
            this.handleNoVersion(shouldDisconnect, h, isBanned, caps, bantime);
            return Result.DROP;
        }
        if (this.checkVersionAndCompressibility(version, isCompressible, shouldDisconnect, h, isBanned, caps)) {
            return Result.DROP;
        }
        if (this.checkLowShareAndVersion(version, isLU, shouldBlockOldRouters, h, shouldDisconnect, isBanned, caps, bantime)) {
            return Result.DROP;
        }
        if (this.checkUnreachableAndOld(version, isUnreachable, isFast, shouldBlockOldRouters, h, shouldDisconnect, isBanned, caps)) {
            return Result.DROP;
        }
        Result rv = this.evaluateThrottleConditions(count, limit, shouldThrottle, isFast, isLowShare, isUnreachable, h, caps, isBanned, bantime);
        return rv;
    }

    private int calculateLimit(int numTunnels, boolean isUnreachable, boolean isLowShare, boolean isFast) {
        if (isUnreachable || isLowShare) {
            return Math.min(MIN_LIMIT, Math.max(MAX_LIMIT / 20, numTunnels * 0 / 100));
        }
        if (isSlow) {
            return Math.min(MIN_LIMIT, Math.max(MAX_LIMIT / 10, numTunnels * 1 / 100));
        }
        return Math.min(MIN_LIMIT * 3, Math.max(MAX_LIMIT / 2, numTunnels * 2 / 100));
    }

    private void handleNoVersion(boolean shouldDisconnect, Hash h, boolean isBanned, String caps, int bantime) {
        if (shouldDisconnect) {
            this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
        }
        if (!isBanned && this._log.shouldWarn()) {
            this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for " + bantime / 60000 + "m -> No router version in RouterInfo");
        }
        this.context.banlist().banlistRouter(h, " <b>\u279c</b> No version in RouterInfo", null, null, this.context.clock().now() + (long)bantime);
    }

    private boolean checkVersionAndCompressibility(String version, boolean isCompressible, boolean shouldDisconnect, Hash h, boolean isBanned, String caps) {
        if (VersionComparator.comp(version, "0.9.57") < 0 && isCompressible) {
            if (shouldDisconnect) {
                this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
            }
            if (!isBanned && this._log.shouldWarn()) {
                this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for 24h -> Compressible RouterInfo / " + version);
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> Compressible RouterInfo & older than 0.9.57", null, null, this.context.clock().now() + 86400000L);
            return true;
        }
        return false;
    }

    private boolean checkLowShareAndVersion(String version, boolean isLU, boolean shouldBlockOldRouters, Hash h, boolean shouldDisconnect, boolean isBanned, String caps, int bantime) {
        if (VersionComparator.comp(version, MIN_VERSION) < 0 && isLU && shouldBlockOldRouters) {
            if (shouldDisconnect) {
                this.context.commSystem().forceDisconnect(h);
                if (!isBanned && this._log.shouldWarn()) {
                    this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for " + bantime * 3 / 60000 + "m -> " + version + (caps.isEmpty() ? "" : " / " + caps));
                }
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> LU and older than current version", null, null, this.context.clock().now() + (long)(bantime * 3));
            return true;
        }
        return false;
    }

    private boolean checkUnreachableAndOld(String version, boolean isUnreachable, boolean isFast, boolean shouldBlockOldRouters, Hash h, boolean shouldDisconnect, boolean isBanned, String caps) {
        if (VersionComparator.comp(version, MIN_VERSION) < 0 && isUnreachable && shouldBlockOldRouters && !isFast) {
            if (shouldDisconnect) {
                this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
            }
            if (this._log.shouldWarn()) {
                this._log.warn("Ignoring Tunnel Request from Router [" + h.toBase64().substring(0, 6) + "] -> " + version + (caps.isEmpty() ? "" : " / " + caps));
            }
            return true;
        }
        return false;
    }

    private Result evaluateThrottleConditions(int count, int limit, boolean shouldThrottle, boolean isFast, boolean isLowShare, boolean isUnreachable, Hash h, String caps, boolean isBanned, int bantime) {
        if (count > limit && shouldThrottle) {
            if (isFast && !isUnreachable && count > limit * 3) {
                this.handleExcessiveRequests(h, caps, count, limit, bantime);
                return Result.DROP;
            }
            if (!isLowShare && !isUnreachable && count > limit * 2) {
                this.handleExcessiveRequests(h, caps, count, limit, bantime);
                return Result.DROP;
            }
            if (isUnreachable && count > limit + 30) {
                this.handleExcessiveRequests(h, caps, count, limit, bantime);
                return Result.DROP;
            }
            if (isLowShare && count > limit + 20) {
                this.handleExcessiveRequests(h, caps, count, limit, bantime);
                return Result.DROP;
            }
            this._logHighRequestCount(caps, count, limit);
            return Result.REJECT;
        }
        this._logAcceptRequest(caps, count);
        return Result.ACCEPT;
    }

    private void handleExcessiveRequests(Hash h, String caps, int count, int limit, int bantime) {
        this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
        this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
        if (this._log.shouldWarn()) {
            this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for " + bantime / 60000 + "m -> Excessive tunnel requests -> Count / Limit: " + count + " / " + limit + " in " + 220 + "s");
        }
    }

    private void _logHighRequestCount(String caps, int count, int limit) {
        if (this._log.shouldWarn()) {
            this._log.warn("Rejecting Tunnel Requests from " + (caps != null ? caps : "") + " Router -> Count / Limit: " + count + " / " + limit + " in " + 220 + "s");
        }
    }

    private void _logAcceptRequest(String caps, int count) {
        if (this._log.shouldDebug()) {
            this._log.debug("Accepting Tunnel Request from " + (caps != "" ? caps : "") + " Router -> Count: " + count + " in " + 220 + "s");
        }
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            ParticipatingThrottler.this.context.commSystem().forceDisconnect(this.h);
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            ParticipatingThrottler.this.counter.clear();
        }
    }

    public static enum Result {
        ACCEPT,
        REJECT,
        DROP;

    }
}

