/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import net.i2p.data.Hash;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.util.Log;
import net.i2p.util.ObjectCounter;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

class RequestThrottler {
    private final RouterContext context;
    private final ObjectCounter<Hash> counter;
    private final Log _log;
    private static final int LIFETIME_PORTION = 4;
    private static boolean isSlow = SystemVersion.isSlow();
    private static final int MIN_LIMIT = (isSlow ? 512 : 1024) / 4;
    private static final int MAX_LIMIT = (isSlow ? 1204 : 4096) / 4;
    private static final int PERCENT_LIMIT = 6;
    private static final long CLEAN_TIME = 165000L;
    private static final boolean DEFAULT_SHOULD_THROTTLE = true;
    private static final String PROP_SHOULD_THROTTLE = "router.enableTransitThrottle";
    private static final boolean DEFAULT_SHOULD_DISCONNECT = false;
    private static final String PROP_SHOULD_DISCONNECT = "router.enableImmediateDisconnect";
    private static final boolean DEFAULT_BLOCK_OLD_ROUTERS = true;
    private static final String PROP_BLOCK_OLD_ROUTERS = "router.blockOldRouters";
    private static final String PROP_BLOCK_COUNTRIES = "router.blockCountries";
    private static final String DEFAULT_BLOCK_COUNTRIES = "";

    RequestThrottler(RouterContext ctx) {
        this.context = ctx;
        this.counter = new ObjectCounter();
        this._log = ctx.logManager().getLog(RequestThrottler.class);
        ctx.simpleTimer2().addPeriodicEvent(new Cleaner(), 165000L);
    }

    boolean shouldThrottle(Hash h) {
        Set<String> blockedCountries;
        boolean highload;
        RouterInfo ri = this.context.netDb().lookupRouterInfoLocally(h);
        boolean isUnreachable = ri != null && ri.getCapabilities().indexOf(82) < 0;
        boolean isLowShare = ri != null && (ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0 || ri.getCapabilities().indexOf(77) >= 0);
        boolean isFast = ri != null && (ri.getCapabilities().indexOf(79) >= 0 || ri.getCapabilities().indexOf(80) >= 0 || ri.getCapabilities().indexOf(88) >= 0);
        boolean isLTier = ri != null && (ri.getCapabilities().indexOf(75) >= 0 || ri.getCapabilities().indexOf(76) >= 0);
        boolean shouldBlockOldRouters = this.context.getProperty(PROP_BLOCK_OLD_ROUTERS, true);
        int numTunnels = this.context.tunnelManager().getParticipatingCount();
        int portion = isSlow ? 6 : 4;
        int limit = Math.max(MIN_LIMIT, Math.min(MAX_LIMIT, numTunnels * 6 / 100));
        int count = this.counter.increment(h);
        boolean rv = count > limit;
        boolean enableThrottle = this.context.getProperty(PROP_SHOULD_THROTTLE, true);
        boolean shouldDisconnect = this.context.getProperty(PROP_SHOULD_DISCONNECT, false);
        boolean isFF = false;
        String v = "unknown";
        String country = "unknown";
        boolean isOld = false;
        long uptime = this.context.router().getUptime();
        long lag = this.context.jobQueue().getMaxLag();
        boolean bl = highload = lag > 1000L && SystemVersion.getCPULoadAvg() > 95;
        if (ri != null) {
            isFF = ri.getCapabilities().contains("f");
            v = ri.getVersion();
            country = this.context.commSystem().getCountry(h);
            boolean bl2 = isOld = VersionComparator.comp(v, "0.9.62") < 0;
        }
        if ((blockedCountries = this.getBlockedCountries()).contains(country)) {
            if (this._log.shouldWarn()) {
                this._log.warn("Banning and disconnecting from [" + h.toBase64().substring(0, 6) + "] -> Blocked country: " + country);
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> Blocked country: " + country, null, null, this.context.clock().now() + 28800000L);
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            return true;
        }
        if (highload) {
            if (this._log.shouldWarn()) {
                this._log.warn("Rejecting Tunnel Request from Router [" + h.toBase64().substring(0, 6) + "] -> CPU is under sustained high load");
            }
        } else if (isLTier && isUnreachable && isOld) {
            if (this._log.shouldWarn() && !this.context.banlist().isBanlisted(h)) {
                this._log.warn("Banning for 4h and disconnecting from [" + h.toBase64().substring(0, 6) + "] -> LU / " + v);
            }
            this.context.banlist().banlistRouter(h, " <b>\u279c</b> LU and older than current version", null, null, this.context.clock().now() + 14400000L);
            this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
        } else if (isOld && (isUnreachable || isLowShare) && shouldBlockOldRouters) {
            if (this._log.shouldWarn()) {
                this._log.warn("Dropping all connections from [" + h.toBase64().substring(0, 6) + "] -> Unreachable / Slow / " + v);
            }
            this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
        } else if (rv && enableThrottle) {
            int bantime = isLowShare || isUnreachable ? 3600000 : 1800000;
            int period = bantime / 60 / 1000;
            if (count == limit + 1) {
                this.context.banlist().banlistRouter(h, " <b>\u279c</b> Excessive tunnel requests", null, null, this.context.clock().now() + (long)bantime);
                this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
                if (this._log.shouldWarn()) {
                    this._log.warn("Banning " + (isLowShare || isUnreachable ? "slow or unreachable" : DEFAULT_BLOCK_COUNTRIES) + " Router [" + h.toBase64().substring(0, 6) + "] for " + period + "m\n* Excessive tunnel requests (Requested: " + count + " / Hard limit " + limit + " in " + 660 / portion + "s)");
                }
            } else {
                if (this._log.shouldInfo()) {
                    this._log.info("Rejecting Tunnel Requests from temp banned Router [" + h.toBase64().substring(0, 6) + "] -> (Requested: " + count + " / Hard limit: " + limit + " in " + 660 / portion + "s)");
                }
                this.context.simpleTimer2().addEvent(new Disconnector(h), 3000L);
            }
        }
        if (rv && count >= 3 * limit && enableThrottle) {
            this.context.banlist().banlistRouter(h, "Excessive tunnel requests", null, null, this.context.clock().now() + 1800000L);
            this.context.simpleTimer2().addEvent(new Disconnector(h), 660000L);
            if (this._log.shouldWarn()) {
                this._log.warn("Banning Router [" + h.toBase64().substring(0, 6) + "] for 30m -> Excessive tunnel requests (Requested: " + count + " / Hard limit: " + limit + ")");
            }
        }
        return rv;
    }

    private Set<String> getBlockedCountries() {
        String blockCountries = this.context.getProperty(PROP_BLOCK_COUNTRIES, DEFAULT_BLOCK_COUNTRIES);
        if (blockCountries.isEmpty()) {
            return Collections.emptySet();
        }
        return new HashSet<String>(Arrays.asList(blockCountries.toLowerCase().split(",")));
    }

    private class Disconnector
    implements SimpleTimer.TimedEvent {
        private final Hash h;

        public Disconnector(Hash h) {
            this.h = h;
        }

        @Override
        public void timeReached() {
            RequestThrottler.this.context.commSystem().forceDisconnect(this.h);
        }
    }

    private class Cleaner
    implements SimpleTimer.TimedEvent {
        private Cleaner() {
        }

        @Override
        public void timeReached() {
            RequestThrottler.this.counter.clear();
        }
    }
}

