/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.router.tunnel.pool;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.StringTokenizer;
import net.i2p.crypto.EncType;
import net.i2p.crypto.SigType;
import net.i2p.crypto.SipHashInline;
import net.i2p.data.DataFormatException;
import net.i2p.data.DataHelper;
import net.i2p.data.Hash;
import net.i2p.data.SessionKey;
import net.i2p.data.router.RouterIdentity;
import net.i2p.data.router.RouterInfo;
import net.i2p.router.RouterContext;
import net.i2p.router.TunnelPoolSettings;
import net.i2p.router.peermanager.PeerProfile;
import net.i2p.router.transport.TransportUtil;
import net.i2p.router.tunnel.pool.ConnectChecker;
import net.i2p.router.tunnel.pool.ExcluderBase;
import net.i2p.util.ArraySet;
import net.i2p.util.SystemVersion;
import net.i2p.util.VersionComparator;

public abstract class TunnelPeerSelector
extends ConnectChecker {
    private static final String DEFAULT_EXCLUDE_CAPS = String.valueOf('K') + String.valueOf('L') + String.valueOf('M') + String.valueOf('U') + String.valueOf('D') + String.valueOf('E') + String.valueOf('G');
    private static final String MIN_VERSION = "0.9.60";
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.outboundExploratoryExcludeUnreachable";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.outboundClientExcludeUnreachable";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = "router.inboundExploratoryExcludeUnreachable";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = "router.inboundClientExcludeUnreachable";
    private static final boolean DEFAULT_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = true;
    private static final boolean DEFAULT_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE = true;
    private static final boolean DEFAULT_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE = true;
    private static final boolean DEFAULT_INBOUND_CLIENT_EXCLUDE_UNREACHABLE = true;
    private static final String PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.outboundExploratoryExcludeSlow";
    private static final String PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW = "router.outboundClientExcludeSlow";
    private static final String PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW = "router.inboundExploratoryExcludeSlow";
    private static final String PROP_INBOUND_CLIENT_EXCLUDE_SLOW = "router.inboundClientExcludeSlow";

    protected TunnelPeerSelector(RouterContext context) {
        super(context);
    }

    public abstract List<Hash> selectPeers(TunnelPoolSettings var1);

    protected int getLength(TunnelPoolSettings settings) {
        int length = settings.getLength();
        int override = settings.getLengthOverride();
        if (override >= 0) {
            length = override;
        } else if (settings.getLengthVariance() != 0) {
            int skew = settings.getLengthVariance();
            if (skew > 0) {
                length += this.ctx.random().nextInt(skew + 1);
            } else {
                skew = 1 - skew;
                int off = this.ctx.random().nextInt(skew);
                length = this.ctx.random().nextBoolean() ? (length += off) : (length -= off);
            }
        }
        if (length < 0) {
            length = 0;
        } else if (length > 7) {
            length = 7;
        }
        return length;
    }

    protected boolean shouldSelectExplicit(TunnelPoolSettings settings) {
        if (settings.isExploratory()) {
            return false;
        }
        Properties opts = settings.getUnknownOptions();
        String peers = opts.getProperty("explicitPeers");
        if (peers == null) {
            peers = this.ctx.getProperty("explicitPeers");
        }
        return peers != null && this.ctx.random().nextInt(4) == 0;
    }

    protected List<Hash> selectExplicit(TunnelPoolSettings settings, int length) {
        String peers = null;
        Properties opts = settings.getUnknownOptions();
        peers = opts.getProperty("explicitPeers");
        if (peers == null) {
            peers = this.ctx.getProperty("explicitPeers");
        }
        ArrayList<Hash> rv = new ArrayList<Hash>();
        StringTokenizer tok = new StringTokenizer(peers, ",");
        while (tok.hasMoreTokens()) {
            String peerStr = tok.nextToken();
            Hash peer = new Hash();
            try {
                peer.fromBase64(peerStr);
                if (this.ctx.profileOrganizer().isSelectable(peer)) {
                    rv.add(peer);
                    continue;
                }
                if (!this.log.shouldWarn()) continue;
                this.log.warn("Explicit peer [" + peerStr + "] is not selectable");
            }
            catch (DataFormatException dfe) {
                if (!this.log.shouldError()) continue;
                this.log.error("Explicit peer [" + peerStr + "] is improperly formatted", dfe);
            }
        }
        int sz = rv.size();
        if (sz == 0) {
            this.log.logAlways(30, "No valid explicit peers found, building zero hop tunnel...");
        } else if (sz > 1) {
            Collections.shuffle(rv, this.ctx.random());
        }
        while (rv.size() > length) {
            rv.remove(0);
        }
        if (rv.size() < length) {
            int more = length - rv.size();
            Set<Hash> exclude = this.getExclude(settings.isInbound(), settings.isExploratory());
            exclude.addAll(rv);
            ArraySet<Hash> matches = new ArraySet<Hash>(more);
            this.ctx.profileOrganizer().selectFastPeers(more, exclude, matches);
            rv.addAll(matches);
            Collections.shuffle(rv, this.ctx.random());
        }
        if (this.log.shouldInfo()) {
            StringBuilder buf = new StringBuilder();
            if (settings.getDestinationNickname() != null) {
                buf.append("peers for ").append(settings.getDestinationNickname());
            } else if (settings.getDestination() != null) {
                buf.append("peers for ").append(settings.getDestination().toBase64());
            } else {
                buf.append("peers for Exploratory ");
            }
            if (settings.isInbound()) {
                buf.append(" Inbound");
            } else {
                buf.append(" Outbound");
            }
            buf.append(" peers: ").append(rv);
            buf.append(", out of ").append(sz).append(" (not including us)");
            this.log.info(buf.toString());
        }
        if (settings.isInbound()) {
            rv.add(0, this.ctx.routerHash());
        } else {
            rv.add(this.ctx.routerHash());
        }
        return rv;
    }

    protected Set<Hash> getExclude(boolean isInbound, boolean isExploratory) {
        return new Excluder(isInbound, isExploratory);
    }

    private boolean shouldExclude(Hash h, boolean isInbound, boolean isExploratory) {
        String excl;
        boolean isFF;
        PeerProfile prof = this.ctx.profileOrganizer().getProfileNonblocking(h);
        if (prof != null) {
            long cutoff = this.ctx.clock().now() - 20000L;
            if (prof.getTunnelHistory().getLastRejectedBandwidth() > cutoff) {
                return true;
            }
        }
        if (this.ctx.commSystem().wasUnreachable(h)) {
            return true;
        }
        RouterInfo info = (RouterInfo)this.ctx.netDb().lookupLocally(h);
        if (info == null) {
            return true;
        }
        String caps = info.getCapabilities();
        boolean bl = isFF = caps.indexOf(102) >= 0;
        if (isFF && caps.indexOf(85) >= 0) {
            return true;
        }
        if (isExploratory && isFF && this.ctx.random().nextInt(4) != 0) {
            return true;
        }
        if (this.filterUnreachable(isInbound, isExploratory) && caps.indexOf(85) >= 0) {
            return true;
        }
        return this.filterSlow(isInbound, isExploratory) && TunnelPeerSelector.shouldExclude(info, excl = TunnelPeerSelector.getExcludeCaps(this.ctx));
    }

    protected boolean isIPv6Only() {
        return TransportUtil.getIPv6Config(this.ctx, "SSU") == TransportUtil.IPv6Config.IPV6_ONLY;
    }

    protected boolean allowAsOBEP(Hash h) {
        RouterInfo ri = (RouterInfo)this.ctx.netDb().lookupLocallyWithoutValidation(h);
        if (ri == null) {
            return true;
        }
        return this.canConnect(ri, 19);
    }

    protected boolean allowAsIBGW(Hash h) {
        RouterInfo ri = (RouterInfo)this.ctx.netDb().lookupLocallyWithoutValidation(h);
        if (ri == null) {
            return true;
        }
        if (ri.getCapabilities().indexOf(82) < 0) {
            return false;
        }
        return this.canConnect(19, ri);
    }

    protected Set<Hash> getClosestHopExclude(boolean isInbound, Set<Hash> toAdd) {
        return new ClosestHopExcluder(isInbound, toAdd);
    }

    public static boolean shouldExclude(RouterContext ctx, RouterInfo peer) {
        return TunnelPeerSelector.shouldExclude(peer, TunnelPeerSelector.getExcludeCaps(ctx));
    }

    private static String getExcludeCaps(RouterContext ctx) {
        return ctx.getProperty("router.excludePeerCaps", DEFAULT_EXCLUDE_CAPS);
    }

    private static boolean shouldExclude(RouterInfo peer, String excl) {
        String cap = peer.getCapabilities();
        for (int j = 0; j < excl.length(); ++j) {
            if (cap.indexOf(excl.charAt(j)) < 0) continue;
            return true;
        }
        int maxLen = 0;
        if (cap.indexOf(102) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(82) >= 0) {
            ++maxLen;
        }
        if (cap.indexOf(85) >= 0) {
            ++maxLen;
        }
        if (cap.length() <= maxLen) {
            return true;
        }
        RouterIdentity ident = peer.getIdentity();
        if (ident.getSigningPublicKey().getType() == SigType.DSA_SHA1) {
            return true;
        }
        EncType type = ident.getPublicKey().getType();
        if (type != EncType.ECIES_X25519) {
            return true;
        }
        String v = peer.getVersion();
        if (v.equals("0.9.66")) {
            return false;
        }
        return VersionComparator.comp(v, MIN_VERSION) < 0;
    }

    private boolean filterUnreachable(boolean isInbound, boolean isExploratory) {
        if (SystemVersion.isSlow() || this.ctx.router().getUptime() < 3900000L) {
            return true;
        }
        if (isExploratory) {
            if (isInbound) {
                if (this.ctx.router().isHidden()) {
                    return true;
                }
                return this.ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, true);
            }
            return this.ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_UNREACHABLE, true);
        }
        if (isInbound) {
            if (this.ctx.router().isHidden()) {
                return true;
            }
            return this.ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_UNREACHABLE, true);
        }
        return this.ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_UNREACHABLE, true);
    }

    protected boolean filterSlow(boolean isInbound, boolean isExploratory) {
        if (isExploratory) {
            if (isInbound) {
                return this.ctx.getProperty(PROP_INBOUND_EXPLORATORY_EXCLUDE_SLOW, true);
            }
            return this.ctx.getProperty(PROP_OUTBOUND_EXPLORATORY_EXCLUDE_SLOW, true);
        }
        if (isInbound) {
            return this.ctx.getProperty(PROP_INBOUND_CLIENT_EXCLUDE_SLOW, true);
        }
        return this.ctx.getProperty(PROP_OUTBOUND_CLIENT_EXCLUDE_SLOW, true);
    }

    protected void orderPeers(List<Hash> rv, SessionKey key) {
        if (rv.size() > 1) {
            Collections.sort(rv, new HashComparator(key));
        }
    }

    protected boolean checkTunnel(boolean isInbound, boolean isExploratory, List<Hash> tunnel) {
        if (!this.checkTunnel(tunnel)) {
            return false;
        }
        if (!isExploratory) {
            return true;
        }
        if (isInbound) {
            Hash h = tunnel.get(tunnel.size() - 1);
            if (!this.allowAsIBGW(h)) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Selected IPv6-only or unreachable peer for Inbound Gateway [" + h.toBase64().substring(0, 6) + "]");
                }
                this.ctx.profileManager().tunnelTimedOut(h);
                return false;
            }
        } else {
            Hash h = tunnel.get(0);
            if (!this.allowAsOBEP(h)) {
                if (this.log.shouldWarn()) {
                    this.log.warn("Selected IPv6-only peer for Outbound Endpoint [" + h.toBase64().substring(0, 6) + "]");
                }
                this.ctx.profileManager().tunnelTimedOut(h);
                return false;
            }
        }
        return true;
    }

    private boolean checkTunnel(List<Hash> tunnel) {
        boolean rv = true;
        for (int i = 0; i < tunnel.size() - 1; ++i) {
            Hash us;
            Hash hf = tunnel.get(i + 1);
            Hash ht = tunnel.get(i);
            StringBuilder buf = new StringBuilder();
            for (Hash h : tunnel) {
                buf.append("[").append(h.toBase64().substring(0, 6)).append("]");
                buf.append(" ");
            }
            if (this.canConnect(hf, ht)) continue;
            if (this.log.shouldWarn()) {
                this.log.warn("Connection check failed at hop [" + (i + 1) + " -> " + i + "] in tunnel (Gateway -> Endpoint)\n* Tunnel: " + buf.toString());
            }
            if (!hf.equals(us = this.ctx.routerHash())) {
                this.ctx.profileManager().tunnelTimedOut(hf);
            }
            if (!ht.equals(us)) {
                this.ctx.profileManager().tunnelTimedOut(ht);
            }
            rv = false;
            break;
        }
        return rv;
    }

    private class ClosestHopExcluder
    extends ExcluderBase {
        private final boolean isIn;
        private final int ourMask;

        public ClosestHopExcluder(boolean isInbound, Set<Hash> set) {
            super(set);
            this.isIn = isInbound;
            RouterInfo ri = TunnelPeerSelector.this.ctx.router().getRouterInfo();
            this.ourMask = ri != null ? (isInbound ? TunnelPeerSelector.this.getInboundMask(ri) : TunnelPeerSelector.this.getOutboundMask(ri)) : 255;
        }

        @Override
        public boolean contains(Object o) {
            if (this.s.contains(o)) {
                return true;
            }
            Hash h = (Hash)o;
            if (TunnelPeerSelector.this.ctx.commSystem().isEstablished(h)) {
                return false;
            }
            RouterInfo peer = (RouterInfo)TunnelPeerSelector.this.ctx.netDb().lookupLocallyWithoutValidation(h);
            boolean canConnect = peer == null ? false : (this.isIn ? TunnelPeerSelector.this.canConnect(peer, this.ourMask) : TunnelPeerSelector.this.canConnect(this.ourMask, peer));
            if (!canConnect) {
                this.s.add(h);
            }
            return !canConnect;
        }
    }

    protected class Excluder
    extends ExcluderBase {
        private final boolean _isIn;
        private final boolean _isExpl;

        public Excluder(boolean isInbound, boolean isExploratory) {
            super(TunnelPeerSelector.this.ctx.getBooleanProperty("i2np.allowLocal") ? new HashSet() : TunnelPeerSelector.this.ctx.tunnelManager().selectPeersInTooManyTunnels());
            this._isIn = isInbound;
            this._isExpl = isExploratory;
        }

        public Excluder(boolean isInbound, boolean isExploratory, Set<Hash> toAdd) {
            super(new HashSet<Hash>(toAdd));
            this._isIn = isInbound;
            this._isExpl = isExploratory;
        }

        @Override
        public boolean contains(Object o) {
            if (this.s.contains(o)) {
                return true;
            }
            Hash h = (Hash)o;
            if (TunnelPeerSelector.this.shouldExclude(h, this._isIn, this._isExpl)) {
                this.s.add(h);
                return true;
            }
            return false;
        }
    }

    private static class HashComparator
    implements Comparator<Hash>,
    Serializable {
        private final long k0;
        private final long k1;

        private HashComparator(SessionKey k) {
            byte[] b = k.getData();
            this.k0 = DataHelper.fromLong8(b, 16);
            this.k1 = DataHelper.fromLong8(b, 24);
        }

        @Override
        public int compare(Hash l, Hash r) {
            long rh;
            long lh = SipHashInline.hash24(this.k0, this.k1, l.getData());
            if (lh > (rh = SipHashInline.hash24(this.k0, this.k1, r.getData()))) {
                return 1;
            }
            if (lh < rh) {
                return -1;
            }
            return 0;
        }
    }
}

