/*
 * Decompiled with CFR 0.152.
 */
package net.i2p;

import java.io.File;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.Set;
import net.i2p.app.ClientAppManager;
import net.i2p.app.ClientAppManagerImpl;
import net.i2p.client.naming.NamingService;
import net.i2p.crypto.AESEngine;
import net.i2p.crypto.CryptixAESEngine;
import net.i2p.crypto.DSAEngine;
import net.i2p.crypto.ElGamalEngine;
import net.i2p.crypto.HMAC256Generator;
import net.i2p.crypto.KeyGenerator;
import net.i2p.crypto.SHA256Generator;
import net.i2p.crypto.SessionKeyManager;
import net.i2p.data.Base64;
import net.i2p.data.RoutingKeyGenerator;
import net.i2p.internal.InternalClientManager;
import net.i2p.stat.StatManager;
import net.i2p.util.Clock;
import net.i2p.util.ConcurrentHashSet;
import net.i2p.util.FileUtil;
import net.i2p.util.FortunaRandomSource;
import net.i2p.util.I2PProperties;
import net.i2p.util.KeyRing;
import net.i2p.util.LogManager;
import net.i2p.util.PortMapper;
import net.i2p.util.RandomSource;
import net.i2p.util.SecureDirectory;
import net.i2p.util.SimpleScheduler;
import net.i2p.util.SimpleTimer;
import net.i2p.util.SimpleTimer2;
import net.i2p.util.SystemVersion;

public class I2PAppContext {
    protected static volatile I2PAppContext _globalAppContext;
    protected final I2PProperties _overrideProps;
    private StatManager _statManager;
    protected SessionKeyManager _sessionKeyManager;
    private NamingService _namingService;
    private ElGamalEngine _elGamalEngine;
    private AESEngine _AESEngine;
    private LogManager _logManager;
    private HMAC256Generator _hmac256;
    private SHA256Generator _sha;
    protected Clock _clock;
    private DSAEngine _dsa;
    private RandomSource _random;
    private KeyGenerator _keyGenerator;
    protected KeyRing _keyRing;
    private SimpleScheduler _simpleScheduler;
    private SimpleTimer _simpleTimer;
    private SimpleTimer2 _simpleTimer2;
    private final PortMapper _portMapper;
    private volatile boolean _statManagerInitialized;
    protected volatile boolean _sessionKeyManagerInitialized;
    private volatile boolean _namingServiceInitialized;
    private volatile boolean _elGamalEngineInitialized;
    private volatile boolean _AESEngineInitialized;
    private volatile boolean _logManagerInitialized;
    private volatile boolean _hmac256Initialized;
    private volatile boolean _shaInitialized;
    protected volatile boolean _clockInitialized;
    private volatile boolean _dsaInitialized;
    private volatile boolean _randomInitialized;
    private volatile boolean _keyGeneratorInitialized;
    protected volatile boolean _keyRingInitialized;
    private volatile boolean _simpleSchedulerInitialized;
    private volatile boolean _simpleTimerInitialized;
    private volatile boolean _simpleTimer2Initialized;
    protected final Set<Runnable> _shutdownTasks;
    private final File _baseDir;
    private final File _configDir;
    private final File _routerDir;
    private final File _pidDir;
    private final File _logDir;
    private final File _appDir;
    private volatile File _tmpDir;
    private final File _libDir;
    private final Random _tmpDirRand = new Random();
    private final ClientAppManager _appManager;
    private final Object _lock1 = new Object();
    private final Object _lock2 = new Object();
    private final Object _lock3 = new Object();
    private final Object _lock4 = new Object();
    private final Object _lock5 = new Object();
    private final Object _lock7 = new Object();
    private final Object _lock8 = new Object();
    private final Object _lock10 = new Object();
    private final Object _lock11 = new Object();
    private final Object _lock12 = new Object();
    private final Object _lock13 = new Object();
    private final Object _lock14 = new Object();
    private final Object _lock16 = new Object();
    private final Object _lock17 = new Object();
    private final Object _lock18 = new Object();
    private final Object _lock19 = new Object();
    private final Object _lock20 = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static I2PAppContext getGlobalContext() {
        I2PAppContext rv = _globalAppContext;
        if (rv != null) {
            return rv;
        }
        Class<I2PAppContext> clazz = I2PAppContext.class;
        synchronized (I2PAppContext.class) {
            if (_globalAppContext == null) {
                _globalAppContext = new I2PAppContext(false, null);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return _globalAppContext;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static boolean setGlobalContext(I2PAppContext ctx) {
        Class<I2PAppContext> clazz = I2PAppContext.class;
        synchronized (I2PAppContext.class) {
            if (_globalAppContext == null) {
                _globalAppContext = ctx;
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return true;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            System.out.println("Warning - New context not replacing old one, you now have a second one");
            new Exception("I did it").printStackTrace();
            return false;
        }
    }

    public static I2PAppContext getCurrentContext() {
        return _globalAppContext;
    }

    public I2PAppContext() {
        this(true, null);
    }

    public I2PAppContext(Properties envProps) {
        this(true, envProps);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected I2PAppContext(boolean doInit, Properties envProps) {
        Class<I2PAppContext> clazz = I2PAppContext.class;
        synchronized (I2PAppContext.class) {
            this._overrideProps = new I2PProperties();
            if (envProps != null) {
                this._overrideProps.putAll((Map<?, ?>)envProps);
            }
            this._shutdownTasks = new ConcurrentHashSet<Runnable>(32);
            this._portMapper = new PortMapper(this);
            this._appManager = this.isRouterContext() ? null : new ClientAppManagerImpl(this);
            String s = this.getProperty("i2p.dir.base", System.getProperty("user.dir"));
            this._baseDir = new File(s);
            s = this.getProperty("i2p.dir.config");
            if (s != null) {
                this._configDir = new SecureDirectory(s);
                if (!this._configDir.exists()) {
                    this._configDir.mkdir();
                }
            } else {
                this._configDir = this._baseDir;
            }
            if ((s = this.getProperty("i2p.dir.router")) != null) {
                this._routerDir = new SecureDirectory(s);
                if (!this._routerDir.exists()) {
                    this._routerDir.mkdir();
                }
            } else {
                this._routerDir = this._configDir;
            }
            if ((s = this.getProperty("i2p.dir.pid")) != null) {
                this._pidDir = new SecureDirectory(s);
                if (!this._pidDir.exists()) {
                    this._pidDir.mkdir();
                }
            } else {
                this._pidDir = this._routerDir;
            }
            if ((s = this.getProperty("i2p.dir.log")) != null) {
                this._logDir = new SecureDirectory(s);
                if (!this._logDir.exists()) {
                    this._logDir.mkdir();
                }
            } else {
                this._logDir = this._routerDir;
            }
            if ((s = this.getProperty("i2p.dir.app")) != null) {
                this._appDir = new SecureDirectory(s);
                if (!this._appDir.exists()) {
                    this._appDir.mkdir();
                }
            } else {
                this._appDir = this._routerDir;
            }
            this._libDir = (s = this.getProperty("i2p.dir.lib")) != null ? new File(s) : new File(this._baseDir, "lib");
            String isPortableStr = System.getProperty("i2p.dir.portableMode");
            boolean isPortable = Boolean.parseBoolean(isPortableStr);
            if (isPortable) {
                System.err.println("Base directory:   " + this._baseDir.getAbsolutePath());
                System.err.println("Lib directory:    " + this._libDir.getAbsolutePath());
                System.err.println("Config directory: " + this._configDir.getAbsolutePath());
                System.err.println("Router directory: " + this._routerDir.getAbsolutePath());
                System.err.println("App directory:    " + this._appDir.getAbsolutePath());
                System.err.println("Log directory:    " + this._logDir.getAbsolutePath());
                System.err.println("PID directory:    " + this._pidDir.getAbsolutePath());
                System.err.println("Temp directory:   " + this.getTempDir().getAbsolutePath());
            }
            if (doInit) {
                I2PAppContext.setGlobalContext(this);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public File getBaseDir() {
        return this._baseDir;
    }

    public File getConfigDir() {
        return this._configDir;
    }

    public File getRouterDir() {
        return this._routerDir;
    }

    public File getPIDDir() {
        return this._pidDir;
    }

    public File getLogDir() {
        return this._logDir;
    }

    public File getAppDir() {
        return this._appDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public File getTempDir() {
        Object object = this._lock1;
        synchronized (object) {
            if (this._tmpDir == null) {
                String d = this.getProperty("i2p.dir.temp", System.getProperty("java.io.tmpdir"));
                byte[] rand = new byte[6];
                this._tmpDirRand.nextBytes(rand);
                String f = "i2p-" + Base64.encode(rand) + ".tmp";
                this._tmpDir = new SecureDirectory(d, f);
                if (!this._tmpDir.exists()) {
                    if (this._tmpDir.mkdir()) {
                        this._tmpDir.deleteOnExit();
                    } else {
                        System.err.println("WARNING: Could not create temp dir " + this._tmpDir.getAbsolutePath());
                        this._tmpDir = new SecureDirectory(this._routerDir, "tmp");
                        this._tmpDir.mkdirs();
                        if (!this._tmpDir.exists()) {
                            System.err.println("ERROR: Could not create temp dir " + this._tmpDir.getAbsolutePath());
                        }
                    }
                }
            }
            return this._tmpDir;
        }
    }

    public File getLibDir() {
        return this._libDir;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteTempDir() {
        Object object = this._lock1;
        synchronized (object) {
            if (this._tmpDir != null) {
                FileUtil.rmdir(this._tmpDir, false);
                this._tmpDir = null;
            }
        }
    }

    public String getProperty(String propName) {
        String rv;
        if (this._overrideProps != null && (rv = this._overrideProps.getProperty(propName)) != null) {
            return rv;
        }
        return System.getProperty(propName);
    }

    public String getProperty(String propName, String defaultValue) {
        if (this._overrideProps != null && this._overrideProps.containsKey(propName)) {
            return this._overrideProps.getProperty(propName, defaultValue);
        }
        return System.getProperty(propName, defaultValue);
    }

    public int getProperty(String propName, int defaultVal) {
        String val = null;
        if (this._overrideProps != null && (val = this._overrideProps.getProperty(propName)) == null) {
            val = System.getProperty(propName);
        }
        int ival = defaultVal;
        if (val != null) {
            try {
                ival = Integer.parseInt(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return ival;
    }

    public long getProperty(String propName, long defaultVal) {
        String val = null;
        if (this._overrideProps != null && (val = this._overrideProps.getProperty(propName)) == null) {
            val = System.getProperty(propName);
        }
        long rv = defaultVal;
        if (val != null) {
            try {
                rv = Long.parseLong(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    public float getProperty(String propName, float defaultVal) {
        String val = null;
        if (this._overrideProps != null && (val = this._overrideProps.getProperty(propName)) == null) {
            val = System.getProperty(propName);
        }
        float rv = defaultVal;
        if (val != null) {
            try {
                rv = Float.parseFloat(val);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return rv;
    }

    public boolean getProperty(String propName, boolean defaultVal) {
        String val = this.getProperty(propName);
        if (val == null) {
            return defaultVal;
        }
        return Boolean.parseBoolean(val);
    }

    public boolean getBooleanProperty(String propName) {
        return Boolean.parseBoolean(this.getProperty(propName));
    }

    public boolean getBooleanPropertyDefaultTrue(String propName) {
        return this.getProperty(propName, true);
    }

    public Set<String> getPropertyNames() {
        HashSet<Object> names = new HashSet<Object>(((Properties)System.getProperties().clone()).keySet());
        if (this._overrideProps != null) {
            names.addAll(this._overrideProps.keySet());
        }
        return names;
    }

    public Properties getProperties() {
        Properties rv = (Properties)System.getProperties().clone();
        rv.putAll((Map<?, ?>)this._overrideProps);
        return rv;
    }

    public void addPropertyCallback(I2PProperties.I2PPropertyCallback callback) {
    }

    public StatManager statManager() {
        if (!this._statManagerInitialized) {
            this.initializeStatManager();
        }
        return this._statManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeStatManager() {
        Object object = this._lock2;
        synchronized (object) {
            if (this._statManager == null) {
                this._statManager = new StatManager(this);
            }
            this._statManagerInitialized = true;
        }
    }

    public SessionKeyManager sessionKeyManager() {
        if (!this._sessionKeyManagerInitialized) {
            this.initializeSessionKeyManager();
        }
        return this._sessionKeyManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeSessionKeyManager() {
        Object object = this._lock3;
        synchronized (object) {
            if (this._sessionKeyManager == null) {
                this._sessionKeyManager = new SessionKeyManager(this);
            }
            this._sessionKeyManagerInitialized = true;
        }
    }

    public NamingService namingService() {
        if (!this._namingServiceInitialized) {
            this.initializeNamingService();
        }
        return this._namingService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeNamingService() {
        Object object = this._lock4;
        synchronized (object) {
            if (this._namingService == null) {
                this._namingService = NamingService.createInstance(this);
            }
            this._namingServiceInitialized = true;
        }
    }

    public ElGamalEngine elGamalEngine() {
        if (!this._elGamalEngineInitialized) {
            this.initializeElGamalEngine();
        }
        return this._elGamalEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeElGamalEngine() {
        Object object = this._lock5;
        synchronized (object) {
            if (this._elGamalEngine == null) {
                this._elGamalEngine = new ElGamalEngine(this);
            }
            this._elGamalEngineInitialized = true;
        }
    }

    public AESEngine aes() {
        if (!this._AESEngineInitialized) {
            this.initializeAESEngine();
        }
        return this._AESEngine;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeAESEngine() {
        Object object = this._lock7;
        synchronized (object) {
            if (this._AESEngine == null) {
                this._AESEngine = new CryptixAESEngine(this);
            }
            this._AESEngineInitialized = true;
        }
    }

    public LogManager logManager() {
        if (!this._logManagerInitialized) {
            this.initializeLogManager();
        }
        return this._logManager;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeLogManager() {
        Object object = this._lock8;
        synchronized (object) {
            if (this._logManager == null) {
                this._logManager = new LogManager(this);
            }
            this._logManagerInitialized = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLogManager(LogManager logManager) {
        Object object = this._lock8;
        synchronized (object) {
            this._logManager = logManager;
            this._logManagerInitialized = true;
        }
    }

    public HMAC256Generator hmac256() {
        if (!this._hmac256Initialized) {
            this.initializeHMAC256();
        }
        return this._hmac256;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void initializeHMAC256() {
        Object object = this._lock10;
        synchronized (object) {
            if (this._hmac256 == null) {
                this._hmac256 = new HMAC256Generator(this);
            }
            this._hmac256Initialized = true;
        }
    }

    public SHA256Generator sha() {
        if (!this._shaInitialized) {
            this.initializeSHA();
        }
        return this._sha;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSHA() {
        Object object = this._lock11;
        synchronized (object) {
            if (this._sha == null) {
                this._sha = new SHA256Generator(this);
            }
            this._shaInitialized = true;
        }
    }

    public DSAEngine dsa() {
        if (!this._dsaInitialized) {
            this.initializeDSA();
        }
        return this._dsa;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeDSA() {
        Object object = this._lock12;
        synchronized (object) {
            if (this._dsa == null) {
                this._dsa = new DSAEngine(this);
            }
            this._dsaInitialized = true;
        }
    }

    public KeyGenerator keyGenerator() {
        if (!this._keyGeneratorInitialized) {
            this.initializeKeyGenerator();
        }
        return this._keyGenerator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeKeyGenerator() {
        Object object = this._lock13;
        synchronized (object) {
            if (this._keyGenerator == null) {
                this._keyGenerator = new KeyGenerator(this);
            }
            this._keyGeneratorInitialized = true;
        }
    }

    public Clock clock() {
        if (!this._clockInitialized) {
            this.initializeClock();
        }
        return this._clock;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeClock() {
        Object object = this._lock14;
        synchronized (object) {
            if (this._clock == null) {
                this._clock = new Clock(this);
            }
            this._clockInitialized = true;
        }
    }

    public RoutingKeyGenerator routingKeyGenerator() {
        return null;
    }

    public KeyRing keyRing() {
        if (!this._keyRingInitialized) {
            this.initializeKeyRing();
        }
        return this._keyRing;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void initializeKeyRing() {
        Object object = this._lock16;
        synchronized (object) {
            if (this._keyRing == null) {
                this._keyRing = new KeyRing();
            }
            this._keyRingInitialized = true;
        }
    }

    public RandomSource random() {
        if (!this._randomInitialized) {
            this.initializeRandom();
        }
        return this._random;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeRandom() {
        Object object = this._lock17;
        synchronized (object) {
            if (this._random == null) {
                this._random = new FortunaRandomSource(this);
            }
            this._randomInitialized = true;
        }
    }

    public void addShutdownTask(Runnable task) {
        this._shutdownTasks.add(task);
    }

    public void removeShutdownTask(Runnable task) {
        this._shutdownTasks.remove(task);
    }

    public Set<Runnable> getShutdownTasks() {
        return Collections.unmodifiableSet(this._shutdownTasks);
    }

    public boolean isRouterContext() {
        return false;
    }

    public InternalClientManager internalClientManager() {
        return null;
    }

    public boolean hasWrapper() {
        return SystemVersion.hasWrapper();
    }

    public PortMapper portMapper() {
        return this._portMapper;
    }

    @Deprecated
    public SimpleScheduler simpleScheduler() {
        if (!this._simpleSchedulerInitialized) {
            this.initializeSimpleScheduler();
        }
        return this._simpleScheduler;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void initializeSimpleScheduler() {
        Object object = this._lock18;
        synchronized (object) {
            if (this._simpleScheduler == null) {
                this._simpleScheduler = new SimpleScheduler(this);
            }
            this._simpleSchedulerInitialized = true;
        }
    }

    @Deprecated
    public SimpleTimer simpleTimer() {
        if (!this._simpleTimerInitialized) {
            this.initializeSimpleTimer();
        }
        return this._simpleTimer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Deprecated
    private void initializeSimpleTimer() {
        Object object = this._lock19;
        synchronized (object) {
            if (this._simpleTimer == null) {
                this._simpleTimer = new SimpleTimer(this);
            }
            this._simpleTimerInitialized = true;
        }
    }

    public SimpleTimer2 simpleTimer2() {
        if (!this._simpleTimer2Initialized) {
            this.initializeSimpleTimer2();
        }
        return this._simpleTimer2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeSimpleTimer2() {
        Object object = this._lock20;
        synchronized (object) {
            if (this._simpleTimer2 == null) {
                this._simpleTimer2 = new SimpleTimer2(this);
            }
            this._simpleTimer2Initialized = true;
        }
    }

    public ClientAppManager clientAppManager() {
        return this._appManager;
    }

    public long getEstimatedDowntime() {
        return 0L;
    }
}

