/*
 * Decompiled with CFR 0.152.
 */
package net.i2p.client.streaming.impl;

import java.util.ArrayList;
import java.util.List;
import net.i2p.I2PAppContext;
import net.i2p.client.streaming.impl.Connection;
import net.i2p.client.streaming.impl.SchedulerClosed;
import net.i2p.client.streaming.impl.SchedulerClosing;
import net.i2p.client.streaming.impl.SchedulerConnectedBulk;
import net.i2p.client.streaming.impl.SchedulerConnecting;
import net.i2p.client.streaming.impl.SchedulerDead;
import net.i2p.client.streaming.impl.SchedulerHardDisconnected;
import net.i2p.client.streaming.impl.SchedulerPreconnect;
import net.i2p.client.streaming.impl.SchedulerReceived;
import net.i2p.client.streaming.impl.TaskScheduler;
import net.i2p.util.Log;

class SchedulerChooser {
    private final I2PAppContext _context;
    private final Log _log;
    private final TaskScheduler _nullScheduler;
    private final List<TaskScheduler> _schedulers;

    public SchedulerChooser(I2PAppContext context) {
        this._context = context;
        this._log = context.logManager().getLog(SchedulerChooser.class);
        this._schedulers = this.createSchedulers();
        this._nullScheduler = new NullScheduler();
    }

    public TaskScheduler getScheduler(Connection con) {
        for (int i = 0; i < this._schedulers.size(); ++i) {
            TaskScheduler scheduler = this._schedulers.get(i);
            if (!scheduler.accept(con)) continue;
            return scheduler;
        }
        return this._nullScheduler;
    }

    private List<TaskScheduler> createSchedulers() {
        ArrayList<TaskScheduler> rv = new ArrayList<TaskScheduler>(8);
        rv.add(new SchedulerHardDisconnected(this._context));
        rv.add(new SchedulerPreconnect(this._context));
        rv.add(new SchedulerConnecting(this._context));
        rv.add(new SchedulerReceived(this._context));
        rv.add(new SchedulerConnectedBulk(this._context));
        rv.add(new SchedulerClosing(this._context));
        rv.add(new SchedulerClosed(this._context));
        rv.add(new SchedulerDead(this._context));
        return rv;
    }

    private class NullScheduler
    implements TaskScheduler {
        private NullScheduler() {
        }

        @Override
        public void eventOccurred(Connection con) {
            if (SchedulerChooser.this._log.shouldInfo()) {
                SchedulerChooser.this._log.info("Yell at jrandom: Event occurred on " + con, new Exception("source"));
            }
        }

        @Override
        public boolean accept(Connection con) {
            return true;
        }
    }
}

